"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontToMediaStore = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-cdk/core");
class CloudFrontToMediaStore extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of CloudFrontToMediaStore class.
     * @since 1.76.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        let cloudFrontDistributionProps = props.cloudFrontDistributionProps;
        if (props.existingMediaStoreContainerObj) {
            this.mediaStoreContainer = props.existingMediaStoreContainerObj;
        }
        else {
            let mediaStoreProps;
            if (props.mediaStoreContainerProps) {
                mediaStoreProps = props.mediaStoreContainerProps;
            }
            else {
                this.cloudFrontOriginAccessIdentity = defaults.CloudFrontOriginAccessIdentity(this);
                mediaStoreProps = {
                    containerName: core_1.Aws.STACK_NAME,
                    policy: JSON.stringify({
                        Version: '2012-10-17',
                        Statement: [{
                                Sid: 'MediaStoreDefaultPolicy',
                                Effect: 'Allow',
                                Principal: '*',
                                Action: [
                                    'mediastore:GetObject',
                                    'mediastore:DescribeObject'
                                ],
                                Resource: `arn:${core_1.Aws.PARTITION}:mediastore:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:container/${core_1.Aws.STACK_NAME}/*`,
                                Condition: {
                                    Bool: {
                                        'aws:UserAgent': this.cloudFrontOriginAccessIdentity.originAccessIdentityName,
                                        'aws:SecureTransport': 'true'
                                    }
                                }
                            }]
                    })
                };
                const userAgentHeader = {
                    'User-Agent': this.cloudFrontOriginAccessIdentity.originAccessIdentityName
                };
                if (cloudFrontDistributionProps) {
                    cloudFrontDistributionProps.customHeaders = userAgentHeader;
                }
                else {
                    cloudFrontDistributionProps = {
                        customHeaders: userAgentHeader
                    };
                }
            }
            this.mediaStoreContainer = defaults.MediaStoreContainer(this, mediaStoreProps);
        }
        [this.cloudFrontWebDistribution, this.cloudFrontLoggingBucket, this.cloudFrontOriginRequestPolicy, this.edgeLambdaFunctionVersion]
            = defaults.CloudFrontDistributionForMediaStore(this, this.mediaStoreContainer, cloudFrontDistributionProps, props.insertHttpSecurityHeaders);
    }
}
exports.CloudFrontToMediaStore = CloudFrontToMediaStore;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontToMediaStore[_a] = { fqn: "@aws-solutions-constructs/aws-cloudfront-mediastore.CloudFrontToMediaStore", version: "1.86.0" };
//# sourceMappingURL=data:application/json;base64,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