# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['onepasswordconnectsdk', 'onepasswordconnectsdk.models']

package_data = \
{'': ['*']}

install_requires = \
['python-dateutil>=2.8.1,<3.0.0', 'requests>=2.24.0,<3.0.0', 'six>=1.10,<2.0']

setup_kwargs = {
    'name': 'onepasswordconnectsdk',
    'version': '1.0.1',
    'description': 'Python SDK for 1Password Connect',
    'long_description': '# 1Password Connect Python SDK\n\nThe 1Password Connect SDK provides access to the 1Password via 1Password Connect hosted on your infrastructure. The library is intended to be used by Python applications to simplify accessing `items` in 1Password `vaults`.\n\n## Prerequisites\n\n- 1Password Connect deployed in your infrastructure.\n## Installation\n\nTo install the 1Password Connect Python SDK use the following command:\n```bash\n$ pip install onepasswordconnectsdk\n```\n\nTo install a specific release of the 1Password Connect Python SDK use the following command:\n```bash\n$ pip install onepasswordconnectsdk==1.0.1\n```\n\n## Usage\n\n**Import 1Password Connect Python SDK**\n\n```python\nimport onepasswordconnectsdk\n```\n\n**Environment Variables**\n\n- **OP_CONNECT_TOKEN** – The token to be used to authenticate with the 1Password Connect API.\n- **OP_VAULT** - The default vault to fetch items from if not specified.\n\n**Creating a Client**\n\nThere are two methods available for creating a client:\n\n- `new_client_from_environment`: Builds a new client for interacting with 1Password Connect using the `OP_CONNECT_TOKEN` *environment variable (ie a 1Password Connect API token)* and the hostname of 1Password Connect.\n- `new_client`: Builds a new client for interacting with 1Password Connect. Accepts the hostname of 1Password Connect and the API token generated for the application.\n\n```python\nfrom onepasswordconnectsdk.client import (\n    Client,\n    new_client_from_environment,\n    new_client\n)\n\n# creating client using OP_CONNECT_TOKEN environment variable\nclient: Client = new_client_from_environment(\n     "{1Password_Connect_Host}")\n\n# creating client by supplying hostname and 1Password Connect API token\nclient: Client = new_client(\n    "{1Password_Connect_Host}",\n    "{1Password_Connect_API_Token}")\n```\n\n**Get Item**\n\nGet a specific item by item and vault uuids:\n\n```python\nclient.get_item("{item_id}", "{vault_id}")\n```\n\n**Get Item By Title**\n\nGet item by item title and vault id\n\n```python\nclient.get_item_by_title("{item_title}", "{vault_id}")\n```\n\n**Get Items**\n\nGet a summarized list of all items for a specified vault\n\n```python\nclient.get_items("{vault_id}")\n```\n\n**Delete Item**\n\nDelete an item by item and vault ids:\n\n```python\nclient.delete_item("{item_id}", "{vault_id}")\n```\n\n**Create Item**\n\nCreate an item in the specified vault.\n\n```python\n# Example item creation. Create an item with your desired arguments. \nitem = onepasswordconnectsdk.models.Item(vault=ItemVault(id="av223f76ydutdngislnkbz6z5u"),\n                                      id="kp2td65r4wbuhocwhhijpdbfqq",\n                                      title="newtitle",\n                                      category="LOGIN",\n                                      tags=["1password-connect"],\n                                      fields=[Field(value="new_user",\n                                                                  purpose="USERNAME")],\n                                      )\nclient.create_item("{vault_id}", item)\n```\n\n**Update Item**\n\nItem the item with the specified item and vault ids. The existing item will be overwritten with the newly supplied item.\n\n```python\n# Example item creation. Create an item with your desired arguments. \nitem = onepasswordconnectsdk.models.Item(vault=ItemVault(id="av223f76ydutdngislnkbz6z5u"),\n                                      id="kp2td65r4wbuhocwhhijpdbfqq",\n                                      title="newtitle",\n                                      category="LOGIN",\n                                      tags=["1password-connect"],\n                                      fields=[Field(value="new_user",\n                                                                  purpose="USERNAME")],\n                                      )\nclient.update_item("{item_id}", "{vault_id}", item)\n```\n\n**Get Vault**\n\nGet vault by vault id\n\n```python\nclient.get_vault("{vault_id}")\n```\n\n**Get Vaults**\n\nRetrieve all vaults available to the service account.\n\n```python\nclient.get_vaults()\n```\n\n**Load Configuration**\n\nUsers can create `classes` or `dicts` that describe fields they wish to get the values from in 1Password. Two convienience methods are provided that will handle the fetching of values for these fields:\n\n- **load_dict**: Takes a dictionary with keys specifying the user desired naming scheme of the values to return. Each key\'s value is a dictionary that includes information on where to find the item field value in 1Password. This returns a dictionary of user specified keys with values retrieved from 1Password\n- **load**: Takes an object with class attributes annotated with tags describing where to find desired fields in 1Password. Manipulates given object and fills attributes in with 1Password item field values.\n\n```python\n# example dict configuration for onepasswordconnectsdk.load_dict(CONFIG)\nCONFIG = {\n    "server": {\n        "opitem": "My database item",\n        "opfield": "specific_section.hostname",\n        "opvault": "some_vault_id",\n    },\n    "database": {\n        "opitem": "My database item",\n        "opfield": ".database",\n    },\n    "username": {\n        "opitem": "My database item",\n        "opfield": ".username",\n    },\n    "password": {\n        "opitem": "My database item",\n        "opfield": ".password",\n    },\n}\n\nvalues_dict = onepasswordconnectsdk.load_dict(CONFIG)\n```\n\n```python\n# example class configuration for onepasswordconnectsdk.load(CONFIG)\nclass Config:\n    server: \'opitem:"My database item" opvault:some_vault_id opfield:specific_section.hostname\' = None\n    database: \'opitem:"My database item" opfield:.database\' = None\n    username: \'opitem:"My database item" opfield:.username\' = None\n    password: \'opitem:"My database item" opfield:.password\' = None\n\nCONFIG = Config()\n\nvalues_object = onepasswordconnectsdk.load(CONFIG)\n```\n\n## Development\n\n**Testing**\n\n```bash\nmake test\n```\n\n## Security\n\n1Password requests you practice responsible disclosure if you discover a vulnerability. \n\nPlease file requests via [**BugCrowd**](https://bugcrowd.com/agilebits). \n\nFor information about security practices, please visit our [Security homepage](https://bugcrowd.com/agilebits).\n',
    'author': '1Password',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/1Password/connect-sdk-python',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
