# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
import fnmatch
sys.path.insert(0, os.path.abspath(".."))


# -- Project information -----------------------------------------------------
# auto-discover the version file
metadata = dict()
exclude = [".git", ".tox", "data", "docs", "build", "html"]
for root, dirnames, filenames in os.walk('..', topdown=True):
    dirnames[:] = [d for d in dirnames if d not in exclude]
    for filename in fnmatch.filter(filenames, '_version.py'):
        with open(os.path.join(root, filename)) as file_h:
            exec(file_h.read(), metadata)

project = metadata["__project__"]
copyright = metadata["__copyright__"]
author = metadata["__author__"]
package = metadata["__package__"]

# The full version, including alpha/beta/rc tags
release = metadata["__version__"]


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named "sphinx.ext.*") or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.napoleon"
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store"]


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "sphinx_rtd_theme"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = [f"../htmlcov"]
master_doc = "index"

