"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _HashFunction:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _HashFunctionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_HashFunction.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWN_HASH_FUNCTION: _HashFunction.ValueType  # 0
    """Never use this in any TUF metadata."""

    SHA256: _HashFunction.ValueType  # 1
class HashFunction(_HashFunction, metaclass=_HashFunctionEnumTypeWrapper):
    pass

UNKNOWN_HASH_FUNCTION: HashFunction.ValueType  # 0
"""Never use this in any TUF metadata."""

SHA256: HashFunction.ValueType  # 1
global___HashFunction = HashFunction


class _KeyType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _KeyTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_KeyType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWN_KEY_TYPE: _KeyType.ValueType  # 0
    """Never use this in any TUF metadata."""

    RSA: _KeyType.ValueType  # 1
    ED25519: _KeyType.ValueType  # 2
    ECDSA_SHA2_NISTP256: _KeyType.ValueType  # 3
class KeyType(_KeyType, metaclass=_KeyTypeEnumTypeWrapper):
    pass

UNKNOWN_KEY_TYPE: KeyType.ValueType  # 0
"""Never use this in any TUF metadata."""

RSA: KeyType.ValueType  # 1
ED25519: KeyType.ValueType  # 2
ECDSA_SHA2_NISTP256: KeyType.ValueType  # 3
global___KeyType = KeyType


class _KeyScheme:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _KeySchemeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_KeyScheme.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWN_KEY_SCHEME: _KeyScheme.ValueType  # 0
    """Never use this in any TUF metadata."""

    RSASSA_PSS_SHA256_SCHEME: _KeyScheme.ValueType  # 1
    """RSA Probabilistic signature scheme with appendix.
    The underlying hash function is SHA256.
    In TUF Specification, this is referred to as "rsassa-pss-sha256".
    """

    ED25519_SCHEME: _KeyScheme.ValueType  # 2
    """Elliptic Curve digital signature algorithm based on Twisted Edwards curves.
    See https://ed25519.cr.yp.to/.
    In TUF Specification, it is referred to as "ed25519".
    """

    ECDSA_SHA2_NISTP256_SCHEME: _KeyScheme.ValueType  # 3
    """Elliptic Curve Digital Signature Algorithm with NIST P-256 curve signing
    and SHA-256 hashing. See
    https://en.wikipedia.org/wiki/Elliptic_Curve_Digital_Signature_Algorithm In
    TUF Specification, it is referred to as "ecdsa-sha2-nistp256".
    """

class KeyScheme(_KeyScheme, metaclass=_KeySchemeEnumTypeWrapper):
    pass

UNKNOWN_KEY_SCHEME: KeyScheme.ValueType  # 0
"""Never use this in any TUF metadata."""

RSASSA_PSS_SHA256_SCHEME: KeyScheme.ValueType  # 1
"""RSA Probabilistic signature scheme with appendix.
The underlying hash function is SHA256.
In TUF Specification, this is referred to as "rsassa-pss-sha256".
"""

ED25519_SCHEME: KeyScheme.ValueType  # 2
"""Elliptic Curve digital signature algorithm based on Twisted Edwards curves.
See https://ed25519.cr.yp.to/.
In TUF Specification, it is referred to as "ed25519".
"""

ECDSA_SHA2_NISTP256_SCHEME: KeyScheme.ValueType  # 3
"""Elliptic Curve Digital Signature Algorithm with NIST P-256 curve signing
and SHA-256 hashing. See
https://en.wikipedia.org/wiki/Elliptic_Curve_Digital_Signature_Algorithm In
TUF Specification, it is referred to as "ecdsa-sha2-nistp256".
"""

global___KeyScheme = KeyScheme


class SignedRootMetadata(google.protobuf.message.Message):
    """Metadata for a particular TUF role (e.g. targets metadata).
    Was TufMetadata
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SERIALIZED_ROOT_METADATA_FIELD_NUMBER: builtins.int
    SIGNATURES_FIELD_NUMBER: builtins.int
    serialized_root_metadata: builtins.bytes
    """Serialized RootMetadata message that is the data portion of the metadata."""

    @property
    def signatures(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Signature]:
        """Signature of the canonical form of the role's serialized metadata
        (serialized_root_metadata).
        """
        pass
    def __init__(self,
        *,
        serialized_root_metadata: builtins.bytes = ...,
        signatures: typing.Optional[typing.Iterable[global___Signature]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["serialized_root_metadata",b"serialized_root_metadata","signatures",b"signatures"]) -> None: ...
global___SignedRootMetadata = SignedRootMetadata

class SignedTimestampMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SERIALIZED_TIMESTAMP_METADATA_FIELD_NUMBER: builtins.int
    SIGNATURES_FIELD_NUMBER: builtins.int
    serialized_timestamp_metadata: builtins.bytes
    """Serialized TimestampMetadata message that is the data portion of the
    metadata.
    """

    @property
    def signatures(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Signature]:
        """Signature of the canonical form of the role's serialized metadata
        (serialized_timestamp_metadata).
        """
        pass
    def __init__(self,
        *,
        serialized_timestamp_metadata: builtins.bytes = ...,
        signatures: typing.Optional[typing.Iterable[global___Signature]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["serialized_timestamp_metadata",b"serialized_timestamp_metadata","signatures",b"signatures"]) -> None: ...
global___SignedTimestampMetadata = SignedTimestampMetadata

class SignedSnapshotMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SERIALIZED_SNAPSHOT_METADATA_FIELD_NUMBER: builtins.int
    SIGNATURES_FIELD_NUMBER: builtins.int
    serialized_snapshot_metadata: builtins.bytes
    """Serialized SnapshotMetadata message that is the data portion of the
    metadata.
    """

    @property
    def signatures(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Signature]:
        """Signature of the canonical form of the role's serialized metadata
        (serialized_snapshot_metadata).
        """
        pass
    def __init__(self,
        *,
        serialized_snapshot_metadata: builtins.bytes = ...,
        signatures: typing.Optional[typing.Iterable[global___Signature]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["serialized_snapshot_metadata",b"serialized_snapshot_metadata","signatures",b"signatures"]) -> None: ...
global___SignedSnapshotMetadata = SignedSnapshotMetadata

class SignedTargetsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SERIALIZED_TARGETS_METADATA_FIELD_NUMBER: builtins.int
    SIGNATURES_FIELD_NUMBER: builtins.int
    serialized_targets_metadata: builtins.bytes
    """Serialized TargetsMetadata message that is the data portion of the
    metadata.
    """

    @property
    def signatures(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Signature]:
        """Signature of the canonical form of the role's serialized metadata
        (serialized_targets_metadata).
        """
        pass
    def __init__(self,
        *,
        serialized_targets_metadata: builtins.bytes = ...,
        signatures: typing.Optional[typing.Iterable[global___Signature]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["serialized_targets_metadata",b"serialized_targets_metadata","signatures",b"signatures"]) -> None: ...
global___SignedTargetsMetadata = SignedTargetsMetadata

class CommonMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SPEC_VERSION_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    EXPIRES_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    spec_version: typing.Text
    """Version number of the TUF Specification.
    Follows the Semantic Versioning 2.0.0 (semver) format. Metadata is
    written according to this version, and clients MUST verify that
    "spec_version" matches the expected version number.
    E.g. "1.0.0".
    """

    version: builtins.int
    """Metadata file version.
    Clients MUST NOT replace a metadata file with a version number less than
    the one currently trusted.
    """

    @property
    def expires(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Expiration time for the metadata.
        Indicates when this metadata should be considered expired and no longer
        trusted by clients. Notice the TUF Specification defines this as a JSON
        string following the ISO 8601 standard. The expected format of the date and
        time string is "YYYY-MM-DDTHH:MM:SSZ". Time is always in UTC, and the "Z"
        time zone designator is attached to indicate a zero UTC offset.
        E.g. "2030-08-26T16:48:27Z".
        """
        pass
    role: typing.Text
    """Role type for the metadata.
    Indicates the type of the metadata. Valid values are 'root', 'targets',
    'snapshot' and 'timestamp' as defined in the TUF spec, though we don't
    plan to support 'mirrors'.

    This field serves as a "magic code" that identifies a particular type of
    a metadata. During verification, the client is expected to check this
    field against the expected role type immediately after verifying the
    signatures of a metadata. This can be considered a "confidence booster"
    in the absence of canonical protobuf -- i.e. it makes the various
    `serialized_x_metadata` fields more tamper resistant.
    """

    def __init__(self,
        *,
        spec_version: typing.Text = ...,
        version: builtins.int = ...,
        expires: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        role: typing.Optional[typing.Text] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_expires",b"_expires","_role",b"_role","expires",b"expires","role",b"role"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_expires",b"_expires","_role",b"_role","expires",b"expires","role",b"role","spec_version",b"spec_version","version",b"version"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_expires",b"_expires"]) -> typing.Optional[typing_extensions.Literal["expires"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_role",b"_role"]) -> typing.Optional[typing_extensions.Literal["role"]]: ...
global___CommonMetadata = CommonMetadata

class RootMetadata(google.protobuf.message.Message):
    """This content is signed."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COMMON_METADATA_FIELD_NUMBER: builtins.int
    CONSISTENT_SNAPSHOT_FIELD_NUMBER: builtins.int
    KEYS_FIELD_NUMBER: builtins.int
    ROOT_SIGNATURE_REQUIREMENT_FIELD_NUMBER: builtins.int
    TIMESTAMP_SIGNATURE_REQUIREMENT_FIELD_NUMBER: builtins.int
    SNAPSHOT_SIGNATURE_REQUIREMENT_FIELD_NUMBER: builtins.int
    TARGETS_SIGNATURE_REQUIREMENT_FIELD_NUMBER: builtins.int
    @property
    def common_metadata(self) -> global___CommonMetadata: ...
    consistent_snapshot: builtins.bool
    """Whether the repo supports consistent snapshots. If the repo has frequent
    updates, you should set this to true.
    """

    @property
    def keys(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___KeyMapping]:
        """Map from Keyid to Key.
        Keyid is a unique identifier that identifies a cryptographic key.
        Contains all of cryptographic keys used by this repository.
        """
        pass
    @property
    def root_signature_requirement(self) -> global___SignatureRequirement:
        """KeyConfig is the list of keys use for a particular role and the threshold.
        Threshold is number of keys of that role whose signatures are required in
        order to consider a file as being properly signed by that role.
        """
        pass
    @property
    def timestamp_signature_requirement(self) -> global___SignatureRequirement: ...
    @property
    def snapshot_signature_requirement(self) -> global___SignatureRequirement: ...
    @property
    def targets_signature_requirement(self) -> global___SignatureRequirement: ...
    def __init__(self,
        *,
        common_metadata: typing.Optional[global___CommonMetadata] = ...,
        consistent_snapshot: builtins.bool = ...,
        keys: typing.Optional[typing.Iterable[global___KeyMapping]] = ...,
        root_signature_requirement: typing.Optional[global___SignatureRequirement] = ...,
        timestamp_signature_requirement: typing.Optional[global___SignatureRequirement] = ...,
        snapshot_signature_requirement: typing.Optional[global___SignatureRequirement] = ...,
        targets_signature_requirement: typing.Optional[global___SignatureRequirement] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["common_metadata",b"common_metadata","root_signature_requirement",b"root_signature_requirement","snapshot_signature_requirement",b"snapshot_signature_requirement","targets_signature_requirement",b"targets_signature_requirement","timestamp_signature_requirement",b"timestamp_signature_requirement"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["common_metadata",b"common_metadata","consistent_snapshot",b"consistent_snapshot","keys",b"keys","root_signature_requirement",b"root_signature_requirement","snapshot_signature_requirement",b"snapshot_signature_requirement","targets_signature_requirement",b"targets_signature_requirement","timestamp_signature_requirement",b"timestamp_signature_requirement"]) -> None: ...
global___RootMetadata = RootMetadata

class TimestampMetadata(google.protobuf.message.Message):
    """The timestamp role is used for freshness check of the snapshot. Any
    project-specific update metadata should go in the top-level targets_metadata
    or with the TargetFile information
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COMMON_METADATA_FIELD_NUMBER: builtins.int
    SNAPSHOT_METADATA_FIELD_NUMBER: builtins.int
    @property
    def common_metadata(self) -> global___CommonMetadata: ...
    @property
    def snapshot_metadata(self) -> global___MetadataFile:
        """Only one snapshot_metadata is used per timestamp."""
        pass
    def __init__(self,
        *,
        common_metadata: typing.Optional[global___CommonMetadata] = ...,
        snapshot_metadata: typing.Optional[global___MetadataFile] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["common_metadata",b"common_metadata","snapshot_metadata",b"snapshot_metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["common_metadata",b"common_metadata","snapshot_metadata",b"snapshot_metadata"]) -> None: ...
global___TimestampMetadata = TimestampMetadata

class SnapshotMetadata(google.protobuf.message.Message):
    """The snapshot role is used to ensure that the collection of targets_metadata
    files is securely consistent (no target metadata mix and match). Any
    project-specific update metadata should go in the top-level targets_metadata
    or with the TargetFile information
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COMMON_METADATA_FIELD_NUMBER: builtins.int
    TARGETS_METADATA_FIELD_NUMBER: builtins.int
    @property
    def common_metadata(self) -> global___CommonMetadata: ...
    @property
    def targets_metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MetadataFile]:
        """Map from Target metadata file name to MetadataFile.
        File name can be an arbitrary name or a full file name with relative path.
        This map should contain an entry for the top level targets role and all
        delegated roles.
        """
        pass
    def __init__(self,
        *,
        common_metadata: typing.Optional[global___CommonMetadata] = ...,
        targets_metadata: typing.Optional[typing.Iterable[global___MetadataFile]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["common_metadata",b"common_metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["common_metadata",b"common_metadata","targets_metadata",b"targets_metadata"]) -> None: ...
global___SnapshotMetadata = SnapshotMetadata

class TargetsMetadata(google.protobuf.message.Message):
    """The targets role describes the target files that comprise the software
    update. Targets metadata is organized in to a top-level targets metadata file
    and optional multiple deligated targets metadata files

    The top-level targets metatdata is the correct place to put any
    project-specific build version information, including build ID, hardware rev,
    etc.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    COMMON_METADATA_FIELD_NUMBER: builtins.int
    TARGET_FILES_FIELD_NUMBER: builtins.int
    @property
    def common_metadata(self) -> global___CommonMetadata: ...
    @property
    def target_files(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TargetFile]:
        """Collection of target file information
        Target file name can be an arbitrary name or a path that describes where
        the file lives relative to the base directory of the repository, e.g.
        "path/to/amber_tools/0".
        """
        pass
    def __init__(self,
        *,
        common_metadata: typing.Optional[global___CommonMetadata] = ...,
        target_files: typing.Optional[typing.Iterable[global___TargetFile]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["common_metadata",b"common_metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["common_metadata",b"common_metadata","target_files",b"target_files"]) -> None: ...
global___TargetsMetadata = TargetsMetadata

class Signature(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    KEY_ID_FIELD_NUMBER: builtins.int
    SIG_FIELD_NUMBER: builtins.int
    key_id: builtins.bytes
    """Identifier of the key, which is bytes of the SHA-256 hash of the
    canonical form of the key.
    """

    sig: builtins.bytes
    """The signature of the canonical form of the role's serialized metadata
    (serialized_{root,timestamp,snapshot,targets}_metadata).
    """

    def __init__(self,
        *,
        key_id: builtins.bytes = ...,
        sig: builtins.bytes = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["key_id",b"key_id","sig",b"sig"]) -> None: ...
global___Signature = Signature

class KeyMapping(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    KEY_ID_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    key_id: builtins.bytes
    """Identifier of the key, which is bytes of the SHA-256 hash of the
    canonical form of the key.
    """

    @property
    def key(self) -> global___Key:
        """Cryptographic key"""
        pass
    def __init__(self,
        *,
        key_id: builtins.bytes = ...,
        key: typing.Optional[global___Key] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["key",b"key"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["key",b"key","key_id",b"key_id"]) -> None: ...
global___KeyMapping = KeyMapping

class Key(google.protobuf.message.Message):
    """Identifies an asymmetric cryptographic key."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    KEY_TYPE_FIELD_NUMBER: builtins.int
    SCHEME_FIELD_NUMBER: builtins.int
    KEYVAL_FIELD_NUMBER: builtins.int
    key_type: global___KeyType.ValueType
    """Denotes a public key signature system, such as RSA or ECDSA."""

    scheme: global___KeyScheme.ValueType
    """Denotes the signature scheme corresponding to the key type. For example:
    "rsassa-pss-sha256" or "ecdsa-sha2-nistp256".
    """

    keyval: builtins.bytes
    """Stores the serialized public key for this cryptographic algorithm."""

    def __init__(self,
        *,
        key_type: global___KeyType.ValueType = ...,
        scheme: global___KeyScheme.ValueType = ...,
        keyval: builtins.bytes = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["key_type",b"key_type","keyval",b"keyval","scheme",b"scheme"]) -> None: ...
global___Key = Key

class SignatureRequirement(google.protobuf.message.Message):
    """The set of cryptographic keys used by a specific role. For example, list of
    key_ids used by the top level role "root".
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    KEY_IDS_FIELD_NUMBER: builtins.int
    THRESHOLD_FIELD_NUMBER: builtins.int
    @property
    def key_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bytes]:
        """Set of Keyid's.
        Keyid is a unique identifier that identifies a cryptographic key.
        E.g. "f2d5020d08aea06a0a9192eb6a4f549e17032ebefa1aa9ac167c1e3e727930d6".
        """
        pass
    threshold: builtins.int
    """Threshold of signatures required to trust given file.
    In other words; the number of keys of that role whose signatures are
    required in order to consider a file as being properly signed by that role.
    """

    def __init__(self,
        *,
        key_ids: typing.Optional[typing.Iterable[builtins.bytes]] = ...,
        threshold: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["key_ids",b"key_ids","threshold",b"threshold"]) -> None: ...
global___SignatureRequirement = SignatureRequirement

class Hash(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FUNCTION_FIELD_NUMBER: builtins.int
    HASH_FIELD_NUMBER: builtins.int
    function: global___HashFunction.ValueType
    hash: builtins.bytes
    """Digest of the cryptographic hash function computed on the target file."""

    def __init__(self,
        *,
        function: global___HashFunction.ValueType = ...,
        hash: builtins.bytes = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["function",b"function","hash",b"hash"]) -> None: ...
global___Hash = Hash

class TargetFile(google.protobuf.message.Message):
    """Descriptor for a file stored in this repository. Linked to from target
    metadata.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FILE_NAME_FIELD_NUMBER: builtins.int
    LENGTH_FIELD_NUMBER: builtins.int
    HASHES_FIELD_NUMBER: builtins.int
    file_name: typing.Text
    """Target file name can be an arbitrary name or a path that describes where
    the file lives relative to the base directory of the repository, e.g.
    "path/to/amber_tools/0".
    """

    length: builtins.int
    """Size of the target file (element payload) in bytes. This the size as stored
    in the bundle. The final applied size can be different due to optional
    compression.
    """

    @property
    def hashes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Hash]:
        """Map from algorithm name to Hash.
        Algorithm name is the name of a cryptographic hash function. E.g. "sha256".
        The Hash string is the hex digest of the cryptographic function computed on
        the target file. E.g.
        "65b8c67f51c993d898250f40aa57a317d854900b3a04895464313e48785440da".
        """
        pass
    def __init__(self,
        *,
        file_name: typing.Text = ...,
        length: builtins.int = ...,
        hashes: typing.Optional[typing.Iterable[global___Hash]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["file_name",b"file_name","hashes",b"hashes","length",b"length"]) -> None: ...
global___TargetFile = TargetFile

class MetadataFile(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FILE_NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    LENGTH_FIELD_NUMBER: builtins.int
    HASHES_FIELD_NUMBER: builtins.int
    file_name: typing.Text
    """Target file name can be an arbitrary name or a path that describes where
    the file lives relative to the base directory of the repository, e.g.
    "path/to/target/0".
    """

    version: builtins.int
    """Metadata file version. E.g. 3."""

    length: builtins.int
    """Size of the target file in bytes."""

    @property
    def hashes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Hash]:
        """Map from algorithm name to Hash.
        Algorithm name is the name of a cryptographic hash function. E.g. "sha256".
        The Hash is the hex digest of the cryptographic function computed on the
        target file. E.g.
        "65b8c67f51c993d898250f40aa57a317d854900b3a04895464313e48785440da".
        """
        pass
    def __init__(self,
        *,
        file_name: typing.Optional[typing.Text] = ...,
        version: builtins.int = ...,
        length: typing.Optional[builtins.int] = ...,
        hashes: typing.Optional[typing.Iterable[global___Hash]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_file_name",b"_file_name","_length",b"_length","file_name",b"file_name","length",b"length"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_file_name",b"_file_name","_length",b"_length","file_name",b"file_name","hashes",b"hashes","length",b"length","version",b"version"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_file_name",b"_file_name"]) -> typing.Optional[typing_extensions.Literal["file_name"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_length",b"_length"]) -> typing.Optional[typing_extensions.Literal["length"]]: ...
global___MetadataFile = MetadataFile
