"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class LogEntry(google.protobuf.message.Message):
    """A log message and metadata. Logs come in a few different forms:

     1. A tokenized log message (recommended for production)
     2. A non-tokenized log message (good for development)
     3. A "log missed" tombstone, indicating that some logs were dropped

    Size analysis for tokenized log messages, including each field's proto tag:

     - message     - 6-12 bytes; depending on number and value of arguments
     - line_level  - 3 bytes; 4 bytes if line > 2048 (uncommon)
     - timestamp   - 3 bytes; assuming delta encoding
     - thread      - 2-6 bytes; depending on whether value is a token or string

    Adding the fields gives the total proto message size:

       6-12 bytes - log
       9-15 bytes - log + level + line
      12-18 bytes - log + level + line + timestamp

    An analysis of a project's log token database revealed the following
    distribution of the number of arguments to log messages:

      # args   # messages
        0         2,700
        1         2,400
        2         1,200
        3+        1,000

    Note: The below proto makes some compromises compared to what one might
    expect for a "clean" proto design, in order to shave bytes off of the
    messages. It is critical that the log messages are as small as possible to
    enable storing more logs in limited memory. This is why, for example, there
    is no separate "DroppedLog" type, or a "TokenizedLog" and "StringLog", which
    would add at least 2 extra bytes per message
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    MESSAGE_FIELD_NUMBER: builtins.int
    LINE_LEVEL_FIELD_NUMBER: builtins.int
    FLAGS_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    TIME_SINCE_LAST_ENTRY_FIELD_NUMBER: builtins.int
    DROPPED_FIELD_NUMBER: builtins.int
    MODULE_FIELD_NUMBER: builtins.int
    FILE_FIELD_NUMBER: builtins.int
    THREAD_FIELD_NUMBER: builtins.int
    message: builtins.bytes
    """The log message, which may be tokenized.

    If tokenized logging is used, implementations may encode metadata in the
    log message rather than as separate proto fields. This reduces the size of
    the protobuf with no overhead.

    The standard format for encoding metadata in the log message is defined by
    the pw_log_tokenized module. The message and metadata are encoded as
    key-value pairs using ■ and ♦ as delimiters. For example:

     ■msg♦This is the log message: %d■module♦wifi■file♦../path/to/file.cc

    See http://pigweed.dev/pw_log_tokenized for full details. When
    pw_log_tokenized is used, this metadata is automatically included as
    described.

    The level and flags are not included since they may be runtime values and
    thus cannot always be tokenized. The line number is not included because
    line numbers change frequently and a new token is created for each line.

    Size analysis when tokenized:

      tag+wire = 1 byte
      size     = 1 byte; payload will almost always be < 127 bytes
      payload  = N bytes; typically 4-10 in practice

    Total: 2 + N ~= 6-12 bytes
    """

    line_level: builtins.int
    """Packed log level and line number. Structure:

      Level: Bottom 3 bits; level = line_level & 0x7
      Line: Remaining bits; line = (line_level >> 3)

    Note: This packing saves two bytes per log message in most cases compared
    to having line and level separately; and is zero-cost if the log backend
    omits the line number.
    """

    flags: builtins.int
    """Some log messages have flags to indicate attributes such as whether they
    are from an assert or if they contain PII. The particular flags are
    product- and implementation-dependent.
    """

    timestamp: builtins.int
    """The absolute timestamp in implementation-defined ticks. Applications
    determine how to interpret this on the receiving end. In the simplest
    case, these ticks might be milliseconds or microseconds since boot.
    Applications could also access clock information out-of-band with a
    ClockParameters protobuf.
    """

    time_since_last_entry: builtins.int
    """Time since the last entry in implementation-defined ticks, as for the
    timestamp field. This enables delta encoding when batching entries
    together.

    Size analysis for this field including tag and varint, assuming 1 kHz
    ticks:

              < 127 ms gap == 127 ms      ==  7 bits == 2 bytes
           < 16,000 ms gap ==  16 seconds == 14 bits == 3 bytes
        < 2,000,000 ms gap ==  35 minutes == 21 bits == 4 bytes
      < 300,000,000 ms gap ==  74 hours   == 28 bits == 5 bytes

    Log bursts will thus consume just 2 bytes (tag + up to 127ms delta) for
    the timestamp, which is a good improvement over an absolute timestamp.
    """

    dropped: builtins.int
    """When the log buffers are full but more logs come in, the logs are counted
    and a special log message is omitted with only counts for the number of
    messages dropped.
    """

    module: builtins.bytes
    """The PW_LOG_MODULE_NAME for this log message."""

    file: builtins.bytes
    """The file path where this log was created, if not encoded in the message."""

    thread: builtins.bytes
    """The task or thread name that created the log message. If the log was not
    created on a thread, it should use a name appropriate to that context.
    """

    def __init__(self,
        *,
        message: typing.Optional[builtins.bytes] = ...,
        line_level: builtins.int = ...,
        flags: builtins.int = ...,
        timestamp: builtins.int = ...,
        time_since_last_entry: builtins.int = ...,
        dropped: builtins.int = ...,
        module: builtins.bytes = ...,
        file: builtins.bytes = ...,
        thread: builtins.bytes = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_message",b"_message","message",b"message","time",b"time","time_since_last_entry",b"time_since_last_entry","timestamp",b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_message",b"_message","dropped",b"dropped","file",b"file","flags",b"flags","line_level",b"line_level","message",b"message","module",b"module","thread",b"thread","time",b"time","time_since_last_entry",b"time_since_last_entry","timestamp",b"timestamp"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_message",b"_message"]) -> typing.Optional[typing_extensions.Literal["message"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["time",b"time"]) -> typing.Optional[typing_extensions.Literal["timestamp","time_since_last_entry"]]: ...
global___LogEntry = LogEntry

class LogRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    def __init__(self,
        ) -> None: ...
global___LogRequest = LogRequest

class LogEntries(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ENTRIES_FIELD_NUMBER: builtins.int
    FIRST_ENTRY_SEQUENCE_ID_FIELD_NUMBER: builtins.int
    @property
    def entries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LogEntry]: ...
    first_entry_sequence_id: builtins.int
    def __init__(self,
        *,
        entries: typing.Optional[typing.Iterable[global___LogEntry]] = ...,
        first_entry_sequence_id: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["entries",b"entries","first_entry_sequence_id",b"first_entry_sequence_id"]) -> None: ...
global___LogEntries = LogEntries

class FilterRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _Level:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _LevelEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[FilterRule._Level.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ANY_LEVEL: FilterRule._Level.ValueType  # 0
        DEBUG_LEVEL: FilterRule._Level.ValueType  # 1
        INFO_LEVEL: FilterRule._Level.ValueType  # 2
        WARN_LEVEL: FilterRule._Level.ValueType  # 3
        ERROR_LEVEL: FilterRule._Level.ValueType  # 4
        CRITICAL_LEVEL: FilterRule._Level.ValueType  # 5
        FATAL_LEVEL: FilterRule._Level.ValueType  # 7
    class Level(_Level, metaclass=_LevelEnumTypeWrapper):
        """Log level values match pw_log/levels.h. Enum names avoid collissions with
        possible macros.
        """
        pass

    ANY_LEVEL: FilterRule.Level.ValueType  # 0
    DEBUG_LEVEL: FilterRule.Level.ValueType  # 1
    INFO_LEVEL: FilterRule.Level.ValueType  # 2
    WARN_LEVEL: FilterRule.Level.ValueType  # 3
    ERROR_LEVEL: FilterRule.Level.ValueType  # 4
    CRITICAL_LEVEL: FilterRule.Level.ValueType  # 5
    FATAL_LEVEL: FilterRule.Level.ValueType  # 7

    class _Action:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _ActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[FilterRule._Action.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INACTIVE: FilterRule._Action.ValueType  # 0
        """Ignore the rule entirely."""

        KEEP: FilterRule._Action.ValueType  # 1
        """Keep the log entry if all conditions are met."""

        DROP: FilterRule._Action.ValueType  # 2
        """Drop the log entry if all conditions are met"""

    class Action(_Action, metaclass=_ActionEnumTypeWrapper):
        """Action to take if all conditions are met and rule is not inactive."""
        pass

    INACTIVE: FilterRule.Action.ValueType  # 0
    """Ignore the rule entirely."""

    KEEP: FilterRule.Action.ValueType  # 1
    """Keep the log entry if all conditions are met."""

    DROP: FilterRule.Action.ValueType  # 2
    """Drop the log entry if all conditions are met"""


    LEVEL_GREATER_THAN_OR_EQUAL_FIELD_NUMBER: builtins.int
    MODULE_EQUALS_FIELD_NUMBER: builtins.int
    ANY_FLAGS_SET_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    THREAD_EQUALS_FIELD_NUMBER: builtins.int
    level_greater_than_or_equal: global___FilterRule.Level.ValueType
    """Condition 1: log.level >= level_greater_than_or_equal."""

    module_equals: builtins.bytes
    """Condition 2: (module_equals.size() == 0) || (log.module == module_equals);"""

    any_flags_set: builtins.int
    """Condition 3: (any_flags_set == 0) || (log.flags & any_flags_set) != 0))"""

    action: global___FilterRule.Action.ValueType
    thread_equals: builtins.bytes
    """Condition 4: (thread_equals.size() == 0 || log.thread == thread_equals)."""

    def __init__(self,
        *,
        level_greater_than_or_equal: global___FilterRule.Level.ValueType = ...,
        module_equals: builtins.bytes = ...,
        any_flags_set: builtins.int = ...,
        action: global___FilterRule.Action.ValueType = ...,
        thread_equals: builtins.bytes = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["action",b"action","any_flags_set",b"any_flags_set","level_greater_than_or_equal",b"level_greater_than_or_equal","module_equals",b"module_equals","thread_equals",b"thread_equals"]) -> None: ...
global___FilterRule = FilterRule

class Filter(google.protobuf.message.Message):
    """A filter is a series of rules. First matching rule wins."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RULE_FIELD_NUMBER: builtins.int
    @property
    def rule(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FilterRule]: ...
    def __init__(self,
        *,
        rule: typing.Optional[typing.Iterable[global___FilterRule]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["rule",b"rule"]) -> None: ...
global___Filter = Filter

class SetFilterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FILTER_ID_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    filter_id: builtins.bytes
    """A filter can be identified by a human readable string, token, or number."""

    @property
    def filter(self) -> global___Filter: ...
    def __init__(self,
        *,
        filter_id: builtins.bytes = ...,
        filter: typing.Optional[global___Filter] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["filter",b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter",b"filter","filter_id",b"filter_id"]) -> None: ...
global___SetFilterRequest = SetFilterRequest

class GetFilterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FILTER_ID_FIELD_NUMBER: builtins.int
    filter_id: builtins.bytes
    def __init__(self,
        *,
        filter_id: builtins.bytes = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter_id",b"filter_id"]) -> None: ...
global___GetFilterRequest = GetFilterRequest

class FilterIdListRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    def __init__(self,
        ) -> None: ...
global___FilterIdListRequest = FilterIdListRequest

class FilterIdListResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FILTER_ID_FIELD_NUMBER: builtins.int
    @property
    def filter_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bytes]: ...
    def __init__(self,
        *,
        filter_id: typing.Optional[typing.Iterable[builtins.bytes]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter_id",b"filter_id"]) -> None: ...
global___FilterIdListResponse = FilterIdListResponse
