# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['ax',
 'ax.utils',
 'ax.utils.ax_tree',
 'axlib',
 'axlib.ax_tree',
 'devapp',
 'devapp.app_token',
 'devapp.arch',
 'devapp.arch.gitlab',
 'devapp.arch.gitlab.solution.conf',
 'devapp.components',
 'devapp.lib',
 'devapp.operations',
 'devapp.plugins.ops_devapp',
 'devapp.plugins.ops_devapp.arch',
 'devapp.spec',
 'devapp.testing',
 'devapp.tests',
 'devapp.utils',
 'mdvl',
 'structlogging',
 'structlogging.tests',
 'theming',
 'theming.filesize',
 'theming.formatting',
 'theming.tests',
 'tree_builder',
 'tree_builder.arch']

package_data = \
{'': ['*'],
 'devapp': ['third/*'],
 'devapp.arch.gitlab': ['solution/*'],
 'devapp.spec': ['templates/*']}

install_requires = \
['PyJWT>=1.7.1,<2.0.0',
 'PyYAML>=5.3.1,<6.0.0',
 'Pygments>=2.7.1,<3.0.0',
 'Rx>=3.1.1,<4.0.0',
 'absl-py>=0.10.0,<0.11.0',
 'bpytop>=1.0.50,<2.0.0',
 'decorator>=4.4.2,<5.0.0',
 'gevent>=20.9.0,<21.0.0',
 'httpx>=0.17.1,<0.18.0',
 'humanize>=3.0.1,<4.0.0',
 'inflection>=0.5.1,<0.6.0',
 'jsondiff>=1.2.0,<2.0.0',
 'lz4>=3.1.0,<4.0.0',
 'msgpack>=1.0.0,<2.0.0',
 'psutil>=5.7.2,<6.0.0',
 'pycond>=20200730,<20200731',
 'requests>=2.24.0,<3.0.0',
 'snoop>=0.2.5,<0.3.0',
 'structlog>=20.1.0,<21.0.0',
 'tabulate>=0.8.7,<0.9.0',
 'toml>=0.10.1,<0.11.0',
 'ujson>=4.0.1,<5.0.0']

entry_points = \
{'console_scripts': ['app = devapp.plugin_tools:main',
                     'ops = devapp.plugin_tools:main']}

setup_kwargs = {
    'name': 'devapps',
    'version': '2021.5.10',
    'description': 'Apps - End to End.',
    'long_description': '\n# About `devapp`\n\n\n<p attr="autogenerated by make_badges"></p>\n\n<p attr="autogenerated by make_badges"></p>\n\n![](img/page-teaser.png){: style="width:1550px" }\n\n\nThis is an enabler repo to develop "ops friendly" apps in a normalized way, incl:\n\n- logging ([structlog](https://www.structlog.org/en/stable/))\n- cli flags handling ([abseil](https://abseil.io/docs/python/), with addons)\n- docu ([mkdocs-material](https://squidfunk.github.io/mkdocs-material/getting-started/))\n- project setup\n- (test) resoures management, including daemons and container filesystem layers\n\nand more.\n\n\n\n<!-- pre_proc_marker -->\n\n----\n\n\n',
    'author': 'Gunther Klessinger',
    'author_email': 'gunther.klessinger@axiros.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'http://github.com/AXGKl/devapps',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
