"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const child_process = require("child_process");
const crypto_1 = require("crypto");
const os_1 = require("os");
const path_1 = require("path");
const process_1 = require("process");
try {
    /* eslint-disable import/no-extraneous-dependencies */
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    require.resolve('esbuild/package.json');
    /* eslint-enable import/no-extraneous-dependencies */
}
catch (e) {
    throw new Error('"esbuild" must be installed on the system');
}
// we are taking a "runtime peer" dependency on esbuild
// eslint-disable-next-line import/no-extraneous-dependencies
const esbuild = require("esbuild");
const fs_extra_1 = require("fs-extra");
/**
 * @stability stable
 */
class CFunction {
    /**
     * @stability stable
     */
    constructor(props) {
        var _b, _c, _d;
        const outdir = fs_extra_1.mkdtempSync(path_1.join(os_1.tmpdir(), '.cf.out.'));
        this.workdir = fs_extra_1.mkdtempSync(path_1.join(os_1.tmpdir(), '.cf.work.'));
        this.env = {};
        const workdir = this.workdir;
        // deploy runtime
        const runtimesrc = path_1.dirname(require.resolve(path_1.join(__dirname, '..', 'resources', 'cfruntime.js')));
        fs_extra_1.copySync(runtimesrc, workdir);
        const outfile = path_1.resolve(outdir, 'cf.js');
        const epcode = new Array();
        this.captureSymbols((_b = props.capture) !== null && _b !== void 0 ? _b : {}, epcode);
        const code = (_c = props.code) !== null && _c !== void 0 ? _c : 'true';
        epcode.push(`const output = ${code};`);
        epcode.push('module.exports = require(\'./cfruntime\').wrap(output);');
        const entrypoint = path_1.join(workdir, 'entrypoint.js');
        fs_extra_1.writeFileSync(entrypoint, epcode.join('\n'));
        const restore = process.cwd();
        process_1.chdir(workdir);
        try {
            const result = esbuild.buildSync({
                bundle: true,
                entryPoints: [path_1.relative(workdir, entrypoint)],
                outfile,
                platform: 'node',
                logLevel: 'silent',
            });
            if ((_d = result.warnings) === null || _d === void 0 ? void 0 : _d.length) {
                throw new Error('esbuild warnings');
            }
        }
        catch (e) {
            throw new Error(`esbuild failed at ${workdir} ${e.message}`);
        }
        finally {
            process_1.chdir(restore);
        }
        this.outfile = outfile;
    }
    /**
     * @stability stable
     */
    static exec(file, options = {}) {
        var _b;
        try {
            const substrate = `require('${file}')().catch(e => { console.error(e.stack); process.exit(1); }).then(o => console.log(JSON.stringify(o)))`;
            const child = child_process.spawnSync(process.execPath, ['-e', substrate], {
                stdio: ['inherit', 'pipe', 'pipe'],
                env: (_b = options.env) !== null && _b !== void 0 ? _b : {},
            });
            const stderr = child.stderr.toString('utf-8');
            if (child.status !== 0) {
                throw new Error(`non-exit from child process: ${stderr}`);
            }
            // allow function to emit logs to STDERR (non-streaming)
            if (stderr.length) {
                console.error(stderr);
            }
            // STDOUT is the result
            return JSON.parse(child.stdout.toString());
        }
        catch (e) {
            throw new Error(`unable to execute ${file}: ${e.message}`);
        }
    }
    /**
     * @stability stable
     */
    toJson() {
        return {
            env: this.env,
            js: fs_extra_1.readFileSync(this.outfile, 'utf-8'),
        };
    }
    captureSymbols(symbols, code) {
        for (const [name, value] of Object.entries(symbols)) {
            // if the value is a cfunction, we copy the cf.js file to our workdir and
            // bind the result of "require()"ing it locally.
            if (value instanceof CFunction) {
                const fileName = hashOf(value.outfile) + '.js';
                fs_extra_1.copySync(value.outfile, path_1.join(this.workdir, fileName));
                code.push(`const ${name} = require('./${fileName}');`);
                continue;
            }
            // bind the value through an environment variable (late binding). technically it should be
            // possible to do early-binding for all values that are not CDK tokens but since we are unable
            // to identify tokens at this layer, we have to deffer to late bindings.
            const cvalue = this.captureValue(value);
            const envVar = symbolToEnv(name);
            code.push(`const ${name} = process.env["${envVar}"];`);
            code.push(`if (${name} === undefined) { throw new Error("missing required environment variable '${envVar}'"); }`);
            this.env[envVar] = cvalue;
        }
    }
    captureValue(x) {
        if (typeof (x) === 'function') {
            throw new Error('cannot capture functions yet');
        }
        ;
        if (typeof (x) === 'symbol') {
            throw new Error('cannot capture symbols yet');
        }
        if (Array.isArray(x)) {
            return this.captureArray(x);
        }
        if (typeof (x) === 'object') {
            return this.captureObject(x);
        }
        return this.capturePrimitive(x);
    }
    capturePrimitive(x) {
        return JSON.stringify(x);
    }
    captureObject(o) {
        if (o.constructor.name != 'Object') {
            throw new Error('classes are not supported yet');
        }
        if ('toJson' in o && typeof (o.toJson === 'function')) {
            o = o.toJson();
        }
        const fields = Array();
        for (const [k, v] of Object.entries(o)) {
            fields.push(`"${k}": ${this.captureValue(v)}`);
        }
        return `{ ${fields.join(',')}}`;
    }
    captureArray(a) {
        return '[' + a.map(x => this.captureValue(x)).join(',') + ']';
    }
}
exports.CFunction = CFunction;
_a = JSII_RTTI_SYMBOL_1;
CFunction[_a] = { fqn: "cfunctions.CFunction", version: "0.1.165" };
/** generate an environment variable for a named symbol */
function symbolToEnv(symbol) {
    return `__CF__${symbol}__`;
}
function hashOf(file) {
    const sha1 = crypto_1.createHash('sha1');
    sha1.update(fs_extra_1.readFileSync(file));
    return sha1.digest('hex');
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2Z1bmN0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2NmdW5jdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLCtDQUErQztBQUMvQyxtQ0FBb0M7QUFDcEMsMkJBQTRCO0FBQzVCLCtCQUF3RDtBQUN4RCxxQ0FBZ0M7QUFFaEMsSUFBSTtJQUNGLHNEQUFzRDtJQUN0RCxpRUFBaUU7SUFDakUsT0FBTyxDQUFDLE9BQU8sQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3hDLHFEQUFxRDtDQUN0RDtBQUFDLE9BQU8sQ0FBQyxFQUFFO0lBQ1YsTUFBTSxJQUFJLEtBQUssQ0FBQywyQ0FBMkMsQ0FBQyxDQUFDO0NBQzlEO0FBR0QsdURBQXVEO0FBQ3ZELDZEQUE2RDtBQUM3RCxtQ0FBbUM7QUFFbkMsdUNBQThFOzs7O0FBZTlFLE1BQWEsU0FBUzs7OztJQW1DcEIsWUFBWSxLQUFxQjs7UUFDL0IsTUFBTSxNQUFNLEdBQUcsc0JBQVcsQ0FBQyxXQUFJLENBQUMsV0FBTSxFQUFFLEVBQUUsVUFBVSxDQUFDLENBQUMsQ0FBQztRQUN2RCxJQUFJLENBQUMsT0FBTyxHQUFHLHNCQUFXLENBQUMsV0FBSSxDQUFDLFdBQU0sRUFBRSxFQUFFLFdBQVcsQ0FBQyxDQUFDLENBQUM7UUFDeEQsSUFBSSxDQUFDLEdBQUcsR0FBRyxFQUFFLENBQUM7UUFFZCxNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1FBRTdCLGlCQUFpQjtRQUNqQixNQUFNLFVBQVUsR0FBRyxjQUFPLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxXQUFJLENBQUMsU0FBUyxFQUFFLElBQUksRUFBRSxXQUFXLEVBQUUsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ2hHLG1CQUFRLENBQUMsVUFBVSxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBRTlCLE1BQU0sT0FBTyxHQUFHLGNBQU8sQ0FBQyxNQUFNLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFFekMsTUFBTSxNQUFNLEdBQUcsSUFBSSxLQUFLLEVBQVUsQ0FBQztRQUVuQyxJQUFJLENBQUMsY0FBYyxPQUFDLEtBQUssQ0FBQyxPQUFPLG1DQUFJLEVBQUcsRUFBRSxNQUFNLENBQUMsQ0FBQztRQUVsRCxNQUFNLElBQUksU0FBRyxLQUFLLENBQUMsSUFBSSxtQ0FBSSxNQUFNLENBQUM7UUFDbEMsTUFBTSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsSUFBSSxHQUFHLENBQUMsQ0FBQztRQUN2QyxNQUFNLENBQUMsSUFBSSxDQUFDLHlEQUF5RCxDQUFDLENBQUM7UUFFdkUsTUFBTSxVQUFVLEdBQUcsV0FBSSxDQUFDLE9BQU8sRUFBRSxlQUFlLENBQUMsQ0FBQztRQUNsRCx3QkFBYSxDQUFDLFVBQVUsRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7UUFFN0MsTUFBTSxPQUFPLEdBQUcsT0FBTyxDQUFDLEdBQUcsRUFBRSxDQUFDO1FBQzlCLGVBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUNmLElBQUk7WUFDRixNQUFNLE1BQU0sR0FBRyxPQUFPLENBQUMsU0FBUyxDQUFDO2dCQUMvQixNQUFNLEVBQUUsSUFBSTtnQkFDWixXQUFXLEVBQUUsQ0FBQyxlQUFRLENBQUMsT0FBTyxFQUFFLFVBQVUsQ0FBQyxDQUFDO2dCQUM1QyxPQUFPO2dCQUNQLFFBQVEsRUFBRSxNQUFNO2dCQUNoQixRQUFRLEVBQUUsUUFBUTthQUNuQixDQUFDLENBQUM7WUFDSCxVQUFJLE1BQU0sQ0FBQyxRQUFRLDBDQUFFLE1BQU0sRUFBRTtnQkFDM0IsTUFBTSxJQUFJLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO2FBQ3JDO1NBQ0Y7UUFBQyxPQUFPLENBQUMsRUFBRTtZQUNWLE1BQU0sSUFBSSxLQUFLLENBQUMscUJBQXFCLE9BQU8sSUFBSSxDQUFDLENBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQztTQUM5RDtnQkFBUztZQUNSLGVBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztTQUNoQjtRQUVELElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO0lBQ3pCLENBQUM7Ozs7SUE5RU0sTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFZLEVBQUUsVUFBdUIsRUFBRTs7UUFDeEQsSUFBSTtZQUNGLE1BQU0sU0FBUyxHQUFHLFlBQVksSUFBSSx5R0FBeUcsQ0FBQztZQUM1SSxNQUFNLEtBQUssR0FBRyxhQUFhLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUsQ0FBQyxJQUFJLEVBQUUsU0FBUyxDQUFDLEVBQUU7Z0JBQ3pFLEtBQUssRUFBRSxDQUFDLFNBQVMsRUFBRSxNQUFNLEVBQUUsTUFBTSxDQUFDO2dCQUNsQyxHQUFHLFFBQUUsT0FBTyxDQUFDLEdBQUcsbUNBQUksRUFBRTthQUN2QixDQUFDLENBQUM7WUFFSCxNQUFNLE1BQU0sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQztZQUU5QyxJQUFJLEtBQUssQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO2dCQUN0QixNQUFNLElBQUksS0FBSyxDQUFDLGdDQUFnQyxNQUFNLEVBQUUsQ0FBQyxDQUFDO2FBQzNEO1lBRUQsd0RBQXdEO1lBQ3hELElBQUksTUFBTSxDQUFDLE1BQU0sRUFBRTtnQkFDakIsT0FBTyxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsQ0FBQzthQUN2QjtZQUVELHVCQUF1QjtZQUN2QixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxRQUFRLEVBQUUsQ0FBQyxDQUFDO1NBQzVDO1FBQUMsT0FBTyxDQUFDLEVBQUU7WUFDVixNQUFNLElBQUksS0FBSyxDQUFDLHFCQUFxQixJQUFJLEtBQUssQ0FBQyxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUM7U0FDNUQ7SUFDSCxDQUFDOzs7O0lBeURNLE1BQU07UUFDWCxPQUFPO1lBQ0wsR0FBRyxFQUFFLElBQUksQ0FBQyxHQUFHO1lBQ2IsRUFBRSxFQUFFLHVCQUFZLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUM7U0FDeEMsQ0FBQztJQUNKLENBQUM7SUFFTyxjQUFjLENBQUMsT0FBa0MsRUFBRSxJQUFjO1FBQ3ZFLEtBQUssTUFBTSxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUFFO1lBRW5ELHlFQUF5RTtZQUN6RSxnREFBZ0Q7WUFDaEQsSUFBSSxLQUFLLFlBQVksU0FBUyxFQUFFO2dCQUM5QixNQUFNLFFBQVEsR0FBRyxNQUFNLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxHQUFHLEtBQUssQ0FBQztnQkFDL0MsbUJBQVEsQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLFdBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLFFBQVEsQ0FBQyxDQUFDLENBQUM7Z0JBQ3RELElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxJQUFJLGlCQUFpQixRQUFRLEtBQUssQ0FBQyxDQUFDO2dCQUN2RCxTQUFTO2FBQ1Y7WUFFRCwwRkFBMEY7WUFDMUYsOEZBQThGO1lBQzlGLHdFQUF3RTtZQUN4RSxNQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ3hDLE1BQU0sTUFBTSxHQUFHLFdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUNqQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsSUFBSSxtQkFBbUIsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUN2RCxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sSUFBSSw2RUFBNkUsTUFBTSxRQUFRLENBQUMsQ0FBQztZQUVsSCxJQUFJLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxHQUFHLE1BQU0sQ0FBQztTQUMzQjtJQUNILENBQUM7SUFFTyxZQUFZLENBQUMsQ0FBTTtRQUN6QixJQUFJLE9BQU0sQ0FBQyxDQUFDLENBQUMsS0FBSyxVQUFVLEVBQUU7WUFDNUIsTUFBTSxJQUFJLEtBQUssQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO1NBQ2pEO1FBQUEsQ0FBQztRQUNGLElBQUksT0FBTSxDQUFDLENBQUMsQ0FBQyxLQUFLLFFBQVEsRUFBRTtZQUMxQixNQUFNLElBQUksS0FBSyxDQUFDLDRCQUE0QixDQUFDLENBQUM7U0FDL0M7UUFFRCxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUU7WUFDcEIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxDQUFDO1NBQzdCO1FBRUQsSUFBSSxPQUFNLENBQUMsQ0FBQyxDQUFDLEtBQUssUUFBUSxFQUFFO1lBQzFCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQztTQUM5QjtRQUVELE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFTyxnQkFBZ0IsQ0FBQyxDQUFxQztRQUM1RCxPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDM0IsQ0FBQztJQUVPLGFBQWEsQ0FBQyxDQUFNO1FBQzFCLElBQUksQ0FBQyxDQUFDLFdBQVcsQ0FBQyxJQUFJLElBQUksUUFBUSxFQUFFO1lBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsK0JBQStCLENBQUMsQ0FBQztTQUNsRDtRQUVELElBQUksUUFBUSxJQUFJLENBQUMsSUFBSSxPQUFNLENBQUMsQ0FBQyxDQUFDLE1BQU0sS0FBSyxVQUFVLENBQUMsRUFBRTtZQUNwRCxDQUFDLEdBQUcsQ0FBQyxDQUFDLE1BQU0sRUFBRSxDQUFDO1NBQ2hCO1FBRUQsTUFBTSxNQUFNLEdBQUcsS0FBSyxFQUFVLENBQUM7UUFDL0IsS0FBSyxNQUFNLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUU7WUFDdEMsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztTQUNoRDtRQUVELE9BQU8sS0FBSyxNQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBRSxHQUFHLENBQUM7SUFDbkMsQ0FBQztJQUVPLFlBQVksQ0FBQyxDQUFRO1FBQzNCLE9BQU8sR0FBRyxHQUFHLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHLEdBQUcsQ0FBQztJQUNoRSxDQUFDOztBQTNKSCw4QkE0SkM7OztBQUVELDBEQUEwRDtBQUMxRCxTQUFTLFdBQVcsQ0FBQyxNQUFjO0lBQ2pDLE9BQU8sU0FBUyxNQUFNLElBQUksQ0FBQztBQUM3QixDQUFDO0FBR0QsU0FBUyxNQUFNLENBQUMsSUFBWTtJQUMxQixNQUFNLElBQUksR0FBRyxtQkFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ2hDLElBQUksQ0FBQyxNQUFNLENBQUMsdUJBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ2hDLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQztBQUM1QixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2hpbGRfcHJvY2VzcyBmcm9tICdjaGlsZF9wcm9jZXNzJztcbmltcG9ydCB7IGNyZWF0ZUhhc2ggfSBmcm9tICdjcnlwdG8nO1xuaW1wb3J0IHsgdG1wZGlyIH0gZnJvbSAnb3MnO1xuaW1wb3J0IHsgam9pbiwgcmVzb2x2ZSwgZGlybmFtZSwgcmVsYXRpdmUgfSBmcm9tICdwYXRoJztcbmltcG9ydCB7IGNoZGlyIH0gZnJvbSAncHJvY2Vzcyc7XG5cbnRyeSB7XG4gIC8qIGVzbGludC1kaXNhYmxlIGltcG9ydC9uby1leHRyYW5lb3VzLWRlcGVuZGVuY2llcyAqL1xuICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgQHR5cGVzY3JpcHQtZXNsaW50L25vLXJlcXVpcmUtaW1wb3J0c1xuICByZXF1aXJlLnJlc29sdmUoJ2VzYnVpbGQvcGFja2FnZS5qc29uJyk7XG4gIC8qIGVzbGludC1lbmFibGUgaW1wb3J0L25vLWV4dHJhbmVvdXMtZGVwZW5kZW5jaWVzICovXG59IGNhdGNoIChlKSB7XG4gIHRocm93IG5ldyBFcnJvcignXCJlc2J1aWxkXCIgbXVzdCBiZSBpbnN0YWxsZWQgb24gdGhlIHN5c3RlbScpO1xufVxuXG5cbi8vIHdlIGFyZSB0YWtpbmcgYSBcInJ1bnRpbWUgcGVlclwiIGRlcGVuZGVuY3kgb24gZXNidWlsZFxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGltcG9ydC9uby1leHRyYW5lb3VzLWRlcGVuZGVuY2llc1xuaW1wb3J0ICogYXMgZXNidWlsZCBmcm9tICdlc2J1aWxkJztcblxuaW1wb3J0IHsgbWtkdGVtcFN5bmMsIHdyaXRlRmlsZVN5bmMsIHJlYWRGaWxlU3luYywgY29weVN5bmMgfSBmcm9tICdmcy1leHRyYSc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQ0Z1bmN0aW9uUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2FwdHVyZT86IHsgW25hbWU6IHN0cmluZ106IGFueSB9O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjb2RlPzogc3RyaW5nO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEV4ZWNPcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGVudj86IHsgW25hbWU6IHN0cmluZ106IHN0cmluZyB9O1xufVxuXG5leHBvcnQgY2xhc3MgQ0Z1bmN0aW9uIHtcbiAgcHVibGljIHN0YXRpYyBleGVjKGZpbGU6IHN0cmluZywgb3B0aW9uczogRXhlY09wdGlvbnMgPSB7fSk6IGFueSB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHN1YnN0cmF0ZSA9IGByZXF1aXJlKCcke2ZpbGV9JykoKS5jYXRjaChlID0+IHsgY29uc29sZS5lcnJvcihlLnN0YWNrKTsgcHJvY2Vzcy5leGl0KDEpOyB9KS50aGVuKG8gPT4gY29uc29sZS5sb2coSlNPTi5zdHJpbmdpZnkobykpKWA7XG4gICAgICBjb25zdCBjaGlsZCA9IGNoaWxkX3Byb2Nlc3Muc3Bhd25TeW5jKHByb2Nlc3MuZXhlY1BhdGgsIFsnLWUnLCBzdWJzdHJhdGVdLCB7XG4gICAgICAgIHN0ZGlvOiBbJ2luaGVyaXQnLCAncGlwZScsICdwaXBlJ10sXG4gICAgICAgIGVudjogb3B0aW9ucy5lbnYgPz8ge30sXG4gICAgICB9KTtcblxuICAgICAgY29uc3Qgc3RkZXJyID0gY2hpbGQuc3RkZXJyLnRvU3RyaW5nKCd1dGYtOCcpO1xuXG4gICAgICBpZiAoY2hpbGQuc3RhdHVzICE9PSAwKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcihgbm9uLWV4aXQgZnJvbSBjaGlsZCBwcm9jZXNzOiAke3N0ZGVycn1gKTtcbiAgICAgIH1cblxuICAgICAgLy8gYWxsb3cgZnVuY3Rpb24gdG8gZW1pdCBsb2dzIHRvIFNUREVSUiAobm9uLXN0cmVhbWluZylcbiAgICAgIGlmIChzdGRlcnIubGVuZ3RoKSB7XG4gICAgICAgIGNvbnNvbGUuZXJyb3Ioc3RkZXJyKTtcbiAgICAgIH1cblxuICAgICAgLy8gU1RET1VUIGlzIHRoZSByZXN1bHRcbiAgICAgIHJldHVybiBKU09OLnBhcnNlKGNoaWxkLnN0ZG91dC50b1N0cmluZygpKTtcbiAgICB9IGNhdGNoIChlKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYHVuYWJsZSB0byBleGVjdXRlICR7ZmlsZX06ICR7ZS5tZXNzYWdlfWApO1xuICAgIH1cbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBvdXRmaWxlOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgZW52OiB7IFtuYW1lOiBzdHJpbmddOiBzdHJpbmcgfTtcblxuICBwcml2YXRlIHJlYWRvbmx5IHdvcmtkaXI6IHN0cmluZztcblxuICBjb25zdHJ1Y3Rvcihwcm9wczogQ0Z1bmN0aW9uUHJvcHMpIHtcbiAgICBjb25zdCBvdXRkaXIgPSBta2R0ZW1wU3luYyhqb2luKHRtcGRpcigpLCAnLmNmLm91dC4nKSk7XG4gICAgdGhpcy53b3JrZGlyID0gbWtkdGVtcFN5bmMoam9pbih0bXBkaXIoKSwgJy5jZi53b3JrLicpKTtcbiAgICB0aGlzLmVudiA9IHt9O1xuXG4gICAgY29uc3Qgd29ya2RpciA9IHRoaXMud29ya2RpcjtcblxuICAgIC8vIGRlcGxveSBydW50aW1lXG4gICAgY29uc3QgcnVudGltZXNyYyA9IGRpcm5hbWUocmVxdWlyZS5yZXNvbHZlKGpvaW4oX19kaXJuYW1lLCAnLi4nLCAncmVzb3VyY2VzJywgJ2NmcnVudGltZS5qcycpKSk7XG4gICAgY29weVN5bmMocnVudGltZXNyYywgd29ya2Rpcik7XG5cbiAgICBjb25zdCBvdXRmaWxlID0gcmVzb2x2ZShvdXRkaXIsICdjZi5qcycpO1xuXG4gICAgY29uc3QgZXBjb2RlID0gbmV3IEFycmF5PHN0cmluZz4oKTtcblxuICAgIHRoaXMuY2FwdHVyZVN5bWJvbHMocHJvcHMuY2FwdHVyZSA/PyB7IH0sIGVwY29kZSk7XG5cbiAgICBjb25zdCBjb2RlID0gcHJvcHMuY29kZSA/PyAndHJ1ZSc7XG4gICAgZXBjb2RlLnB1c2goYGNvbnN0IG91dHB1dCA9ICR7Y29kZX07YCk7XG4gICAgZXBjb2RlLnB1c2goJ21vZHVsZS5leHBvcnRzID0gcmVxdWlyZShcXCcuL2NmcnVudGltZVxcJykud3JhcChvdXRwdXQpOycpO1xuXG4gICAgY29uc3QgZW50cnlwb2ludCA9IGpvaW4od29ya2RpciwgJ2VudHJ5cG9pbnQuanMnKTtcbiAgICB3cml0ZUZpbGVTeW5jKGVudHJ5cG9pbnQsIGVwY29kZS5qb2luKCdcXG4nKSk7XG5cbiAgICBjb25zdCByZXN0b3JlID0gcHJvY2Vzcy5jd2QoKTtcbiAgICBjaGRpcih3b3JrZGlyKTtcbiAgICB0cnkge1xuICAgICAgY29uc3QgcmVzdWx0ID0gZXNidWlsZC5idWlsZFN5bmMoe1xuICAgICAgICBidW5kbGU6IHRydWUsXG4gICAgICAgIGVudHJ5UG9pbnRzOiBbcmVsYXRpdmUod29ya2RpciwgZW50cnlwb2ludCldLFxuICAgICAgICBvdXRmaWxlLFxuICAgICAgICBwbGF0Zm9ybTogJ25vZGUnLFxuICAgICAgICBsb2dMZXZlbDogJ3NpbGVudCcsXG4gICAgICB9KTtcbiAgICAgIGlmIChyZXN1bHQud2FybmluZ3M/Lmxlbmd0aCkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ2VzYnVpbGQgd2FybmluZ3MnKTtcbiAgICAgIH1cbiAgICB9IGNhdGNoIChlKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYGVzYnVpbGQgZmFpbGVkIGF0ICR7d29ya2Rpcn0gJHtlLm1lc3NhZ2V9YCk7XG4gICAgfSBmaW5hbGx5IHtcbiAgICAgIGNoZGlyKHJlc3RvcmUpO1xuICAgIH1cblxuICAgIHRoaXMub3V0ZmlsZSA9IG91dGZpbGU7XG4gIH1cblxuXG4gIHB1YmxpYyB0b0pzb24oKTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgZW52OiB0aGlzLmVudixcbiAgICAgIGpzOiByZWFkRmlsZVN5bmModGhpcy5vdXRmaWxlLCAndXRmLTgnKSxcbiAgICB9O1xuICB9XG5cbiAgcHJpdmF0ZSBjYXB0dXJlU3ltYm9scyhzeW1ib2xzOiB7IFtzeW1ib2w6IHN0cmluZ106IGFueSB9LCBjb2RlOiBzdHJpbmdbXSkge1xuICAgIGZvciAoY29uc3QgW25hbWUsIHZhbHVlXSBvZiBPYmplY3QuZW50cmllcyhzeW1ib2xzKSkge1xuXG4gICAgICAvLyBpZiB0aGUgdmFsdWUgaXMgYSBjZnVuY3Rpb24sIHdlIGNvcHkgdGhlIGNmLmpzIGZpbGUgdG8gb3VyIHdvcmtkaXIgYW5kXG4gICAgICAvLyBiaW5kIHRoZSByZXN1bHQgb2YgXCJyZXF1aXJlKClcImluZyBpdCBsb2NhbGx5LlxuICAgICAgaWYgKHZhbHVlIGluc3RhbmNlb2YgQ0Z1bmN0aW9uKSB7XG4gICAgICAgIGNvbnN0IGZpbGVOYW1lID0gaGFzaE9mKHZhbHVlLm91dGZpbGUpICsgJy5qcyc7XG4gICAgICAgIGNvcHlTeW5jKHZhbHVlLm91dGZpbGUsIGpvaW4odGhpcy53b3JrZGlyLCBmaWxlTmFtZSkpO1xuICAgICAgICBjb2RlLnB1c2goYGNvbnN0ICR7bmFtZX0gPSByZXF1aXJlKCcuLyR7ZmlsZU5hbWV9Jyk7YCk7XG4gICAgICAgIGNvbnRpbnVlO1xuICAgICAgfVxuXG4gICAgICAvLyBiaW5kIHRoZSB2YWx1ZSB0aHJvdWdoIGFuIGVudmlyb25tZW50IHZhcmlhYmxlIChsYXRlIGJpbmRpbmcpLiB0ZWNobmljYWxseSBpdCBzaG91bGQgYmVcbiAgICAgIC8vIHBvc3NpYmxlIHRvIGRvIGVhcmx5LWJpbmRpbmcgZm9yIGFsbCB2YWx1ZXMgdGhhdCBhcmUgbm90IENESyB0b2tlbnMgYnV0IHNpbmNlIHdlIGFyZSB1bmFibGVcbiAgICAgIC8vIHRvIGlkZW50aWZ5IHRva2VucyBhdCB0aGlzIGxheWVyLCB3ZSBoYXZlIHRvIGRlZmZlciB0byBsYXRlIGJpbmRpbmdzLlxuICAgICAgY29uc3QgY3ZhbHVlID0gdGhpcy5jYXB0dXJlVmFsdWUodmFsdWUpO1xuICAgICAgY29uc3QgZW52VmFyID0gc3ltYm9sVG9FbnYobmFtZSk7XG4gICAgICBjb2RlLnB1c2goYGNvbnN0ICR7bmFtZX0gPSBwcm9jZXNzLmVudltcIiR7ZW52VmFyfVwiXTtgKTtcbiAgICAgIGNvZGUucHVzaChgaWYgKCR7bmFtZX0gPT09IHVuZGVmaW5lZCkgeyB0aHJvdyBuZXcgRXJyb3IoXCJtaXNzaW5nIHJlcXVpcmVkIGVudmlyb25tZW50IHZhcmlhYmxlICcke2VudlZhcn0nXCIpOyB9YCk7XG5cbiAgICAgIHRoaXMuZW52W2VudlZhcl0gPSBjdmFsdWU7XG4gICAgfVxuICB9XG5cbiAgcHJpdmF0ZSBjYXB0dXJlVmFsdWUoeDogYW55KSB7XG4gICAgaWYgKHR5cGVvZih4KSA9PT0gJ2Z1bmN0aW9uJykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdjYW5ub3QgY2FwdHVyZSBmdW5jdGlvbnMgeWV0Jyk7XG4gICAgfTtcbiAgICBpZiAodHlwZW9mKHgpID09PSAnc3ltYm9sJykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdjYW5ub3QgY2FwdHVyZSBzeW1ib2xzIHlldCcpO1xuICAgIH1cblxuICAgIGlmIChBcnJheS5pc0FycmF5KHgpKSB7XG4gICAgICByZXR1cm4gdGhpcy5jYXB0dXJlQXJyYXkoeCk7XG4gICAgfVxuXG4gICAgaWYgKHR5cGVvZih4KSA9PT0gJ29iamVjdCcpIHtcbiAgICAgIHJldHVybiB0aGlzLmNhcHR1cmVPYmplY3QoeCk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMuY2FwdHVyZVByaW1pdGl2ZSh4KTtcbiAgfVxuXG4gIHByaXZhdGUgY2FwdHVyZVByaW1pdGl2ZSh4OiBzdHJpbmcgfCBudW1iZXIgfCBib29sZWFuIHwgYmlnaW50KSB7XG4gICAgcmV0dXJuIEpTT04uc3RyaW5naWZ5KHgpO1xuICB9XG5cbiAgcHJpdmF0ZSBjYXB0dXJlT2JqZWN0KG86IGFueSkge1xuICAgIGlmIChvLmNvbnN0cnVjdG9yLm5hbWUgIT0gJ09iamVjdCcpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignY2xhc3NlcyBhcmUgbm90IHN1cHBvcnRlZCB5ZXQnKTtcbiAgICB9XG5cbiAgICBpZiAoJ3RvSnNvbicgaW4gbyAmJiB0eXBlb2Yoby50b0pzb24gPT09ICdmdW5jdGlvbicpKSB7XG4gICAgICBvID0gby50b0pzb24oKTtcbiAgICB9XG5cbiAgICBjb25zdCBmaWVsZHMgPSBBcnJheTxzdHJpbmc+KCk7XG4gICAgZm9yIChjb25zdCBbaywgdl0gb2YgT2JqZWN0LmVudHJpZXMobykpIHtcbiAgICAgIGZpZWxkcy5wdXNoKGBcIiR7a31cIjogJHt0aGlzLmNhcHR1cmVWYWx1ZSh2KX1gKTtcbiAgICB9XG5cbiAgICByZXR1cm4gYHsgJHtmaWVsZHMuam9pbignLCcgKX19YDtcbiAgfVxuXG4gIHByaXZhdGUgY2FwdHVyZUFycmF5KGE6IGFueVtdKTogc3RyaW5nIHtcbiAgICByZXR1cm4gJ1snICsgYS5tYXAoeCA9PiB0aGlzLmNhcHR1cmVWYWx1ZSh4KSkuam9pbignLCcpICsgJ10nO1xuICB9XG59XG5cbi8qKiBnZW5lcmF0ZSBhbiBlbnZpcm9ubWVudCB2YXJpYWJsZSBmb3IgYSBuYW1lZCBzeW1ib2wgKi9cbmZ1bmN0aW9uIHN5bWJvbFRvRW52KHN5bWJvbDogc3RyaW5nKSB7XG4gIHJldHVybiBgX19DRl9fJHtzeW1ib2x9X19gO1xufVxuXG5cbmZ1bmN0aW9uIGhhc2hPZihmaWxlOiBzdHJpbmcpOiBzdHJpbmcge1xuICBjb25zdCBzaGExID0gY3JlYXRlSGFzaCgnc2hhMScpO1xuICBzaGExLnVwZGF0ZShyZWFkRmlsZVN5bmMoZmlsZSkpO1xuICByZXR1cm4gc2hhMS5kaWdlc3QoJ2hleCcpO1xufVxuIl19