# AUTOGENERATED! DO NOT EDIT! File to edit: ../03_express.ipynb.

# %% auto 0
__all__ = ['cb', 'px', 'set_template', 'update_legend_and_yaxis', 'Express']

# %% ../03_express.ipynb 4
from functools import partial, wraps
import inspect

import pandas as pd
from plotly import express
from plotly.graph_objects import Figure
import plotly.io as pio
import seaborn as sns

from fastcore.all import *
from .core import *
from .case import *

# %% ../03_express.ipynb 6
def set_template(template_name):
    pio.templates.default = template_name
    set_template.__doc__  = str(pio.templates)
set_template.__doc__  = str(pio.templates)

# %% ../03_express.ipynb 12
pio.templates['seaborn'].layout.shapedefaults.pop('line')
pio.templates['seaborn'].layout.shapedefaults.pop('opacity');

# %% ../03_express.ipynb 15
cb = ['#%02x%02x%02x' % (int(x[0]*255), int(x[1]*255), int(x[2]*255)) for x in sns.color_palette('colorblind')]
for t in pio.templates: pio.templates[t]['layout']['colorway'] = cb

# %% ../03_express.ipynb 17
def update_legend_and_yaxis(fun):
    @wraps(fun)
    def _inner(*args, **kwargs):
        fig = fun(*args, **kwargs)
        for t in fig.data:
            if hasattr(t, 'name'):
                t.update(name=px_labeler[t.name])
            if hasattr(t, 'legendgroup'):
                t.update(legendgroup=px_labeler[t.name])
            if hasattr(t, 'hovertemplate'):
                if not t.hovertemplate is None:
                    t.update(hovertemplate=t.hovertemplate.replace(t.name, px_labeler[t.name]))
        # some express functions like ecdf and histogram write their own yaxis text so we update it here
        if nested_attr(fig, 'layout.yaxis.title.text'):
            fig.update_layout(yaxis_title=px_labeler[fig.layout.yaxis.title.text])
        return fig
    return _inner

# %% ../03_express.ipynb 18
class Express:
    '''Like `plotly.express` but defaults to labels=`px_labeler`'''
    def __getattr__(self, attr):
        fun = getattr(express, attr)
        docstr = fun.__doc__
        if hasattr(fun, '__call__'): 
            sig = inspect.signature(fun)
            if 'labels' in sig.parameters.keys():
                if attr=='imshow':
                    imshow_labeler = PxLabeler()
                    imshow_labeler['x'] = None
                    imshow_labeler['y'] = None
                    fun = partial(fun, labels=imshow_labeler)
                else:
                    fun = update_legend_and_yaxis(partial(fun, labels=px_labeler))
        fun.__doc__ = docstr
        return fun
    __dir__ = express.__dir__
px = Express()

# %% ../03_express.ipynb 32
@patch
def __add__(self:Figure, other):
    color_discrete_sequence = ifnone(self.layout.colorway, pio.templates[pio.templates.default].layout.colorway)
    n_traces = len(self.data)
    if n_traces==1:
        self.data[0].name = self.layout.yaxis.title.text
        self.data[0].showlegend = True
        self.layout.yaxis.title.text = 'Value'
    if len(other.data)==1:
        other.data[0].name = other.layout.yaxis.title.text
    for i, trace in enumerate(other.data):
        trace.showlegend = True
        trace.update(marker_color=color_discrete_sequence[n_traces+i])
        self.add_trace(trace)
    return self
