/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.executor.python.impl;

import com.alibaba.alink.executor.python.PythonBridge;
import com.alibaba.alink.executor.python.api.BaseTableFunction;
import com.alibaba.alink.executor.python.api.PyCollectorWrapper;
import com.alibaba.alink.executor.util.FlinkTypeUtil;
import com.alibaba.alink.executor.util.JsonUtil;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Arrays;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.types.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PyTableFunction
extends TableFunction<Row> {
    private static final Logger LOG = LoggerFactory.getLogger(PyTableFunction.class);
    final String name;
    final String[] resList;
    final TypeInformation<Row> resultType;
    final String config;
    transient BaseTableFunction impl;

    public PyTableFunction(String name, String config) {
        this.name = name;
        this.config = config;
        JsonObject g = new JsonParser().parse(config).getAsJsonObject();
        this.resList = (String[])JsonUtil.gson.fromJson(g.get("paths"), String[].class);
        this.resultType = FlinkTypeUtil.makeRowTypes(g.get("resultType").getAsString().split(","));
    }

    public void open(FunctionContext context) throws Exception {
        super.open(context);
        String pyCmd = context.getJobParameter("py_cmd", "");
        String jvmPort = context.getJobParameter("py_jvm_port", "0");
        String pyPort = context.getJobParameter("py_port", "0");
        int pyConnectTimeout = Integer.parseInt(context.getJobParameter("py_connect_timeout", "0"));
        int pyReadTimeout = Integer.parseInt(context.getJobParameter("py_read_timeout", "0"));
        boolean turnOnLogging = Boolean.valueOf(context.getJobParameter("py_turnon_logging", "false"));
        PythonBridge.inst().open(this.name, pyCmd, Integer.parseInt(jvmPort, 10), Integer.parseInt(pyPort, 10), pyConnectTimeout, pyReadTimeout, turnOnLogging);
        LOG.info("begin to make {}[name={}] with config:{}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.name, this.config});
        this.impl = PythonBridge.inst().app().makeTableFunction(this.config);
        this.impl.setCollector(new FakeCollector(this, ((RowTypeInfo)this.resultType).getFieldTypes()));
    }

    public void eval(Object ... args) {
        this.impl.eval(args);
    }

    public boolean isDeterministic() {
        return super.isDeterministic();
    }

    public void close() throws Exception {
        this.impl = null;
        PythonBridge.inst().close(this.name);
        super.close();
    }

    public TypeInformation<Row> getResultType() {
        return this.resultType;
    }

    static class FakeCollector
    implements PyCollectorWrapper {
        final PyTableFunction f;
        final TypeInformation<?>[] types;
        final Object[] values;

        public FakeCollector(TableFunction<Row> f, TypeInformation<?>[] types) {
            if (!(f instanceof PyTableFunction)) {
                throw new RuntimeException("f is not PyTableFunction.");
            }
            this.f = (PyTableFunction)f;
            this.types = types;
            this.values = new Object[types.length];
        }

        @Override
        public void setField(int idx, Object x) {
            this.values[idx] = FlinkTypeUtil.castTo(x, this.types[idx]);
        }

        @Override
        public void collect() {
            this.f.collect(Row.of((Object[])this.values));
            Arrays.fill(this.values, null);
        }
    }
}

