"""
    Cohesity REST API

    Cohesity API provides a RESTful interface to access the various data management operations on Cohesity cluster and Helios.  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cohesity_sdk.cluster.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from cohesity_sdk.cluster.model.backup_data_stats import BackupDataStats
    from cohesity_sdk.cluster.model.data_lock_constraints import DataLockConstraints
    globals()['BackupDataStats'] = BackupDataStats
    globals()['DataLockConstraints'] = DataLockConstraints


class SnapshotInfo(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.

      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.

    """

    allowed_values = {
        ('status',): {
            'None': None,
            'KINPROGRESS': "kInProgress",
            'KSUCCESSFUL': "kSuccessful",
            'KFAILED': "kFailed",
            'KWAITINGFORNEXTATTEMPT': "kWaitingForNextAttempt",
            'KWARNING': "kWarning",
            'KCURRENTATTEMPTPAUSED': "kCurrentAttemptPaused",
            'KCURRENTATTEMPTRESUMING': "kCurrentAttemptResuming",
            'KCURRENTATTEMPTPAUSING': "kCurrentAttemptPausing",
            'KWAITINGFOROLDERBACKUPRUN': "kWaitingForOlderBackupRun",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'snapshot_id': (str, none_type,),  # noqa: E501
            'status': (str, none_type,),  # noqa: E501
            'status_message': (str, none_type,),  # noqa: E501
            'start_time_usecs': (int, none_type,),  # noqa: E501
            'end_time_usecs': (int, none_type,),  # noqa: E501
            'admitted_time_usecs': (int, none_type,),  # noqa: E501
            'permit_grant_time_usecs': (int, none_type,),  # noqa: E501
            'queue_duration_usecs': (int, none_type,),  # noqa: E501
            'snapshot_creation_time_usecs': (int, none_type,),  # noqa: E501
            'stats': (BackupDataStats,),  # noqa: E501
            'progress_task_id': (str, none_type,),  # noqa: E501
            'warnings': ([str], none_type,),  # noqa: E501
            'is_manually_deleted': (bool, none_type,),  # noqa: E501
            'expiry_time_usecs': (int, none_type,),  # noqa: E501
            'total_file_count': (int, none_type,),  # noqa: E501
            'backup_file_count': (int, none_type,),  # noqa: E501
            'data_lock_constraints': (DataLockConstraints,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'snapshot_id': 'snapshotId',  # noqa: E501
        'status': 'status',  # noqa: E501
        'status_message': 'statusMessage',  # noqa: E501
        'start_time_usecs': 'startTimeUsecs',  # noqa: E501
        'end_time_usecs': 'endTimeUsecs',  # noqa: E501
        'admitted_time_usecs': 'admittedTimeUsecs',  # noqa: E501
        'permit_grant_time_usecs': 'permitGrantTimeUsecs',  # noqa: E501
        'queue_duration_usecs': 'queueDurationUsecs',  # noqa: E501
        'snapshot_creation_time_usecs': 'snapshotCreationTimeUsecs',  # noqa: E501
        'stats': 'stats',  # noqa: E501
        'progress_task_id': 'progressTaskId',  # noqa: E501
        'warnings': 'warnings',  # noqa: E501
        'is_manually_deleted': 'isManuallyDeleted',  # noqa: E501
        'expiry_time_usecs': 'expiryTimeUsecs',  # noqa: E501
        'total_file_count': 'totalFileCount',  # noqa: E501
        'backup_file_count': 'backupFileCount',  # noqa: E501
        'data_lock_constraints': 'dataLockConstraints',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """SnapshotInfo - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)

            snapshot_id (str, none_type): Snapshot id for a successful snapshot. This field will not be set if the Protection Group Run has no successful attempt.. [optional]  # noqa: E501
            status (str, none_type): Status of snapshot.. [optional]  # noqa: E501
            status_message (str, none_type): A message decribing the status. This will be populated currently only for kWaitingForOlderBackupRun status.. [optional]  # noqa: E501
            start_time_usecs (int, none_type): Specifies the start time of attempt in Unix epoch Timestamp(in microseconds) for an object.. [optional]  # noqa: E501
            end_time_usecs (int, none_type): Specifies the end time of attempt in Unix epoch Timestamp(in microseconds) for an object.. [optional]  # noqa: E501
            admitted_time_usecs (int, none_type): Specifies the time at which the backup task was admitted to run in Unix epoch Timestamp(in microseconds) for an object.. [optional]  # noqa: E501
            permit_grant_time_usecs (int, none_type): Specifies the time when gatekeeper permit is granted to the backup task. If the backup task is rescheduled due to errors, the field is updated to the time when permit is granted again.. [optional]  # noqa: E501
            queue_duration_usecs (int, none_type): Specifies the duration between the startTime and when gatekeeper permit is granted to the backup task. If the backup task is rescheduled due to errors, the field is updated considering the time when permit is granted again. Queue duration = PermitGrantTimeUsecs - StartTimeUsecs. [optional]  # noqa: E501
            snapshot_creation_time_usecs (int, none_type): Specifies the time at which the source snapshot was taken in Unix epoch Timestamp(in microseconds) for an object.. [optional]  # noqa: E501
            stats (BackupDataStats): [optional]  # noqa: E501
            progress_task_id (str, none_type): Progress monitor task for an object.. [optional]  # noqa: E501
            warnings ([str], none_type): Specifies a list of warning messages.. [optional]  # noqa: E501
            is_manually_deleted (bool, none_type): Specifies whether the snapshot is deleted manually.. [optional]  # noqa: E501
            expiry_time_usecs (int, none_type): Specifies the expiry time of attempt in Unix epoch Timestamp (in microseconds) for an object.. [optional]  # noqa: E501
            total_file_count (int, none_type): The total number of file and directory entities visited in this backup. Only applicable to file based backups.. [optional]  # noqa: E501
            backup_file_count (int, none_type): The total number of file and directory entities that are backed up in this run. Only applicable to file based backups.. [optional]  # noqa: E501
            data_lock_constraints (DataLockConstraints): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)


        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)


