"""
    Cohesity REST API

    Cohesity API provides a RESTful interface to access the various data management operations on Cohesity cluster and Helios.  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cohesity_sdk.cluster.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from cohesity_sdk.cluster.model.common_oracle_app_source_config import CommonOracleAppSourceConfig
    from cohesity_sdk.cluster.model.key_value_pair import KeyValuePair
    from cohesity_sdk.cluster.model.oracle_db_channel import OracleDbChannel
    from cohesity_sdk.cluster.model.shell_key_value_pair import ShellKeyValuePair
    globals()['CommonOracleAppSourceConfig'] = CommonOracleAppSourceConfig
    globals()['KeyValuePair'] = KeyValuePair
    globals()['OracleDbChannel'] = OracleDbChannel
    globals()['ShellKeyValuePair'] = ShellKeyValuePair


class RecoverOracleNewTargetDatabaseConfig(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.

      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.

    """

    allowed_values = {
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'database_name': (str, none_type,),  # noqa: E501
            'oracle_base_folder': (str, none_type,),  # noqa: E501
            'oracle_home_folder': (str, none_type,),  # noqa: E501
            'db_files_destination': (str, none_type,),  # noqa: E501
            'db_config_file_path': (str, none_type,),  # noqa: E501
            'enable_archive_log_mode': (bool, none_type,),  # noqa: E501
            'pfile_parameter_map': ([KeyValuePair], none_type,),  # noqa: E501
            'bct_file_path': (str, none_type,),  # noqa: E501
            'num_tempfiles': (int, none_type,),  # noqa: E501
            'redo_log_config': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'is_multi_stage_restore': (bool, none_type,),  # noqa: E501
            'oracle_update_restore_options': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type,),  # noqa: E501
            'skip_clone_nid': (bool, none_type,),  # noqa: E501
            'no_filename_check': (bool, none_type,),  # noqa: E501
            'new_name_clause': (str, none_type,),  # noqa: E501
            'restore_time_usecs': (int, none_type,),  # noqa: E501
            'db_channels': ([OracleDbChannel], none_type,),  # noqa: E501
            'recovery_mode': (bool, none_type,),  # noqa: E501
            'shell_evironment_vars': ([ShellKeyValuePair], none_type,),  # noqa: E501
            'granular_restore_info': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'oracle_archive_log_info': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'oracle_recovery_validation_info': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'restore_spfile_or_pfile_info': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'use_scn_for_restore': (bool, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'database_name': 'databaseName',  # noqa: E501
        'oracle_base_folder': 'oracleBaseFolder',  # noqa: E501
        'oracle_home_folder': 'oracleHomeFolder',  # noqa: E501
        'db_files_destination': 'dbFilesDestination',  # noqa: E501
        'db_config_file_path': 'dbConfigFilePath',  # noqa: E501
        'enable_archive_log_mode': 'enableArchiveLogMode',  # noqa: E501
        'pfile_parameter_map': 'pfileParameterMap',  # noqa: E501
        'bct_file_path': 'bctFilePath',  # noqa: E501
        'num_tempfiles': 'numTempfiles',  # noqa: E501
        'redo_log_config': 'redoLogConfig',  # noqa: E501
        'is_multi_stage_restore': 'isMultiStageRestore',  # noqa: E501
        'oracle_update_restore_options': 'oracleUpdateRestoreOptions',  # noqa: E501
        'skip_clone_nid': 'skipCloneNid',  # noqa: E501
        'no_filename_check': 'noFilenameCheck',  # noqa: E501
        'new_name_clause': 'newNameClause',  # noqa: E501
        'restore_time_usecs': 'restoreTimeUsecs',  # noqa: E501
        'db_channels': 'dbChannels',  # noqa: E501
        'recovery_mode': 'recoveryMode',  # noqa: E501
        'shell_evironment_vars': 'shellEvironmentVars',  # noqa: E501
        'granular_restore_info': 'granularRestoreInfo',  # noqa: E501
        'oracle_archive_log_info': 'oracleArchiveLogInfo',  # noqa: E501
        'oracle_recovery_validation_info': 'oracleRecoveryValidationInfo',  # noqa: E501
        'restore_spfile_or_pfile_info': 'restoreSpfileOrPfileInfo',  # noqa: E501
        'use_scn_for_restore': 'useScnForRestore',  # noqa: E501
    }

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """RecoverOracleNewTargetDatabaseConfig - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)

            database_name (str, none_type): Specifies a new name for the restored database. If this field is not specified, then the original database will be overwritten after recovery.. [optional]  # noqa: E501
            oracle_base_folder (str, none_type): Specifies the oracle base folder at selected host.. [optional]  # noqa: E501
            oracle_home_folder (str, none_type): Specifies the oracle home folder at selected host.. [optional]  # noqa: E501
            db_files_destination (str, none_type): Specifies the location to restore database files.. [optional]  # noqa: E501
            db_config_file_path (str, none_type): Specifies the config file path on selected host which configures the restored database.. [optional]  # noqa: E501
            enable_archive_log_mode (bool, none_type): Specifies archive log mode for oracle restore.. [optional]  # noqa: E501
            pfile_parameter_map ([KeyValuePair], none_type): Specifies a key value pair for pfile parameters.. [optional]  # noqa: E501
            bct_file_path (str, none_type): Specifies BCT file path.. [optional]  # noqa: E501
            num_tempfiles (int, none_type): Specifies no. of tempfiles to be used for the recovered database.. [optional]  # noqa: E501
            redo_log_config ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Specifies redo log config.. [optional]  # noqa: E501
            is_multi_stage_restore (bool, none_type): Specifies whether this task is a multistage restore task. If set, we migrate the DB after clone completes.. [optional]  # noqa: E501
            oracle_update_restore_options ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Specifies the parameters that are needed for updating oracle restore options.. [optional]  # noqa: E501
            skip_clone_nid (bool, none_type): Whether or not to skip the nid step in Oracle Clone workflow. Applicable to both smart and old clone workflow.. [optional]  # noqa: E501
            no_filename_check (bool, none_type): Specifies whether to validate filenames or not in Oracle alternate restore workflow.. [optional]  # noqa: E501
            new_name_clause (str, none_type): Specifies newname clause for db files which allows user to have full control on how their database files can be renamed during the oracle alternate restore workflow.. [optional]  # noqa: E501
            restore_time_usecs (int, none_type): Specifies the time in the past to which the Oracle db needs to be restored. This allows for granular recovery of Oracle databases. If this is not set, the Oracle db will be restored from the full/incremental snapshot.. [optional]  # noqa: E501
            db_channels ([OracleDbChannel], none_type): Specifies the Oracle database node channels info. If not specified, the default values assigned by the server are applied to all the databases.. [optional]  # noqa: E501
            recovery_mode (bool, none_type): Specifies if database should be left in recovery mode.. [optional]  # noqa: E501
            shell_evironment_vars ([ShellKeyValuePair], none_type): Specifies key value pairs of shell variables which defines the restore shell environment.. [optional]  # noqa: E501
            granular_restore_info ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Specifies information about list of objects (PDBs) to restore.. [optional]  # noqa: E501
            oracle_archive_log_info ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Specifies Range in Time, Scn or Sequence to restore archive logs of a DB.. [optional]  # noqa: E501
            oracle_recovery_validation_info ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Specifies parameters related to Oracle Recovery Validation.. [optional]  # noqa: E501
            restore_spfile_or_pfile_info ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Specifies parameters related to spfile/pfile restore.. [optional]  # noqa: E501
            use_scn_for_restore (bool, none_type): Specifies whether database recovery performed should use scn value or not.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)


        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
        }
        model_args = {}
        model_args.update(required_args)
        model_args.update(kwargs)
        composed_info = validate_get_composed_info(
            constant_args, model_args, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        unused_args = composed_info[3]

        for var_name, var_value in required_args.items():
            setattr(self, var_name, var_value)
        for var_name, var_value in kwargs.items():
            if var_name in unused_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        not self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)


    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error beause the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              CommonOracleAppSourceConfig,
          ],
          'oneOf': [
          ],
        }

