"""
    Cohesity REST API

    Cohesity API provides a RESTful interface to access the various data management operations on Cohesity cluster and Helios.  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cohesity_sdk.cluster.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from cohesity_sdk.cluster.model.email_helios_search_params_all_of import EmailHeliosSearchParamsAllOf
    from cohesity_sdk.cluster.model.o365_helios_search_emails_request_params import O365HeliosSearchEmailsRequestParams
    from cohesity_sdk.cluster.model.search_email_request_params_base import SearchEmailRequestParamsBase
    globals()['EmailHeliosSearchParamsAllOf'] = EmailHeliosSearchParamsAllOf
    globals()['O365HeliosSearchEmailsRequestParams'] = O365HeliosSearchEmailsRequestParams
    globals()['SearchEmailRequestParamsBase'] = SearchEmailRequestParamsBase


class EmailHeliosSearchParams(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.

      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.

    """

    allowed_values = {
        ('types',): {
            'None': None,
            'EMAIL': "Email",
            'FOLDER': "Folder",
            'CALENDAR': "Calendar",
            'CONTACT': "Contact",
            'TASK': "Task",
            'NOTE': "Note",
        },
        ('source_environment',): {
            'None': None,
            'KO365': "kO365",
        },
        ('task_status_types',): {
            'None': None,
            'NOTSTARTED': "NotStarted",
            'INPROGRESS': "InProgress",
            'COMPLETED': "Completed",
            'WAITINGONOTHERS': "WaitingOnOthers",
            'DEFERRED': "Deferred",
        },
    }

    validations = {
        ('types',): {
        },

        ('task_status_types',): {
        },

    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'types': ([str], none_type,),  # noqa: E501
            'has_attachment': (bool, none_type,),  # noqa: E501
            'sender_address': (str, none_type,),  # noqa: E501
            'recipient_addresses': ([str], none_type,),  # noqa: E501
            'cc_recipient_addresses': ([str], none_type,),  # noqa: E501
            'bcc_recipient_addresses': ([str], none_type,),  # noqa: E501
            'received_start_time_secs': (int, none_type,),  # noqa: E501
            'received_end_time_secs': (int, none_type,),  # noqa: E501
            'email_subject': (str, none_type,),  # noqa: E501
            'folder_names': ([str], none_type,),  # noqa: E501
            'source_environment': (str, none_type,),  # noqa: E501
            'created_start_time_secs': (int, none_type,),  # noqa: E501
            'created_end_time_secs': (int, none_type,),  # noqa: E501
            'last_modified_start_time_secs': (int, none_type,),  # noqa: E501
            'last_modified_end_time_secs': (int, none_type,),  # noqa: E501
            'organizer_address': (str, none_type,),  # noqa: E501
            'attendees_addresses': ([str], none_type,),  # noqa: E501
            'first_name': (str, none_type,),  # noqa: E501
            'middle_name': (str, none_type,),  # noqa: E501
            'last_name': (str, none_type,),  # noqa: E501
            'email_address': (str, none_type,),  # noqa: E501
            'due_date_start_time_secs': (int, none_type,),  # noqa: E501
            'due_date_end_time_secs': (int, none_type,),  # noqa: E501
            'task_status_types': ([str], none_type,),  # noqa: E501
            'o365_params': ([O365HeliosSearchEmailsRequestParams], none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'types': 'types',  # noqa: E501
        'has_attachment': 'hasAttachment',  # noqa: E501
        'sender_address': 'senderAddress',  # noqa: E501
        'recipient_addresses': 'recipientAddresses',  # noqa: E501
        'cc_recipient_addresses': 'ccRecipientAddresses',  # noqa: E501
        'bcc_recipient_addresses': 'bccRecipientAddresses',  # noqa: E501
        'received_start_time_secs': 'receivedStartTimeSecs',  # noqa: E501
        'received_end_time_secs': 'receivedEndTimeSecs',  # noqa: E501
        'email_subject': 'emailSubject',  # noqa: E501
        'folder_names': 'folderNames',  # noqa: E501
        'source_environment': 'sourceEnvironment',  # noqa: E501
        'created_start_time_secs': 'createdStartTimeSecs',  # noqa: E501
        'created_end_time_secs': 'createdEndTimeSecs',  # noqa: E501
        'last_modified_start_time_secs': 'lastModifiedStartTimeSecs',  # noqa: E501
        'last_modified_end_time_secs': 'lastModifiedEndTimeSecs',  # noqa: E501
        'organizer_address': 'organizerAddress',  # noqa: E501
        'attendees_addresses': 'attendeesAddresses',  # noqa: E501
        'first_name': 'firstName',  # noqa: E501
        'middle_name': 'middleName',  # noqa: E501
        'last_name': 'lastName',  # noqa: E501
        'email_address': 'emailAddress',  # noqa: E501
        'due_date_start_time_secs': 'dueDateStartTimeSecs',  # noqa: E501
        'due_date_end_time_secs': 'dueDateEndTimeSecs',  # noqa: E501
        'task_status_types': 'taskStatusTypes',  # noqa: E501
        'o365_params': 'o365Params',  # noqa: E501
    }

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """EmailHeliosSearchParams - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)

            types ([str], none_type): Specifies a list of mailbox item types. Only items within the given types will be returned.. [optional]  # noqa: E501
            has_attachment (bool, none_type): Filters the emails which have attachment.. [optional]  # noqa: E501
            sender_address (str, none_type): Filters the emails which are received from specified User's email address.. [optional]  # noqa: E501
            recipient_addresses ([str], none_type): Filters the emails which are sent to specified email addresses.. [optional]  # noqa: E501
            cc_recipient_addresses ([str], none_type): Filters the emails which are sent to specified email addresses in CC.. [optional]  # noqa: E501
            bcc_recipient_addresses ([str], none_type): Filters the emails which are sent to specified email addresses in BCC.. [optional]  # noqa: E501
            received_start_time_secs (int, none_type): Specifies the start time in Unix timestamp epoch in seconds where the received time of the email is more than specified value.. [optional]  # noqa: E501
            received_end_time_secs (int, none_type): Specifies the end time in Unix timestamp epoch in seconds where the received time of the email is less than specified value.. [optional]  # noqa: E501
            email_subject (str, none_type): Filters the emails which have the specified text in its subject.. [optional]  # noqa: E501
            folder_names ([str], none_type): Filters the emails which are categorized to specified folders.. [optional]  # noqa: E501
            source_environment (str, none_type): Specifies the source environment.. [optional] if omitted the server will use the default value of "kO365"  # noqa: E501
            created_start_time_secs (int, none_type): Specifies the start time in Unix timestamp epoch in seconds where the created time of the email/item is more than specified value.. [optional]  # noqa: E501
            created_end_time_secs (int, none_type): Specifies the end time in Unix timestamp epoch in seconds where the created time of the email/item is less than specified value.. [optional]  # noqa: E501
            last_modified_start_time_secs (int, none_type): Specifies the start time in Unix timestamp epoch in seconds where the last modification time of the email/item is more than specified value.. [optional]  # noqa: E501
            last_modified_end_time_secs (int, none_type): Specifies the end time in Unix timestamp epoch in seconds where the last modification time of the email/item is less than specified value.. [optional]  # noqa: E501
            organizer_address (str, none_type): Filters the calendar items which are organized by specified User's email address.. [optional]  # noqa: E501
            attendees_addresses ([str], none_type): Filters the calendar items which have specified email addresses as attendees.. [optional]  # noqa: E501
            first_name (str, none_type): Filters the contacts with specified text in first name.. [optional]  # noqa: E501
            middle_name (str, none_type): Filters the contacts with specified text in middle name.. [optional]  # noqa: E501
            last_name (str, none_type): Filters the contacts with specified text in last name.. [optional]  # noqa: E501
            email_address (str, none_type): Filters the contact items which have specified text in email address.. [optional]  # noqa: E501
            due_date_start_time_secs (int, none_type): Specifies the start time in Unix timestamp epoch in seconds where the last modification time of the email/item is more than specified value.. [optional]  # noqa: E501
            due_date_end_time_secs (int, none_type): Specifies the end time in Unix timestamp epoch in seconds where the last modification time of the email/item is less than specified value.. [optional]  # noqa: E501
            task_status_types ([str], none_type): Specifies a list of task item status types. Task items having status within the given types will be returned.. [optional]  # noqa: E501
            o365_params ([O365HeliosSearchEmailsRequestParams], none_type): Specifies the O365 specific params to search emails.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)


        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
        }
        model_args = {}
        model_args.update(required_args)
        model_args.update(kwargs)
        composed_info = validate_get_composed_info(
            constant_args, model_args, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        unused_args = composed_info[3]

        for var_name, var_value in required_args.items():
            setattr(self, var_name, var_value)
        for var_name, var_value in kwargs.items():
            if var_name in unused_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        not self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)


    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error beause the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              EmailHeliosSearchParamsAllOf,
              SearchEmailRequestParamsBase,
          ],
          'oneOf': [
          ],
        }

