"""
    Cohesity REST API

    Cohesity API provides a RESTful interface to access the various data management operations on Cohesity cluster and Helios.  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cohesity_sdk.cluster.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from cohesity_sdk.cluster.model.object_summary import ObjectSummary
    globals()['ObjectSummary'] = ObjectSummary


class EmailAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.

      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.

    """

    allowed_values = {
        ('type',): {
            'None': None,
            'EMAIL': "Email",
            'FOLDER': "Folder",
            'CALENDAR': "Calendar",
            'CONTACT': "Contact",
            'TASK': "Task",
            'NOTE': "Note",
        },
        ('task_status',): {
            'None': None,
            'NOTSTARTED': "NotStarted",
            'INPROGRESS': "InProgress",
            'COMPLETED': "Completed",
            'WAITINGONOTHERS': "WaitingOnOthers",
            'DEFERRED': "Deferred",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (str, none_type,),  # noqa: E501
            'user_object_info': (ObjectSummary,),  # noqa: E501
            'folder_name': (str, none_type,),  # noqa: E501
            'parent_folder_id': (int, none_type,),  # noqa: E501
            'path': (str, none_type,),  # noqa: E501
            'directory_path': (str, none_type,),  # noqa: E501
            'type': (str, none_type,),  # noqa: E501
            'email_subject': (str, none_type,),  # noqa: E501
            'has_attachment': (bool, none_type,),  # noqa: E501
            'sender_address': (str, none_type,),  # noqa: E501
            'recipient_addresses': ([str], none_type,),  # noqa: E501
            'cc_recipient_addresses': ([str], none_type,),  # noqa: E501
            'bcc_recipient_addresses': ([str], none_type,),  # noqa: E501
            'sent_time_secs': (int, none_type,),  # noqa: E501
            'received_time_secs': (int, none_type,),  # noqa: E501
            'created_time_secs': (int, none_type,),  # noqa: E501
            'organizer_address': (str, none_type,),  # noqa: E501
            'required_attendees_addresses': ([str], none_type,),  # noqa: E501
            'optional_attendees_addresses': ([str], none_type,),  # noqa: E501
            'first_name': (str, none_type,),  # noqa: E501
            'last_name': (str, none_type,),  # noqa: E501
            'email_addresses': ([str], none_type,),  # noqa: E501
            'last_modification_time_secs': (int, none_type,),  # noqa: E501
            'last_modification_name': (str, none_type,),  # noqa: E501
            'task_due_date_time_secs': (int, none_type,),  # noqa: E501
            'task_completion_date_time_secs': (int, none_type,),  # noqa: E501
            'task_status': (str, none_type,),  # noqa: E501
            'protection_group_id': (str, none_type,),  # noqa: E501
            'protection_group_name': (str, none_type,),  # noqa: E501
            'storage_domain_id': (int, none_type,),  # noqa: E501
            'tenant_id': (str, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'id': 'id',  # noqa: E501
        'user_object_info': 'userObjectInfo',  # noqa: E501
        'folder_name': 'folderName',  # noqa: E501
        'parent_folder_id': 'parentFolderId',  # noqa: E501
        'path': 'path',  # noqa: E501
        'directory_path': 'directoryPath',  # noqa: E501
        'type': 'type',  # noqa: E501
        'email_subject': 'emailSubject',  # noqa: E501
        'has_attachment': 'hasAttachment',  # noqa: E501
        'sender_address': 'senderAddress',  # noqa: E501
        'recipient_addresses': 'recipientAddresses',  # noqa: E501
        'cc_recipient_addresses': 'ccRecipientAddresses',  # noqa: E501
        'bcc_recipient_addresses': 'bccRecipientAddresses',  # noqa: E501
        'sent_time_secs': 'sentTimeSecs',  # noqa: E501
        'received_time_secs': 'receivedTimeSecs',  # noqa: E501
        'created_time_secs': 'createdTimeSecs',  # noqa: E501
        'organizer_address': 'organizerAddress',  # noqa: E501
        'required_attendees_addresses': 'requiredAttendeesAddresses',  # noqa: E501
        'optional_attendees_addresses': 'optionalAttendeesAddresses',  # noqa: E501
        'first_name': 'firstName',  # noqa: E501
        'last_name': 'lastName',  # noqa: E501
        'email_addresses': 'emailAddresses',  # noqa: E501
        'last_modification_time_secs': 'lastModificationTimeSecs',  # noqa: E501
        'last_modification_name': 'lastModificationName',  # noqa: E501
        'task_due_date_time_secs': 'taskDueDateTimeSecs',  # noqa: E501
        'task_completion_date_time_secs': 'taskCompletionDateTimeSecs',  # noqa: E501
        'task_status': 'taskStatus',  # noqa: E501
        'protection_group_id': 'protectionGroupId',  # noqa: E501
        'protection_group_name': 'protectionGroupName',  # noqa: E501
        'storage_domain_id': 'storageDomainId',  # noqa: E501
        'tenant_id': 'tenantId',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """EmailAllOf - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)

            id (str, none_type): Specifies the id of the email object.. [optional]  # noqa: E501
            user_object_info (ObjectSummary): [optional]  # noqa: E501
            folder_name (str, none_type): Specify the name of the email folder.. [optional]  # noqa: E501
            parent_folder_id (int, none_type): Specifies the id of parent folder the mailbox item.. [optional]  # noqa: E501
            path (str, none_type): Specifies the path to this mailbox item.. [optional]  # noqa: E501
            directory_path (str, none_type): Specifies the directory path to this mailbox item.. [optional]  # noqa: E501
            type (str, none_type): Specifies the Mailbox item type.. [optional]  # noqa: E501
            email_subject (str, none_type): Specifies the subject of this email.. [optional]  # noqa: E501
            has_attachment (bool, none_type): Specifies whether email has an attachment.. [optional]  # noqa: E501
            sender_address (str, none_type): Specifies the sender's email address.. [optional]  # noqa: E501
            recipient_addresses ([str], none_type): \"Specifies the email addresses of all receipients of this email.\". [optional]  # noqa: E501
            cc_recipient_addresses ([str], none_type): \"Specifies the email addresses of all the CC receipients of this email.\". [optional]  # noqa: E501
            bcc_recipient_addresses ([str], none_type): \"Specifies the email addresses of all the BCC receipients of this email.\". [optional]  # noqa: E501
            sent_time_secs (int, none_type): \"Specifies the Unix timestamp epoch in seconds at which this email is sent.\". [optional]  # noqa: E501
            received_time_secs (int, none_type): \"Specifies the Unix timestamp epoch in seconds at which this email is received.\". [optional]  # noqa: E501
            created_time_secs (int, none_type): \"Specifies the Unix timestamp epoch in seconds at which this item is created.\". [optional]  # noqa: E501
            organizer_address (str, none_type): \"Specifies the calendar item organizer's email address.\". [optional]  # noqa: E501
            required_attendees_addresses ([str], none_type): \"Specifies the email addresses of all required attendees of this calendar item.\". [optional]  # noqa: E501
            optional_attendees_addresses ([str], none_type): \"Specifies the email addresses of all the optional attendees of this calendar item.\". [optional]  # noqa: E501
            first_name (str, none_type): Specifies the contact's first name.. [optional]  # noqa: E501
            last_name (str, none_type): Specifies the contact's last name.. [optional]  # noqa: E501
            email_addresses ([str], none_type): Specifies the email addresses of a contact.. [optional]  # noqa: E501
            last_modification_time_secs (int, none_type): \"Specifies the Unix timestamp epoch in seconds at which this item was modified.\". [optional]  # noqa: E501
            last_modification_name (str, none_type): \"Specifies the name of the person who modified this item.\". [optional]  # noqa: E501
            task_due_date_time_secs (int, none_type): \"Specifies the Unix timestamp epoch in seconds at which this task item is due.\". [optional]  # noqa: E501
            task_completion_date_time_secs (int, none_type): \"Specifies the Unix timestamp epoch in seconds at which this task item was completed.\". [optional]  # noqa: E501
            task_status (str, none_type): Specifies the task item status type.. [optional]  # noqa: E501
            protection_group_id (str, none_type): \"Specifies the Protection Group id protecting the mailbox.\". [optional]  # noqa: E501
            protection_group_name (str, none_type): \"Specifies the Protection Group name protecting the mailbox item.\". [optional]  # noqa: E501
            storage_domain_id (int, none_type): \"Specifies the Storage Domain id where the backup data of Object is present.\". [optional]  # noqa: E501
            tenant_id (str, none_type): \"Specify the tenant id to which this email belongs to.\". [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)


        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)


