"""
    Cohesity REST API

    Cohesity API provides a RESTful interface to access the various data management operations on Cohesity cluster and Helios.  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cohesity_sdk.cluster.api_client import ApiClient, Endpoint as _Endpoint
from cohesity_sdk.cluster.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cohesity_sdk.cluster.model.common_tdm_task_request_params706da1b2_bba84e7d85383f4309898623 import CommonTdmTaskRequestParams706da1b2Bba84e7d85383f4309898623
from cohesity_sdk.cluster.model.common_tdm_task_response_paramsecdb6214_b7d84c11_b5e2_eafd0cfa820f import CommonTdmTaskResponseParamsecdb6214B7d84c11B5e2Eafd0cfa820f
from cohesity_sdk.cluster.model.error import Error
from cohesity_sdk.cluster.model.perform_action_on_clones_request import PerformActionOnClonesRequest
from cohesity_sdk.cluster.model.tdm_object import TdmObject
from cohesity_sdk.cluster.model.tdm_object_timeline_events import TdmObjectTimelineEvents
from cohesity_sdk.cluster.model.tdm_objects import TdmObjects
from cohesity_sdk.cluster.model.tdm_snapshot import TdmSnapshot
from cohesity_sdk.cluster.model.tdm_task import TdmTask
from cohesity_sdk.cluster.model.tdm_tasks import TdmTasks
from cohesity_sdk.cluster.model.update_tdm_snapshot_request import UpdateTdmSnapshotRequest


class TestDataManagementApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_tdm_task(
            self,
            body,
            **kwargs
        ):
            """Create a TDM task  # noqa: E501

            Create a task for the Test Data Management (TDM) workflow.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_tdm_task(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (CommonTdmTaskRequestParams706da1b2Bba84e7d85383f4309898623): Specifies the parameters to create a TDM task.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CommonTdmTaskResponseParamsecdb6214B7d84c11B5e2Eafd0cfa820f
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.create_tdm_task = _Endpoint(
            settings={
                'response_type': (CommonTdmTaskResponseParamsecdb6214B7d84c11B5e2Eafd0cfa820f,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/tdm/tasks',
                'operation_id': 'create_tdm_task',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (CommonTdmTaskRequestParams706da1b2Bba84e7d85383f4309898623,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_tdm_task
        )

        def __delete_tdm_snapshot_by_id(
            self,
            id,
            **kwargs
        ):
            """Delete a snapshot by ID  # noqa: E501

            Delete a snapshot by specifying its ID.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_tdm_snapshot_by_id(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies the ID of the snapshot.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.delete_tdm_snapshot_by_id = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/tdm/snapshots/{id}',
                'operation_id': 'delete_tdm_snapshot_by_id',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_tdm_snapshot_by_id
        )

        def __get_tdm_object_by_id(
            self,
            id,
            **kwargs
        ):
            """Get TDM object by ID  # noqa: E501

            Get a TDM object by specifying its ID.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tdm_object_by_id(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies the ID of the TDM object.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TdmObject
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_tdm_object_by_id = _Endpoint(
            settings={
                'response_type': (TdmObject,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/tdm/objects/{id}',
                'operation_id': 'get_tdm_object_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_tdm_object_by_id
        )

        def __get_tdm_objects(
            self,
            **kwargs
        ):
            """Get all TDM objects  # noqa: E501

            Get all TDM objects matching specified optional filter criteria.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tdm_objects(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                ids ([str]): Get the objects matching specifies IDs.. [optional]
                environments ([str]): Get the objects matching specified environments.. [optional]
                name (str): Get the objects matching specified name.. [optional]
                task_ids ([str]): Get the objects belonging to the specified TDM task IDs.. [optional]
                statuses ([str]): Get the objects matching specified statuses.. [optional]
                pagination_cookie (str): Get the next set of objects by specifying the cookie string, as received from the server in the last call.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TdmObjects
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_tdm_objects = _Endpoint(
            settings={
                'response_type': (TdmObjects,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/tdm/objects',
                'operation_id': 'get_tdm_objects',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ids',
                    'environments',
                    'name',
                    'task_ids',
                    'statuses',
                    'pagination_cookie',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'environments',
                    'statuses',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('environments',): {

                        "KSQL": "kSQL",
                        "KORACLE": "kOracle"
                    },
                    ('statuses',): {

                        "SCHEDULED": "scheduled",
                        "INPROGRESS": "inProgress",
                        "SUCCEEDED": "succeeded",
                        "FAILED": "failed",
                        "CANCELED": "canceled"
                    },
                },
                'openapi_types': {
                    'ids':
                        ([str],),
                    'environments':
                        ([str],),
                    'name':
                        (str,),
                    'task_ids':
                        ([str],),
                    'statuses':
                        ([str],),
                    'pagination_cookie':
                        (str,),
                },
                'attribute_map': {
                    'ids': 'ids',
                    'environments': 'environments',
                    'name': 'name',
                    'task_ids': 'taskIds',
                    'statuses': 'statuses',
                    'pagination_cookie': 'paginationCookie',
                },
                'location_map': {
                    'ids': 'query',
                    'environments': 'query',
                    'name': 'query',
                    'task_ids': 'query',
                    'statuses': 'query',
                    'pagination_cookie': 'query',
                },
                'collection_format_map': {
                    'ids': 'csv',
                    'environments': 'csv',
                    'task_ids': 'csv',
                    'statuses': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_tdm_objects
        )

        def __get_tdm_task_by_id(
            self,
            id,
            **kwargs
        ):
            """Get a TDM task by ID  # noqa: E501

            Get a TDM task by ID.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tdm_task_by_id(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies the ID of the TDM task.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TdmTask
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_tdm_task_by_id = _Endpoint(
            settings={
                'response_type': (TdmTask,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/tdm/tasks/{id}',
                'operation_id': 'get_tdm_task_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_tdm_task_by_id
        )

        def __get_tdm_tasks(
            self,
            **kwargs
        ):
            """Get all TDM tasks  # noqa: E501

            Get all the TDM tasks matching specified optional filter criteria.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tdm_tasks(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                ids ([str]): Get the tasks matching specified IDs.. [optional]
                actions ([str]): Get the tasks matching specified actions.. [optional]
                environments ([str]): Get the tasks matching specified environments.. [optional]
                created_after_usecs (int): Get the tasks created after the specified time (in usecs from epoch).. [optional]
                created_before_usecs (int): Get the tasks created before the specified time (in usecs from epoch).. [optional]
                statuses ([str]): Get the tasks matching specified statuses.. [optional]
                object_ids ([str]): Get the tasks for the specified TDM object IDs.. [optional]
                pagination_cookie (str): Get the next set of tasks by specifying the cookie string, as received from the server in the last call.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TdmTasks
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_tdm_tasks = _Endpoint(
            settings={
                'response_type': (TdmTasks,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/tdm/tasks',
                'operation_id': 'get_tdm_tasks',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ids',
                    'actions',
                    'environments',
                    'created_after_usecs',
                    'created_before_usecs',
                    'statuses',
                    'object_ids',
                    'pagination_cookie',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'actions',
                    'environments',
                    'statuses',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('actions',): {

                        "CLONE": "clone",
                        "TEARDOWN": "teardown",
                        "REFRESH": "refresh",
                        "SNAPSHOT": "snapshot",
                        "REWIND": "rewind"
                    },
                    ('environments',): {

                        "KSQL": "kSQL",
                        "KORACLE": "kOracle"
                    },
                    ('statuses',): {

                        "SCHEDULED": "scheduled",
                        "INPROGRESS": "inProgress",
                        "SUCCEEDED": "succeeded",
                        "FAILED": "failed",
                        "CANCELED": "canceled"
                    },
                },
                'openapi_types': {
                    'ids':
                        ([str],),
                    'actions':
                        ([str],),
                    'environments':
                        ([str],),
                    'created_after_usecs':
                        (int,),
                    'created_before_usecs':
                        (int,),
                    'statuses':
                        ([str],),
                    'object_ids':
                        ([str],),
                    'pagination_cookie':
                        (str,),
                },
                'attribute_map': {
                    'ids': 'ids',
                    'actions': 'actions',
                    'environments': 'environments',
                    'created_after_usecs': 'createdAfterUsecs',
                    'created_before_usecs': 'createdBeforeUsecs',
                    'statuses': 'statuses',
                    'object_ids': 'objectIds',
                    'pagination_cookie': 'paginationCookie',
                },
                'location_map': {
                    'ids': 'query',
                    'actions': 'query',
                    'environments': 'query',
                    'created_after_usecs': 'query',
                    'created_before_usecs': 'query',
                    'statuses': 'query',
                    'object_ids': 'query',
                    'pagination_cookie': 'query',
                },
                'collection_format_map': {
                    'ids': 'csv',
                    'actions': 'csv',
                    'environments': 'csv',
                    'statuses': 'csv',
                    'object_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_tdm_tasks
        )

        def __get_tdm_timeline_events_by_object_id(
            self,
            id,
            **kwargs
        ):
            """Get timeline events of object  # noqa: E501

            Get the collection of timeline events of a TDM object by specifying its ID.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tdm_timeline_events_by_object_id(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies the ID of the TDM object.

            Keyword Args:
                created_after (int): Get the events created after the specified time (in usecs from epoch).. [optional]
                created_before (int): Get the events created before the specified time (in usecs from epoch).. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TdmObjectTimelineEvents
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_tdm_timeline_events_by_object_id = _Endpoint(
            settings={
                'response_type': (TdmObjectTimelineEvents,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/tdm/objects/{id}/timeline-events',
                'operation_id': 'get_tdm_timeline_events_by_object_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'created_after',
                    'created_before',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'created_after':
                        (int,),
                    'created_before':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                    'created_after': 'createdAfter',
                    'created_before': 'createdBefore',
                },
                'location_map': {
                    'id': 'path',
                    'created_after': 'query',
                    'created_before': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_tdm_timeline_events_by_object_id
        )

        def __perform_action_on_clones(
            self,
            body,
            **kwargs
        ):
            """Perform actions on clones  # noqa: E501

            Performs various actions on clones. Supports actions on multiple clones.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.perform_action_on_clones(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (PerformActionOnClonesRequest): Specifies the parameters to perform an action on multiple clones.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.perform_action_on_clones = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/tdm/clones/actions',
                'operation_id': 'perform_action_on_clones',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (PerformActionOnClonesRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__perform_action_on_clones
        )

        def __update_tdm_snapshot_by_id(
            self,
            id,
            body,
            **kwargs
        ):
            """Update a snapshot by ID  # noqa: E501

            Update the details of a snapshot by specifying its ID.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_tdm_snapshot_by_id(id, body, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies the ID of the snapshot.
                body (UpdateTdmSnapshotRequest): Specifies the parameters to update the snapshot.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TdmSnapshot
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_tdm_snapshot_by_id = _Endpoint(
            settings={
                'response_type': (TdmSnapshot,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/tdm/snapshots/{id}',
                'operation_id': 'update_tdm_snapshot_by_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'body',
                ],
                'required': [
                    'id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'body':
                        (UpdateTdmSnapshotRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_tdm_snapshot_by_id
        )
