"""
    Cohesity REST API

    Cohesity API provides a RESTful interface to access the various data management operations on Cohesity cluster and Helios.  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cohesity_sdk.cluster.api_client import ApiClient, Endpoint as _Endpoint
from cohesity_sdk.cluster.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cohesity_sdk.cluster.model.common_search_indexed_objects_request_paramse820baa78991407c9d7d87296ca195fd import CommonSearchIndexedObjectsRequestParamse820baa78991407c9d7d87296ca195fd
from cohesity_sdk.cluster.model.common_search_indexed_objects_response_params53a94a3678b441c88505_c186d1bcc3e7 import CommonSearchIndexedObjectsResponseParams53a94a3678b441c88505C186d1bcc3e7
from cohesity_sdk.cluster.model.error import Error
from cohesity_sdk.cluster.model.objects_search_response_body import ObjectsSearchResponseBody
from cohesity_sdk.cluster.model.protected_objects_search_response_body import ProtectedObjectsSearchResponseBody


class SearchApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __search_indexed_objects(
            self,
            body,
            **kwargs
        ):
            """List indexed objects.  # noqa: E501

            List all the indexed objects like files and folders, emails, mailboxes etc., that match the specified search and filter criteria from protected objects.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_indexed_objects(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (CommonSearchIndexedObjectsRequestParamse820baa78991407c9d7d87296ca195fd): Specifies the parameters to search for indexed objects.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CommonSearchIndexedObjectsResponseParams53a94a3678b441c88505C186d1bcc3e7
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.search_indexed_objects = _Endpoint(
            settings={
                'response_type': (CommonSearchIndexedObjectsResponseParams53a94a3678b441c88505C186d1bcc3e7,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/search/indexed-objects',
                'operation_id': 'search_indexed_objects',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (CommonSearchIndexedObjectsRequestParamse820baa78991407c9d7d87296ca195fd,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_indexed_objects
        )

        def __search_objects(
            self,
            **kwargs
        ):
            """List Objects.  # noqa: E501

            List objects.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_objects(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                request_initiator_type (str): Specifies the type of request from UI, which is used for services like magneto to determine the priority of requests.. [optional]
                search_string (str): Specifies the search string to filter the objects. This search string will be applicable for objectnames. User can specify a wildcard character '*' as a suffix to a string where all object names are matched with the prefix string. For example, if vm1 and vm2 are the names of objects, user can specify vm* to list the objects. If not specified, then all the objects will be returned which will match other filtering criteria.. [optional]
                environments ([str]): Specifies the environment type to filter objects.. [optional]
                protection_types ([str]): Specifies the protection type to filter objects.. [optional]
                tenant_ids ([str]): TenantIds contains ids of the tenants for which objects are to be returned.. [optional]
                include_tenants (bool): If true, the response will include Objects which belongs to all tenants which the current user has permission to see.. [optional]
                protection_group_ids ([str]): Specifies a list of Protection Group ids to filter the objects. If specified, the objects protected by specified Protection Group ids will be returned.. [optional]
                object_ids ([int]): Specifies a list of Object ids to filter.. [optional]
                os_types ([str]): Specifies the operating system types to filter objects on.. [optional]
                o365_object_types ([str]): Specifies the object types to filter objects on. Only applicable if the environment is o365.. [optional]
                source_ids ([int]): Specifies a list of Protection Source object ids to filter the objects. If specified, the object which are present in those Sources will be returned.. [optional]
                source_uuids ([str]): Specifies a list of Protection Source object uuids to filter the objects. If specified, the object which are present in those Sources will be returned.. [optional]
                is_protected (bool): Specifies the protection status of objects. If set to true, only protected objects will be returned. If set to false, only unprotected objects will be returned. If not specified, all objects will be returned.. [optional]
                is_deleted (bool): If set to true, then objects which are deleted on atleast one cluster will be returned. If not set or set to false then objects which are registered on atleast one cluster are returned.. [optional]
                last_run_status_list ([str]): Specifies a list of status of the object's last protection run. Only objects with last run status of these will be returned.. [optional]
                region_ids ([str]): Specifies a list of region ids. Only records from clusters having these region ids will be returned.. [optional]
                cluster_identifiers ([str]): Specifies the list of cluster identifiers. Format is clusterId:clusterIncarnationId. Only records from clusters having these identifiers will be returned.. [optional]
                storage_domain_ids ([str]): Specifies the list of storage domain ids. Format is clusterId:clusterIncarnationId:storageDomainId. Only objects having protection in these storage domains will be returned.. [optional]
                include_deleted_objects (bool): Specifies whether to include deleted objects in response. These objects can't be protected but can be recovered. This field is deprecated.. [optional]
                pagination_cookie (str): Specifies the pagination cookie with which subsequent parts of the response can be fetched.. [optional]
                count (int): Specifies the number of objects to be fetched for the specified pagination cookie.. [optional]
                must_have_tag_ids ([str]): Specifies tags which must be all present in the document.. [optional]
                might_have_tag_ids ([str]): Specifies list of tags, one or more of which might be present in the document. These are OR'ed together and the resulting criteria AND'ed with the rest of the query.. [optional]
                must_have_snapshot_tag_ids ([str]): Specifies snapshot tags which must be all present in the document.. [optional]
                might_have_snapshot_tag_ids ([str]): Specifies list of snapshot tags, one or more of which might be present in the document. These are OR'ed together and the resulting criteria AND'ed with the rest of the query.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjectsSearchResponseBody
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_objects = _Endpoint(
            settings={
                'response_type': (ObjectsSearchResponseBody,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/search/objects',
                'operation_id': 'search_objects',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'request_initiator_type',
                    'search_string',
                    'environments',
                    'protection_types',
                    'tenant_ids',
                    'include_tenants',
                    'protection_group_ids',
                    'object_ids',
                    'os_types',
                    'o365_object_types',
                    'source_ids',
                    'source_uuids',
                    'is_protected',
                    'is_deleted',
                    'last_run_status_list',
                    'region_ids',
                    'cluster_identifiers',
                    'storage_domain_ids',
                    'include_deleted_objects',
                    'pagination_cookie',
                    'count',
                    'must_have_tag_ids',
                    'might_have_tag_ids',
                    'must_have_snapshot_tag_ids',
                    'might_have_snapshot_tag_ids',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'request_initiator_type',
                    'environments',
                    'protection_types',
                    'os_types',
                    'o365_object_types',
                    'last_run_status_list',
                ],
                'validation': [
                    'environments',
                    'protection_types',
                    'must_have_tag_ids',
                    'might_have_tag_ids',
                    'must_have_snapshot_tag_ids',
                    'might_have_snapshot_tag_ids',
                ]
            },
            root_map={
                'validations': {
                    ('environments',): {

                    },
                    ('protection_types',): {

                    },
                    ('must_have_tag_ids',): {

                    },
                    ('might_have_tag_ids',): {

                    },
                    ('must_have_snapshot_tag_ids',): {

                    },
                    ('might_have_snapshot_tag_ids',): {

                    },
                },
                'allowed_values': {
                    ('request_initiator_type',): {

                        "UIUSER": "UIUser",
                        "UIAUTO": "UIAuto"
                    },
                    ('environments',): {

                        "KVMWARE": "kVMware",
                        "KHYPERV": "kHyperV",
                        "KAZURE": "kAzure",
                        "KKVM": "kKVM",
                        "KAWS": "kAWS",
                        "KACROPOLIS": "kAcropolis",
                        "KGCP": "kGCP",
                        "KPHYSICAL": "kPhysical",
                        "KPHYSICALFILES": "kPhysicalFiles",
                        "KISILON": "kIsilon",
                        "KNETAPP": "kNetapp",
                        "KGENERICNAS": "kGenericNas",
                        "KFLASHBLADE": "kFlashBlade",
                        "KELASTIFILE": "kElastifile",
                        "KGPFS": "kGPFS",
                        "KPURE": "kPure",
                        "KNIMBLE": "kNimble",
                        "KSQL": "kSQL",
                        "KORACLE": "kOracle",
                        "KEXCHANGE": "kExchange",
                        "KAD": "kAD",
                        "KVIEW": "kView",
                        "KO365": "kO365",
                        "KHYPERFLEX": "kHyperFlex",
                        "KKUBERNETES": "kKubernetes",
                        "KCASSANDRA": "kCassandra",
                        "KMONGODB": "kMongoDB",
                        "KCOUCHBASE": "kCouchbase",
                        "KHDFS": "kHdfs",
                        "KHIVE": "kHive",
                        "KHBASE": "kHBase",
                        "KUDA": "kUDA",
                        "KSFDC": "kSfdc"
                    },
                    ('protection_types',): {

                        "KAGENT": "kAgent",
                        "KNATIVE": "kNative",
                        "KSNAPSHOTMANAGER": "kSnapshotManager",
                        "KRDSSNAPSHOTMANAGER": "kRDSSnapshotManager",
                        "KAURORASNAPSHOTMANAGER": "kAuroraSnapshotManager",
                        "KFILE": "kFile",
                        "KVOLUME": "kVolume"
                    },
                    ('os_types',): {

                        "KLINUX": "kLinux",
                        "KWINDOWS": "kWindows",
                        "KAIX": "kAix",
                        "KSOLARIS": "kSolaris",
                        "KSAPHANA": "kSapHana",
                        "KOTHER": "kOther",
                        "KHPUX": "kHPUX"
                    },
                    ('o365_object_types',): {

                        "KDOMAIN": "kDomain",
                        "KOUTLOOK": "kOutlook",
                        "KMAILBOX": "kMailbox",
                        "KUSERS": "kUsers",
                        "KGROUPS": "kGroups",
                        "KSITES": "kSites",
                        "KUSER": "kUser",
                        "KGROUP": "kGroup",
                        "KSITE": "kSite",
                        "KAPPLICATION": "kApplication",
                        "KGRAPHUSER": "kGraphUser",
                        "KPUBLICFOLDERS": "kPublicFolders",
                        "KPUBLICFOLDER": "kPublicFolder",
                        "KTEAMS": "kTeams",
                        "KTEAM": "kTeam",
                        "KROOTPUBLICFOLDER": "kRootPublicFolder",
                        "KO365EXCHANGE": "kO365Exchange",
                        "KO365ONEDRIVE": "kO365OneDrive",
                        "KO365SHAREPOINT": "kO365Sharepoint"
                    },
                    ('last_run_status_list',): {

                        "ACCEPTED": "Accepted",
                        "RUNNING": "Running",
                        "CANCELED": "Canceled",
                        "CANCELING": "Canceling",
                        "FAILED": "Failed",
                        "MISSED": "Missed",
                        "SUCCEEDED": "Succeeded",
                        "SUCCEEDEDWITHWARNING": "SucceededWithWarning",
                        "ONHOLD": "OnHold",
                        "FINALIZING": "Finalizing"
                    },
                },
                'openapi_types': {
                    'request_initiator_type':
                        (str,),
                    'search_string':
                        (str,),
                    'environments':
                        ([str],),
                    'protection_types':
                        ([str],),
                    'tenant_ids':
                        ([str],),
                    'include_tenants':
                        (bool,),
                    'protection_group_ids':
                        ([str],),
                    'object_ids':
                        ([int],),
                    'os_types':
                        ([str],),
                    'o365_object_types':
                        ([str],),
                    'source_ids':
                        ([int],),
                    'source_uuids':
                        ([str],),
                    'is_protected':
                        (bool,),
                    'is_deleted':
                        (bool,),
                    'last_run_status_list':
                        ([str],),
                    'region_ids':
                        ([str],),
                    'cluster_identifiers':
                        ([str],),
                    'storage_domain_ids':
                        ([str],),
                    'include_deleted_objects':
                        (bool,),
                    'pagination_cookie':
                        (str,),
                    'count':
                        (int,),
                    'must_have_tag_ids':
                        ([str],),
                    'might_have_tag_ids':
                        ([str],),
                    'must_have_snapshot_tag_ids':
                        ([str],),
                    'might_have_snapshot_tag_ids':
                        ([str],),
                },
                'attribute_map': {
                    'request_initiator_type': 'requestInitiatorType',
                    'search_string': 'searchString',
                    'environments': 'environments',
                    'protection_types': 'protectionTypes',
                    'tenant_ids': 'tenantIds',
                    'include_tenants': 'includeTenants',
                    'protection_group_ids': 'protectionGroupIds',
                    'object_ids': 'objectIds',
                    'os_types': 'osTypes',
                    'o365_object_types': 'o365ObjectTypes',
                    'source_ids': 'sourceIds',
                    'source_uuids': 'sourceUuids',
                    'is_protected': 'isProtected',
                    'is_deleted': 'isDeleted',
                    'last_run_status_list': 'lastRunStatusList',
                    'region_ids': 'regionIds',
                    'cluster_identifiers': 'clusterIdentifiers',
                    'storage_domain_ids': 'storageDomainIds',
                    'include_deleted_objects': 'includeDeletedObjects',
                    'pagination_cookie': 'paginationCookie',
                    'count': 'count',
                    'must_have_tag_ids': 'mustHaveTagIds',
                    'might_have_tag_ids': 'mightHaveTagIds',
                    'must_have_snapshot_tag_ids': 'mustHaveSnapshotTagIds',
                    'might_have_snapshot_tag_ids': 'mightHaveSnapshotTagIds',
                },
                'location_map': {
                    'request_initiator_type': 'header',
                    'search_string': 'query',
                    'environments': 'query',
                    'protection_types': 'query',
                    'tenant_ids': 'query',
                    'include_tenants': 'query',
                    'protection_group_ids': 'query',
                    'object_ids': 'query',
                    'os_types': 'query',
                    'o365_object_types': 'query',
                    'source_ids': 'query',
                    'source_uuids': 'query',
                    'is_protected': 'query',
                    'is_deleted': 'query',
                    'last_run_status_list': 'query',
                    'region_ids': 'query',
                    'cluster_identifiers': 'query',
                    'storage_domain_ids': 'query',
                    'include_deleted_objects': 'query',
                    'pagination_cookie': 'query',
                    'count': 'query',
                    'must_have_tag_ids': 'query',
                    'might_have_tag_ids': 'query',
                    'must_have_snapshot_tag_ids': 'query',
                    'might_have_snapshot_tag_ids': 'query',
                },
                'collection_format_map': {
                    'environments': 'csv',
                    'protection_types': 'csv',
                    'tenant_ids': 'csv',
                    'protection_group_ids': 'csv',
                    'object_ids': 'csv',
                    'os_types': 'csv',
                    'o365_object_types': 'csv',
                    'source_ids': 'csv',
                    'source_uuids': 'csv',
                    'last_run_status_list': 'csv',
                    'region_ids': 'csv',
                    'cluster_identifiers': 'csv',
                    'storage_domain_ids': 'csv',
                    'must_have_tag_ids': 'csv',
                    'might_have_tag_ids': 'csv',
                    'must_have_snapshot_tag_ids': 'csv',
                    'might_have_snapshot_tag_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__search_objects
        )

        def __search_protected_objects(
            self,
            **kwargs
        ):
            """List Protected Objects.  # noqa: E501

            List protected objects and corresponding detail information from registered sources filtered by specified query parameters. If no search pattern or filter parameters are specified, all protected objects currently found are returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_protected_objects(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                request_initiator_type (str): Specifies the type of request from UI, which is used for services like magneto to determine the priority of requests.. [optional]
                search_string (str): Specifies the search string to filter the objects. This search string will be applicable for objectnames and Protection Group names. User can specify a wildcard character '*' as a suffix to a string where all object and their Protection Group names are matched with the prefix string. For example, if vm1 and vm2 are the names of objects, user can specify vm* to list the objects. If not specified, then all the objects with Protection Groups will be returned which will match other filtering criteria.. [optional]
                environments ([str]): Specifies the environment type to filter objects.. [optional]
                snapshot_actions ([str]): Specifies a list of recovery actions. Only snapshots that applies to these actions will be returned.. [optional]
                object_action_key (str, none_type): Filter by ObjectActionKey, which uniquely represents protection of an object. An object can be protected in multiple ways but atmost once for a given combination of ObjectActionKey. When specified, latest snapshot info matching the objectActionKey is for corresponding object.. [optional]
                tenant_ids ([str]): TenantIds contains ids of the tenants for which objects are to be returned.. [optional]
                include_tenants (bool): If true, the response will include Objects which belongs to all tenants which the current user has permission to see.. [optional]
                protection_group_ids ([str]): Specifies a list of Protection Group ids to filter the objects. If specified, the objects protected by specified Protection Group ids will be returned.. [optional]
                object_ids ([int]): Specifies a list of Object ids to filter.. [optional]
                storage_domain_ids ([int]): Specifies the Storage Domain ids to filter objects for which Protection Groups are writing data to Cohesity Views on the specified Storage Domains.. [optional]
                sub_result_size (int): Specifies the size of objects to be fetched for a single subresult.. [optional]
                filter_snapshot_from_usecs (int): Specifies the timestamp in Unix time epoch in microseconds to filter the objects if the Object has a successful snapshot after this value.. [optional]
                filter_snapshot_to_usecs (int): Specifies the timestamp in Unix time epoch in microseconds to filter the objects if the Object has a successful snapshot before this value.. [optional]
                os_types ([str]): Specifies the operating system types to filter objects on.. [optional]
                source_ids ([int]): Specifies a list of Protection Source object ids to filter the objects. If specified, the object which are present in those Sources will be returned.. [optional]
                run_instance_ids ([int]): Specifies a list of run instance ids. If specified only objects belonging to the provided run id will be retunrned.. [optional]
                cdp_protected_only (bool): Specifies whether to only return the CDP protected objects.. [optional]
                region_ids ([str]): Specifies a list of region ids. Only records from clusters having these region ids will be returned.. [optional]
                use_cached_data (bool): Specifies whether we can serve the GET request to the read replica cache cache. There is a lag of 15 seconds between the read replica and primary data source.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProtectedObjectsSearchResponseBody
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_protected_objects = _Endpoint(
            settings={
                'response_type': (ProtectedObjectsSearchResponseBody,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/search/protected-objects',
                'operation_id': 'search_protected_objects',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'request_initiator_type',
                    'search_string',
                    'environments',
                    'snapshot_actions',
                    'object_action_key',
                    'tenant_ids',
                    'include_tenants',
                    'protection_group_ids',
                    'object_ids',
                    'storage_domain_ids',
                    'sub_result_size',
                    'filter_snapshot_from_usecs',
                    'filter_snapshot_to_usecs',
                    'os_types',
                    'source_ids',
                    'run_instance_ids',
                    'cdp_protected_only',
                    'region_ids',
                    'use_cached_data',
                ],
                'required': [],
                'nullable': [
                    'object_action_key',
                ],
                'enum': [
                    'request_initiator_type',
                    'environments',
                    'snapshot_actions',
                    'object_action_key',
                    'os_types',
                ],
                'validation': [
                    'environments',
                    'snapshot_actions',
                ]
            },
            root_map={
                'validations': {
                    ('environments',): {

                    },
                    ('snapshot_actions',): {

                    },
                },
                'allowed_values': {
                    ('request_initiator_type',): {

                        "UIUSER": "UIUser",
                        "UIAUTO": "UIAuto"
                    },
                    ('environments',): {

                        "KVMWARE": "kVMware",
                        "KHYPERV": "kHyperV",
                        "KAZURE": "kAzure",
                        "KKVM": "kKVM",
                        "KAWS": "kAWS",
                        "KACROPOLIS": "kAcropolis",
                        "KGCP": "kGCP",
                        "KPHYSICAL": "kPhysical",
                        "KPHYSICALFILES": "kPhysicalFiles",
                        "KISILON": "kIsilon",
                        "KNETAPP": "kNetapp",
                        "KGENERICNAS": "kGenericNas",
                        "KFLASHBLADE": "kFlashBlade",
                        "KELASTIFILE": "kElastifile",
                        "KGPFS": "kGPFS",
                        "KPURE": "kPure",
                        "KNIMBLE": "kNimble",
                        "KSQL": "kSQL",
                        "KORACLE": "kOracle",
                        "KEXCHANGE": "kExchange",
                        "KAD": "kAD",
                        "KVIEW": "kView",
                        "KO365": "kO365",
                        "KHYPERFLEX": "kHyperFlex",
                        "KKUBERNETES": "kKubernetes",
                        "KCASSANDRA": "kCassandra",
                        "KMONGODB": "kMongoDB",
                        "KCOUCHBASE": "kCouchbase",
                        "KHDFS": "kHdfs",
                        "KHIVE": "kHive",
                        "KHBASE": "kHBase",
                        "KUDA": "kUDA",
                        "KSFDC": "kSfdc"
                    },
                    ('snapshot_actions',): {

                        "RECOVERVMS": "RecoverVMs",
                        "RECOVERFILES": "RecoverFiles",
                        "INSTANTVOLUMEMOUNT": "InstantVolumeMount",
                        "RECOVERVMDISKS": "RecoverVmDisks",
                        "MOUNTVOLUMES": "MountVolumes",
                        "RECOVERVAPPS": "RecoverVApps",
                        "RECOVERRDS": "RecoverRDS",
                        "RECOVERAURORA": "RecoverAurora",
                        "RECOVERAPPS": "RecoverApps",
                        "RECOVERNASVOLUME": "RecoverNasVolume",
                        "RECOVERPHYSICALVOLUMES": "RecoverPhysicalVolumes",
                        "RECOVERSYSTEM": "RecoverSystem",
                        "RECOVERSANVOLUMES": "RecoverSanVolumes",
                        "RECOVERNAMESPACES": "RecoverNamespaces",
                        "RECOVEROBJECTS": "RecoverObjects",
                        "DOWNLOADFILESANDFOLDERS": "DownloadFilesAndFolders",
                        "RECOVERPUBLICFOLDERS": "RecoverPublicFolders",
                        "RECOVERVAPPTEMPLATES": "RecoverVAppTemplates",
                        "RECOVERMAILBOX": "RecoverMailbox",
                        "RECOVERONEDRIVE": "RecoverOneDrive",
                        "RECOVERMSTEAM": "RecoverMsTeam",
                        "RECOVERMSGROUP": "RecoverMsGroup",
                        "RECOVERSHAREPOINT": "RecoverSharePoint",
                        "CONVERTTOPST": "ConvertToPst",
                        "RECOVERSFDCRECORDS": "RecoverSfdcRecords"
                    },
                    ('object_action_key',): {
                        'None': None,
                        "KVMWARE": "kVMware",
                        "KHYPERV": "kHyperV",
                        "KVCD": "kVCD",
                        "KAZURE": "kAzure",
                        "KGCP": "kGCP",
                        "KKVM": "kKVM",
                        "KACROPOLIS": "kAcropolis",
                        "KAWS": "kAWS",
                        "KAWSNATIVE": "kAWSNative",
                        "KAWSSNAPSHOTMANAGER": "kAWSSnapshotManager",
                        "KRDSSNAPSHOTMANAGER": "kRDSSnapshotManager",
                        "KAURORASNAPSHOTMANAGER": "kAuroraSnapshotManager",
                        "KPHYSICAL": "kPhysical",
                        "KPHYSICALFILES": "kPhysicalFiles",
                        "KGPFS": "kGPFS",
                        "KELASTIFILE": "kElastifile",
                        "KNETAPP": "kNetapp",
                        "KGENERICNAS": "kGenericNas",
                        "KISILON": "kIsilon",
                        "KFLASHBLADE": "kFlashBlade",
                        "KPURE": "kPure",
                        "KSQL": "kSQL",
                        "KEXCHANGE": "kExchange",
                        "KAD": "kAD",
                        "KORACLE": "kOracle",
                        "KVIEW": "kView",
                        "KREMOTEADAPTER": "kRemoteAdapter",
                        "KO365": "kO365",
                        "KO365PUBLICFOLDERS": "kO365PublicFolders",
                        "KO365TEAMS": "kO365Teams",
                        "KO365GROUP": "kO365Group",
                        "KO365EXCHANGE": "kO365Exchange",
                        "KO365ONEDRIVE": "kO365OneDrive",
                        "KO365SHAREPOINT": "kO365Sharepoint",
                        "KKUBERNETES": "kKubernetes",
                        "KCASSANDRA": "kCassandra",
                        "KMONGODB": "kMongoDB",
                        "KCOUCHBASE": "kCouchbase",
                        "KHDFS": "kHdfs",
                        "KHIVE": "kHive",
                        "KHBASE": "kHBase",
                        "KUDA": "kUDA",
                        "KSFDC": "kSfdc"
                    },
                    ('os_types',): {

                        "KLINUX": "kLinux",
                        "KWINDOWS": "kWindows",
                        "KAIX": "kAix",
                        "KSOLARIS": "kSolaris",
                        "KSAPHANA": "kSapHana",
                        "KOTHER": "kOther",
                        "KHPUX": "kHPUX"
                    },
                },
                'openapi_types': {
                    'request_initiator_type':
                        (str,),
                    'search_string':
                        (str,),
                    'environments':
                        ([str],),
                    'snapshot_actions':
                        ([str],),
                    'object_action_key':
                        (str, none_type,),
                    'tenant_ids':
                        ([str],),
                    'include_tenants':
                        (bool,),
                    'protection_group_ids':
                        ([str],),
                    'object_ids':
                        ([int],),
                    'storage_domain_ids':
                        ([int],),
                    'sub_result_size':
                        (int,),
                    'filter_snapshot_from_usecs':
                        (int,),
                    'filter_snapshot_to_usecs':
                        (int,),
                    'os_types':
                        ([str],),
                    'source_ids':
                        ([int],),
                    'run_instance_ids':
                        ([int],),
                    'cdp_protected_only':
                        (bool,),
                    'region_ids':
                        ([str],),
                    'use_cached_data':
                        (bool,),
                },
                'attribute_map': {
                    'request_initiator_type': 'requestInitiatorType',
                    'search_string': 'searchString',
                    'environments': 'environments',
                    'snapshot_actions': 'snapshotActions',
                    'object_action_key': 'objectActionKey',
                    'tenant_ids': 'tenantIds',
                    'include_tenants': 'includeTenants',
                    'protection_group_ids': 'protectionGroupIds',
                    'object_ids': 'objectIds',
                    'storage_domain_ids': 'storageDomainIds',
                    'sub_result_size': 'subResultSize',
                    'filter_snapshot_from_usecs': 'filterSnapshotFromUsecs',
                    'filter_snapshot_to_usecs': 'filterSnapshotToUsecs',
                    'os_types': 'osTypes',
                    'source_ids': 'sourceIds',
                    'run_instance_ids': 'runInstanceIds',
                    'cdp_protected_only': 'cdpProtectedOnly',
                    'region_ids': 'regionIds',
                    'use_cached_data': 'useCachedData',
                },
                'location_map': {
                    'request_initiator_type': 'header',
                    'search_string': 'query',
                    'environments': 'query',
                    'snapshot_actions': 'query',
                    'object_action_key': 'query',
                    'tenant_ids': 'query',
                    'include_tenants': 'query',
                    'protection_group_ids': 'query',
                    'object_ids': 'query',
                    'storage_domain_ids': 'query',
                    'sub_result_size': 'query',
                    'filter_snapshot_from_usecs': 'query',
                    'filter_snapshot_to_usecs': 'query',
                    'os_types': 'query',
                    'source_ids': 'query',
                    'run_instance_ids': 'query',
                    'cdp_protected_only': 'query',
                    'region_ids': 'query',
                    'use_cached_data': 'query',
                },
                'collection_format_map': {
                    'environments': 'csv',
                    'snapshot_actions': 'csv',
                    'tenant_ids': 'csv',
                    'protection_group_ids': 'csv',
                    'object_ids': 'csv',
                    'storage_domain_ids': 'csv',
                    'os_types': 'csv',
                    'source_ids': 'csv',
                    'run_instance_ids': 'csv',
                    'region_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__search_protected_objects
        )
