"""
    Cohesity REST API

    Cohesity API provides a RESTful interface to access the various data management operations on Cohesity cluster and Helios.  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cohesity_sdk.cluster.api_client import ApiClient, Endpoint as _Endpoint
from cohesity_sdk.cluster.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cohesity_sdk.cluster.model.common_recovery_request_paramsae1b0dbe35e54e869ddd_fd34af026fcb import CommonRecoveryRequestParamsae1b0dbe35e54e869dddFd34af026fcb
from cohesity_sdk.cluster.model.common_recovery_response_params6a8355069c784a8f8fe5_c686344da58c import CommonRecoveryResponseParams6a8355069c784a8f8fe5C686344da58c
from cohesity_sdk.cluster.model.download_files_and_folders_request_params import DownloadFilesAndFoldersRequestParams
from cohesity_sdk.cluster.model.error import Error
from cohesity_sdk.cluster.model.fetch_uptier_data_response import FetchUptierDataResponse
from cohesity_sdk.cluster.model.recoveries import Recoveries
from cohesity_sdk.cluster.model.recovery import Recovery


class RecoveryApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __cancel_recovery_by_id(
            self,
            id,
            **kwargs
        ):
            """Cancel Recovery for a given id.  # noqa: E501

            Cancel Recovery for a given id.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.cancel_recovery_by_id(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies the id of a Recovery.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.cancel_recovery_by_id = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/recoveries/{id}/cancel',
                'operation_id': 'cancel_recovery_by_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^\d+:\d+:\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__cancel_recovery_by_id
        )

        def __create_download_files_and_folders_recovery(
            self,
            body,
            **kwargs
        ):
            """Create a download files and folders recovery.  # noqa: E501

            Creates a download files and folders recovery.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_download_files_and_folders_recovery(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (DownloadFilesAndFoldersRequestParams): Specifies the parameters to create a download files and folder recovery.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Recovery
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.create_download_files_and_folders_recovery = _Endpoint(
            settings={
                'response_type': (Recovery,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/recoveries/download-files-folders',
                'operation_id': 'create_download_files_and_folders_recovery',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (DownloadFilesAndFoldersRequestParams,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_download_files_and_folders_recovery
        )

        def __create_recovery(
            self,
            body,
            **kwargs
        ):
            """Performs a Recovery.  # noqa: E501

            Performs a Recovery.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_recovery(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (CommonRecoveryRequestParamsae1b0dbe35e54e869dddFd34af026fcb): Specifies the parameters to create a Recovery.

            Keyword Args:
                request_initiator_type (str): Specifies the type of request from UI, which is used for services like magneto to determine the priority of requests.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CommonRecoveryResponseParams6a8355069c784a8f8fe5C686344da58c
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.create_recovery = _Endpoint(
            settings={
                'response_type': (CommonRecoveryResponseParams6a8355069c784a8f8fe5C686344da58c,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/recoveries',
                'operation_id': 'create_recovery',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                    'request_initiator_type',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                    'request_initiator_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('request_initiator_type',): {

                        "UIUSER": "UIUser",
                        "UIAUTO": "UIAuto"
                    },
                },
                'openapi_types': {
                    'body':
                        (CommonRecoveryRequestParamsae1b0dbe35e54e869dddFd34af026fcb,),
                    'request_initiator_type':
                        (str,),
                },
                'attribute_map': {
                    'request_initiator_type': 'requestInitiatorType',
                },
                'location_map': {
                    'body': 'body',
                    'request_initiator_type': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_recovery
        )

        def __download_files_from_recovery(
            self,
            id,
            **kwargs
        ):
            """Download files from the given download file recovery.  # noqa: E501

            Download files from the given download file recovery.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.download_files_from_recovery(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies the id of a Recovery.

            Keyword Args:
                start_offset (int): Specifies the start offset of file chunk to be downloaded.. [optional]
                length (int): Specifies the length of bytes to download. This can not be greater than 8MB (8388608 byets). [optional]
                file_type (str): Specifies the downloaded type, i.e: error, success_files_list. [optional]
                include_tenants (bool): Specifies if objects of all the organizations under the hierarchy of the logged in user's organization should be returned.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.download_files_from_recovery = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/recoveries/{id}/download-files',
                'operation_id': 'download_files_from_recovery',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'start_offset',
                    'length',
                    'file_type',
                    'include_tenants',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^\d+:\d+:\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'start_offset':
                        (int,),
                    'length':
                        (int,),
                    'file_type':
                        (str,),
                    'include_tenants':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'start_offset': 'startOffset',
                    'length': 'length',
                    'file_type': 'fileType',
                    'include_tenants': 'includeTenants',
                },
                'location_map': {
                    'id': 'path',
                    'start_offset': 'query',
                    'length': 'query',
                    'file_type': 'query',
                    'include_tenants': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__download_files_from_recovery
        )

        def __download_indexed_file(
            self,
            snapshots_id,
            **kwargs
        ):
            """Download an indexed file.  # noqa: E501

            Download an indexed file from a snapshot.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.download_indexed_file(snapshots_id, async_req=True)
            >>> result = thread.get()

            Args:
                snapshots_id (str): Specifies the snapshot id to download from.

            Keyword Args:
                file_path (str): Specifies the path to the file to download. If no path is specified and snapshot environment is kVMWare, VMX file for VMware will be downloaded. For other snapshot environments, this field must be specified.. [optional]
                retry_attempt (int): Specifies the number of attempts the protection run took to create this file.. [optional]
                start_offset (int): Specifies the start offset of file chunk to be downloaded.. [optional]
                length (int): Specifies the length of bytes to download. This can not be greater than 8MB (8388608 byets). [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['snapshots_id'] = \
                snapshots_id
            return self.call_with_http_info(**kwargs)

        self.download_indexed_file = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/snapshots/{snapshotsId}/download-file',
                'operation_id': 'download_indexed_file',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'snapshots_id',
                    'file_path',
                    'retry_attempt',
                    'start_offset',
                    'length',
                ],
                'required': [
                    'snapshots_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'snapshots_id':
                        (str,),
                    'file_path':
                        (str,),
                    'retry_attempt':
                        (int,),
                    'start_offset':
                        (int,),
                    'length':
                        (int,),
                },
                'attribute_map': {
                    'snapshots_id': 'snapshotsId',
                    'file_path': 'filePath',
                    'retry_attempt': 'retryAttempt',
                    'start_offset': 'startOffset',
                    'length': 'length',
                },
                'location_map': {
                    'snapshots_id': 'path',
                    'file_path': 'query',
                    'retry_attempt': 'query',
                    'start_offset': 'query',
                    'length': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__download_indexed_file
        )

        def __fetch_uptier_data(
            self,
            archive_uid,
            **kwargs
        ):
            """Fetches the uptier data.  # noqa: E501

            Fetches the uptier data for a restore job.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.fetch_uptier_data(archive_uid, async_req=True)
            >>> result = thread.get()

            Args:
                archive_uid (str): Archive UID of the current restore.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FetchUptierDataResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['archive_uid'] = \
                archive_uid
            return self.call_with_http_info(**kwargs)

        self.fetch_uptier_data = _Endpoint(
            settings={
                'response_type': (FetchUptierDataResponse,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/recoveries/fetch-uptier-data',
                'operation_id': 'fetch_uptier_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'archive_uid',
                ],
                'required': [
                    'archive_uid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'archive_uid',
                ]
            },
            root_map={
                'validations': {
                    ('archive_uid',): {

                        'regex': {
                            'pattern': r'^\d+:\d+:\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'archive_uid':
                        (str,),
                },
                'attribute_map': {
                    'archive_uid': 'archiveUId',
                },
                'location_map': {
                    'archive_uid': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__fetch_uptier_data
        )

        def __get_recoveries(
            self,
            **kwargs
        ):
            """Lists the Recoveries.  # noqa: E501

            Lists the Recoveries.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_recoveries(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                ids ([str]): Filter Recoveries for given ids.. [optional]
                return_only_child_recoveries (bool): Returns only child recoveries if passed as true. This filter should always be used along with 'ids' filter. . [optional]
                tenant_ids ([str]): TenantIds contains ids of the organizations for which recoveries are to be returned.. [optional]
                include_tenants (bool): Specifies if objects of all the organizations under the hierarchy of the logged in user's organization should be returned.. [optional]
                start_time_usecs (int): Returns the recoveries which are started after the specific time. This value should be in Unix timestamp epoch in microseconds.. [optional]
                end_time_usecs (int): Returns the recoveries which are started before the specific time. This value should be in Unix timestamp epoch in microseconds.. [optional]
                storage_domain_id (int): Filter by Storage Domain id. Only recoveries writing data to this Storage Domain will be returned.. [optional]
                snapshot_target_type ([str]): Specifies the snapshot's target type from which recovery has been performed.. [optional]
                archival_target_type ([str]): Specifies the snapshot's archival target type from which recovery has been performed. This parameter applies only if 'snapshotTargetType' is 'Archival'.. [optional]
                snapshot_environments ([str]): Specifies the list of snapshot environment types to filter Recoveries. If empty, Recoveries related to all environments will be returned.. [optional]
                status ([str]): Specifies the list of run status to filter Recoveries. If empty, Recoveries with all run status will be returned.. [optional]
                recovery_actions ([str]): Specifies the list of recovery actions to filter Recoveries. If empty, Recoveries related to all actions will be returned.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Recoveries
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_recoveries = _Endpoint(
            settings={
                'response_type': (Recoveries,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/recoveries',
                'operation_id': 'get_recoveries',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ids',
                    'return_only_child_recoveries',
                    'tenant_ids',
                    'include_tenants',
                    'start_time_usecs',
                    'end_time_usecs',
                    'storage_domain_id',
                    'snapshot_target_type',
                    'archival_target_type',
                    'snapshot_environments',
                    'status',
                    'recovery_actions',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'snapshot_target_type',
                    'archival_target_type',
                    'snapshot_environments',
                    'status',
                    'recovery_actions',
                ],
                'validation': [
                    'snapshot_target_type',
                    'archival_target_type',
                    'snapshot_environments',
                    'status',
                ]
            },
            root_map={
                'validations': {
                    ('snapshot_target_type',): {

                    },
                    ('archival_target_type',): {

                    },
                    ('snapshot_environments',): {

                    },
                    ('status',): {

                    },
                },
                'allowed_values': {
                    ('snapshot_target_type',): {

                        "LOCAL": "Local",
                        "ARCHIVAL": "Archival",
                        "RPAASARCHIVAL": "RpaasArchival",
                        "STORAGEARRAYSNAPSHOT": "StorageArraySnapshot"
                    },
                    ('archival_target_type',): {

                        "TAPE": "Tape",
                        "CLOUD": "Cloud",
                        "NAS": "Nas"
                    },
                    ('snapshot_environments',): {

                        "KVMWARE": "kVMware",
                        "KHYPERV": "kHyperV",
                        "KAZURE": "kAzure",
                        "KGCP": "kGCP",
                        "KKVM": "kKVM",
                        "KACROPOLIS": "kAcropolis",
                        "KAWS": "kAWS",
                        "KPHYSICAL": "kPhysical",
                        "KGPFS": "kGPFS",
                        "KELASTIFILE": "kElastifile",
                        "KNETAPP": "kNetapp",
                        "KGENERICNAS": "kGenericNas",
                        "KISILON": "kIsilon",
                        "KFLASHBLADE": "kFlashBlade",
                        "KPURE": "kPure",
                        "KSQL": "kSQL",
                        "KEXCHANGE": "kExchange",
                        "KAD": "kAD",
                        "KORACLE": "kOracle",
                        "KVIEW": "kView",
                        "KREMOTEADAPTER": "kRemoteAdapter",
                        "KO365": "kO365",
                        "KKUBERNETES": "kKubernetes",
                        "KCASSANDRA": "kCassandra",
                        "KMONGODB": "kMongoDB",
                        "KCOUCHBASE": "kCouchbase",
                        "KHDFS": "kHdfs",
                        "KHIVE": "kHive",
                        "KHBASE": "kHBase",
                        "KUDA": "kUDA",
                        "KSFDC": "kSfdc"
                    },
                    ('status',): {

                        "ACCEPTED": "Accepted",
                        "RUNNING": "Running",
                        "CANCELED": "Canceled",
                        "CANCELING": "Canceling",
                        "FAILED": "Failed",
                        "MISSED": "Missed",
                        "SUCCEEDED": "Succeeded",
                        "SUCCEEDEDWITHWARNING": "SucceededWithWarning",
                        "ONHOLD": "OnHold",
                        "FINALIZING": "Finalizing"
                    },
                    ('recovery_actions',): {

                        "RECOVERVMS": "RecoverVMs",
                        "RECOVERFILES": "RecoverFiles",
                        "INSTANTVOLUMEMOUNT": "InstantVolumeMount",
                        "RECOVERVMDISKS": "RecoverVmDisks",
                        "RECOVERVAPPS": "RecoverVApps",
                        "RECOVERVAPPTEMPLATES": "RecoverVAppTemplates",
                        "UPTIERSNAPSHOT": "UptierSnapshot",
                        "RECOVERRDS": "RecoverRDS",
                        "RECOVERAURORA": "RecoverAurora",
                        "RECOVERAPPS": "RecoverApps",
                        "RECOVERNASVOLUME": "RecoverNasVolume",
                        "RECOVERPHYSICALVOLUMES": "RecoverPhysicalVolumes",
                        "RECOVERSYSTEM": "RecoverSystem",
                        "CLONEAPPVIEW": "CloneAppView",
                        "RECOVERSANVOLUMES": "RecoverSanVolumes",
                        "RECOVERMAILBOX": "RecoverMailbox",
                        "RECOVERONEDRIVE": "RecoverOneDrive",
                        "RECOVERSHAREPOINT": "RecoverSharePoint",
                        "RECOVERPUBLICFOLDERS": "RecoverPublicFolders",
                        "RECOVERMSGROUP": "RecoverMsGroup",
                        "RECOVERMSTEAM": "RecoverMsTeam",
                        "CONVERTTOPST": "ConvertToPst",
                        "RECOVERNAMESPACES": "RecoverNamespaces",
                        "RECOVEROBJECTS": "RecoverObjects",
                        "RECOVERSFDCOBJECTS": "RecoverSfdcObjects",
                        "RECOVERSFDCORG": "RecoverSfdcOrg",
                        "RECOVERSFDCRECORDS": "RecoverSfdcRecords",
                        "DOWNLOADFILESANDFOLDERS": "DownloadFilesAndFolders"
                    },
                },
                'openapi_types': {
                    'ids':
                        ([str],),
                    'return_only_child_recoveries':
                        (bool,),
                    'tenant_ids':
                        ([str],),
                    'include_tenants':
                        (bool,),
                    'start_time_usecs':
                        (int,),
                    'end_time_usecs':
                        (int,),
                    'storage_domain_id':
                        (int,),
                    'snapshot_target_type':
                        ([str],),
                    'archival_target_type':
                        ([str],),
                    'snapshot_environments':
                        ([str],),
                    'status':
                        ([str],),
                    'recovery_actions':
                        ([str],),
                },
                'attribute_map': {
                    'ids': 'ids',
                    'return_only_child_recoveries': 'returnOnlyChildRecoveries',
                    'tenant_ids': 'tenantIds',
                    'include_tenants': 'includeTenants',
                    'start_time_usecs': 'startTimeUsecs',
                    'end_time_usecs': 'endTimeUsecs',
                    'storage_domain_id': 'storageDomainId',
                    'snapshot_target_type': 'snapshotTargetType',
                    'archival_target_type': 'archivalTargetType',
                    'snapshot_environments': 'snapshotEnvironments',
                    'status': 'status',
                    'recovery_actions': 'recoveryActions',
                },
                'location_map': {
                    'ids': 'query',
                    'return_only_child_recoveries': 'query',
                    'tenant_ids': 'query',
                    'include_tenants': 'query',
                    'start_time_usecs': 'query',
                    'end_time_usecs': 'query',
                    'storage_domain_id': 'query',
                    'snapshot_target_type': 'query',
                    'archival_target_type': 'query',
                    'snapshot_environments': 'query',
                    'status': 'query',
                    'recovery_actions': 'query',
                },
                'collection_format_map': {
                    'ids': 'csv',
                    'tenant_ids': 'csv',
                    'snapshot_target_type': 'csv',
                    'archival_target_type': 'csv',
                    'snapshot_environments': 'csv',
                    'status': 'csv',
                    'recovery_actions': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_recoveries
        )

        def __get_recovery_by_id(
            self,
            id,
            **kwargs
        ):
            """Get Recovery for a given id.  # noqa: E501

            Get Recovery for a given id.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_recovery_by_id(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies the id of a Recovery.

            Keyword Args:
                include_tenants (bool): Specifies if objects of all the organizations under the hierarchy of the logged in user's organization should be returned.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CommonRecoveryResponseParams6a8355069c784a8f8fe5C686344da58c
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_recovery_by_id = _Endpoint(
            settings={
                'response_type': (CommonRecoveryResponseParams6a8355069c784a8f8fe5C686344da58c,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/recoveries/{id}',
                'operation_id': 'get_recovery_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'include_tenants',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^\d+:\d+:\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'include_tenants':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'include_tenants': 'includeTenants',
                },
                'location_map': {
                    'id': 'path',
                    'include_tenants': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_recovery_by_id
        )

        def __get_recovery_debug_logs(
            self,
            id,
            **kwargs
        ):
            """Get the debug logs for a particular recovery operation.  # noqa: E501

            Get the debug logs for a particular recovery operation.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_recovery_debug_logs(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies the id of a Recovery job.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_recovery_debug_logs = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/recoveries/{id}/debug-logs',
                'operation_id': 'get_recovery_debug_logs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^\d+:\d+:\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_recovery_debug_logs
        )

        def __get_recovery_errors_report(
            self,
            id,
            **kwargs
        ):
            """Get the CSV of errors/warnings for a given recovery operation.  # noqa: E501

            Get a CSV error report for given recovery operation. Each row in CSV report contains the File Path, error/warning code and error/warning message.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_recovery_errors_report(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies a unique ID of a Recovery.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_recovery_errors_report = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/recoveries/{id}/download-messages',
                'operation_id': 'get_recovery_errors_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^\d+:\d+:\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_recovery_errors_report
        )

        def __internal_api_create_download_files_and_folders_recovery(
            self,
            body,
            **kwargs
        ):
            """Create a download files and folders recovery.  # noqa: E501

            Creates a download files and folders recovery.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.internal_api_create_download_files_and_folders_recovery(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (DownloadFilesAndFoldersRequestParams): Specifies the parameters to create a download files and folder recovery.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Recovery
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.internal_api_create_download_files_and_folders_recovery = _Endpoint(
            settings={
                'response_type': (Recovery,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/recoveries/downloadFilesAndFoldersRecovery',
                'operation_id': 'internal_api_create_download_files_and_folders_recovery',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (DownloadFilesAndFoldersRequestParams,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__internal_api_create_download_files_and_folders_recovery
        )

        def __internal_api_download_files_from_recovery(
            self,
            id,
            **kwargs
        ):
            """Download files from the given download file recovery.  # noqa: E501

            Download files from the given download file recovery.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.internal_api_download_files_from_recovery(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies the id of a Recovery.

            Keyword Args:
                start_offset (int): Specifies the start offset of file chunk to be downloaded.. [optional]
                length (int): Specifies the length of bytes to download. This can not be greater than 8MB (8388608 byets). [optional]
                include_tenants (bool): Specifies if objects of all the organizations under the hierarchy of the logged in user's organization should be returned.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.internal_api_download_files_from_recovery = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/recoveries/{id}/downloadFiles',
                'operation_id': 'internal_api_download_files_from_recovery',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'start_offset',
                    'length',
                    'include_tenants',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^\d+:\d+:\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'start_offset':
                        (int,),
                    'length':
                        (int,),
                    'include_tenants':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'start_offset': 'startOffset',
                    'length': 'length',
                    'include_tenants': 'includeTenants',
                },
                'location_map': {
                    'id': 'path',
                    'start_offset': 'query',
                    'length': 'query',
                    'include_tenants': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__internal_api_download_files_from_recovery
        )

        def __internal_api_download_indexed_file(
            self,
            snapshots_id,
            **kwargs
        ):
            """Download an indexed file.  # noqa: E501

            Download an indexed file from a snapshot.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.internal_api_download_indexed_file(snapshots_id, async_req=True)
            >>> result = thread.get()

            Args:
                snapshots_id (str): Specifies the snapshot id to download from.

            Keyword Args:
                file_path (str): Specifies the path to the file to download. If no path is specified and snapshot environment is kVMWare, VMX file for VMware will be downloaded. For other snapshot environments, this field must be specified.. [optional]
                retry_attempt (int): Specifies the number of attempts the protection run took to create this file.. [optional]
                start_offset (int): Specifies the start offset of file chunk to be downloaded.. [optional]
                length (int): Specifies the length of bytes to download. This can not be greater than 8MB (8388608 byets). [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['snapshots_id'] = \
                snapshots_id
            return self.call_with_http_info(**kwargs)

        self.internal_api_download_indexed_file = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/snapshots/{snapshotsId}/downloadFile',
                'operation_id': 'internal_api_download_indexed_file',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'snapshots_id',
                    'file_path',
                    'retry_attempt',
                    'start_offset',
                    'length',
                ],
                'required': [
                    'snapshots_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'snapshots_id':
                        (str,),
                    'file_path':
                        (str,),
                    'retry_attempt':
                        (int,),
                    'start_offset':
                        (int,),
                    'length':
                        (int,),
                },
                'attribute_map': {
                    'snapshots_id': 'snapshotsId',
                    'file_path': 'filePath',
                    'retry_attempt': 'retryAttempt',
                    'start_offset': 'startOffset',
                    'length': 'length',
                },
                'location_map': {
                    'snapshots_id': 'path',
                    'file_path': 'query',
                    'retry_attempt': 'query',
                    'start_offset': 'query',
                    'length': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__internal_api_download_indexed_file
        )

        def __tear_down_recovery_by_id(
            self,
            id,
            **kwargs
        ):
            """Tear down Recovery for a given id.  # noqa: E501

            Tear down Recovery for a given id.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.tear_down_recovery_by_id(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies the id of a Recovery.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.tear_down_recovery_by_id = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/recoveries/{id}/tear-down',
                'operation_id': 'tear_down_recovery_by_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^\d+:\d+:\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__tear_down_recovery_by_id
        )
