"""
    Cohesity REST API

    Cohesity API provides a RESTful interface to access the various data management operations on Cohesity cluster and Helios.  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cohesity_sdk.cluster.api_client import ApiClient, Endpoint as _Endpoint
from cohesity_sdk.cluster.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cohesity_sdk.cluster.model.cancel_object_runs_request import CancelObjectRunsRequest
from cohesity_sdk.cluster.model.cancel_object_runs_results import CancelObjectRunsResults
from cohesity_sdk.cluster.model.common_object_action_requestd8e311a83f104ddc_b60d8e62f77f28c8 import CommonObjectActionRequestd8e311a83f104ddcB60d8e62f77f28c8
from cohesity_sdk.cluster.model.common_pit_ranges_protected_object_response666782ab_bc134c23_b256_c8f7d125980f import CommonPITRangesProtectedObjectResponse666782abBc134c23B256C8f7d125980f
from cohesity_sdk.cluster.model.construct_meta_info_params import ConstructMetaInfoParams
from cohesity_sdk.cluster.model.construct_meta_info_result import ConstructMetaInfoResult
from cohesity_sdk.cluster.model.deleted_protected_objects_response_body import DeletedProtectedObjectsResponseBody
from cohesity_sdk.cluster.model.error import Error
from cohesity_sdk.cluster.model.file_folder_info import FileFolderInfo
from cohesity_sdk.cluster.model.filter_objects_request import FilterObjectsRequest
from cohesity_sdk.cluster.model.filtered_objects_response_body import FilteredObjectsResponseBody
from cohesity_sdk.cluster.model.get_indexed_object_snapshots_response_body import GetIndexedObjectSnapshotsResponseBody
from cohesity_sdk.cluster.model.get_object_runs_response_body import GetObjectRunsResponseBody
from cohesity_sdk.cluster.model.get_object_snapshots_response_body import GetObjectSnapshotsResponseBody
from cohesity_sdk.cluster.model.get_protected_objects_response import GetProtectedObjectsResponse
from cohesity_sdk.cluster.model.local_global_object_id_list import LocalGlobalObjectIdList
from cohesity_sdk.cluster.model.object_protection_run_summary import ObjectProtectionRunSummary
from cohesity_sdk.cluster.model.object_snapshot import ObjectSnapshot
from cohesity_sdk.cluster.model.object_snapshot_id_params import ObjectSnapshotIdParams
from cohesity_sdk.cluster.model.object_snapshot_id_result import ObjectSnapshotIdResult
from cohesity_sdk.cluster.model.object_snapshot_volume_info import ObjectSnapshotVolumeInfo
from cohesity_sdk.cluster.model.object_stats import ObjectStats
from cohesity_sdk.cluster.model.object_with_children import ObjectWithChildren
from cohesity_sdk.cluster.model.objects_action_request import ObjectsActionRequest
from cohesity_sdk.cluster.model.objects_last_run import ObjectsLastRun
from cohesity_sdk.cluster.model.protected_object_info import ProtectedObjectInfo
from cohesity_sdk.cluster.model.snapshot_diff_params import SnapshotDiffParams
from cohesity_sdk.cluster.model.snapshot_diff_result import SnapshotDiffResult
from cohesity_sdk.cluster.model.source_hierarchy_object_summaries import SourceHierarchyObjectSummaries
from cohesity_sdk.cluster.model.update_object_snapshot_request import UpdateObjectSnapshotRequest


class ObjectApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __browse_object_contents(
            self,
            id,
            body,
            **kwargs
        ):
            """Fetch the contents (files & folders) for the specified object.  # noqa: E501

            Fetch the contents (files & folders) of the specified path inside the specified object.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.browse_object_contents(id, body, async_req=True)
            >>> result = thread.get()

            Args:
                id (int): Specifies the id of the Object.
                body (CommonObjectActionRequestd8e311a83f104ddcB60d8e62f77f28c8): Specifies the parameters to fetch contents of an object.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FileFolderInfo
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.browse_object_contents = _Endpoint(
            settings={
                'response_type': (FileFolderInfo,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/{id}/browse',
                'operation_id': 'browse_object_contents',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'body',
                ],
                'required': [
                    'id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'body':
                        (CommonObjectActionRequestd8e311a83f104ddcB60d8e62f77f28c8,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__browse_object_contents
        )

        def __cancel_object_runs(
            self,
            body,
            **kwargs
        ):
            """Cancel object runs.  # noqa: E501

            Cancel object runs for object based protection. This does not apply to Group based protection.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.cancel_object_runs(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (CancelObjectRunsRequest): Specifies the parameters to cancel object runs.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CancelObjectRunsResults
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.cancel_object_runs = _Endpoint(
            settings={
                'response_type': (CancelObjectRunsResults,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/runs/cancel',
                'operation_id': 'cancel_object_runs',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (CancelObjectRunsRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__cancel_object_runs
        )

        def __construct_meta_info(
            self,
            snapshot_id,
            body,
            **kwargs
        ):
            """Construct meta info for any workflow from object snapshot and some other information.  # noqa: E501

            Construct meta info from object snapshot and some additional params.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.construct_meta_info(snapshot_id, body, async_req=True)
            >>> result = thread.get()

            Args:
                snapshot_id (str): Specifies the snapshot id.
                body (ConstructMetaInfoParams): Specifies the parameters to construct meta info for desired workflow.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ConstructMetaInfoResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['snapshot_id'] = \
                snapshot_id
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.construct_meta_info = _Endpoint(
            settings={
                'response_type': (ConstructMetaInfoResult,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/snapshots/{snapshotId}/meta-info',
                'operation_id': 'construct_meta_info',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'snapshot_id',
                    'body',
                ],
                'required': [
                    'snapshot_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'snapshot_id':
                        (str,),
                    'body':
                        (ConstructMetaInfoParams,),
                },
                'attribute_map': {
                    'snapshot_id': 'snapshotId',
                },
                'location_map': {
                    'snapshot_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__construct_meta_info
        )

        def __filter_objects(
            self,
            body,
            **kwargs
        ):
            """List all the filtered objects.  # noqa: E501

            List all the filtered objects using given regular expressions and wildcard supported search strings. We are currenly supporting this for only SQL adapter.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.filter_objects(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (FilterObjectsRequest): Specifies the parameters to filter objects.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FilteredObjectsResponseBody
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.filter_objects = _Endpoint(
            settings={
                'response_type': (FilteredObjectsResponseBody,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/filter/objects',
                'operation_id': 'filter_objects',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (FilterObjectsRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__filter_objects
        )

        def __get_all_indexed_object_snapshots(
            self,
            object_id,
            indexed_object_name,
            **kwargs
        ):
            """Get snapshots of indexed object.  # noqa: E501

            Get snapshots of indexed object.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_all_indexed_object_snapshots(object_id, indexed_object_name, async_req=True)
            >>> result = thread.get()

            Args:
                object_id (int): Specifies the object id.
                indexed_object_name (str): Specifies the indexed object name.

            Keyword Args:
                protection_group_id (str): Specifies the protection group id.. [optional]
                include_indexed_snapshots_only (bool): Specifies whether to only return snapshots which are indexed. In an indexed snapshot files are guaranteed to exist, while in a non-indexed snapshot files may not exist.. [optional] if omitted the server will use the default value of False
                from_time_usecs (int): Specifies the timestamp in Unix time epoch in microseconds to filter indexed object's snapshots which are taken after this value.. [optional]
                to_time_usecs (int): Specifies the timestamp in Unix time epoch in microseconds to filter indexed object's snapshots which are taken before this value.. [optional]
                run_types ([str]): Filter by run type. Only protection run matching the specified types will be returned. By default, CDP hydration snapshots are not included, unless explicitly queried using this field.. [optional]
                use_cached_data (bool): Specifies whether we can serve the GET request to the read replica cache. There is a lag of 15 seconds between the read replica and primary data source.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                GetIndexedObjectSnapshotsResponseBody
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['object_id'] = \
                object_id
            kwargs['indexed_object_name'] = \
                indexed_object_name
            return self.call_with_http_info(**kwargs)

        self.get_all_indexed_object_snapshots = _Endpoint(
            settings={
                'response_type': (GetIndexedObjectSnapshotsResponseBody,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/{objectId}/indexed-objects/snapshots',
                'operation_id': 'get_all_indexed_object_snapshots',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'object_id',
                    'indexed_object_name',
                    'protection_group_id',
                    'include_indexed_snapshots_only',
                    'from_time_usecs',
                    'to_time_usecs',
                    'run_types',
                    'use_cached_data',
                ],
                'required': [
                    'object_id',
                    'indexed_object_name',
                ],
                'nullable': [
                ],
                'enum': [
                    'run_types',
                ],
                'validation': [
                    'run_types',
                ]
            },
            root_map={
                'validations': {
                    ('run_types',): {

                    },
                },
                'allowed_values': {
                    ('run_types',): {

                        "KREGULAR": "kRegular",
                        "KFULL": "kFull",
                        "KLOG": "kLog",
                        "KSYSTEM": "kSystem",
                        "KHYDRATECDP": "kHydrateCDP",
                        "KSTORAGEARRAYSNAPSHOT": "kStorageArraySnapshot"
                    },
                },
                'openapi_types': {
                    'object_id':
                        (int,),
                    'indexed_object_name':
                        (str,),
                    'protection_group_id':
                        (str,),
                    'include_indexed_snapshots_only':
                        (bool,),
                    'from_time_usecs':
                        (int,),
                    'to_time_usecs':
                        (int,),
                    'run_types':
                        ([str],),
                    'use_cached_data':
                        (bool,),
                },
                'attribute_map': {
                    'object_id': 'objectId',
                    'indexed_object_name': 'indexedObjectName',
                    'protection_group_id': 'protectionGroupId',
                    'include_indexed_snapshots_only': 'includeIndexedSnapshotsOnly',
                    'from_time_usecs': 'fromTimeUsecs',
                    'to_time_usecs': 'toTimeUsecs',
                    'run_types': 'runTypes',
                    'use_cached_data': 'useCachedData',
                },
                'location_map': {
                    'object_id': 'path',
                    'indexed_object_name': 'query',
                    'protection_group_id': 'query',
                    'include_indexed_snapshots_only': 'query',
                    'from_time_usecs': 'query',
                    'to_time_usecs': 'query',
                    'run_types': 'query',
                    'use_cached_data': 'query',
                },
                'collection_format_map': {
                    'run_types': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_all_indexed_object_snapshots
        )

        def __get_deleted_protected_objects(
            self,
            source_id,
            **kwargs
        ):
            """List deleted protected objects.  # noqa: E501

            List of objects which are deleted but protected by object protection.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_deleted_protected_objects(source_id, async_req=True)
            >>> result = thread.get()

            Args:
                source_id (int): Specifies the source ID for which objects should be returned.

            Keyword Args:
                tenant_ids ([str]): TenantIds contains ids of the tenants for which objects are to be returned.. [optional]
                include_tenants (bool): If true, the response will include objects which were protected by all tenants which the current user has permission to see. If false, then only objects protected by the current user will be returned.. [optional]
                max_count (int): Specifies the max number of objects to return.. [optional]
                cookie (str): Specifies the pagination cookie.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DeletedProtectedObjectsResponseBody
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['source_id'] = \
                source_id
            return self.call_with_http_info(**kwargs)

        self.get_deleted_protected_objects = _Endpoint(
            settings={
                'response_type': (DeletedProtectedObjectsResponseBody,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/sources/{sourceId}/deleted-protected-objects',
                'operation_id': 'get_deleted_protected_objects',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_id',
                    'tenant_ids',
                    'include_tenants',
                    'max_count',
                    'cookie',
                ],
                'required': [
                    'source_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_id':
                        (int,),
                    'tenant_ids':
                        ([str],),
                    'include_tenants':
                        (bool,),
                    'max_count':
                        (int,),
                    'cookie':
                        (str,),
                },
                'attribute_map': {
                    'source_id': 'sourceId',
                    'tenant_ids': 'tenantIds',
                    'include_tenants': 'includeTenants',
                    'max_count': 'maxCount',
                    'cookie': 'cookie',
                },
                'location_map': {
                    'source_id': 'path',
                    'tenant_ids': 'query',
                    'include_tenants': 'query',
                    'max_count': 'query',
                    'cookie': 'query',
                },
                'collection_format_map': {
                    'tenant_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_deleted_protected_objects
        )

        def __get_indexed_object_snapshots(
            self,
            protection_group_id,
            object_id,
            indexed_object_name,
            **kwargs
        ):
            """Get snapshots of indexed object.  # noqa: E501

            Get snapshots of indexed object.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_indexed_object_snapshots(protection_group_id, object_id, indexed_object_name, async_req=True)
            >>> result = thread.get()

            Args:
                protection_group_id (str): Specifies the protection group id.
                object_id (int): Specifies the object id.
                indexed_object_name (str): Specifies the indexed object name.

            Keyword Args:
                include_indexed_snapshots_only (bool): Specifies whether to only return snapshots which are indexed. In an indexed snapshots file are guaranteened to exist, while in a non-indexed snapshots file may not exist.. [optional] if omitted the server will use the default value of False
                from_time_usecs (int): Specifies the timestamp in Unix time epoch in microseconds to filter indexed object's snapshots which are taken after this value.. [optional]
                to_time_usecs (int): Specifies the timestamp in Unix time epoch in microseconds to filter indexed object's snapshots which are taken before this value.. [optional]
                run_types ([str]): Filter by run type. Only protection run matching the specified types will be returned. By default, CDP hydration snapshots are not included, unless explicitly queried using this field.. [optional]
                use_cached_data (bool): Specifies whether we can serve the GET request to the read replica cache. There is a lag of 15 seconds between the read replica and primary data source.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                GetIndexedObjectSnapshotsResponseBody
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['protection_group_id'] = \
                protection_group_id
            kwargs['object_id'] = \
                object_id
            kwargs['indexed_object_name'] = \
                indexed_object_name
            return self.call_with_http_info(**kwargs)

        self.get_indexed_object_snapshots = _Endpoint(
            settings={
                'response_type': (GetIndexedObjectSnapshotsResponseBody,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/{objectId}/protection-groups/{protectionGroupId}/indexed-objects/snapshots',
                'operation_id': 'get_indexed_object_snapshots',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'protection_group_id',
                    'object_id',
                    'indexed_object_name',
                    'include_indexed_snapshots_only',
                    'from_time_usecs',
                    'to_time_usecs',
                    'run_types',
                    'use_cached_data',
                ],
                'required': [
                    'protection_group_id',
                    'object_id',
                    'indexed_object_name',
                ],
                'nullable': [
                ],
                'enum': [
                    'run_types',
                ],
                'validation': [
                    'run_types',
                ]
            },
            root_map={
                'validations': {
                    ('run_types',): {

                    },
                },
                'allowed_values': {
                    ('run_types',): {

                        "KREGULAR": "kRegular",
                        "KFULL": "kFull",
                        "KLOG": "kLog",
                        "KSYSTEM": "kSystem",
                        "KHYDRATECDP": "kHydrateCDP",
                        "KSTORAGEARRAYSNAPSHOT": "kStorageArraySnapshot"
                    },
                },
                'openapi_types': {
                    'protection_group_id':
                        (str,),
                    'object_id':
                        (int,),
                    'indexed_object_name':
                        (str,),
                    'include_indexed_snapshots_only':
                        (bool,),
                    'from_time_usecs':
                        (int,),
                    'to_time_usecs':
                        (int,),
                    'run_types':
                        ([str],),
                    'use_cached_data':
                        (bool,),
                },
                'attribute_map': {
                    'protection_group_id': 'protectionGroupId',
                    'object_id': 'objectId',
                    'indexed_object_name': 'indexedObjectName',
                    'include_indexed_snapshots_only': 'includeIndexedSnapshotsOnly',
                    'from_time_usecs': 'fromTimeUsecs',
                    'to_time_usecs': 'toTimeUsecs',
                    'run_types': 'runTypes',
                    'use_cached_data': 'useCachedData',
                },
                'location_map': {
                    'protection_group_id': 'path',
                    'object_id': 'path',
                    'indexed_object_name': 'query',
                    'include_indexed_snapshots_only': 'query',
                    'from_time_usecs': 'query',
                    'to_time_usecs': 'query',
                    'run_types': 'query',
                    'use_cached_data': 'query',
                },
                'collection_format_map': {
                    'run_types': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_indexed_object_snapshots
        )

        def __get_object_identifiers(
            self,
            **kwargs
        ):
            """Get Object Identifiers  # noqa: E501

            Get Object Identifiers.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_object_identifiers(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                global_ids ([str]): Get the object identifier matching specified global IDs.. [optional]
                local_ids ([int]): Get the object identifier matching specified local IDs.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LocalGlobalObjectIdList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_object_identifiers = _Endpoint(
            settings={
                'response_type': (LocalGlobalObjectIdList,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/object-identifiers',
                'operation_id': 'get_object_identifiers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'global_ids',
                    'local_ids',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'global_ids':
                        ([str],),
                    'local_ids':
                        ([int],),
                },
                'attribute_map': {
                    'global_ids': 'globalIds',
                    'local_ids': 'localIds',
                },
                'location_map': {
                    'global_ids': 'query',
                    'local_ids': 'query',
                },
                'collection_format_map': {
                    'global_ids': 'ssv',
                    'local_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_object_identifiers
        )

        def __get_object_run_by_run_id(
            self,
            id,
            run_id,
            **kwargs
        ):
            """Get a run for an object.  # noqa: E501

            Get a run for an object.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_object_run_by_run_id(id, run_id, async_req=True)
            >>> result = thread.get()

            Args:
                id (int): Specifies a unique id of the object.
                run_id (str): Specifies the id of the run.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjectProtectionRunSummary
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['run_id'] = \
                run_id
            return self.call_with_http_info(**kwargs)

        self.get_object_run_by_run_id = _Endpoint(
            settings={
                'response_type': (ObjectProtectionRunSummary,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/{id}/runs/{runId}',
                'operation_id': 'get_object_run_by_run_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'run_id',
                ],
                'required': [
                    'id',
                    'run_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'run_id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'run_id': 'runId',
                },
                'location_map': {
                    'id': 'path',
                    'run_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_object_run_by_run_id
        )

        def __get_object_runs(
            self,
            id,
            **kwargs
        ):
            """Get the list of runs for an object.  # noqa: E501

            Get the runs for a particular object.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_object_runs(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (int): Specifies a unique id of the object.

            Keyword Args:
                run_id (str): Specifies a unique id of the run.. [optional]
                start_time_usecs (int): Filter by a start time when the run starts. Specify the start time as a Unix epoch Timestamp (in microseconds).. [optional]
                end_time_usecs (int): Filter by a end time when the run starts. Specify the start time as a Unix epoch Timestamp (in microseconds).. [optional]
                tenant_ids ([str]): TenantIds contains ids of the tenants for which objects are to be returned.. [optional]
                include_tenants (bool): If true, the response will include Protection Group Runs which were created by all tenants which the current user has permission to see. If false, then only Protection Group Runs created by the current user will be returned.. [optional]
                run_types ([str]): Filter by run type. Only protection run matching the specified types will be returned.. [optional]
                local_backup_object_status ([str]): Specifies a list of status for the object in the backup run.. [optional]
                replication_object_status ([str]): Specifies a list of status for the object in the replication run.. [optional]
                archival_object_status ([str]): Specifies a list of status for the object in the archival run.. [optional]
                cloud_spin_run_status ([str]): Specifies a list of status for the object in the cloud spin run.. [optional]
                num_runs (int): Specifies the max number of runs. If not specified, at most 100 runs will be returned.. [optional]
                pagination_cookie (str): Specifies the pagination cookie with which subsequent parts of the response can be fetched. Users can use this to get next runs. [optional]
                exclude_non_restorable_runs (bool): Specifies whether to exclude non restorable runs. Run is treated restorable only if there is atleast one object snapshot (which may be either a local or an archival snapshot) which is not deleted or expired. Default value is false.. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                GetObjectRunsResponseBody
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_object_runs = _Endpoint(
            settings={
                'response_type': (GetObjectRunsResponseBody,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/{id}/runs',
                'operation_id': 'get_object_runs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'run_id',
                    'start_time_usecs',
                    'end_time_usecs',
                    'tenant_ids',
                    'include_tenants',
                    'run_types',
                    'local_backup_object_status',
                    'replication_object_status',
                    'archival_object_status',
                    'cloud_spin_run_status',
                    'num_runs',
                    'pagination_cookie',
                    'exclude_non_restorable_runs',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'run_types',
                    'local_backup_object_status',
                    'replication_object_status',
                    'archival_object_status',
                    'cloud_spin_run_status',
                ],
                'validation': [
                    'run_types',
                ]
            },
            root_map={
                'validations': {
                    ('run_types',): {

                    },
                },
                'allowed_values': {
                    ('run_types',): {

                        "KALL": "kAll",
                        "KHYDRATECDP": "kHydrateCDP",
                        "KSYSTEM": "kSystem",
                        "KSTORAGEARRAYSNAPSHOT": "kStorageArraySnapshot",
                        "KINCREMENTAL": "kIncremental",
                        "KFULL": "kFull",
                        "KLOG": "kLog"
                    },
                    ('local_backup_object_status',): {

                        "KINPROGRESS": "kInProgress",
                        "KSUCCESSFUL": "kSuccessful",
                        "KFAILED": "kFailed",
                        "KWAITINGFORNEXTATTEMPT": "kWaitingForNextAttempt",
                        "KWARNING": "kWarning",
                        "KCURRENTATTEMPTPAUSED": "kCurrentAttemptPaused",
                        "KCURRENTATTEMPTRESUMING": "kCurrentAttemptResuming",
                        "KCURRENTATTEMPTPAUSING": "kCurrentAttemptPausing",
                        "KWAITINGFOROLDERBACKUPRUN": "kWaitingForOlderBackupRun"
                    },
                    ('replication_object_status',): {

                        "KINPROGRESS": "kInProgress",
                        "KSUCCESSFUL": "kSuccessful",
                        "KFAILED": "kFailed",
                        "KWAITINGFORNEXTATTEMPT": "kWaitingForNextAttempt",
                        "KWARNING": "kWarning",
                        "KCURRENTATTEMPTPAUSED": "kCurrentAttemptPaused",
                        "KCURRENTATTEMPTRESUMING": "kCurrentAttemptResuming",
                        "KCURRENTATTEMPTPAUSING": "kCurrentAttemptPausing",
                        "KWAITINGFOROLDERBACKUPRUN": "kWaitingForOlderBackupRun"
                    },
                    ('archival_object_status',): {

                        "KINPROGRESS": "kInProgress",
                        "KSUCCESSFUL": "kSuccessful",
                        "KFAILED": "kFailed",
                        "KWAITINGFORNEXTATTEMPT": "kWaitingForNextAttempt",
                        "KWARNING": "kWarning",
                        "KCURRENTATTEMPTPAUSED": "kCurrentAttemptPaused",
                        "KCURRENTATTEMPTRESUMING": "kCurrentAttemptResuming",
                        "KCURRENTATTEMPTPAUSING": "kCurrentAttemptPausing",
                        "KWAITINGFOROLDERBACKUPRUN": "kWaitingForOlderBackupRun"
                    },
                    ('cloud_spin_run_status',): {

                        "KINPROGRESS": "kInProgress",
                        "KSUCCESSFUL": "kSuccessful",
                        "KFAILED": "kFailed",
                        "KWAITINGFORNEXTATTEMPT": "kWaitingForNextAttempt",
                        "KWARNING": "kWarning",
                        "KCURRENTATTEMPTPAUSED": "kCurrentAttemptPaused",
                        "KCURRENTATTEMPTRESUMING": "kCurrentAttemptResuming",
                        "KCURRENTATTEMPTPAUSING": "kCurrentAttemptPausing",
                        "KWAITINGFOROLDERBACKUPRUN": "kWaitingForOlderBackupRun"
                    },
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'run_id':
                        (str,),
                    'start_time_usecs':
                        (int,),
                    'end_time_usecs':
                        (int,),
                    'tenant_ids':
                        ([str],),
                    'include_tenants':
                        (bool,),
                    'run_types':
                        ([str],),
                    'local_backup_object_status':
                        ([str],),
                    'replication_object_status':
                        ([str],),
                    'archival_object_status':
                        ([str],),
                    'cloud_spin_run_status':
                        ([str],),
                    'num_runs':
                        (int,),
                    'pagination_cookie':
                        (str,),
                    'exclude_non_restorable_runs':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'run_id': 'runId',
                    'start_time_usecs': 'startTimeUsecs',
                    'end_time_usecs': 'endTimeUsecs',
                    'tenant_ids': 'tenantIds',
                    'include_tenants': 'includeTenants',
                    'run_types': 'runTypes',
                    'local_backup_object_status': 'localBackupObjectStatus',
                    'replication_object_status': 'replicationObjectStatus',
                    'archival_object_status': 'archivalObjectStatus',
                    'cloud_spin_run_status': 'cloudSpinRunStatus',
                    'num_runs': 'numRuns',
                    'pagination_cookie': 'paginationCookie',
                    'exclude_non_restorable_runs': 'excludeNonRestorableRuns',
                },
                'location_map': {
                    'id': 'path',
                    'run_id': 'query',
                    'start_time_usecs': 'query',
                    'end_time_usecs': 'query',
                    'tenant_ids': 'query',
                    'include_tenants': 'query',
                    'run_types': 'query',
                    'local_backup_object_status': 'query',
                    'replication_object_status': 'query',
                    'archival_object_status': 'query',
                    'cloud_spin_run_status': 'query',
                    'num_runs': 'query',
                    'pagination_cookie': 'query',
                    'exclude_non_restorable_runs': 'query',
                },
                'collection_format_map': {
                    'tenant_ids': 'csv',
                    'run_types': 'csv',
                    'local_backup_object_status': 'csv',
                    'replication_object_status': 'csv',
                    'archival_object_status': 'csv',
                    'cloud_spin_run_status': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_object_runs
        )

        def __get_object_snapshot_id(
            self,
            object_id,
            body,
            **kwargs
        ):
            """Get snapshot id for a given object.  # noqa: E501

            Get snapshot id for object for given params.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_object_snapshot_id(object_id, body, async_req=True)
            >>> result = thread.get()

            Args:
                object_id (int): Specifies the object id.
                body (ObjectSnapshotIdParams): Specifies the parameters to fetch snapshot id for object.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjectSnapshotIdResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['object_id'] = \
                object_id
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.get_object_snapshot_id = _Endpoint(
            settings={
                'response_type': (ObjectSnapshotIdResult,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/{objectId}/snapshotId',
                'operation_id': 'get_object_snapshot_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'object_id',
                    'body',
                ],
                'required': [
                    'object_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'object_id':
                        (int,),
                    'body':
                        (ObjectSnapshotIdParams,),
                },
                'attribute_map': {
                    'object_id': 'objectId',
                },
                'location_map': {
                    'object_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__get_object_snapshot_id
        )

        def __get_object_snapshot_info(
            self,
            snapshot_id,
            **kwargs
        ):
            """Get details of object snapshot.  # noqa: E501

            Get details of object snapshot.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_object_snapshot_info(snapshot_id, async_req=True)
            >>> result = thread.get()

            Args:
                snapshot_id (str): Specifies the snapshot id.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjectSnapshot
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['snapshot_id'] = \
                snapshot_id
            return self.call_with_http_info(**kwargs)

        self.get_object_snapshot_info = _Endpoint(
            settings={
                'response_type': (ObjectSnapshot,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/snapshots/{snapshotId}',
                'operation_id': 'get_object_snapshot_info',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'snapshot_id',
                ],
                'required': [
                    'snapshot_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'snapshot_id':
                        (str,),
                },
                'attribute_map': {
                    'snapshot_id': 'snapshotId',
                },
                'location_map': {
                    'snapshot_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_object_snapshot_info
        )

        def __get_object_snapshot_volume_info(
            self,
            snapshot_id,
            **kwargs
        ):
            """Get volume info of object snapshot.  # noqa: E501

            Get volume info of object snapshot.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_object_snapshot_volume_info(snapshot_id, async_req=True)
            >>> result = thread.get()

            Args:
                snapshot_id (str): Specifies the snapshot id.

            Keyword Args:
                include_supported_only (bool): Specifies whether to only return supported volumes.. [optional]
                point_in_time_usecs (float): Specifies the point-in-time timestamp (in usecs from epoch) between snapshots for which the volume info is to be returned.. [optional]
                use_cached_data (bool): Specifies whether we can serve the GET request to the read replica cache. There is a lag of 15 seconds between the read replica and primary data source.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjectSnapshotVolumeInfo
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['snapshot_id'] = \
                snapshot_id
            return self.call_with_http_info(**kwargs)

        self.get_object_snapshot_volume_info = _Endpoint(
            settings={
                'response_type': (ObjectSnapshotVolumeInfo,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/snapshots/{snapshotId}/volume',
                'operation_id': 'get_object_snapshot_volume_info',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'snapshot_id',
                    'include_supported_only',
                    'point_in_time_usecs',
                    'use_cached_data',
                ],
                'required': [
                    'snapshot_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'snapshot_id':
                        (str,),
                    'include_supported_only':
                        (bool,),
                    'point_in_time_usecs':
                        (float,),
                    'use_cached_data':
                        (bool,),
                },
                'attribute_map': {
                    'snapshot_id': 'snapshotId',
                    'include_supported_only': 'includeSupportedOnly',
                    'point_in_time_usecs': 'pointInTimeUsecs',
                    'use_cached_data': 'useCachedData',
                },
                'location_map': {
                    'snapshot_id': 'path',
                    'include_supported_only': 'query',
                    'point_in_time_usecs': 'query',
                    'use_cached_data': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_object_snapshot_volume_info
        )

        def __get_object_snapshots(
            self,
            id,
            **kwargs
        ):
            """List the snapshots for a given object.  # noqa: E501

            List the snapshots for a given object.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_object_snapshots(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (int): Specifies the id of the Object.

            Keyword Args:
                from_time_usecs (int): Specifies the timestamp in Unix time epoch in microseconds to filter Object's snapshots which were taken after this value.. [optional]
                to_time_usecs (int): Specifies the timestamp in Unix time epoch in microseconds to filter Object's snapshots which were taken before this value.. [optional]
                run_start_from_time_usecs (int): Specifies the timestamp in Unix time epoch in microseconds to filter Object's snapshots which were run after this value.. [optional]
                run_start_to_time_usecs (int): Specifies the timestamp in Unix time epoch in microseconds to filter Object's snapshots which were run before this value.. [optional]
                snapshot_actions ([str]): Specifies a list of recovery actions. Only snapshots that applies to these actions will be returned.. [optional]
                run_types ([str]): Filter by run type. Only protection run matching the specified types will be returned. By default, CDP hydration snapshots are not included, unless explicitly queried using this field.. [optional]
                protection_group_ids ([str]): If specified, this returns only the snapshots of the specified object ID, which belong to the provided protection group IDs.. [optional]
                run_instance_ids ([int]): Filter by a list run instance ids. If specified, only snapshots created by these protection runs will be returned.. [optional]
                region_ids ([str]): Filter by a list of region ids.. [optional]
                object_action_keys ([str]): Filter by ObjectActionKey, which uniquely represents protection of an object. An object can be protected in multiple ways but atmost once for a given combination of ObjectActionKey. When specified, only snapshots matching given action keys are returned for corresponding object.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                GetObjectSnapshotsResponseBody
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_object_snapshots = _Endpoint(
            settings={
                'response_type': (GetObjectSnapshotsResponseBody,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/{id}/snapshots',
                'operation_id': 'get_object_snapshots',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'from_time_usecs',
                    'to_time_usecs',
                    'run_start_from_time_usecs',
                    'run_start_to_time_usecs',
                    'snapshot_actions',
                    'run_types',
                    'protection_group_ids',
                    'run_instance_ids',
                    'region_ids',
                    'object_action_keys',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'snapshot_actions',
                    'run_types',
                    'object_action_keys',
                ],
                'validation': [
                    'snapshot_actions',
                    'run_types',
                ]
            },
            root_map={
                'validations': {
                    ('snapshot_actions',): {

                    },
                    ('run_types',): {

                    },
                },
                'allowed_values': {
                    ('snapshot_actions',): {

                        "RECOVERVMS": "RecoverVMs",
                        "RECOVERFILES": "RecoverFiles",
                        "INSTANTVOLUMEMOUNT": "InstantVolumeMount",
                        "RECOVERVMDISKS": "RecoverVmDisks",
                        "MOUNTVOLUMES": "MountVolumes",
                        "RECOVERVAPPS": "RecoverVApps",
                        "RECOVERRDS": "RecoverRDS",
                        "RECOVERAURORA": "RecoverAurora",
                        "RECOVERAPPS": "RecoverApps",
                        "RECOVERNASVOLUME": "RecoverNasVolume",
                        "RECOVERPHYSICALVOLUMES": "RecoverPhysicalVolumes",
                        "RECOVERSYSTEM": "RecoverSystem",
                        "RECOVERSANVOLUMES": "RecoverSanVolumes",
                        "RECOVERNAMESPACES": "RecoverNamespaces",
                        "RECOVEROBJECTS": "RecoverObjects",
                        "DOWNLOADFILESANDFOLDERS": "DownloadFilesAndFolders",
                        "RECOVERPUBLICFOLDERS": "RecoverPublicFolders",
                        "RECOVERVAPPTEMPLATES": "RecoverVAppTemplates",
                        "RECOVERMAILBOX": "RecoverMailbox",
                        "RECOVERONEDRIVE": "RecoverOneDrive",
                        "RECOVERMSTEAM": "RecoverMsTeam",
                        "RECOVERMSGROUP": "RecoverMsGroup",
                        "RECOVERSHAREPOINT": "RecoverSharePoint",
                        "CONVERTTOPST": "ConvertToPst",
                        "RECOVERSFDCRECORDS": "RecoverSfdcRecords"
                    },
                    ('run_types',): {

                        "KREGULAR": "kRegular",
                        "KFULL": "kFull",
                        "KLOG": "kLog",
                        "KSYSTEM": "kSystem",
                        "KHYDRATECDP": "kHydrateCDP",
                        "KSTORAGEARRAYSNAPSHOT": "kStorageArraySnapshot"
                    },
                    ('object_action_keys',): {

                        "KVMWARE": "kVMware",
                        "KHYPERV": "kHyperV",
                        "KVCD": "kVCD",
                        "KAZURE": "kAzure",
                        "KGCP": "kGCP",
                        "KKVM": "kKVM",
                        "KACROPOLIS": "kAcropolis",
                        "KAWS": "kAWS",
                        "KAWSNATIVE": "kAWSNative",
                        "KAWSSNAPSHOTMANAGER": "kAWSSnapshotManager",
                        "KRDSSNAPSHOTMANAGER": "kRDSSnapshotManager",
                        "KAURORASNAPSHOTMANAGER": "kAuroraSnapshotManager",
                        "KPHYSICAL": "kPhysical",
                        "KPHYSICALFILES": "kPhysicalFiles",
                        "KGPFS": "kGPFS",
                        "KELASTIFILE": "kElastifile",
                        "KNETAPP": "kNetapp",
                        "KGENERICNAS": "kGenericNas",
                        "KISILON": "kIsilon",
                        "KFLASHBLADE": "kFlashBlade",
                        "KPURE": "kPure",
                        "KSQL": "kSQL",
                        "KEXCHANGE": "kExchange",
                        "KAD": "kAD",
                        "KORACLE": "kOracle",
                        "KVIEW": "kView",
                        "KREMOTEADAPTER": "kRemoteAdapter",
                        "KO365": "kO365",
                        "KO365PUBLICFOLDERS": "kO365PublicFolders",
                        "KO365TEAMS": "kO365Teams",
                        "KO365GROUP": "kO365Group",
                        "KO365EXCHANGE": "kO365Exchange",
                        "KO365ONEDRIVE": "kO365OneDrive",
                        "KO365SHAREPOINT": "kO365Sharepoint",
                        "KKUBERNETES": "kKubernetes",
                        "KCASSANDRA": "kCassandra",
                        "KMONGODB": "kMongoDB",
                        "KCOUCHBASE": "kCouchbase",
                        "KHDFS": "kHdfs",
                        "KHIVE": "kHive",
                        "KHBASE": "kHBase",
                        "KUDA": "kUDA",
                        "KSFDC": "kSfdc"
                    },
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'from_time_usecs':
                        (int,),
                    'to_time_usecs':
                        (int,),
                    'run_start_from_time_usecs':
                        (int,),
                    'run_start_to_time_usecs':
                        (int,),
                    'snapshot_actions':
                        ([str],),
                    'run_types':
                        ([str],),
                    'protection_group_ids':
                        ([str],),
                    'run_instance_ids':
                        ([int],),
                    'region_ids':
                        ([str],),
                    'object_action_keys':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'from_time_usecs': 'fromTimeUsecs',
                    'to_time_usecs': 'toTimeUsecs',
                    'run_start_from_time_usecs': 'runStartFromTimeUsecs',
                    'run_start_to_time_usecs': 'runStartToTimeUsecs',
                    'snapshot_actions': 'snapshotActions',
                    'run_types': 'runTypes',
                    'protection_group_ids': 'protectionGroupIds',
                    'run_instance_ids': 'runInstanceIds',
                    'region_ids': 'regionIds',
                    'object_action_keys': 'objectActionKeys',
                },
                'location_map': {
                    'id': 'path',
                    'from_time_usecs': 'query',
                    'to_time_usecs': 'query',
                    'run_start_from_time_usecs': 'query',
                    'run_start_to_time_usecs': 'query',
                    'snapshot_actions': 'query',
                    'run_types': 'query',
                    'protection_group_ids': 'query',
                    'run_instance_ids': 'query',
                    'region_ids': 'query',
                    'object_action_keys': 'query',
                },
                'collection_format_map': {
                    'snapshot_actions': 'csv',
                    'run_types': 'csv',
                    'protection_group_ids': 'csv',
                    'run_instance_ids': 'csv',
                    'region_ids': 'csv',
                    'object_action_keys': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_object_snapshots
        )

        def __get_object_stats(
            self,
            id,
            **kwargs
        ):
            """Get stats for a given object.  # noqa: E501

            Get stats for a given object.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_object_stats(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (int): Specifies the id of the Object.

            Keyword Args:
                region_ids ([str]): Filter by a list of region ids.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjectStats
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_object_stats = _Endpoint(
            settings={
                'response_type': (ObjectStats,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/{id}/stats',
                'operation_id': 'get_object_stats',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'region_ids',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'region_ids':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'region_ids': 'regionIds',
                },
                'location_map': {
                    'id': 'path',
                    'region_ids': 'query',
                },
                'collection_format_map': {
                    'region_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_object_stats
        )

        def __get_object_tree(
            self,
            id,
            **kwargs
        ):
            """Get the objects tree hierarchy for for an Object.  # noqa: E501

            Get the objects tree hierarchy for for an Object. If the object does not have a hierarchy then a single object will be returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_object_tree(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (int): Specifies the id of the Object.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjectWithChildren
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_object_tree = _Endpoint(
            settings={
                'response_type': (ObjectWithChildren,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/{id}/tree',
                'operation_id': 'get_object_tree',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_object_tree
        )

        def __get_objects_last_run(
            self,
            **kwargs
        ):
            """Get last protection run of objects.  # noqa: E501

            Get last protection run of objects.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_objects_last_run(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                ids ([int]): Specifies a list of object ids, only last runs for these objects will be returned.. [optional]
                tenant_ids ([str]): TenantIds contains ids of the tenants for which objects are to be returned.. [optional]
                include_tenants (bool): If true, the response will include Objects which belongs to all tenants which the current user has permission to see.. [optional]
                pagination_cookie (str): Specifies the pagination cookie with which subsequent parts of the response can be fetched.. [optional]
                count (int): Specifies the number of objects to be fetched for the specified pagination cookie.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjectsLastRun
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_objects_last_run = _Endpoint(
            settings={
                'response_type': (ObjectsLastRun,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/last-run',
                'operation_id': 'get_objects_last_run',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ids',
                    'tenant_ids',
                    'include_tenants',
                    'pagination_cookie',
                    'count',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ids':
                        ([int],),
                    'tenant_ids':
                        ([str],),
                    'include_tenants':
                        (bool,),
                    'pagination_cookie':
                        (str,),
                    'count':
                        (int,),
                },
                'attribute_map': {
                    'ids': 'ids',
                    'tenant_ids': 'tenantIds',
                    'include_tenants': 'includeTenants',
                    'pagination_cookie': 'paginationCookie',
                    'count': 'count',
                },
                'location_map': {
                    'ids': 'query',
                    'tenant_ids': 'query',
                    'include_tenants': 'query',
                    'pagination_cookie': 'query',
                    'count': 'query',
                },
                'collection_format_map': {
                    'ids': 'csv',
                    'tenant_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_objects_last_run
        )

        def __get_pit_ranges_for_protected_object(
            self,
            id,
            **kwargs
        ):
            """Get PIT ranges for an object  # noqa: E501

            Returns the ranges in various types like time, SCN etc. within which the specified protected object can be restored to any Point in time.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_pit_ranges_for_protected_object(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (int): Specifies the ID of the protected object.

            Keyword Args:
                from_time_usecs (int): If specified, return the restore ranges that lie after this timestamp. This parameter is specified as the timestamp in Unix time epoch in microseconds.. [optional]
                to_time_usecs (int): If specified, return the restore ranges that lie before this timestamp. This parameter is specified as the timestamp in Unix time epoch in microseconds.. [optional]
                protection_group_ids ([str]): If specified, return only the points in time corresponding to these protection group IDs.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CommonPITRangesProtectedObjectResponse666782abBc134c23B256C8f7d125980f
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_pit_ranges_for_protected_object = _Endpoint(
            settings={
                'response_type': (CommonPITRangesProtectedObjectResponse666782abBc134c23B256C8f7d125980f,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/{id}/pit-ranges',
                'operation_id': 'get_pit_ranges_for_protected_object',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'from_time_usecs',
                    'to_time_usecs',
                    'protection_group_ids',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'from_time_usecs':
                        (int,),
                    'to_time_usecs':
                        (int,),
                    'protection_group_ids':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'from_time_usecs': 'fromTimeUsecs',
                    'to_time_usecs': 'toTimeUsecs',
                    'protection_group_ids': 'protectionGroupIds',
                },
                'location_map': {
                    'id': 'path',
                    'from_time_usecs': 'query',
                    'to_time_usecs': 'query',
                    'protection_group_ids': 'query',
                },
                'collection_format_map': {
                    'protection_group_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_pit_ranges_for_protected_object
        )

        def __get_protected_object_of_any_type_by_id(
            self,
            id,
            **kwargs
        ):
            """Get an Object.  # noqa: E501

            Get Object configrations for given object id.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_protected_object_of_any_type_by_id(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (int): Specifies the id of the Object.

            Keyword Args:
                request_initiator_type (str): Specifies the type of request from UI, which is used for services like magneto to determine the priority of requests.. [optional]
                object_action_key ([str]): Filter by ObjectActionKey, uniquely represent protection of an object. An object can be protected in multiple ways but atmost once for a given combination of ObjectActionKey, when specified Only objects of given action_key are returned for corresponding object id and this vec's size needs to be same as 'id'.. [optional]
                only_protected_objects (bool): If true, the response will include only objects which have been protected.. [optional]
                storage_domain_id (int): Filter by Storage Domain id. Only Objects protected to this Storage Domain will be returned.. [optional]
                environments ([str]): Filter by environment types such as 'kVMware', 'kView', etc. Only Protected objects protecting the specified environment types are returned.. [optional]
                tenant_ids ([str]): TenantIds contains ids of the tenants for which objects are to be returned.. [optional]
                include_tenants (bool): If true, the response will include Objects which were protected by all tenants which the current user has permission to see. If false, then only objects protected by the current user will be returned.. [optional]
                include_last_run_info (bool): If true, the response will include information about the last protection run on this object.. [optional]
                only_auto_protected_objects (bool): If true, the response will include only the auto protected objects.. [optional]
                only_leaf_objects (bool): If true, the response will include only the leaf level objects.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProtectedObjectInfo
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_protected_object_of_any_type_by_id = _Endpoint(
            settings={
                'response_type': (ProtectedObjectInfo,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/{id}',
                'operation_id': 'get_protected_object_of_any_type_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'request_initiator_type',
                    'object_action_key',
                    'only_protected_objects',
                    'storage_domain_id',
                    'environments',
                    'tenant_ids',
                    'include_tenants',
                    'include_last_run_info',
                    'only_auto_protected_objects',
                    'only_leaf_objects',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'request_initiator_type',
                    'object_action_key',
                    'environments',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('request_initiator_type',): {

                        "UIUSER": "UIUser",
                        "UIAUTO": "UIAuto"
                    },
                    ('object_action_key',): {

                        "KVMWARE": "kVMware",
                        "KHYPERV": "kHyperV",
                        "KVCD": "kVCD",
                        "KAZURE": "kAzure",
                        "KGCP": "kGCP",
                        "KKVM": "kKVM",
                        "KACROPOLIS": "kAcropolis",
                        "KAWS": "kAWS",
                        "KAWSNATIVE": "kAWSNative",
                        "KAWSSNAPSHOTMANAGER": "kAWSSnapshotManager",
                        "KRDSSNAPSHOTMANAGER": "kRDSSnapshotManager",
                        "KAURORASNAPSHOTMANAGER": "kAuroraSnapshotManager",
                        "KPHYSICAL": "kPhysical",
                        "KPHYSICALFILES": "kPhysicalFiles",
                        "KGPFS": "kGPFS",
                        "KELASTIFILE": "kElastifile",
                        "KNETAPP": "kNetapp",
                        "KGENERICNAS": "kGenericNas",
                        "KISILON": "kIsilon",
                        "KFLASHBLADE": "kFlashBlade",
                        "KPURE": "kPure",
                        "KSQL": "kSQL",
                        "KEXCHANGE": "kExchange",
                        "KAD": "kAD",
                        "KORACLE": "kOracle",
                        "KVIEW": "kView",
                        "KREMOTEADAPTER": "kRemoteAdapter",
                        "KO365": "kO365",
                        "KO365PUBLICFOLDERS": "kO365PublicFolders",
                        "KO365TEAMS": "kO365Teams",
                        "KO365GROUP": "kO365Group",
                        "KO365EXCHANGE": "kO365Exchange",
                        "KO365ONEDRIVE": "kO365OneDrive",
                        "KO365SHAREPOINT": "kO365Sharepoint",
                        "KKUBERNETES": "kKubernetes",
                        "KCASSANDRA": "kCassandra",
                        "KMONGODB": "kMongoDB",
                        "KCOUCHBASE": "kCouchbase",
                        "KHDFS": "kHdfs",
                        "KHIVE": "kHive",
                        "KHBASE": "kHBase",
                        "KUDA": "kUDA",
                        "KSFDC": "kSfdc"
                    },
                    ('environments',): {

                        "KVMWARE": "kVMware",
                        "KHYPERV": "kHyperV",
                        "KVCD": "kVCD",
                        "KAZURE": "kAzure",
                        "KGCP": "kGCP",
                        "KKVM": "kKVM",
                        "KACROPOLIS": "kAcropolis",
                        "KAWS": "kAWS",
                        "KAWSNATIVE": "kAWSNative",
                        "KAWSSNAPSHOTMANAGER": "kAWSSnapshotManager",
                        "KRDSSNAPSHOTMANAGER": "kRDSSnapshotManager",
                        "KAURORASNAPSHOTMANAGER": "kAuroraSnapshotManager",
                        "KPHYSICAL": "kPhysical",
                        "KPHYSICALFILES": "kPhysicalFiles",
                        "KGPFS": "kGPFS",
                        "KELASTIFILE": "kElastifile",
                        "KNETAPP": "kNetapp",
                        "KGENERICNAS": "kGenericNas",
                        "KISILON": "kIsilon",
                        "KFLASHBLADE": "kFlashBlade",
                        "KPURE": "kPure",
                        "KSQL": "kSQL",
                        "KEXCHANGE": "kExchange",
                        "KAD": "kAD",
                        "KORACLE": "kOracle",
                        "KVIEW": "kView",
                        "KREMOTEADAPTER": "kRemoteAdapter",
                        "KO365": "kO365",
                        "KO365PUBLICFOLDERS": "kO365PublicFolders",
                        "KO365TEAMS": "kO365Teams",
                        "KO365GROUP": "kO365Group",
                        "KO365EXCHANGE": "kO365Exchange",
                        "KO365ONEDRIVE": "kO365OneDrive",
                        "KO365SHAREPOINT": "kO365Sharepoint",
                        "KKUBERNETES": "kKubernetes",
                        "KCASSANDRA": "kCassandra",
                        "KMONGODB": "kMongoDB",
                        "KCOUCHBASE": "kCouchbase",
                        "KHDFS": "kHdfs",
                        "KHIVE": "kHive",
                        "KHBASE": "kHBase",
                        "KUDA": "kUDA",
                        "KSFDC": "kSfdc"
                    },
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'request_initiator_type':
                        (str,),
                    'object_action_key':
                        ([str],),
                    'only_protected_objects':
                        (bool,),
                    'storage_domain_id':
                        (int,),
                    'environments':
                        ([str],),
                    'tenant_ids':
                        ([str],),
                    'include_tenants':
                        (bool,),
                    'include_last_run_info':
                        (bool,),
                    'only_auto_protected_objects':
                        (bool,),
                    'only_leaf_objects':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'request_initiator_type': 'requestInitiatorType',
                    'object_action_key': 'objectActionKey',
                    'only_protected_objects': 'onlyProtectedObjects',
                    'storage_domain_id': 'storageDomainId',
                    'environments': 'environments',
                    'tenant_ids': 'tenantIds',
                    'include_tenants': 'includeTenants',
                    'include_last_run_info': 'includeLastRunInfo',
                    'only_auto_protected_objects': 'onlyAutoProtectedObjects',
                    'only_leaf_objects': 'onlyLeafObjects',
                },
                'location_map': {
                    'id': 'path',
                    'request_initiator_type': 'header',
                    'object_action_key': 'query',
                    'only_protected_objects': 'query',
                    'storage_domain_id': 'query',
                    'environments': 'query',
                    'tenant_ids': 'query',
                    'include_tenants': 'query',
                    'include_last_run_info': 'query',
                    'only_auto_protected_objects': 'query',
                    'only_leaf_objects': 'query',
                },
                'collection_format_map': {
                    'object_action_key': 'csv',
                    'environments': 'csv',
                    'tenant_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_protected_object_of_any_type_by_id
        )

        def __get_protected_objects_of_any_type(
            self,
            **kwargs
        ):
            """Get Objects.  # noqa: E501

            Get Objects Configurations.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_protected_objects_of_any_type(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                request_initiator_type (str): Specifies the type of request from UI, which is used for services like magneto to determine the priority of requests.. [optional]
                ids ([int]): Filter by a list of Object ids.. [optional]
                object_action_keys ([str]): Filter by ObjectActionKey, uniquely represent protection of an object. An object can be protected in multiple ways but atmost once for a given combination of ObjectActionKey, when specified Only objects of given action_key are returned for corresponding object id. The vec's size needs to be of either length one or same as the length of 'ids'. If the length of objectActionKey is one, it will be repeated as many number of times equal to the length of objectIds, as mandated by backend validation. If the length of objectActionKey and object ids are same then it will be passed as it is.. [optional]
                policy_ids ([str]): Filter by Policy ids that are associated with Protected Objects.. [optional]
                parent_id (int): Filter by Parent Id. Parent id is a unique object Id which may contain protected objects underneath in the source tree.. [optional]
                only_protected_objects (bool): If true, the response will include only objects which have been protected.. [optional]
                storage_domain_id (int): Filter by Storage Domain id. Only Objects protected to this Storage Domain will be returned.. [optional]
                environments ([str]): Filter by environment types such as 'kVMware', 'kView', etc. Only Protected objects protecting the specified environment types are returned.. [optional]
                tenant_ids ([str]): TenantIds contains ids of the tenants for which objects are to be returned.. [optional]
                include_tenants (bool): If true, the response will include Objects which were protected by all tenants which the current user has permission to see. If false, then only objects protected by the current user will be returned.. [optional]
                include_last_run_info (bool): If true, the response will include information about the last protection run on this object.. [optional]
                only_auto_protected_objects (bool): If true, the response will include only the auto protected objects.. [optional]
                only_leaf_objects (bool): If true, the response will include only the leaf level objects.. [optional]
                region_ids ([str]): Filter by a list of region ids.. [optional]
                max_count (int): Specifies the max number of objects to return.. [optional]
                cookie (str): Specifies the pagination cookie.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                GetProtectedObjectsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_protected_objects_of_any_type = _Endpoint(
            settings={
                'response_type': (GetProtectedObjectsResponse,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects',
                'operation_id': 'get_protected_objects_of_any_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'request_initiator_type',
                    'ids',
                    'object_action_keys',
                    'policy_ids',
                    'parent_id',
                    'only_protected_objects',
                    'storage_domain_id',
                    'environments',
                    'tenant_ids',
                    'include_tenants',
                    'include_last_run_info',
                    'only_auto_protected_objects',
                    'only_leaf_objects',
                    'region_ids',
                    'max_count',
                    'cookie',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'request_initiator_type',
                    'object_action_keys',
                    'environments',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('request_initiator_type',): {

                        "UIUSER": "UIUser",
                        "UIAUTO": "UIAuto"
                    },
                    ('object_action_keys',): {

                        "KVMWARE": "kVMware",
                        "KHYPERV": "kHyperV",
                        "KVCD": "kVCD",
                        "KAZURE": "kAzure",
                        "KGCP": "kGCP",
                        "KKVM": "kKVM",
                        "KACROPOLIS": "kAcropolis",
                        "KAWS": "kAWS",
                        "KAWSNATIVE": "kAWSNative",
                        "KAWSSNAPSHOTMANAGER": "kAWSSnapshotManager",
                        "KRDSSNAPSHOTMANAGER": "kRDSSnapshotManager",
                        "KAURORASNAPSHOTMANAGER": "kAuroraSnapshotManager",
                        "KPHYSICAL": "kPhysical",
                        "KPHYSICALFILES": "kPhysicalFiles",
                        "KGPFS": "kGPFS",
                        "KELASTIFILE": "kElastifile",
                        "KNETAPP": "kNetapp",
                        "KGENERICNAS": "kGenericNas",
                        "KISILON": "kIsilon",
                        "KFLASHBLADE": "kFlashBlade",
                        "KPURE": "kPure",
                        "KSQL": "kSQL",
                        "KEXCHANGE": "kExchange",
                        "KAD": "kAD",
                        "KORACLE": "kOracle",
                        "KVIEW": "kView",
                        "KREMOTEADAPTER": "kRemoteAdapter",
                        "KO365": "kO365",
                        "KO365PUBLICFOLDERS": "kO365PublicFolders",
                        "KO365TEAMS": "kO365Teams",
                        "KO365GROUP": "kO365Group",
                        "KO365EXCHANGE": "kO365Exchange",
                        "KO365ONEDRIVE": "kO365OneDrive",
                        "KO365SHAREPOINT": "kO365Sharepoint",
                        "KKUBERNETES": "kKubernetes",
                        "KCASSANDRA": "kCassandra",
                        "KMONGODB": "kMongoDB",
                        "KCOUCHBASE": "kCouchbase",
                        "KHDFS": "kHdfs",
                        "KHIVE": "kHive",
                        "KHBASE": "kHBase",
                        "KUDA": "kUDA",
                        "KSFDC": "kSfdc"
                    },
                    ('environments',): {

                        "KVMWARE": "kVMware",
                        "KHYPERV": "kHyperV",
                        "KVCD": "kVCD",
                        "KAZURE": "kAzure",
                        "KGCP": "kGCP",
                        "KKVM": "kKVM",
                        "KACROPOLIS": "kAcropolis",
                        "KAWS": "kAWS",
                        "KAWSNATIVE": "kAWSNative",
                        "KAWSSNAPSHOTMANAGER": "kAWSSnapshotManager",
                        "KRDSSNAPSHOTMANAGER": "kRDSSnapshotManager",
                        "KAURORASNAPSHOTMANAGER": "kAuroraSnapshotManager",
                        "KPHYSICAL": "kPhysical",
                        "KPHYSICALFILES": "kPhysicalFiles",
                        "KGPFS": "kGPFS",
                        "KELASTIFILE": "kElastifile",
                        "KNETAPP": "kNetapp",
                        "KGENERICNAS": "kGenericNas",
                        "KISILON": "kIsilon",
                        "KFLASHBLADE": "kFlashBlade",
                        "KPURE": "kPure",
                        "KSQL": "kSQL",
                        "KEXCHANGE": "kExchange",
                        "KAD": "kAD",
                        "KORACLE": "kOracle",
                        "KVIEW": "kView",
                        "KREMOTEADAPTER": "kRemoteAdapter",
                        "KO365": "kO365",
                        "KO365PUBLICFOLDERS": "kO365PublicFolders",
                        "KO365TEAMS": "kO365Teams",
                        "KO365GROUP": "kO365Group",
                        "KO365EXCHANGE": "kO365Exchange",
                        "KO365ONEDRIVE": "kO365OneDrive",
                        "KO365SHAREPOINT": "kO365Sharepoint",
                        "KKUBERNETES": "kKubernetes",
                        "KCASSANDRA": "kCassandra",
                        "KMONGODB": "kMongoDB",
                        "KCOUCHBASE": "kCouchbase",
                        "KHDFS": "kHdfs",
                        "KHIVE": "kHive",
                        "KHBASE": "kHBase",
                        "KUDA": "kUDA",
                        "KSFDC": "kSfdc"
                    },
                },
                'openapi_types': {
                    'request_initiator_type':
                        (str,),
                    'ids':
                        ([int],),
                    'object_action_keys':
                        ([str],),
                    'policy_ids':
                        ([str],),
                    'parent_id':
                        (int,),
                    'only_protected_objects':
                        (bool,),
                    'storage_domain_id':
                        (int,),
                    'environments':
                        ([str],),
                    'tenant_ids':
                        ([str],),
                    'include_tenants':
                        (bool,),
                    'include_last_run_info':
                        (bool,),
                    'only_auto_protected_objects':
                        (bool,),
                    'only_leaf_objects':
                        (bool,),
                    'region_ids':
                        ([str],),
                    'max_count':
                        (int,),
                    'cookie':
                        (str,),
                },
                'attribute_map': {
                    'request_initiator_type': 'requestInitiatorType',
                    'ids': 'ids',
                    'object_action_keys': 'objectActionKeys',
                    'policy_ids': 'policyIds',
                    'parent_id': 'parentId',
                    'only_protected_objects': 'onlyProtectedObjects',
                    'storage_domain_id': 'storageDomainId',
                    'environments': 'environments',
                    'tenant_ids': 'tenantIds',
                    'include_tenants': 'includeTenants',
                    'include_last_run_info': 'includeLastRunInfo',
                    'only_auto_protected_objects': 'onlyAutoProtectedObjects',
                    'only_leaf_objects': 'onlyLeafObjects',
                    'region_ids': 'regionIds',
                    'max_count': 'maxCount',
                    'cookie': 'cookie',
                },
                'location_map': {
                    'request_initiator_type': 'header',
                    'ids': 'query',
                    'object_action_keys': 'query',
                    'policy_ids': 'query',
                    'parent_id': 'query',
                    'only_protected_objects': 'query',
                    'storage_domain_id': 'query',
                    'environments': 'query',
                    'tenant_ids': 'query',
                    'include_tenants': 'query',
                    'include_last_run_info': 'query',
                    'only_auto_protected_objects': 'query',
                    'only_leaf_objects': 'query',
                    'region_ids': 'query',
                    'max_count': 'query',
                    'cookie': 'query',
                },
                'collection_format_map': {
                    'ids': 'csv',
                    'object_action_keys': 'csv',
                    'policy_ids': 'csv',
                    'environments': 'csv',
                    'tenant_ids': 'csv',
                    'region_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_protected_objects_of_any_type
        )

        def __get_snapshot_diff(
            self,
            id,
            body,
            **kwargs
        ):
            """Get diff between two snapshots of a given object.  # noqa: E501

            Get diff (files added/deleted) between two snapshots of a given object.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_snapshot_diff(id, body, async_req=True)
            >>> result = thread.get()

            Args:
                id (int):
                body (SnapshotDiffParams):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SnapshotDiffResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.get_snapshot_diff = _Endpoint(
            settings={
                'response_type': (SnapshotDiffResult,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/{id}/snapshot-diff',
                'operation_id': 'get_snapshot_diff',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'body',
                ],
                'required': [
                    'id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'body':
                        (SnapshotDiffParams,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__get_snapshot_diff
        )

        def __get_source_hierarchy_objects(
            self,
            source_id,
            **kwargs
        ):
            """List objects on a source which can be used for data protection.  # noqa: E501

            List objects which can be used for data protection.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_source_hierarchy_objects(source_id, async_req=True)
            >>> result = thread.get()

            Args:
                source_id (int): Specifies the source ID for which objects should be returned.

            Keyword Args:
                parent_id (int, none_type): Specifies the parent ID under which objects should be returned.. [optional]
                tenant_ids ([str]): TenantIds contains ids of the tenants for which objects are to be returned.. [optional]
                include_tenants (bool): If true, the response will include Objects which belongs to all tenants which the current user has permission to see.. [optional]
                vmware_object_types ([str]): Specifies the VMware object types to filter objects.. [optional]
                netapp_object_types ([str]): Specifies the Netapp object types to filter objects.. [optional]
                o365_object_types ([str]): Specifies the Office 365 object types to filter objects.. [optional]
                cassandra_object_types ([str]): Specifies the Cassandra object types to filter objects.. [optional]
                mongodb_object_types ([str]): Specifies the Mongo DB object types to filter objects.. [optional]
                couchbase_object_types ([str]): Specifies the Couchbase object types to filter objects.. [optional]
                hdfs_object_types ([str]): Specifies the HDFS object types to filter objects.. [optional]
                hbase_object_types ([str]): Specifies the Hbase object types to filter objects.. [optional]
                hive_object_types ([str]): Specifies the Hive object types to filter objects.. [optional]
                hyperv_object_types ([str]): Specifies the HyperV object types to filter objects.. [optional]
                azure_object_types ([str]): Specifies the Azure object types to filter objects.. [optional]
                kvm_object_types ([str]): Specifies the KVM object types to filter objects.. [optional]
                aws_object_types ([str]): Specifies the AWS object types to filter objects.. [optional]
                gcp_object_types ([str]): Specifies the GCP object types to filter objects.. [optional]
                acropolis_object_types ([str]): Specifies the Acropolis object types to filter objects.. [optional]
                generic_nas_object_types ([str]): Specifies the generic NAS object types to filter objects.. [optional]
                isilon_object_types ([str]): Specifies the Isilon object types to filter objects.. [optional]
                flashblade_object_types ([str]): Specifies the Flashblade object types to filter objects.. [optional]
                elastifile_object_types ([str]): Specifies the Elastifile object types to filter objects.. [optional]
                gpfs_object_types ([str]): Specifies the GPFS object types to filter objects.. [optional]
                pure_object_types ([str]): Specifies the Pure object types to filter objects.. [optional]
                nimble_object_types ([str]): Specifies the Nimble object types to filter objects.. [optional]
                physical_object_types ([str]): Specifies the Physical object types to filter objects.. [optional]
                kubernetes_object_types ([str]): Specifies the Kubernetes object types to filter objects.. [optional]
                exchange_object_types ([str]): Specifies the Exchange object types to filter objects.. [optional]
                ad_object_types ([str]): Specifies the AD object types to filter objects.. [optional]
                mssql_object_types ([str]): Specifies the MSSQL object types to filter objects.. [optional]
                oracle_object_types ([str]): Specifies the Oracle object types to filter objects.. [optional]
                use_cached_data (bool): Specifies whether we can serve the GET request to the read replica cache. There is a lag of 15 seconds between the read replica and primary data source.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SourceHierarchyObjectSummaries
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['source_id'] = \
                source_id
            return self.call_with_http_info(**kwargs)

        self.get_source_hierarchy_objects = _Endpoint(
            settings={
                'response_type': (SourceHierarchyObjectSummaries,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/sources/{sourceId}/objects',
                'operation_id': 'get_source_hierarchy_objects',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_id',
                    'parent_id',
                    'tenant_ids',
                    'include_tenants',
                    'vmware_object_types',
                    'netapp_object_types',
                    'o365_object_types',
                    'cassandra_object_types',
                    'mongodb_object_types',
                    'couchbase_object_types',
                    'hdfs_object_types',
                    'hbase_object_types',
                    'hive_object_types',
                    'hyperv_object_types',
                    'azure_object_types',
                    'kvm_object_types',
                    'aws_object_types',
                    'gcp_object_types',
                    'acropolis_object_types',
                    'generic_nas_object_types',
                    'isilon_object_types',
                    'flashblade_object_types',
                    'elastifile_object_types',
                    'gpfs_object_types',
                    'pure_object_types',
                    'nimble_object_types',
                    'physical_object_types',
                    'kubernetes_object_types',
                    'exchange_object_types',
                    'ad_object_types',
                    'mssql_object_types',
                    'oracle_object_types',
                    'use_cached_data',
                ],
                'required': [
                    'source_id',
                ],
                'nullable': [
                    'parent_id',
                ],
                'enum': [
                    'vmware_object_types',
                    'netapp_object_types',
                    'o365_object_types',
                    'cassandra_object_types',
                    'mongodb_object_types',
                    'couchbase_object_types',
                    'hdfs_object_types',
                    'hbase_object_types',
                    'hive_object_types',
                    'hyperv_object_types',
                    'azure_object_types',
                    'kvm_object_types',
                    'aws_object_types',
                    'gcp_object_types',
                    'acropolis_object_types',
                    'generic_nas_object_types',
                    'isilon_object_types',
                    'flashblade_object_types',
                    'elastifile_object_types',
                    'gpfs_object_types',
                    'pure_object_types',
                    'nimble_object_types',
                    'physical_object_types',
                    'kubernetes_object_types',
                    'exchange_object_types',
                    'ad_object_types',
                    'mssql_object_types',
                    'oracle_object_types',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('vmware_object_types',): {

                        "KVCENTER": "kVCenter",
                        "KSTANDALONEHOST": "kStandaloneHost",
                        "KVCLOUDDIRECTOR": "kvCloudDirector",
                        "KFOLDER": "kFolder",
                        "KDATACENTER": "kDatacenter",
                        "KCOMPUTERESOURCE": "kComputeResource",
                        "KCLUSTERCOMPUTERESOURCE": "kClusterComputeResource",
                        "KRESOURCEPOOL": "kResourcePool",
                        "KDATASTORE": "kDatastore",
                        "KHOSTSYSTEM": "kHostSystem",
                        "KVIRTUALMACHINE": "kVirtualMachine",
                        "KVIRTUALAPP": "kVirtualApp",
                        "KSTORAGEPOD": "kStoragePod",
                        "KNETWORK": "kNetwork",
                        "KDISTRIBUTEDVIRTUALPORTGROUP": "kDistributedVirtualPortgroup",
                        "KTAGCATEGORY": "kTagCategory",
                        "KTAG": "kTag",
                        "KOPAQUENETWORK": "kOpaqueNetwork",
                        "KORGANIZATION": "kOrganization",
                        "KVIRTUALDATACENTER": "kVirtualDatacenter",
                        "KCATALOG": "kCatalog",
                        "KORGMETADATA": "kOrgMetadata",
                        "KSTORAGEPOLICY": "kStoragePolicy",
                        "KVIRTUALAPPTEMPLATE": "kVirtualAppTemplate"
                    },
                    ('netapp_object_types',): {

                        "KCLUSTER": "kCluster",
                        "KVSERVER": "kVserver",
                        "KVOLUME": "kVolume"
                    },
                    ('o365_object_types',): {

                        "KDOMAIN": "kDomain",
                        "KOUTLOOK": "kOutlook",
                        "KMAILBOX": "kMailbox",
                        "KUSERS": "kUsers",
                        "KGROUPS": "kGroups",
                        "KSITES": "kSites",
                        "KUSER": "kUser",
                        "KGROUP": "kGroup",
                        "KSITE": "kSite",
                        "KAPPLICATION": "kApplication",
                        "KGRAPHUSER": "kGraphUser",
                        "KPUBLICFOLDERS": "kPublicFolders",
                        "KPUBLICFOLDER": "kPublicFolder",
                        "KTEAMS": "kTeams",
                        "KTEAM": "kTeam",
                        "KROOTPUBLICFOLDER": "kRootPublicFolder",
                        "KO365EXCHANGE": "kO365Exchange",
                        "KO365ONEDRIVE": "kO365OneDrive",
                        "KO365SHAREPOINT": "kO365Sharepoint"
                    },
                    ('cassandra_object_types',): {

                        "KCLUSTER": "kCluster",
                        "KKEYSPACE": "kKeyspace",
                        "KTABLE": "kTable"
                    },
                    ('mongodb_object_types',): {

                        "KCLUSTER": "kCluster",
                        "KDATABASE": "kDatabase",
                        "KCOLLECTION": "kCollection"
                    },
                    ('couchbase_object_types',): {

                        "KCLUSTER": "kCluster",
                        "KBUCKET": "kBucket"
                    },
                    ('hdfs_object_types',): {

                        "KCLUSTER": "kCluster"
                    },
                    ('hbase_object_types',): {

                        "KCLUSTER": "kCluster",
                        "KNAMESPACE": "kNamespace",
                        "KTABLE": "kTable"
                    },
                    ('hive_object_types',): {

                        "KCLUSTER": "kCluster",
                        "KDATABASE": "kDatabase",
                        "KTABLE": "kTable"
                    },
                    ('hyperv_object_types',): {

                        "KSCVMMSERVER": "kSCVMMServer",
                        "KSTANDALONEHOST": "kStandaloneHost",
                        "KSTANDALONECLUSTER": "kStandaloneCluster",
                        "KHOSTGROUP": "kHostGroup",
                        "KHYPERVHOST": "kHypervHost",
                        "KHOSTCLUSTER": "kHostCluster",
                        "KVIRTUALMACHINE": "kVirtualMachine",
                        "KNETWORK": "kNetwork",
                        "KDATASTORE": "kDatastore",
                        "KTAG": "kTag",
                        "KCUSTOMPROPERTY": "kCustomProperty"
                    },
                    ('azure_object_types',): {

                        "KSUBSCRIPTION": "kSubscription",
                        "KRESOURCEGROUP": "kResourceGroup",
                        "KVIRTUALMACHINE": "kVirtualMachine",
                        "KSTORAGEACCOUNT": "kStorageAccount",
                        "KSTORAGEKEY": "kStorageKey",
                        "KSTORAGECONTAINER": "kStorageContainer",
                        "KSTORAGEBLOB": "kStorageBlob",
                        "KNETWORKSECURITYGROUP": "kNetworkSecurityGroup",
                        "KVIRTUALNETWORK": "kVirtualNetwork",
                        "KSUBNET": "kSubnet",
                        "KCOMPUTEOPTIONS": "kComputeOptions",
                        "KSNAPSHOTMANAGERPERMIT": "kSnapshotManagerPermit",
                        "KTAG": "kTag",
                        "KAVAILABILITYSET": "kAvailabilitySet"
                    },
                    ('kvm_object_types',): {

                        "KOVIRTMANAGER": "kOVirtManager",
                        "KSTANDALONEHOST": "kStandaloneHost",
                        "KDATACENTER": "kDatacenter",
                        "KCLUSTER": "kCluster",
                        "KHOST": "kHost",
                        "KVIRTUALMACHINE": "kVirtualMachine",
                        "KNETWORK": "kNetwork",
                        "KSTORAGEDOMAIN": "kStorageDomain",
                        "KVNICPROFILE": "kVNicProfile"
                    },
                    ('aws_object_types',): {

                        "KIAMUSER": "kIAMUser",
                        "KREGION": "kRegion",
                        "KAVAILABILITYZONE": "kAvailabilityZone",
                        "KEC2INSTANCE": "kEC2Instance",
                        "KVPC": "kVPC",
                        "KSUBNET": "kSubnet",
                        "KNETWORKSECURITYGROUP": "kNetworkSecurityGroup",
                        "KINSTANCETYPE": "kInstanceType",
                        "KKEYPAIR": "kKeyPair",
                        "KTAG": "kTag",
                        "KRDSOPTIONGROUP": "kRDSOptionGroup",
                        "KRDSPARAMETERGROUP": "kRDSParameterGroup",
                        "KRDSINSTANCE": "kRDSInstance",
                        "KRDSSUBNET": "kRDSSubnet",
                        "KRDSTAG": "kRDSTag",
                        "KAURORATAG": "kAuroraTag",
                        "KAURORACLUSTER": "kAuroraCluster",
                        "KACCOUNT": "kAccount",
                        "KSUBTASKPERMIT": "kSubTaskPermit"
                    },
                    ('gcp_object_types',): {

                        "KIAMUSER": "kIAMUser",
                        "KPROJECT": "kProject",
                        "KREGION": "kRegion",
                        "KAVAILABILITYZONE": "kAvailabilityZone",
                        "KVIRTUALMACHINE": "kVirtualMachine",
                        "KVPC": "kVPC",
                        "KSUBNET": "kSubnet",
                        "KNETWORKSECURITYGROUP": "kNetworkSecurityGroup",
                        "KINSTANCETYPE": "kInstanceType",
                        "KLABEL": "kLabel",
                        "KMETADATA": "kMetadata",
                        "KTAG": "kTag",
                        "KVPCCONNECTOR": "kVPCConnector"
                    },
                    ('acropolis_object_types',): {

                        "KPRISMCENTRAL": "kPrismCentral",
                        "KSTANDALONECLUSTER": "kStandaloneCluster",
                        "KOTHERHYPERVISORCLUSTER": "kOtherHypervisorCluster",
                        "KCLUSTER": "kCluster",
                        "KHOST": "kHost",
                        "KVIRTUALMACHINE": "kVirtualMachine",
                        "KNETWORK": "kNetwork",
                        "KSTORAGECONTAINER": "kStorageContainer"
                    },
                    ('generic_nas_object_types',): {

                        "KGROUP": "kGroup",
                        "KHOST": "kHost",
                        "KDFSGROUP": "kDfsGroup",
                        "KDFSTOPDIR": "kDfsTopDir"
                    },
                    ('isilon_object_types',): {

                        "KCLUSTER": "kCluster",
                        "KZONE": "kZone",
                        "KMOUNTPOINT": "kMountPoint"
                    },
                    ('flashblade_object_types',): {

                        "KSTORAGEARRAY": "kStorageArray",
                        "KFILESYSTEM": "kFileSystem"
                    },
                    ('elastifile_object_types',): {

                        "KCLUSTER": "kCluster",
                        "KCONTAINER": "kContainer"
                    },
                    ('gpfs_object_types',): {

                        "KCLUSTER": "kCluster",
                        "KFILESYSTEM": "kFilesystem",
                        "KFILESET": "kFileset"
                    },
                    ('pure_object_types',): {

                        "KSTORAGEARRAY": "kStorageArray",
                        "KVOLUME": "kVolume"
                    },
                    ('nimble_object_types',): {

                        "KSTORAGEARRAY": "kStorageArray",
                        "KVOLUME": "kVolume"
                    },
                    ('physical_object_types',): {

                        "KGROUP": "kGroup",
                        "KHOST": "kHost",
                        "KWINDOWSCLUSTER": "kWindowsCluster",
                        "KORACLERACCLUSTER": "kOracleRACCluster",
                        "KORACLEAPCLUSTER": "kOracleAPCluster"
                    },
                    ('kubernetes_object_types',): {

                        "KCLUSTER": "kCluster",
                        "KNAMESPACE": "kNamespace",
                        "KSERVICE": "kService",
                        "KPVC": "kPVC",
                        "KPERSISTENTVOLUMECLAIM": "kPersistentVolumeClaim",
                        "KPERSISTENTVOLUME": "kPersistentVolume",
                        "KLABEL": "kLabel"
                    },
                    ('exchange_object_types',): {

                        "KROOTCONTAINER": "kRootContainer",
                        "KDAGROOTCONTAINER": "kDAGRootContainer",
                        "KEXCHANGENODE": "kExchangeNode",
                        "KEXCHANGEDAGDATABASECOPY": "kExchangeDAGDatabaseCopy",
                        "KEXCHANGESTANDALONEDATABASE": "kExchangeStandaloneDatabase",
                        "KEXCHANGEDAG": "kExchangeDAG",
                        "KEXCHANGEDAGDATABASE": "kExchangeDAGDatabase"
                    },
                    ('ad_object_types',): {

                        "KROOTCONTAINER": "kRootContainer",
                        "KDOMAINCONTROLLER": "kDomainController"
                    },
                    ('mssql_object_types',): {

                        "KINSTANCE": "kInstance",
                        "KDATABASE": "kDatabase",
                        "KAAG": "kAAG",
                        "KAAGROOTCONTAINER": "kAAGRootContainer",
                        "KROOTCONTAINER": "kRootContainer"
                    },
                    ('oracle_object_types',): {

                        "KRACROOTCONTAINER": "kRACRootContainer",
                        "KROOTCONTAINER": "kRootContainer",
                        "KHOST": "kHost",
                        "KDATABASE": "kDatabase",
                        "KTABLESPACE": "kTableSpace",
                        "KTABLE": "kTable",
                        "KPDB": "kPDB"
                    },
                },
                'openapi_types': {
                    'source_id':
                        (int,),
                    'parent_id':
                        (int, none_type,),
                    'tenant_ids':
                        ([str],),
                    'include_tenants':
                        (bool,),
                    'vmware_object_types':
                        ([str],),
                    'netapp_object_types':
                        ([str],),
                    'o365_object_types':
                        ([str],),
                    'cassandra_object_types':
                        ([str],),
                    'mongodb_object_types':
                        ([str],),
                    'couchbase_object_types':
                        ([str],),
                    'hdfs_object_types':
                        ([str],),
                    'hbase_object_types':
                        ([str],),
                    'hive_object_types':
                        ([str],),
                    'hyperv_object_types':
                        ([str],),
                    'azure_object_types':
                        ([str],),
                    'kvm_object_types':
                        ([str],),
                    'aws_object_types':
                        ([str],),
                    'gcp_object_types':
                        ([str],),
                    'acropolis_object_types':
                        ([str],),
                    'generic_nas_object_types':
                        ([str],),
                    'isilon_object_types':
                        ([str],),
                    'flashblade_object_types':
                        ([str],),
                    'elastifile_object_types':
                        ([str],),
                    'gpfs_object_types':
                        ([str],),
                    'pure_object_types':
                        ([str],),
                    'nimble_object_types':
                        ([str],),
                    'physical_object_types':
                        ([str],),
                    'kubernetes_object_types':
                        ([str],),
                    'exchange_object_types':
                        ([str],),
                    'ad_object_types':
                        ([str],),
                    'mssql_object_types':
                        ([str],),
                    'oracle_object_types':
                        ([str],),
                    'use_cached_data':
                        (bool,),
                },
                'attribute_map': {
                    'source_id': 'sourceId',
                    'parent_id': 'parentId',
                    'tenant_ids': 'tenantIds',
                    'include_tenants': 'includeTenants',
                    'vmware_object_types': 'vmwareObjectTypes',
                    'netapp_object_types': 'netappObjectTypes',
                    'o365_object_types': 'o365ObjectTypes',
                    'cassandra_object_types': 'cassandraObjectTypes',
                    'mongodb_object_types': 'mongodbObjectTypes',
                    'couchbase_object_types': 'couchbaseObjectTypes',
                    'hdfs_object_types': 'hdfsObjectTypes',
                    'hbase_object_types': 'hbaseObjectTypes',
                    'hive_object_types': 'hiveObjectTypes',
                    'hyperv_object_types': 'hypervObjectTypes',
                    'azure_object_types': 'azureObjectTypes',
                    'kvm_object_types': 'kvmObjectTypes',
                    'aws_object_types': 'awsObjectTypes',
                    'gcp_object_types': 'gcpObjectTypes',
                    'acropolis_object_types': 'acropolisObjectTypes',
                    'generic_nas_object_types': 'genericNasObjectTypes',
                    'isilon_object_types': 'isilonObjectTypes',
                    'flashblade_object_types': 'flashbladeObjectTypes',
                    'elastifile_object_types': 'elastifileObjectTypes',
                    'gpfs_object_types': 'gpfsObjectTypes',
                    'pure_object_types': 'pureObjectTypes',
                    'nimble_object_types': 'nimbleObjectTypes',
                    'physical_object_types': 'physicalObjectTypes',
                    'kubernetes_object_types': 'kubernetesObjectTypes',
                    'exchange_object_types': 'exchangeObjectTypes',
                    'ad_object_types': 'adObjectTypes',
                    'mssql_object_types': 'mssqlObjectTypes',
                    'oracle_object_types': 'oracleObjectTypes',
                    'use_cached_data': 'useCachedData',
                },
                'location_map': {
                    'source_id': 'path',
                    'parent_id': 'query',
                    'tenant_ids': 'query',
                    'include_tenants': 'query',
                    'vmware_object_types': 'query',
                    'netapp_object_types': 'query',
                    'o365_object_types': 'query',
                    'cassandra_object_types': 'query',
                    'mongodb_object_types': 'query',
                    'couchbase_object_types': 'query',
                    'hdfs_object_types': 'query',
                    'hbase_object_types': 'query',
                    'hive_object_types': 'query',
                    'hyperv_object_types': 'query',
                    'azure_object_types': 'query',
                    'kvm_object_types': 'query',
                    'aws_object_types': 'query',
                    'gcp_object_types': 'query',
                    'acropolis_object_types': 'query',
                    'generic_nas_object_types': 'query',
                    'isilon_object_types': 'query',
                    'flashblade_object_types': 'query',
                    'elastifile_object_types': 'query',
                    'gpfs_object_types': 'query',
                    'pure_object_types': 'query',
                    'nimble_object_types': 'query',
                    'physical_object_types': 'query',
                    'kubernetes_object_types': 'query',
                    'exchange_object_types': 'query',
                    'ad_object_types': 'query',
                    'mssql_object_types': 'query',
                    'oracle_object_types': 'query',
                    'use_cached_data': 'query',
                },
                'collection_format_map': {
                    'tenant_ids': 'csv',
                    'vmware_object_types': 'csv',
                    'netapp_object_types': 'csv',
                    'o365_object_types': 'csv',
                    'cassandra_object_types': 'csv',
                    'mongodb_object_types': 'csv',
                    'couchbase_object_types': 'csv',
                    'hdfs_object_types': 'csv',
                    'hbase_object_types': 'csv',
                    'hive_object_types': 'csv',
                    'hyperv_object_types': 'csv',
                    'azure_object_types': 'csv',
                    'kvm_object_types': 'csv',
                    'aws_object_types': 'csv',
                    'gcp_object_types': 'csv',
                    'acropolis_object_types': 'csv',
                    'generic_nas_object_types': 'csv',
                    'isilon_object_types': 'csv',
                    'flashblade_object_types': 'csv',
                    'elastifile_object_types': 'csv',
                    'gpfs_object_types': 'csv',
                    'pure_object_types': 'csv',
                    'nimble_object_types': 'csv',
                    'physical_object_types': 'csv',
                    'kubernetes_object_types': 'csv',
                    'exchange_object_types': 'csv',
                    'ad_object_types': 'csv',
                    'mssql_object_types': 'csv',
                    'oracle_object_types': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_source_hierarchy_objects
        )

        def __internal_api_construct_meta_info(
            self,
            snapshot_id,
            body,
            **kwargs
        ):
            """Construct meta info for any workflow from object snapshot and some other information.  # noqa: E501

            Construct meta info from object snapshot and some additional params.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.internal_api_construct_meta_info(snapshot_id, body, async_req=True)
            >>> result = thread.get()

            Args:
                snapshot_id (str): Specifies the snapshot id.
                body (ConstructMetaInfoParams): Specifies the parameters to construct meta info for desired workflow.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ConstructMetaInfoResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['snapshot_id'] = \
                snapshot_id
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.internal_api_construct_meta_info = _Endpoint(
            settings={
                'response_type': (ConstructMetaInfoResult,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/snapshots/{snapshotId}/metaInfo',
                'operation_id': 'internal_api_construct_meta_info',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'snapshot_id',
                    'body',
                ],
                'required': [
                    'snapshot_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'snapshot_id':
                        (str,),
                    'body':
                        (ConstructMetaInfoParams,),
                },
                'attribute_map': {
                    'snapshot_id': 'snapshotId',
                },
                'location_map': {
                    'snapshot_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__internal_api_construct_meta_info
        )

        def __internal_api_get_snapshot_diff(
            self,
            id,
            body,
            **kwargs
        ):
            """Get diff between two snapshots of a given object.  # noqa: E501

            Get diff (files added/deleted) between two snapshots of a given object.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.internal_api_get_snapshot_diff(id, body, async_req=True)
            >>> result = thread.get()

            Args:
                id (int):
                body (SnapshotDiffParams):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SnapshotDiffResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.internal_api_get_snapshot_diff = _Endpoint(
            settings={
                'response_type': (SnapshotDiffResult,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/{id}/snapshotDiff',
                'operation_id': 'internal_api_get_snapshot_diff',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'body',
                ],
                'required': [
                    'id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'body':
                        (SnapshotDiffParams,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__internal_api_get_snapshot_diff
        )

        def __objects_actions(
            self,
            body,
            **kwargs
        ):
            """Actions on Objects  # noqa: E501

            Specifies the request to perform various actions on multiple objects.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.objects_actions(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ObjectsActionRequest): Specifies the paramteres to execute actions on given list of objects.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.objects_actions = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/actions',
                'operation_id': 'objects_actions',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ObjectsActionRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__objects_actions
        )

        def __perform_action_on_object(
            self,
            id,
            body,
            **kwargs
        ):
            """Perform an action on an object.  # noqa: E501

            Perform an action on an object. Depending on the object environment type, different actions are available.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.perform_action_on_object(id, body, async_req=True)
            >>> result = thread.get()

            Args:
                id (int): Specifies the id of the Object.
                body (CommonObjectActionRequestd8e311a83f104ddcB60d8e62f77f28c8): Specifies the parameters to perform an action on an object.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.perform_action_on_object = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/{id}/actions',
                'operation_id': 'perform_action_on_object',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'body',
                ],
                'required': [
                    'id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'body':
                        (CommonObjectActionRequestd8e311a83f104ddcB60d8e62f77f28c8,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__perform_action_on_object
        )

        def __update_object_snapshot(
            self,
            id,
            snapshot_id,
            body,
            **kwargs
        ):
            """Update an object snapshot.  # noqa: E501

            Update an object snapshot.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_object_snapshot(id, snapshot_id, body, async_req=True)
            >>> result = thread.get()

            Args:
                id (int): Specifies the id of the Object.
                snapshot_id (str): Specifies the id of the snapshot.<br> Note: 1. If the snapshotid of one of the apps is specified, it applies for all the databases in the Protection Run.<br> 2. In case of volume based jobs, please specify the snapshotid of the source not the database. if source snapshot is specified, applied to source snapshot. if database snapshotid is specified in case of volume based jobs, then it is applicable for host's snapshot.
                body (UpdateObjectSnapshotRequest): Specifies the parameters update an object snapshot.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjectSnapshot
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['snapshot_id'] = \
                snapshot_id
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_object_snapshot = _Endpoint(
            settings={
                'response_type': (ObjectSnapshot,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/objects/{id}/snapshots/{snapshotId}',
                'operation_id': 'update_object_snapshot',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'snapshot_id',
                    'body',
                ],
                'required': [
                    'id',
                    'snapshot_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'snapshot_id':
                        (str,),
                    'body':
                        (UpdateObjectSnapshotRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                    'snapshot_id': 'snapshotId',
                },
                'location_map': {
                    'id': 'path',
                    'snapshot_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_object_snapshot
        )
