from tornado import web

from . import (
    configuration_systems,
    cookie_cutters,
    data_centers,
    deployment_types,
    environments,
    groups,
    namespaces,
    openapi,
    orchestration_systems,
    permissions,
    project_dependencies,
    project_fact_type_options,
    project_fact_types,
    project_link_types,
    project_links,
    project_types,
    projects,
    status,
    ui
)

URLS = [
   web.url(r'^/$', ui.IndexRequestHandler),
   web.url(r'^/api-docs/$', openapi.RequestHandler),
   web.url(r'^/api-docs/(openapi.yaml)$', openapi.RequestHandler),
   web.url(r'^/configuration-systems$',
           configuration_systems.CollectionRequestHandler),
   web.url(r'^/configuration-systems/(?P<name>[\w_\-%\+]+)$',
           configuration_systems.RecordRequestHandler,
           name='configuration-system'),
   web.url(r'^/cookie-cutters$',
           cookie_cutters.CollectionRequestHandler),
   web.url(r'^/cookie-cutters/(?P<name>[\w_\-%\+]+)$',
           cookie_cutters.RecordRequestHandler,
           name='cookie-cutter'),
   web.url(r'^/deployment-types$',
           deployment_types.CollectionRequestHandler),
   web.url(r'^/deployment-types/(?P<name>[\w_\-%\+]+$)',
           deployment_types.RecordRequestHandler,
           name='deployment-type'),
   web.url(r'^/data-centers$', data_centers.CollectionRequestHandler),
   web.url(r'^/data-centers/(?P<name>[\w_\-%\+]+)$',
           data_centers.RecordRequestHandler,
           name='data-center'),
   web.url(r'^/environments$', environments.CollectionRequestHandler),
   web.url(r'^/environments/(?P<name>[\w_\-%\+]+)$',
           environments.RecordRequestHandler,
           name='environment'),
   web.url(r'^/groups$', groups.CollectionRequestHandler),
   web.url(r'^/groups/(?P<name>[\w_\-%\+]+)$', groups.RecordRequestHandler,
           name='group'),
   web.url(r'^/namespaces$', namespaces.CollectionRequestHandler),
   web.url(r'^/namespaces/(?P<id>\d+)$', namespaces.RecordRequestHandler,
           name='namespace'),
   web.url(r'^/orchestration-systems$',
           orchestration_systems.CollectionRequestHandler),
   web.url(r'^/orchestration-systems/(?P<name>[\w_\-%\+]+)$',
           orchestration_systems.RecordRequestHandler,
           name='orchestration-system'),
   web.url(r'^/permissions$', permissions.RequestHandler),
   web.url(r'^/project-fact-types$',
           project_fact_types.CollectionRequestHandler),
   web.url(r'^/project-fact-types/(?P<id>\d+)$',
           project_fact_types.RecordRequestHandler,
           name='project-fact-type'),
   web.url(r'^/project-fact-type-options$',
           project_fact_type_options.CollectionRequestHandler),
   web.url(r'^/project-fact-type-options/(?P<id>\d+)$',
           project_fact_type_options.RecordRequestHandler,
           name='project-fact-type-option'),
   web.url(r'^/project-link-types$',
           project_link_types.CollectionRequestHandler),
   web.url(r'^/project-link-types/(?P<id>\d+)$',
           project_link_types.RecordRequestHandler,
           name='project-link-type'),
   web.url(r'^/project-types$', project_types.CollectionRequestHandler),
   web.url(r'^/project-types/(?P<id>\d+)$',
           project_types.RecordRequestHandler,
           name='project-type'),
   web.url(r'^/projects$', projects.CollectionRequestHandler,
           name='projects'),
   web.url(r'^/projects/(?P<id>\d+)$', projects.RecordRequestHandler,
           name='project'),
   web.url(r'^/projects/(?P<project_id>\d+)/dependencies$',
           project_dependencies.CollectionRequestHandler,
           name='project-dependencies'),
   web.url(r'^/projects/(?P<project_id>\d+)/dependencies/'
           r'(?P<dependency_id>\d+)$',
           project_dependencies.RecordRequestHandler,
           name='project-dependency'),
   web.url(r'^/projects/(?P<project_id>\d+)/links$',
           project_links.CollectionRequestHandler,
           name='project-links'),
   web.url(r'^/projects/(?P<project_id>\d+)/links/'
           r'(?P<link_type_id>\d+)$',
           project_links.RecordRequestHandler,
           name='project-link'),
   web.url(r'^/status$', status.RequestHandler),
   web.url(r'^/ui/groups$', ui.GroupsRequestHandler),
   web.url(r'^/ui/login$', ui.LoginRequestHandler),
   web.url(r'^/ui/logout$', ui.LogoutRequestHandler),
   web.url(r'^/ui/user$', ui.UserRequestHandler),
   web.url(r'^/ui/.*$', ui.IndexRequestHandler)
]
