# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cambai.models.languages import Languages
from typing import Optional, Set
from typing_extensions import Self

class VoiceItem(BaseModel):
    """
    VoiceItem
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="A unique identifier for the voice record. Each voice is assigned a distinct `id` for reference")
    voice_name: Optional[StrictStr] = Field(default=None, description="The name or label assigned to the voice.")
    gender: Optional[StrictInt] = Field(default=None, description="Represents the gender of the voice. Values are encoded as integers.")
    age: Optional[StrictInt] = Field(default=None, description="The age of the voice represented as an integer. If the age is unknown or not applicable, the value is `null`.")
    description: Optional[StrictStr] = Field(default=None, description="A brief summary of the custom voice—e.g. its intended use, tone or character traits.")
    transcript: Optional[StrictStr] = Field(default=None, description="The transcribed text of the voice recording, if available.")
    is_published: Optional[StrictBool] = Field(default=None, description="Specifies whether the voice is shared on the marketplace or not.")
    language: Optional[Languages] = Field(default=None, description="The language specified when creating the custom voice.")
    __properties: ClassVar[List[str]] = ["id", "voice_name", "gender", "age", "description", "transcript", "is_published", "language"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VoiceItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VoiceItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "voice_name": obj.get("voice_name"),
            "gender": obj.get("gender"),
            "age": obj.get("age"),
            "description": obj.get("description"),
            "transcript": obj.get("transcript"),
            "is_published": obj.get("is_published"),
            "language": obj.get("language")
        })
        return _obj


