# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cambai.models.dialogue_item import DialogueItem
from typing import Optional, Set
from typing_extensions import Self

class StoryRunInfoResponse(BaseModel):
    """
    StoryRunInfoResponse
    """ # noqa: E501
    audio_url: Optional[StrictStr] = Field(default=None, description="The URL pointing to the generated audio file for the story.")
    dialogue_url: Optional[StrictStr] = Field(default=None, description="The URL pointing to the audio file that contains the story's dialogue.")
    transcript: Optional[List[DialogueItem]] = Field(default=None, description="A collection of dialogue items representing the textual transcript of the story.")
    __properties: ClassVar[List[str]] = ["audio_url", "dialogue_url", "transcript"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StoryRunInfoResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in transcript (list)
        _items = []
        if self.transcript:
            for _item_transcript in self.transcript:
                if _item_transcript:
                    _items.append(_item_transcript.to_dict())
            _dict['transcript'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StoryRunInfoResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "audio_url": obj.get("audio_url"),
            "dialogue_url": obj.get("dialogue_url"),
            "transcript": [DialogueItem.from_dict(_item) for _item in obj["transcript"]] if obj.get("transcript") is not None else None
        })
        return _obj


