# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cambai.models.languages import Languages
from typing import Optional, Set
from typing_extensions import Self

class EndToEndDubbingRequestPayload(BaseModel):
    """
    EndToEndDubbingRequestPayload
    """ # noqa: E501
    video_url: StrictStr = Field(description="The URL of the media file to be used to create the end-to-end dubbing task.")
    source_language: Languages = Field(description="The original language of the media file to be used to create the end-to-end dubbing task.")
    target_languages: Optional[List[Languages]] = Field(default=None, description="The list of desired languages that the media file will be dubbed to.")
    selected_audio_tracks: Optional[Annotated[List[Optional[StrictInt]], Field(min_length=1, max_length=2)]] = Field(default=None, description="Optional array of one or two zero‑based audio track indices to dub. Only supported for `MXF` files. If omitted, the first audio track (index 0) is used by default.")
    add_output_as_an_audio_track: Optional[StrictBool] = Field(default=None, description="Optional flag to append the dubbed audio as a new audio track in the output file. Only supported for `MXF` files. If `true`, the dubbed audio is added as an additional track; if `false` or omitted, the source would be returned with only dubbed audio.")
    chosen_dictionaries: Optional[Annotated[List[StrictInt], Field(min_length=1)]] = Field(default=None, description="An optional list of dictionary IDs selected by the user. Each entry must be an integer corresponding to a valid dictionary ID. If provided, at least one ID is required.")
    __properties: ClassVar[List[str]] = ["video_url", "source_language", "target_languages", "selected_audio_tracks", "add_output_as_an_audio_track", "chosen_dictionaries"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EndToEndDubbingRequestPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EndToEndDubbingRequestPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "video_url": obj.get("video_url"),
            "source_language": obj.get("source_language"),
            "target_languages": obj.get("target_languages"),
            "selected_audio_tracks": obj.get("selected_audio_tracks"),
            "add_output_as_an_audio_track": obj.get("add_output_as_an_audio_track"),
            "chosen_dictionaries": obj.get("chosen_dictionaries")
        })
        return _obj


