# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cambai.models.gender import Gender
from cambai.models.languages import Languages
from cambai.models.tts_stream_output_format import TTSStreamOutputFormat
from typing import Optional, Set
from typing_extensions import Self

class CreateTTSStreamRequestPayload(BaseModel):
    """
    CreateTTSStreamRequestPayload
    """ # noqa: E501
    text: StrictStr = Field(description="The content you want converted into spoken audio. This can be anything from a single sentence to paragraphs of text, supporting punctuation for natural speech patterns.")
    voice_id: StrictInt = Field(description="The unique identifier for your selected voice profile. You can obtain available voice IDs from the `/list-voices` endpoint or create custom voices with the `/create-custom-voice` endpoint.")
    language: Languages = Field(description="The source language of your input text. This helps the system apply the correct pronunciation rules and speech patterns.")
    gender: Optional[Gender] = Field(default=None, description="The preferred gender characteristics of the synthesized voice (`0 = Not Specified, 1 = Male, 2 = Female, 9 = Not Applicable`). Defaults to `null`.")
    age: Optional[StrictInt] = Field(default=None, description="The approximate age (between 1-100 years) to be reflected in the voice characteristics. This parameter helps fine-tune the timbre and speech patterns to match different age groups.")
    output_format: Optional[TTSStreamOutputFormat] = Field(default=None, description="The audio file format for the generated speech stream.")
    __properties: ClassVar[List[str]] = ["text", "voice_id", "language", "gender", "age", "output_format"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateTTSStreamRequestPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateTTSStreamRequestPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "text": obj.get("text"),
            "voice_id": obj.get("voice_id"),
            "language": obj.get("language"),
            "gender": obj.get("gender"),
            "age": obj.get("age"),
            "output_format": obj.get("output_format")
        })
        return _obj


