# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cambai.models.formalities import Formalities
from cambai.models.gender import Gender
from cambai.models.languages import Languages
from typing import Optional, Set
from typing_extensions import Self

class BodyTranslateTranslatePost(BaseModel):
    """
    BodyTranslateTranslatePost
    """ # noqa: E501
    source_language: Languages
    target_language: Languages
    texts: List[StrictStr]
    age: Optional[StrictInt] = None
    formality: Optional[Formalities] = Field(default=None, description="Specifies whether the translated text should be formal or informal. For example, `1` (formal) may use polite language, while `2` (informal) may use casual or colloquial language.")
    gender: Optional[Gender] = None
    chosen_dictionaries: Optional[Annotated[List[StrictInt], Field(min_length=1)]] = Field(default=None, description="An optional list of dictionary IDs selected by the user. Each entry must be an integer corresponding to a valid dictionary ID. If provided, at least one ID is required.")
    __properties: ClassVar[List[str]] = ["source_language", "target_language", "texts", "age", "formality", "gender", "chosen_dictionaries"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BodyTranslateTranslatePost from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BodyTranslateTranslatePost from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "source_language": obj.get("source_language"),
            "target_language": obj.get("target_language"),
            "texts": obj.get("texts"),
            "age": obj.get("age"),
            "formality": obj.get("formality"),
            "gender": obj.get("gender"),
            "chosen_dictionaries": obj.get("chosen_dictionaries")
        })
        return _obj


