# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import unittest

import swagger_client
from swagger_client.api.containers_api import ContainersApi  # noqa: E501
from swagger_client.rest import ApiException


class TestContainersApi(unittest.TestCase):
    """ContainersApi unit test stubs"""

    def setUp(self):
        self.api = ContainersApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_archive_container(self):
        """Test case for archive_container

        ArchiveContainer  # noqa: E501
        """
        pass

    def test_container_batch_update(self):
        """Test case for container_batch_update

        ContainerBatchUpdate  # noqa: E501
        """
        pass

    def test_create_container(self):
        """Test case for create_container

        CreateContainer  # noqa: E501
        """
        pass

    def test_import_container(self):
        """Test case for import_container

        ImportContainer  # noqa: E501
        """
        pass

    def test_list_containers(self):
        """Test case for list_containers

        ListContainers  # noqa: E501
        """
        pass

    def test_repair_container_permissions(self):
        """Test case for repair_container_permissions

        RepairContainerPermissions  # noqa: E501
        """
        pass

    def test_retrieve_container(self):
        """Test case for retrieve_container

        RetrieveContainer  # noqa: E501
        """
        pass

    def test_set_container_active(self):
        """Test case for set_container_active

        SetContainerActive  # noqa: E501
        """
        pass

    def test_update_container(self):
        """Test case for update_container

        UpdateContainer  # noqa: E501
        """
        pass

    def test_update_container_import(self):
        """Test case for update_container_import

        UpdateContainerImport  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
