# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ImportContainerIdBody(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'data_versioning_enabled': 'bool',
        'path': 'str',
        'file': 'str'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'data_versioning_enabled': 'data_versioning_enabled',
        'path': 'path',
        'file': 'file'
    }

    def __init__(self, name=None, description=None, data_versioning_enabled=None, path=None, file=None):  # noqa: E501
        """ImportContainerIdBody - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._description = None
        self._data_versioning_enabled = None
        self._path = None
        self._file = None
        self.discriminator = None
        self.name = name
        self.description = description
        self.data_versioning_enabled = data_versioning_enabled
        if path is not None:
            self.path = path
        if file is not None:
            self.file = file

    @property
    def name(self):
        """Gets the name of this ImportContainerIdBody.  # noqa: E501


        :return: The name of this ImportContainerIdBody.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ImportContainerIdBody.


        :param name: The name of this ImportContainerIdBody.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this ImportContainerIdBody.  # noqa: E501


        :return: The description of this ImportContainerIdBody.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ImportContainerIdBody.


        :param description: The description of this ImportContainerIdBody.  # noqa: E501
        :type: str
        """
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def data_versioning_enabled(self):
        """Gets the data_versioning_enabled of this ImportContainerIdBody.  # noqa: E501


        :return: The data_versioning_enabled of this ImportContainerIdBody.  # noqa: E501
        :rtype: bool
        """
        return self._data_versioning_enabled

    @data_versioning_enabled.setter
    def data_versioning_enabled(self, data_versioning_enabled):
        """Sets the data_versioning_enabled of this ImportContainerIdBody.


        :param data_versioning_enabled: The data_versioning_enabled of this ImportContainerIdBody.  # noqa: E501
        :type: bool
        """
        if data_versioning_enabled is None:
            raise ValueError("Invalid value for `data_versioning_enabled`, must not be `None`")  # noqa: E501

        self._data_versioning_enabled = data_versioning_enabled

    @property
    def path(self):
        """Gets the path of this ImportContainerIdBody.  # noqa: E501


        :return: The path of this ImportContainerIdBody.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this ImportContainerIdBody.


        :param path: The path of this ImportContainerIdBody.  # noqa: E501
        :type: str
        """

        self._path = path

    @property
    def file(self):
        """Gets the file of this ImportContainerIdBody.  # noqa: E501


        :return: The file of this ImportContainerIdBody.  # noqa: E501
        :rtype: str
        """
        return self._file

    @file.setter
    def file(self, file):
        """Sets the file of this ImportContainerIdBody.


        :param file: The file of this ImportContainerIdBody.  # noqa: E501
        :type: str
        """

        self._file = file

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ImportContainerIdBody, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ImportContainerIdBody):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
