# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class EventAction(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'container_id': 'str',
        'data_source_id': 'str',
        'event_type': 'str',
        'action_type': 'str',
        'action_config': 'object',
        'destination': 'str',
        'destination_data_source_id': 'str',
        'active': 'bool',
        'created_at': 'str',
        'modified_at': 'str',
        'deleted_at': 'str',
        'created_by': 'str',
        'modified_by': 'str'
    }

    attribute_map = {
        'id': 'id',
        'container_id': 'container_id',
        'data_source_id': 'data_source_id',
        'event_type': 'event_type',
        'action_type': 'action_type',
        'action_config': 'action_config',
        'destination': 'destination',
        'destination_data_source_id': 'destination_data_source_id',
        'active': 'active',
        'created_at': 'created_at',
        'modified_at': 'modified_at',
        'deleted_at': 'deleted_at',
        'created_by': 'created_by',
        'modified_by': 'modified_by'
    }

    def __init__(self, id=None, container_id=None, data_source_id=None, event_type=None, action_type=None, action_config=None, destination=None, destination_data_source_id=None, active=None, created_at=None, modified_at=None, deleted_at=None, created_by=None, modified_by=None):  # noqa: E501
        """EventAction - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._container_id = None
        self._data_source_id = None
        self._event_type = None
        self._action_type = None
        self._action_config = None
        self._destination = None
        self._destination_data_source_id = None
        self._active = None
        self._created_at = None
        self._modified_at = None
        self._deleted_at = None
        self._created_by = None
        self._modified_by = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if container_id is not None:
            self.container_id = container_id
        if data_source_id is not None:
            self.data_source_id = data_source_id
        self.event_type = event_type
        self.action_type = action_type
        if action_config is not None:
            self.action_config = action_config
        if destination is not None:
            self.destination = destination
        if destination_data_source_id is not None:
            self.destination_data_source_id = destination_data_source_id
        if active is not None:
            self.active = active
        if created_at is not None:
            self.created_at = created_at
        if modified_at is not None:
            self.modified_at = modified_at
        if deleted_at is not None:
            self.deleted_at = deleted_at
        if created_by is not None:
            self.created_by = created_by
        if modified_by is not None:
            self.modified_by = modified_by

    @property
    def id(self):
        """Gets the id of this EventAction.  # noqa: E501


        :return: The id of this EventAction.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this EventAction.


        :param id: The id of this EventAction.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def container_id(self):
        """Gets the container_id of this EventAction.  # noqa: E501


        :return: The container_id of this EventAction.  # noqa: E501
        :rtype: str
        """
        return self._container_id

    @container_id.setter
    def container_id(self, container_id):
        """Sets the container_id of this EventAction.


        :param container_id: The container_id of this EventAction.  # noqa: E501
        :type: str
        """

        self._container_id = container_id

    @property
    def data_source_id(self):
        """Gets the data_source_id of this EventAction.  # noqa: E501


        :return: The data_source_id of this EventAction.  # noqa: E501
        :rtype: str
        """
        return self._data_source_id

    @data_source_id.setter
    def data_source_id(self, data_source_id):
        """Sets the data_source_id of this EventAction.


        :param data_source_id: The data_source_id of this EventAction.  # noqa: E501
        :type: str
        """

        self._data_source_id = data_source_id

    @property
    def event_type(self):
        """Gets the event_type of this EventAction.  # noqa: E501


        :return: The event_type of this EventAction.  # noqa: E501
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type):
        """Sets the event_type of this EventAction.


        :param event_type: The event_type of this EventAction.  # noqa: E501
        :type: str
        """
        if event_type is None:
            raise ValueError("Invalid value for `event_type`, must not be `None`")  # noqa: E501

        self._event_type = event_type

    @property
    def action_type(self):
        """Gets the action_type of this EventAction.  # noqa: E501


        :return: The action_type of this EventAction.  # noqa: E501
        :rtype: str
        """
        return self._action_type

    @action_type.setter
    def action_type(self, action_type):
        """Sets the action_type of this EventAction.


        :param action_type: The action_type of this EventAction.  # noqa: E501
        :type: str
        """
        if action_type is None:
            raise ValueError("Invalid value for `action_type`, must not be `None`")  # noqa: E501

        self._action_type = action_type

    @property
    def action_config(self):
        """Gets the action_config of this EventAction.  # noqa: E501


        :return: The action_config of this EventAction.  # noqa: E501
        :rtype: object
        """
        return self._action_config

    @action_config.setter
    def action_config(self, action_config):
        """Sets the action_config of this EventAction.


        :param action_config: The action_config of this EventAction.  # noqa: E501
        :type: object
        """

        self._action_config = action_config

    @property
    def destination(self):
        """Gets the destination of this EventAction.  # noqa: E501


        :return: The destination of this EventAction.  # noqa: E501
        :rtype: str
        """
        return self._destination

    @destination.setter
    def destination(self, destination):
        """Sets the destination of this EventAction.


        :param destination: The destination of this EventAction.  # noqa: E501
        :type: str
        """

        self._destination = destination

    @property
    def destination_data_source_id(self):
        """Gets the destination_data_source_id of this EventAction.  # noqa: E501


        :return: The destination_data_source_id of this EventAction.  # noqa: E501
        :rtype: str
        """
        return self._destination_data_source_id

    @destination_data_source_id.setter
    def destination_data_source_id(self, destination_data_source_id):
        """Sets the destination_data_source_id of this EventAction.


        :param destination_data_source_id: The destination_data_source_id of this EventAction.  # noqa: E501
        :type: str
        """

        self._destination_data_source_id = destination_data_source_id

    @property
    def active(self):
        """Gets the active of this EventAction.  # noqa: E501


        :return: The active of this EventAction.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this EventAction.


        :param active: The active of this EventAction.  # noqa: E501
        :type: bool
        """

        self._active = active

    @property
    def created_at(self):
        """Gets the created_at of this EventAction.  # noqa: E501


        :return: The created_at of this EventAction.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this EventAction.


        :param created_at: The created_at of this EventAction.  # noqa: E501
        :type: str
        """

        self._created_at = created_at

    @property
    def modified_at(self):
        """Gets the modified_at of this EventAction.  # noqa: E501


        :return: The modified_at of this EventAction.  # noqa: E501
        :rtype: str
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """Sets the modified_at of this EventAction.


        :param modified_at: The modified_at of this EventAction.  # noqa: E501
        :type: str
        """

        self._modified_at = modified_at

    @property
    def deleted_at(self):
        """Gets the deleted_at of this EventAction.  # noqa: E501


        :return: The deleted_at of this EventAction.  # noqa: E501
        :rtype: str
        """
        return self._deleted_at

    @deleted_at.setter
    def deleted_at(self, deleted_at):
        """Sets the deleted_at of this EventAction.


        :param deleted_at: The deleted_at of this EventAction.  # noqa: E501
        :type: str
        """

        self._deleted_at = deleted_at

    @property
    def created_by(self):
        """Gets the created_by of this EventAction.  # noqa: E501


        :return: The created_by of this EventAction.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this EventAction.


        :param created_by: The created_by of this EventAction.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def modified_by(self):
        """Gets the modified_by of this EventAction.  # noqa: E501


        :return: The modified_by of this EventAction.  # noqa: E501
        :rtype: str
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """Sets the modified_by of this EventAction.


        :param modified_by: The modified_by of this EventAction.  # noqa: E501
        :type: str
        """

        self._modified_by = modified_by

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EventAction, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EventAction):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
