# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from deep_lynx.api_client import ApiClient


class ImportsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_data_to_import(self, container_id, import_id, data_source_id, **kwargs):  # noqa: E501
        """Add Data to Import  # noqa: E501

        Adds data to an existing import. Accepts an array of JSON objects or a file in JSON or CSV format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_data_to_import(container_id, import_id, data_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str import_id: (required)
        :param str data_source_id: (required)
        :param list[object] body:
        :return: AddDataToImportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_data_to_import_with_http_info(container_id, import_id, data_source_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_data_to_import_with_http_info(container_id, import_id, data_source_id, **kwargs)  # noqa: E501
            return data

    def add_data_to_import_with_http_info(self, container_id, import_id, data_source_id, **kwargs):  # noqa: E501
        """Add Data to Import  # noqa: E501

        Adds data to an existing import. Accepts an array of JSON objects or a file in JSON or CSV format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_data_to_import_with_http_info(container_id, import_id, data_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str import_id: (required)
        :param str data_source_id: (required)
        :param list[object] body:
        :return: AddDataToImportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'import_id', 'data_source_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_data_to_import" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `add_data_to_import`")  # noqa: E501
        # verify the required parameter 'import_id' is set
        if ('import_id' not in params or
                params['import_id'] is None):
            raise ValueError("Missing the required parameter `import_id` when calling `add_data_to_import`")  # noqa: E501
        # verify the required parameter 'data_source_id' is set
        if ('data_source_id' not in params or
                params['data_source_id'] is None):
            raise ValueError("Missing the required parameter `data_source_id` when calling `add_data_to_import`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'import_id' in params:
            path_params['import_id'] = params['import_id']  # noqa: E501
        if 'data_source_id' in params:
            path_params['data_source_id'] = params['data_source_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/datasources/{data_source_id}/imports/{import_id}/data', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddDataToImportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_data_to_import(self, container_id, import_id, data_source_id, **kwargs):  # noqa: E501
        """Add Data to Import  # noqa: E501

        Adds data to an existing import. Accepts an array of JSON objects or a file in JSON or CSV format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_data_to_import(container_id, import_id, data_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str import_id: (required)
        :param str data_source_id: (required)
        :param str file:
        :return: AddDataToImportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_data_to_import_with_http_info(container_id, import_id, data_source_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_data_to_import_with_http_info(container_id, import_id, data_source_id, **kwargs)  # noqa: E501
            return data

    def add_data_to_import_with_http_info(self, container_id, import_id, data_source_id, **kwargs):  # noqa: E501
        """Add Data to Import  # noqa: E501

        Adds data to an existing import. Accepts an array of JSON objects or a file in JSON or CSV format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_data_to_import_with_http_info(container_id, import_id, data_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str import_id: (required)
        :param str data_source_id: (required)
        :param str file:
        :return: AddDataToImportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'import_id', 'data_source_id', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_data_to_import" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `add_data_to_import`")  # noqa: E501
        # verify the required parameter 'import_id' is set
        if ('import_id' not in params or
                params['import_id'] is None):
            raise ValueError("Missing the required parameter `import_id` when calling `add_data_to_import`")  # noqa: E501
        # verify the required parameter 'data_source_id' is set
        if ('data_source_id' not in params or
                params['data_source_id'] is None):
            raise ValueError("Missing the required parameter `data_source_id` when calling `add_data_to_import`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'import_id' in params:
            path_params['import_id'] = params['import_id']  # noqa: E501
        if 'data_source_id' in params:
            path_params['data_source_id'] = params['data_source_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/datasources/{data_source_id}/imports/{import_id}/data', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddDataToImportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_import(self, container_id, data_source_id, **kwargs):  # noqa: E501
        """Create Import  # noqa: E501

        Creates a new import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_import(container_id, data_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param DataSourceIdImportsBody body:
        :return: CreateImportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_import_with_http_info(container_id, data_source_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_import_with_http_info(container_id, data_source_id, **kwargs)  # noqa: E501
            return data

    def create_import_with_http_info(self, container_id, data_source_id, **kwargs):  # noqa: E501
        """Create Import  # noqa: E501

        Creates a new import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_import_with_http_info(container_id, data_source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str data_source_id: (required)
        :param DataSourceIdImportsBody body:
        :return: CreateImportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'data_source_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_import" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `create_import`")  # noqa: E501
        # verify the required parameter 'data_source_id' is set
        if ('data_source_id' not in params or
                params['data_source_id'] is None):
            raise ValueError("Missing the required parameter `data_source_id` when calling `create_import`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'data_source_id' in params:
            path_params['data_source_id'] = params['data_source_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/datasources/{data_source_id}/imports', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateImportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_import(self, container_id, import_id, **kwargs):  # noqa: E501
        """Delete Import  # noqa: E501

        Delete import will delete an import ONLY IF the import has not been processed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_import(container_id, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str import_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_import_with_http_info(container_id, import_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_import_with_http_info(container_id, import_id, **kwargs)  # noqa: E501
            return data

    def delete_import_with_http_info(self, container_id, import_id, **kwargs):  # noqa: E501
        """Delete Import  # noqa: E501

        Delete import will delete an import ONLY IF the import has not been processed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_import_with_http_info(container_id, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str import_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'import_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_import" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `delete_import`")  # noqa: E501
        # verify the required parameter 'import_id' is set
        if ('import_id' not in params or
                params['import_id'] is None):
            raise ValueError("Missing the required parameter `import_id` when calling `delete_import`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'import_id' in params:
            path_params['import_id'] = params['import_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/import/imports/{import_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_import_data(self, container_id, import_id, data_id, **kwargs):  # noqa: E501
        """Delete Import Data  # noqa: E501

        Delete a single piece of data from an import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_import_data(container_id, import_id, data_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str import_id: (required)
        :param int data_id: (required)
        :return: Generic200Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_import_data_with_http_info(container_id, import_id, data_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_import_data_with_http_info(container_id, import_id, data_id, **kwargs)  # noqa: E501
            return data

    def delete_import_data_with_http_info(self, container_id, import_id, data_id, **kwargs):  # noqa: E501
        """Delete Import Data  # noqa: E501

        Delete a single piece of data from an import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_import_data_with_http_info(container_id, import_id, data_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str import_id: (required)
        :param int data_id: (required)
        :return: Generic200Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'import_id', 'data_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_import_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `delete_import_data`")  # noqa: E501
        # verify the required parameter 'import_id' is set
        if ('import_id' not in params or
                params['import_id'] is None):
            raise ValueError("Missing the required parameter `import_id` when calling `delete_import_data`")  # noqa: E501
        # verify the required parameter 'data_id' is set
        if ('data_id' not in params or
                params['data_id'] is None):
            raise ValueError("Missing the required parameter `data_id` when calling `delete_import_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'import_id' in params:
            path_params['import_id'] = params['import_id']  # noqa: E501
        if 'data_id' in params:
            path_params['data_id'] = params['data_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/import/imports/{import_id}/data/{data_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Generic200Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_imports_data(self, container_id, import_id, **kwargs):  # noqa: E501
        """List Import's Data  # noqa: E501

        List the data for an import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_imports_data(container_id, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str import_id: (required)
        :param str count: boolean indicating if the return value should be a count only
        :param int limit:
        :param int offset:
        :param str sort_by: column to sort results by
        :param bool sort_desc: boolean indicating if results should be in descending order
        :return: ListImportDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_imports_data_with_http_info(container_id, import_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_imports_data_with_http_info(container_id, import_id, **kwargs)  # noqa: E501
            return data

    def list_imports_data_with_http_info(self, container_id, import_id, **kwargs):  # noqa: E501
        """List Import's Data  # noqa: E501

        List the data for an import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_imports_data_with_http_info(container_id, import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str import_id: (required)
        :param str count: boolean indicating if the return value should be a count only
        :param int limit:
        :param int offset:
        :param str sort_by: column to sort results by
        :param bool sort_desc: boolean indicating if results should be in descending order
        :return: ListImportDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'import_id', 'count', 'limit', 'offset', 'sort_by', 'sort_desc']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_imports_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `list_imports_data`")  # noqa: E501
        # verify the required parameter 'import_id' is set
        if ('import_id' not in params or
                params['import_id'] is None):
            raise ValueError("Missing the required parameter `import_id` when calling `list_imports_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'import_id' in params:
            path_params['import_id'] = params['import_id']  # noqa: E501

        query_params = []
        if 'count' in params:
            query_params.append(('count', params['count']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'sort_by' in params:
            query_params.append(('sortBy', params['sort_by']))  # noqa: E501
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/import/imports/{import_id}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListImportDataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_import_data(self, container_id, import_id, data_id, **kwargs):  # noqa: E501
        """Retrieve Import Data  # noqa: E501

        Retrieve a single piece of data from an import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_import_data(container_id, import_id, data_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str import_id: (required)
        :param int data_id: (required)
        :return: GetImportDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.retrieve_import_data_with_http_info(container_id, import_id, data_id, **kwargs)  # noqa: E501
        else:
            (data) = self.retrieve_import_data_with_http_info(container_id, import_id, data_id, **kwargs)  # noqa: E501
            return data

    def retrieve_import_data_with_http_info(self, container_id, import_id, data_id, **kwargs):  # noqa: E501
        """Retrieve Import Data  # noqa: E501

        Retrieve a single piece of data from an import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_import_data_with_http_info(container_id, import_id, data_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str import_id: (required)
        :param int data_id: (required)
        :return: GetImportDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'import_id', 'data_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_import_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `retrieve_import_data`")  # noqa: E501
        # verify the required parameter 'import_id' is set
        if ('import_id' not in params or
                params['import_id'] is None):
            raise ValueError("Missing the required parameter `import_id` when calling `retrieve_import_data`")  # noqa: E501
        # verify the required parameter 'data_id' is set
        if ('data_id' not in params or
                params['data_id'] is None):
            raise ValueError("Missing the required parameter `data_id` when calling `retrieve_import_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'import_id' in params:
            path_params['import_id'] = params['import_id']  # noqa: E501
        if 'data_id' in params:
            path_params['data_id'] = params['data_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/import/imports/{import_id}/data/{data_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetImportDataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_import_data(self, container_id, import_id, data_id, **kwargs):  # noqa: E501
        """Update Import Data  # noqa: E501

        Update the data of an existing import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_import_data(container_id, import_id, data_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str import_id: (required)
        :param int data_id: (required)
        :param DataStaging body:
        :return: UpdateImportDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_import_data_with_http_info(container_id, import_id, data_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_import_data_with_http_info(container_id, import_id, data_id, **kwargs)  # noqa: E501
            return data

    def update_import_data_with_http_info(self, container_id, import_id, data_id, **kwargs):  # noqa: E501
        """Update Import Data  # noqa: E501

        Update the data of an existing import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_import_data_with_http_info(container_id, import_id, data_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str container_id: (required)
        :param str import_id: (required)
        :param int data_id: (required)
        :param DataStaging body:
        :return: UpdateImportDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'import_id', 'data_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_import_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if ('container_id' not in params or
                params['container_id'] is None):
            raise ValueError("Missing the required parameter `container_id` when calling `update_import_data`")  # noqa: E501
        # verify the required parameter 'import_id' is set
        if ('import_id' not in params or
                params['import_id'] is None):
            raise ValueError("Missing the required parameter `import_id` when calling `update_import_data`")  # noqa: E501
        # verify the required parameter 'data_id' is set
        if ('data_id' not in params or
                params['data_id'] is None):
            raise ValueError("Missing the required parameter `data_id` when calling `update_import_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['container_id'] = params['container_id']  # noqa: E501
        if 'import_id' in params:
            path_params['import_id'] = params['import_id']  # noqa: E501
        if 'data_id' in params:
            path_params['data_id'] = params['data_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{container_id}/import/imports/{import_id}/data/{data_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdateImportDataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
