# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AddCategoryRequest(TeaModel):
    def __init__(self, cate_name=None, parent_id=None, type=None):
        self.cate_name = cate_name  # type: str
        self.parent_id = parent_id  # type: long
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCategoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddCategoryResponseBodyCategory(TeaModel):
    def __init__(self, cate_id=None, cate_name=None, level=None, parent_id=None, type=None):
        self.cate_id = cate_id  # type: long
        self.cate_name = cate_name  # type: str
        self.level = level  # type: long
        self.parent_id = parent_id  # type: long
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCategoryResponseBodyCategory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddCategoryResponseBody(TeaModel):
    def __init__(self, category=None, request_id=None):
        self.category = category  # type: AddCategoryResponseBodyCategory
        self.request_id = request_id  # type: str

    def validate(self):
        if self.category:
            self.category.validate()

    def to_map(self):
        _map = super(AddCategoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            temp_model = AddCategoryResponseBodyCategory()
            self.category = temp_model.from_map(m['Category'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCategoryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddCategoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddCategoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddEditingProjectMaterialsRequest(TeaModel):
    def __init__(self, material_maps=None, project_id=None):
        self.material_maps = material_maps  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddEditingProjectMaterialsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.material_maps is not None:
            result['MaterialMaps'] = self.material_maps
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaterialMaps') is not None:
            self.material_maps = m.get('MaterialMaps')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class AddEditingProjectMaterialsResponseBodyLiveMaterials(TeaModel):
    def __init__(self, app_name=None, domain_name=None, live_url=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.live_url = live_url  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddEditingProjectMaterialsResponseBodyLiveMaterials, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.live_url is not None:
            result['LiveUrl'] = self.live_url
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LiveUrl') is not None:
            self.live_url = m.get('LiveUrl')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo(TeaModel):
    def __init__(self, bitrate=None, duration=None, file_name=None, file_size=None, file_status=None, file_type=None,
                 file_url=None, format_name=None, height=None, region=None, width=None):
        self.bitrate = bitrate  # type: str
        self.duration = duration  # type: str
        self.file_name = file_name  # type: str
        self.file_size = file_size  # type: str
        self.file_status = file_status  # type: str
        self.file_type = file_type  # type: str
        self.file_url = file_url  # type: str
        self.format_name = format_name  # type: str
        self.height = height  # type: str
        self.region = region  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoList(TeaModel):
    def __init__(self, file_basic_info=None):
        self.file_basic_info = file_basic_info  # type: AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo

    def validate(self):
        if self.file_basic_info:
            self.file_basic_info.validate()

    def to_map(self):
        _map = super(AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileBasicInfo') is not None:
            temp_model = AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        return self


class AddEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo(TeaModel):
    def __init__(self, business_type=None, category=None, cover_url=None, create_time=None, deleted_time=None,
                 description=None, input_url=None, media_id=None, media_tags=None, media_type=None, modified_time=None,
                 snapshots=None, source=None, sprite_images=None, status=None, title=None, transcode_status=None,
                 user_data=None):
        self.business_type = business_type  # type: str
        self.category = category  # type: str
        self.cover_url = cover_url  # type: str
        self.create_time = create_time  # type: str
        self.deleted_time = deleted_time  # type: str
        self.description = description  # type: str
        self.input_url = input_url  # type: str
        self.media_id = media_id  # type: str
        self.media_tags = media_tags  # type: str
        self.media_type = media_type  # type: str
        self.modified_time = modified_time  # type: str
        self.snapshots = snapshots  # type: str
        self.source = source  # type: str
        self.sprite_images = sprite_images  # type: str
        self.status = status  # type: str
        self.title = title  # type: str
        self.transcode_status = transcode_status  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_images is not None:
            result['SpriteImages'] = self.sprite_images
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.transcode_status is not None:
            result['TranscodeStatus'] = self.transcode_status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Snapshots') is not None:
            self.snapshots = m.get('Snapshots')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteImages') is not None:
            self.sprite_images = m.get('SpriteImages')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('TranscodeStatus') is not None:
            self.transcode_status = m.get('TranscodeStatus')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class AddEditingProjectMaterialsResponseBodyMediaInfos(TeaModel):
    def __init__(self, file_info_list=None, media_basic_info=None, media_id=None):
        self.file_info_list = file_info_list  # type: list[AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoList]
        self.media_basic_info = media_basic_info  # type: AddEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo
        self.media_id = media_id  # type: str

    def validate(self):
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super(AddEditingProjectMaterialsResponseBodyMediaInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = AddEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class AddEditingProjectMaterialsResponseBody(TeaModel):
    def __init__(self, live_materials=None, media_infos=None, project_id=None, project_materials=None,
                 request_id=None):
        self.live_materials = live_materials  # type: list[AddEditingProjectMaterialsResponseBodyLiveMaterials]
        self.media_infos = media_infos  # type: list[AddEditingProjectMaterialsResponseBodyMediaInfos]
        self.project_id = project_id  # type: str
        self.project_materials = project_materials  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.live_materials:
            for k in self.live_materials:
                if k:
                    k.validate()
        if self.media_infos:
            for k in self.media_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddEditingProjectMaterialsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveMaterials'] = []
        if self.live_materials is not None:
            for k in self.live_materials:
                result['LiveMaterials'].append(k.to_map() if k else None)
        result['MediaInfos'] = []
        if self.media_infos is not None:
            for k in self.media_infos:
                result['MediaInfos'].append(k.to_map() if k else None)
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_materials is not None:
            result['ProjectMaterials'] = self.project_materials
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_materials = []
        if m.get('LiveMaterials') is not None:
            for k in m.get('LiveMaterials'):
                temp_model = AddEditingProjectMaterialsResponseBodyLiveMaterials()
                self.live_materials.append(temp_model.from_map(k))
        self.media_infos = []
        if m.get('MediaInfos') is not None:
            for k in m.get('MediaInfos'):
                temp_model = AddEditingProjectMaterialsResponseBodyMediaInfos()
                self.media_infos.append(temp_model.from_map(k))
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectMaterials') is not None:
            self.project_materials = m.get('ProjectMaterials')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddEditingProjectMaterialsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddEditingProjectMaterialsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddEditingProjectMaterialsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddEditingProjectMaterialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddFavoritePublicMediaRequest(TeaModel):
    def __init__(self, media_ids=None):
        self.media_ids = media_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddFavoritePublicMediaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        return self


class AddFavoritePublicMediaResponseBody(TeaModel):
    def __init__(self, ignored_list=None, request_id=None):
        self.ignored_list = ignored_list  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddFavoritePublicMediaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignored_list is not None:
            result['IgnoredList'] = self.ignored_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IgnoredList') is not None:
            self.ignored_list = m.get('IgnoredList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddFavoritePublicMediaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddFavoritePublicMediaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddFavoritePublicMediaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddFavoritePublicMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTemplateRequest(TeaModel):
    def __init__(self, config=None, cover_url=None, name=None, preview_media=None, related_mediaids=None,
                 source=None, status=None, type=None):
        self.config = config  # type: str
        self.cover_url = cover_url  # type: str
        self.name = name  # type: str
        self.preview_media = preview_media  # type: str
        self.related_mediaids = related_mediaids  # type: str
        self.source = source  # type: str
        self.status = status  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.cover_url is not None:
            result['CoverUrl'] = self.cover_url
        if self.name is not None:
            result['Name'] = self.name
        if self.preview_media is not None:
            result['PreviewMedia'] = self.preview_media
        if self.related_mediaids is not None:
            result['RelatedMediaids'] = self.related_mediaids
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('CoverUrl') is not None:
            self.cover_url = m.get('CoverUrl')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PreviewMedia') is not None:
            self.preview_media = m.get('PreviewMedia')
        if m.get('RelatedMediaids') is not None:
            self.related_mediaids = m.get('RelatedMediaids')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddTemplateResponseBodyTemplate(TeaModel):
    def __init__(self, config=None, cover_url=None, create_source=None, modified_source=None, name=None,
                 preview_media=None, status=None, template_id=None, type=None):
        self.config = config  # type: str
        self.cover_url = cover_url  # type: str
        self.create_source = create_source  # type: str
        self.modified_source = modified_source  # type: str
        self.name = name  # type: str
        self.preview_media = preview_media  # type: str
        self.status = status  # type: str
        self.template_id = template_id  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTemplateResponseBodyTemplate, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.cover_url is not None:
            result['CoverUrl'] = self.cover_url
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.modified_source is not None:
            result['ModifiedSource'] = self.modified_source
        if self.name is not None:
            result['Name'] = self.name
        if self.preview_media is not None:
            result['PreviewMedia'] = self.preview_media
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('CoverUrl') is not None:
            self.cover_url = m.get('CoverUrl')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('ModifiedSource') is not None:
            self.modified_source = m.get('ModifiedSource')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PreviewMedia') is not None:
            self.preview_media = m.get('PreviewMedia')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template=None):
        self.request_id = request_id  # type: str
        self.template = template  # type: AddTemplateResponseBodyTemplate

    def validate(self):
        if self.template:
            self.template.validate()

    def to_map(self):
        _map = super(AddTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template is not None:
            result['Template'] = self.template.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Template') is not None:
            temp_model = AddTemplateResponseBodyTemplate()
            self.template = temp_model.from_map(m['Template'])
        return self


class AddTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetMediaInfosRequest(TeaModel):
    def __init__(self, addition_type=None, media_ids=None):
        self.addition_type = addition_type  # type: str
        self.media_ids = media_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetMediaInfosRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addition_type is not None:
            result['AdditionType'] = self.addition_type
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdditionType') is not None:
            self.addition_type = m.get('AdditionType')
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        return self


class BatchGetMediaInfosResponseBodyMediaInfosFileInfoListFileBasicInfo(TeaModel):
    def __init__(self, bitrate=None, duration=None, file_name=None, file_size=None, file_status=None, file_type=None,
                 file_url=None, format_name=None, height=None, region=None, width=None):
        self.bitrate = bitrate  # type: str
        self.duration = duration  # type: str
        self.file_name = file_name  # type: str
        self.file_size = file_size  # type: str
        self.file_status = file_status  # type: str
        self.file_type = file_type  # type: str
        self.file_url = file_url  # type: str
        self.format_name = format_name  # type: str
        self.height = height  # type: str
        self.region = region  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetMediaInfosResponseBodyMediaInfosFileInfoListFileBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class BatchGetMediaInfosResponseBodyMediaInfosFileInfoList(TeaModel):
    def __init__(self, file_basic_info=None):
        self.file_basic_info = file_basic_info  # type: BatchGetMediaInfosResponseBodyMediaInfosFileInfoListFileBasicInfo

    def validate(self):
        if self.file_basic_info:
            self.file_basic_info.validate()

    def to_map(self):
        _map = super(BatchGetMediaInfosResponseBodyMediaInfosFileInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileBasicInfo') is not None:
            temp_model = BatchGetMediaInfosResponseBodyMediaInfosFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        return self


class BatchGetMediaInfosResponseBodyMediaInfosMediaBasicInfo(TeaModel):
    def __init__(self, business_type=None, category=None, cover_url=None, create_time=None, deleted_time=None,
                 description=None, input_url=None, media_id=None, media_tags=None, media_type=None, modified_time=None,
                 snapshots=None, source=None, sprite_images=None, status=None, title=None, transcode_status=None,
                 user_data=None):
        self.business_type = business_type  # type: str
        self.category = category  # type: str
        self.cover_url = cover_url  # type: str
        self.create_time = create_time  # type: str
        self.deleted_time = deleted_time  # type: str
        self.description = description  # type: str
        self.input_url = input_url  # type: str
        self.media_id = media_id  # type: str
        self.media_tags = media_tags  # type: str
        self.media_type = media_type  # type: str
        self.modified_time = modified_time  # type: str
        self.snapshots = snapshots  # type: str
        self.source = source  # type: str
        self.sprite_images = sprite_images  # type: str
        self.status = status  # type: str
        self.title = title  # type: str
        self.transcode_status = transcode_status  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetMediaInfosResponseBodyMediaInfosMediaBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_images is not None:
            result['SpriteImages'] = self.sprite_images
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.transcode_status is not None:
            result['TranscodeStatus'] = self.transcode_status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Snapshots') is not None:
            self.snapshots = m.get('Snapshots')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteImages') is not None:
            self.sprite_images = m.get('SpriteImages')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('TranscodeStatus') is not None:
            self.transcode_status = m.get('TranscodeStatus')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class BatchGetMediaInfosResponseBodyMediaInfos(TeaModel):
    def __init__(self, file_info_list=None, media_basic_info=None, media_id=None):
        self.file_info_list = file_info_list  # type: list[BatchGetMediaInfosResponseBodyMediaInfosFileInfoList]
        self.media_basic_info = media_basic_info  # type: BatchGetMediaInfosResponseBodyMediaInfosMediaBasicInfo
        self.media_id = media_id  # type: str

    def validate(self):
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super(BatchGetMediaInfosResponseBodyMediaInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = BatchGetMediaInfosResponseBodyMediaInfosFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = BatchGetMediaInfosResponseBodyMediaInfosMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class BatchGetMediaInfosResponseBody(TeaModel):
    def __init__(self, media_infos=None, request_id=None):
        self.media_infos = media_infos  # type: list[BatchGetMediaInfosResponseBodyMediaInfos]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_infos:
            for k in self.media_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetMediaInfosResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaInfos'] = []
        if self.media_infos is not None:
            for k in self.media_infos:
                result['MediaInfos'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.media_infos = []
        if m.get('MediaInfos') is not None:
            for k in m.get('MediaInfos'):
                temp_model = BatchGetMediaInfosResponseBodyMediaInfos()
                self.media_infos.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchGetMediaInfosResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchGetMediaInfosResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetMediaInfosResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchGetMediaInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelFavoritePublicMediaRequest(TeaModel):
    def __init__(self, media_ids=None):
        self.media_ids = media_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelFavoritePublicMediaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        return self


class CancelFavoritePublicMediaResponseBody(TeaModel):
    def __init__(self, ignored_list=None, request_id=None):
        self.ignored_list = ignored_list  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelFavoritePublicMediaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignored_list is not None:
            result['IgnoredList'] = self.ignored_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IgnoredList') is not None:
            self.ignored_list = m.get('IgnoredList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelFavoritePublicMediaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelFavoritePublicMediaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelFavoritePublicMediaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelFavoritePublicMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomTemplateRequest(TeaModel):
    def __init__(self, name=None, subtype=None, template_config=None, type=None):
        self.name = name  # type: str
        self.subtype = subtype  # type: int
        self.template_config = template_config  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateCustomTemplateResponseBodyCustomTemplate(TeaModel):
    def __init__(self, create_time=None, is_default=None, modified_time=None, status=None, subtype=None,
                 template_config=None, template_id=None, template_name=None, type=None, type_name=None):
        self.create_time = create_time  # type: str
        self.is_default = is_default  # type: bool
        self.modified_time = modified_time  # type: str
        self.status = status  # type: str
        self.subtype = subtype  # type: str
        self.template_config = template_config  # type: str
        self.template_id = template_id  # type: str
        self.template_name = template_name  # type: str
        self.type = type  # type: int
        self.type_name = type_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomTemplateResponseBodyCustomTemplate, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.status is not None:
            result['Status'] = self.status
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.type is not None:
            result['Type'] = self.type
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        return self


class CreateCustomTemplateResponseBody(TeaModel):
    def __init__(self, custom_template=None, request_id=None):
        self.custom_template = custom_template  # type: CreateCustomTemplateResponseBodyCustomTemplate
        self.request_id = request_id  # type: str

    def validate(self):
        if self.custom_template:
            self.custom_template.validate()

    def to_map(self):
        _map = super(CreateCustomTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_template is not None:
            result['CustomTemplate'] = self.custom_template.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomTemplate') is not None:
            temp_model = CreateCustomTemplateResponseBodyCustomTemplate()
            self.custom_template = temp_model.from_map(m['CustomTemplate'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCustomTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCustomTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCustomTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEditingProjectRequest(TeaModel):
    def __init__(self, business_config=None, clips_param=None, cover_url=None, description=None, material_maps=None,
                 project_type=None, template_id=None, timeline=None, title=None):
        self.business_config = business_config  # type: str
        self.clips_param = clips_param  # type: str
        self.cover_url = cover_url  # type: str
        self.description = description  # type: str
        self.material_maps = material_maps  # type: str
        self.project_type = project_type  # type: str
        self.template_id = template_id  # type: str
        self.timeline = timeline  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEditingProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_config is not None:
            result['BusinessConfig'] = self.business_config
        if self.clips_param is not None:
            result['ClipsParam'] = self.clips_param
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.description is not None:
            result['Description'] = self.description
        if self.material_maps is not None:
            result['MaterialMaps'] = self.material_maps
        if self.project_type is not None:
            result['ProjectType'] = self.project_type
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.timeline is not None:
            result['Timeline'] = self.timeline
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessConfig') is not None:
            self.business_config = m.get('BusinessConfig')
        if m.get('ClipsParam') is not None:
            self.clips_param = m.get('ClipsParam')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MaterialMaps') is not None:
            self.material_maps = m.get('MaterialMaps')
        if m.get('ProjectType') is not None:
            self.project_type = m.get('ProjectType')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Timeline') is not None:
            self.timeline = m.get('Timeline')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class CreateEditingProjectResponseBodyProject(TeaModel):
    def __init__(self, business_config=None, business_status=None, clips_param=None, cover_url=None,
                 create_source=None, create_time=None, description=None, duration=None, modified_source=None, modified_time=None,
                 project_id=None, project_type=None, status=None, status_name=None, template_id=None, template_type=None,
                 timeline=None, title=None):
        self.business_config = business_config  # type: str
        self.business_status = business_status  # type: str
        self.clips_param = clips_param  # type: str
        self.cover_url = cover_url  # type: str
        self.create_source = create_source  # type: str
        self.create_time = create_time  # type: str
        self.description = description  # type: str
        self.duration = duration  # type: float
        self.modified_source = modified_source  # type: str
        self.modified_time = modified_time  # type: str
        self.project_id = project_id  # type: str
        self.project_type = project_type  # type: str
        self.status = status  # type: long
        self.status_name = status_name  # type: str
        self.template_id = template_id  # type: str
        self.template_type = template_type  # type: str
        self.timeline = timeline  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEditingProjectResponseBodyProject, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_config is not None:
            result['BusinessConfig'] = self.business_config
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.clips_param is not None:
            result['ClipsParam'] = self.clips_param
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.modified_source is not None:
            result['ModifiedSource'] = self.modified_source
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_type is not None:
            result['ProjectType'] = self.project_type
        if self.status is not None:
            result['Status'] = self.status
        if self.status_name is not None:
            result['StatusName'] = self.status_name
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.timeline is not None:
            result['Timeline'] = self.timeline
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessConfig') is not None:
            self.business_config = m.get('BusinessConfig')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('ClipsParam') is not None:
            self.clips_param = m.get('ClipsParam')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ModifiedSource') is not None:
            self.modified_source = m.get('ModifiedSource')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectType') is not None:
            self.project_type = m.get('ProjectType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusName') is not None:
            self.status_name = m.get('StatusName')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('Timeline') is not None:
            self.timeline = m.get('Timeline')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class CreateEditingProjectResponseBody(TeaModel):
    def __init__(self, project=None, request_id=None):
        self.project = project  # type: CreateEditingProjectResponseBodyProject
        self.request_id = request_id  # type: str

    def validate(self):
        if self.project:
            self.project.validate()

    def to_map(self):
        _map = super(CreateEditingProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project is not None:
            result['Project'] = self.project.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Project') is not None:
            temp_model = CreateEditingProjectResponseBodyProject()
            self.project = temp_model.from_map(m['Project'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateEditingProjectResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateEditingProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEditingProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEditingProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveRecordTemplateRequestRecordFormat(TeaModel):
    def __init__(self, cycle_duration=None, format=None, oss_object_prefix=None, slice_duration=None,
                 slice_oss_object_prefix=None):
        self.cycle_duration = cycle_duration  # type: int
        self.format = format  # type: str
        self.oss_object_prefix = oss_object_prefix  # type: str
        self.slice_duration = slice_duration  # type: int
        self.slice_oss_object_prefix = slice_oss_object_prefix  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveRecordTemplateRequestRecordFormat, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.format is not None:
            result['Format'] = self.format
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.slice_duration is not None:
            result['SliceDuration'] = self.slice_duration
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('SliceDuration') is not None:
            self.slice_duration = m.get('SliceDuration')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        return self


class CreateLiveRecordTemplateRequest(TeaModel):
    def __init__(self, name=None, record_format=None):
        self.name = name  # type: str
        self.record_format = record_format  # type: list[CreateLiveRecordTemplateRequestRecordFormat]

    def validate(self):
        if self.record_format:
            for k in self.record_format:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateLiveRecordTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        result['RecordFormat'] = []
        if self.record_format is not None:
            for k in self.record_format:
                result['RecordFormat'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.record_format = []
        if m.get('RecordFormat') is not None:
            for k in m.get('RecordFormat'):
                temp_model = CreateLiveRecordTemplateRequestRecordFormat()
                self.record_format.append(temp_model.from_map(k))
        return self


class CreateLiveRecordTemplateShrinkRequest(TeaModel):
    def __init__(self, name=None, record_format_shrink=None):
        self.name = name  # type: str
        self.record_format_shrink = record_format_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveRecordTemplateShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.record_format_shrink is not None:
            result['RecordFormat'] = self.record_format_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RecordFormat') is not None:
            self.record_format_shrink = m.get('RecordFormat')
        return self


class CreateLiveRecordTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template_id=None):
        self.request_id = request_id  # type: str
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveRecordTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class CreateLiveRecordTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateLiveRecordTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateLiveRecordTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveRecordTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveSnapshotTemplateRequest(TeaModel):
    def __init__(self, overwrite_format=None, sequence_format=None, template_name=None, time_interval=None):
        self.overwrite_format = overwrite_format  # type: str
        self.sequence_format = sequence_format  # type: str
        self.template_name = template_name  # type: str
        self.time_interval = time_interval  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveSnapshotTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_format is not None:
            result['OverwriteFormat'] = self.overwrite_format
        if self.sequence_format is not None:
            result['SequenceFormat'] = self.sequence_format
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.time_interval is not None:
            result['TimeInterval'] = self.time_interval
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OverwriteFormat') is not None:
            self.overwrite_format = m.get('OverwriteFormat')
        if m.get('SequenceFormat') is not None:
            self.sequence_format = m.get('SequenceFormat')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TimeInterval') is not None:
            self.time_interval = m.get('TimeInterval')
        return self


class CreateLiveSnapshotTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template_id=None):
        self.request_id = request_id  # type: str
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveSnapshotTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class CreateLiveSnapshotTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateLiveSnapshotTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateLiveSnapshotTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveSnapshotTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveTranscodeTemplateRequestTemplateConfigAudioParams(TeaModel):
    def __init__(self, bitrate=None, channels=None, codec=None, profile=None, samplerate=None):
        self.bitrate = bitrate  # type: str
        self.channels = channels  # type: str
        self.codec = codec  # type: str
        self.profile = profile  # type: str
        self.samplerate = samplerate  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveTranscodeTemplateRequestTemplateConfigAudioParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        return self


class CreateLiveTranscodeTemplateRequestTemplateConfigVideoParams(TeaModel):
    def __init__(self, bitrate=None, codec=None, fps=None, gop=None, height=None, profile=None, width=None):
        self.bitrate = bitrate  # type: str
        self.codec = codec  # type: str
        self.fps = fps  # type: str
        self.gop = gop  # type: str
        self.height = height  # type: str
        self.profile = profile  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveTranscodeTemplateRequestTemplateConfigVideoParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class CreateLiveTranscodeTemplateRequestTemplateConfig(TeaModel):
    def __init__(self, audio_params=None, video_params=None):
        self.audio_params = audio_params  # type: CreateLiveTranscodeTemplateRequestTemplateConfigAudioParams
        self.video_params = video_params  # type: CreateLiveTranscodeTemplateRequestTemplateConfigVideoParams

    def validate(self):
        if self.audio_params:
            self.audio_params.validate()
        if self.video_params:
            self.video_params.validate()

    def to_map(self):
        _map = super(CreateLiveTranscodeTemplateRequestTemplateConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_params is not None:
            result['AudioParams'] = self.audio_params.to_map()
        if self.video_params is not None:
            result['VideoParams'] = self.video_params.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioParams') is not None:
            temp_model = CreateLiveTranscodeTemplateRequestTemplateConfigAudioParams()
            self.audio_params = temp_model.from_map(m['AudioParams'])
        if m.get('VideoParams') is not None:
            temp_model = CreateLiveTranscodeTemplateRequestTemplateConfigVideoParams()
            self.video_params = temp_model.from_map(m['VideoParams'])
        return self


class CreateLiveTranscodeTemplateRequest(TeaModel):
    def __init__(self, name=None, template_config=None, type=None):
        self.name = name  # type: str
        self.template_config = template_config  # type: CreateLiveTranscodeTemplateRequestTemplateConfig
        self.type = type  # type: str

    def validate(self):
        if self.template_config:
            self.template_config.validate()

    def to_map(self):
        _map = super(CreateLiveTranscodeTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TemplateConfig') is not None:
            temp_model = CreateLiveTranscodeTemplateRequestTemplateConfig()
            self.template_config = temp_model.from_map(m['TemplateConfig'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateLiveTranscodeTemplateShrinkRequest(TeaModel):
    def __init__(self, name=None, template_config_shrink=None, type=None):
        self.name = name  # type: str
        self.template_config_shrink = template_config_shrink  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveTranscodeTemplateShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.template_config_shrink is not None:
            result['TemplateConfig'] = self.template_config_shrink
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TemplateConfig') is not None:
            self.template_config_shrink = m.get('TemplateConfig')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateLiveTranscodeTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template_id=None):
        self.request_id = request_id  # type: str
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveTranscodeTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class CreateLiveTranscodeTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateLiveTranscodeTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateLiveTranscodeTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveTranscodeTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePipelineRequest(TeaModel):
    def __init__(self, name=None, priority=None, speed=None):
        self.name = name  # type: str
        self.priority = priority  # type: int
        self.speed = speed  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreatePipelineRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.speed is not None:
            result['Speed'] = self.speed
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        return self


class CreatePipelineResponseBodyPipeline(TeaModel):
    def __init__(self, create_time=None, modified_time=None, name=None, pipeline_id=None, priority=None, speed=None,
                 status=None):
        self.create_time = create_time  # type: str
        self.modified_time = modified_time  # type: str
        self.name = name  # type: str
        self.pipeline_id = pipeline_id  # type: str
        self.priority = priority  # type: int
        self.speed = speed  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreatePipelineResponseBodyPipeline, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreatePipelineResponseBody(TeaModel):
    def __init__(self, pipeline=None, request_id=None):
        self.pipeline = pipeline  # type: CreatePipelineResponseBodyPipeline
        self.request_id = request_id  # type: str

    def validate(self):
        if self.pipeline:
            self.pipeline.validate()

    def to_map(self):
        _map = super(CreatePipelineResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline is not None:
            result['Pipeline'] = self.pipeline.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Pipeline') is not None:
            temp_model = CreatePipelineResponseBodyPipeline()
            self.pipeline = temp_model.from_map(m['Pipeline'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePipelineResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreatePipelineResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreatePipelineResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUploadMediaRequest(TeaModel):
    def __init__(self, app_id=None, entity_id=None, file_info=None, media_meta_data=None, post_process_config=None,
                 upload_target_config=None, user_data=None):
        self.app_id = app_id  # type: str
        self.entity_id = entity_id  # type: str
        self.file_info = file_info  # type: str
        self.media_meta_data = media_meta_data  # type: str
        self.post_process_config = post_process_config  # type: str
        self.upload_target_config = upload_target_config  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUploadMediaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.file_info is not None:
            result['FileInfo'] = self.file_info
        if self.media_meta_data is not None:
            result['MediaMetaData'] = self.media_meta_data
        if self.post_process_config is not None:
            result['PostProcessConfig'] = self.post_process_config
        if self.upload_target_config is not None:
            result['UploadTargetConfig'] = self.upload_target_config
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('FileInfo') is not None:
            self.file_info = m.get('FileInfo')
        if m.get('MediaMetaData') is not None:
            self.media_meta_data = m.get('MediaMetaData')
        if m.get('PostProcessConfig') is not None:
            self.post_process_config = m.get('PostProcessConfig')
        if m.get('UploadTargetConfig') is not None:
            self.upload_target_config = m.get('UploadTargetConfig')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class CreateUploadMediaResponseBody(TeaModel):
    def __init__(self, file_url=None, media_id=None, media_url=None, request_id=None, upload_address=None,
                 upload_auth=None):
        self.file_url = file_url  # type: str
        self.media_id = media_id  # type: str
        self.media_url = media_url  # type: str
        self.request_id = request_id  # type: str
        self.upload_address = upload_address  # type: str
        self.upload_auth = upload_auth  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUploadMediaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_url is not None:
            result['MediaURL'] = self.media_url
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.upload_address is not None:
            result['UploadAddress'] = self.upload_address
        if self.upload_auth is not None:
            result['UploadAuth'] = self.upload_auth
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaURL') is not None:
            self.media_url = m.get('MediaURL')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UploadAddress') is not None:
            self.upload_address = m.get('UploadAddress')
        if m.get('UploadAuth') is not None:
            self.upload_auth = m.get('UploadAuth')
        return self


class CreateUploadMediaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateUploadMediaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateUploadMediaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUploadMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUploadStreamRequest(TeaModel):
    def __init__(self, definition=None, file_extension=None, hdrtype=None, media_id=None, user_data=None):
        self.definition = definition  # type: str
        self.file_extension = file_extension  # type: str
        self.hdrtype = hdrtype  # type: str
        self.media_id = media_id  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUploadStreamRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.file_extension is not None:
            result['FileExtension'] = self.file_extension
        if self.hdrtype is not None:
            result['HDRType'] = self.hdrtype
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('FileExtension') is not None:
            self.file_extension = m.get('FileExtension')
        if m.get('HDRType') is not None:
            self.hdrtype = m.get('HDRType')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class CreateUploadStreamResponseBody(TeaModel):
    def __init__(self, file_url=None, media_id=None, request_id=None, upload_address=None, upload_auth=None):
        self.file_url = file_url  # type: str
        self.media_id = media_id  # type: str
        self.request_id = request_id  # type: str
        self.upload_address = upload_address  # type: str
        self.upload_auth = upload_auth  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUploadStreamResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.upload_address is not None:
            result['UploadAddress'] = self.upload_address
        if self.upload_auth is not None:
            result['UploadAuth'] = self.upload_auth
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UploadAddress') is not None:
            self.upload_address = m.get('UploadAddress')
        if m.get('UploadAuth') is not None:
            self.upload_auth = m.get('UploadAuth')
        return self


class CreateUploadStreamResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateUploadStreamResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateUploadStreamResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUploadStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCategoryRequest(TeaModel):
    def __init__(self, cate_id=None):
        self.cate_id = cate_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCategoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        return self


class DeleteCategoryResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCategoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCategoryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCategoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCategoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomTemplateRequest(TeaModel):
    def __init__(self, template_id=None):
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteCustomTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteCustomTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCustomTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCustomTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEditingProjectMaterialsRequest(TeaModel):
    def __init__(self, material_ids=None, material_type=None, project_id=None):
        self.material_ids = material_ids  # type: str
        self.material_type = material_type  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEditingProjectMaterialsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.material_ids is not None:
            result['MaterialIds'] = self.material_ids
        if self.material_type is not None:
            result['MaterialType'] = self.material_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaterialIds') is not None:
            self.material_ids = m.get('MaterialIds')
        if m.get('MaterialType') is not None:
            self.material_type = m.get('MaterialType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteEditingProjectMaterialsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEditingProjectMaterialsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEditingProjectMaterialsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteEditingProjectMaterialsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEditingProjectMaterialsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEditingProjectMaterialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEditingProjectsRequest(TeaModel):
    def __init__(self, project_ids=None):
        self.project_ids = project_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEditingProjectsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_ids is not None:
            result['ProjectIds'] = self.project_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectIds') is not None:
            self.project_ids = m.get('ProjectIds')
        return self


class DeleteEditingProjectsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEditingProjectsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEditingProjectsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteEditingProjectsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEditingProjectsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEditingProjectsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRecordFilesRequest(TeaModel):
    def __init__(self, record_ids=None, remove_file=None):
        self.record_ids = record_ids  # type: list[str]
        self.remove_file = remove_file  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveRecordFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_ids is not None:
            result['RecordIds'] = self.record_ids
        if self.remove_file is not None:
            result['RemoveFile'] = self.remove_file
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RecordIds') is not None:
            self.record_ids = m.get('RecordIds')
        if m.get('RemoveFile') is not None:
            self.remove_file = m.get('RemoveFile')
        return self


class DeleteLiveRecordFilesResponseBodyDeleteFileInfoList(TeaModel):
    def __init__(self, code=None, message=None, record_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.record_id = record_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveRecordFilesResponseBodyDeleteFileInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        return self


class DeleteLiveRecordFilesResponseBody(TeaModel):
    def __init__(self, delete_file_info_list=None, message=None, request_id=None):
        self.delete_file_info_list = delete_file_info_list  # type: list[DeleteLiveRecordFilesResponseBodyDeleteFileInfoList]
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.delete_file_info_list:
            for k in self.delete_file_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DeleteLiveRecordFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeleteFileInfoList'] = []
        if self.delete_file_info_list is not None:
            for k in self.delete_file_info_list:
                result['DeleteFileInfoList'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.delete_file_info_list = []
        if m.get('DeleteFileInfoList') is not None:
            for k in m.get('DeleteFileInfoList'):
                temp_model = DeleteLiveRecordFilesResponseBodyDeleteFileInfoList()
                self.delete_file_info_list.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRecordFilesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveRecordFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveRecordFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveRecordFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRecordTemplateRequest(TeaModel):
    def __init__(self, template_id=None):
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveRecordTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteLiveRecordTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveRecordTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRecordTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveRecordTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveRecordTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveRecordTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveSnapshotFilesRequest(TeaModel):
    def __init__(self, create_timestamp_list=None, delete_original_file=None, job_id=None):
        self.create_timestamp_list = create_timestamp_list  # type: list[long]
        self.delete_original_file = delete_original_file  # type: bool
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveSnapshotFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_timestamp_list is not None:
            result['CreateTimestampList'] = self.create_timestamp_list
        if self.delete_original_file is not None:
            result['DeleteOriginalFile'] = self.delete_original_file
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTimestampList') is not None:
            self.create_timestamp_list = m.get('CreateTimestampList')
        if m.get('DeleteOriginalFile') is not None:
            self.delete_original_file = m.get('DeleteOriginalFile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteLiveSnapshotFilesShrinkRequest(TeaModel):
    def __init__(self, create_timestamp_list_shrink=None, delete_original_file=None, job_id=None):
        self.create_timestamp_list_shrink = create_timestamp_list_shrink  # type: str
        self.delete_original_file = delete_original_file  # type: bool
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveSnapshotFilesShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_timestamp_list_shrink is not None:
            result['CreateTimestampList'] = self.create_timestamp_list_shrink
        if self.delete_original_file is not None:
            result['DeleteOriginalFile'] = self.delete_original_file
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTimestampList') is not None:
            self.create_timestamp_list_shrink = m.get('CreateTimestampList')
        if m.get('DeleteOriginalFile') is not None:
            self.delete_original_file = m.get('DeleteOriginalFile')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteLiveSnapshotFilesResponseBodyDeleteFileResultList(TeaModel):
    def __init__(self, create_timestamp=None, result=None):
        self.create_timestamp = create_timestamp  # type: long
        self.result = result  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveSnapshotFilesResponseBodyDeleteFileResultList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class DeleteLiveSnapshotFilesResponseBody(TeaModel):
    def __init__(self, delete_file_result_list=None, request_id=None):
        self.delete_file_result_list = delete_file_result_list  # type: list[DeleteLiveSnapshotFilesResponseBodyDeleteFileResultList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.delete_file_result_list:
            for k in self.delete_file_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DeleteLiveSnapshotFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeleteFileResultList'] = []
        if self.delete_file_result_list is not None:
            for k in self.delete_file_result_list:
                result['DeleteFileResultList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.delete_file_result_list = []
        if m.get('DeleteFileResultList') is not None:
            for k in m.get('DeleteFileResultList'):
                temp_model = DeleteLiveSnapshotFilesResponseBodyDeleteFileResultList()
                self.delete_file_result_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveSnapshotFilesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveSnapshotFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveSnapshotFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveSnapshotFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveSnapshotTemplateRequest(TeaModel):
    def __init__(self, template_id=None):
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveSnapshotTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteLiveSnapshotTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveSnapshotTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveSnapshotTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveSnapshotTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveSnapshotTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveSnapshotTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveTranscodeJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveTranscodeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteLiveTranscodeJobResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveTranscodeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveTranscodeJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveTranscodeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveTranscodeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveTranscodeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveTranscodeTemplateRequest(TeaModel):
    def __init__(self, template_id=None):
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveTranscodeTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteLiveTranscodeTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveTranscodeTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveTranscodeTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveTranscodeTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveTranscodeTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveTranscodeTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaInfosRequest(TeaModel):
    def __init__(self, delete_physical_files=None, input_urls=None, media_ids=None):
        self.delete_physical_files = delete_physical_files  # type: bool
        self.input_urls = input_urls  # type: str
        self.media_ids = media_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMediaInfosRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_physical_files is not None:
            result['DeletePhysicalFiles'] = self.delete_physical_files
        if self.input_urls is not None:
            result['InputURLs'] = self.input_urls
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeletePhysicalFiles') is not None:
            self.delete_physical_files = m.get('DeletePhysicalFiles')
        if m.get('InputURLs') is not None:
            self.input_urls = m.get('InputURLs')
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        return self


class DeleteMediaInfosResponseBody(TeaModel):
    def __init__(self, forbidden_list=None, ignored_list=None, request_id=None):
        self.forbidden_list = forbidden_list  # type: list[str]
        self.ignored_list = ignored_list  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMediaInfosResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.forbidden_list is not None:
            result['ForbiddenList'] = self.forbidden_list
        if self.ignored_list is not None:
            result['IgnoredList'] = self.ignored_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ForbiddenList') is not None:
            self.forbidden_list = m.get('ForbiddenList')
        if m.get('IgnoredList') is not None:
            self.ignored_list = m.get('IgnoredList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMediaInfosResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMediaInfosResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMediaInfosResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMediaInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePipelineRequest(TeaModel):
    def __init__(self, pipeline_id=None):
        self.pipeline_id = pipeline_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePipelineRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        return self


class DeletePipelineResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePipelineResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeletePipelineResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeletePipelineResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeletePipelineResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePlayInfoRequest(TeaModel):
    def __init__(self, delete_physical_files=None, file_urls=None, media_id=None):
        self.delete_physical_files = delete_physical_files  # type: bool
        self.file_urls = file_urls  # type: str
        self.media_id = media_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePlayInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_physical_files is not None:
            result['DeletePhysicalFiles'] = self.delete_physical_files
        if self.file_urls is not None:
            result['FileURLs'] = self.file_urls
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeletePhysicalFiles') is not None:
            self.delete_physical_files = m.get('DeletePhysicalFiles')
        if m.get('FileURLs') is not None:
            self.file_urls = m.get('FileURLs')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class DeletePlayInfoResponseBody(TeaModel):
    def __init__(self, forbidden_list=None, ignored_list=None, request_id=None):
        self.forbidden_list = forbidden_list  # type: list[str]
        self.ignored_list = ignored_list  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePlayInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.forbidden_list is not None:
            result['ForbiddenList'] = self.forbidden_list
        if self.ignored_list is not None:
            result['IgnoredList'] = self.ignored_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ForbiddenList') is not None:
            self.forbidden_list = m.get('ForbiddenList')
        if m.get('IgnoredList') is not None:
            self.ignored_list = m.get('IgnoredList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePlayInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeletePlayInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeletePlayInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePlayInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSmartJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSmartJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteSmartJobResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSmartJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSmartJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSmartJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSmartJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSmartJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTemplateRequest(TeaModel):
    def __init__(self, template_ids=None):
        self.template_ids = template_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_ids is not None:
            result['TemplateIds'] = self.template_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateIds') is not None:
            self.template_ids = m.get('TemplateIds')
        return self


class DeleteTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFilterConfigsRequest(TeaModel):
    def __init__(self, type=None):
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFilterConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeFilterConfigsResponseBodyFilterConfigs(TeaModel):
    def __init__(self, filter_name=None, item_configs=None, type=None, uu_id=None):
        self.filter_name = filter_name  # type: str
        self.item_configs = item_configs  # type: str
        self.type = type  # type: str
        self.uu_id = uu_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFilterConfigsResponseBodyFilterConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filter_name is not None:
            result['FilterName'] = self.filter_name
        if self.item_configs is not None:
            result['ItemConfigs'] = self.item_configs
        if self.type is not None:
            result['Type'] = self.type
        if self.uu_id is not None:
            result['UuId'] = self.uu_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FilterName') is not None:
            self.filter_name = m.get('FilterName')
        if m.get('ItemConfigs') is not None:
            self.item_configs = m.get('ItemConfigs')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UuId') is not None:
            self.uu_id = m.get('UuId')
        return self


class DescribeFilterConfigsResponseBody(TeaModel):
    def __init__(self, filter_configs=None, request_id=None):
        self.filter_configs = filter_configs  # type: list[DescribeFilterConfigsResponseBodyFilterConfigs]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.filter_configs:
            for k in self.filter_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeFilterConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FilterConfigs'] = []
        if self.filter_configs is not None:
            for k in self.filter_configs:
                result['FilterConfigs'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.filter_configs = []
        if m.get('FilterConfigs') is not None:
            for k in m.get('FilterConfigs'):
                temp_model = DescribeFilterConfigsResponseBodyFilterConfigs()
                self.filter_configs.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFilterConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeFilterConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeFilterConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFilterConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterIceEditUsageRequest(TeaModel):
    def __init__(self, end_ts=None, interval=None, region=None, start_ts=None):
        self.end_ts = end_ts  # type: long
        self.interval = interval  # type: long
        self.region = region  # type: str
        self.start_ts = start_ts  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterIceEditUsageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterIceEditUsageResponseBodyData(TeaModel):
    def __init__(self, duration=None, profile=None, time=None):
        self.duration = duration  # type: long
        self.profile = profile  # type: str
        self.time = time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterIceEditUsageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterIceEditUsageResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeMeterIceEditUsageResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMeterIceEditUsageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterIceEditUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterIceEditUsageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMeterIceEditUsageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMeterIceEditUsageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterIceEditUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterIceLiveMediaConvertUsageRequest(TeaModel):
    def __init__(self, end_ts=None, interval=None, region=None, start_ts=None):
        self.end_ts = end_ts  # type: long
        self.interval = interval  # type: long
        self.region = region  # type: str
        self.start_ts = start_ts  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterIceLiveMediaConvertUsageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterIceLiveMediaConvertUsageResponseBodyData(TeaModel):
    def __init__(self, duration=None, specification=None, time=None):
        self.duration = duration  # type: long
        self.specification = specification  # type: str
        self.time = time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterIceLiveMediaConvertUsageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterIceLiveMediaConvertUsageResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeMeterIceLiveMediaConvertUsageResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMeterIceLiveMediaConvertUsageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterIceLiveMediaConvertUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterIceLiveMediaConvertUsageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMeterIceLiveMediaConvertUsageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMeterIceLiveMediaConvertUsageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterIceLiveMediaConvertUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterIceMediaConvertUHDUsageRequest(TeaModel):
    def __init__(self, end_ts=None, interval=None, region_id=None, start_ts=None):
        self.end_ts = end_ts  # type: long
        self.interval = interval  # type: str
        self.region_id = region_id  # type: str
        self.start_ts = start_ts  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterIceMediaConvertUHDUsageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterIceMediaConvertUHDUsageResponseBodyData(TeaModel):
    def __init__(self, duration=None, specification=None, time=None):
        self.duration = duration  # type: long
        self.specification = specification  # type: str
        self.time = time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterIceMediaConvertUHDUsageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterIceMediaConvertUHDUsageResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeMeterIceMediaConvertUHDUsageResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMeterIceMediaConvertUHDUsageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterIceMediaConvertUHDUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterIceMediaConvertUHDUsageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMeterIceMediaConvertUHDUsageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMeterIceMediaConvertUHDUsageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterIceMediaConvertUHDUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterIceMediaConvertUsageRequest(TeaModel):
    def __init__(self, end_ts=None, interval=None, region=None, start_ts=None):
        self.end_ts = end_ts  # type: long
        self.interval = interval  # type: long
        self.region = region  # type: str
        self.start_ts = start_ts  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterIceMediaConvertUsageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterIceMediaConvertUsageResponseBodyData(TeaModel):
    def __init__(self, duration=None, specification=None, time=None):
        self.duration = duration  # type: long
        self.specification = specification  # type: str
        self.time = time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterIceMediaConvertUsageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterIceMediaConvertUsageResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeMeterIceMediaConvertUsageResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMeterIceMediaConvertUsageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterIceMediaConvertUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterIceMediaConvertUsageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMeterIceMediaConvertUsageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMeterIceMediaConvertUsageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterIceMediaConvertUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterIceMpsAiUsageRequest(TeaModel):
    def __init__(self, end_ts=None, interval=None, region=None, start_ts=None):
        self.end_ts = end_ts  # type: long
        self.interval = interval  # type: long
        self.region = region  # type: str
        self.start_ts = start_ts  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterIceMpsAiUsageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterIceMpsAiUsageResponseBodyData(TeaModel):
    def __init__(self, duration=None, time=None, type=None):
        self.duration = duration  # type: long
        self.time = time  # type: long
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterIceMpsAiUsageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.time is not None:
            result['Time'] = self.time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeMeterIceMpsAiUsageResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeMeterIceMpsAiUsageResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMeterIceMpsAiUsageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterIceMpsAiUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterIceMpsAiUsageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMeterIceMpsAiUsageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMeterIceMpsAiUsageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterIceMpsAiUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterImsEditUsageRequest(TeaModel):
    def __init__(self, end_ts=None, interval=None, region=None, start_ts=None):
        self.end_ts = end_ts  # type: long
        self.interval = interval  # type: long
        self.region = region  # type: str
        self.start_ts = start_ts  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsEditUsageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterImsEditUsageResponseBodyData(TeaModel):
    def __init__(self, duration=None, profile=None, time=None):
        self.duration = duration  # type: long
        self.profile = profile  # type: str
        self.time = time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsEditUsageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterImsEditUsageResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeMeterImsEditUsageResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMeterImsEditUsageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterImsEditUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterImsEditUsageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMeterImsEditUsageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMeterImsEditUsageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterImsEditUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterImsLiveEditUsageRequest(TeaModel):
    def __init__(self, end_ts=None, interval=None, region=None, start_ts=None):
        self.end_ts = end_ts  # type: long
        self.interval = interval  # type: long
        self.region = region  # type: str
        self.start_ts = start_ts  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsLiveEditUsageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterImsLiveEditUsageResponseBodyData(TeaModel):
    def __init__(self, duration=None, profile=None, time=None):
        self.duration = duration  # type: long
        self.profile = profile  # type: str
        self.time = time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsLiveEditUsageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterImsLiveEditUsageResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeMeterImsLiveEditUsageResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMeterImsLiveEditUsageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterImsLiveEditUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterImsLiveEditUsageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMeterImsLiveEditUsageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMeterImsLiveEditUsageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterImsLiveEditUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterImsLiveMediaConvertUsageRequest(TeaModel):
    def __init__(self, end_ts=None, interval=None, region=None, start_ts=None):
        self.end_ts = end_ts  # type: long
        self.interval = interval  # type: long
        self.region = region  # type: str
        self.start_ts = start_ts  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsLiveMediaConvertUsageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterImsLiveMediaConvertUsageResponseBodyData(TeaModel):
    def __init__(self, duration=None, specification=None, time=None):
        self.duration = duration  # type: long
        self.specification = specification  # type: str
        self.time = time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsLiveMediaConvertUsageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterImsLiveMediaConvertUsageResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeMeterImsLiveMediaConvertUsageResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMeterImsLiveMediaConvertUsageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterImsLiveMediaConvertUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterImsLiveMediaConvertUsageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMeterImsLiveMediaConvertUsageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMeterImsLiveMediaConvertUsageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterImsLiveMediaConvertUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterImsLiveRecordUsageRequest(TeaModel):
    def __init__(self, end_ts=None, interval=None, region=None, start_ts=None):
        self.end_ts = end_ts  # type: long
        self.interval = interval  # type: long
        self.region = region  # type: str
        self.start_ts = start_ts  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsLiveRecordUsageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterImsLiveRecordUsageResponseBodyData(TeaModel):
    def __init__(self, channels=None, duration=None, time=None, type=None):
        self.channels = channels  # type: float
        self.duration = duration  # type: long
        self.time = time  # type: long
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsLiveRecordUsageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.time is not None:
            result['Time'] = self.time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeMeterImsLiveRecordUsageResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeMeterImsLiveRecordUsageResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMeterImsLiveRecordUsageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterImsLiveRecordUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterImsLiveRecordUsageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMeterImsLiveRecordUsageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMeterImsLiveRecordUsageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterImsLiveRecordUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterImsLiveSnapshotUsageRequest(TeaModel):
    def __init__(self, end_ts=None, interval=None, region=None, start_ts=None):
        self.end_ts = end_ts  # type: long
        self.interval = interval  # type: long
        self.region = region  # type: str
        self.start_ts = start_ts  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsLiveSnapshotUsageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterImsLiveSnapshotUsageResponseBodyData(TeaModel):
    def __init__(self, count=None, time=None):
        self.count = count  # type: long
        self.time = time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsLiveSnapshotUsageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterImsLiveSnapshotUsageResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeMeterImsLiveSnapshotUsageResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMeterImsLiveSnapshotUsageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterImsLiveSnapshotUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterImsLiveSnapshotUsageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMeterImsLiveSnapshotUsageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMeterImsLiveSnapshotUsageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterImsLiveSnapshotUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterImsMediaConvertUHDUsageRequest(TeaModel):
    def __init__(self, end_ts=None, interval=None, region_id=None, start_ts=None):
        self.end_ts = end_ts  # type: long
        self.interval = interval  # type: str
        self.region_id = region_id  # type: str
        self.start_ts = start_ts  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsMediaConvertUHDUsageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterImsMediaConvertUHDUsageResponseBodyData(TeaModel):
    def __init__(self, duration=None, specification=None, time=None):
        self.duration = duration  # type: long
        self.specification = specification  # type: str
        self.time = time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsMediaConvertUHDUsageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterImsMediaConvertUHDUsageResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeMeterImsMediaConvertUHDUsageResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMeterImsMediaConvertUHDUsageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterImsMediaConvertUHDUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterImsMediaConvertUHDUsageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMeterImsMediaConvertUHDUsageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMeterImsMediaConvertUHDUsageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterImsMediaConvertUHDUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterImsMediaConvertUsageRequest(TeaModel):
    def __init__(self, end_ts=None, interval=None, region=None, start_ts=None):
        self.end_ts = end_ts  # type: long
        self.interval = interval  # type: long
        self.region = region  # type: str
        self.start_ts = start_ts  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsMediaConvertUsageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterImsMediaConvertUsageResponseBodyData(TeaModel):
    def __init__(self, duration=None, specification=None, time=None):
        self.duration = duration  # type: long
        self.specification = specification  # type: str
        self.time = time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsMediaConvertUsageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterImsMediaConvertUsageResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeMeterImsMediaConvertUsageResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMeterImsMediaConvertUsageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterImsMediaConvertUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterImsMediaConvertUsageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMeterImsMediaConvertUsageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMeterImsMediaConvertUsageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterImsMediaConvertUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterImsMpsAiUsageRequest(TeaModel):
    def __init__(self, end_ts=None, interval=None, region=None, start_ts=None):
        self.end_ts = end_ts  # type: long
        self.interval = interval  # type: long
        self.region = region  # type: str
        self.start_ts = start_ts  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsMpsAiUsageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterImsMpsAiUsageResponseBodyData(TeaModel):
    def __init__(self, duration=None, time=None, type=None):
        self.duration = duration  # type: long
        self.time = time  # type: long
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsMpsAiUsageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.time is not None:
            result['Time'] = self.time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeMeterImsMpsAiUsageResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeMeterImsMpsAiUsageResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMeterImsMpsAiUsageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterImsMpsAiUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterImsMpsAiUsageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMeterImsMpsAiUsageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMeterImsMpsAiUsageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterImsMpsAiUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterImsSummaryRequest(TeaModel):
    def __init__(self, end_ts=None, region=None, start_ts=None):
        self.end_ts = end_ts  # type: long
        self.region = region  # type: str
        self.start_ts = start_ts  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsSummaryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterImsSummaryResponseBodyData(TeaModel):
    def __init__(self, editing_duration=None, live_edit_duration=None, live_record_duration=None,
                 live_snapshot_count=None, live_transcode_duration=None, mps_ai_duration=None, mps_transcode_duration=None,
                 mps_transcode_uhdduration=None):
        self.editing_duration = editing_duration  # type: str
        self.live_edit_duration = live_edit_duration  # type: str
        self.live_record_duration = live_record_duration  # type: str
        self.live_snapshot_count = live_snapshot_count  # type: str
        self.live_transcode_duration = live_transcode_duration  # type: long
        self.mps_ai_duration = mps_ai_duration  # type: long
        self.mps_transcode_duration = mps_transcode_duration  # type: long
        self.mps_transcode_uhdduration = mps_transcode_uhdduration  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMeterImsSummaryResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.editing_duration is not None:
            result['EditingDuration'] = self.editing_duration
        if self.live_edit_duration is not None:
            result['LiveEditDuration'] = self.live_edit_duration
        if self.live_record_duration is not None:
            result['LiveRecordDuration'] = self.live_record_duration
        if self.live_snapshot_count is not None:
            result['LiveSnapshotCount'] = self.live_snapshot_count
        if self.live_transcode_duration is not None:
            result['LiveTranscodeDuration'] = self.live_transcode_duration
        if self.mps_ai_duration is not None:
            result['MpsAiDuration'] = self.mps_ai_duration
        if self.mps_transcode_duration is not None:
            result['MpsTranscodeDuration'] = self.mps_transcode_duration
        if self.mps_transcode_uhdduration is not None:
            result['MpsTranscodeUHDDuration'] = self.mps_transcode_uhdduration
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EditingDuration') is not None:
            self.editing_duration = m.get('EditingDuration')
        if m.get('LiveEditDuration') is not None:
            self.live_edit_duration = m.get('LiveEditDuration')
        if m.get('LiveRecordDuration') is not None:
            self.live_record_duration = m.get('LiveRecordDuration')
        if m.get('LiveSnapshotCount') is not None:
            self.live_snapshot_count = m.get('LiveSnapshotCount')
        if m.get('LiveTranscodeDuration') is not None:
            self.live_transcode_duration = m.get('LiveTranscodeDuration')
        if m.get('MpsAiDuration') is not None:
            self.mps_ai_duration = m.get('MpsAiDuration')
        if m.get('MpsTranscodeDuration') is not None:
            self.mps_transcode_duration = m.get('MpsTranscodeDuration')
        if m.get('MpsTranscodeUHDDuration') is not None:
            self.mps_transcode_uhdduration = m.get('MpsTranscodeUHDDuration')
        return self


class DescribeMeterImsSummaryResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeMeterImsSummaryResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMeterImsSummaryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterImsSummaryResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterImsSummaryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMeterImsSummaryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMeterImsSummaryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterImsSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayDetailRequest(TeaModel):
    def __init__(self, session_id=None):
        self.session_id = session_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        return self


class DescribePlayDetailResponseBodyBaseInfos(TeaModel):
    def __init__(self, app_name=None, bps=None, broadcast_pace=None, client_ip=None, codec=None,
                 decode_stuck_time=None, definition=None, first_frame_duration=None, fps=None, is_hard_decode=None, mdat=None,
                 moov=None, network=None, network_duration=None, network_stuck_time=None, os=None, play_ts=None,
                 player_load_duration=None, player_pre_deal_duration=None, player_ready_duration=None, sdk_version=None,
                 session_id=None, status=None, terminal_type=None):
        self.app_name = app_name  # type: str
        self.bps = bps  # type: str
        self.broadcast_pace = broadcast_pace  # type: str
        self.client_ip = client_ip  # type: str
        self.codec = codec  # type: str
        self.decode_stuck_time = decode_stuck_time  # type: str
        self.definition = definition  # type: str
        self.first_frame_duration = first_frame_duration  # type: str
        self.fps = fps  # type: str
        self.is_hard_decode = is_hard_decode  # type: str
        self.mdat = mdat  # type: str
        self.moov = moov  # type: str
        self.network = network  # type: str
        self.network_duration = network_duration  # type: str
        self.network_stuck_time = network_stuck_time  # type: str
        self.os = os  # type: str
        self.play_ts = play_ts  # type: str
        self.player_load_duration = player_load_duration  # type: str
        self.player_pre_deal_duration = player_pre_deal_duration  # type: str
        self.player_ready_duration = player_ready_duration  # type: str
        self.sdk_version = sdk_version  # type: str
        self.session_id = session_id  # type: str
        self.status = status  # type: str
        self.terminal_type = terminal_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayDetailResponseBodyBaseInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.bps is not None:
            result['Bps'] = self.bps
        if self.broadcast_pace is not None:
            result['BroadcastPace'] = self.broadcast_pace
        if self.client_ip is not None:
            result['ClientIP'] = self.client_ip
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.decode_stuck_time is not None:
            result['DecodeStuckTime'] = self.decode_stuck_time
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.first_frame_duration is not None:
            result['FirstFrameDuration'] = self.first_frame_duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.is_hard_decode is not None:
            result['IsHardDecode'] = self.is_hard_decode
        if self.mdat is not None:
            result['Mdat'] = self.mdat
        if self.moov is not None:
            result['Moov'] = self.moov
        if self.network is not None:
            result['Network'] = self.network
        if self.network_duration is not None:
            result['NetworkDuration'] = self.network_duration
        if self.network_stuck_time is not None:
            result['NetworkStuckTime'] = self.network_stuck_time
        if self.os is not None:
            result['Os'] = self.os
        if self.play_ts is not None:
            result['PlayTs'] = self.play_ts
        if self.player_load_duration is not None:
            result['PlayerLoadDuration'] = self.player_load_duration
        if self.player_pre_deal_duration is not None:
            result['PlayerPreDealDuration'] = self.player_pre_deal_duration
        if self.player_ready_duration is not None:
            result['PlayerReadyDuration'] = self.player_ready_duration
        if self.sdk_version is not None:
            result['SdkVersion'] = self.sdk_version
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.status is not None:
            result['Status'] = self.status
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Bps') is not None:
            self.bps = m.get('Bps')
        if m.get('BroadcastPace') is not None:
            self.broadcast_pace = m.get('BroadcastPace')
        if m.get('ClientIP') is not None:
            self.client_ip = m.get('ClientIP')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('DecodeStuckTime') is not None:
            self.decode_stuck_time = m.get('DecodeStuckTime')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('FirstFrameDuration') is not None:
            self.first_frame_duration = m.get('FirstFrameDuration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('IsHardDecode') is not None:
            self.is_hard_decode = m.get('IsHardDecode')
        if m.get('Mdat') is not None:
            self.mdat = m.get('Mdat')
        if m.get('Moov') is not None:
            self.moov = m.get('Moov')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('NetworkDuration') is not None:
            self.network_duration = m.get('NetworkDuration')
        if m.get('NetworkStuckTime') is not None:
            self.network_stuck_time = m.get('NetworkStuckTime')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('PlayTs') is not None:
            self.play_ts = m.get('PlayTs')
        if m.get('PlayerLoadDuration') is not None:
            self.player_load_duration = m.get('PlayerLoadDuration')
        if m.get('PlayerPreDealDuration') is not None:
            self.player_pre_deal_duration = m.get('PlayerPreDealDuration')
        if m.get('PlayerReadyDuration') is not None:
            self.player_ready_duration = m.get('PlayerReadyDuration')
        if m.get('SdkVersion') is not None:
            self.sdk_version = m.get('SdkVersion')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribePlayDetailResponseBody(TeaModel):
    def __init__(self, base_infos=None, request_id=None):
        self.base_infos = base_infos  # type: list[DescribePlayDetailResponseBodyBaseInfos]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.base_infos:
            for k in self.base_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePlayDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BaseInfos'] = []
        if self.base_infos is not None:
            for k in self.base_infos:
                result['BaseInfos'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.base_infos = []
        if m.get('BaseInfos') is not None:
            for k in m.get('BaseInfos'):
                temp_model = DescribePlayDetailResponseBodyBaseInfos()
                self.base_infos.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePlayDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePlayDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePlayDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayEventListRequest(TeaModel):
    def __init__(self, page_no=None, page_size=None, session_id=None):
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.session_id = session_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayEventListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        return self


class DescribePlayEventListResponseBodyEventList(TeaModel):
    def __init__(self, description=None, duration=None, event_name=None, time=None, topic=None):
        self.description = description  # type: str
        self.duration = duration  # type: float
        self.event_name = event_name  # type: str
        self.time = time  # type: long
        self.topic = topic  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayEventListResponseBodyEventList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.time is not None:
            result['Time'] = self.time
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class DescribePlayEventListResponseBody(TeaModel):
    def __init__(self, event_list=None, page_no=None, page_size=None, request_id=None, total_count=None):
        self.event_list = event_list  # type: list[DescribePlayEventListResponseBodyEventList]
        self.page_no = page_no  # type: long
        self.page_size = page_size  # type: long
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: long

    def validate(self):
        if self.event_list:
            for k in self.event_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePlayEventListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventList'] = []
        if self.event_list is not None:
            for k in self.event_list:
                result['EventList'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.event_list = []
        if m.get('EventList') is not None:
            for k in m.get('EventList'):
                temp_model = DescribePlayEventListResponseBodyEventList()
                self.event_list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePlayEventListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePlayEventListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePlayEventListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayEventListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayFirstFrameDurationMetricDataRequest(TeaModel):
    def __init__(self, begin_ts=None, end_ts=None, trace_id=None):
        self.begin_ts = begin_ts  # type: str
        self.end_ts = end_ts  # type: str
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayFirstFrameDurationMetricDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribePlayFirstFrameDurationMetricDataResponseBodyNodes(TeaModel):
    def __init__(self, x=None, y=None):
        self.x = x  # type: long
        self.y = y  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayFirstFrameDurationMetricDataResponseBodyNodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.x is not None:
            result['X'] = self.x
        if self.y is not None:
            result['Y'] = self.y
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('X') is not None:
            self.x = m.get('X')
        if m.get('Y') is not None:
            self.y = m.get('Y')
        return self


class DescribePlayFirstFrameDurationMetricDataResponseBody(TeaModel):
    def __init__(self, nodes=None, request_id=None):
        self.nodes = nodes  # type: list[DescribePlayFirstFrameDurationMetricDataResponseBodyNodes]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePlayFirstFrameDurationMetricDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = DescribePlayFirstFrameDurationMetricDataResponseBodyNodes()
                self.nodes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePlayFirstFrameDurationMetricDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePlayFirstFrameDurationMetricDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePlayFirstFrameDurationMetricDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayFirstFrameDurationMetricDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayListRequest(TeaModel):
    def __init__(self, begin_ts=None, end_ts=None, order_name=None, order_type=None, page_no=None, page_size=None,
                 play_type=None, status=None, trace_id=None):
        self.begin_ts = begin_ts  # type: str
        self.end_ts = end_ts  # type: str
        self.order_name = order_name  # type: str
        self.order_type = order_type  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.play_type = play_type  # type: str
        self.status = status  # type: str
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.order_name is not None:
            result['OrderName'] = self.order_name
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.play_type is not None:
            result['PlayType'] = self.play_type
        if self.status is not None:
            result['Status'] = self.status
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('OrderName') is not None:
            self.order_name = m.get('OrderName')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PlayType') is not None:
            self.play_type = m.get('PlayType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribePlayListResponseBodyPlayList(TeaModel):
    def __init__(self, first_frame_duration=None, play_duration=None, play_type=None, session_id=None, status=None,
                 stuck_duration=None, trace_id=None, video_duration=None, video_id=None):
        self.first_frame_duration = first_frame_duration  # type: str
        self.play_duration = play_duration  # type: str
        self.play_type = play_type  # type: str
        self.session_id = session_id  # type: str
        self.status = status  # type: str
        self.stuck_duration = stuck_duration  # type: str
        self.trace_id = trace_id  # type: str
        self.video_duration = video_duration  # type: str
        self.video_id = video_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayListResponseBodyPlayList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.first_frame_duration is not None:
            result['FirstFrameDuration'] = self.first_frame_duration
        if self.play_duration is not None:
            result['PlayDuration'] = self.play_duration
        if self.play_type is not None:
            result['PlayType'] = self.play_type
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.status is not None:
            result['Status'] = self.status
        if self.stuck_duration is not None:
            result['StuckDuration'] = self.stuck_duration
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        if self.video_duration is not None:
            result['VideoDuration'] = self.video_duration
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirstFrameDuration') is not None:
            self.first_frame_duration = m.get('FirstFrameDuration')
        if m.get('PlayDuration') is not None:
            self.play_duration = m.get('PlayDuration')
        if m.get('PlayType') is not None:
            self.play_type = m.get('PlayType')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StuckDuration') is not None:
            self.stuck_duration = m.get('StuckDuration')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        if m.get('VideoDuration') is not None:
            self.video_duration = m.get('VideoDuration')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class DescribePlayListResponseBody(TeaModel):
    def __init__(self, page_num=None, page_size=None, play_list=None, request_id=None, total_num=None):
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.play_list = play_list  # type: list[DescribePlayListResponseBodyPlayList]
        self.request_id = request_id  # type: str
        self.total_num = total_num  # type: long

    def validate(self):
        if self.play_list:
            for k in self.play_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePlayListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['PlayList'] = []
        if self.play_list is not None:
            for k in self.play_list:
                result['PlayList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.play_list = []
        if m.get('PlayList') is not None:
            for k in m.get('PlayList'):
                temp_model = DescribePlayListResponseBodyPlayList()
                self.play_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class DescribePlayListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePlayListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePlayListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayMetricDataRequest(TeaModel):
    def __init__(self, app_name=None, begin_ts=None, definition=None, end_ts=None, experience_level=None,
                 item_configs=None, metric_type=None, network=None, os=None, sdk_version=None, terminal_type=None):
        self.app_name = app_name  # type: str
        self.begin_ts = begin_ts  # type: long
        self.definition = definition  # type: str
        self.end_ts = end_ts  # type: long
        self.experience_level = experience_level  # type: str
        self.item_configs = item_configs  # type: str
        self.metric_type = metric_type  # type: str
        self.network = network  # type: str
        self.os = os  # type: str
        self.sdk_version = sdk_version  # type: str
        self.terminal_type = terminal_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayMetricDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.experience_level is not None:
            result['ExperienceLevel'] = self.experience_level
        if self.item_configs is not None:
            result['ItemConfigs'] = self.item_configs
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.network is not None:
            result['Network'] = self.network
        if self.os is not None:
            result['Os'] = self.os
        if self.sdk_version is not None:
            result['SdkVersion'] = self.sdk_version
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('ExperienceLevel') is not None:
            self.experience_level = m.get('ExperienceLevel')
        if m.get('ItemConfigs') is not None:
            self.item_configs = m.get('ItemConfigs')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('SdkVersion') is not None:
            self.sdk_version = m.get('SdkVersion')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribePlayMetricDataResponseBodyNodes(TeaModel):
    def __init__(self, x=None, y=None):
        self.x = x  # type: str
        self.y = y  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayMetricDataResponseBodyNodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.x is not None:
            result['X'] = self.x
        if self.y is not None:
            result['Y'] = self.y
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('X') is not None:
            self.x = m.get('X')
        if m.get('Y') is not None:
            self.y = m.get('Y')
        return self


class DescribePlayMetricDataResponseBody(TeaModel):
    def __init__(self, nodes=None, request_id=None, summary_data=None):
        self.nodes = nodes  # type: list[DescribePlayMetricDataResponseBodyNodes]
        self.request_id = request_id  # type: str
        self.summary_data = summary_data  # type: str

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePlayMetricDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.summary_data is not None:
            result['SummaryData'] = self.summary_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = DescribePlayMetricDataResponseBodyNodes()
                self.nodes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SummaryData') is not None:
            self.summary_data = m.get('SummaryData')
        return self


class DescribePlayMetricDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePlayMetricDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePlayMetricDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayMetricDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayQoeListRequest(TeaModel):
    def __init__(self, app_name=None, begin_ts=None, definition=None, end_ts=None, item_configs=None,
                 metric_types=None, network=None, order_name=None, order_type=None, os=None, page_no=None, page_size=None,
                 terminal_type=None):
        self.app_name = app_name  # type: str
        self.begin_ts = begin_ts  # type: long
        self.definition = definition  # type: str
        self.end_ts = end_ts  # type: long
        self.item_configs = item_configs  # type: str
        self.metric_types = metric_types  # type: list[str]
        self.network = network  # type: str
        self.order_name = order_name  # type: str
        self.order_type = order_type  # type: str
        self.os = os  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.terminal_type = terminal_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayQoeListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.item_configs is not None:
            result['ItemConfigs'] = self.item_configs
        if self.metric_types is not None:
            result['MetricTypes'] = self.metric_types
        if self.network is not None:
            result['Network'] = self.network
        if self.order_name is not None:
            result['OrderName'] = self.order_name
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.os is not None:
            result['Os'] = self.os
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('ItemConfigs') is not None:
            self.item_configs = m.get('ItemConfigs')
        if m.get('MetricTypes') is not None:
            self.metric_types = m.get('MetricTypes')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('OrderName') is not None:
            self.order_name = m.get('OrderName')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribePlayQoeListShrinkRequest(TeaModel):
    def __init__(self, app_name=None, begin_ts=None, definition=None, end_ts=None, item_configs=None,
                 metric_types_shrink=None, network=None, order_name=None, order_type=None, os=None, page_no=None, page_size=None,
                 terminal_type=None):
        self.app_name = app_name  # type: str
        self.begin_ts = begin_ts  # type: long
        self.definition = definition  # type: str
        self.end_ts = end_ts  # type: long
        self.item_configs = item_configs  # type: str
        self.metric_types_shrink = metric_types_shrink  # type: str
        self.network = network  # type: str
        self.order_name = order_name  # type: str
        self.order_type = order_type  # type: str
        self.os = os  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.terminal_type = terminal_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayQoeListShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.item_configs is not None:
            result['ItemConfigs'] = self.item_configs
        if self.metric_types_shrink is not None:
            result['MetricTypes'] = self.metric_types_shrink
        if self.network is not None:
            result['Network'] = self.network
        if self.order_name is not None:
            result['OrderName'] = self.order_name
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.os is not None:
            result['Os'] = self.os
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('ItemConfigs') is not None:
            self.item_configs = m.get('ItemConfigs')
        if m.get('MetricTypes') is not None:
            self.metric_types_shrink = m.get('MetricTypes')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('OrderName') is not None:
            self.order_name = m.get('OrderName')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribePlayQoeListResponseBodyQoeInfoList(TeaModel):
    def __init__(self, qoe_finished_vv=None, qoe_finished_vvrate=None, qoe_ufinished_vvtime=None, qoe_uv=None,
                 qoe_uvvduration=None, qoe_uvvtime=None, qoe_vduration=None, qoe_vvduration=None, trace_id=None):
        self.qoe_finished_vv = qoe_finished_vv  # type: float
        self.qoe_finished_vvrate = qoe_finished_vvrate  # type: float
        self.qoe_ufinished_vvtime = qoe_ufinished_vvtime  # type: float
        self.qoe_uv = qoe_uv  # type: float
        self.qoe_uvvduration = qoe_uvvduration  # type: float
        self.qoe_uvvtime = qoe_uvvtime  # type: float
        self.qoe_vduration = qoe_vduration  # type: float
        self.qoe_vvduration = qoe_vvduration  # type: float
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayQoeListResponseBodyQoeInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qoe_finished_vv is not None:
            result['QoeFinishedVV'] = self.qoe_finished_vv
        if self.qoe_finished_vvrate is not None:
            result['QoeFinishedVVRate'] = self.qoe_finished_vvrate
        if self.qoe_ufinished_vvtime is not None:
            result['QoeUFinishedVVTime'] = self.qoe_ufinished_vvtime
        if self.qoe_uv is not None:
            result['QoeUV'] = self.qoe_uv
        if self.qoe_uvvduration is not None:
            result['QoeUVVDuration'] = self.qoe_uvvduration
        if self.qoe_uvvtime is not None:
            result['QoeUVVTime'] = self.qoe_uvvtime
        if self.qoe_vduration is not None:
            result['QoeVDuration'] = self.qoe_vduration
        if self.qoe_vvduration is not None:
            result['QoeVVDuration'] = self.qoe_vvduration
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QoeFinishedVV') is not None:
            self.qoe_finished_vv = m.get('QoeFinishedVV')
        if m.get('QoeFinishedVVRate') is not None:
            self.qoe_finished_vvrate = m.get('QoeFinishedVVRate')
        if m.get('QoeUFinishedVVTime') is not None:
            self.qoe_ufinished_vvtime = m.get('QoeUFinishedVVTime')
        if m.get('QoeUV') is not None:
            self.qoe_uv = m.get('QoeUV')
        if m.get('QoeUVVDuration') is not None:
            self.qoe_uvvduration = m.get('QoeUVVDuration')
        if m.get('QoeUVVTime') is not None:
            self.qoe_uvvtime = m.get('QoeUVVTime')
        if m.get('QoeVDuration') is not None:
            self.qoe_vduration = m.get('QoeVDuration')
        if m.get('QoeVVDuration') is not None:
            self.qoe_vvduration = m.get('QoeVVDuration')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribePlayQoeListResponseBody(TeaModel):
    def __init__(self, page_no=None, page_size=None, qoe_info_list=None, request_id=None, total_count=None):
        self.page_no = page_no  # type: long
        self.page_size = page_size  # type: long
        self.qoe_info_list = qoe_info_list  # type: list[DescribePlayQoeListResponseBodyQoeInfoList]
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: long

    def validate(self):
        if self.qoe_info_list:
            for k in self.qoe_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePlayQoeListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['QoeInfoList'] = []
        if self.qoe_info_list is not None:
            for k in self.qoe_info_list:
                result['QoeInfoList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.qoe_info_list = []
        if m.get('QoeInfoList') is not None:
            for k in m.get('QoeInfoList'):
                temp_model = DescribePlayQoeListResponseBodyQoeInfoList()
                self.qoe_info_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePlayQoeListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePlayQoeListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePlayQoeListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayQoeListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayQosListRequest(TeaModel):
    def __init__(self, app_name=None, begin_ts=None, definition=None, end_ts=None, item_configs=None,
                 metric_types=None, network=None, order_name=None, order_type=None, os=None, page_no=None, page_size=None,
                 terminal_type=None):
        self.app_name = app_name  # type: str
        self.begin_ts = begin_ts  # type: str
        self.definition = definition  # type: str
        self.end_ts = end_ts  # type: str
        self.item_configs = item_configs  # type: str
        self.metric_types = metric_types  # type: list[str]
        self.network = network  # type: str
        self.order_name = order_name  # type: str
        self.order_type = order_type  # type: str
        self.os = os  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.terminal_type = terminal_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayQosListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.item_configs is not None:
            result['ItemConfigs'] = self.item_configs
        if self.metric_types is not None:
            result['MetricTypes'] = self.metric_types
        if self.network is not None:
            result['Network'] = self.network
        if self.order_name is not None:
            result['OrderName'] = self.order_name
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.os is not None:
            result['Os'] = self.os
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('ItemConfigs') is not None:
            self.item_configs = m.get('ItemConfigs')
        if m.get('MetricTypes') is not None:
            self.metric_types = m.get('MetricTypes')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('OrderName') is not None:
            self.order_name = m.get('OrderName')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribePlayQosListShrinkRequest(TeaModel):
    def __init__(self, app_name=None, begin_ts=None, definition=None, end_ts=None, item_configs=None,
                 metric_types_shrink=None, network=None, order_name=None, order_type=None, os=None, page_no=None, page_size=None,
                 terminal_type=None):
        self.app_name = app_name  # type: str
        self.begin_ts = begin_ts  # type: str
        self.definition = definition  # type: str
        self.end_ts = end_ts  # type: str
        self.item_configs = item_configs  # type: str
        self.metric_types_shrink = metric_types_shrink  # type: str
        self.network = network  # type: str
        self.order_name = order_name  # type: str
        self.order_type = order_type  # type: str
        self.os = os  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.terminal_type = terminal_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayQosListShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.item_configs is not None:
            result['ItemConfigs'] = self.item_configs
        if self.metric_types_shrink is not None:
            result['MetricTypes'] = self.metric_types_shrink
        if self.network is not None:
            result['Network'] = self.network
        if self.order_name is not None:
            result['OrderName'] = self.order_name
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.os is not None:
            result['Os'] = self.os
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('ItemConfigs') is not None:
            self.item_configs = m.get('ItemConfigs')
        if m.get('MetricTypes') is not None:
            self.metric_types_shrink = m.get('MetricTypes')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('OrderName') is not None:
            self.order_name = m.get('OrderName')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribePlayQosListResponseBodyQosInfoList(TeaModel):
    def __init__(self, qos_first_frame=None, qos_kbps=None, qos_play=None, qos_play_fail=None, qos_real_play=None,
                 qos_seed_fail_rate=None, qos_stuck_rate=None, trace_id=None):
        self.qos_first_frame = qos_first_frame  # type: str
        self.qos_kbps = qos_kbps  # type: str
        self.qos_play = qos_play  # type: str
        self.qos_play_fail = qos_play_fail  # type: str
        self.qos_real_play = qos_real_play  # type: str
        self.qos_seed_fail_rate = qos_seed_fail_rate  # type: str
        self.qos_stuck_rate = qos_stuck_rate  # type: str
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePlayQosListResponseBodyQosInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qos_first_frame is not None:
            result['QosFirstFrame'] = self.qos_first_frame
        if self.qos_kbps is not None:
            result['QosKbps'] = self.qos_kbps
        if self.qos_play is not None:
            result['QosPlay'] = self.qos_play
        if self.qos_play_fail is not None:
            result['QosPlayFail'] = self.qos_play_fail
        if self.qos_real_play is not None:
            result['QosRealPlay'] = self.qos_real_play
        if self.qos_seed_fail_rate is not None:
            result['QosSeedFailRate'] = self.qos_seed_fail_rate
        if self.qos_stuck_rate is not None:
            result['QosStuckRate'] = self.qos_stuck_rate
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QosFirstFrame') is not None:
            self.qos_first_frame = m.get('QosFirstFrame')
        if m.get('QosKbps') is not None:
            self.qos_kbps = m.get('QosKbps')
        if m.get('QosPlay') is not None:
            self.qos_play = m.get('QosPlay')
        if m.get('QosPlayFail') is not None:
            self.qos_play_fail = m.get('QosPlayFail')
        if m.get('QosRealPlay') is not None:
            self.qos_real_play = m.get('QosRealPlay')
        if m.get('QosSeedFailRate') is not None:
            self.qos_seed_fail_rate = m.get('QosSeedFailRate')
        if m.get('QosStuckRate') is not None:
            self.qos_stuck_rate = m.get('QosStuckRate')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribePlayQosListResponseBody(TeaModel):
    def __init__(self, page_no=None, page_size=None, qos_info_list=None, request_id=None, total_count=None):
        self.page_no = page_no  # type: long
        self.page_size = page_size  # type: long
        self.qos_info_list = qos_info_list  # type: list[DescribePlayQosListResponseBodyQosInfoList]
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: long

    def validate(self):
        if self.qos_info_list:
            for k in self.qos_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePlayQosListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['QosInfoList'] = []
        if self.qos_info_list is not None:
            for k in self.qos_info_list:
                result['QosInfoList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.qos_info_list = []
        if m.get('QosInfoList') is not None:
            for k in m.get('QosInfoList'):
                temp_model = DescribePlayQosListResponseBodyQosInfoList()
                self.qos_info_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePlayQosListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePlayQosListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePlayQosListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayQosListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeQueryConfigsRequest(TeaModel):
    def __init__(self, type=None):
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeQueryConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeQueryConfigsResponseBodyConfigs(TeaModel):
    def __init__(self, value=None):
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeQueryConfigsResponseBodyConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeQueryConfigsResponseBody(TeaModel):
    def __init__(self, configs=None, request_id=None):
        self.configs = configs  # type: list[DescribeQueryConfigsResponseBodyConfigs]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeQueryConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = DescribeQueryConfigsResponseBodyConfigs()
                self.configs.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeQueryConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeQueryConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeQueryConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeQueryConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCategoriesRequest(TeaModel):
    def __init__(self, cate_id=None, page_no=None, page_size=None, sort_by=None, type=None):
        self.cate_id = cate_id  # type: long
        self.page_no = page_no  # type: long
        self.page_size = page_size  # type: long
        self.sort_by = sort_by  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCategoriesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCategoriesResponseBodyCategory(TeaModel):
    def __init__(self, cate_id=None, cate_name=None, level=None, parent_id=None, type=None):
        self.cate_id = cate_id  # type: long
        self.cate_name = cate_name  # type: str
        self.level = level  # type: long
        self.parent_id = parent_id  # type: long
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCategoriesResponseBodyCategory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCategoriesResponseBodySubCategoriesCategory(TeaModel):
    def __init__(self, cate_id=None, cate_name=None, level=None, parent_id=None, sub_total=None, type=None):
        self.cate_id = cate_id  # type: long
        self.cate_name = cate_name  # type: str
        self.level = level  # type: long
        self.parent_id = parent_id  # type: long
        self.sub_total = sub_total  # type: long
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCategoriesResponseBodySubCategoriesCategory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.sub_total is not None:
            result['SubTotal'] = self.sub_total
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('SubTotal') is not None:
            self.sub_total = m.get('SubTotal')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCategoriesResponseBodySubCategories(TeaModel):
    def __init__(self, category=None):
        self.category = category  # type: list[GetCategoriesResponseBodySubCategoriesCategory]

    def validate(self):
        if self.category:
            for k in self.category:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetCategoriesResponseBodySubCategories, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Category'] = []
        if self.category is not None:
            for k in self.category:
                result['Category'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.category = []
        if m.get('Category') is not None:
            for k in m.get('Category'):
                temp_model = GetCategoriesResponseBodySubCategoriesCategory()
                self.category.append(temp_model.from_map(k))
        return self


class GetCategoriesResponseBody(TeaModel):
    def __init__(self, category=None, request_id=None, sub_categories=None, sub_total=None):
        self.category = category  # type: GetCategoriesResponseBodyCategory
        self.request_id = request_id  # type: str
        self.sub_categories = sub_categories  # type: GetCategoriesResponseBodySubCategories
        self.sub_total = sub_total  # type: long

    def validate(self):
        if self.category:
            self.category.validate()
        if self.sub_categories:
            self.sub_categories.validate()

    def to_map(self):
        _map = super(GetCategoriesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sub_categories is not None:
            result['SubCategories'] = self.sub_categories.to_map()
        if self.sub_total is not None:
            result['SubTotal'] = self.sub_total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            temp_model = GetCategoriesResponseBodyCategory()
            self.category = temp_model.from_map(m['Category'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SubCategories') is not None:
            temp_model = GetCategoriesResponseBodySubCategories()
            self.sub_categories = temp_model.from_map(m['SubCategories'])
        if m.get('SubTotal') is not None:
            self.sub_total = m.get('SubTotal')
        return self


class GetCategoriesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetCategoriesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetCategoriesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCategoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCustomTemplateRequest(TeaModel):
    def __init__(self, subtype=None, template_id=None, type=None):
        self.subtype = subtype  # type: int
        self.template_id = template_id  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCustomTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCustomTemplateResponseBodyCustomTemplate(TeaModel):
    def __init__(self, create_time=None, is_default=None, modified_time=None, status=None, subtype=None,
                 subtype_name=None, template_config=None, template_id=None, template_name=None, type=None, type_name=None):
        self.create_time = create_time  # type: str
        self.is_default = is_default  # type: bool
        self.modified_time = modified_time  # type: str
        self.status = status  # type: str
        self.subtype = subtype  # type: int
        self.subtype_name = subtype_name  # type: str
        self.template_config = template_config  # type: str
        self.template_id = template_id  # type: str
        self.template_name = template_name  # type: str
        self.type = type  # type: int
        self.type_name = type_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCustomTemplateResponseBodyCustomTemplate, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.status is not None:
            result['Status'] = self.status
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.subtype_name is not None:
            result['SubtypeName'] = self.subtype_name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.type is not None:
            result['Type'] = self.type
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('SubtypeName') is not None:
            self.subtype_name = m.get('SubtypeName')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        return self


class GetCustomTemplateResponseBody(TeaModel):
    def __init__(self, custom_template=None, request_id=None):
        self.custom_template = custom_template  # type: GetCustomTemplateResponseBodyCustomTemplate
        self.request_id = request_id  # type: str

    def validate(self):
        if self.custom_template:
            self.custom_template.validate()

    def to_map(self):
        _map = super(GetCustomTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_template is not None:
            result['CustomTemplate'] = self.custom_template.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomTemplate') is not None:
            temp_model = GetCustomTemplateResponseBodyCustomTemplate()
            self.custom_template = temp_model.from_map(m['CustomTemplate'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetCustomTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetCustomTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetCustomTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCustomTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDefaultStorageLocationResponseBody(TeaModel):
    def __init__(self, bucket=None, path=None, request_id=None, status=None, storage_type=None):
        self.bucket = bucket  # type: str
        self.path = path  # type: str
        self.request_id = request_id  # type: str
        self.status = status  # type: str
        self.storage_type = storage_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDefaultStorageLocationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.path is not None:
            result['Path'] = self.path
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class GetDefaultStorageLocationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDefaultStorageLocationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDefaultStorageLocationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDefaultStorageLocationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDynamicImageJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDynamicImageJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetDynamicImageJobResponseBodyDynamicImageJobInputOssFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        self.bucket = bucket  # type: str
        self.location = location  # type: str
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDynamicImageJobResponseBodyDynamicImageJobInputOssFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class GetDynamicImageJobResponseBodyDynamicImageJobInput(TeaModel):
    def __init__(self, media=None, oss_file=None, type=None):
        self.media = media  # type: str
        self.oss_file = oss_file  # type: GetDynamicImageJobResponseBodyDynamicImageJobInputOssFile
        self.type = type  # type: str

    def validate(self):
        if self.oss_file:
            self.oss_file.validate()

    def to_map(self):
        _map = super(GetDynamicImageJobResponseBodyDynamicImageJobInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.oss_file is not None:
            result['OssFile'] = self.oss_file.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('OssFile') is not None:
            temp_model = GetDynamicImageJobResponseBodyDynamicImageJobInputOssFile()
            self.oss_file = temp_model.from_map(m['OssFile'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDynamicImageJobResponseBodyDynamicImageJobOutputOssFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        self.bucket = bucket  # type: str
        self.location = location  # type: str
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDynamicImageJobResponseBodyDynamicImageJobOutputOssFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class GetDynamicImageJobResponseBodyDynamicImageJobOutput(TeaModel):
    def __init__(self, media=None, oss_file=None, type=None):
        self.media = media  # type: str
        self.oss_file = oss_file  # type: GetDynamicImageJobResponseBodyDynamicImageJobOutputOssFile
        self.type = type  # type: str

    def validate(self):
        if self.oss_file:
            self.oss_file.validate()

    def to_map(self):
        _map = super(GetDynamicImageJobResponseBodyDynamicImageJobOutput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.oss_file is not None:
            result['OssFile'] = self.oss_file.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('OssFile') is not None:
            temp_model = GetDynamicImageJobResponseBodyDynamicImageJobOutputOssFile()
            self.oss_file = temp_model.from_map(m['OssFile'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDynamicImageJobResponseBodyDynamicImageJob(TeaModel):
    def __init__(self, code=None, create_time=None, finish_time=None, input=None, job_id=None, message=None,
                 modified_time=None, name=None, output=None, output_url=None, pipeline_id=None, status=None, submit_time=None,
                 template_config=None, template_id=None, trigger_source=None, user_data=None):
        self.code = code  # type: str
        self.create_time = create_time  # type: str
        self.finish_time = finish_time  # type: str
        self.input = input  # type: GetDynamicImageJobResponseBodyDynamicImageJobInput
        self.job_id = job_id  # type: str
        self.message = message  # type: str
        self.modified_time = modified_time  # type: str
        self.name = name  # type: str
        self.output = output  # type: GetDynamicImageJobResponseBodyDynamicImageJobOutput
        self.output_url = output_url  # type: str
        self.pipeline_id = pipeline_id  # type: str
        self.status = status  # type: str
        self.submit_time = submit_time  # type: str
        self.template_config = template_config  # type: str
        self.template_id = template_id  # type: str
        self.trigger_source = trigger_source  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        if self.input:
            self.input.validate()
        if self.output:
            self.output.validate()

    def to_map(self):
        _map = super(GetDynamicImageJobResponseBodyDynamicImageJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.output_url is not None:
            result['OutputUrl'] = self.output_url
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = GetDynamicImageJobResponseBodyDynamicImageJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Output') is not None:
            temp_model = GetDynamicImageJobResponseBodyDynamicImageJobOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('OutputUrl') is not None:
            self.output_url = m.get('OutputUrl')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetDynamicImageJobResponseBody(TeaModel):
    def __init__(self, dynamic_image_job=None, request_id=None):
        self.dynamic_image_job = dynamic_image_job  # type: GetDynamicImageJobResponseBodyDynamicImageJob
        self.request_id = request_id  # type: str

    def validate(self):
        if self.dynamic_image_job:
            self.dynamic_image_job.validate()

    def to_map(self):
        _map = super(GetDynamicImageJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_image_job is not None:
            result['DynamicImageJob'] = self.dynamic_image_job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DynamicImageJob') is not None:
            temp_model = GetDynamicImageJobResponseBodyDynamicImageJob()
            self.dynamic_image_job = temp_model.from_map(m['DynamicImageJob'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDynamicImageJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDynamicImageJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDynamicImageJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDynamicImageJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEditingProjectRequest(TeaModel):
    def __init__(self, project_id=None):
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEditingProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetEditingProjectResponseBodyProject(TeaModel):
    def __init__(self, business_config=None, business_status=None, clips_param=None, cover_url=None,
                 create_source=None, create_time=None, description=None, duration=None, modified_source=None, modified_time=None,
                 project_id=None, project_type=None, status=None, template_id=None, template_type=None, timeline=None,
                 title=None):
        self.business_config = business_config  # type: str
        self.business_status = business_status  # type: str
        self.clips_param = clips_param  # type: str
        self.cover_url = cover_url  # type: str
        self.create_source = create_source  # type: str
        self.create_time = create_time  # type: str
        self.description = description  # type: str
        self.duration = duration  # type: long
        self.modified_source = modified_source  # type: str
        self.modified_time = modified_time  # type: str
        self.project_id = project_id  # type: str
        self.project_type = project_type  # type: str
        self.status = status  # type: str
        self.template_id = template_id  # type: str
        self.template_type = template_type  # type: str
        self.timeline = timeline  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEditingProjectResponseBodyProject, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_config is not None:
            result['BusinessConfig'] = self.business_config
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.clips_param is not None:
            result['ClipsParam'] = self.clips_param
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.modified_source is not None:
            result['ModifiedSource'] = self.modified_source
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_type is not None:
            result['ProjectType'] = self.project_type
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.timeline is not None:
            result['Timeline'] = self.timeline
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessConfig') is not None:
            self.business_config = m.get('BusinessConfig')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('ClipsParam') is not None:
            self.clips_param = m.get('ClipsParam')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ModifiedSource') is not None:
            self.modified_source = m.get('ModifiedSource')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectType') is not None:
            self.project_type = m.get('ProjectType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('Timeline') is not None:
            self.timeline = m.get('Timeline')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetEditingProjectResponseBody(TeaModel):
    def __init__(self, project=None, request_id=None):
        self.project = project  # type: GetEditingProjectResponseBodyProject
        self.request_id = request_id  # type: str

    def validate(self):
        if self.project:
            self.project.validate()

    def to_map(self):
        _map = super(GetEditingProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project is not None:
            result['Project'] = self.project.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Project') is not None:
            temp_model = GetEditingProjectResponseBodyProject()
            self.project = temp_model.from_map(m['Project'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEditingProjectResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetEditingProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetEditingProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEditingProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEditingProjectMaterialsRequest(TeaModel):
    def __init__(self, project_id=None):
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEditingProjectMaterialsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetEditingProjectMaterialsResponseBodyLiveMaterials(TeaModel):
    def __init__(self, app_name=None, domain_name=None, live_url=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.live_url = live_url  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEditingProjectMaterialsResponseBodyLiveMaterials, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.live_url is not None:
            result['LiveUrl'] = self.live_url
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LiveUrl') is not None:
            self.live_url = m.get('LiveUrl')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo(TeaModel):
    def __init__(self, bitrate=None, duration=None, file_name=None, file_size=None, file_status=None, file_type=None,
                 file_url=None, format_name=None, height=None, region=None, width=None):
        self.bitrate = bitrate  # type: str
        self.duration = duration  # type: str
        self.file_name = file_name  # type: str
        self.file_size = file_size  # type: str
        self.file_status = file_status  # type: str
        self.file_type = file_type  # type: str
        self.file_url = file_url  # type: str
        self.format_name = format_name  # type: str
        self.height = height  # type: str
        self.region = region  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoList(TeaModel):
    def __init__(self, file_basic_info=None):
        self.file_basic_info = file_basic_info  # type: GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo

    def validate(self):
        if self.file_basic_info:
            self.file_basic_info.validate()

    def to_map(self):
        _map = super(GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileBasicInfo') is not None:
            temp_model = GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        return self


class GetEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo(TeaModel):
    def __init__(self, business_type=None, category=None, cover_url=None, create_time=None, deleted_time=None,
                 description=None, input_url=None, media_id=None, media_tags=None, media_type=None, modified_time=None,
                 snapshots=None, source=None, sprite_images=None, status=None, title=None, transcode_status=None,
                 user_data=None):
        self.business_type = business_type  # type: str
        self.category = category  # type: str
        self.cover_url = cover_url  # type: str
        self.create_time = create_time  # type: str
        self.deleted_time = deleted_time  # type: str
        self.description = description  # type: str
        self.input_url = input_url  # type: str
        self.media_id = media_id  # type: str
        self.media_tags = media_tags  # type: str
        self.media_type = media_type  # type: str
        self.modified_time = modified_time  # type: str
        self.snapshots = snapshots  # type: str
        self.source = source  # type: str
        self.sprite_images = sprite_images  # type: str
        self.status = status  # type: str
        self.title = title  # type: str
        self.transcode_status = transcode_status  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_images is not None:
            result['SpriteImages'] = self.sprite_images
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.transcode_status is not None:
            result['TranscodeStatus'] = self.transcode_status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Snapshots') is not None:
            self.snapshots = m.get('Snapshots')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteImages') is not None:
            self.sprite_images = m.get('SpriteImages')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('TranscodeStatus') is not None:
            self.transcode_status = m.get('TranscodeStatus')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetEditingProjectMaterialsResponseBodyMediaInfos(TeaModel):
    def __init__(self, file_info_list=None, media_basic_info=None, media_id=None):
        self.file_info_list = file_info_list  # type: list[GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoList]
        self.media_basic_info = media_basic_info  # type: GetEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo
        self.media_id = media_id  # type: str

    def validate(self):
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super(GetEditingProjectMaterialsResponseBodyMediaInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = GetEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class GetEditingProjectMaterialsResponseBody(TeaModel):
    def __init__(self, live_materials=None, media_infos=None, project_id=None, project_materials=None,
                 request_id=None):
        self.live_materials = live_materials  # type: list[GetEditingProjectMaterialsResponseBodyLiveMaterials]
        self.media_infos = media_infos  # type: list[GetEditingProjectMaterialsResponseBodyMediaInfos]
        self.project_id = project_id  # type: str
        self.project_materials = project_materials  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.live_materials:
            for k in self.live_materials:
                if k:
                    k.validate()
        if self.media_infos:
            for k in self.media_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetEditingProjectMaterialsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveMaterials'] = []
        if self.live_materials is not None:
            for k in self.live_materials:
                result['LiveMaterials'].append(k.to_map() if k else None)
        result['MediaInfos'] = []
        if self.media_infos is not None:
            for k in self.media_infos:
                result['MediaInfos'].append(k.to_map() if k else None)
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_materials is not None:
            result['ProjectMaterials'] = self.project_materials
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_materials = []
        if m.get('LiveMaterials') is not None:
            for k in m.get('LiveMaterials'):
                temp_model = GetEditingProjectMaterialsResponseBodyLiveMaterials()
                self.live_materials.append(temp_model.from_map(k))
        self.media_infos = []
        if m.get('MediaInfos') is not None:
            for k in m.get('MediaInfos'):
                temp_model = GetEditingProjectMaterialsResponseBodyMediaInfos()
                self.media_infos.append(temp_model.from_map(k))
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectMaterials') is not None:
            self.project_materials = m.get('ProjectMaterials')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEditingProjectMaterialsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetEditingProjectMaterialsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetEditingProjectMaterialsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEditingProjectMaterialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEventCallbackResponseBody(TeaModel):
    def __init__(self, auth_key=None, auth_switch=None, callback_queue_name=None, callback_type=None,
                 callback_url=None, event_type_list=None, request_id=None):
        self.auth_key = auth_key  # type: str
        self.auth_switch = auth_switch  # type: str
        self.callback_queue_name = callback_queue_name  # type: str
        self.callback_type = callback_type  # type: str
        self.callback_url = callback_url  # type: str
        self.event_type_list = event_type_list  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEventCallbackResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_key is not None:
            result['AuthKey'] = self.auth_key
        if self.auth_switch is not None:
            result['AuthSwitch'] = self.auth_switch
        if self.callback_queue_name is not None:
            result['CallbackQueueName'] = self.callback_queue_name
        if self.callback_type is not None:
            result['CallbackType'] = self.callback_type
        if self.callback_url is not None:
            result['CallbackURL'] = self.callback_url
        if self.event_type_list is not None:
            result['EventTypeList'] = self.event_type_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AuthKey') is not None:
            self.auth_key = m.get('AuthKey')
        if m.get('AuthSwitch') is not None:
            self.auth_switch = m.get('AuthSwitch')
        if m.get('CallbackQueueName') is not None:
            self.callback_queue_name = m.get('CallbackQueueName')
        if m.get('CallbackType') is not None:
            self.callback_type = m.get('CallbackType')
        if m.get('CallbackURL') is not None:
            self.callback_url = m.get('CallbackURL')
        if m.get('EventTypeList') is not None:
            self.event_type_list = m.get('EventTypeList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEventCallbackResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetEventCallbackResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetEventCallbackResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEventCallbackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLiveEditingIndexFileRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, project_id=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.project_id = project_id  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveEditingIndexFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class GetLiveEditingIndexFileResponseBody(TeaModel):
    def __init__(self, index_file=None, request_id=None):
        self.index_file = index_file  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveEditingIndexFileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index_file is not None:
            result['IndexFile'] = self.index_file
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IndexFile') is not None:
            self.index_file = m.get('IndexFile')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetLiveEditingIndexFileResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetLiveEditingIndexFileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetLiveEditingIndexFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetLiveEditingIndexFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLiveEditingJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveEditingJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetLiveEditingJobResponseBodyLiveEditingJobLiveStreamConfig(TeaModel):
    def __init__(self, app_name=None, domain_name=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveEditingJobResponseBodyLiveEditingJobLiveStreamConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class GetLiveEditingJobResponseBodyLiveEditingJobMediaProduceConfig(TeaModel):
    def __init__(self, mode=None):
        self.mode = mode  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveEditingJobResponseBodyLiveEditingJobMediaProduceConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mode is not None:
            result['Mode'] = self.mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        return self


class GetLiveEditingJobResponseBodyLiveEditingJobOutputMediaConfig(TeaModel):
    def __init__(self, bitrate=None, file_name=None, height=None, media_url=None, storage_location=None,
                 vod_template_group_id=None, width=None):
        self.bitrate = bitrate  # type: long
        self.file_name = file_name  # type: str
        self.height = height  # type: int
        self.media_url = media_url  # type: str
        self.storage_location = storage_location  # type: str
        self.vod_template_group_id = vod_template_group_id  # type: str
        self.width = width  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveEditingJobResponseBodyLiveEditingJobOutputMediaConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.height is not None:
            result['Height'] = self.height
        if self.media_url is not None:
            result['MediaURL'] = self.media_url
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.vod_template_group_id is not None:
            result['VodTemplateGroupId'] = self.vod_template_group_id
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaURL') is not None:
            self.media_url = m.get('MediaURL')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('VodTemplateGroupId') is not None:
            self.vod_template_group_id = m.get('VodTemplateGroupId')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetLiveEditingJobResponseBodyLiveEditingJob(TeaModel):
    def __init__(self, clips=None, code=None, complete_time=None, creation_time=None, job_id=None,
                 live_stream_config=None, media_id=None, media_produce_config=None, media_url=None, message=None, modified_time=None,
                 output_media_config=None, project_id=None, status=None, user_data=None):
        self.clips = clips  # type: str
        self.code = code  # type: str
        self.complete_time = complete_time  # type: str
        self.creation_time = creation_time  # type: str
        self.job_id = job_id  # type: str
        self.live_stream_config = live_stream_config  # type: GetLiveEditingJobResponseBodyLiveEditingJobLiveStreamConfig
        self.media_id = media_id  # type: str
        self.media_produce_config = media_produce_config  # type: GetLiveEditingJobResponseBodyLiveEditingJobMediaProduceConfig
        self.media_url = media_url  # type: str
        self.message = message  # type: str
        self.modified_time = modified_time  # type: str
        self.output_media_config = output_media_config  # type: GetLiveEditingJobResponseBodyLiveEditingJobOutputMediaConfig
        self.project_id = project_id  # type: str
        self.status = status  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        if self.live_stream_config:
            self.live_stream_config.validate()
        if self.media_produce_config:
            self.media_produce_config.validate()
        if self.output_media_config:
            self.output_media_config.validate()

    def to_map(self):
        _map = super(GetLiveEditingJobResponseBodyLiveEditingJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips is not None:
            result['Clips'] = self.clips
        if self.code is not None:
            result['Code'] = self.code
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.live_stream_config is not None:
            result['LiveStreamConfig'] = self.live_stream_config.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_produce_config is not None:
            result['MediaProduceConfig'] = self.media_produce_config.to_map()
        if self.media_url is not None:
            result['MediaURL'] = self.media_url
        if self.message is not None:
            result['Message'] = self.message
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.output_media_config is not None:
            result['OutputMediaConfig'] = self.output_media_config.to_map()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Clips') is not None:
            self.clips = m.get('Clips')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('LiveStreamConfig') is not None:
            temp_model = GetLiveEditingJobResponseBodyLiveEditingJobLiveStreamConfig()
            self.live_stream_config = temp_model.from_map(m['LiveStreamConfig'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaProduceConfig') is not None:
            temp_model = GetLiveEditingJobResponseBodyLiveEditingJobMediaProduceConfig()
            self.media_produce_config = temp_model.from_map(m['MediaProduceConfig'])
        if m.get('MediaURL') is not None:
            self.media_url = m.get('MediaURL')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OutputMediaConfig') is not None:
            temp_model = GetLiveEditingJobResponseBodyLiveEditingJobOutputMediaConfig()
            self.output_media_config = temp_model.from_map(m['OutputMediaConfig'])
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetLiveEditingJobResponseBody(TeaModel):
    def __init__(self, live_editing_job=None, request_id=None):
        self.live_editing_job = live_editing_job  # type: GetLiveEditingJobResponseBodyLiveEditingJob
        self.request_id = request_id  # type: str

    def validate(self):
        if self.live_editing_job:
            self.live_editing_job.validate()

    def to_map(self):
        _map = super(GetLiveEditingJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_editing_job is not None:
            result['LiveEditingJob'] = self.live_editing_job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveEditingJob') is not None:
            temp_model = GetLiveEditingJobResponseBodyLiveEditingJob()
            self.live_editing_job = temp_model.from_map(m['LiveEditingJob'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetLiveEditingJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetLiveEditingJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetLiveEditingJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetLiveEditingJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLiveRecordJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveRecordJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetLiveRecordJobResponseBodyRecordJobRecordOutput(TeaModel):
    def __init__(self, bucket=None, endpoint=None, type=None):
        self.bucket = bucket  # type: str
        self.endpoint = endpoint  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveRecordJobResponseBodyRecordJobRecordOutput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetLiveRecordJobResponseBodyRecordJobStreamInput(TeaModel):
    def __init__(self, type=None, url=None):
        self.type = type  # type: str
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveRecordJobResponseBodyRecordJobStreamInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetLiveRecordJobResponseBodyRecordJob(TeaModel):
    def __init__(self, create_time=None, job_id=None, name=None, notify_url=None, record_output=None, status=None,
                 stream_input=None, template_id=None, template_name=None):
        self.create_time = create_time  # type: str
        self.job_id = job_id  # type: str
        self.name = name  # type: str
        self.notify_url = notify_url  # type: str
        self.record_output = record_output  # type: GetLiveRecordJobResponseBodyRecordJobRecordOutput
        self.status = status  # type: str
        self.stream_input = stream_input  # type: GetLiveRecordJobResponseBodyRecordJobStreamInput
        self.template_id = template_id  # type: str
        self.template_name = template_name  # type: str

    def validate(self):
        if self.record_output:
            self.record_output.validate()
        if self.stream_input:
            self.stream_input.validate()

    def to_map(self):
        _map = super(GetLiveRecordJobResponseBodyRecordJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        if self.record_output is not None:
            result['RecordOutput'] = self.record_output.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.stream_input is not None:
            result['StreamInput'] = self.stream_input.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        if m.get('RecordOutput') is not None:
            temp_model = GetLiveRecordJobResponseBodyRecordJobRecordOutput()
            self.record_output = temp_model.from_map(m['RecordOutput'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StreamInput') is not None:
            temp_model = GetLiveRecordJobResponseBodyRecordJobStreamInput()
            self.stream_input = temp_model.from_map(m['StreamInput'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        return self


class GetLiveRecordJobResponseBody(TeaModel):
    def __init__(self, record_job=None, request_id=None):
        self.record_job = record_job  # type: GetLiveRecordJobResponseBodyRecordJob
        self.request_id = request_id  # type: str

    def validate(self):
        if self.record_job:
            self.record_job.validate()

    def to_map(self):
        _map = super(GetLiveRecordJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_job is not None:
            result['RecordJob'] = self.record_job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RecordJob') is not None:
            temp_model = GetLiveRecordJobResponseBodyRecordJob()
            self.record_job = temp_model.from_map(m['RecordJob'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetLiveRecordJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetLiveRecordJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetLiveRecordJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetLiveRecordJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLiveRecordTemplateRequest(TeaModel):
    def __init__(self, job_id=None, template_id=None):
        self.job_id = job_id  # type: str
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveRecordTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetLiveRecordTemplateResponseBodyRecordTemplateRecordFormatList(TeaModel):
    def __init__(self, cycle_duration=None, format=None, oss_object_prefix=None, slice_duration=None,
                 slice_oss_object_prefix=None):
        self.cycle_duration = cycle_duration  # type: int
        self.format = format  # type: str
        self.oss_object_prefix = oss_object_prefix  # type: str
        self.slice_duration = slice_duration  # type: int
        self.slice_oss_object_prefix = slice_oss_object_prefix  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveRecordTemplateResponseBodyRecordTemplateRecordFormatList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.format is not None:
            result['Format'] = self.format
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.slice_duration is not None:
            result['SliceDuration'] = self.slice_duration
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('SliceDuration') is not None:
            self.slice_duration = m.get('SliceDuration')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        return self


class GetLiveRecordTemplateResponseBodyRecordTemplate(TeaModel):
    def __init__(self, create_time=None, last_modified=None, name=None, record_format_list=None, template_id=None,
                 type=None):
        self.create_time = create_time  # type: str
        self.last_modified = last_modified  # type: str
        self.name = name  # type: str
        self.record_format_list = record_format_list  # type: list[GetLiveRecordTemplateResponseBodyRecordTemplateRecordFormatList]
        self.template_id = template_id  # type: str
        self.type = type  # type: str

    def validate(self):
        if self.record_format_list:
            for k in self.record_format_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetLiveRecordTemplateResponseBodyRecordTemplate, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_modified is not None:
            result['LastModified'] = self.last_modified
        if self.name is not None:
            result['Name'] = self.name
        result['RecordFormatList'] = []
        if self.record_format_list is not None:
            for k in self.record_format_list:
                result['RecordFormatList'].append(k.to_map() if k else None)
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastModified') is not None:
            self.last_modified = m.get('LastModified')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.record_format_list = []
        if m.get('RecordFormatList') is not None:
            for k in m.get('RecordFormatList'):
                temp_model = GetLiveRecordTemplateResponseBodyRecordTemplateRecordFormatList()
                self.record_format_list.append(temp_model.from_map(k))
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetLiveRecordTemplateResponseBody(TeaModel):
    def __init__(self, record_template=None, request_id=None):
        self.record_template = record_template  # type: GetLiveRecordTemplateResponseBodyRecordTemplate
        self.request_id = request_id  # type: str

    def validate(self):
        if self.record_template:
            self.record_template.validate()

    def to_map(self):
        _map = super(GetLiveRecordTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_template is not None:
            result['RecordTemplate'] = self.record_template.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RecordTemplate') is not None:
            temp_model = GetLiveRecordTemplateResponseBodyRecordTemplate()
            self.record_template = temp_model.from_map(m['RecordTemplate'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetLiveRecordTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetLiveRecordTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetLiveRecordTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetLiveRecordTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLiveSnapshotJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveSnapshotJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetLiveSnapshotJobResponseBodySnapshotOutput(TeaModel):
    def __init__(self, bucket=None, endpoint=None, storage_type=None):
        self.bucket = bucket  # type: str
        self.endpoint = endpoint  # type: str
        self.storage_type = storage_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveSnapshotJobResponseBodySnapshotOutput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class GetLiveSnapshotJobResponseBodyStreamInput(TeaModel):
    def __init__(self, type=None, url=None):
        self.type = type  # type: str
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveSnapshotJobResponseBodyStreamInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetLiveSnapshotJobResponseBody(TeaModel):
    def __init__(self, callback_url=None, create_time=None, job_id=None, job_name=None, last_modified=None,
                 overwrite_format=None, request_id=None, sequence_format=None, snapshot_output=None, status=None, stream_input=None,
                 template_id=None, template_name=None, time_interval=None):
        self.callback_url = callback_url  # type: str
        self.create_time = create_time  # type: str
        self.job_id = job_id  # type: str
        self.job_name = job_name  # type: str
        self.last_modified = last_modified  # type: str
        self.overwrite_format = overwrite_format  # type: str
        self.request_id = request_id  # type: str
        self.sequence_format = sequence_format  # type: str
        self.snapshot_output = snapshot_output  # type: GetLiveSnapshotJobResponseBodySnapshotOutput
        self.status = status  # type: str
        self.stream_input = stream_input  # type: GetLiveSnapshotJobResponseBodyStreamInput
        self.template_id = template_id  # type: str
        self.template_name = template_name  # type: str
        self.time_interval = time_interval  # type: int

    def validate(self):
        if self.snapshot_output:
            self.snapshot_output.validate()
        if self.stream_input:
            self.stream_input.validate()

    def to_map(self):
        _map = super(GetLiveSnapshotJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.last_modified is not None:
            result['LastModified'] = self.last_modified
        if self.overwrite_format is not None:
            result['OverwriteFormat'] = self.overwrite_format
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sequence_format is not None:
            result['SequenceFormat'] = self.sequence_format
        if self.snapshot_output is not None:
            result['SnapshotOutput'] = self.snapshot_output.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.stream_input is not None:
            result['StreamInput'] = self.stream_input.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.time_interval is not None:
            result['TimeInterval'] = self.time_interval
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('LastModified') is not None:
            self.last_modified = m.get('LastModified')
        if m.get('OverwriteFormat') is not None:
            self.overwrite_format = m.get('OverwriteFormat')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SequenceFormat') is not None:
            self.sequence_format = m.get('SequenceFormat')
        if m.get('SnapshotOutput') is not None:
            temp_model = GetLiveSnapshotJobResponseBodySnapshotOutput()
            self.snapshot_output = temp_model.from_map(m['SnapshotOutput'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StreamInput') is not None:
            temp_model = GetLiveSnapshotJobResponseBodyStreamInput()
            self.stream_input = temp_model.from_map(m['StreamInput'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TimeInterval') is not None:
            self.time_interval = m.get('TimeInterval')
        return self


class GetLiveSnapshotJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetLiveSnapshotJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetLiveSnapshotJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetLiveSnapshotJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLiveSnapshotTemplateRequest(TeaModel):
    def __init__(self, template_id=None):
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveSnapshotTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetLiveSnapshotTemplateResponseBody(TeaModel):
    def __init__(self, create_time=None, last_modified=None, overwrite_format=None, request_id=None,
                 sequence_format=None, template_id=None, template_name=None, time_interval=None, type=None):
        self.create_time = create_time  # type: str
        self.last_modified = last_modified  # type: str
        self.overwrite_format = overwrite_format  # type: str
        self.request_id = request_id  # type: str
        self.sequence_format = sequence_format  # type: str
        self.template_id = template_id  # type: str
        self.template_name = template_name  # type: str
        self.time_interval = time_interval  # type: int
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveSnapshotTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_modified is not None:
            result['LastModified'] = self.last_modified
        if self.overwrite_format is not None:
            result['OverwriteFormat'] = self.overwrite_format
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sequence_format is not None:
            result['SequenceFormat'] = self.sequence_format
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.time_interval is not None:
            result['TimeInterval'] = self.time_interval
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastModified') is not None:
            self.last_modified = m.get('LastModified')
        if m.get('OverwriteFormat') is not None:
            self.overwrite_format = m.get('OverwriteFormat')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SequenceFormat') is not None:
            self.sequence_format = m.get('SequenceFormat')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TimeInterval') is not None:
            self.time_interval = m.get('TimeInterval')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetLiveSnapshotTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetLiveSnapshotTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetLiveSnapshotTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetLiveSnapshotTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLiveTranscodeJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveTranscodeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetLiveTranscodeJobResponseBodyJobOutputStreamStreamInfos(TeaModel):
    def __init__(self, output_url=None, type=None):
        self.output_url = output_url  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveTranscodeJobResponseBodyJobOutputStreamStreamInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_url is not None:
            result['OutputUrl'] = self.output_url
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OutputUrl') is not None:
            self.output_url = m.get('OutputUrl')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetLiveTranscodeJobResponseBodyJobOutputStream(TeaModel):
    def __init__(self, stream_infos=None):
        self.stream_infos = stream_infos  # type: list[GetLiveTranscodeJobResponseBodyJobOutputStreamStreamInfos]

    def validate(self):
        if self.stream_infos:
            for k in self.stream_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetLiveTranscodeJobResponseBodyJobOutputStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['StreamInfos'] = []
        if self.stream_infos is not None:
            for k in self.stream_infos:
                result['StreamInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.stream_infos = []
        if m.get('StreamInfos') is not None:
            for k in m.get('StreamInfos'):
                temp_model = GetLiveTranscodeJobResponseBodyJobOutputStreamStreamInfos()
                self.stream_infos.append(temp_model.from_map(k))
        return self


class GetLiveTranscodeJobResponseBodyJobStreamInput(TeaModel):
    def __init__(self, input_url=None, type=None):
        self.input_url = input_url  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveTranscodeJobResponseBodyJobStreamInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_url is not None:
            result['InputUrl'] = self.input_url
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InputUrl') is not None:
            self.input_url = m.get('InputUrl')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetLiveTranscodeJobResponseBodyJob(TeaModel):
    def __init__(self, create_time=None, job_id=None, name=None, output_stream=None, start_mode=None, status=None,
                 stream_input=None, template_id=None, template_name=None, template_type=None):
        self.create_time = create_time  # type: str
        self.job_id = job_id  # type: str
        self.name = name  # type: str
        self.output_stream = output_stream  # type: GetLiveTranscodeJobResponseBodyJobOutputStream
        self.start_mode = start_mode  # type: int
        self.status = status  # type: int
        self.stream_input = stream_input  # type: GetLiveTranscodeJobResponseBodyJobStreamInput
        self.template_id = template_id  # type: str
        self.template_name = template_name  # type: str
        self.template_type = template_type  # type: str

    def validate(self):
        if self.output_stream:
            self.output_stream.validate()
        if self.stream_input:
            self.stream_input.validate()

    def to_map(self):
        _map = super(GetLiveTranscodeJobResponseBodyJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.name is not None:
            result['Name'] = self.name
        if self.output_stream is not None:
            result['OutputStream'] = self.output_stream.to_map()
        if self.start_mode is not None:
            result['StartMode'] = self.start_mode
        if self.status is not None:
            result['Status'] = self.status
        if self.stream_input is not None:
            result['StreamInput'] = self.stream_input.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OutputStream') is not None:
            temp_model = GetLiveTranscodeJobResponseBodyJobOutputStream()
            self.output_stream = temp_model.from_map(m['OutputStream'])
        if m.get('StartMode') is not None:
            self.start_mode = m.get('StartMode')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StreamInput') is not None:
            temp_model = GetLiveTranscodeJobResponseBodyJobStreamInput()
            self.stream_input = temp_model.from_map(m['StreamInput'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        return self


class GetLiveTranscodeJobResponseBody(TeaModel):
    def __init__(self, job=None, request_id=None):
        self.job = job  # type: GetLiveTranscodeJobResponseBodyJob
        self.request_id = request_id  # type: str

    def validate(self):
        if self.job:
            self.job.validate()

    def to_map(self):
        _map = super(GetLiveTranscodeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job is not None:
            result['Job'] = self.job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Job') is not None:
            temp_model = GetLiveTranscodeJobResponseBodyJob()
            self.job = temp_model.from_map(m['Job'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetLiveTranscodeJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetLiveTranscodeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetLiveTranscodeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetLiveTranscodeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLiveTranscodeTemplateRequest(TeaModel):
    def __init__(self, template_id=None):
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveTranscodeTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfigAudioParams(TeaModel):
    def __init__(self, bitrate=None, channels=None, codec=None, profile=None, samplerate=None):
        self.bitrate = bitrate  # type: str
        self.channels = channels  # type: str
        self.codec = codec  # type: str
        self.profile = profile  # type: str
        self.samplerate = samplerate  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfigAudioParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        return self


class GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfigVideoParams(TeaModel):
    def __init__(self, bitrate=None, codec=None, fps=None, gop=None, height=None, profile=None, width=None):
        self.bitrate = bitrate  # type: str
        self.codec = codec  # type: str
        self.fps = fps  # type: str
        self.gop = gop  # type: str
        self.height = height  # type: str
        self.profile = profile  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfigVideoParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfig(TeaModel):
    def __init__(self, audio_params=None, video_params=None):
        self.audio_params = audio_params  # type: GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfigAudioParams
        self.video_params = video_params  # type: GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfigVideoParams

    def validate(self):
        if self.audio_params:
            self.audio_params.validate()
        if self.video_params:
            self.video_params.validate()

    def to_map(self):
        _map = super(GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_params is not None:
            result['AudioParams'] = self.audio_params.to_map()
        if self.video_params is not None:
            result['VideoParams'] = self.video_params.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioParams') is not None:
            temp_model = GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfigAudioParams()
            self.audio_params = temp_model.from_map(m['AudioParams'])
        if m.get('VideoParams') is not None:
            temp_model = GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfigVideoParams()
            self.video_params = temp_model.from_map(m['VideoParams'])
        return self


class GetLiveTranscodeTemplateResponseBodyTemplateContent(TeaModel):
    def __init__(self, category=None, create_time=None, name=None, template_config=None, template_id=None, type=None):
        self.category = category  # type: str
        self.create_time = create_time  # type: str
        self.name = name  # type: str
        self.template_config = template_config  # type: GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfig
        self.template_id = template_id  # type: str
        self.type = type  # type: str

    def validate(self):
        if self.template_config:
            self.template_config.validate()

    def to_map(self):
        _map = super(GetLiveTranscodeTemplateResponseBodyTemplateContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.name is not None:
            result['Name'] = self.name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TemplateConfig') is not None:
            temp_model = GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfig()
            self.template_config = temp_model.from_map(m['TemplateConfig'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetLiveTranscodeTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template_content=None):
        self.request_id = request_id  # type: str
        self.template_content = template_content  # type: GetLiveTranscodeTemplateResponseBodyTemplateContent

    def validate(self):
        if self.template_content:
            self.template_content.validate()

    def to_map(self):
        _map = super(GetLiveTranscodeTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_content is not None:
            result['TemplateContent'] = self.template_content.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateContent') is not None:
            temp_model = GetLiveTranscodeTemplateResponseBodyTemplateContent()
            self.template_content = temp_model.from_map(m['TemplateContent'])
        return self


class GetLiveTranscodeTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetLiveTranscodeTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetLiveTranscodeTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetLiveTranscodeTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMediaInfoRequest(TeaModel):
    def __init__(self, input_url=None, media_id=None, output_type=None):
        self.input_url = input_url  # type: str
        self.media_id = media_id  # type: str
        self.output_type = output_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        return self


class GetMediaInfoResponseBodyMediaInfoFileInfoListAudioStreamInfoList(TeaModel):
    def __init__(self, bitrate=None, channel_layout=None, channels=None, codec_long_name=None, codec_name=None,
                 codec_tag=None, codec_tag_string=None, codec_time_base=None, duration=None, fps=None, index=None, lang=None,
                 num_frames=None, profile=None, sample_fmt=None, sample_rate=None, start_time=None, timebase=None):
        self.bitrate = bitrate  # type: str
        self.channel_layout = channel_layout  # type: str
        self.channels = channels  # type: str
        self.codec_long_name = codec_long_name  # type: str
        self.codec_name = codec_name  # type: str
        self.codec_tag = codec_tag  # type: str
        self.codec_tag_string = codec_tag_string  # type: str
        self.codec_time_base = codec_time_base  # type: str
        self.duration = duration  # type: str
        self.fps = fps  # type: str
        self.index = index  # type: str
        self.lang = lang  # type: str
        self.num_frames = num_frames  # type: str
        self.profile = profile  # type: str
        self.sample_fmt = sample_fmt  # type: str
        self.sample_rate = sample_rate  # type: str
        self.start_time = start_time  # type: str
        self.timebase = timebase  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaInfoResponseBodyMediaInfoFileInfoListAudioStreamInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.sample_rate is not None:
            result['SampleRate'] = self.sample_rate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('SampleRate') is not None:
            self.sample_rate = m.get('SampleRate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class GetMediaInfoResponseBodyMediaInfoFileInfoListFileBasicInfo(TeaModel):
    def __init__(self, bitrate=None, create_time=None, duration=None, file_name=None, file_size=None,
                 file_status=None, file_type=None, file_url=None, format_name=None, height=None, modified_time=None, region=None,
                 width=None):
        self.bitrate = bitrate  # type: str
        self.create_time = create_time  # type: str
        self.duration = duration  # type: str
        self.file_name = file_name  # type: str
        self.file_size = file_size  # type: str
        self.file_status = file_status  # type: str
        self.file_type = file_type  # type: str
        self.file_url = file_url  # type: str
        self.format_name = format_name  # type: str
        self.height = height  # type: str
        self.modified_time = modified_time  # type: str
        self.region = region  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaInfoResponseBodyMediaInfoFileInfoListFileBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetMediaInfoResponseBodyMediaInfoFileInfoListSubtitleStreamInfoList(TeaModel):
    def __init__(self, codec_long_name=None, codec_name=None, codec_tag=None, codec_tag_string=None,
                 codec_time_base=None, duration=None, index=None, lang=None, start_time=None, timebase=None):
        self.codec_long_name = codec_long_name  # type: str
        self.codec_name = codec_name  # type: str
        self.codec_tag = codec_tag  # type: str
        self.codec_tag_string = codec_tag_string  # type: str
        self.codec_time_base = codec_time_base  # type: str
        self.duration = duration  # type: str
        self.index = index  # type: str
        self.lang = lang  # type: str
        self.start_time = start_time  # type: str
        self.timebase = timebase  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaInfoResponseBodyMediaInfoFileInfoListSubtitleStreamInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class GetMediaInfoResponseBodyMediaInfoFileInfoListVideoStreamInfoList(TeaModel):
    def __init__(self, avg_fps=None, bitrate=None, codec_long_name=None, codec_name=None, codec_tag=None,
                 codec_tag_string=None, codec_time_base=None, dar=None, duration=None, fps=None, has_bframes=None, height=None,
                 index=None, lang=None, level=None, nb_frames=None, num_frames=None, pix_fmt=None, profile=None,
                 rotate=None, sar=None, start_time=None, timebase=None, width=None):
        self.avg_fps = avg_fps  # type: str
        self.bitrate = bitrate  # type: str
        self.codec_long_name = codec_long_name  # type: str
        self.codec_name = codec_name  # type: str
        self.codec_tag = codec_tag  # type: str
        self.codec_tag_string = codec_tag_string  # type: str
        self.codec_time_base = codec_time_base  # type: str
        self.dar = dar  # type: str
        self.duration = duration  # type: str
        self.fps = fps  # type: str
        self.has_bframes = has_bframes  # type: str
        self.height = height  # type: str
        self.index = index  # type: str
        self.lang = lang  # type: str
        self.level = level  # type: str
        self.nb_frames = nb_frames  # type: str
        self.num_frames = num_frames  # type: str
        self.pix_fmt = pix_fmt  # type: str
        self.profile = profile  # type: str
        self.rotate = rotate  # type: str
        self.sar = sar  # type: str
        self.start_time = start_time  # type: str
        self.timebase = timebase  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaInfoResponseBodyMediaInfoFileInfoListVideoStreamInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.nb_frames is not None:
            result['Nb_frames'] = self.nb_frames
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Nb_frames') is not None:
            self.nb_frames = m.get('Nb_frames')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetMediaInfoResponseBodyMediaInfoFileInfoList(TeaModel):
    def __init__(self, audio_stream_info_list=None, file_basic_info=None, subtitle_stream_info_list=None,
                 video_stream_info_list=None):
        self.audio_stream_info_list = audio_stream_info_list  # type: list[GetMediaInfoResponseBodyMediaInfoFileInfoListAudioStreamInfoList]
        self.file_basic_info = file_basic_info  # type: GetMediaInfoResponseBodyMediaInfoFileInfoListFileBasicInfo
        self.subtitle_stream_info_list = subtitle_stream_info_list  # type: list[GetMediaInfoResponseBodyMediaInfoFileInfoListSubtitleStreamInfoList]
        self.video_stream_info_list = video_stream_info_list  # type: list[GetMediaInfoResponseBodyMediaInfoFileInfoListVideoStreamInfoList]

    def validate(self):
        if self.audio_stream_info_list:
            for k in self.audio_stream_info_list:
                if k:
                    k.validate()
        if self.file_basic_info:
            self.file_basic_info.validate()
        if self.subtitle_stream_info_list:
            for k in self.subtitle_stream_info_list:
                if k:
                    k.validate()
        if self.video_stream_info_list:
            for k in self.video_stream_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMediaInfoResponseBodyMediaInfoFileInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStreamInfoList'] = []
        if self.audio_stream_info_list is not None:
            for k in self.audio_stream_info_list:
                result['AudioStreamInfoList'].append(k.to_map() if k else None)
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        result['SubtitleStreamInfoList'] = []
        if self.subtitle_stream_info_list is not None:
            for k in self.subtitle_stream_info_list:
                result['SubtitleStreamInfoList'].append(k.to_map() if k else None)
        result['VideoStreamInfoList'] = []
        if self.video_stream_info_list is not None:
            for k in self.video_stream_info_list:
                result['VideoStreamInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.audio_stream_info_list = []
        if m.get('AudioStreamInfoList') is not None:
            for k in m.get('AudioStreamInfoList'):
                temp_model = GetMediaInfoResponseBodyMediaInfoFileInfoListAudioStreamInfoList()
                self.audio_stream_info_list.append(temp_model.from_map(k))
        if m.get('FileBasicInfo') is not None:
            temp_model = GetMediaInfoResponseBodyMediaInfoFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        self.subtitle_stream_info_list = []
        if m.get('SubtitleStreamInfoList') is not None:
            for k in m.get('SubtitleStreamInfoList'):
                temp_model = GetMediaInfoResponseBodyMediaInfoFileInfoListSubtitleStreamInfoList()
                self.subtitle_stream_info_list.append(temp_model.from_map(k))
        self.video_stream_info_list = []
        if m.get('VideoStreamInfoList') is not None:
            for k in m.get('VideoStreamInfoList'):
                temp_model = GetMediaInfoResponseBodyMediaInfoFileInfoListVideoStreamInfoList()
                self.video_stream_info_list.append(temp_model.from_map(k))
        return self


class GetMediaInfoResponseBodyMediaInfoMediaBasicInfo(TeaModel):
    def __init__(self, biz=None, business_type=None, cate_id=None, cate_name=None, category=None, cover_url=None,
                 create_time=None, deleted_time=None, description=None, input_url=None, media_id=None, media_tags=None,
                 media_type=None, modified_time=None, source=None, sprite_images=None, status=None, title=None,
                 upload_source=None, user_data=None):
        self.biz = biz  # type: str
        self.business_type = business_type  # type: str
        self.cate_id = cate_id  # type: long
        self.cate_name = cate_name  # type: str
        self.category = category  # type: str
        self.cover_url = cover_url  # type: str
        self.create_time = create_time  # type: str
        self.deleted_time = deleted_time  # type: str
        self.description = description  # type: str
        self.input_url = input_url  # type: str
        self.media_id = media_id  # type: str
        self.media_tags = media_tags  # type: str
        self.media_type = media_type  # type: str
        self.modified_time = modified_time  # type: str
        self.source = source  # type: str
        self.sprite_images = sprite_images  # type: str
        self.status = status  # type: str
        self.title = title  # type: str
        self.upload_source = upload_source  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaInfoResponseBodyMediaInfoMediaBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz is not None:
            result['Biz'] = self.biz
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_images is not None:
            result['SpriteImages'] = self.sprite_images
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.upload_source is not None:
            result['UploadSource'] = self.upload_source
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Biz') is not None:
            self.biz = m.get('Biz')
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteImages') is not None:
            self.sprite_images = m.get('SpriteImages')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UploadSource') is not None:
            self.upload_source = m.get('UploadSource')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetMediaInfoResponseBodyMediaInfo(TeaModel):
    def __init__(self, file_info_list=None, media_basic_info=None, media_id=None):
        self.file_info_list = file_info_list  # type: list[GetMediaInfoResponseBodyMediaInfoFileInfoList]
        self.media_basic_info = media_basic_info  # type: GetMediaInfoResponseBodyMediaInfoMediaBasicInfo
        self.media_id = media_id  # type: str

    def validate(self):
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super(GetMediaInfoResponseBodyMediaInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = GetMediaInfoResponseBodyMediaInfoFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = GetMediaInfoResponseBodyMediaInfoMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class GetMediaInfoResponseBody(TeaModel):
    def __init__(self, media_info=None, request_id=None):
        self.media_info = media_info  # type: GetMediaInfoResponseBodyMediaInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_info:
            self.media_info.validate()

    def to_map(self):
        _map = super(GetMediaInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_info is not None:
            result['MediaInfo'] = self.media_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaInfo') is not None:
            temp_model = GetMediaInfoResponseBodyMediaInfo()
            self.media_info = temp_model.from_map(m['MediaInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMediaInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMediaInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMediaInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMediaInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMediaInfoJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaInfoJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetMediaInfoJobResponseBodyMediaInfoJobInput(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaInfoJobResponseBodyMediaInfoJobInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyAudioStreamInfoList(TeaModel):
    def __init__(self, bitrate=None, channel_layout=None, channels=None, codec_long_name=None, codec_name=None,
                 codec_tag=None, codec_tag_string=None, codec_time_base=None, duration=None, index=None, lang=None,
                 sample_fmt=None, sample_rate=None, start_time=None, timebase=None):
        self.bitrate = bitrate  # type: str
        self.channel_layout = channel_layout  # type: str
        self.channels = channels  # type: str
        self.codec_long_name = codec_long_name  # type: str
        self.codec_name = codec_name  # type: str
        self.codec_tag = codec_tag  # type: str
        self.codec_tag_string = codec_tag_string  # type: str
        self.codec_time_base = codec_time_base  # type: str
        self.duration = duration  # type: str
        self.index = index  # type: str
        self.lang = lang  # type: str
        self.sample_fmt = sample_fmt  # type: str
        self.sample_rate = sample_rate  # type: str
        self.start_time = start_time  # type: str
        self.timebase = timebase  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyAudioStreamInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.sample_rate is not None:
            result['SampleRate'] = self.sample_rate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('SampleRate') is not None:
            self.sample_rate = m.get('SampleRate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyFileBasicInfo(TeaModel):
    def __init__(self, bitrate=None, duration=None, file_name=None, file_size=None, file_status=None, file_type=None,
                 file_url=None, format_name=None, height=None, media_id=None, region=None, width=None):
        self.bitrate = bitrate  # type: str
        self.duration = duration  # type: str
        self.file_name = file_name  # type: str
        self.file_size = file_size  # type: str
        self.file_status = file_status  # type: str
        self.file_type = file_type  # type: str
        self.file_url = file_url  # type: str
        self.format_name = format_name  # type: str
        self.height = height  # type: str
        self.media_id = media_id  # type: str
        self.region = region  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyFileBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyVideoStreamInfoList(TeaModel):
    def __init__(self, avg_fps=None, bit_rate=None, codec_long_name=None, codec_name=None, codec_tag=None,
                 codec_tag_string=None, codec_time_base=None, dar=None, duration=None, fps=None, has_bframes=None, height=None,
                 index=None, lang=None, level=None, num_frames=None, pix_fmt=None, profile=None, rotate=None, sar=None,
                 start_time=None, time_base=None, width=None):
        self.avg_fps = avg_fps  # type: str
        self.bit_rate = bit_rate  # type: str
        self.codec_long_name = codec_long_name  # type: str
        self.codec_name = codec_name  # type: str
        self.codec_tag = codec_tag  # type: str
        self.codec_tag_string = codec_tag_string  # type: str
        self.codec_time_base = codec_time_base  # type: str
        self.dar = dar  # type: str
        self.duration = duration  # type: str
        self.fps = fps  # type: str
        self.has_bframes = has_bframes  # type: str
        self.height = height  # type: str
        self.index = index  # type: str
        self.lang = lang  # type: str
        self.level = level  # type: str
        self.num_frames = num_frames  # type: str
        self.pix_fmt = pix_fmt  # type: str
        self.profile = profile  # type: str
        self.rotate = rotate  # type: str
        self.sar = sar  # type: str
        self.start_time = start_time  # type: str
        self.time_base = time_base  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyVideoStreamInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['Avg_fps'] = self.avg_fps
        if self.bit_rate is not None:
            result['Bit_rate'] = self.bit_rate
        if self.codec_long_name is not None:
            result['Codec_long_name'] = self.codec_long_name
        if self.codec_name is not None:
            result['Codec_name'] = self.codec_name
        if self.codec_tag is not None:
            result['Codec_tag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['Codec_tag_string'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['Codec_time_base'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['Has_b_frames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['Start_time'] = self.start_time
        if self.time_base is not None:
            result['Time_base'] = self.time_base
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Avg_fps') is not None:
            self.avg_fps = m.get('Avg_fps')
        if m.get('Bit_rate') is not None:
            self.bit_rate = m.get('Bit_rate')
        if m.get('Codec_long_name') is not None:
            self.codec_long_name = m.get('Codec_long_name')
        if m.get('Codec_name') is not None:
            self.codec_name = m.get('Codec_name')
        if m.get('Codec_tag') is not None:
            self.codec_tag = m.get('Codec_tag')
        if m.get('Codec_tag_string') is not None:
            self.codec_tag_string = m.get('Codec_tag_string')
        if m.get('Codec_time_base') is not None:
            self.codec_time_base = m.get('Codec_time_base')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Has_b_frames') is not None:
            self.has_bframes = m.get('Has_b_frames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('Start_time') is not None:
            self.start_time = m.get('Start_time')
        if m.get('Time_base') is not None:
            self.time_base = m.get('Time_base')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoProperty(TeaModel):
    def __init__(self, audio_stream_info_list=None, file_basic_info=None, video_stream_info_list=None):
        self.audio_stream_info_list = audio_stream_info_list  # type: list[GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyAudioStreamInfoList]
        self.file_basic_info = file_basic_info  # type: GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyFileBasicInfo
        self.video_stream_info_list = video_stream_info_list  # type: list[GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyVideoStreamInfoList]

    def validate(self):
        if self.audio_stream_info_list:
            for k in self.audio_stream_info_list:
                if k:
                    k.validate()
        if self.file_basic_info:
            self.file_basic_info.validate()
        if self.video_stream_info_list:
            for k in self.video_stream_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoProperty, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStreamInfoList'] = []
        if self.audio_stream_info_list is not None:
            for k in self.audio_stream_info_list:
                result['AudioStreamInfoList'].append(k.to_map() if k else None)
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        result['VideoStreamInfoList'] = []
        if self.video_stream_info_list is not None:
            for k in self.video_stream_info_list:
                result['VideoStreamInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.audio_stream_info_list = []
        if m.get('AudioStreamInfoList') is not None:
            for k in m.get('AudioStreamInfoList'):
                temp_model = GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyAudioStreamInfoList()
                self.audio_stream_info_list.append(temp_model.from_map(k))
        if m.get('FileBasicInfo') is not None:
            temp_model = GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        self.video_stream_info_list = []
        if m.get('VideoStreamInfoList') is not None:
            for k in m.get('VideoStreamInfoList'):
                temp_model = GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyVideoStreamInfoList()
                self.video_stream_info_list.append(temp_model.from_map(k))
        return self


class GetMediaInfoJobResponseBodyMediaInfoJobScheduleConfig(TeaModel):
    def __init__(self, pipeline_id=None, priority=None):
        self.pipeline_id = pipeline_id  # type: str
        self.priority = priority  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaInfoJobResponseBodyMediaInfoJobScheduleConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class GetMediaInfoJobResponseBodyMediaInfoJob(TeaModel):
    def __init__(self, async=None, finish_time=None, input=None, job_id=None, media_info_property=None, name=None,
                 request_id=None, schedule_config=None, status=None, submit_result_json=None, submit_time=None,
                 trigger_source=None, user_data=None):
        self.async = async  # type: bool
        self.finish_time = finish_time  # type: str
        self.input = input  # type: GetMediaInfoJobResponseBodyMediaInfoJobInput
        self.job_id = job_id  # type: str
        self.media_info_property = media_info_property  # type: GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoProperty
        self.name = name  # type: str
        self.request_id = request_id  # type: str
        self.schedule_config = schedule_config  # type: GetMediaInfoJobResponseBodyMediaInfoJobScheduleConfig
        self.status = status  # type: str
        self.submit_result_json = submit_result_json  # type: dict[str, any]
        self.submit_time = submit_time  # type: str
        self.trigger_source = trigger_source  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        if self.input:
            self.input.validate()
        if self.media_info_property:
            self.media_info_property.validate()
        if self.schedule_config:
            self.schedule_config.validate()

    def to_map(self):
        _map = super(GetMediaInfoJobResponseBodyMediaInfoJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async is not None:
            result['Async'] = self.async
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.media_info_property is not None:
            result['MediaInfoProperty'] = self.media_info_property.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_config is not None:
            result['ScheduleConfig'] = self.schedule_config.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_result_json is not None:
            result['SubmitResultJson'] = self.submit_result_json
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Async') is not None:
            self.async = m.get('Async')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = GetMediaInfoJobResponseBodyMediaInfoJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MediaInfoProperty') is not None:
            temp_model = GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoProperty()
            self.media_info_property = temp_model.from_map(m['MediaInfoProperty'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleConfig') is not None:
            temp_model = GetMediaInfoJobResponseBodyMediaInfoJobScheduleConfig()
            self.schedule_config = temp_model.from_map(m['ScheduleConfig'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitResultJson') is not None:
            self.submit_result_json = m.get('SubmitResultJson')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetMediaInfoJobResponseBody(TeaModel):
    def __init__(self, media_info_job=None, request_id=None):
        self.media_info_job = media_info_job  # type: GetMediaInfoJobResponseBodyMediaInfoJob
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_info_job:
            self.media_info_job.validate()

    def to_map(self):
        _map = super(GetMediaInfoJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_info_job is not None:
            result['MediaInfoJob'] = self.media_info_job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaInfoJob') is not None:
            temp_model = GetMediaInfoJobResponseBodyMediaInfoJob()
            self.media_info_job = temp_model.from_map(m['MediaInfoJob'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMediaInfoJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMediaInfoJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMediaInfoJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMediaInfoJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMediaProducingJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaProducingJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetMediaProducingJobResponseBodyMediaProducingJob(TeaModel):
    def __init__(self, clips_param=None, code=None, complete_time=None, create_time=None, duration=None, job_id=None,
                 media_id=None, media_url=None, message=None, modified_time=None, project_id=None, status=None,
                 template_id=None, timeline=None, vod_media_id=None):
        self.clips_param = clips_param  # type: str
        self.code = code  # type: str
        self.complete_time = complete_time  # type: str
        self.create_time = create_time  # type: str
        self.duration = duration  # type: float
        self.job_id = job_id  # type: str
        self.media_id = media_id  # type: str
        self.media_url = media_url  # type: str
        self.message = message  # type: str
        self.modified_time = modified_time  # type: str
        self.project_id = project_id  # type: str
        self.status = status  # type: str
        self.template_id = template_id  # type: str
        self.timeline = timeline  # type: str
        self.vod_media_id = vod_media_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMediaProducingJobResponseBodyMediaProducingJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_param is not None:
            result['ClipsParam'] = self.clips_param
        if self.code is not None:
            result['Code'] = self.code
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_url is not None:
            result['MediaURL'] = self.media_url
        if self.message is not None:
            result['Message'] = self.message
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.timeline is not None:
            result['Timeline'] = self.timeline
        if self.vod_media_id is not None:
            result['VodMediaId'] = self.vod_media_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClipsParam') is not None:
            self.clips_param = m.get('ClipsParam')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaURL') is not None:
            self.media_url = m.get('MediaURL')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Timeline') is not None:
            self.timeline = m.get('Timeline')
        if m.get('VodMediaId') is not None:
            self.vod_media_id = m.get('VodMediaId')
        return self


class GetMediaProducingJobResponseBody(TeaModel):
    def __init__(self, media_producing_job=None, request_id=None):
        self.media_producing_job = media_producing_job  # type: GetMediaProducingJobResponseBodyMediaProducingJob
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_producing_job:
            self.media_producing_job.validate()

    def to_map(self):
        _map = super(GetMediaProducingJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_producing_job is not None:
            result['MediaProducingJob'] = self.media_producing_job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaProducingJob') is not None:
            temp_model = GetMediaProducingJobResponseBodyMediaProducingJob()
            self.media_producing_job = temp_model.from_map(m['MediaProducingJob'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMediaProducingJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMediaProducingJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMediaProducingJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMediaProducingJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPipelineRequest(TeaModel):
    def __init__(self, pipeline_id=None):
        self.pipeline_id = pipeline_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPipelineRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        return self


class GetPipelineResponseBodyPipeline(TeaModel):
    def __init__(self, create_time=None, modified_time=None, name=None, pipeline_id=None, priority=None, speed=None,
                 status=None):
        self.create_time = create_time  # type: str
        self.modified_time = modified_time  # type: str
        self.name = name  # type: str
        self.pipeline_id = pipeline_id  # type: str
        self.priority = priority  # type: int
        self.speed = speed  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPipelineResponseBodyPipeline, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetPipelineResponseBody(TeaModel):
    def __init__(self, pipeline=None, request_id=None):
        self.pipeline = pipeline  # type: GetPipelineResponseBodyPipeline
        self.request_id = request_id  # type: str

    def validate(self):
        if self.pipeline:
            self.pipeline.validate()

    def to_map(self):
        _map = super(GetPipelineResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline is not None:
            result['Pipeline'] = self.pipeline.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Pipeline') is not None:
            temp_model = GetPipelineResponseBodyPipeline()
            self.pipeline = temp_model.from_map(m['Pipeline'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPipelineResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetPipelineResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetPipelineResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPlayInfoRequest(TeaModel):
    def __init__(self, media_id=None):
        self.media_id = media_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPlayInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class GetPlayInfoResponseBodyMediaBase(TeaModel):
    def __init__(self, cover_url=None, creation_time=None, media_id=None, media_type=None, status=None, title=None):
        self.cover_url = cover_url  # type: str
        self.creation_time = creation_time  # type: str
        self.media_id = media_id  # type: str
        self.media_type = media_type  # type: str
        self.status = status  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPlayInfoResponseBodyMediaBase, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetPlayInfoResponseBodyPlayInfoList(TeaModel):
    def __init__(self, bit_depth=None, bitrate=None, creation_time=None, definition=None, duration=None,
                 encrypt=None, encrypt_type=None, file_url=None, format=None, fps=None, hdrtype=None, height=None,
                 modification_time=None, narrow_band_type=None, play_url=None, size=None, status=None, stream_type=None,
                 trans_template_type=None, watermark_id=None, width=None):
        self.bit_depth = bit_depth  # type: int
        self.bitrate = bitrate  # type: str
        self.creation_time = creation_time  # type: str
        self.definition = definition  # type: str
        self.duration = duration  # type: str
        self.encrypt = encrypt  # type: long
        self.encrypt_type = encrypt_type  # type: str
        self.file_url = file_url  # type: str
        self.format = format  # type: str
        self.fps = fps  # type: str
        self.hdrtype = hdrtype  # type: str
        self.height = height  # type: long
        self.modification_time = modification_time  # type: str
        self.narrow_band_type = narrow_band_type  # type: str
        self.play_url = play_url  # type: str
        self.size = size  # type: long
        self.status = status  # type: str
        self.stream_type = stream_type  # type: str
        self.trans_template_type = trans_template_type  # type: str
        self.watermark_id = watermark_id  # type: str
        self.width = width  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPlayInfoResponseBodyPlayInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bit_depth is not None:
            result['BitDepth'] = self.bit_depth
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        if self.encrypt_type is not None:
            result['EncryptType'] = self.encrypt_type
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.format is not None:
            result['Format'] = self.format
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.hdrtype is not None:
            result['HDRType'] = self.hdrtype
        if self.height is not None:
            result['Height'] = self.height
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        if self.narrow_band_type is not None:
            result['NarrowBandType'] = self.narrow_band_type
        if self.play_url is not None:
            result['PlayURL'] = self.play_url
        if self.size is not None:
            result['Size'] = self.size
        if self.status is not None:
            result['Status'] = self.status
        if self.stream_type is not None:
            result['StreamType'] = self.stream_type
        if self.trans_template_type is not None:
            result['TransTemplateType'] = self.trans_template_type
        if self.watermark_id is not None:
            result['WatermarkId'] = self.watermark_id
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BitDepth') is not None:
            self.bit_depth = m.get('BitDepth')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        if m.get('EncryptType') is not None:
            self.encrypt_type = m.get('EncryptType')
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HDRType') is not None:
            self.hdrtype = m.get('HDRType')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        if m.get('NarrowBandType') is not None:
            self.narrow_band_type = m.get('NarrowBandType')
        if m.get('PlayURL') is not None:
            self.play_url = m.get('PlayURL')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StreamType') is not None:
            self.stream_type = m.get('StreamType')
        if m.get('TransTemplateType') is not None:
            self.trans_template_type = m.get('TransTemplateType')
        if m.get('WatermarkId') is not None:
            self.watermark_id = m.get('WatermarkId')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetPlayInfoResponseBody(TeaModel):
    def __init__(self, media_base=None, play_info_list=None, request_id=None):
        self.media_base = media_base  # type: GetPlayInfoResponseBodyMediaBase
        self.play_info_list = play_info_list  # type: list[GetPlayInfoResponseBodyPlayInfoList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_base:
            self.media_base.validate()
        if self.play_info_list:
            for k in self.play_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetPlayInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_base is not None:
            result['MediaBase'] = self.media_base.to_map()
        result['PlayInfoList'] = []
        if self.play_info_list is not None:
            for k in self.play_info_list:
                result['PlayInfoList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaBase') is not None:
            temp_model = GetPlayInfoResponseBodyMediaBase()
            self.media_base = temp_model.from_map(m['MediaBase'])
        self.play_info_list = []
        if m.get('PlayInfoList') is not None:
            for k in m.get('PlayInfoList'):
                temp_model = GetPlayInfoResponseBodyPlayInfoList()
                self.play_info_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPlayInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetPlayInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetPlayInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPlayInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPublicMediaInfoRequest(TeaModel):
    def __init__(self, media_id=None):
        self.media_id = media_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPublicMediaInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class GetPublicMediaInfoResponseBodyMediaInfoDynamicMetaData(TeaModel):
    def __init__(self, data=None, type=None):
        self.data = data  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPublicMediaInfoResponseBodyMediaInfoDynamicMetaData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetPublicMediaInfoResponseBodyMediaInfoFileInfoListAudioStreamInfoList(TeaModel):
    def __init__(self, bitrate=None, channel_layout=None, channels=None, codec_long_name=None, codec_name=None,
                 codec_tag=None, codec_tag_string=None, codec_time_base=None, duration=None, fps=None, index=None, lang=None,
                 num_frames=None, profile=None, sample_fmt=None, sample_rate=None, start_time=None, timebase=None):
        self.bitrate = bitrate  # type: str
        self.channel_layout = channel_layout  # type: str
        self.channels = channels  # type: str
        self.codec_long_name = codec_long_name  # type: str
        self.codec_name = codec_name  # type: str
        self.codec_tag = codec_tag  # type: str
        self.codec_tag_string = codec_tag_string  # type: str
        self.codec_time_base = codec_time_base  # type: str
        self.duration = duration  # type: str
        self.fps = fps  # type: str
        self.index = index  # type: str
        self.lang = lang  # type: str
        self.num_frames = num_frames  # type: str
        self.profile = profile  # type: str
        self.sample_fmt = sample_fmt  # type: str
        self.sample_rate = sample_rate  # type: str
        self.start_time = start_time  # type: str
        self.timebase = timebase  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPublicMediaInfoResponseBodyMediaInfoFileInfoListAudioStreamInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.sample_rate is not None:
            result['SampleRate'] = self.sample_rate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('SampleRate') is not None:
            self.sample_rate = m.get('SampleRate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class GetPublicMediaInfoResponseBodyMediaInfoFileInfoListFileBasicInfo(TeaModel):
    def __init__(self, bitrate=None, duration=None, file_name=None, file_size=None, file_status=None, file_type=None,
                 file_url=None, format_name=None, height=None, region=None, width=None):
        self.bitrate = bitrate  # type: str
        self.duration = duration  # type: str
        self.file_name = file_name  # type: str
        self.file_size = file_size  # type: str
        self.file_status = file_status  # type: str
        self.file_type = file_type  # type: str
        self.file_url = file_url  # type: str
        self.format_name = format_name  # type: str
        self.height = height  # type: str
        self.region = region  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPublicMediaInfoResponseBodyMediaInfoFileInfoListFileBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetPublicMediaInfoResponseBodyMediaInfoFileInfoListSubtitleStreamInfoList(TeaModel):
    def __init__(self, codec_long_name=None, codec_name=None, codec_tag=None, codec_tag_string=None,
                 codec_time_base=None, duration=None, index=None, lang=None, start_time=None, timebase=None):
        self.codec_long_name = codec_long_name  # type: str
        self.codec_name = codec_name  # type: str
        self.codec_tag = codec_tag  # type: str
        self.codec_tag_string = codec_tag_string  # type: str
        self.codec_time_base = codec_time_base  # type: str
        self.duration = duration  # type: str
        self.index = index  # type: str
        self.lang = lang  # type: str
        self.start_time = start_time  # type: str
        self.timebase = timebase  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPublicMediaInfoResponseBodyMediaInfoFileInfoListSubtitleStreamInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class GetPublicMediaInfoResponseBodyMediaInfoFileInfoListVideoStreamInfoList(TeaModel):
    def __init__(self, avg_fps=None, bitrate=None, codec_long_name=None, codec_name=None, codec_tag=None,
                 codec_tag_string=None, codec_time_base=None, dar=None, duration=None, fps=None, has_bframes=None, height=None,
                 index=None, lang=None, level=None, nb_frames=None, num_frames=None, pix_fmt=None, profile=None,
                 rotate=None, sar=None, start_time=None, timebase=None, width=None):
        self.avg_fps = avg_fps  # type: str
        self.bitrate = bitrate  # type: str
        self.codec_long_name = codec_long_name  # type: str
        self.codec_name = codec_name  # type: str
        self.codec_tag = codec_tag  # type: str
        self.codec_tag_string = codec_tag_string  # type: str
        self.codec_time_base = codec_time_base  # type: str
        self.dar = dar  # type: str
        self.duration = duration  # type: str
        self.fps = fps  # type: str
        self.has_bframes = has_bframes  # type: str
        self.height = height  # type: str
        self.index = index  # type: str
        self.lang = lang  # type: str
        self.level = level  # type: str
        self.nb_frames = nb_frames  # type: str
        self.num_frames = num_frames  # type: str
        self.pix_fmt = pix_fmt  # type: str
        self.profile = profile  # type: str
        self.rotate = rotate  # type: str
        self.sar = sar  # type: str
        self.start_time = start_time  # type: str
        self.timebase = timebase  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPublicMediaInfoResponseBodyMediaInfoFileInfoListVideoStreamInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.nb_frames is not None:
            result['Nb_frames'] = self.nb_frames
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Nb_frames') is not None:
            self.nb_frames = m.get('Nb_frames')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetPublicMediaInfoResponseBodyMediaInfoFileInfoList(TeaModel):
    def __init__(self, audio_stream_info_list=None, file_basic_info=None, subtitle_stream_info_list=None,
                 video_stream_info_list=None):
        self.audio_stream_info_list = audio_stream_info_list  # type: list[GetPublicMediaInfoResponseBodyMediaInfoFileInfoListAudioStreamInfoList]
        self.file_basic_info = file_basic_info  # type: GetPublicMediaInfoResponseBodyMediaInfoFileInfoListFileBasicInfo
        self.subtitle_stream_info_list = subtitle_stream_info_list  # type: list[GetPublicMediaInfoResponseBodyMediaInfoFileInfoListSubtitleStreamInfoList]
        self.video_stream_info_list = video_stream_info_list  # type: list[GetPublicMediaInfoResponseBodyMediaInfoFileInfoListVideoStreamInfoList]

    def validate(self):
        if self.audio_stream_info_list:
            for k in self.audio_stream_info_list:
                if k:
                    k.validate()
        if self.file_basic_info:
            self.file_basic_info.validate()
        if self.subtitle_stream_info_list:
            for k in self.subtitle_stream_info_list:
                if k:
                    k.validate()
        if self.video_stream_info_list:
            for k in self.video_stream_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetPublicMediaInfoResponseBodyMediaInfoFileInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStreamInfoList'] = []
        if self.audio_stream_info_list is not None:
            for k in self.audio_stream_info_list:
                result['AudioStreamInfoList'].append(k.to_map() if k else None)
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        result['SubtitleStreamInfoList'] = []
        if self.subtitle_stream_info_list is not None:
            for k in self.subtitle_stream_info_list:
                result['SubtitleStreamInfoList'].append(k.to_map() if k else None)
        result['VideoStreamInfoList'] = []
        if self.video_stream_info_list is not None:
            for k in self.video_stream_info_list:
                result['VideoStreamInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.audio_stream_info_list = []
        if m.get('AudioStreamInfoList') is not None:
            for k in m.get('AudioStreamInfoList'):
                temp_model = GetPublicMediaInfoResponseBodyMediaInfoFileInfoListAudioStreamInfoList()
                self.audio_stream_info_list.append(temp_model.from_map(k))
        if m.get('FileBasicInfo') is not None:
            temp_model = GetPublicMediaInfoResponseBodyMediaInfoFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        self.subtitle_stream_info_list = []
        if m.get('SubtitleStreamInfoList') is not None:
            for k in m.get('SubtitleStreamInfoList'):
                temp_model = GetPublicMediaInfoResponseBodyMediaInfoFileInfoListSubtitleStreamInfoList()
                self.subtitle_stream_info_list.append(temp_model.from_map(k))
        self.video_stream_info_list = []
        if m.get('VideoStreamInfoList') is not None:
            for k in m.get('VideoStreamInfoList'):
                temp_model = GetPublicMediaInfoResponseBodyMediaInfoFileInfoListVideoStreamInfoList()
                self.video_stream_info_list.append(temp_model.from_map(k))
        return self


class GetPublicMediaInfoResponseBodyMediaInfoMediaBasicInfo(TeaModel):
    def __init__(self, business_type=None, category=None, cover_url=None, create_time=None, deleted_time=None,
                 description=None, media_id=None, media_tags=None, media_type=None, modified_time=None, source=None,
                 sprite_images=None, status=None, title=None, user_data=None):
        self.business_type = business_type  # type: str
        self.category = category  # type: str
        self.cover_url = cover_url  # type: str
        self.create_time = create_time  # type: str
        self.deleted_time = deleted_time  # type: str
        self.description = description  # type: str
        self.media_id = media_id  # type: str
        self.media_tags = media_tags  # type: str
        self.media_type = media_type  # type: str
        self.modified_time = modified_time  # type: str
        self.source = source  # type: str
        self.sprite_images = sprite_images  # type: str
        self.status = status  # type: str
        self.title = title  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetPublicMediaInfoResponseBodyMediaInfoMediaBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_images is not None:
            result['SpriteImages'] = self.sprite_images
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteImages') is not None:
            self.sprite_images = m.get('SpriteImages')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetPublicMediaInfoResponseBodyMediaInfo(TeaModel):
    def __init__(self, dynamic_meta_data=None, file_info_list=None, media_basic_info=None, media_id=None):
        self.dynamic_meta_data = dynamic_meta_data  # type: GetPublicMediaInfoResponseBodyMediaInfoDynamicMetaData
        self.file_info_list = file_info_list  # type: list[GetPublicMediaInfoResponseBodyMediaInfoFileInfoList]
        self.media_basic_info = media_basic_info  # type: GetPublicMediaInfoResponseBodyMediaInfoMediaBasicInfo
        self.media_id = media_id  # type: str

    def validate(self):
        if self.dynamic_meta_data:
            self.dynamic_meta_data.validate()
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super(GetPublicMediaInfoResponseBodyMediaInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_meta_data is not None:
            result['DynamicMetaData'] = self.dynamic_meta_data.to_map()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DynamicMetaData') is not None:
            temp_model = GetPublicMediaInfoResponseBodyMediaInfoDynamicMetaData()
            self.dynamic_meta_data = temp_model.from_map(m['DynamicMetaData'])
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = GetPublicMediaInfoResponseBodyMediaInfoFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = GetPublicMediaInfoResponseBodyMediaInfoMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class GetPublicMediaInfoResponseBody(TeaModel):
    def __init__(self, media_info=None, request_id=None):
        self.media_info = media_info  # type: GetPublicMediaInfoResponseBodyMediaInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_info:
            self.media_info.validate()

    def to_map(self):
        _map = super(GetPublicMediaInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_info is not None:
            result['MediaInfo'] = self.media_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaInfo') is not None:
            temp_model = GetPublicMediaInfoResponseBodyMediaInfo()
            self.media_info = temp_model.from_map(m['MediaInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPublicMediaInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetPublicMediaInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetPublicMediaInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPublicMediaInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSmartHandleJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSmartHandleJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetSmartHandleJobResponseBodySmartJobInfoInputConfig(TeaModel):
    def __init__(self, input_file=None):
        self.input_file = input_file  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSmartHandleJobResponseBodySmartJobInfoInputConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_file is not None:
            result['InputFile'] = self.input_file
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InputFile') is not None:
            self.input_file = m.get('InputFile')
        return self


class GetSmartHandleJobResponseBodySmartJobInfoOutputConfig(TeaModel):
    def __init__(self, bucket=None, object=None):
        self.bucket = bucket  # type: str
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSmartHandleJobResponseBodySmartJobInfoOutputConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class GetSmartHandleJobResponseBodySmartJobInfo(TeaModel):
    def __init__(self, create_time=None, description=None, input_config=None, job_type=None, modified_time=None,
                 output_config=None, title=None, user_id=None):
        self.create_time = create_time  # type: str
        self.description = description  # type: str
        self.input_config = input_config  # type: GetSmartHandleJobResponseBodySmartJobInfoInputConfig
        self.job_type = job_type  # type: str
        self.modified_time = modified_time  # type: str
        self.output_config = output_config  # type: GetSmartHandleJobResponseBodySmartJobInfoOutputConfig
        self.title = title  # type: str
        self.user_id = user_id  # type: str

    def validate(self):
        if self.input_config:
            self.input_config.validate()
        if self.output_config:
            self.output_config.validate()

    def to_map(self):
        _map = super(GetSmartHandleJobResponseBodySmartJobInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_config is not None:
            result['InputConfig'] = self.input_config.to_map()
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.output_config is not None:
            result['OutputConfig'] = self.output_config.to_map()
        if self.title is not None:
            result['Title'] = self.title
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputConfig') is not None:
            temp_model = GetSmartHandleJobResponseBodySmartJobInfoInputConfig()
            self.input_config = temp_model.from_map(m['InputConfig'])
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OutputConfig') is not None:
            temp_model = GetSmartHandleJobResponseBodySmartJobInfoOutputConfig()
            self.output_config = temp_model.from_map(m['OutputConfig'])
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetSmartHandleJobResponseBody(TeaModel):
    def __init__(self, job_id=None, output=None, request_id=None, smart_job_info=None, state=None, user_data=None):
        self.job_id = job_id  # type: str
        self.output = output  # type: str
        self.request_id = request_id  # type: str
        self.smart_job_info = smart_job_info  # type: GetSmartHandleJobResponseBodySmartJobInfo
        self.state = state  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        if self.smart_job_info:
            self.smart_job_info.validate()

    def to_map(self):
        _map = super(GetSmartHandleJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.output is not None:
            result['Output'] = self.output
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.smart_job_info is not None:
            result['SmartJobInfo'] = self.smart_job_info.to_map()
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SmartJobInfo') is not None:
            temp_model = GetSmartHandleJobResponseBodySmartJobInfo()
            self.smart_job_info = temp_model.from_map(m['SmartJobInfo'])
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetSmartHandleJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSmartHandleJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSmartHandleJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSmartHandleJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSnapshotJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSnapshotJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetSnapshotJobResponseBodySnapshotJobInputOssFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        self.bucket = bucket  # type: str
        self.location = location  # type: str
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSnapshotJobResponseBodySnapshotJobInputOssFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class GetSnapshotJobResponseBodySnapshotJobInput(TeaModel):
    def __init__(self, media=None, oss_file=None, type=None):
        self.media = media  # type: str
        self.oss_file = oss_file  # type: GetSnapshotJobResponseBodySnapshotJobInputOssFile
        self.type = type  # type: str

    def validate(self):
        if self.oss_file:
            self.oss_file.validate()

    def to_map(self):
        _map = super(GetSnapshotJobResponseBodySnapshotJobInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.oss_file is not None:
            result['OssFile'] = self.oss_file.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('OssFile') is not None:
            temp_model = GetSnapshotJobResponseBodySnapshotJobInputOssFile()
            self.oss_file = temp_model.from_map(m['OssFile'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetSnapshotJobResponseBodySnapshotJobOutputOssFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        self.bucket = bucket  # type: str
        self.location = location  # type: str
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSnapshotJobResponseBodySnapshotJobOutputOssFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class GetSnapshotJobResponseBodySnapshotJobOutput(TeaModel):
    def __init__(self, media=None, oss_file=None, type=None):
        self.media = media  # type: str
        self.oss_file = oss_file  # type: GetSnapshotJobResponseBodySnapshotJobOutputOssFile
        self.type = type  # type: str

    def validate(self):
        if self.oss_file:
            self.oss_file.validate()

    def to_map(self):
        _map = super(GetSnapshotJobResponseBodySnapshotJobOutput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.oss_file is not None:
            result['OssFile'] = self.oss_file.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('OssFile') is not None:
            temp_model = GetSnapshotJobResponseBodySnapshotJobOutputOssFile()
            self.oss_file = temp_model.from_map(m['OssFile'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetSnapshotJobResponseBodySnapshotJob(TeaModel):
    def __init__(self, async=None, code=None, count=None, create_time=None, finish_time=None, input=None, job_id=None,
                 message=None, modified_time=None, name=None, output=None, pipeline_id=None, status=None, submit_time=None,
                 template_config=None, template_id=None, trigger_source=None, type=None, user_data=None):
        self.async = async  # type: bool
        self.code = code  # type: str
        self.count = count  # type: int
        self.create_time = create_time  # type: str
        self.finish_time = finish_time  # type: str
        self.input = input  # type: GetSnapshotJobResponseBodySnapshotJobInput
        self.job_id = job_id  # type: str
        self.message = message  # type: str
        self.modified_time = modified_time  # type: str
        self.name = name  # type: str
        self.output = output  # type: GetSnapshotJobResponseBodySnapshotJobOutput
        self.pipeline_id = pipeline_id  # type: str
        self.status = status  # type: str
        self.submit_time = submit_time  # type: str
        self.template_config = template_config  # type: str
        self.template_id = template_id  # type: str
        self.trigger_source = trigger_source  # type: str
        self.type = type  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        if self.input:
            self.input.validate()
        if self.output:
            self.output.validate()

    def to_map(self):
        _map = super(GetSnapshotJobResponseBodySnapshotJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async is not None:
            result['Async'] = self.async
        if self.code is not None:
            result['Code'] = self.code
        if self.count is not None:
            result['Count'] = self.count
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        if self.type is not None:
            result['Type'] = self.type
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Async') is not None:
            self.async = m.get('Async')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = GetSnapshotJobResponseBodySnapshotJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Output') is not None:
            temp_model = GetSnapshotJobResponseBodySnapshotJobOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetSnapshotJobResponseBody(TeaModel):
    def __init__(self, request_id=None, snapshot_job=None):
        self.request_id = request_id  # type: str
        self.snapshot_job = snapshot_job  # type: GetSnapshotJobResponseBodySnapshotJob

    def validate(self):
        if self.snapshot_job:
            self.snapshot_job.validate()

    def to_map(self):
        _map = super(GetSnapshotJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snapshot_job is not None:
            result['SnapshotJob'] = self.snapshot_job.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnapshotJob') is not None:
            temp_model = GetSnapshotJobResponseBodySnapshotJob()
            self.snapshot_job = temp_model.from_map(m['SnapshotJob'])
        return self


class GetSnapshotJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSnapshotJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSnapshotJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSnapshotJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSnapshotUrlsRequest(TeaModel):
    def __init__(self, job_id=None, order_by=None, page_number=None, page_size=None, timeout=None):
        self.job_id = job_id  # type: str
        self.order_by = order_by  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.timeout = timeout  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSnapshotUrlsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        return self


class GetSnapshotUrlsResponseBody(TeaModel):
    def __init__(self, request_id=None, snapshot_urls=None, total=None, web_vtturl=None):
        self.request_id = request_id  # type: str
        self.snapshot_urls = snapshot_urls  # type: list[str]
        self.total = total  # type: int
        self.web_vtturl = web_vtturl  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSnapshotUrlsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snapshot_urls is not None:
            result['SnapshotUrls'] = self.snapshot_urls
        if self.total is not None:
            result['Total'] = self.total
        if self.web_vtturl is not None:
            result['WebVTTUrl'] = self.web_vtturl
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnapshotUrls') is not None:
            self.snapshot_urls = m.get('SnapshotUrls')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('WebVTTUrl') is not None:
            self.web_vtturl = m.get('WebVTTUrl')
        return self


class GetSnapshotUrlsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSnapshotUrlsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSnapshotUrlsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSnapshotUrlsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSystemTemplateRequest(TeaModel):
    def __init__(self, template_id=None):
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSystemTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetSystemTemplateResponseBodySystemTemplate(TeaModel):
    def __init__(self, status=None, subtype=None, subtype_name=None, template_config=None, template_id=None,
                 template_name=None, type=None, type_name=None):
        self.status = status  # type: str
        self.subtype = subtype  # type: int
        self.subtype_name = subtype_name  # type: str
        self.template_config = template_config  # type: str
        self.template_id = template_id  # type: str
        self.template_name = template_name  # type: str
        self.type = type  # type: int
        self.type_name = type_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSystemTemplateResponseBodySystemTemplate, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.subtype_name is not None:
            result['SubtypeName'] = self.subtype_name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.type is not None:
            result['Type'] = self.type
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('SubtypeName') is not None:
            self.subtype_name = m.get('SubtypeName')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        return self


class GetSystemTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, system_template=None):
        self.request_id = request_id  # type: str
        self.system_template = system_template  # type: GetSystemTemplateResponseBodySystemTemplate

    def validate(self):
        if self.system_template:
            self.system_template.validate()

    def to_map(self):
        _map = super(GetSystemTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.system_template is not None:
            result['SystemTemplate'] = self.system_template.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SystemTemplate') is not None:
            temp_model = GetSystemTemplateResponseBodySystemTemplate()
            self.system_template = temp_model.from_map(m['SystemTemplate'])
        return self


class GetSystemTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSystemTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSystemTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSystemTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTemplateRequest(TeaModel):
    def __init__(self, related_mediaid_flag=None, template_id=None):
        self.related_mediaid_flag = related_mediaid_flag  # type: str
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.related_mediaid_flag is not None:
            result['RelatedMediaidFlag'] = self.related_mediaid_flag
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RelatedMediaidFlag') is not None:
            self.related_mediaid_flag = m.get('RelatedMediaidFlag')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTemplateResponseBodyTemplate(TeaModel):
    def __init__(self, clips_param=None, config=None, cover_url=None, create_source=None, creation_time=None,
                 modified_source=None, modified_time=None, name=None, preview_media=None, preview_media_status=None,
                 related_mediaids=None, status=None, template_id=None, type=None):
        self.clips_param = clips_param  # type: str
        self.config = config  # type: str
        self.cover_url = cover_url  # type: str
        self.create_source = create_source  # type: str
        self.creation_time = creation_time  # type: str
        self.modified_source = modified_source  # type: str
        self.modified_time = modified_time  # type: str
        self.name = name  # type: str
        self.preview_media = preview_media  # type: str
        self.preview_media_status = preview_media_status  # type: str
        self.related_mediaids = related_mediaids  # type: str
        self.status = status  # type: str
        self.template_id = template_id  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTemplateResponseBodyTemplate, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_param is not None:
            result['ClipsParam'] = self.clips_param
        if self.config is not None:
            result['Config'] = self.config
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.modified_source is not None:
            result['ModifiedSource'] = self.modified_source
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.preview_media is not None:
            result['PreviewMedia'] = self.preview_media
        if self.preview_media_status is not None:
            result['PreviewMediaStatus'] = self.preview_media_status
        if self.related_mediaids is not None:
            result['RelatedMediaids'] = self.related_mediaids
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClipsParam') is not None:
            self.clips_param = m.get('ClipsParam')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('ModifiedSource') is not None:
            self.modified_source = m.get('ModifiedSource')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PreviewMedia') is not None:
            self.preview_media = m.get('PreviewMedia')
        if m.get('PreviewMediaStatus') is not None:
            self.preview_media_status = m.get('PreviewMediaStatus')
        if m.get('RelatedMediaids') is not None:
            self.related_mediaids = m.get('RelatedMediaids')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template=None):
        self.request_id = request_id  # type: str
        self.template = template  # type: GetTemplateResponseBodyTemplate

    def validate(self):
        if self.template:
            self.template.validate()

    def to_map(self):
        _map = super(GetTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template is not None:
            result['Template'] = self.template.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Template') is not None:
            temp_model = GetTemplateResponseBodyTemplate()
            self.template = temp_model.from_map(m['Template'])
        return self


class GetTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTemplateMaterialsRequest(TeaModel):
    def __init__(self, file_list=None, template_id=None):
        self.file_list = file_list  # type: str
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTemplateMaterialsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_list is not None:
            result['FileList'] = self.file_list
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileList') is not None:
            self.file_list = m.get('FileList')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTemplateMaterialsResponseBody(TeaModel):
    def __init__(self, material_urls=None, request_id=None):
        self.material_urls = material_urls  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTemplateMaterialsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.material_urls is not None:
            result['MaterialUrls'] = self.material_urls
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaterialUrls') is not None:
            self.material_urls = m.get('MaterialUrls')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetTemplateMaterialsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetTemplateMaterialsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTemplateMaterialsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTemplateMaterialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTranscodeJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobInputGroup(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobInputGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupOutput(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupOutput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParamsFile(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParamsFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParamsTimeline(TeaModel):
    def __init__(self, duration=None, start=None):
        self.duration = duration  # type: str
        self.start = start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParamsTimeline, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParams(TeaModel):
    def __init__(self, dx=None, dy=None, file=None, height=None, refer_pos=None, timeline=None, width=None):
        self.dx = dx  # type: str
        self.dy = dy  # type: str
        self.file = file  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParamsFile
        self.height = height  # type: str
        self.refer_pos = refer_pos  # type: str
        self.timeline = timeline  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParamsTimeline
        self.width = width  # type: str

    def validate(self):
        if self.file:
            self.file.validate()
        if self.timeline:
            self.timeline.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.dy is not None:
            result['Dy'] = self.dy
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.height is not None:
            result['Height'] = self.height
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.timeline is not None:
            result['Timeline'] = self.timeline.to_map()
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        if m.get('File') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParamsFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Timeline') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParamsTimeline()
            self.timeline = temp_model.from_map(m['Timeline'])
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarks(TeaModel):
    def __init__(self, overwrite_params=None, template_id=None):
        self.overwrite_params = overwrite_params  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParams
        self.template_id = template_id  # type: str

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitlesOverwriteParamsFile(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitlesOverwriteParamsFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitlesOverwriteParams(TeaModel):
    def __init__(self, char_enc=None, file=None, format=None):
        self.char_enc = char_enc  # type: str
        self.file = file  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitlesOverwriteParamsFile
        self.format = format  # type: str

    def validate(self):
        if self.file:
            self.file.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitlesOverwriteParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('File') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitlesOverwriteParamsFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitles(TeaModel):
    def __init__(self, overwrite_params=None, template_id=None):
        self.overwrite_params = overwrite_params  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitlesOverwriteParams
        self.template_id = template_id  # type: str

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitles, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitlesOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTextWatermarksOverwriteParams(TeaModel):
    def __init__(self, adaptive=None, border_color=None, border_width=None, content=None, font_alpha=None,
                 font_color=None, font_name=None, font_size=None, left=None, top=None):
        self.adaptive = adaptive  # type: str
        self.border_color = border_color  # type: str
        self.border_width = border_width  # type: int
        self.content = content  # type: str
        self.font_alpha = font_alpha  # type: str
        self.font_color = font_color  # type: str
        self.font_name = font_name  # type: str
        self.font_size = font_size  # type: int
        self.left = left  # type: str
        self.top = top  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTextWatermarksOverwriteParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adaptive is not None:
            result['Adaptive'] = self.adaptive
        if self.border_color is not None:
            result['BorderColor'] = self.border_color
        if self.border_width is not None:
            result['BorderWidth'] = self.border_width
        if self.content is not None:
            result['Content'] = self.content
        if self.font_alpha is not None:
            result['FontAlpha'] = self.font_alpha
        if self.font_color is not None:
            result['FontColor'] = self.font_color
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.font_size is not None:
            result['FontSize'] = self.font_size
        if self.left is not None:
            result['Left'] = self.left
        if self.top is not None:
            result['Top'] = self.top
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Adaptive') is not None:
            self.adaptive = m.get('Adaptive')
        if m.get('BorderColor') is not None:
            self.border_color = m.get('BorderColor')
        if m.get('BorderWidth') is not None:
            self.border_width = m.get('BorderWidth')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('FontAlpha') is not None:
            self.font_alpha = m.get('FontAlpha')
        if m.get('FontColor') is not None:
            self.font_color = m.get('FontColor')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('FontSize') is not None:
            self.font_size = m.get('FontSize')
        if m.get('Left') is not None:
            self.left = m.get('Left')
        if m.get('Top') is not None:
            self.top = m.get('Top')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTextWatermarks(TeaModel):
    def __init__(self, overwrite_params=None, template_id=None):
        self.overwrite_params = overwrite_params  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTextWatermarksOverwriteParams
        self.template_id = template_id  # type: str

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTextWatermarks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTextWatermarksOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsAudioVolume(TeaModel):
    def __init__(self, integrated_loudness_target=None, loudness_range_target=None, method=None, true_peak=None):
        self.integrated_loudness_target = integrated_loudness_target  # type: str
        self.loudness_range_target = loudness_range_target  # type: str
        self.method = method  # type: str
        self.true_peak = true_peak  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsAudioVolume, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.integrated_loudness_target is not None:
            result['IntegratedLoudnessTarget'] = self.integrated_loudness_target
        if self.loudness_range_target is not None:
            result['LoudnessRangeTarget'] = self.loudness_range_target
        if self.method is not None:
            result['Method'] = self.method
        if self.true_peak is not None:
            result['TruePeak'] = self.true_peak
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IntegratedLoudnessTarget') is not None:
            self.integrated_loudness_target = m.get('IntegratedLoudnessTarget')
        if m.get('LoudnessRangeTarget') is not None:
            self.loudness_range_target = m.get('LoudnessRangeTarget')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('TruePeak') is not None:
            self.true_peak = m.get('TruePeak')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsAudio(TeaModel):
    def __init__(self, bitrate=None, channels=None, codec=None, profile=None, remove=None, samplerate=None,
                 volume=None):
        self.bitrate = bitrate  # type: str
        self.channels = channels  # type: str
        self.codec = codec  # type: str
        self.profile = profile  # type: str
        self.remove = remove  # type: str
        self.samplerate = samplerate  # type: str
        self.volume = volume  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsAudioVolume

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsAudio, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Volume') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsContainer(TeaModel):
    def __init__(self, format=None):
        self.format = format  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsContainer, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfigSegment(TeaModel):
    def __init__(self, duration=None, force_seg_time=None):
        self.duration = duration  # type: str
        self.force_seg_time = force_seg_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfigSegment, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.force_seg_time is not None:
            result['ForceSegTime'] = self.force_seg_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ForceSegTime') is not None:
            self.force_seg_time = m.get('ForceSegTime')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfig(TeaModel):
    def __init__(self, segment=None):
        self.segment = segment  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfigSegment

    def validate(self):
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Segment') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsVideo(TeaModel):
    def __init__(self, abr_max=None, bitrate=None, bufsize=None, codec=None, crf=None, crop=None, fps=None, gop=None,
                 height=None, long_short_mode=None, maxrate=None, pad=None, pix_fmt=None, preset=None, profile=None,
                 remove=None, scan_mode=None, width=None):
        self.abr_max = abr_max  # type: str
        self.bitrate = bitrate  # type: str
        self.bufsize = bufsize  # type: str
        self.codec = codec  # type: str
        self.crf = crf  # type: str
        self.crop = crop  # type: str
        self.fps = fps  # type: str
        self.gop = gop  # type: str
        self.height = height  # type: str
        self.long_short_mode = long_short_mode  # type: str
        self.maxrate = maxrate  # type: str
        self.pad = pad  # type: str
        self.pix_fmt = pix_fmt  # type: str
        self.preset = preset  # type: str
        self.profile = profile  # type: str
        self.remove = remove  # type: str
        self.scan_mode = scan_mode  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsVideo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abr_max is not None:
            result['AbrMax'] = self.abr_max
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.long_short_mode is not None:
            result['LongShortMode'] = self.long_short_mode
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AbrMax') is not None:
            self.abr_max = m.get('AbrMax')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('LongShortMode') is not None:
            self.long_short_mode = m.get('LongShortMode')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParams(TeaModel):
    def __init__(self, audio=None, container=None, mux_config=None, video=None):
        self.audio = audio  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsAudio
        self.container = container  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsContainer
        self.mux_config = mux_config  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfig
        self.video = video  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsVideo

    def validate(self):
        if self.audio:
            self.audio.validate()
        if self.container:
            self.container.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.video:
            self.video.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Audio') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('Container') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('MuxConfig') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('Video') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsVideo()
            self.video = temp_model.from_map(m['Video'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscode(TeaModel):
    def __init__(self, overwrite_params=None, template_id=None):
        self.overwrite_params = overwrite_params  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParams
        self.template_id = template_id  # type: str

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscode, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfig(TeaModel):
    def __init__(self, image_watermarks=None, subtitles=None, text_watermarks=None, transcode=None):
        self.image_watermarks = image_watermarks  # type: list[GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarks]
        self.subtitles = subtitles  # type: list[GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitles]
        self.text_watermarks = text_watermarks  # type: list[GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTextWatermarks]
        self.transcode = transcode  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscode

    def validate(self):
        if self.image_watermarks:
            for k in self.image_watermarks:
                if k:
                    k.validate()
        if self.subtitles:
            for k in self.subtitles:
                if k:
                    k.validate()
        if self.text_watermarks:
            for k in self.text_watermarks:
                if k:
                    k.validate()
        if self.transcode:
            self.transcode.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageWatermarks'] = []
        if self.image_watermarks is not None:
            for k in self.image_watermarks:
                result['ImageWatermarks'].append(k.to_map() if k else None)
        result['Subtitles'] = []
        if self.subtitles is not None:
            for k in self.subtitles:
                result['Subtitles'].append(k.to_map() if k else None)
        result['TextWatermarks'] = []
        if self.text_watermarks is not None:
            for k in self.text_watermarks:
                result['TextWatermarks'].append(k.to_map() if k else None)
        if self.transcode is not None:
            result['Transcode'] = self.transcode.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.image_watermarks = []
        if m.get('ImageWatermarks') is not None:
            for k in m.get('ImageWatermarks'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarks()
                self.image_watermarks.append(temp_model.from_map(k))
        self.subtitles = []
        if m.get('Subtitles') is not None:
            for k in m.get('Subtitles'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitles()
                self.subtitles.append(temp_model.from_map(k))
        self.text_watermarks = []
        if m.get('TextWatermarks') is not None:
            for k in m.get('TextWatermarks'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTextWatermarks()
                self.text_watermarks.append(temp_model.from_map(k))
        if m.get('Transcode') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscode()
            self.transcode = temp_model.from_map(m['Transcode'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroup(TeaModel):
    def __init__(self, output=None, process_config=None):
        self.output = output  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupOutput
        self.process_config = process_config  # type: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfig

    def validate(self):
        if self.output:
            self.output.validate()
        if self.process_config:
            self.process_config.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobOutputGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.process_config is not None:
            result['ProcessConfig'] = self.process_config.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Output') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('ProcessConfig') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfig()
            self.process_config = temp_model.from_map(m['ProcessConfig'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobScheduleConfig(TeaModel):
    def __init__(self, pipeline_id=None, priority=None):
        self.pipeline_id = pipeline_id  # type: str
        self.priority = priority  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobScheduleConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListInputGroup(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListInputGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaAudioStreamInfoList(TeaModel):
    def __init__(self, bitrate=None, channel_layout=None, channels=None, codec_long_name=None, codec_name=None,
                 codec_tag=None, codec_tag_string=None, codec_time_base=None, duration=None, index=None, lang=None,
                 sample_fmt=None, sample_rate=None, start_time=None, timebase=None):
        self.bitrate = bitrate  # type: str
        self.channel_layout = channel_layout  # type: str
        self.channels = channels  # type: str
        self.codec_long_name = codec_long_name  # type: str
        self.codec_name = codec_name  # type: str
        self.codec_tag = codec_tag  # type: str
        self.codec_tag_string = codec_tag_string  # type: str
        self.codec_time_base = codec_time_base  # type: str
        self.duration = duration  # type: str
        self.index = index  # type: str
        self.lang = lang  # type: str
        self.sample_fmt = sample_fmt  # type: str
        self.sample_rate = sample_rate  # type: str
        self.start_time = start_time  # type: str
        self.timebase = timebase  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaAudioStreamInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.sample_rate is not None:
            result['SampleRate'] = self.sample_rate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('SampleRate') is not None:
            self.sample_rate = m.get('SampleRate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaFileBasicInfo(TeaModel):
    def __init__(self, bitrate=None, duration=None, file_name=None, file_size=None, file_status=None, file_type=None,
                 file_url=None, format_name=None, height=None, media_id=None, region=None, width=None):
        self.bitrate = bitrate  # type: str
        self.duration = duration  # type: str
        self.file_name = file_name  # type: str
        self.file_size = file_size  # type: str
        self.file_status = file_status  # type: str
        self.file_type = file_type  # type: str
        self.file_url = file_url  # type: str
        self.format_name = format_name  # type: str
        self.height = height  # type: str
        self.media_id = media_id  # type: str
        self.region = region  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaFileBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaVideoStreamInfoList(TeaModel):
    def __init__(self, avg_fps=None, bit_rate=None, codec_long_name=None, codec_name=None, codec_tag=None,
                 codec_tag_string=None, codec_time_base=None, dar=None, duration=None, fps=None, has_bframes=None, height=None,
                 index=None, lang=None, level=None, num_frames=None, pix_fmt=None, profile=None, rotate=None, sar=None,
                 start_time=None, time_base=None, width=None):
        self.avg_fps = avg_fps  # type: str
        self.bit_rate = bit_rate  # type: str
        self.codec_long_name = codec_long_name  # type: str
        self.codec_name = codec_name  # type: str
        self.codec_tag = codec_tag  # type: str
        self.codec_tag_string = codec_tag_string  # type: str
        self.codec_time_base = codec_time_base  # type: str
        self.dar = dar  # type: str
        self.duration = duration  # type: str
        self.fps = fps  # type: str
        self.has_bframes = has_bframes  # type: str
        self.height = height  # type: str
        self.index = index  # type: str
        self.lang = lang  # type: str
        self.level = level  # type: str
        self.num_frames = num_frames  # type: str
        self.pix_fmt = pix_fmt  # type: str
        self.profile = profile  # type: str
        self.rotate = rotate  # type: str
        self.sar = sar  # type: str
        self.start_time = start_time  # type: str
        self.time_base = time_base  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaVideoStreamInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['Avg_fps'] = self.avg_fps
        if self.bit_rate is not None:
            result['Bit_rate'] = self.bit_rate
        if self.codec_long_name is not None:
            result['Codec_long_name'] = self.codec_long_name
        if self.codec_name is not None:
            result['Codec_name'] = self.codec_name
        if self.codec_tag is not None:
            result['Codec_tag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['Codec_tag_string'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['Codec_time_base'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['Has_b_frames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['Start_time'] = self.start_time
        if self.time_base is not None:
            result['Time_base'] = self.time_base
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Avg_fps') is not None:
            self.avg_fps = m.get('Avg_fps')
        if m.get('Bit_rate') is not None:
            self.bit_rate = m.get('Bit_rate')
        if m.get('Codec_long_name') is not None:
            self.codec_long_name = m.get('Codec_long_name')
        if m.get('Codec_name') is not None:
            self.codec_name = m.get('Codec_name')
        if m.get('Codec_tag') is not None:
            self.codec_tag = m.get('Codec_tag')
        if m.get('Codec_tag_string') is not None:
            self.codec_tag_string = m.get('Codec_tag_string')
        if m.get('Codec_time_base') is not None:
            self.codec_time_base = m.get('Codec_time_base')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Has_b_frames') is not None:
            self.has_bframes = m.get('Has_b_frames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('Start_time') is not None:
            self.start_time = m.get('Start_time')
        if m.get('Time_base') is not None:
            self.time_base = m.get('Time_base')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMeta(TeaModel):
    def __init__(self, audio_stream_info_list=None, file_basic_info=None, video_stream_info_list=None):
        self.audio_stream_info_list = audio_stream_info_list  # type: list[GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaAudioStreamInfoList]
        self.file_basic_info = file_basic_info  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaFileBasicInfo
        self.video_stream_info_list = video_stream_info_list  # type: list[GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaVideoStreamInfoList]

    def validate(self):
        if self.audio_stream_info_list:
            for k in self.audio_stream_info_list:
                if k:
                    k.validate()
        if self.file_basic_info:
            self.file_basic_info.validate()
        if self.video_stream_info_list:
            for k in self.video_stream_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMeta, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStreamInfoList'] = []
        if self.audio_stream_info_list is not None:
            for k in self.audio_stream_info_list:
                result['AudioStreamInfoList'].append(k.to_map() if k else None)
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        result['VideoStreamInfoList'] = []
        if self.video_stream_info_list is not None:
            for k in self.video_stream_info_list:
                result['VideoStreamInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.audio_stream_info_list = []
        if m.get('AudioStreamInfoList') is not None:
            for k in m.get('AudioStreamInfoList'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaAudioStreamInfoList()
                self.audio_stream_info_list.append(temp_model.from_map(k))
        if m.get('FileBasicInfo') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        self.video_stream_info_list = []
        if m.get('VideoStreamInfoList') is not None:
            for k in m.get('VideoStreamInfoList'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaVideoStreamInfoList()
                self.video_stream_info_list.append(temp_model.from_map(k))
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutput(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParamsFile(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParamsFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParamsTimeline(TeaModel):
    def __init__(self, duration=None, start=None):
        self.duration = duration  # type: str
        self.start = start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParamsTimeline, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParams(TeaModel):
    def __init__(self, dx=None, dy=None, file=None, height=None, refer_pos=None, timeline=None, width=None):
        self.dx = dx  # type: str
        self.dy = dy  # type: str
        self.file = file  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParamsFile
        self.height = height  # type: str
        self.refer_pos = refer_pos  # type: str
        self.timeline = timeline  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParamsTimeline
        self.width = width  # type: str

    def validate(self):
        if self.file:
            self.file.validate()
        if self.timeline:
            self.timeline.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.dy is not None:
            result['Dy'] = self.dy
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.height is not None:
            result['Height'] = self.height
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.timeline is not None:
            result['Timeline'] = self.timeline.to_map()
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        if m.get('File') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParamsFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Timeline') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParamsTimeline()
            self.timeline = temp_model.from_map(m['Timeline'])
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarks(TeaModel):
    def __init__(self, overwrite_params=None, template_id=None):
        self.overwrite_params = overwrite_params  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParams
        self.template_id = template_id  # type: str

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitlesOverwriteParamsFile(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitlesOverwriteParamsFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitlesOverwriteParams(TeaModel):
    def __init__(self, char_enc=None, file=None, format=None):
        self.char_enc = char_enc  # type: str
        self.file = file  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitlesOverwriteParamsFile
        self.format = format  # type: str

    def validate(self):
        if self.file:
            self.file.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitlesOverwriteParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('File') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitlesOverwriteParamsFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitles(TeaModel):
    def __init__(self, overwrite_params=None, template_id=None):
        self.overwrite_params = overwrite_params  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitlesOverwriteParams
        self.template_id = template_id  # type: str

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitles, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitlesOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTextWatermarksOverwriteParams(TeaModel):
    def __init__(self, adaptive=None, border_color=None, border_width=None, content=None, font_alpha=None,
                 font_color=None, font_name=None, font_size=None, left=None, top=None):
        self.adaptive = adaptive  # type: str
        self.border_color = border_color  # type: str
        self.border_width = border_width  # type: int
        self.content = content  # type: str
        self.font_alpha = font_alpha  # type: str
        self.font_color = font_color  # type: str
        self.font_name = font_name  # type: str
        self.font_size = font_size  # type: int
        self.left = left  # type: str
        self.top = top  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTextWatermarksOverwriteParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adaptive is not None:
            result['Adaptive'] = self.adaptive
        if self.border_color is not None:
            result['BorderColor'] = self.border_color
        if self.border_width is not None:
            result['BorderWidth'] = self.border_width
        if self.content is not None:
            result['Content'] = self.content
        if self.font_alpha is not None:
            result['FontAlpha'] = self.font_alpha
        if self.font_color is not None:
            result['FontColor'] = self.font_color
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.font_size is not None:
            result['FontSize'] = self.font_size
        if self.left is not None:
            result['Left'] = self.left
        if self.top is not None:
            result['Top'] = self.top
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Adaptive') is not None:
            self.adaptive = m.get('Adaptive')
        if m.get('BorderColor') is not None:
            self.border_color = m.get('BorderColor')
        if m.get('BorderWidth') is not None:
            self.border_width = m.get('BorderWidth')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('FontAlpha') is not None:
            self.font_alpha = m.get('FontAlpha')
        if m.get('FontColor') is not None:
            self.font_color = m.get('FontColor')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('FontSize') is not None:
            self.font_size = m.get('FontSize')
        if m.get('Left') is not None:
            self.left = m.get('Left')
        if m.get('Top') is not None:
            self.top = m.get('Top')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTextWatermarks(TeaModel):
    def __init__(self, overwrite_params=None, template_id=None):
        self.overwrite_params = overwrite_params  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTextWatermarksOverwriteParams
        self.template_id = template_id  # type: str

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTextWatermarks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTextWatermarksOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsAudioVolume(TeaModel):
    def __init__(self, integrated_loudness_target=None, loudness_range_target=None, method=None, true_peak=None):
        self.integrated_loudness_target = integrated_loudness_target  # type: str
        self.loudness_range_target = loudness_range_target  # type: str
        self.method = method  # type: str
        self.true_peak = true_peak  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsAudioVolume, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.integrated_loudness_target is not None:
            result['IntegratedLoudnessTarget'] = self.integrated_loudness_target
        if self.loudness_range_target is not None:
            result['LoudnessRangeTarget'] = self.loudness_range_target
        if self.method is not None:
            result['Method'] = self.method
        if self.true_peak is not None:
            result['TruePeak'] = self.true_peak
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IntegratedLoudnessTarget') is not None:
            self.integrated_loudness_target = m.get('IntegratedLoudnessTarget')
        if m.get('LoudnessRangeTarget') is not None:
            self.loudness_range_target = m.get('LoudnessRangeTarget')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('TruePeak') is not None:
            self.true_peak = m.get('TruePeak')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsAudio(TeaModel):
    def __init__(self, bitrate=None, channels=None, codec=None, profile=None, remove=None, samplerate=None,
                 volume=None):
        self.bitrate = bitrate  # type: str
        self.channels = channels  # type: str
        self.codec = codec  # type: str
        self.profile = profile  # type: str
        self.remove = remove  # type: str
        self.samplerate = samplerate  # type: str
        self.volume = volume  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsAudioVolume

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsAudio, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Volume') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsContainer(TeaModel):
    def __init__(self, format=None):
        self.format = format  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsContainer, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsMuxConfigSegment(TeaModel):
    def __init__(self, duration=None, force_seg_time=None):
        self.duration = duration  # type: str
        self.force_seg_time = force_seg_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsMuxConfigSegment, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.force_seg_time is not None:
            result['ForceSegTime'] = self.force_seg_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ForceSegTime') is not None:
            self.force_seg_time = m.get('ForceSegTime')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsMuxConfig(TeaModel):
    def __init__(self, segment=None):
        self.segment = segment  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsMuxConfigSegment

    def validate(self):
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsMuxConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Segment') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsVideo(TeaModel):
    def __init__(self, abr_max=None, bitrate=None, bufsize=None, codec=None, crf=None, crop=None, fps=None, gop=None,
                 height=None, long_short_mode=None, maxrate=None, pad=None, pix_fmt=None, preset=None, profile=None,
                 remove=None, scan_mode=None, width=None):
        self.abr_max = abr_max  # type: str
        self.bitrate = bitrate  # type: str
        self.bufsize = bufsize  # type: str
        self.codec = codec  # type: str
        self.crf = crf  # type: str
        self.crop = crop  # type: str
        self.fps = fps  # type: str
        self.gop = gop  # type: str
        self.height = height  # type: str
        self.long_short_mode = long_short_mode  # type: str
        self.maxrate = maxrate  # type: str
        self.pad = pad  # type: str
        self.pix_fmt = pix_fmt  # type: str
        self.preset = preset  # type: str
        self.profile = profile  # type: str
        self.remove = remove  # type: str
        self.scan_mode = scan_mode  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsVideo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abr_max is not None:
            result['AbrMax'] = self.abr_max
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.long_short_mode is not None:
            result['LongShortMode'] = self.long_short_mode
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AbrMax') is not None:
            self.abr_max = m.get('AbrMax')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('LongShortMode') is not None:
            self.long_short_mode = m.get('LongShortMode')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParams(TeaModel):
    def __init__(self, audio=None, container=None, mux_config=None, video=None):
        self.audio = audio  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsAudio
        self.container = container  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsContainer
        self.mux_config = mux_config  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsMuxConfig
        self.video = video  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsVideo

    def validate(self):
        if self.audio:
            self.audio.validate()
        if self.container:
            self.container.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.video:
            self.video.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Audio') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('Container') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('MuxConfig') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('Video') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsVideo()
            self.video = temp_model.from_map(m['Video'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscode(TeaModel):
    def __init__(self, overwrite_params=None, template_id=None):
        self.overwrite_params = overwrite_params  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParams
        self.template_id = template_id  # type: str

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscode, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfig(TeaModel):
    def __init__(self, image_watermarks=None, subtitles=None, text_watermarks=None, transcode=None):
        self.image_watermarks = image_watermarks  # type: list[GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarks]
        self.subtitles = subtitles  # type: list[GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitles]
        self.text_watermarks = text_watermarks  # type: list[GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTextWatermarks]
        self.transcode = transcode  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscode

    def validate(self):
        if self.image_watermarks:
            for k in self.image_watermarks:
                if k:
                    k.validate()
        if self.subtitles:
            for k in self.subtitles:
                if k:
                    k.validate()
        if self.text_watermarks:
            for k in self.text_watermarks:
                if k:
                    k.validate()
        if self.transcode:
            self.transcode.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageWatermarks'] = []
        if self.image_watermarks is not None:
            for k in self.image_watermarks:
                result['ImageWatermarks'].append(k.to_map() if k else None)
        result['Subtitles'] = []
        if self.subtitles is not None:
            for k in self.subtitles:
                result['Subtitles'].append(k.to_map() if k else None)
        result['TextWatermarks'] = []
        if self.text_watermarks is not None:
            for k in self.text_watermarks:
                result['TextWatermarks'].append(k.to_map() if k else None)
        if self.transcode is not None:
            result['Transcode'] = self.transcode.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.image_watermarks = []
        if m.get('ImageWatermarks') is not None:
            for k in m.get('ImageWatermarks'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarks()
                self.image_watermarks.append(temp_model.from_map(k))
        self.subtitles = []
        if m.get('Subtitles') is not None:
            for k in m.get('Subtitles'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitles()
                self.subtitles.append(temp_model.from_map(k))
        self.text_watermarks = []
        if m.get('TextWatermarks') is not None:
            for k in m.get('TextWatermarks'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTextWatermarks()
                self.text_watermarks.append(temp_model.from_map(k))
        if m.get('Transcode') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscode()
            self.transcode = temp_model.from_map(m['Transcode'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListScheduleConfig(TeaModel):
    def __init__(self, pipeline_id=None, priority=None):
        self.pipeline_id = pipeline_id  # type: str
        self.priority = priority  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListScheduleConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobList(TeaModel):
    def __init__(self, create_time=None, finish_time=None, input_group=None, job_id=None, job_index=None, name=None,
                 out_file_meta=None, output=None, parent_job_id=None, process_config=None, request_id=None, schedule_config=None,
                 status=None, submit_result_json=None, submit_time=None, user_data=None):
        self.create_time = create_time  # type: str
        self.finish_time = finish_time  # type: str
        self.input_group = input_group  # type: list[GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListInputGroup]
        self.job_id = job_id  # type: str
        self.job_index = job_index  # type: int
        self.name = name  # type: str
        self.out_file_meta = out_file_meta  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMeta
        self.output = output  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutput
        self.parent_job_id = parent_job_id  # type: str
        self.process_config = process_config  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfig
        self.request_id = request_id  # type: str
        self.schedule_config = schedule_config  # type: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListScheduleConfig
        self.status = status  # type: str
        self.submit_result_json = submit_result_json  # type: dict[str, any]
        self.submit_time = submit_time  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        if self.input_group:
            for k in self.input_group:
                if k:
                    k.validate()
        if self.out_file_meta:
            self.out_file_meta.validate()
        if self.output:
            self.output.validate()
        if self.process_config:
            self.process_config.validate()
        if self.schedule_config:
            self.schedule_config.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        result['InputGroup'] = []
        if self.input_group is not None:
            for k in self.input_group:
                result['InputGroup'].append(k.to_map() if k else None)
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_index is not None:
            result['JobIndex'] = self.job_index
        if self.name is not None:
            result['Name'] = self.name
        if self.out_file_meta is not None:
            result['OutFileMeta'] = self.out_file_meta.to_map()
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.parent_job_id is not None:
            result['ParentJobId'] = self.parent_job_id
        if self.process_config is not None:
            result['ProcessConfig'] = self.process_config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_config is not None:
            result['ScheduleConfig'] = self.schedule_config.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_result_json is not None:
            result['SubmitResultJson'] = self.submit_result_json
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        self.input_group = []
        if m.get('InputGroup') is not None:
            for k in m.get('InputGroup'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListInputGroup()
                self.input_group.append(temp_model.from_map(k))
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobIndex') is not None:
            self.job_index = m.get('JobIndex')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OutFileMeta') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMeta()
            self.out_file_meta = temp_model.from_map(m['OutFileMeta'])
        if m.get('Output') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('ParentJobId') is not None:
            self.parent_job_id = m.get('ParentJobId')
        if m.get('ProcessConfig') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfig()
            self.process_config = temp_model.from_map(m['ProcessConfig'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleConfig') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListScheduleConfig()
            self.schedule_config = temp_model.from_map(m['ScheduleConfig'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitResultJson') is not None:
            self.submit_result_json = m.get('SubmitResultJson')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJob(TeaModel):
    def __init__(self, create_time=None, finish_time=None, input_group=None, job_count=None, name=None,
                 output_group=None, parent_job_id=None, percent=None, request_id=None, schedule_config=None, status=None,
                 submit_time=None, transcode_job_list=None, trigger_source=None, user_data=None):
        self.create_time = create_time  # type: str
        self.finish_time = finish_time  # type: str
        self.input_group = input_group  # type: list[GetTranscodeJobResponseBodyTranscodeParentJobInputGroup]
        self.job_count = job_count  # type: int
        self.name = name  # type: str
        self.output_group = output_group  # type: list[GetTranscodeJobResponseBodyTranscodeParentJobOutputGroup]
        self.parent_job_id = parent_job_id  # type: str
        self.percent = percent  # type: int
        self.request_id = request_id  # type: str
        self.schedule_config = schedule_config  # type: GetTranscodeJobResponseBodyTranscodeParentJobScheduleConfig
        self.status = status  # type: str
        self.submit_time = submit_time  # type: str
        self.transcode_job_list = transcode_job_list  # type: list[GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobList]
        self.trigger_source = trigger_source  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        if self.input_group:
            for k in self.input_group:
                if k:
                    k.validate()
        if self.output_group:
            for k in self.output_group:
                if k:
                    k.validate()
        if self.schedule_config:
            self.schedule_config.validate()
        if self.transcode_job_list:
            for k in self.transcode_job_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBodyTranscodeParentJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        result['InputGroup'] = []
        if self.input_group is not None:
            for k in self.input_group:
                result['InputGroup'].append(k.to_map() if k else None)
        if self.job_count is not None:
            result['JobCount'] = self.job_count
        if self.name is not None:
            result['Name'] = self.name
        result['OutputGroup'] = []
        if self.output_group is not None:
            for k in self.output_group:
                result['OutputGroup'].append(k.to_map() if k else None)
        if self.parent_job_id is not None:
            result['ParentJobId'] = self.parent_job_id
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_config is not None:
            result['ScheduleConfig'] = self.schedule_config.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        result['TranscodeJobList'] = []
        if self.transcode_job_list is not None:
            for k in self.transcode_job_list:
                result['TranscodeJobList'].append(k.to_map() if k else None)
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        self.input_group = []
        if m.get('InputGroup') is not None:
            for k in m.get('InputGroup'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobInputGroup()
                self.input_group.append(temp_model.from_map(k))
        if m.get('JobCount') is not None:
            self.job_count = m.get('JobCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.output_group = []
        if m.get('OutputGroup') is not None:
            for k in m.get('OutputGroup'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroup()
                self.output_group.append(temp_model.from_map(k))
        if m.get('ParentJobId') is not None:
            self.parent_job_id = m.get('ParentJobId')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleConfig') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobScheduleConfig()
            self.schedule_config = temp_model.from_map(m['ScheduleConfig'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        self.transcode_job_list = []
        if m.get('TranscodeJobList') is not None:
            for k in m.get('TranscodeJobList'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobList()
                self.transcode_job_list.append(temp_model.from_map(k))
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetTranscodeJobResponseBody(TeaModel):
    def __init__(self, request_id=None, transcode_parent_job=None):
        self.request_id = request_id  # type: str
        self.transcode_parent_job = transcode_parent_job  # type: GetTranscodeJobResponseBodyTranscodeParentJob

    def validate(self):
        if self.transcode_parent_job:
            self.transcode_parent_job.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transcode_parent_job is not None:
            result['TranscodeParentJob'] = self.transcode_parent_job.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TranscodeParentJob') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJob()
            self.transcode_parent_job = temp_model.from_map(m['TranscodeParentJob'])
        return self


class GetTranscodeJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetTranscodeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetTranscodeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTranscodeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUrlUploadInfosRequest(TeaModel):
    def __init__(self, job_ids=None, upload_urls=None):
        self.job_ids = job_ids  # type: str
        self.upload_urls = upload_urls  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetUrlUploadInfosRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.upload_urls is not None:
            result['UploadURLs'] = self.upload_urls
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('UploadURLs') is not None:
            self.upload_urls = m.get('UploadURLs')
        return self


class GetUrlUploadInfosResponseBodyURLUploadInfoList(TeaModel):
    def __init__(self, complete_time=None, creation_time=None, error_code=None, error_message=None, file_size=None,
                 job_id=None, media_id=None, status=None, upload_url=None, user_data=None):
        self.complete_time = complete_time  # type: str
        self.creation_time = creation_time  # type: str
        self.error_code = error_code  # type: str
        self.error_message = error_message  # type: str
        self.file_size = file_size  # type: str
        self.job_id = job_id  # type: str
        self.media_id = media_id  # type: str
        self.status = status  # type: str
        self.upload_url = upload_url  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetUrlUploadInfosResponseBodyURLUploadInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.status is not None:
            result['Status'] = self.status
        if self.upload_url is not None:
            result['UploadURL'] = self.upload_url
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UploadURL') is not None:
            self.upload_url = m.get('UploadURL')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetUrlUploadInfosResponseBody(TeaModel):
    def __init__(self, non_exists=None, request_id=None, urlupload_info_list=None):
        self.non_exists = non_exists  # type: list[str]
        self.request_id = request_id  # type: str
        self.urlupload_info_list = urlupload_info_list  # type: list[GetUrlUploadInfosResponseBodyURLUploadInfoList]

    def validate(self):
        if self.urlupload_info_list:
            for k in self.urlupload_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetUrlUploadInfosResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exists is not None:
            result['NonExists'] = self.non_exists
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['URLUploadInfoList'] = []
        if self.urlupload_info_list is not None:
            for k in self.urlupload_info_list:
                result['URLUploadInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NonExists') is not None:
            self.non_exists = m.get('NonExists')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.urlupload_info_list = []
        if m.get('URLUploadInfoList') is not None:
            for k in m.get('URLUploadInfoList'):
                temp_model = GetUrlUploadInfosResponseBodyURLUploadInfoList()
                self.urlupload_info_list.append(temp_model.from_map(k))
        return self


class GetUrlUploadInfosResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetUrlUploadInfosResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetUrlUploadInfosResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetUrlUploadInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAllPublicMediaTagsRequest(TeaModel):
    def __init__(self, business_type=None, entity_id=None):
        self.business_type = business_type  # type: str
        self.entity_id = entity_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAllPublicMediaTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        return self


class ListAllPublicMediaTagsResponseBodyMediaTagListOptions(TeaModel):
    def __init__(self, option_chinese_name=None, option_english_name=None, option_id=None):
        self.option_chinese_name = option_chinese_name  # type: str
        self.option_english_name = option_english_name  # type: str
        self.option_id = option_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAllPublicMediaTagsResponseBodyMediaTagListOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.option_chinese_name is not None:
            result['OptionChineseName'] = self.option_chinese_name
        if self.option_english_name is not None:
            result['OptionEnglishName'] = self.option_english_name
        if self.option_id is not None:
            result['OptionId'] = self.option_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OptionChineseName') is not None:
            self.option_chinese_name = m.get('OptionChineseName')
        if m.get('OptionEnglishName') is not None:
            self.option_english_name = m.get('OptionEnglishName')
        if m.get('OptionId') is not None:
            self.option_id = m.get('OptionId')
        return self


class ListAllPublicMediaTagsResponseBodyMediaTagList(TeaModel):
    def __init__(self, media_tag_id=None, media_tag_name_chinese=None, media_tag_name_english=None, options=None):
        self.media_tag_id = media_tag_id  # type: str
        self.media_tag_name_chinese = media_tag_name_chinese  # type: str
        self.media_tag_name_english = media_tag_name_english  # type: str
        self.options = options  # type: list[ListAllPublicMediaTagsResponseBodyMediaTagListOptions]

    def validate(self):
        if self.options:
            for k in self.options:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAllPublicMediaTagsResponseBodyMediaTagList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_tag_id is not None:
            result['MediaTagId'] = self.media_tag_id
        if self.media_tag_name_chinese is not None:
            result['MediaTagNameChinese'] = self.media_tag_name_chinese
        if self.media_tag_name_english is not None:
            result['MediaTagNameEnglish'] = self.media_tag_name_english
        result['Options'] = []
        if self.options is not None:
            for k in self.options:
                result['Options'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MediaTagId') is not None:
            self.media_tag_id = m.get('MediaTagId')
        if m.get('MediaTagNameChinese') is not None:
            self.media_tag_name_chinese = m.get('MediaTagNameChinese')
        if m.get('MediaTagNameEnglish') is not None:
            self.media_tag_name_english = m.get('MediaTagNameEnglish')
        self.options = []
        if m.get('Options') is not None:
            for k in m.get('Options'):
                temp_model = ListAllPublicMediaTagsResponseBodyMediaTagListOptions()
                self.options.append(temp_model.from_map(k))
        return self


class ListAllPublicMediaTagsResponseBody(TeaModel):
    def __init__(self, media_tag_list=None, request_id=None):
        self.media_tag_list = media_tag_list  # type: list[ListAllPublicMediaTagsResponseBodyMediaTagList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.media_tag_list:
            for k in self.media_tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAllPublicMediaTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaTagList'] = []
        if self.media_tag_list is not None:
            for k in self.media_tag_list:
                result['MediaTagList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.media_tag_list = []
        if m.get('MediaTagList') is not None:
            for k in m.get('MediaTagList'):
                temp_model = ListAllPublicMediaTagsResponseBodyMediaTagList()
                self.media_tag_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAllPublicMediaTagsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAllPublicMediaTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAllPublicMediaTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAllPublicMediaTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCustomTemplatesRequest(TeaModel):
    def __init__(self, name=None, order_by=None, page_number=None, page_size=None, subtype=None, template_id=None,
                 type=None):
        self.name = name  # type: str
        self.order_by = order_by  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.subtype = subtype  # type: str
        self.template_id = template_id  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCustomTemplatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListCustomTemplatesResponseBodyCustomTemplateList(TeaModel):
    def __init__(self, create_time=None, is_default=None, modified_time=None, status=None, subtype=None,
                 subtype_name=None, template_config=None, template_id=None, template_name=None, type=None, type_name=None):
        self.create_time = create_time  # type: str
        self.is_default = is_default  # type: bool
        self.modified_time = modified_time  # type: str
        self.status = status  # type: str
        self.subtype = subtype  # type: int
        self.subtype_name = subtype_name  # type: str
        self.template_config = template_config  # type: str
        self.template_id = template_id  # type: str
        self.template_name = template_name  # type: str
        self.type = type  # type: int
        self.type_name = type_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCustomTemplatesResponseBodyCustomTemplateList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.status is not None:
            result['Status'] = self.status
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.subtype_name is not None:
            result['SubtypeName'] = self.subtype_name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.type is not None:
            result['Type'] = self.type
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('SubtypeName') is not None:
            self.subtype_name = m.get('SubtypeName')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        return self


class ListCustomTemplatesResponseBody(TeaModel):
    def __init__(self, custom_template_list=None, request_id=None, total=None):
        self.custom_template_list = custom_template_list  # type: list[ListCustomTemplatesResponseBodyCustomTemplateList]
        self.request_id = request_id  # type: str
        self.total = total  # type: int

    def validate(self):
        if self.custom_template_list:
            for k in self.custom_template_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCustomTemplatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomTemplateList'] = []
        if self.custom_template_list is not None:
            for k in self.custom_template_list:
                result['CustomTemplateList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.custom_template_list = []
        if m.get('CustomTemplateList') is not None:
            for k in m.get('CustomTemplateList'):
                temp_model = ListCustomTemplatesResponseBodyCustomTemplateList()
                self.custom_template_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListCustomTemplatesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCustomTemplatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCustomTemplatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCustomTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDynamicImageJobsRequest(TeaModel):
    def __init__(self, end_of_create_time=None, job_id=None, next_page_token=None, order_by=None, page_size=None,
                 start_of_create_time=None, status=None):
        self.end_of_create_time = end_of_create_time  # type: str
        self.job_id = job_id  # type: str
        self.next_page_token = next_page_token  # type: str
        self.order_by = order_by  # type: str
        self.page_size = page_size  # type: int
        self.start_of_create_time = start_of_create_time  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDynamicImageJobsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_of_create_time is not None:
            result['EndOfCreateTime'] = self.end_of_create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_of_create_time is not None:
            result['StartOfCreateTime'] = self.start_of_create_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndOfCreateTime') is not None:
            self.end_of_create_time = m.get('EndOfCreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartOfCreateTime') is not None:
            self.start_of_create_time = m.get('StartOfCreateTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListDynamicImageJobsResponseBodyJobsInput(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDynamicImageJobsResponseBodyJobsInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListDynamicImageJobsResponseBodyJobsOutput(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDynamicImageJobsResponseBodyJobsOutput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListDynamicImageJobsResponseBodyJobs(TeaModel):
    def __init__(self, create_time=None, finish_time=None, input=None, job_id=None, modified_time=None, name=None,
                 output=None, pipeline_id=None, status=None, submit_time=None, template_id=None, trigger_source=None):
        self.create_time = create_time  # type: str
        self.finish_time = finish_time  # type: str
        self.input = input  # type: ListDynamicImageJobsResponseBodyJobsInput
        self.job_id = job_id  # type: str
        self.modified_time = modified_time  # type: str
        self.name = name  # type: str
        self.output = output  # type: ListDynamicImageJobsResponseBodyJobsOutput
        self.pipeline_id = pipeline_id  # type: str
        self.status = status  # type: str
        self.submit_time = submit_time  # type: str
        self.template_id = template_id  # type: str
        self.trigger_source = trigger_source  # type: str

    def validate(self):
        if self.input:
            self.input.validate()
        if self.output:
            self.output.validate()

    def to_map(self):
        _map = super(ListDynamicImageJobsResponseBodyJobs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = ListDynamicImageJobsResponseBodyJobsInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Output') is not None:
            temp_model = ListDynamicImageJobsResponseBodyJobsOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        return self


class ListDynamicImageJobsResponseBody(TeaModel):
    def __init__(self, jobs=None, next_page_token=None, request_id=None):
        self.jobs = jobs  # type: list[ListDynamicImageJobsResponseBodyJobs]
        self.next_page_token = next_page_token  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDynamicImageJobsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['Jobs'].append(k.to_map() if k else None)
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.jobs = []
        if m.get('Jobs') is not None:
            for k in m.get('Jobs'):
                temp_model = ListDynamicImageJobsResponseBodyJobs()
                self.jobs.append(temp_model.from_map(k))
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDynamicImageJobsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListDynamicImageJobsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDynamicImageJobsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDynamicImageJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLiveRecordFilesRequest(TeaModel):
    def __init__(self, end_time=None, job_ids=None, page_no=None, page_size=None, record_format=None, sort_by=None,
                 start_time=None):
        self.end_time = end_time  # type: str
        self.job_ids = job_ids  # type: list[str]
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.record_format = record_format  # type: str
        self.sort_by = sort_by  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveRecordFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.record_format is not None:
            result['RecordFormat'] = self.record_format
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RecordFormat') is not None:
            self.record_format = m.get('RecordFormat')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListLiveRecordFilesResponseBodyFiles(TeaModel):
    def __init__(self, create_time=None, duration=None, end_time=None, format=None, height=None, job_id=None,
                 job_name=None, record_id=None, record_output=None, record_url=None, start_time=None, stream_url=None,
                 width=None):
        self.create_time = create_time  # type: str
        self.duration = duration  # type: float
        self.end_time = end_time  # type: str
        self.format = format  # type: str
        self.height = height  # type: int
        self.job_id = job_id  # type: str
        self.job_name = job_name  # type: str
        self.record_id = record_id  # type: str
        self.record_output = record_output  # type: str
        self.record_url = record_url  # type: str
        self.start_time = start_time  # type: str
        self.stream_url = stream_url  # type: str
        self.width = width  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveRecordFilesResponseBodyFiles, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.format is not None:
            result['Format'] = self.format
        if self.height is not None:
            result['Height'] = self.height
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.record_output is not None:
            result['RecordOutput'] = self.record_output
        if self.record_url is not None:
            result['RecordUrl'] = self.record_url
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RecordOutput') is not None:
            self.record_output = m.get('RecordOutput')
        if m.get('RecordUrl') is not None:
            self.record_url = m.get('RecordUrl')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListLiveRecordFilesResponseBody(TeaModel):
    def __init__(self, files=None, page_no=None, page_size=None, request_id=None, sort_by=None, total_count=None):
        self.files = files  # type: list[ListLiveRecordFilesResponseBodyFiles]
        self.page_no = page_no  # type: long
        self.page_size = page_size  # type: str
        self.request_id = request_id  # type: str
        self.sort_by = sort_by  # type: str
        self.total_count = total_count  # type: str

    def validate(self):
        if self.files:
            for k in self.files:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListLiveRecordFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Files'] = []
        if self.files is not None:
            for k in self.files:
                result['Files'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.files = []
        if m.get('Files') is not None:
            for k in m.get('Files'):
                temp_model = ListLiveRecordFilesResponseBodyFiles()
                self.files.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListLiveRecordFilesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListLiveRecordFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListLiveRecordFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListLiveRecordFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLiveRecordJobsRequest(TeaModel):
    def __init__(self, end_time=None, keyword=None, page_no=None, page_size=None, sort_by=None, start_time=None,
                 status=None):
        self.end_time = end_time  # type: str
        self.keyword = keyword  # type: str
        self.page_no = page_no  # type: long
        self.page_size = page_size  # type: long
        self.sort_by = sort_by  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveRecordJobsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListLiveRecordJobsResponseBodyLiveRecordJobsRecordOutput(TeaModel):
    def __init__(self, bucket=None, endpoint=None, type=None):
        self.bucket = bucket  # type: str
        self.endpoint = endpoint  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveRecordJobsResponseBodyLiveRecordJobsRecordOutput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListLiveRecordJobsResponseBodyLiveRecordJobsStreamInput(TeaModel):
    def __init__(self, type=None, url=None):
        self.type = type  # type: str
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveRecordJobsResponseBodyLiveRecordJobsStreamInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class ListLiveRecordJobsResponseBodyLiveRecordJobs(TeaModel):
    def __init__(self, create_time=None, job_id=None, name=None, notify_url=None, record_output=None, status=None,
                 stream_input=None, template_id=None, template_name=None):
        self.create_time = create_time  # type: str
        self.job_id = job_id  # type: str
        self.name = name  # type: str
        self.notify_url = notify_url  # type: str
        self.record_output = record_output  # type: ListLiveRecordJobsResponseBodyLiveRecordJobsRecordOutput
        self.status = status  # type: str
        self.stream_input = stream_input  # type: ListLiveRecordJobsResponseBodyLiveRecordJobsStreamInput
        self.template_id = template_id  # type: str
        self.template_name = template_name  # type: str

    def validate(self):
        if self.record_output:
            self.record_output.validate()
        if self.stream_input:
            self.stream_input.validate()

    def to_map(self):
        _map = super(ListLiveRecordJobsResponseBodyLiveRecordJobs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.name is not None:
            result['Name'] = self.name
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        if self.record_output is not None:
            result['RecordOutput'] = self.record_output.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.stream_input is not None:
            result['StreamInput'] = self.stream_input.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        if m.get('RecordOutput') is not None:
            temp_model = ListLiveRecordJobsResponseBodyLiveRecordJobsRecordOutput()
            self.record_output = temp_model.from_map(m['RecordOutput'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StreamInput') is not None:
            temp_model = ListLiveRecordJobsResponseBodyLiveRecordJobsStreamInput()
            self.stream_input = temp_model.from_map(m['StreamInput'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        return self


class ListLiveRecordJobsResponseBody(TeaModel):
    def __init__(self, live_record_jobs=None, page_no=None, page_size=None, request_id=None, sort_by=None,
                 total_count=None):
        self.live_record_jobs = live_record_jobs  # type: list[ListLiveRecordJobsResponseBodyLiveRecordJobs]
        self.page_no = page_no  # type: long
        self.page_size = page_size  # type: long
        self.request_id = request_id  # type: str
        self.sort_by = sort_by  # type: str
        self.total_count = total_count  # type: long

    def validate(self):
        if self.live_record_jobs:
            for k in self.live_record_jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListLiveRecordJobsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveRecordJobs'] = []
        if self.live_record_jobs is not None:
            for k in self.live_record_jobs:
                result['LiveRecordJobs'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_record_jobs = []
        if m.get('LiveRecordJobs') is not None:
            for k in m.get('LiveRecordJobs'):
                temp_model = ListLiveRecordJobsResponseBodyLiveRecordJobs()
                self.live_record_jobs.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListLiveRecordJobsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListLiveRecordJobsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListLiveRecordJobsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListLiveRecordJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLiveRecordTemplatesRequest(TeaModel):
    def __init__(self, keyword=None, page_no=None, page_size=None, sort_by=None, template_ids=None, type=None):
        self.keyword = keyword  # type: str
        self.page_no = page_no  # type: long
        self.page_size = page_size  # type: long
        self.sort_by = sort_by  # type: str
        self.template_ids = template_ids  # type: list[str]
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveRecordTemplatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.template_ids is not None:
            result['TemplateIds'] = self.template_ids
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('TemplateIds') is not None:
            self.template_ids = m.get('TemplateIds')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListLiveRecordTemplatesResponseBodyRecordTemplateListRecordFormatList(TeaModel):
    def __init__(self, cycle_duration=None, format=None, oss_object_prefix=None, slice_duration=None,
                 slice_oss_object_prefix=None):
        self.cycle_duration = cycle_duration  # type: int
        self.format = format  # type: str
        self.oss_object_prefix = oss_object_prefix  # type: str
        self.slice_duration = slice_duration  # type: int
        self.slice_oss_object_prefix = slice_oss_object_prefix  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveRecordTemplatesResponseBodyRecordTemplateListRecordFormatList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.format is not None:
            result['Format'] = self.format
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.slice_duration is not None:
            result['SliceDuration'] = self.slice_duration
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('SliceDuration') is not None:
            self.slice_duration = m.get('SliceDuration')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        return self


class ListLiveRecordTemplatesResponseBodyRecordTemplateList(TeaModel):
    def __init__(self, create_time=None, last_modified=None, name=None, record_format_list=None, template_id=None,
                 type=None):
        self.create_time = create_time  # type: str
        self.last_modified = last_modified  # type: str
        self.name = name  # type: str
        self.record_format_list = record_format_list  # type: list[ListLiveRecordTemplatesResponseBodyRecordTemplateListRecordFormatList]
        self.template_id = template_id  # type: str
        self.type = type  # type: str

    def validate(self):
        if self.record_format_list:
            for k in self.record_format_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListLiveRecordTemplatesResponseBodyRecordTemplateList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_modified is not None:
            result['LastModified'] = self.last_modified
        if self.name is not None:
            result['Name'] = self.name
        result['RecordFormatList'] = []
        if self.record_format_list is not None:
            for k in self.record_format_list:
                result['RecordFormatList'].append(k.to_map() if k else None)
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastModified') is not None:
            self.last_modified = m.get('LastModified')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.record_format_list = []
        if m.get('RecordFormatList') is not None:
            for k in m.get('RecordFormatList'):
                temp_model = ListLiveRecordTemplatesResponseBodyRecordTemplateListRecordFormatList()
                self.record_format_list.append(temp_model.from_map(k))
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListLiveRecordTemplatesResponseBody(TeaModel):
    def __init__(self, page_no=None, page_size=None, record_template_list=None, request_id=None, sort_by=None,
                 total_count=None):
        self.page_no = page_no  # type: long
        self.page_size = page_size  # type: long
        self.record_template_list = record_template_list  # type: list[ListLiveRecordTemplatesResponseBodyRecordTemplateList]
        self.request_id = request_id  # type: str
        self.sort_by = sort_by  # type: str
        self.total_count = total_count  # type: long

    def validate(self):
        if self.record_template_list:
            for k in self.record_template_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListLiveRecordTemplatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['RecordTemplateList'] = []
        if self.record_template_list is not None:
            for k in self.record_template_list:
                result['RecordTemplateList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.record_template_list = []
        if m.get('RecordTemplateList') is not None:
            for k in m.get('RecordTemplateList'):
                temp_model = ListLiveRecordTemplatesResponseBodyRecordTemplateList()
                self.record_template_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListLiveRecordTemplatesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListLiveRecordTemplatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListLiveRecordTemplatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListLiveRecordTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLiveSnapshotFilesRequest(TeaModel):
    def __init__(self, end_time=None, job_id=None, limit=None, sort_by=None, start_time=None):
        self.end_time = end_time  # type: str
        self.job_id = job_id  # type: str
        self.limit = limit  # type: int
        self.sort_by = sort_by  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveSnapshotFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListLiveSnapshotFilesResponseBodyFileList(TeaModel):
    def __init__(self, create_time=None, create_timestamp=None, is_overlay=None, oss_bucket=None, oss_endpoint=None,
                 oss_object=None):
        self.create_time = create_time  # type: str
        self.create_timestamp = create_timestamp  # type: long
        self.is_overlay = is_overlay  # type: bool
        self.oss_bucket = oss_bucket  # type: str
        self.oss_endpoint = oss_endpoint  # type: str
        self.oss_object = oss_object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveSnapshotFilesResponseBodyFileList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.is_overlay is not None:
            result['IsOverlay'] = self.is_overlay
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('IsOverlay') is not None:
            self.is_overlay = m.get('IsOverlay')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        return self


class ListLiveSnapshotFilesResponseBody(TeaModel):
    def __init__(self, file_list=None, next_start_time=None, request_id=None):
        self.file_list = file_list  # type: list[ListLiveSnapshotFilesResponseBodyFileList]
        self.next_start_time = next_start_time  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.file_list:
            for k in self.file_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListLiveSnapshotFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileList'] = []
        if self.file_list is not None:
            for k in self.file_list:
                result['FileList'].append(k.to_map() if k else None)
        if self.next_start_time is not None:
            result['NextStartTime'] = self.next_start_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.file_list = []
        if m.get('FileList') is not None:
            for k in m.get('FileList'):
                temp_model = ListLiveSnapshotFilesResponseBodyFileList()
                self.file_list.append(temp_model.from_map(k))
        if m.get('NextStartTime') is not None:
            self.next_start_time = m.get('NextStartTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListLiveSnapshotFilesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListLiveSnapshotFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListLiveSnapshotFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListLiveSnapshotFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLiveSnapshotJobsRequest(TeaModel):
    def __init__(self, end_time=None, page_no=None, page_size=None, search_key_word=None, sort_by=None,
                 start_time=None, status=None):
        self.end_time = end_time  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.search_key_word = search_key_word  # type: str
        self.sort_by = sort_by  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveSnapshotJobsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_key_word is not None:
            result['SearchKeyWord'] = self.search_key_word
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchKeyWord') is not None:
            self.search_key_word = m.get('SearchKeyWord')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListLiveSnapshotJobsResponseBodyJobListSnapshotOutput(TeaModel):
    def __init__(self, bucket=None, endpoint=None, storage_type=None):
        self.bucket = bucket  # type: str
        self.endpoint = endpoint  # type: str
        self.storage_type = storage_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveSnapshotJobsResponseBodyJobListSnapshotOutput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class ListLiveSnapshotJobsResponseBodyJobList(TeaModel):
    def __init__(self, create_time=None, job_id=None, job_name=None, snapshot_output=None, status=None,
                 template_id=None, template_name=None, time_interval=None):
        self.create_time = create_time  # type: str
        self.job_id = job_id  # type: str
        self.job_name = job_name  # type: str
        self.snapshot_output = snapshot_output  # type: ListLiveSnapshotJobsResponseBodyJobListSnapshotOutput
        self.status = status  # type: str
        self.template_id = template_id  # type: str
        self.template_name = template_name  # type: str
        self.time_interval = time_interval  # type: int

    def validate(self):
        if self.snapshot_output:
            self.snapshot_output.validate()

    def to_map(self):
        _map = super(ListLiveSnapshotJobsResponseBodyJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.snapshot_output is not None:
            result['SnapshotOutput'] = self.snapshot_output.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.time_interval is not None:
            result['TimeInterval'] = self.time_interval
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('SnapshotOutput') is not None:
            temp_model = ListLiveSnapshotJobsResponseBodyJobListSnapshotOutput()
            self.snapshot_output = temp_model.from_map(m['SnapshotOutput'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TimeInterval') is not None:
            self.time_interval = m.get('TimeInterval')
        return self


class ListLiveSnapshotJobsResponseBody(TeaModel):
    def __init__(self, job_list=None, page_no=None, page_size=None, request_id=None, sort_by=None, total_count=None):
        self.job_list = job_list  # type: list[ListLiveSnapshotJobsResponseBodyJobList]
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.sort_by = sort_by  # type: str
        self.total_count = total_count  # type: long

    def validate(self):
        if self.job_list:
            for k in self.job_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListLiveSnapshotJobsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['JobList'] = []
        if self.job_list is not None:
            for k in self.job_list:
                result['JobList'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.job_list = []
        if m.get('JobList') is not None:
            for k in m.get('JobList'):
                temp_model = ListLiveSnapshotJobsResponseBodyJobList()
                self.job_list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListLiveSnapshotJobsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListLiveSnapshotJobsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListLiveSnapshotJobsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListLiveSnapshotJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLiveSnapshotTemplatesRequest(TeaModel):
    def __init__(self, page_no=None, page_size=None, search_key_word=None, sort_by=None, template_ids=None,
                 type=None):
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.search_key_word = search_key_word  # type: str
        self.sort_by = sort_by  # type: str
        self.template_ids = template_ids  # type: list[str]
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveSnapshotTemplatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_key_word is not None:
            result['SearchKeyWord'] = self.search_key_word
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.template_ids is not None:
            result['TemplateIds'] = self.template_ids
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchKeyWord') is not None:
            self.search_key_word = m.get('SearchKeyWord')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('TemplateIds') is not None:
            self.template_ids = m.get('TemplateIds')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListLiveSnapshotTemplatesResponseBodyTemplateList(TeaModel):
    def __init__(self, create_time=None, template_id=None, template_name=None, time_interval=None, type=None):
        self.create_time = create_time  # type: str
        self.template_id = template_id  # type: str
        self.template_name = template_name  # type: str
        self.time_interval = time_interval  # type: int
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveSnapshotTemplatesResponseBodyTemplateList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.time_interval is not None:
            result['TimeInterval'] = self.time_interval
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TimeInterval') is not None:
            self.time_interval = m.get('TimeInterval')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListLiveSnapshotTemplatesResponseBody(TeaModel):
    def __init__(self, page_no=None, page_size=None, request_id=None, sort_by=None, template_list=None,
                 total_count=None):
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.sort_by = sort_by  # type: str
        self.template_list = template_list  # type: list[ListLiveSnapshotTemplatesResponseBodyTemplateList]
        self.total_count = total_count  # type: long

    def validate(self):
        if self.template_list:
            for k in self.template_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListLiveSnapshotTemplatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        result['TemplateList'] = []
        if self.template_list is not None:
            for k in self.template_list:
                result['TemplateList'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        self.template_list = []
        if m.get('TemplateList') is not None:
            for k in m.get('TemplateList'):
                temp_model = ListLiveSnapshotTemplatesResponseBodyTemplateList()
                self.template_list.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListLiveSnapshotTemplatesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListLiveSnapshotTemplatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListLiveSnapshotTemplatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListLiveSnapshotTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLiveTranscodeJobsRequest(TeaModel):
    def __init__(self, key_word=None, page_no=None, page_size=None, sort_by=None, start_mode=None, status=None,
                 type=None):
        self.key_word = key_word  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.sort_by = sort_by  # type: str
        self.start_mode = start_mode  # type: int
        self.status = status  # type: int
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveTranscodeJobsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_word is not None:
            result['KeyWord'] = self.key_word
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.start_mode is not None:
            result['StartMode'] = self.start_mode
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('KeyWord') is not None:
            self.key_word = m.get('KeyWord')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('StartMode') is not None:
            self.start_mode = m.get('StartMode')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListLiveTranscodeJobsResponseBodyJobListOutputStreamStreamInfos(TeaModel):
    def __init__(self, output_url=None, type=None):
        self.output_url = output_url  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveTranscodeJobsResponseBodyJobListOutputStreamStreamInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_url is not None:
            result['OutputUrl'] = self.output_url
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OutputUrl') is not None:
            self.output_url = m.get('OutputUrl')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListLiveTranscodeJobsResponseBodyJobListOutputStream(TeaModel):
    def __init__(self, stream_infos=None):
        self.stream_infos = stream_infos  # type: list[ListLiveTranscodeJobsResponseBodyJobListOutputStreamStreamInfos]

    def validate(self):
        if self.stream_infos:
            for k in self.stream_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListLiveTranscodeJobsResponseBodyJobListOutputStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['StreamInfos'] = []
        if self.stream_infos is not None:
            for k in self.stream_infos:
                result['StreamInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.stream_infos = []
        if m.get('StreamInfos') is not None:
            for k in m.get('StreamInfos'):
                temp_model = ListLiveTranscodeJobsResponseBodyJobListOutputStreamStreamInfos()
                self.stream_infos.append(temp_model.from_map(k))
        return self


class ListLiveTranscodeJobsResponseBodyJobListStreamInput(TeaModel):
    def __init__(self, input_url=None, type=None):
        self.input_url = input_url  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveTranscodeJobsResponseBodyJobListStreamInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_url is not None:
            result['InputUrl'] = self.input_url
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InputUrl') is not None:
            self.input_url = m.get('InputUrl')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListLiveTranscodeJobsResponseBodyJobList(TeaModel):
    def __init__(self, create_time=None, job_id=None, name=None, output_stream=None, start_mode=None, status=None,
                 stream_input=None, template_id=None, template_name=None, template_type=None):
        self.create_time = create_time  # type: str
        self.job_id = job_id  # type: str
        self.name = name  # type: str
        self.output_stream = output_stream  # type: ListLiveTranscodeJobsResponseBodyJobListOutputStream
        self.start_mode = start_mode  # type: int
        self.status = status  # type: int
        self.stream_input = stream_input  # type: ListLiveTranscodeJobsResponseBodyJobListStreamInput
        self.template_id = template_id  # type: str
        self.template_name = template_name  # type: str
        self.template_type = template_type  # type: str

    def validate(self):
        if self.output_stream:
            self.output_stream.validate()
        if self.stream_input:
            self.stream_input.validate()

    def to_map(self):
        _map = super(ListLiveTranscodeJobsResponseBodyJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.name is not None:
            result['Name'] = self.name
        if self.output_stream is not None:
            result['OutputStream'] = self.output_stream.to_map()
        if self.start_mode is not None:
            result['StartMode'] = self.start_mode
        if self.status is not None:
            result['Status'] = self.status
        if self.stream_input is not None:
            result['StreamInput'] = self.stream_input.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OutputStream') is not None:
            temp_model = ListLiveTranscodeJobsResponseBodyJobListOutputStream()
            self.output_stream = temp_model.from_map(m['OutputStream'])
        if m.get('StartMode') is not None:
            self.start_mode = m.get('StartMode')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StreamInput') is not None:
            temp_model = ListLiveTranscodeJobsResponseBodyJobListStreamInput()
            self.stream_input = temp_model.from_map(m['StreamInput'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        return self


class ListLiveTranscodeJobsResponseBody(TeaModel):
    def __init__(self, job_list=None, request_id=None, total_count=None):
        self.job_list = job_list  # type: list[ListLiveTranscodeJobsResponseBodyJobList]
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.job_list:
            for k in self.job_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListLiveTranscodeJobsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['JobList'] = []
        if self.job_list is not None:
            for k in self.job_list:
                result['JobList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.job_list = []
        if m.get('JobList') is not None:
            for k in m.get('JobList'):
                temp_model = ListLiveTranscodeJobsResponseBodyJobList()
                self.job_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListLiveTranscodeJobsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListLiveTranscodeJobsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListLiveTranscodeJobsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListLiveTranscodeJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLiveTranscodeTemplatesRequest(TeaModel):
    def __init__(self, category=None, key_word=None, page_no=None, page_size=None, sort_by=None, type=None,
                 video_codec=None):
        self.category = category  # type: str
        self.key_word = key_word  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.sort_by = sort_by  # type: str
        self.type = type  # type: str
        self.video_codec = video_codec  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveTranscodeTemplatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.key_word is not None:
            result['KeyWord'] = self.key_word
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.type is not None:
            result['Type'] = self.type
        if self.video_codec is not None:
            result['VideoCodec'] = self.video_codec
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('KeyWord') is not None:
            self.key_word = m.get('KeyWord')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VideoCodec') is not None:
            self.video_codec = m.get('VideoCodec')
        return self


class ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfigAudioParams(TeaModel):
    def __init__(self, bitrate=None, channels=None, codec=None, profile=None, samplerate=None):
        self.bitrate = bitrate  # type: str
        self.channels = channels  # type: str
        self.codec = codec  # type: str
        self.profile = profile  # type: str
        self.samplerate = samplerate  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfigAudioParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        return self


class ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfigVideoParams(TeaModel):
    def __init__(self, bitrate=None, codec=None, fps=None, gop=None, height=None, profile=None, width=None):
        self.bitrate = bitrate  # type: str
        self.codec = codec  # type: str
        self.fps = fps  # type: str
        self.gop = gop  # type: str
        self.height = height  # type: str
        self.profile = profile  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfigVideoParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfig(TeaModel):
    def __init__(self, audio_params=None, video_params=None):
        self.audio_params = audio_params  # type: ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfigAudioParams
        self.video_params = video_params  # type: ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfigVideoParams

    def validate(self):
        if self.audio_params:
            self.audio_params.validate()
        if self.video_params:
            self.video_params.validate()

    def to_map(self):
        _map = super(ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_params is not None:
            result['AudioParams'] = self.audio_params.to_map()
        if self.video_params is not None:
            result['VideoParams'] = self.video_params.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioParams') is not None:
            temp_model = ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfigAudioParams()
            self.audio_params = temp_model.from_map(m['AudioParams'])
        if m.get('VideoParams') is not None:
            temp_model = ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfigVideoParams()
            self.video_params = temp_model.from_map(m['VideoParams'])
        return self


class ListLiveTranscodeTemplatesResponseBodyTemplateContentList(TeaModel):
    def __init__(self, category=None, create_time=None, name=None, template_config=None, template_id=None, type=None):
        self.category = category  # type: str
        self.create_time = create_time  # type: str
        self.name = name  # type: str
        self.template_config = template_config  # type: ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfig
        self.template_id = template_id  # type: str
        self.type = type  # type: str

    def validate(self):
        if self.template_config:
            self.template_config.validate()

    def to_map(self):
        _map = super(ListLiveTranscodeTemplatesResponseBodyTemplateContentList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.name is not None:
            result['Name'] = self.name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TemplateConfig') is not None:
            temp_model = ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfig()
            self.template_config = temp_model.from_map(m['TemplateConfig'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListLiveTranscodeTemplatesResponseBody(TeaModel):
    def __init__(self, request_id=None, template_content_list=None, total_count=None):
        self.request_id = request_id  # type: str
        self.template_content_list = template_content_list  # type: list[ListLiveTranscodeTemplatesResponseBodyTemplateContentList]
        self.total_count = total_count  # type: int

    def validate(self):
        if self.template_content_list:
            for k in self.template_content_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListLiveTranscodeTemplatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TemplateContentList'] = []
        if self.template_content_list is not None:
            for k in self.template_content_list:
                result['TemplateContentList'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.template_content_list = []
        if m.get('TemplateContentList') is not None:
            for k in m.get('TemplateContentList'):
                temp_model = ListLiveTranscodeTemplatesResponseBodyTemplateContentList()
                self.template_content_list.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListLiveTranscodeTemplatesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListLiveTranscodeTemplatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListLiveTranscodeTemplatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListLiveTranscodeTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMediaBasicInfosRequest(TeaModel):
    def __init__(self, business_type=None, end_time=None, include_file_basic_info=None, max_results=None,
                 media_id=None, media_type=None, next_token=None, sort_by=None, source=None, start_time=None, status=None):
        self.business_type = business_type  # type: str
        self.end_time = end_time  # type: str
        self.include_file_basic_info = include_file_basic_info  # type: bool
        self.max_results = max_results  # type: int
        self.media_id = media_id  # type: str
        self.media_type = media_type  # type: str
        self.next_token = next_token  # type: str
        self.sort_by = sort_by  # type: str
        self.source = source  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMediaBasicInfosRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.include_file_basic_info is not None:
            result['IncludeFileBasicInfo'] = self.include_file_basic_info
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.source is not None:
            result['Source'] = self.source
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IncludeFileBasicInfo') is not None:
            self.include_file_basic_info = m.get('IncludeFileBasicInfo')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListMediaBasicInfosResponseBodyMediaInfosFileInfoListFileBasicInfo(TeaModel):
    def __init__(self, bitrate=None, create_time=None, duration=None, file_name=None, file_size=None,
                 file_status=None, file_type=None, file_url=None, format_name=None, height=None, modified_time=None, region=None,
                 width=None):
        self.bitrate = bitrate  # type: str
        self.create_time = create_time  # type: str
        self.duration = duration  # type: str
        self.file_name = file_name  # type: str
        self.file_size = file_size  # type: str
        self.file_status = file_status  # type: str
        self.file_type = file_type  # type: str
        self.file_url = file_url  # type: str
        self.format_name = format_name  # type: str
        self.height = height  # type: str
        self.modified_time = modified_time  # type: str
        self.region = region  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMediaBasicInfosResponseBodyMediaInfosFileInfoListFileBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListMediaBasicInfosResponseBodyMediaInfosFileInfoList(TeaModel):
    def __init__(self, file_basic_info=None):
        self.file_basic_info = file_basic_info  # type: ListMediaBasicInfosResponseBodyMediaInfosFileInfoListFileBasicInfo

    def validate(self):
        if self.file_basic_info:
            self.file_basic_info.validate()

    def to_map(self):
        _map = super(ListMediaBasicInfosResponseBodyMediaInfosFileInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileBasicInfo') is not None:
            temp_model = ListMediaBasicInfosResponseBodyMediaInfosFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        return self


class ListMediaBasicInfosResponseBodyMediaInfosMediaBasicInfo(TeaModel):
    def __init__(self, biz=None, business_type=None, cate_id=None, category=None, cover_url=None, create_time=None,
                 deleted_time=None, description=None, input_url=None, media_id=None, media_tags=None, media_type=None,
                 modified_time=None, snapshots=None, source=None, sprite_images=None, status=None, title=None,
                 transcode_status=None, upload_source=None, user_data=None):
        self.biz = biz  # type: str
        self.business_type = business_type  # type: str
        self.cate_id = cate_id  # type: long
        self.category = category  # type: str
        self.cover_url = cover_url  # type: str
        self.create_time = create_time  # type: str
        self.deleted_time = deleted_time  # type: str
        self.description = description  # type: str
        self.input_url = input_url  # type: str
        self.media_id = media_id  # type: str
        self.media_tags = media_tags  # type: str
        self.media_type = media_type  # type: str
        self.modified_time = modified_time  # type: str
        self.snapshots = snapshots  # type: str
        self.source = source  # type: str
        self.sprite_images = sprite_images  # type: str
        self.status = status  # type: str
        self.title = title  # type: str
        self.transcode_status = transcode_status  # type: str
        self.upload_source = upload_source  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMediaBasicInfosResponseBodyMediaInfosMediaBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz is not None:
            result['Biz'] = self.biz
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_images is not None:
            result['SpriteImages'] = self.sprite_images
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.transcode_status is not None:
            result['TranscodeStatus'] = self.transcode_status
        if self.upload_source is not None:
            result['UploadSource'] = self.upload_source
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Biz') is not None:
            self.biz = m.get('Biz')
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Snapshots') is not None:
            self.snapshots = m.get('Snapshots')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteImages') is not None:
            self.sprite_images = m.get('SpriteImages')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('TranscodeStatus') is not None:
            self.transcode_status = m.get('TranscodeStatus')
        if m.get('UploadSource') is not None:
            self.upload_source = m.get('UploadSource')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class ListMediaBasicInfosResponseBodyMediaInfos(TeaModel):
    def __init__(self, file_info_list=None, media_basic_info=None, media_id=None):
        self.file_info_list = file_info_list  # type: list[ListMediaBasicInfosResponseBodyMediaInfosFileInfoList]
        self.media_basic_info = media_basic_info  # type: ListMediaBasicInfosResponseBodyMediaInfosMediaBasicInfo
        self.media_id = media_id  # type: str

    def validate(self):
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super(ListMediaBasicInfosResponseBodyMediaInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = ListMediaBasicInfosResponseBodyMediaInfosFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = ListMediaBasicInfosResponseBodyMediaInfosMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class ListMediaBasicInfosResponseBody(TeaModel):
    def __init__(self, max_results=None, media_infos=None, next_token=None, request_id=None, total_count=None):
        self.max_results = max_results  # type: int
        self.media_infos = media_infos  # type: list[ListMediaBasicInfosResponseBodyMediaInfos]
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: long

    def validate(self):
        if self.media_infos:
            for k in self.media_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListMediaBasicInfosResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        result['MediaInfos'] = []
        if self.media_infos is not None:
            for k in self.media_infos:
                result['MediaInfos'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        self.media_infos = []
        if m.get('MediaInfos') is not None:
            for k in m.get('MediaInfos'):
                temp_model = ListMediaBasicInfosResponseBodyMediaInfos()
                self.media_infos.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListMediaBasicInfosResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListMediaBasicInfosResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListMediaBasicInfosResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListMediaBasicInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMediaInfoJobsRequest(TeaModel):
    def __init__(self, end_of_create_time=None, job_id=None, next_page_token=None, order_by=None, page_size=None,
                 start_of_create_time=None, status=None):
        self.end_of_create_time = end_of_create_time  # type: str
        self.job_id = job_id  # type: str
        self.next_page_token = next_page_token  # type: str
        self.order_by = order_by  # type: str
        self.page_size = page_size  # type: int
        self.start_of_create_time = start_of_create_time  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMediaInfoJobsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_of_create_time is not None:
            result['EndOfCreateTime'] = self.end_of_create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_of_create_time is not None:
            result['StartOfCreateTime'] = self.start_of_create_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndOfCreateTime') is not None:
            self.end_of_create_time = m.get('EndOfCreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartOfCreateTime') is not None:
            self.start_of_create_time = m.get('StartOfCreateTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListMediaInfoJobsResponseBodyJobsInput(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMediaInfoJobsResponseBodyJobsInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyAudioStreamInfoList(TeaModel):
    def __init__(self, bitrate=None, channel_layout=None, channels=None, codec_long_name=None, codec_name=None,
                 codec_tag=None, codec_tag_string=None, codec_time_base=None, duration=None, index=None, lang=None,
                 sample_fmt=None, sample_rate=None, start_time=None, timebase=None):
        self.bitrate = bitrate  # type: str
        self.channel_layout = channel_layout  # type: str
        self.channels = channels  # type: str
        self.codec_long_name = codec_long_name  # type: str
        self.codec_name = codec_name  # type: str
        self.codec_tag = codec_tag  # type: str
        self.codec_tag_string = codec_tag_string  # type: str
        self.codec_time_base = codec_time_base  # type: str
        self.duration = duration  # type: str
        self.index = index  # type: str
        self.lang = lang  # type: str
        self.sample_fmt = sample_fmt  # type: str
        self.sample_rate = sample_rate  # type: str
        self.start_time = start_time  # type: str
        self.timebase = timebase  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyAudioStreamInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.sample_rate is not None:
            result['SampleRate'] = self.sample_rate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('SampleRate') is not None:
            self.sample_rate = m.get('SampleRate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyFileBasicInfo(TeaModel):
    def __init__(self, bitrate=None, duration=None, file_name=None, file_size=None, file_status=None, file_type=None,
                 file_url=None, format_name=None, height=None, media_id=None, region=None, width=None):
        self.bitrate = bitrate  # type: str
        self.duration = duration  # type: str
        self.file_name = file_name  # type: str
        self.file_size = file_size  # type: str
        self.file_status = file_status  # type: str
        self.file_type = file_type  # type: str
        self.file_url = file_url  # type: str
        self.format_name = format_name  # type: str
        self.height = height  # type: str
        self.media_id = media_id  # type: str
        self.region = region  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyFileBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyVideoStreamInfoList(TeaModel):
    def __init__(self, avg_fps=None, bit_rate=None, codec_long_name=None, codec_name=None, codec_tag=None,
                 codec_tag_string=None, codec_time_base=None, dar=None, duration=None, fps=None, has_bframes=None, height=None,
                 index=None, lang=None, level=None, num_frames=None, pix_fmt=None, profile=None, rotate=None, sar=None,
                 start_time=None, time_base=None, width=None):
        self.avg_fps = avg_fps  # type: str
        self.bit_rate = bit_rate  # type: str
        self.codec_long_name = codec_long_name  # type: str
        self.codec_name = codec_name  # type: str
        self.codec_tag = codec_tag  # type: str
        self.codec_tag_string = codec_tag_string  # type: str
        self.codec_time_base = codec_time_base  # type: str
        self.dar = dar  # type: str
        self.duration = duration  # type: str
        self.fps = fps  # type: str
        self.has_bframes = has_bframes  # type: str
        self.height = height  # type: str
        self.index = index  # type: str
        self.lang = lang  # type: str
        self.level = level  # type: str
        self.num_frames = num_frames  # type: str
        self.pix_fmt = pix_fmt  # type: str
        self.profile = profile  # type: str
        self.rotate = rotate  # type: str
        self.sar = sar  # type: str
        self.start_time = start_time  # type: str
        self.time_base = time_base  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyVideoStreamInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['Avg_fps'] = self.avg_fps
        if self.bit_rate is not None:
            result['Bit_rate'] = self.bit_rate
        if self.codec_long_name is not None:
            result['Codec_long_name'] = self.codec_long_name
        if self.codec_name is not None:
            result['Codec_name'] = self.codec_name
        if self.codec_tag is not None:
            result['Codec_tag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['Codec_tag_string'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['Codec_time_base'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['Has_b_frames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['Start_time'] = self.start_time
        if self.time_base is not None:
            result['Time_base'] = self.time_base
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Avg_fps') is not None:
            self.avg_fps = m.get('Avg_fps')
        if m.get('Bit_rate') is not None:
            self.bit_rate = m.get('Bit_rate')
        if m.get('Codec_long_name') is not None:
            self.codec_long_name = m.get('Codec_long_name')
        if m.get('Codec_name') is not None:
            self.codec_name = m.get('Codec_name')
        if m.get('Codec_tag') is not None:
            self.codec_tag = m.get('Codec_tag')
        if m.get('Codec_tag_string') is not None:
            self.codec_tag_string = m.get('Codec_tag_string')
        if m.get('Codec_time_base') is not None:
            self.codec_time_base = m.get('Codec_time_base')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Has_b_frames') is not None:
            self.has_bframes = m.get('Has_b_frames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('Start_time') is not None:
            self.start_time = m.get('Start_time')
        if m.get('Time_base') is not None:
            self.time_base = m.get('Time_base')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListMediaInfoJobsResponseBodyJobsMediaInfoProperty(TeaModel):
    def __init__(self, audio_stream_info_list=None, file_basic_info=None, video_stream_info_list=None):
        self.audio_stream_info_list = audio_stream_info_list  # type: list[ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyAudioStreamInfoList]
        self.file_basic_info = file_basic_info  # type: ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyFileBasicInfo
        self.video_stream_info_list = video_stream_info_list  # type: list[ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyVideoStreamInfoList]

    def validate(self):
        if self.audio_stream_info_list:
            for k in self.audio_stream_info_list:
                if k:
                    k.validate()
        if self.file_basic_info:
            self.file_basic_info.validate()
        if self.video_stream_info_list:
            for k in self.video_stream_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListMediaInfoJobsResponseBodyJobsMediaInfoProperty, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStreamInfoList'] = []
        if self.audio_stream_info_list is not None:
            for k in self.audio_stream_info_list:
                result['AudioStreamInfoList'].append(k.to_map() if k else None)
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        result['VideoStreamInfoList'] = []
        if self.video_stream_info_list is not None:
            for k in self.video_stream_info_list:
                result['VideoStreamInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.audio_stream_info_list = []
        if m.get('AudioStreamInfoList') is not None:
            for k in m.get('AudioStreamInfoList'):
                temp_model = ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyAudioStreamInfoList()
                self.audio_stream_info_list.append(temp_model.from_map(k))
        if m.get('FileBasicInfo') is not None:
            temp_model = ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        self.video_stream_info_list = []
        if m.get('VideoStreamInfoList') is not None:
            for k in m.get('VideoStreamInfoList'):
                temp_model = ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyVideoStreamInfoList()
                self.video_stream_info_list.append(temp_model.from_map(k))
        return self


class ListMediaInfoJobsResponseBodyJobsScheduleConfig(TeaModel):
    def __init__(self, pipeline_id=None, priority=None):
        self.pipeline_id = pipeline_id  # type: str
        self.priority = priority  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListMediaInfoJobsResponseBodyJobsScheduleConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class ListMediaInfoJobsResponseBodyJobs(TeaModel):
    def __init__(self, async=None, finish_time=None, input=None, job_id=None, media_info_property=None, name=None,
                 request_id=None, schedule_config=None, status=None, submit_result_json=None, submit_time=None,
                 trigger_source=None, user_data=None):
        self.async = async  # type: bool
        self.finish_time = finish_time  # type: str
        self.input = input  # type: ListMediaInfoJobsResponseBodyJobsInput
        self.job_id = job_id  # type: str
        self.media_info_property = media_info_property  # type: ListMediaInfoJobsResponseBodyJobsMediaInfoProperty
        self.name = name  # type: str
        self.request_id = request_id  # type: str
        self.schedule_config = schedule_config  # type: ListMediaInfoJobsResponseBodyJobsScheduleConfig
        self.status = status  # type: str
        self.submit_result_json = submit_result_json  # type: dict[str, any]
        self.submit_time = submit_time  # type: str
        self.trigger_source = trigger_source  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        if self.input:
            self.input.validate()
        if self.media_info_property:
            self.media_info_property.validate()
        if self.schedule_config:
            self.schedule_config.validate()

    def to_map(self):
        _map = super(ListMediaInfoJobsResponseBodyJobs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async is not None:
            result['Async'] = self.async
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.media_info_property is not None:
            result['MediaInfoProperty'] = self.media_info_property.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_config is not None:
            result['ScheduleConfig'] = self.schedule_config.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_result_json is not None:
            result['SubmitResultJson'] = self.submit_result_json
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Async') is not None:
            self.async = m.get('Async')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = ListMediaInfoJobsResponseBodyJobsInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MediaInfoProperty') is not None:
            temp_model = ListMediaInfoJobsResponseBodyJobsMediaInfoProperty()
            self.media_info_property = temp_model.from_map(m['MediaInfoProperty'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleConfig') is not None:
            temp_model = ListMediaInfoJobsResponseBodyJobsScheduleConfig()
            self.schedule_config = temp_model.from_map(m['ScheduleConfig'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitResultJson') is not None:
            self.submit_result_json = m.get('SubmitResultJson')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class ListMediaInfoJobsResponseBody(TeaModel):
    def __init__(self, jobs=None, next_page_token=None, request_id=None):
        self.jobs = jobs  # type: list[ListMediaInfoJobsResponseBodyJobs]
        self.next_page_token = next_page_token  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListMediaInfoJobsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['Jobs'].append(k.to_map() if k else None)
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.jobs = []
        if m.get('Jobs') is not None:
            for k in m.get('Jobs'):
                temp_model = ListMediaInfoJobsResponseBodyJobs()
                self.jobs.append(temp_model.from_map(k))
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListMediaInfoJobsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListMediaInfoJobsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListMediaInfoJobsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListMediaInfoJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPipelinesRequest(TeaModel):
    def __init__(self, speed=None):
        self.speed = speed  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPipelinesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.speed is not None:
            result['Speed'] = self.speed
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        return self


class ListPipelinesResponseBodyPipelineList(TeaModel):
    def __init__(self, create_time=None, modified_time=None, name=None, pipeline_id=None, priority=None, speed=None,
                 status=None):
        self.create_time = create_time  # type: str
        self.modified_time = modified_time  # type: str
        self.name = name  # type: str
        self.pipeline_id = pipeline_id  # type: str
        self.priority = priority  # type: int
        self.speed = speed  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPipelinesResponseBodyPipelineList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListPipelinesResponseBody(TeaModel):
    def __init__(self, pipeline_list=None, request_id=None):
        self.pipeline_list = pipeline_list  # type: list[ListPipelinesResponseBodyPipelineList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.pipeline_list:
            for k in self.pipeline_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPipelinesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PipelineList'] = []
        if self.pipeline_list is not None:
            for k in self.pipeline_list:
                result['PipelineList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.pipeline_list = []
        if m.get('PipelineList') is not None:
            for k in m.get('PipelineList'):
                temp_model = ListPipelinesResponseBodyPipelineList()
                self.pipeline_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListPipelinesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListPipelinesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPipelinesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPipelinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPublicMediaBasicInfosRequest(TeaModel):
    def __init__(self, include_file_basic_info=None, max_results=None, media_tag_id=None, next_token=None,
                 page_no=None, page_size=None):
        self.include_file_basic_info = include_file_basic_info  # type: bool
        self.max_results = max_results  # type: int
        self.media_tag_id = media_tag_id  # type: str
        self.next_token = next_token  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPublicMediaBasicInfosRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.include_file_basic_info is not None:
            result['IncludeFileBasicInfo'] = self.include_file_basic_info
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.media_tag_id is not None:
            result['MediaTagId'] = self.media_tag_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IncludeFileBasicInfo') is not None:
            self.include_file_basic_info = m.get('IncludeFileBasicInfo')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('MediaTagId') is not None:
            self.media_tag_id = m.get('MediaTagId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListPublicMediaBasicInfosResponseBodyMediaInfosFileInfoListFileBasicInfo(TeaModel):
    def __init__(self, bitrate=None, duration=None, file_name=None, file_size=None, file_status=None, file_type=None,
                 file_url=None, format_name=None, height=None, region=None, width=None):
        self.bitrate = bitrate  # type: str
        self.duration = duration  # type: str
        self.file_name = file_name  # type: str
        self.file_size = file_size  # type: str
        self.file_status = file_status  # type: str
        self.file_type = file_type  # type: str
        self.file_url = file_url  # type: str
        self.format_name = format_name  # type: str
        self.height = height  # type: str
        self.region = region  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPublicMediaBasicInfosResponseBodyMediaInfosFileInfoListFileBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListPublicMediaBasicInfosResponseBodyMediaInfosFileInfoList(TeaModel):
    def __init__(self, file_basic_info=None):
        self.file_basic_info = file_basic_info  # type: ListPublicMediaBasicInfosResponseBodyMediaInfosFileInfoListFileBasicInfo

    def validate(self):
        if self.file_basic_info:
            self.file_basic_info.validate()

    def to_map(self):
        _map = super(ListPublicMediaBasicInfosResponseBodyMediaInfosFileInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileBasicInfo') is not None:
            temp_model = ListPublicMediaBasicInfosResponseBodyMediaInfosFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        return self


class ListPublicMediaBasicInfosResponseBodyMediaInfosMediaBasicInfo(TeaModel):
    def __init__(self, business_type=None, category=None, cover_url=None, create_time=None, deleted_time=None,
                 description=None, input_url=None, media_id=None, media_tags=None, media_type=None, modified_time=None,
                 snapshots=None, source=None, status=None, title=None, transcode_status=None, user_data=None):
        self.business_type = business_type  # type: str
        self.category = category  # type: str
        self.cover_url = cover_url  # type: str
        self.create_time = create_time  # type: str
        self.deleted_time = deleted_time  # type: str
        self.description = description  # type: str
        self.input_url = input_url  # type: str
        self.media_id = media_id  # type: str
        self.media_tags = media_tags  # type: str
        self.media_type = media_type  # type: str
        self.modified_time = modified_time  # type: str
        self.snapshots = snapshots  # type: str
        self.source = source  # type: str
        self.status = status  # type: str
        self.title = title  # type: str
        self.transcode_status = transcode_status  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListPublicMediaBasicInfosResponseBodyMediaInfosMediaBasicInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.transcode_status is not None:
            result['TranscodeStatus'] = self.transcode_status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Snapshots') is not None:
            self.snapshots = m.get('Snapshots')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('TranscodeStatus') is not None:
            self.transcode_status = m.get('TranscodeStatus')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class ListPublicMediaBasicInfosResponseBodyMediaInfos(TeaModel):
    def __init__(self, file_info_list=None, media_basic_info=None, media_id=None):
        self.file_info_list = file_info_list  # type: list[ListPublicMediaBasicInfosResponseBodyMediaInfosFileInfoList]
        self.media_basic_info = media_basic_info  # type: ListPublicMediaBasicInfosResponseBodyMediaInfosMediaBasicInfo
        self.media_id = media_id  # type: str

    def validate(self):
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super(ListPublicMediaBasicInfosResponseBodyMediaInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = ListPublicMediaBasicInfosResponseBodyMediaInfosFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = ListPublicMediaBasicInfosResponseBodyMediaInfosMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class ListPublicMediaBasicInfosResponseBody(TeaModel):
    def __init__(self, max_results=None, media_infos=None, next_token=None, request_id=None, total_count=None):
        self.max_results = max_results  # type: int
        self.media_infos = media_infos  # type: list[ListPublicMediaBasicInfosResponseBodyMediaInfos]
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: long

    def validate(self):
        if self.media_infos:
            for k in self.media_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListPublicMediaBasicInfosResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        result['MediaInfos'] = []
        if self.media_infos is not None:
            for k in self.media_infos:
                result['MediaInfos'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        self.media_infos = []
        if m.get('MediaInfos') is not None:
            for k in m.get('MediaInfos'):
                temp_model = ListPublicMediaBasicInfosResponseBodyMediaInfos()
                self.media_infos.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListPublicMediaBasicInfosResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListPublicMediaBasicInfosResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListPublicMediaBasicInfosResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPublicMediaBasicInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSmartJobsRequest(TeaModel):
    def __init__(self, job_state=None, job_type=None, max_results=None, next_token=None, page_no=None,
                 page_size=None, sort_by=None):
        self.job_state = job_state  # type: str
        self.job_type = job_type  # type: str
        self.max_results = max_results  # type: long
        self.next_token = next_token  # type: str
        self.page_no = page_no  # type: long
        self.page_size = page_size  # type: long
        self.sort_by = sort_by  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSmartJobsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_state is not None:
            result['JobState'] = self.job_state
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobState') is not None:
            self.job_state = m.get('JobState')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        return self


class ListSmartJobsResponseBodySmartJobListInputConfig(TeaModel):
    def __init__(self, input_file=None, keyword=None):
        self.input_file = input_file  # type: str
        self.keyword = keyword  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSmartJobsResponseBodySmartJobListInputConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_file is not None:
            result['InputFile'] = self.input_file
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InputFile') is not None:
            self.input_file = m.get('InputFile')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        return self


class ListSmartJobsResponseBodySmartJobListOutputConfig(TeaModel):
    def __init__(self, bucket=None, object=None):
        self.bucket = bucket  # type: str
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSmartJobsResponseBodySmartJobListOutputConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class ListSmartJobsResponseBodySmartJobList(TeaModel):
    def __init__(self, create_time=None, description=None, editing_config=None, input_config=None, job_id=None,
                 job_state=None, job_type=None, modified_time=None, output_config=None, title=None, user_data=None,
                 user_id=None):
        self.create_time = create_time  # type: str
        self.description = description  # type: str
        self.editing_config = editing_config  # type: str
        self.input_config = input_config  # type: ListSmartJobsResponseBodySmartJobListInputConfig
        self.job_id = job_id  # type: str
        self.job_state = job_state  # type: str
        self.job_type = job_type  # type: str
        self.modified_time = modified_time  # type: str
        self.output_config = output_config  # type: ListSmartJobsResponseBodySmartJobListOutputConfig
        self.title = title  # type: str
        self.user_data = user_data  # type: str
        self.user_id = user_id  # type: long

    def validate(self):
        if self.input_config:
            self.input_config.validate()
        if self.output_config:
            self.output_config.validate()

    def to_map(self):
        _map = super(ListSmartJobsResponseBodySmartJobList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.editing_config is not None:
            result['EditingConfig'] = self.editing_config
        if self.input_config is not None:
            result['InputConfig'] = self.input_config.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_state is not None:
            result['JobState'] = self.job_state
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.output_config is not None:
            result['OutputConfig'] = self.output_config.to_map()
        if self.title is not None:
            result['Title'] = self.title
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EditingConfig') is not None:
            self.editing_config = m.get('EditingConfig')
        if m.get('InputConfig') is not None:
            temp_model = ListSmartJobsResponseBodySmartJobListInputConfig()
            self.input_config = temp_model.from_map(m['InputConfig'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobState') is not None:
            self.job_state = m.get('JobState')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OutputConfig') is not None:
            temp_model = ListSmartJobsResponseBodySmartJobListOutputConfig()
            self.output_config = temp_model.from_map(m['OutputConfig'])
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListSmartJobsResponseBody(TeaModel):
    def __init__(self, max_results=None, next_token=None, request_id=None, smart_job_list=None, total_count=None):
        self.max_results = max_results  # type: str
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str
        self.smart_job_list = smart_job_list  # type: list[ListSmartJobsResponseBodySmartJobList]
        self.total_count = total_count  # type: str

    def validate(self):
        if self.smart_job_list:
            for k in self.smart_job_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListSmartJobsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SmartJobList'] = []
        if self.smart_job_list is not None:
            for k in self.smart_job_list:
                result['SmartJobList'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.smart_job_list = []
        if m.get('SmartJobList') is not None:
            for k in m.get('SmartJobList'):
                temp_model = ListSmartJobsResponseBodySmartJobList()
                self.smart_job_list.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListSmartJobsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListSmartJobsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListSmartJobsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListSmartJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSnapshotJobsRequest(TeaModel):
    def __init__(self, end_of_create_time=None, job_id=None, next_page_token=None, order_by=None, page_size=None,
                 start_of_create_time=None, status=None):
        self.end_of_create_time = end_of_create_time  # type: str
        self.job_id = job_id  # type: str
        self.next_page_token = next_page_token  # type: str
        self.order_by = order_by  # type: str
        self.page_size = page_size  # type: int
        self.start_of_create_time = start_of_create_time  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSnapshotJobsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_of_create_time is not None:
            result['EndOfCreateTime'] = self.end_of_create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_of_create_time is not None:
            result['StartOfCreateTime'] = self.start_of_create_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndOfCreateTime') is not None:
            self.end_of_create_time = m.get('EndOfCreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartOfCreateTime') is not None:
            self.start_of_create_time = m.get('StartOfCreateTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListSnapshotJobsResponseBodyJobsInput(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSnapshotJobsResponseBodyJobsInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListSnapshotJobsResponseBodyJobsOutput(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSnapshotJobsResponseBodyJobsOutput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListSnapshotJobsResponseBodyJobs(TeaModel):
    def __init__(self, async=None, count=None, create_time=None, finish_time=None, input=None, job_id=None,
                 modified_time=None, name=None, output=None, pipeline_id=None, status=None, submit_time=None, template_id=None,
                 trigger_source=None, type=None):
        self.async = async  # type: bool
        self.count = count  # type: int
        self.create_time = create_time  # type: str
        self.finish_time = finish_time  # type: str
        self.input = input  # type: ListSnapshotJobsResponseBodyJobsInput
        self.job_id = job_id  # type: str
        self.modified_time = modified_time  # type: str
        self.name = name  # type: str
        self.output = output  # type: ListSnapshotJobsResponseBodyJobsOutput
        self.pipeline_id = pipeline_id  # type: str
        self.status = status  # type: str
        self.submit_time = submit_time  # type: str
        self.template_id = template_id  # type: str
        self.trigger_source = trigger_source  # type: str
        self.type = type  # type: str

    def validate(self):
        if self.input:
            self.input.validate()
        if self.output:
            self.output.validate()

    def to_map(self):
        _map = super(ListSnapshotJobsResponseBodyJobs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async is not None:
            result['Async'] = self.async
        if self.count is not None:
            result['Count'] = self.count
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Async') is not None:
            self.async = m.get('Async')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = ListSnapshotJobsResponseBodyJobsInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Output') is not None:
            temp_model = ListSnapshotJobsResponseBodyJobsOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListSnapshotJobsResponseBody(TeaModel):
    def __init__(self, jobs=None, next_page_token=None, request_id=None):
        self.jobs = jobs  # type: list[ListSnapshotJobsResponseBodyJobs]
        self.next_page_token = next_page_token  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListSnapshotJobsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['Jobs'].append(k.to_map() if k else None)
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.jobs = []
        if m.get('Jobs') is not None:
            for k in m.get('Jobs'):
                temp_model = ListSnapshotJobsResponseBodyJobs()
                self.jobs.append(temp_model.from_map(k))
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListSnapshotJobsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListSnapshotJobsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListSnapshotJobsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListSnapshotJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSystemTemplatesRequest(TeaModel):
    def __init__(self, name=None, page_number=None, page_size=None, status=None, subtype=None, template_id=None,
                 type=None):
        self.name = name  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.status = status  # type: str
        self.subtype = subtype  # type: str
        self.template_id = template_id  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSystemTemplatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListSystemTemplatesResponseBodySystemTemplateList(TeaModel):
    def __init__(self, status=None, subtype=None, subtype_name=None, template_config=None, template_id=None,
                 template_name=None, type=None, type_name=None):
        self.status = status  # type: str
        self.subtype = subtype  # type: int
        self.subtype_name = subtype_name  # type: str
        self.template_config = template_config  # type: str
        self.template_id = template_id  # type: str
        self.template_name = template_name  # type: str
        self.type = type  # type: int
        self.type_name = type_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSystemTemplatesResponseBodySystemTemplateList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.subtype_name is not None:
            result['SubtypeName'] = self.subtype_name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.type is not None:
            result['Type'] = self.type
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('SubtypeName') is not None:
            self.subtype_name = m.get('SubtypeName')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        return self


class ListSystemTemplatesResponseBody(TeaModel):
    def __init__(self, request_id=None, system_template_list=None, total=None):
        self.request_id = request_id  # type: str
        self.system_template_list = system_template_list  # type: list[ListSystemTemplatesResponseBodySystemTemplateList]
        self.total = total  # type: int

    def validate(self):
        if self.system_template_list:
            for k in self.system_template_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListSystemTemplatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SystemTemplateList'] = []
        if self.system_template_list is not None:
            for k in self.system_template_list:
                result['SystemTemplateList'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.system_template_list = []
        if m.get('SystemTemplateList') is not None:
            for k in m.get('SystemTemplateList'):
                temp_model = ListSystemTemplatesResponseBodySystemTemplateList()
                self.system_template_list.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSystemTemplatesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListSystemTemplatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListSystemTemplatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListSystemTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTemplatesRequest(TeaModel):
    def __init__(self, create_source=None, keyword=None, page_no=None, page_size=None, sort_type=None, status=None,
                 type=None):
        self.create_source = create_source  # type: str
        self.keyword = keyword  # type: str
        self.page_no = page_no  # type: long
        self.page_size = page_size  # type: long
        self.sort_type = sort_type  # type: str
        self.status = status  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTemplatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_type is not None:
            result['SortType'] = self.sort_type
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortType') is not None:
            self.sort_type = m.get('SortType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListTemplatesResponseBodyTemplates(TeaModel):
    def __init__(self, clips_param=None, config=None, cover_url=None, create_source=None, creation_time=None,
                 modified_source=None, modified_time=None, name=None, preview_media=None, preview_media_status=None, status=None,
                 template_id=None, type=None):
        self.clips_param = clips_param  # type: str
        self.config = config  # type: str
        self.cover_url = cover_url  # type: str
        self.create_source = create_source  # type: str
        self.creation_time = creation_time  # type: str
        self.modified_source = modified_source  # type: str
        self.modified_time = modified_time  # type: str
        self.name = name  # type: str
        self.preview_media = preview_media  # type: str
        self.preview_media_status = preview_media_status  # type: str
        self.status = status  # type: str
        self.template_id = template_id  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTemplatesResponseBodyTemplates, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_param is not None:
            result['ClipsParam'] = self.clips_param
        if self.config is not None:
            result['Config'] = self.config
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.modified_source is not None:
            result['ModifiedSource'] = self.modified_source
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.preview_media is not None:
            result['PreviewMedia'] = self.preview_media
        if self.preview_media_status is not None:
            result['PreviewMediaStatus'] = self.preview_media_status
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClipsParam') is not None:
            self.clips_param = m.get('ClipsParam')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('ModifiedSource') is not None:
            self.modified_source = m.get('ModifiedSource')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PreviewMedia') is not None:
            self.preview_media = m.get('PreviewMedia')
        if m.get('PreviewMediaStatus') is not None:
            self.preview_media_status = m.get('PreviewMediaStatus')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListTemplatesResponseBody(TeaModel):
    def __init__(self, request_id=None, templates=None, total_count=None):
        self.request_id = request_id  # type: str
        self.templates = templates  # type: list[ListTemplatesResponseBodyTemplates]
        self.total_count = total_count  # type: int

    def validate(self):
        if self.templates:
            for k in self.templates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTemplatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Templates'] = []
        if self.templates is not None:
            for k in self.templates:
                result['Templates'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.templates = []
        if m.get('Templates') is not None:
            for k in m.get('Templates'):
                temp_model = ListTemplatesResponseBodyTemplates()
                self.templates.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListTemplatesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListTemplatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTemplatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTranscodeJobsRequest(TeaModel):
    def __init__(self, end_of_create_time=None, job_id=None, next_page_token=None, order_by=None, page_size=None,
                 start_of_create_time=None, status=None):
        self.end_of_create_time = end_of_create_time  # type: str
        self.job_id = job_id  # type: str
        self.next_page_token = next_page_token  # type: str
        self.order_by = order_by  # type: str
        self.page_size = page_size  # type: int
        self.start_of_create_time = start_of_create_time  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeJobsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_of_create_time is not None:
            result['EndOfCreateTime'] = self.end_of_create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_of_create_time is not None:
            result['StartOfCreateTime'] = self.start_of_create_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndOfCreateTime') is not None:
            self.end_of_create_time = m.get('EndOfCreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartOfCreateTime') is not None:
            self.start_of_create_time = m.get('StartOfCreateTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTranscodeJobsResponseBodyJobsInputGroup(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsInputGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupOutput(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupOutput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParamsFile(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParamsFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParamsTimeline(TeaModel):
    def __init__(self, duration=None, start=None):
        self.duration = duration  # type: str
        self.start = start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParamsTimeline, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParams(TeaModel):
    def __init__(self, dx=None, dy=None, file=None, height=None, refer_pos=None, timeline=None, width=None):
        self.dx = dx  # type: str
        self.dy = dy  # type: str
        self.file = file  # type: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParamsFile
        self.height = height  # type: str
        self.refer_pos = refer_pos  # type: str
        self.timeline = timeline  # type: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParamsTimeline
        self.width = width  # type: str

    def validate(self):
        if self.file:
            self.file.validate()
        if self.timeline:
            self.timeline.validate()

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.dy is not None:
            result['Dy'] = self.dy
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.height is not None:
            result['Height'] = self.height
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.timeline is not None:
            result['Timeline'] = self.timeline.to_map()
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        if m.get('File') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParamsFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Timeline') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParamsTimeline()
            self.timeline = temp_model.from_map(m['Timeline'])
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarks(TeaModel):
    def __init__(self, overwrite_params=None, template_id=None):
        self.overwrite_params = overwrite_params  # type: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParams
        self.template_id = template_id  # type: str

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitlesOverwriteParamsFile(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitlesOverwriteParamsFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitlesOverwriteParams(TeaModel):
    def __init__(self, char_enc=None, file=None, format=None):
        self.char_enc = char_enc  # type: str
        self.file = file  # type: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitlesOverwriteParamsFile
        self.format = format  # type: str

    def validate(self):
        if self.file:
            self.file.validate()

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitlesOverwriteParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('File') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitlesOverwriteParamsFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitles(TeaModel):
    def __init__(self, overwrite_params=None, template_id=None):
        self.overwrite_params = overwrite_params  # type: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitlesOverwriteParams
        self.template_id = template_id  # type: str

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitles, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitlesOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTextWatermarksOverwriteParams(TeaModel):
    def __init__(self, adaptive=None, border_color=None, border_width=None, content=None, font_alpha=None,
                 font_color=None, font_name=None, font_size=None, left=None, top=None):
        self.adaptive = adaptive  # type: str
        self.border_color = border_color  # type: str
        self.border_width = border_width  # type: int
        self.content = content  # type: str
        self.font_alpha = font_alpha  # type: str
        self.font_color = font_color  # type: str
        self.font_name = font_name  # type: str
        self.font_size = font_size  # type: int
        self.left = left  # type: str
        self.top = top  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTextWatermarksOverwriteParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adaptive is not None:
            result['Adaptive'] = self.adaptive
        if self.border_color is not None:
            result['BorderColor'] = self.border_color
        if self.border_width is not None:
            result['BorderWidth'] = self.border_width
        if self.content is not None:
            result['Content'] = self.content
        if self.font_alpha is not None:
            result['FontAlpha'] = self.font_alpha
        if self.font_color is not None:
            result['FontColor'] = self.font_color
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.font_size is not None:
            result['FontSize'] = self.font_size
        if self.left is not None:
            result['Left'] = self.left
        if self.top is not None:
            result['Top'] = self.top
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Adaptive') is not None:
            self.adaptive = m.get('Adaptive')
        if m.get('BorderColor') is not None:
            self.border_color = m.get('BorderColor')
        if m.get('BorderWidth') is not None:
            self.border_width = m.get('BorderWidth')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('FontAlpha') is not None:
            self.font_alpha = m.get('FontAlpha')
        if m.get('FontColor') is not None:
            self.font_color = m.get('FontColor')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('FontSize') is not None:
            self.font_size = m.get('FontSize')
        if m.get('Left') is not None:
            self.left = m.get('Left')
        if m.get('Top') is not None:
            self.top = m.get('Top')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTextWatermarks(TeaModel):
    def __init__(self, overwrite_params=None, template_id=None):
        self.overwrite_params = overwrite_params  # type: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTextWatermarksOverwriteParams
        self.template_id = template_id  # type: str

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTextWatermarks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTextWatermarksOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsAudioVolume(TeaModel):
    def __init__(self, integrated_loudness_target=None, loudness_range_target=None, method=None, true_peak=None):
        self.integrated_loudness_target = integrated_loudness_target  # type: str
        self.loudness_range_target = loudness_range_target  # type: str
        self.method = method  # type: str
        self.true_peak = true_peak  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsAudioVolume, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.integrated_loudness_target is not None:
            result['IntegratedLoudnessTarget'] = self.integrated_loudness_target
        if self.loudness_range_target is not None:
            result['LoudnessRangeTarget'] = self.loudness_range_target
        if self.method is not None:
            result['Method'] = self.method
        if self.true_peak is not None:
            result['TruePeak'] = self.true_peak
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IntegratedLoudnessTarget') is not None:
            self.integrated_loudness_target = m.get('IntegratedLoudnessTarget')
        if m.get('LoudnessRangeTarget') is not None:
            self.loudness_range_target = m.get('LoudnessRangeTarget')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('TruePeak') is not None:
            self.true_peak = m.get('TruePeak')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsAudio(TeaModel):
    def __init__(self, bitrate=None, channels=None, codec=None, profile=None, remove=None, samplerate=None,
                 volume=None):
        self.bitrate = bitrate  # type: str
        self.channels = channels  # type: str
        self.codec = codec  # type: str
        self.profile = profile  # type: str
        self.remove = remove  # type: str
        self.samplerate = samplerate  # type: str
        self.volume = volume  # type: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsAudioVolume

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsAudio, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Volume') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsContainer(TeaModel):
    def __init__(self, format=None):
        self.format = format  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsContainer, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfigSegment(TeaModel):
    def __init__(self, duration=None, force_seg_time=None):
        self.duration = duration  # type: str
        self.force_seg_time = force_seg_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfigSegment, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.force_seg_time is not None:
            result['ForceSegTime'] = self.force_seg_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ForceSegTime') is not None:
            self.force_seg_time = m.get('ForceSegTime')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfig(TeaModel):
    def __init__(self, segment=None):
        self.segment = segment  # type: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfigSegment

    def validate(self):
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Segment') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsVideo(TeaModel):
    def __init__(self, abr_max=None, bitrate=None, bufsize=None, codec=None, crf=None, crop=None, fps=None, gop=None,
                 height=None, long_short_mode=None, maxrate=None, pad=None, pix_fmt=None, preset=None, profile=None,
                 remove=None, scan_mode=None, width=None):
        self.abr_max = abr_max  # type: str
        self.bitrate = bitrate  # type: str
        self.bufsize = bufsize  # type: str
        self.codec = codec  # type: str
        self.crf = crf  # type: str
        self.crop = crop  # type: str
        self.fps = fps  # type: str
        self.gop = gop  # type: str
        self.height = height  # type: str
        self.long_short_mode = long_short_mode  # type: str
        self.maxrate = maxrate  # type: str
        self.pad = pad  # type: str
        self.pix_fmt = pix_fmt  # type: str
        self.preset = preset  # type: str
        self.profile = profile  # type: str
        self.remove = remove  # type: str
        self.scan_mode = scan_mode  # type: str
        self.width = width  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsVideo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abr_max is not None:
            result['AbrMax'] = self.abr_max
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.long_short_mode is not None:
            result['LongShortMode'] = self.long_short_mode
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AbrMax') is not None:
            self.abr_max = m.get('AbrMax')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('LongShortMode') is not None:
            self.long_short_mode = m.get('LongShortMode')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParams(TeaModel):
    def __init__(self, audio=None, container=None, mux_config=None, video=None):
        self.audio = audio  # type: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsAudio
        self.container = container  # type: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsContainer
        self.mux_config = mux_config  # type: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfig
        self.video = video  # type: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsVideo

    def validate(self):
        if self.audio:
            self.audio.validate()
        if self.container:
            self.container.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.video:
            self.video.validate()

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Audio') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('Container') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('MuxConfig') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('Video') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsVideo()
            self.video = temp_model.from_map(m['Video'])
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscode(TeaModel):
    def __init__(self, overwrite_params=None, template_id=None):
        self.overwrite_params = overwrite_params  # type: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParams
        self.template_id = template_id  # type: str

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscode, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfig(TeaModel):
    def __init__(self, image_watermarks=None, subtitles=None, text_watermarks=None, transcode=None):
        self.image_watermarks = image_watermarks  # type: list[ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarks]
        self.subtitles = subtitles  # type: list[ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitles]
        self.text_watermarks = text_watermarks  # type: list[ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTextWatermarks]
        self.transcode = transcode  # type: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscode

    def validate(self):
        if self.image_watermarks:
            for k in self.image_watermarks:
                if k:
                    k.validate()
        if self.subtitles:
            for k in self.subtitles:
                if k:
                    k.validate()
        if self.text_watermarks:
            for k in self.text_watermarks:
                if k:
                    k.validate()
        if self.transcode:
            self.transcode.validate()

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageWatermarks'] = []
        if self.image_watermarks is not None:
            for k in self.image_watermarks:
                result['ImageWatermarks'].append(k.to_map() if k else None)
        result['Subtitles'] = []
        if self.subtitles is not None:
            for k in self.subtitles:
                result['Subtitles'].append(k.to_map() if k else None)
        result['TextWatermarks'] = []
        if self.text_watermarks is not None:
            for k in self.text_watermarks:
                result['TextWatermarks'].append(k.to_map() if k else None)
        if self.transcode is not None:
            result['Transcode'] = self.transcode.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.image_watermarks = []
        if m.get('ImageWatermarks') is not None:
            for k in m.get('ImageWatermarks'):
                temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarks()
                self.image_watermarks.append(temp_model.from_map(k))
        self.subtitles = []
        if m.get('Subtitles') is not None:
            for k in m.get('Subtitles'):
                temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitles()
                self.subtitles.append(temp_model.from_map(k))
        self.text_watermarks = []
        if m.get('TextWatermarks') is not None:
            for k in m.get('TextWatermarks'):
                temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTextWatermarks()
                self.text_watermarks.append(temp_model.from_map(k))
        if m.get('Transcode') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscode()
            self.transcode = temp_model.from_map(m['Transcode'])
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroup(TeaModel):
    def __init__(self, output=None, process_config=None):
        self.output = output  # type: ListTranscodeJobsResponseBodyJobsOutputGroupOutput
        self.process_config = process_config  # type: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfig

    def validate(self):
        if self.output:
            self.output.validate()
        if self.process_config:
            self.process_config.validate()

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsOutputGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.process_config is not None:
            result['ProcessConfig'] = self.process_config.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Output') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('ProcessConfig') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfig()
            self.process_config = temp_model.from_map(m['ProcessConfig'])
        return self


class ListTranscodeJobsResponseBodyJobsScheduleConfig(TeaModel):
    def __init__(self, pipeline_id=None, priority=None):
        self.pipeline_id = pipeline_id  # type: str
        self.priority = priority  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobsScheduleConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class ListTranscodeJobsResponseBodyJobs(TeaModel):
    def __init__(self, create_time=None, finish_time=None, input_group=None, job_count=None, name=None,
                 output_group=None, parent_job_id=None, percent=None, request_id=None, schedule_config=None, status=None,
                 submit_time=None, trigger_source=None, user_data=None):
        self.create_time = create_time  # type: str
        self.finish_time = finish_time  # type: str
        self.input_group = input_group  # type: list[ListTranscodeJobsResponseBodyJobsInputGroup]
        self.job_count = job_count  # type: int
        self.name = name  # type: str
        self.output_group = output_group  # type: list[ListTranscodeJobsResponseBodyJobsOutputGroup]
        self.parent_job_id = parent_job_id  # type: str
        self.percent = percent  # type: int
        self.request_id = request_id  # type: str
        self.schedule_config = schedule_config  # type: ListTranscodeJobsResponseBodyJobsScheduleConfig
        self.status = status  # type: str
        self.submit_time = submit_time  # type: str
        self.trigger_source = trigger_source  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        if self.input_group:
            for k in self.input_group:
                if k:
                    k.validate()
        if self.output_group:
            for k in self.output_group:
                if k:
                    k.validate()
        if self.schedule_config:
            self.schedule_config.validate()

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBodyJobs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        result['InputGroup'] = []
        if self.input_group is not None:
            for k in self.input_group:
                result['InputGroup'].append(k.to_map() if k else None)
        if self.job_count is not None:
            result['JobCount'] = self.job_count
        if self.name is not None:
            result['Name'] = self.name
        result['OutputGroup'] = []
        if self.output_group is not None:
            for k in self.output_group:
                result['OutputGroup'].append(k.to_map() if k else None)
        if self.parent_job_id is not None:
            result['ParentJobId'] = self.parent_job_id
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_config is not None:
            result['ScheduleConfig'] = self.schedule_config.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        self.input_group = []
        if m.get('InputGroup') is not None:
            for k in m.get('InputGroup'):
                temp_model = ListTranscodeJobsResponseBodyJobsInputGroup()
                self.input_group.append(temp_model.from_map(k))
        if m.get('JobCount') is not None:
            self.job_count = m.get('JobCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.output_group = []
        if m.get('OutputGroup') is not None:
            for k in m.get('OutputGroup'):
                temp_model = ListTranscodeJobsResponseBodyJobsOutputGroup()
                self.output_group.append(temp_model.from_map(k))
        if m.get('ParentJobId') is not None:
            self.parent_job_id = m.get('ParentJobId')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleConfig') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsScheduleConfig()
            self.schedule_config = temp_model.from_map(m['ScheduleConfig'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class ListTranscodeJobsResponseBody(TeaModel):
    def __init__(self, jobs=None, next_page_token=None, request_id=None):
        self.jobs = jobs  # type: list[ListTranscodeJobsResponseBodyJobs]
        self.next_page_token = next_page_token  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTranscodeJobsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['Jobs'].append(k.to_map() if k else None)
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.jobs = []
        if m.get('Jobs') is not None:
            for k in m.get('Jobs'):
                temp_model = ListTranscodeJobsResponseBodyJobs()
                self.jobs.append(temp_model.from_map(k))
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListTranscodeJobsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListTranscodeJobsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTranscodeJobsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTranscodeJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCensorJobListRequest(TeaModel):
    def __init__(self, job_ids=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.job_ids = job_ids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryCensorJobListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorConfigOutputFile(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        self.bucket = bucket  # type: str
        self.location = location  # type: str
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJobCensorConfigOutputFile, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorConfig(TeaModel):
    def __init__(self, biz_type=None, interval=None, output_file=None, save_type=None, scenes=None):
        self.biz_type = biz_type  # type: str
        self.interval = interval  # type: str
        self.output_file = output_file  # type: QueryCensorJobListResponseBodyJobsCensorJobCensorConfigOutputFile
        self.save_type = save_type  # type: str
        self.scenes = scenes  # type: str

    def validate(self):
        if self.output_file:
            self.output_file.validate()

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJobCensorConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.save_type is not None:
            result['SaveType'] = self.save_type
        if self.scenes is not None:
            result['Scenes'] = self.scenes
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OutputFile') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorConfigOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('SaveType') is not None:
            self.save_type = m.get('SaveType')
        if m.get('Scenes') is not None:
            self.scenes = m.get('Scenes')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornCounterListCounter(TeaModel):
    def __init__(self, count=None, label=None):
        self.count = count  # type: int
        self.label = label  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornCounterListCounter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornCounterList(TeaModel):
    def __init__(self, counter=None):
        self.counter = counter  # type: list[QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornCounterListCounter]

    def validate(self):
        if self.counter:
            for k in self.counter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornCounterList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Counter'] = []
        if self.counter is not None:
            for k in self.counter:
                result['Counter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.counter = []
        if m.get('Counter') is not None:
            for k in m.get('Counter'):
                temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornCounterListCounter()
                self.counter.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornTopListTop(TeaModel):
    def __init__(self, index=None, label=None, object=None, score=None, timestamp=None):
        self.index = index  # type: str
        self.label = label  # type: str
        self.object = object  # type: str
        self.score = score  # type: str
        self.timestamp = timestamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornTopListTop, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.label is not None:
            result['Label'] = self.label
        if self.object is not None:
            result['Object'] = self.object
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornTopList(TeaModel):
    def __init__(self, top=None):
        self.top = top  # type: list[QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornTopListTop]

    def validate(self):
        if self.top:
            for k in self.top:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornTopList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Top'] = []
        if self.top is not None:
            for k in self.top:
                result['Top'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.top = []
        if m.get('Top') is not None:
            for k in m.get('Top'):
                temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornTopListTop()
                self.top.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorPornResult(TeaModel):
    def __init__(self, average_score=None, label=None, max_score=None, porn_counter_list=None, porn_top_list=None,
                 suggestion=None):
        self.average_score = average_score  # type: str
        self.label = label  # type: str
        self.max_score = max_score  # type: str
        self.porn_counter_list = porn_counter_list  # type: QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornCounterList
        self.porn_top_list = porn_top_list  # type: QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornTopList
        self.suggestion = suggestion  # type: str

    def validate(self):
        if self.porn_counter_list:
            self.porn_counter_list.validate()
        if self.porn_top_list:
            self.porn_top_list.validate()

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJobCensorPornResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.porn_counter_list is not None:
            result['PornCounterList'] = self.porn_counter_list.to_map()
        if self.porn_top_list is not None:
            result['PornTopList'] = self.porn_top_list.to_map()
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('PornCounterList') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornCounterList()
            self.porn_counter_list = temp_model.from_map(m['PornCounterList'])
        if m.get('PornTopList') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornTopList()
            self.porn_top_list = temp_model.from_map(m['PornTopList'])
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismCounterListCounter(TeaModel):
    def __init__(self, count=None, label=None):
        self.count = count  # type: int
        self.label = label  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismCounterListCounter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismCounterList(TeaModel):
    def __init__(self, counter=None):
        self.counter = counter  # type: list[QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismCounterListCounter]

    def validate(self):
        if self.counter:
            for k in self.counter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismCounterList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Counter'] = []
        if self.counter is not None:
            for k in self.counter:
                result['Counter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.counter = []
        if m.get('Counter') is not None:
            for k in m.get('Counter'):
                temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismCounterListCounter()
                self.counter.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismTopListTop(TeaModel):
    def __init__(self, index=None, label=None, object=None, score=None, timestamp=None):
        self.index = index  # type: str
        self.label = label  # type: str
        self.object = object  # type: str
        self.score = score  # type: str
        self.timestamp = timestamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismTopListTop, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.label is not None:
            result['Label'] = self.label
        if self.object is not None:
            result['Object'] = self.object
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismTopList(TeaModel):
    def __init__(self, top=None):
        self.top = top  # type: list[QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismTopListTop]

    def validate(self):
        if self.top:
            for k in self.top:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismTopList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Top'] = []
        if self.top is not None:
            for k in self.top:
                result['Top'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.top = []
        if m.get('Top') is not None:
            for k in m.get('Top'):
                temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismTopListTop()
                self.top.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResult(TeaModel):
    def __init__(self, average_score=None, label=None, max_score=None, suggestion=None, terrorism_counter_list=None,
                 terrorism_top_list=None):
        self.average_score = average_score  # type: str
        self.label = label  # type: str
        self.max_score = max_score  # type: str
        self.suggestion = suggestion  # type: str
        self.terrorism_counter_list = terrorism_counter_list  # type: QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismCounterList
        self.terrorism_top_list = terrorism_top_list  # type: QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismTopList

    def validate(self):
        if self.terrorism_counter_list:
            self.terrorism_counter_list.validate()
        if self.terrorism_top_list:
            self.terrorism_top_list.validate()

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.terrorism_counter_list is not None:
            result['TerrorismCounterList'] = self.terrorism_counter_list.to_map()
        if self.terrorism_top_list is not None:
            result['TerrorismTopList'] = self.terrorism_top_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('TerrorismCounterList') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismCounterList()
            self.terrorism_counter_list = temp_model.from_map(m['TerrorismCounterList'])
        if m.get('TerrorismTopList') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismTopList()
            self.terrorism_top_list = temp_model.from_map(m['TerrorismTopList'])
        return self


class QueryCensorJobListResponseBodyJobsCensorJobImageCensorResultsImageCensorResult(TeaModel):
    def __init__(self, image_bucket=None, image_location=None, image_object=None, result=None):
        self.image_bucket = image_bucket  # type: str
        self.image_location = image_location  # type: str
        self.image_object = image_object  # type: str
        self.result = result  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJobImageCensorResultsImageCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_bucket is not None:
            result['ImageBucket'] = self.image_bucket
        if self.image_location is not None:
            result['ImageLocation'] = self.image_location
        if self.image_object is not None:
            result['ImageObject'] = self.image_object
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImageBucket') is not None:
            self.image_bucket = m.get('ImageBucket')
        if m.get('ImageLocation') is not None:
            self.image_location = m.get('ImageLocation')
        if m.get('ImageObject') is not None:
            self.image_object = m.get('ImageObject')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobImageCensorResults(TeaModel):
    def __init__(self, image_censor_result=None):
        self.image_censor_result = image_censor_result  # type: list[QueryCensorJobListResponseBodyJobsCensorJobImageCensorResultsImageCensorResult]

    def validate(self):
        if self.image_censor_result:
            for k in self.image_censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJobImageCensorResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageCensorResult'] = []
        if self.image_censor_result is not None:
            for k in self.image_censor_result:
                result['ImageCensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.image_censor_result = []
        if m.get('ImageCensorResult') is not None:
            for k in m.get('ImageCensorResult'):
                temp_model = QueryCensorJobListResponseBodyJobsCensorJobImageCensorResultsImageCensorResult()
                self.image_censor_result.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyJobsCensorJobInput(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        self.bucket = bucket  # type: str
        self.location = location  # type: str
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJobInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryCensorJobListResponseBodyJobsCensorJob(TeaModel):
    def __init__(self, barrage_censor_result=None, censor_config=None, censor_porn_result=None,
                 censor_terrorism_result=None, code=None, creation_time=None, desc_censor_result=None, id=None, image_censor_results=None,
                 input=None, message=None, pipeline_id=None, result_save_object=None, state=None,
                 title_censor_result=None, user_data=None):
        self.barrage_censor_result = barrage_censor_result  # type: str
        self.censor_config = censor_config  # type: QueryCensorJobListResponseBodyJobsCensorJobCensorConfig
        self.censor_porn_result = censor_porn_result  # type: QueryCensorJobListResponseBodyJobsCensorJobCensorPornResult
        self.censor_terrorism_result = censor_terrorism_result  # type: QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResult
        self.code = code  # type: str
        self.creation_time = creation_time  # type: str
        self.desc_censor_result = desc_censor_result  # type: str
        self.id = id  # type: str
        self.image_censor_results = image_censor_results  # type: QueryCensorJobListResponseBodyJobsCensorJobImageCensorResults
        self.input = input  # type: QueryCensorJobListResponseBodyJobsCensorJobInput
        self.message = message  # type: str
        self.pipeline_id = pipeline_id  # type: str
        self.result_save_object = result_save_object  # type: str
        self.state = state  # type: str
        self.title_censor_result = title_censor_result  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        if self.censor_config:
            self.censor_config.validate()
        if self.censor_porn_result:
            self.censor_porn_result.validate()
        if self.censor_terrorism_result:
            self.censor_terrorism_result.validate()
        if self.image_censor_results:
            self.image_censor_results.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobsCensorJob, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.barrage_censor_result is not None:
            result['BarrageCensorResult'] = self.barrage_censor_result
        if self.censor_config is not None:
            result['CensorConfig'] = self.censor_config.to_map()
        if self.censor_porn_result is not None:
            result['CensorPornResult'] = self.censor_porn_result.to_map()
        if self.censor_terrorism_result is not None:
            result['CensorTerrorismResult'] = self.censor_terrorism_result.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.desc_censor_result is not None:
            result['DescCensorResult'] = self.desc_censor_result
        if self.id is not None:
            result['Id'] = self.id
        if self.image_censor_results is not None:
            result['ImageCensorResults'] = self.image_censor_results.to_map()
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.result_save_object is not None:
            result['ResultSaveObject'] = self.result_save_object
        if self.state is not None:
            result['State'] = self.state
        if self.title_censor_result is not None:
            result['TitleCensorResult'] = self.title_censor_result
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BarrageCensorResult') is not None:
            self.barrage_censor_result = m.get('BarrageCensorResult')
        if m.get('CensorConfig') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorConfig()
            self.censor_config = temp_model.from_map(m['CensorConfig'])
        if m.get('CensorPornResult') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorPornResult()
            self.censor_porn_result = temp_model.from_map(m['CensorPornResult'])
        if m.get('CensorTerrorismResult') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResult()
            self.censor_terrorism_result = temp_model.from_map(m['CensorTerrorismResult'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DescCensorResult') is not None:
            self.desc_censor_result = m.get('DescCensorResult')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ImageCensorResults') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobImageCensorResults()
            self.image_censor_results = temp_model.from_map(m['ImageCensorResults'])
        if m.get('Input') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('ResultSaveObject') is not None:
            self.result_save_object = m.get('ResultSaveObject')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TitleCensorResult') is not None:
            self.title_censor_result = m.get('TitleCensorResult')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryCensorJobListResponseBodyJobs(TeaModel):
    def __init__(self, censor_job=None):
        self.censor_job = censor_job  # type: list[QueryCensorJobListResponseBodyJobsCensorJob]

    def validate(self):
        if self.censor_job:
            for k in self.censor_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyJobs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CensorJob'] = []
        if self.censor_job is not None:
            for k in self.censor_job:
                result['CensorJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.censor_job = []
        if m.get('CensorJob') is not None:
            for k in m.get('CensorJob'):
                temp_model = QueryCensorJobListResponseBodyJobsCensorJob()
                self.censor_job.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyNonExistIds(TeaModel):
    def __init__(self, string=None):
        self.string = string  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryCensorJobListResponseBodyNonExistIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryCensorJobListResponseBody(TeaModel):
    def __init__(self, jobs=None, non_exist_ids=None, request_id=None):
        self.jobs = jobs  # type: QueryCensorJobListResponseBodyJobs
        self.non_exist_ids = non_exist_ids  # type: QueryCensorJobListResponseBodyNonExistIds
        self.request_id = request_id  # type: str

    def validate(self):
        if self.jobs:
            self.jobs.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super(QueryCensorJobListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.jobs is not None:
            result['Jobs'] = self.jobs.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Jobs') is not None:
            temp_model = QueryCensorJobListResponseBodyJobs()
            self.jobs = temp_model.from_map(m['Jobs'])
        if m.get('NonExistIds') is not None:
            temp_model = QueryCensorJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryCensorJobListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryCensorJobListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryCensorJobListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryCensorJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryIProductionJobRequest(TeaModel):
    def __init__(self, client_token=None, job_id=None):
        self.client_token = client_token  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryIProductionJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryIProductionJobResponseBodyInput(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryIProductionJobResponseBodyInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryIProductionJobResponseBodyOutput(TeaModel):
    def __init__(self, media=None, type=None):
        self.media = media  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryIProductionJobResponseBodyOutput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryIProductionJobResponseBodyScheduleConfig(TeaModel):
    def __init__(self, pipeline_id=None, priority=None):
        self.pipeline_id = pipeline_id  # type: str
        self.priority = priority  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryIProductionJobResponseBodyScheduleConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class QueryIProductionJobResponseBody(TeaModel):
    def __init__(self, create_time=None, finish_time=None, function_name=None, input=None, job_id=None,
                 job_params=None, name=None, output=None, output_files=None, output_urls=None, request_id=None, result=None,
                 schedule_config=None, status=None, template_id=None, user_data=None):
        self.create_time = create_time  # type: str
        self.finish_time = finish_time  # type: str
        self.function_name = function_name  # type: str
        self.input = input  # type: QueryIProductionJobResponseBodyInput
        self.job_id = job_id  # type: str
        self.job_params = job_params  # type: str
        self.name = name  # type: str
        self.output = output  # type: QueryIProductionJobResponseBodyOutput
        self.output_files = output_files  # type: list[str]
        self.output_urls = output_urls  # type: list[str]
        self.request_id = request_id  # type: str
        self.result = result  # type: str
        self.schedule_config = schedule_config  # type: QueryIProductionJobResponseBodyScheduleConfig
        self.status = status  # type: str
        self.template_id = template_id  # type: str
        self.user_data = user_data  # type: str

    def validate(self):
        if self.input:
            self.input.validate()
        if self.output:
            self.output.validate()
        if self.schedule_config:
            self.schedule_config.validate()

    def to_map(self):
        _map = super(QueryIProductionJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_params is not None:
            result['JobParams'] = self.job_params
        if self.name is not None:
            result['Name'] = self.name
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.output_files is not None:
            result['OutputFiles'] = self.output_files
        if self.output_urls is not None:
            result['OutputUrls'] = self.output_urls
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.schedule_config is not None:
            result['ScheduleConfig'] = self.schedule_config.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('Input') is not None:
            temp_model = QueryIProductionJobResponseBodyInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobParams') is not None:
            self.job_params = m.get('JobParams')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Output') is not None:
            temp_model = QueryIProductionJobResponseBodyOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('OutputFiles') is not None:
            self.output_files = m.get('OutputFiles')
        if m.get('OutputUrls') is not None:
            self.output_urls = m.get('OutputUrls')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('ScheduleConfig') is not None:
            temp_model = QueryIProductionJobResponseBodyScheduleConfig()
            self.schedule_config = temp_model.from_map(m['ScheduleConfig'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryIProductionJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryIProductionJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryIProductionJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryIProductionJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryMediaCensorJobDetailRequest(TeaModel):
    def __init__(self, job_id=None, maximum_page_size=None, next_page_token=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.job_id = job_id  # type: str
        self.maximum_page_size = maximum_page_size  # type: long
        self.next_page_token = next_page_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailBarrageCensorResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        self.label = label  # type: str
        self.rate = rate  # type: str
        self.scene = scene  # type: str
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailBarrageCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResultsResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        self.label = label  # type: str
        self.rate = rate  # type: str
        self.scene = scene  # type: str
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResultsResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResults(TeaModel):
    def __init__(self, result=None):
        self.result = result  # type: list[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResultsResult]

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResultsResult()
                self.result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResult(TeaModel):
    def __init__(self, bucket=None, location=None, object=None, results=None):
        self.bucket = bucket  # type: str
        self.location = location  # type: str
        self.object = object  # type: str
        self.results = results  # type: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResults

    def validate(self):
        if self.results:
            self.results.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        if self.results is not None:
            result['Results'] = self.results.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Results') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResults()
            self.results = temp_model.from_map(m['Results'])
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResults(TeaModel):
    def __init__(self, cover_image_censor_result=None):
        self.cover_image_censor_result = cover_image_censor_result  # type: list[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResult]

    def validate(self):
        if self.cover_image_censor_result:
            for k in self.cover_image_censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CoverImageCensorResult'] = []
        if self.cover_image_censor_result is not None:
            for k in self.cover_image_censor_result:
                result['CoverImageCensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cover_image_censor_result = []
        if m.get('CoverImageCensorResult') is not None:
            for k in m.get('CoverImageCensorResult'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResult()
                self.cover_image_censor_result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailDescCensorResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        self.label = label  # type: str
        self.rate = rate  # type: str
        self.scene = scene  # type: str
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailDescCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailInput(TeaModel):
    def __init__(self, bucket=None, location=None, object=None):
        self.bucket = bucket  # type: str
        self.location = location  # type: str
        self.object = object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailInput, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailTitleCensorResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        self.label = label  # type: str
        self.rate = rate  # type: str
        self.scene = scene  # type: str
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailTitleCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResultsCensorResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        self.label = label  # type: str
        self.rate = rate  # type: str
        self.scene = scene  # type: str
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResultsCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResults(TeaModel):
    def __init__(self, censor_result=None):
        self.censor_result = censor_result  # type: list[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResultsCensorResult]

    def validate(self):
        if self.censor_result:
            for k in self.censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CensorResult'] = []
        if self.censor_result is not None:
            for k in self.censor_result:
                result['CensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.censor_result = []
        if m.get('CensorResult') is not None:
            for k in m.get('CensorResult'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResultsCensorResult()
                self.censor_result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult(TeaModel):
    def __init__(self, label=None, rate=None, scene=None, suggestion=None):
        self.label = label  # type: str
        self.rate = rate  # type: str
        self.scene = scene  # type: str
        self.suggestion = suggestion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResults(TeaModel):
    def __init__(self, censor_result=None):
        self.censor_result = censor_result  # type: list[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult]

    def validate(self):
        if self.censor_result:
            for k in self.censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CensorResult'] = []
        if self.censor_result is not None:
            for k in self.censor_result:
                result['CensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.censor_result = []
        if m.get('CensorResult') is not None:
            for k in m.get('CensorResult'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult()
                self.censor_result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimeline(TeaModel):
    def __init__(self, censor_results=None, object=None, timestamp=None):
        self.censor_results = censor_results  # type: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResults
        self.object = object  # type: str
        self.timestamp = timestamp  # type: str

    def validate(self):
        if self.censor_results:
            self.censor_results.validate()

    def to_map(self):
        _map = super(QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimeline, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.censor_results is not None:
            result['CensorResults'] = self.censor_results.to_map()
        if self.object is not None:
            result['Object'] = self.object
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CensorResults') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResults()
            self.censor_results = temp_model.from_map(m['CensorResults'])
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelines(TeaModel):
    def __init__(self, video_timeline=None):
        self.video_timeline = video_timeline  # type: list[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimeline]

    def validate(self):
      