# MetaImageIO

Support for reading and writing images in [MetaIO](https://itk.org/Wiki/ITK/MetaIO/Documentation) file format.

![GitHub](https://img.shields.io/github/license/auneri/MetaImageIO)
![GitHub Workflow Status](https://img.shields.io/github/actions/workflow/status/auneri/MetaImageIO/main.yml)
![PyPI](https://img.shields.io/pypi/v/metaimageio)
![Conda (channel only)](https://img.shields.io/conda/vn/conda-forge/MetaImageIO)
[![MATLAB](https://www.mathworks.com/matlabcentral/images/matlab-file-exchange.svg)](https://www.mathworks.com/matlabcentral/fileexchange/104070-metaimageio)

## Getting started in Python

Install using `pip install metaimageio` or `conda install -c conda-forge metaimageio`.

```python
import metaimageio
image, meta = metaimageio.read('/path/to/input.mha')
metaimageio.write('/path/to/output.mha', image, ElementSpacing=meta['ElementSpacing'])
```

Add to [imageio](https://imageio.readthedocs.io) plugins.

```python
import imageio.v2 as imageio
metaimageio.imageio()
image = imageio.imread('/path/to/input.mha')
meta = image.meta
```

## Getting started in MATLAB

Install using the [Add-On Manager](https://www.mathworks.com/help/matlab/matlab_env/get-add-ons.html).

```matlab
[image, meta] = metaimageio.read('/path/to/input.mha');
metaimageio.write('/path/to/output.mha', image, 'ElementSpacing', meta.ElementSpacing);
```

Add to [image file format registry](https://www.mathworks.com/help/matlab/ref/imformats.html).

```matlab
metaimageio.imformats();
image = imread('/path/to/input.mha');
meta = imfinfo('/path/to/input.mha');
```
