import numpy as np

#Notable neutron cross sections

def StainlessSteel316L_Alpha():
    spectrum = np.array([
        [0, 0, 1.30313],
        [0.003, 0, 1.30366],
        [0.005, 5.00758e-05, 1.30412],
        [0.008, 5.84736e-05, 1.30461],
        [0.011, 0.000153338, 1.30506],
        [0.013, 0.000215544, 1.30554],
        [0.016, 0.00031725, 1.30598],
        [0.019, 0.000420512, 1.30632],
        [0.021, 0.000541192, 1.30671],
        [0.024, 0.000694529, 1.30705],
        [0.027, 0.000858442, 1.30747],
        [0.029, 0.00102018, 1.30782],
        [0.032, 0.00123572, 1.30809],
        [0.035, 0.00145126, 1.30842],
        [0.037, 0.00166308, 1.30866],
        [0.04, 0.00193025, 1.3089],
        [0.043, 0.00219587, 1.30917],
        [0.045, 0.00246989, 1.30939],
        [0.048, 0.00278869, 1.3096],
        [0.051, 0.00306271, 1.30978],
        [0.053, 0.00343159, 1.30991],
        [0.056, 0.00375724, 1.31007],
        [0.059, 0.00413296, 1.31023],
        [0.061, 0.00451024, 1.31035],
        [0.064, 0.00493977, 1.31042],
        [0.067, 0.00531705, 1.31048],
        [0.069, 0.00574596, 1.31055],
        [0.072, 0.00622712, 1.31053],
        [0.075, 0.00670611, 1.31062],
        [0.077, 0.00719567, 1.31057],
        [0.08, 0.00767466, 1.31059],
        [0.083, 0.008209, 1.31054],
        [0.085, 0.00874864, 1.31051],
        [0.088, 0.00928983, 1.31042],
        [0.091, 0.00987052, 1.31032],
        [0.093, 0.0104633, 1.31021],
        [0.096, 0.0110562, 1.31006],
        [0.099, 0.0116975, 1.30987],
        [0.101, 0.012342, 1.30976],
        [0.104, 0.0129849, 1.30956],
        [0.107, 0.0136362, 1.30941],
        [0.109, 0.0143413, 1.30914],
        [0.112, 0.015079, 1.30888],
        [0.115, 0.0157804, 1.30867],
        [0.117, 0.0165371, 1.30836],
        [0.12, 0.0172833, 1.30801],
        [0.123, 0.0180363, 1.30775],
        [0.125, 0.0188431, 1.30743],
        [0.128, 0.0196583, 1.30701],
        [0.131, 0.0205062, 1.30669],
        [0.133, 0.0213646, 1.30633],
        [0.136, 0.0222231, 1.30585],
        [0.139, 0.0230793, 1.3055],
        [0.141, 0.0239894, 1.30497],
        [0.144, 0.0249063, 1.30455],
        [0.147, 0.0258164, 1.30407],
        [0.149, 0.0267849, 1.30355],
        [0.152, 0.0277451, 1.30307],
        [0.155, 0.0287152, 1.3025],
        [0.157, 0.029727, 1.30197],
        [0.16, 0.0307129, 1.30137],
        [0.163, 0.0317763, 1.30075],
        [0.165, 0.0327965, 1.30016],
        [0.168, 0.0338789, 1.29952],
        [0.171, 0.0349492, 1.29888],
        [0.173, 0.0360748, 1.29825],
        [0.176, 0.0371967, 1.29752],
        [0.179, 0.0383291, 1.29682],
        [0.181, 0.0394526, 1.29609],
        [0.184, 0.0406351, 1.29532],
        [0.187, 0.0418192, 1.29462],
        [0.189, 0.0430481, 1.29381],
        [0.192, 0.044239, 1.29306],
        [0.195, 0.0454747, 1.29219],
        [0.197, 0.0467605, 1.29135],
        [0.2, 0.0479962, 1.29054],
        [0.203, 0.0493336, 1.28965],
        [0.205, 0.0506194, 1.2887],
        [0.208, 0.0519136, 1.28785],
        [0.211, 0.0532526, 1.28694],
        [0.213, 0.0546507, 1.28593],
        [0.216, 0.0559897, 1.28502],
        [0.219, 0.0573856, 1.28406],
        [0.221, 0.0588285, 1.283],
        [0.224, 0.0602349, 1.28199],
        [0.227, 0.0616756, 1.28093],
        [0.229, 0.0631337, 1.27987],
        [0.232, 0.0646245, 1.27883],
        [0.235, 0.0660826, 1.27771],
        [0.237, 0.0676356, 1.27665],
        [0.24, 0.0691453, 1.27548],
        [0.243, 0.0706983, 1.27435],
        [0.245, 0.0722596, 1.27316],
        [0.248, 0.0738195, 1.27196],
        [0.251, 0.0754241, 1.27078],
        [0.253, 0.0770355, 1.2696],
        [0.256, 0.0786917, 1.26832],
        [0.259, 0.0803032, 1.26706],
        [0.261, 0.0819768, 1.26577],
        [0.264, 0.0836831, 1.2645],
        [0.267, 0.0853531, 1.2632],
        [0.269, 0.0870715, 1.26182],
        [0.272, 0.0887862, 1.26048],
        [0.275, 0.0905616, 1.2591],
        [0.277, 0.0923369, 1.25775],
        [0.28, 0.0941033, 1.25628],
        [0.283, 0.0959234, 1.25488],
        [0.285, 0.0977504, 1.25343],
        [0.288, 0.0995842, 1.25193],
        [0.291, 0.101402, 1.2505],
        [0.293, 0.103279, 1.24895],
        [0.296, 0.105158, 1.24744],
        [0.299, 0.107088, 1.24591],
        [0.301, 0.109027, 1.24439],
        [0.304, 0.110958, 1.24279],
        [0.307, 0.112895, 1.24121],
        [0.309, 0.114875, 1.23959],
        [0.312, 0.116868, 1.23795],
        [0.315, 0.118855, 1.23635],
        [0.317, 0.120887, 1.23468],
        [0.32, 0.122931, 1.23303],
        [0.323, 0.12497, 1.23128],
        [0.325, 0.127064, 1.2296],
        [0.328, 0.129158, 1.2278],
        [0.331, 0.131248, 1.22612],
        [0.333, 0.133394, 1.22428],
        [0.336, 0.135538, 1.22251],
        [0.339, 0.137691, 1.22069],
        [0.341, 0.139844, 1.21889],
        [0.344, 0.142048, 1.21704],
        [0.347, 0.144252, 1.21519],
        [0.349, 0.1465, 1.21335],
        [0.352, 0.148747, 1.21139],
        [0.355, 0.151001, 1.20948],
        [0.357, 0.153257, 1.2076],
        [0.36, 0.155574, 1.20562],
        [0.363, 0.15788, 1.20364],
        [0.365, 0.160229, 1.20168],
        [0.368, 0.162554, 1.19969],
        [0.371, 0.164912, 1.19766],
        [0.373, 0.167323, 1.19565],
        [0.376, 0.169741, 1.19363],
        [0.379, 0.172151, 1.19155],
        [0.381, 0.17457, 1.18951],
        [0.384, 0.176997, 1.18738],
        [0.387, 0.179467, 1.18529],
        [0.389, 0.181982, 1.18317],
        [0.392, 0.184449, 1.18107],
        [0.395, 0.186971, 1.17889],
        [0.397, 0.189503, 1.1767],
        [0.4, 0.192076, 1.17452],
        [0.403, 0.194649, 1.17238],
        [0.405, 0.197222, 1.17017],
        [0.408, 0.199846, 1.16791],
        [0.411, 0.202436, 1.16566],
        [0.413, 0.205068, 1.16343],
        [0.416, 0.207736, 1.16119],
        [0.419, 0.210428, 1.15889],
        [0.421, 0.213104, 1.15669],
        [0.424, 0.215797, 1.15435],
        [0.427, 0.218534, 1.15207],
        [0.429, 0.221269, 1.14972],
        [0.432, 0.224013, 1.14739],
        [0.435, 0.226801, 1.14504],
        [0.437, 0.22959, 1.14269],
        [0.44, 0.232385, 1.14036],
        [0.443, 0.235233, 1.13799],
        [0.445, 0.238071, 1.13555],
        [0.448, 0.240871, 1.13319],
        [0.451, 0.243706, 1.1308],
        [0.453, 0.246605, 1.12839],
        [0.456, 0.249504, 1.12599],
        [0.459, 0.252444, 1.12356],
        [0.461, 0.255362, 1.12116],
        [0.464, 0.258354, 1.11864],
        [0.467, 0.261315, 1.11623],
        [0.469, 0.264314, 1.11375],
        [0.472, 0.267325, 1.1113],
        [0.475, 0.270334, 1.10884],
        [0.477, 0.273388, 1.10634],
        [0.48, 0.276383, 1.10383],
        [0.483, 0.279452, 1.10137],
        [0.485, 0.28256, 1.09889],
        [0.488, 0.285407, 1.09639],
        [0.491, 0.288517, 1.09384],
        [0.493, 0.291572, 1.09134],
        [0.496, 0.294572, 1.08883],
        [0.499, 0.297736, 1.08632],
        [0.501, 0.300798, 1.08382],
        [0.504, 0.304014, 1.08122],
        [0.507, 0.307131, 1.07867],
        [0.509, 0.310397, 1.07612],
        [0.512, 0.31362, 1.07361],
        [0.515, 0.316898, 1.0711],
        [0.517, 0.320214, 1.0685],
        [0.52, 0.323056, 1.06599],
        [0.523, 0.326381, 1.06344],
        [0.525, 0.329718, 1.06087],
        [0.528, 0.333085, 1.05838],
        [0.531, 0.336465, 1.05578],
        [0.533, 0.339251, 1.05332],
        [0.536, 0.342681, 1.0507],
        [0.539, 0.344808, 1.04821],
        [0.541, 0.348245, 1.04565],
        [0.544, 0.351682, 1.04309],
        [0.547, 0.354393, 1.04053],
        [0.549, 0.357882, 1.03798],
        [0.552, 0.361219, 1.03543],
        [0.555, 0.364708, 1.03288],
        [0.557, 0.368239, 1.03037],
        [0.56, 0.37178, 1.02782],
        [0.563, 0.374348, 1.02522],
        [0.565, 0.377948, 1.02273],
        [0.568, 0.380998, 1.02017],
        [0.571, 0.384588, 1.01766],
        [0.573, 0.387637, 1.01515],
        [0.576, 0.391234, 1.0126],
        [0.579, 0.394885, 1.0101],
        [0.581, 0.396967, 1.00755],
        [0.584, 0.400607, 1.00505],
        [0.587, 0.403609, 1.00255],
        [0.589, 0.407312, 1.00005],
        [0.592, 0.409544, 0.997577],
        [0.595, 0.413253, 0.995097],
        [0.597, 0.416962, 0.992588],
        [0.6, 0.420704, 0.990134],
        [0.603, 0.424458, 0.987648],
        [0.605, 0.424758, 0.985186],
        [0.608, 0.428511, 0.982706],
        [0.611, 0.43226, 0.98024],
        [0.613, 0.4351, 0.977794],
        [0.616, 0.438861, 0.975343],
        [0.619, 0.439591, 0.972887],
        [0.621, 0.4434, 0.970449],
        [0.624, 0.447211, 0.968059],
        [0.627, 0.448742, 0.965549],
        [0.629, 0.452602, 0.963103],
        [0.632, 0.456413, 0.960761],
        [0.635, 0.459045, 0.958315],
        [0.637, 0.462907, 0.955971],
        [0.64, 0.466775, 0.953569],
        [0.643, 0.469337, 0.951189],
        [0.645, 0.473248, 0.948837],
        [0.648, 0.477159, 0.946435],
        [0.651, 0.478067, 0.944092],
        [0.653, 0.481985, 0.941758],
        [0.656, 0.485947, 0.93941],
        [0.659, 0.488247, 0.937117],
        [0.661, 0.49221, 0.934741],
        [0.664, 0.496191, 0.932441],
        [0.667, 0.491162, 0.930056],
        [0.669, 0.49508, 0.927843],
        [0.672, 0.499042, 0.925574],
        [0.675, 0.50301, 0.923236],
        [0.677, 0.503967, 0.921002],
        [0.68, 0.507946, 0.9187],
        [0.683, 0.511957, 0.916481],
        [0.685, 0.511571, 0.914224],
        [0.688, 0.515539, 0.912],
        [0.691, 0.519568, 0.909747],
        [0.693, 0.523586, 0.907529],
        [0.696, 0.522761, 0.90535],
        [0.699, 0.526746, 0.903143],
        [0.701, 0.530807, 0.900933],
        [0.704, 0.534836, 0.898788],
        [0.707, 0.528109, 0.89656],
        [0.709, 0.532129, 0.894436],
        [0.712, 0.536146, 0.892265],
        [0.715, 0.540169, 0.890185],
        [0.717, 0.543449, 0.888059],
        [0.72, 0.547509, 0.885879],
        [0.723, 0.551544, 0.883783],
        [0.725, 0.55562, 0.881662],
        [0.728, 0.546535, 0.879581],
        [0.731, 0.550552, 0.877499],
        [0.733, 0.554584, 0.875429],
        [0.736, 0.558651, 0.873408],
        [0.739, 0.562675, 0.871284],
        [0.741, 0.566752, 0.869249],
        [0.744, 0.570825, 0.867281],
        [0.747, 0.574954, 0.865215],
        [0.749, 0.57903, 0.863218],
        [0.752, 0.583165, 0.86121],
        [0.755, 0.583215, 0.859273],
        [0.757, 0.587351, 0.857261],
        [0.76, 0.59152, 0.855254],
        [0.763, 0.595655, 0.853369],
        [0.765, 0.599841, 0.851368],
        [0.768, 0.594897, 0.849454],
        [0.771, 0.599031, 0.84757],
        [0.773, 0.6032, 0.845563],
        [0.776, 0.607341, 0.843735],
        [0.779, 0.611527, 0.841738],
        [0.781, 0.595367, 0.839879],
        [0.784, 0.599438, 0.838107],
        [0.787, 0.60352, 0.836154],
        [0.789, 0.607644, 0.834324],
        [0.792, 0.611733, 0.832423],
        [0.795, 0.615857, 0.830614],
        [0.797, 0.614299, 0.828798],
        [0.8, 0.618423, 0.826993],
        [0.803, 0.622556, 0.825205],
        [0.805, 0.626678, 0.823361],
        [0.808, 0.630862, 0.821657],
        [0.811, 0.612742, 0.819796],
        [0.813, 0.616761, 0.818089],
        [0.816, 0.620831, 0.816332],
        [0.819, 0.624858, 0.814574],
        [0.821, 0.628946, 0.812837],
        [0.824, 0.63306, 0.81113],
        [0.827, 0.637137, 0.809384],
        [0.829, 0.638857, 0.807754],
        [0.832, 0.64299, 0.80602],
        [0.835, 0.64711, 0.804347],
        [0.837, 0.65125, 0.802622],
        [0.84, 0.655422, 0.801056],
        [0.843, 0.659562, 0.799361],
        [0.845, 0.647597, 0.797772],
        [0.848, 0.651685, 0.796066],
        [0.851, 0.655806, 0.794475],
        [0.853, 0.659926, 0.792906],
        [0.856, 0.664064, 0.791257],
        [0.859, 0.668191, 0.789725],
        [0.861, 0.672374, 0.788083],
        [0.864, 0.676508, 0.786532],
        [0.867, 0.671524, 0.784987],
        [0.869, 0.67565, 0.783437],
        [0.872, 0.679832, 0.781892],
        [0.875, 0.683967, 0.780356],
        [0.877, 0.688155, 0.778856],
        [0.88, 0.692334, 0.77738],
        [0.883, 0.696565, 0.77579],
        [0.885, 0.680006, 0.774354],
        [0.888, 0.684137, 0.772906],
        [0.891, 0.68822, 0.771389],
        [0.893, 0.692346, 0.76993],
        [0.896, 0.696525, 0.768487],
        [0.899, 0.700653, 0.767011],
        [0.901, 0.70483, 0.765627],
        [0.904, 0.709018, 0.764187],
        [0.907, 0.701404, 0.762794],
        [0.909, 0.705541, 0.761375],
        [0.912, 0.709667, 0.759984],
        [0.915, 0.713799, 0.758593],
        [0.917, 0.717987, 0.757175],
        [0.92, 0.722165, 0.755878],
        [0.923, 0.726351, 0.754517],
        [0.925, 0.730579, 0.753173],
        [0.928, 0.734775, 0.751797],
        [0.931, 0.698545, 0.750462],
        [0.933, 0.702568, 0.749188],
        [0.936, 0.706591, 0.747862],
        [0.939, 0.710615, 0.746572],
        [0.941, 0.714687, 0.745309],
        [0.944, 0.718717, 0.743995],
        [0.947, 0.722791, 0.742705],
        [0.949, 0.726865, 0.741436],
        [0.952, 0.730944, 0.740204],
        [0.955, 0.735062, 0.738992],
        [0.957, 0.71979, 0.737704],
        [0.96, 0.723812, 0.736489],
        [0.963, 0.727842, 0.735258],
        [0.965, 0.731864, 0.734044],
        [0.968, 0.735894, 0.73282],
        [0.971, 0.739966, 0.731644],
        [0.973, 0.744039, 0.730474],
        [0.976, 0.74812, 0.729267],
        [0.979, 0.752236, 0.728139],
        [0.981, 0.756317, 0.726925],
        [0.984, 0.724768, 0.725805],
        [0.987, 0.728727, 0.724688],
        [0.989, 0.732646, 0.72355],
        [0.992, 0.736617, 0.722454],
        [0.995, 0.740583, 0.721243],
        [0.997, 0.744554, 0.720156],
        [1, 0.748531, 0.719063],
        [1.003, 0.752542, 0.717951],
        [1.005, 0.756519, 0.716882],
        [1.008, 0.76054, 0.715772],
        [1.011, 0.764612, 0.71476],
        [1.013, 0.758301, 0.713703],
        [1.016, 0.762322, 0.712633],
        [1.019, 0.766332, 0.711588],
        [1.021, 0.770353, 0.710554],
        [1.024, 0.774381, 0.709537],
        [1.027, 0.778409, 0.708549],
        [1.029, 0.782438, 0.707532],
        [1.032, 0.786509, 0.706504],
        [1.035, 0.790589, 0.705521],
        [1.037, 0.794667, 0.704505],
        [1.04, 0.798739, 0.703545],
        [1.043, 0.802869, 0.702531],
        [1.045, 0.806948, 0.701588],
        [1.048, 0.762896, 0.700637],
        [1.051, 0.76676, 0.699684],
        [1.053, 0.770679, 0.698732],
        [1.056, 0.774593, 0.697784],
        [1.059, 0.778501, 0.696867],
        [1.061, 0.782425, 0.695915],
        [1.064, 0.786341, 0.695023],
        [1.067, 0.790308, 0.694118],
        [1.069, 0.794278, 0.693225],
        [1.072, 0.798243, 0.69236],
        [1.075, 0.80222, 0.691354],
        [1.077, 0.806185, 0.690507],
        [1.08, 0.810205, 0.689622],
        [1.083, 0.814181, 0.688768],
        [1.085, 0.818209, 0.687916],
        [1.088, 0.822225, 0.68707],
        [1.091, 0.826252, 0.686273],
        [1.093, 0.830323, 0.685432],
        [1.096, 0.83435, 0.684624],
        [1.099, 0.838428, 0.683774],
        [1.101, 0.842505, 0.682926],
        [1.104, 0.846585, 0.682191],
        [1.107, 0.850706, 0.681339],
        [1.109, 0.854791, 0.680498],
        [1.112, 0.85892, 0.679762],
        [1.115, 0.863048, 0.678961],
        [1.117, 0.867178, 0.678215],
        [1.12, 0.871307, 0.677432],
        [1.123, 0.875487, 0.676686],
        [1.125, 0.779401, 0.675938],
        [1.128, 0.783103, 0.675157],
        [1.131, 0.786812, 0.674373],
        [1.133, 0.790514, 0.673672],
        [1.136, 0.794258, 0.67298],
        [1.139, 0.797967, 0.672208],
        [1.141, 0.80172, 0.671496],
        [1.144, 0.80548, 0.670814],
        [1.147, 0.809233, 0.670049],
        [1.149, 0.812994, 0.669387],
        [1.152, 0.816796, 0.668665],
        [1.155, 0.820557, 0.668018],
        [1.157, 0.824361, 0.66733],
        [1.16, 0.828172, 0.666641],
        [1.163, 0.831977, 0.666014],
        [1.165, 0.835788, 0.665333],
        [1.168, 0.839599, 0.6647],
        [1.171, 0.803643, 0.664056],
        [1.173, 0.807285, 0.663412],
        [1.176, 0.810985, 0.662734],
        [1.179, 0.814688, 0.662078],
        [1.181, 0.818341, 0.661485],
        [1.184, 0.822043, 0.660885],
        [1.187, 0.825746, 0.660206],
        [1.189, 0.829486, 0.659634],
        [1.192, 0.833195, 0.658997],
        [1.195, 0.836947, 0.658428],
        [1.197, 0.840658, 0.657877],
        [1.2, 0.844417, 0.657253],
        [1.203, 0.848176, 0.656674],
        [1.205, 0.851918, 0.656087],
        [1.208, 0.855721, 0.65555],
        [1.211, 0.859487, 0.654977],
        [1.213, 0.863291, 0.654359],
        [1.216, 0.867095, 0.653871],
        [1.219, 0.870906, 0.65326],
        [1.221, 0.874717, 0.652733],
        [1.224, 0.830454, 0.652164],
        [1.227, 0.83405, 0.651731],
        [1.229, 0.837701, 0.65116],
        [1.232, 0.841339, 0.650587],
        [1.235, 0.84499, 0.65014],
        [1.237, 0.848637, 0.649582],
        [1.24, 0.852294, 0.649067],
        [1.243, 0.855934, 0.648631],
        [1.245, 0.859642, 0.6481],
        [1.248, 0.863342, 0.64758],
        [1.251, 0.867032, 0.647114],
        [1.253, 0.870741, 0.646685],
        [1.256, 0.874449, 0.646168],
        [1.259, 0.878147, 0.64567],
        [1.261, 0.881855, 0.645269],
        [1.264, 0.885607, 0.644707],
        [1.267, 0.889359, 0.644315],
        [1.269, 0.893108, 0.643903],
        [1.272, 0.896867, 0.643381],
        [1.275, 0.900626, 0.64302],
        [1.277, 0.904385, 0.64255],
        [1.28, 0.908144, 0.642077],
        [1.283, 0.853359, 0.641706],
        [1.285, 0.856896, 0.641249],
        [1.288, 0.860441, 0.640869],
        [1.291, 0.86404, 0.640407],
        [1.293, 0.867583, 0.64004],
        [1.296, 0.871172, 0.639624],
        [1.299, 0.874771, 0.639196],
        [1.301, 0.878366, 0.638785],
        [1.304, 0.881954, 0.638417],
        [1.307, 0.88556, 0.638051],
        [1.309, 0.889199, 0.637629],
        [1.312, 0.892794, 0.637272],
        [1.315, 0.896443, 0.636903],
        [1.317, 0.90009, 0.636538],
        [1.32, 0.903745, 0.636168],
        [1.323, 0.907385, 0.635801],
        [1.325, 0.911041, 0.635438],
        [1.328, 0.914731, 0.635122],
        [1.331, 0.918389, 0.634763],
        [1.333, 0.922096, 0.634416],
        [1.336, 0.925785, 0.634061],
        [1.339, 0.929492, 0.633736],
        [1.341, 0.933191, 0.633473],
        [1.344, 0.936898, 0.633068],
        [1.347, 0.940605, 0.632744],
        [1.349, 0.944363, 0.632437],
        [1.352, 0.839124, 0.632118],
        [1.355, 0.842456, 0.631806],
        [1.357, 0.845772, 0.6315],
        [1.36, 0.849103, 0.631271],
        [1.363, 0.852426, 0.630889],
        [1.365, 0.855766, 0.630669],
        [1.368, 0.859132, 0.63035],
        [1.371, 0.862464, 0.630094],
        [1.373, 0.865847, 0.62975],
        [1.376, 0.86922, 0.629444],
        [1.379, 0.87256, 0.629234],
        [1.381, 0.875944, 0.628926],
        [1.384, 0.879361, 0.628703],
        [1.387, 0.882745, 0.628396],
        [1.389, 0.886135, 0.628195],
        [1.392, 0.889551, 0.627892],
        [1.395, 0.892943, 0.627684],
        [1.397, 0.896376, 0.627383],
        [1.4, 0.899811, 0.627219],
        [1.403, 0.903246, 0.626866],
        [1.405, 0.906669, 0.626702],
        [1.408, 0.910111, 0.62641],
        [1.411, 0.913546, 0.626237],
        [1.413, 0.917031, 0.625987],
        [1.416, 0.920473, 0.625788],
        [1.419, 0.923958, 0.625538],
        [1.421, 0.927443, 0.625328],
        [1.424, 0.930885, 0.62512],
        [1.427, 0.93442, 0.624956],
        [1.429, 0.937914, 0.624673],
        [1.432, 0.941399, 0.62455],
        [1.435, 0.921942, 0.624257],
        [1.437, 0.925383, 0.624147],
        [1.44, 0.928808, 0.623917],
        [1.443, 0.932284, 0.623747],
        [1.445, 0.935726, 0.623562],
        [1.448, 0.939168, 0.623408],
        [1.451, 0.942653, 0.623208],
        [1.453, 0.946095, 0.623093],
        [1.456, 0.94958, 0.622902],
        [1.459, 0.953065, 0.622748],
        [1.461, 0.956557, 0.622554],
        [1.464, 0.960042, 0.622401],
        [1.467, 0.963534, 0.622196],
        [1.469, 0.967071, 0.622037],
        [1.472, 0.970563, 0.621934],
        [1.475, 0.9741, 0.62175],
        [1.477, 0.977635, 0.621635],
        [1.48, 0.981128, 0.62146],
        [1.483, 0.98467, 0.621338],
        [1.485, 0.988214, 0.62125],
        [1.488, 0.991801, 0.621046],
        [1.491, 0.995337, 0.620949],
        [1.493, 0.998898, 0.6208],
        [1.496, 1.00249, 0.620709],
        [1.499, 1.00607, 0.620605],
        [1.501, 1.00962, 0.620455],
        [1.504, 1.01321, 0.62042],
        [1.507, 1.01681, 0.620226],
        [1.509, 1.02041, 0.620173],
        [1.512, 1.02405, 0.620039],
        [1.515, 1.02765, 0.619931],
        [1.517, 1.03125, 0.619827],
        [1.52, 1.03489, 0.619705],
        [1.523, 1.03854, 0.61968],
        [1.525, 1.04218, 0.619541],
        [1.528, 1.04584, 0.619495],
        [1.531, 1.04948, 0.619363],
        [1.533, 0.815999, 0.619262],
        [1.536, 0.818799, 0.619259],
        [1.539, 0.821644, 0.61917],
        [1.541, 0.824533, 0.619076],
        [1.544, 0.827378, 0.61898],
        [1.547, 0.830224, 0.618948],
        [1.549, 0.833076, 0.618885],
        [1.552, 0.835964, 0.618751],
        [1.555, 0.838863, 0.618764],
        [1.557, 0.841717, 0.618691],
        [1.56, 0.844612, 0.618628],
        [1.563, 0.847508, 0.618629],
        [1.565, 0.850403, 0.618507],
        [1.568, 0.8533, 0.618494],
        [1.571, 0.856206, 0.618505],
        [1.573, 0.859103, 0.618406],
        [1.576, 0.861998, 0.618367],
        [1.579, 0.864945, 0.618302],
        [1.581, 0.867851, 0.618331],
        [1.584, 0.870798, 0.618293],
        [1.587, 0.873745, 0.618261],
        [1.589, 0.87666, 0.61821],
        [1.592, 0.879605, 0.618178],
        [1.595, 0.882552, 0.618176],
        [1.597, 0.88551, 0.618187],
        [1.6, 0.888457, 0.618101],
        [1.603, 0.891464, 0.618159],
        [1.605, 0.894411, 0.618118],
        [1.608, 0.897367, 0.618129],
        [1.611, 0.900374, 0.618123],
        [1.613, 0.903328, 0.618103],
        [1.616, 0.906336, 0.618117],
        [1.619, 0.909335, 0.618074],
        [1.621, 0.912342, 0.618094],
        [1.624, 0.915339, 0.61816],
        [1.627, 0.918355, 0.618118],
        [1.629, 0.921352, 0.618191],
        [1.632, 0.924368, 0.618131],
        [1.635, 0.927367, 0.618153],
        [1.637, 0.930425, 0.618216],
        [1.64, 0.933441, 0.618173],
        [1.643, 0.93649, 0.618227],
        [1.645, 0.939549, 0.61829],
        [1.648, 0.94256, 0.618269],
        [1.651, 0.945619, 0.618278],
        [1.653, 0.948685, 0.618375],
        [1.656, 0.899065, 0.618404],
        [1.659, 0.90196, 0.618359],
        [1.661, 0.904856, 0.618474],
        [1.664, 0.90777, 0.618456],
        [1.667, 0.910665, 0.618507],
        [1.669, 0.913606, 0.618611],
        [1.672, 0.916508, 0.618603],
        [1.675, 0.919465, 0.618659],
        [1.677, 0.922361, 0.618721],
        [1.68, 0.925308, 0.618771],
        [1.683, 0.928264, 0.618843],
        [1.685, 0.931211, 0.618921],
        [1.688, 0.934158, 0.618934],
        [1.691, 0.937122, 0.619002],
        [1.693, 0.940069, 0.619101],
        [1.696, 0.943022, 0.619178],
        [1.699, 0.945979, 0.619203],
        [1.701, 0.948976, 0.619311],
        [1.704, 0.951941, 0.619389],
        [1.707, 0.954938, 0.619386],
        [1.709, 0.957897, 0.619541],
        [1.712, 0.960901, 0.619609],
        [1.715, 0.963898, 0.61964],
        [1.717, 0.966906, 0.619746],
        [1.72, 0.969904, 0.619875],
        [1.723, 0.972919, 0.619889],
        [1.725, 0.975923, 0.619997],
        [1.728, 0.978932, 0.620119],
        [1.731, 0.98199, 0.620189],
        [1.733, 0.984995, 0.620319],
        [1.736, 0.988053, 0.620382],
        [1.739, 0.991058, 0.6205],
        [1.741, 0.994117, 0.620658],
        [1.744, 0.997184, 0.620683],
        [1.747, 1.00019, 0.620802],
        [1.749, 1.00325, 0.620879],
        [1.752, 1.0063, 0.620986],
        [1.755, 1.00941, 0.621148],
        [1.757, 1.01248, 0.62123],
        [1.76, 1.01554, 0.621391],
        [1.763, 1.0186, 0.621426],
        [1.765, 1.02171, 0.621581],
        [1.768, 1.02478, 0.621737],
        [1.771, 1.02787, 0.621772],
        [1.773, 1.03099, 0.621944],
        [1.776, 1.0341, 0.62202],
        [1.779, 1.03722, 0.622221],
        [1.781, 1.04033, 0.622306],
        [1.784, 1.04343, 0.62245],
        [1.787, 1.04655, 0.622651],
        [1.789, 1.04967, 0.622726],
        [1.792, 1.05279, 0.622857],
        [1.795, 1.05595, 0.623021],
        [1.797, 1.05907, 0.623146],
        [1.8, 1.06223, 0.623304],
        [1.803, 1.06539, 0.62338],
        [1.805, 1.06851, 0.623594],
        [1.808, 1.07167, 0.623663],
        [1.811, 1.07484, 0.623844],
        [1.813, 0.858335, 0.62397],
        [1.816, 0.860856, 0.624145],
        [1.819, 0.863377, 0.624308],
        [1.821, 0.865905, 0.624433],
        [1.824, 0.86847, 0.624555],
        [1.827, 0.870999, 0.624761],
        [1.829, 0.87352, 0.624887],
        [1.832, 0.876102, 0.625113],
        [1.835, 0.878625, 0.625239],
        [1.837, 0.881196, 0.625395],
        [1.84, 0.883769, 0.625572],
        [1.843, 0.88634, 0.625709],
        [1.845, 0.888881, 0.625924],
        [1.848, 0.891452, 0.62605],
        [1.851, 0.894025, 0.626224],
        [1.853, 0.896604, 0.626445],
        [1.856, 0.899186, 0.626576],
        [1.859, 0.901766, 0.626752],
        [1.861, 0.904382, 0.626924],
        [1.864, 0.906962, 0.627097],
        [1.867, 0.909545, 0.627317],
        [1.869, 0.912166, 0.627438],
        [1.872, 0.914746, 0.627665],
        [1.875, 0.91738, 0.627828],
        [1.877, 0.920003, 0.628053],
        [1.88, 0.922582, 0.628247],
        [1.883, 0.925216, 0.628376],
        [1.885, 0.927839, 0.62858],
        [1.888, 0.930481, 0.628793],
        [1.891, 0.933103, 0.628989],
        [1.893, 0.935733, 0.629116],
        [1.896, 0.938367, 0.629329],
        [1.899, 0.940998, 0.629614],
        [1.901, 0.943682, 0.629795],
        [1.904, 0.946304, 0.629972],
        [1.907, 0.948946, 0.63015],
        [1.909, 0.951619, 0.630413],
        [1.912, 0.954261, 0.630638],
        [1.915, 0.956941, 0.630785],
        [1.917, 0.959626, 0.631005],
        [1.92, 0.962299, 0.63122],
        [1.923, 0.964941, 0.631457],
        [1.925, 0.967621, 0.631677],
        [1.928, 0.970306, 0.631817],
        [1.931, 0.972987, 0.632026],
        [1.933, 0.975679, 0.632264],
        [1.936, 0.978402, 0.632478],
        [1.939, 0.981088, 0.632748],
        [1.941, 0.983779, 0.632898],
        [1.944, 0.986461, 0.633169],
        [1.947, 0.989203, 0.633346],
        [1.949, 0.991884, 0.633609],
        [1.952, 0.994619, 0.633834],
        [1.955, 0.997355, 0.634034],
        [1.957, 1.00004, 0.634294],
        [1.96, 1.00278, 0.634482],
        [1.963, 1.00552, 0.634753],
        [1.965, 1.00826, 0.634942],
        [1.968, 1.01099, 0.635216],
        [1.971, 1.01373, 0.635436],
        [1.973, 1.01647, 0.635666],
        [1.976, 1.01921, 0.63592],
        [1.979, 1.02199, 0.636166],
        [1.981, 1.02473, 0.636353],
        [1.984, 1.02753, 0.636637],
        [1.987, 1.03026, 0.636857],
        [1.989, 1.03304, 0.637093],
        [1.992, 1.0358, 0.637367],
        [1.995, 1.03859, 0.637599],
        [1.997, 1.04137, 0.637824],
        [2, 1.04416, 0.638054],
        [2.003, 1.04691, 0.638338],
        [2.005, 1.0497, 0.638615],
        [2.008, 1.05249, 0.638888],
        [2.011, 1.05533, 0.639122],
        [2.013, 1.05812, 0.639305],
        [2.016, 1.06092, 0.639638],
        [2.019, 1.06371, 0.639859],
        [2.021, 1.06655, 0.640152],
        [2.024, 1.06934, 0.640379],
        [2.027, 0.909824, 0.640596],
        [2.029, 0.912236, 0.640925],
        [2.032, 0.914647, 0.64116],
        [2.035, 0.917067, 0.641443],
        [2.037, 0.919432, 0.641723],
        [2.04, 0.921845, 0.641906],
        [2.043, 0.924265, 0.64223],
        [2.045, 0.926683, 0.642462],
        [2.048, 0.929091, 0.642794],
        [2.051, 0.931511, 0.643029],
        [2.053, 0.93393, 0.643292],
        [2.056, 0.936393, 0.64359],
        [2.059, 0.938813, 0.64381],
        [2.061, 0.941232, 0.644145],
        [2.064, 0.943684, 0.644377],
        [2.067, 0.946111, 0.644648],
        [2.069, 0.948573, 0.64504],
        [2.072, 0.951001, 0.645223],
        [2.075, 0.953464, 0.645512],
        [2.077, 0.95589, 0.645784],
        [2.08, 0.958353, 0.646066],
        [2.083, 0.960814, 0.64636],
        [2.085, 0.963283, 0.646676],
        [2.088, 0.965753, 0.646915],
        [2.091, 0.968224, 0.647199],
        [2.093, 0.970694, 0.647482],
        [2.096, 0.973163, 0.647797],
        [2.099, 0.975634, 0.648091],
        [2.101, 0.978111, 0.648412],
        [2.104, 0.980625, 0.648612],
        [2.107, 0.983096, 0.648937],
        [2.109, 0.985573, 0.649231],
        [2.112, 0.988087, 0.649545],
        [2.115, 0.990563, 0.649878],
        [2.117, 0.993078, 0.650112],
        [2.12, 0.995556, 0.650406],
        [2.123, 0.998077, 0.650733],
        [2.125, 1.0006, 0.65098],
        [2.128, 1.00312, 0.651354],
        [2.131, 1.00564, 0.651634],
        [2.133, 1.00812, 0.651966],
        [2.136, 1.01064, 0.652201],
        [2.139, 1.01316, 0.652484],
        [2.141, 1.01574, 0.652819],
        [2.144, 1.01826, 0.653144],
        [2.147, 1.02078, 0.653483],
        [2.149, 1.02331, 0.653772],
        [2.152, 1.02588, 0.654095],
        [2.155, 1.0284, 0.654377],
        [2.157, 1.03093, 0.654678],
        [2.16, 1.0335, 0.654995],
        [2.163, 1.03604, 0.655291],
        [2.165, 1.03861, 0.65563],
        [2.168, 1.04118, 0.655944],
        [2.171, 1.04375, 0.65624],
        [2.173, 1.04628, 0.656622],
        [2.176, 1.04886, 0.656859],
        [2.179, 1.05144, 0.657191],
        [2.181, 1.05401, 0.657539],
        [2.184, 1.05659, 0.657869],
        [2.187, 1.05917, 0.658201],
        [2.189, 1.06175, 0.658528],
        [2.192, 1.06437, 0.658864],
        [2.195, 1.06695, 0.659153],
        [2.197, 1.06953, 0.659431],
        [2.2, 1.07215, 0.659777],
        [2.203, 1.07473, 0.660109],
        [2.205, 1.07731, 0.660475],
        [2.208, 1.07994, 0.660832],
        [2.211, 1.08257, 0.66111],
        [2.213, 1.08515, 0.661442],
        [2.216, 1.08778, 0.661728],
        [2.219, 1.09041, 0.662077],
        [2.221, 1.09304, 0.662433],
        [2.224, 1.09567, 0.662783],
        [2.227, 1.0983, 0.663095],
        [2.229, 1.10093, 0.663452],
        [2.232, 1.10356, 0.663791],
        [2.235, 1.10619, 0.664034],
        [2.237, 1.10883, 0.664419],
        [2.24, 1.11145, 0.664797],
        [2.243, 1.11414, 0.665148],
        [2.245, 1.11677, 0.66547],
        [2.248, 1.11945, 0.665802],
        [2.251, 1.12208, 0.666143],
        [2.253, 1.12477, 0.666539],
        [2.256, 1.1274, 0.666817],
        [2.259, 1.13007, 0.667201],
        [2.261, 1.13277, 0.667486],
        [2.264, 1.1354, 0.667874],
        [2.267, 1.13808, 0.668205],
        [2.269, 1.14077, 0.668548],
        [2.272, 1.14345, 0.668939],
        [2.275, 1.14614, 0.669267],
        [2.277, 1.14882, 0.669617],
        [2.28, 1.15151, 0.669936],
        [2.283, 1.15423, 0.670292],
        [2.285, 1.15692, 0.670657],
        [2.288, 1.1596, 0.670961],
        [2.291, 1.16234, 0.671344],
        [2.293, 1.16503, 0.671759],
        [2.296, 1.16776, 0.672114],
        [2.299, 1.17045, 0.672402],
        [2.301, 1.17318, 0.672753],
        [2.304, 1.17588, 0.673135],
        [2.307, 1.17862, 0.673477],
        [2.309, 1.18134, 0.673872],
        [2.312, 1.18409, 0.674243],
        [2.315, 1.18683, 0.674582],
        [2.317, 1.18955, 0.674963],
        [2.32, 1.19229, 0.675302],
        [2.323, 1.19504, 0.675647],
        [2.325, 1.19777, 0.676031],
        [2.328, 1.20051, 0.67637],
        [2.331, 1.20326, 0.676749],
        [2.333, 1.20605, 0.677107],
        [2.336, 1.20878, 0.677485],
        [2.339, 1.21153, 0.677868],
        [2.341, 0.684914, 0.678215],
        [2.344, 0.686466, 0.678588],
        [2.347, 0.688025, 0.678886],
        [2.349, 0.689588, 0.679325],
        [2.352, 0.691148, 0.6797],
        [2.355, 0.692743, 0.680058],
        [2.357, 0.694306, 0.680433],
        [2.36, 0.695865, 0.680783],
        [2.363, 0.697434, 0.681184],
        [2.365, 0.699031, 0.681595],
        [2.368, 0.70059, 0.681995],
        [2.371, 0.702153, 0.68238],
        [2.373, 0.703756, 0.682672],
        [2.376, 0.705326, 0.683054],
        [2.379, 0.706928, 0.683445],
        [2.381, 0.708488, 0.683773],
        [2.384, 0.710094, 0.684188],
        [2.387, 0.711696, 0.68456],
        [2.389, 0.713267, 0.684994],
        [2.392, 0.71487, 0.685341],
        [2.395, 0.716484, 0.685724],
        [2.397, 0.718043, 0.686145],
        [2.4, 0.719646, 0.686467],
        [2.403, 0.721266, 0.686845],
        [2.405, 0.72287, 0.687203],
        [2.408, 0.724482, 0.687637],
        [2.411, 0.726043, 0.688063],
        [2.413, 0.727662, 0.688409],
        [2.416, 0.729266, 0.688806],
        [2.419, 0.73088, 0.689185],
        [2.421, 0.732489, 0.689589],
        [2.424, 0.734103, 0.689968],
        [2.427, 0.735757, 0.690313],
        [2.429, 0.73737, 0.690704],
        [2.432, 0.73898, 0.691138],
        [2.435, 0.740594, 0.691523],
        [2.437, 0.742203, 0.691918],
        [2.44, 0.743868, 0.692314],
        [2.443, 0.745471, 0.692692],
        [2.445, 0.747093, 0.693084],
        [2.448, 0.748746, 0.693473],
        [2.451, 0.750366, 0.693902],
        [2.453, 0.751987, 0.694286],
        [2.456, 0.753641, 0.694694],
        [2.459, 0.755262, 0.695038],
        [2.461, 0.756915, 0.69547],
        [2.464, 0.758537, 0.69587],
        [2.467, 0.76019, 0.696269],
        [2.469, 0.761855, 0.696647],
        [2.472, 0.763476, 0.697047],
        [2.475, 0.765129, 0.697484],
        [2.477, 0.766794, 0.697878],
        [2.48, 0.768411, 0.6983],
        [2.483, 0.770075, 0.698715],
        [2.485, 0.77174, 0.699087],
        [2.488, 0.7734, 0.699423],
        [2.491, 0.775065, 0.699832],
        [2.493, 0.776725, 0.700267],
        [2.496, 0.77839, 0.700656],
        [2.499, 0.780061, 0.701085],
        [2.501, 0.781714, 0.701531],
        [2.504, 0.783386, 0.701878],
        [2.507, 0.785051, 0.702321],
        [2.509, 0.786712, 0.70275],
        [2.512, 0.788383, 0.703086],
        [2.515, 0.790054, 0.703538],
        [2.517, 0.79176, 0.703934],
        [2.52, 0.793424, 0.704314],
        [2.523, 0.795095, 0.704758],
        [2.525, 0.796756, 0.705172],
        [2.528, 0.798472, 0.705612],
        [2.531, 0.800143, 0.705992],
        [2.533, 0.801847, 0.706433],
        [2.536, 0.803519, 0.706822],
        [2.539, 0.805234, 0.70723],
        [2.541, 0.806913, 0.70765],
        [2.544, 0.808617, 0.708056],
        [2.547, 0.810288, 0.708534],
        [2.549, 0.812004, 0.708978],
        [2.552, 0.813726, 0.709318],
        [2.555, 0.815388, 0.709707],
        [2.557, 0.817102, 0.710115],
        [2.56, 0.818825, 0.710545],
        [2.563, 0.820496, 0.710948],
        [2.565, 0.822208, 0.711382],
        [2.568, 0.823924, 0.71183],
        [2.571, 0.825646, 0.712255],
        [2.573, 0.827368, 0.712697],
        [2.576, 0.829072, 0.713093],
        [2.579, 0.830795, 0.713545],
        [2.581, 0.832518, 0.713985],
        [2.584, 0.834239, 0.714388],
        [2.587, 0.835955, 0.714811],
        [2.589, 0.837667, 0.715176],
        [2.592, 0.83939, 0.715622],
        [2.595, 0.841154, 0.716064],
        [2.597, 0.842877, 0.716497],
        [2.6, 0.8446, 0.716934],
        [2.603, 0.846312, 0.717335],
        [2.605, 0.848077, 0.717757],
        [2.608, 0.849806, 0.718208],
        [2.611, 0.851529, 0.718612],
        [2.613, 0.853295, 0.719043],
        [2.616, 0.855018, 0.719433],
        [2.619, 0.856791, 0.719886],
        [2.621, 0.858503, 0.720374],
        [2.624, 0.860269, 0.720761],
        [2.627, 0.861999, 0.721252],
        [2.629, 0.863765, 0.721597],
        [2.632, 0.865538, 0.722047],
        [2.635, 0.86726, 0.722453],
        [2.637, 0.869033, 0.722901],
        [2.64, 0.870799, 0.723324],
        [2.643, 0.872529, 0.723782],
        [2.645, 0.874291, 0.724221],
        [2.648, 0.876057, 0.724619],
        [2.651, 0.87783, 0.72512],
        [2.653, 0.879603, 0.72554],
        [2.656, 0.881376, 0.725974],
        [2.659, 0.883149, 0.726437],
        [2.661, 0.884923, 0.726829],
        [2.664, 0.886696, 0.727279],
        [2.667, 0.888469, 0.727755],
        [2.669, 0.890242, 0.72811],
        [2.672, 0.892016, 0.728554],
        [2.675, 0.893789, 0.729],
        [2.677, 0.895605, 0.729493],
        [2.68, 0.897378, 0.729921],
        [2.683, 0.899152, 0.730319],
        [2.685, 0.900932, 0.73082],
        [2.688, 0.902748, 0.731218],
        [2.691, 0.904523, 0.731669],
        [2.693, 0.906346, 0.73216],
        [2.696, 0.90812, 0.732538],
        [2.699, 0.9099, 0.732987],
        [2.701, 0.911716, 0.733451],
        [2.704, 0.91354, 0.733885],
        [2.707, 0.915313, 0.734408],
        [2.709, 0.917138, 0.734823],
        [2.712, 0.918917, 0.735252],
        [2.715, 0.920735, 0.735661],
        [2.717, 0.922558, 0.736107],
        [2.72, 0.924339, 0.736537],
        [2.723, 0.926164, 0.736996],
        [2.725, 0.927987, 0.737486],
        [2.728, 0.929804, 0.737875],
        [2.731, 0.931627, 0.738325],
        [2.733, 0.933452, 0.738772],
        [2.736, 0.935276, 0.739252],
        [2.739, 0.937099, 0.739747],
        [2.741, 0.938931, 0.740143],
        [2.744, 0.940766, 0.740631],
        [2.747, 0.94259, 0.741049],
        [2.749, 0.944413, 0.741533],
        [2.752, 0.946238, 0.74197],
        [2.755, 0.948069, 0.742435],
        [2.757, 0.949893, 0.742918],
        [2.76, 0.95176, 0.743323],
        [2.763, 0.953591, 0.743807],
        [2.765, 0.955426, 0.744254],
        [2.768, 0.957257, 0.744698],
        [2.771, 0.959125, 0.745148],
        [2.773, 0.960956, 0.74559],
        [2.776, 0.962824, 0.746081],
        [2.779, 0.964656, 0.746538],
        [2.781, 0.96653, 0.746976],
        [2.784, 0.968365, 0.747412],
        [2.787, 0.97024, 0.747863],
        [2.789, 0.972071, 0.748348],
        [2.792, 0.973946, 0.748794],
        [2.795, 0.97582, 0.749259],
        [2.797, 0.977652, 0.749787],
        [2.8, 0.979537, 0.750174],
        [2.803, 0.981411, 0.750664],
        [2.805, 0.983286, 0.751086],
        [2.808, 0.985117, 0.75157],
        [2.811, 0.987002, 0.752071],
        [2.813, 0.988877, 0.752519],
        [2.816, 0.990753, 0.75296],
        [2.819, 0.992628, 0.753425],
        [2.821, 0.994509, 0.753851],
        [2.824, 0.996394, 0.754297],
        [2.827, 0.998269, 0.754757],
        [2.829, 1.00015, 0.755284],
        [2.832, 1.00203, 0.755723],
        [2.835, 1.00396, 0.756186],
        [2.837, 1.00584, 0.756687],
        [2.84, 1.00772, 0.757116],
        [2.843, 1.00959, 0.757605],
        [2.845, 1.01153, 0.758013],
        [2.848, 1.01341, 0.758504],
        [2.851, 1.01529, 0.758994],
        [2.853, 1.01722, 0.759451],
        [2.856, 1.0191, 0.759936],
        [2.859, 1.02102, 0.760354],
        [2.861, 1.02292, 0.760854],
        [2.864, 1.02484, 0.761383],
        [2.867, 0.769589, 0.761827],
        [2.869, 0.77104, 0.762316],
        [2.872, 0.772483, 0.762769],
        [2.875, 0.773889, 0.763218],
        [2.877, 0.775332, 0.763714],
        [2.88, 0.776782, 0.764167],
        [2.883, 0.778233, 0.764615],
        [2.885, 0.779676, 0.765065],
        [2.888, 0.781083, 0.76556],
        [2.891, 0.782534, 0.766004],
        [2.893, 0.783982, 0.766495],
        [2.896, 0.785426, 0.766978],
        [2.899, 0.786876, 0.767443],
        [2.901, 0.788327, 0.767934],
        [2.904, 0.789777, 0.768389],
        [2.907, 0.791227, 0.768883],
        [2.909, 0.792678, 0.769357],
        [2.912, 0.794128, 0.769818],
        [2.915, 0.795578, 0.770302],
        [2.917, 0.797029, 0.770777],
        [2.92, 0.798522, 0.771258],
        [2.923, 0.799972, 0.771757],
        [2.925, 0.801423, 0.772215],
        [2.928, 0.802875, 0.772711],
        [2.931, 0.804325, 0.77316],
        [2.933, 0.805825, 0.773684],
        [2.936, 0.807276, 0.774183],
        [2.939, 0.808737, 0.774639],
        [2.941, 0.81023, 0.775123],
        [2.944, 0.811687, 0.775595],
        [2.947, 0.813138, 0.776079],
        [2.949, 0.81464, 0.776566],
        [2.952, 0.81609, 0.777014],
        [2.955, 0.817584, 0.777472],
        [2.957, 0.819041, 0.77792],
        [2.96, 0.820536, 0.778419],
        [2.963, 0.821993, 0.778916],
        [2.965, 0.823497, 0.779356],
        [2.968, 0.824954, 0.779855],
        [2.971, 0.826456, 0.780346],
        [2.973, 0.82795, 0.780906],
        [2.976, 0.829407, 0.781355],
        [2.979, 0.830909, 0.781846],
        [2.981, 0.832403, 0.782333],
        [2.984, 0.833903, 0.782791],
        [2.987, 0.835372, 0.783289],
        [2.989, 0.836873, 0.783736],
        [2.992, 0.838373, 0.784246],
        [2.995, 0.839875, 0.784725],
        [2.997, 0.841369, 0.785224],
        [3, 0.842827, 0.785715],
        [3.003, 0.844338, 0.78618],
        [3.005, 0.84584, 0.786671],
        [3.008, 0.847341, 0.787168],
        [3.011, 0.848841, 0.787659],
        [3.013, 0.850343, 0.788212],
        [3.016, 0.85185, 0.788658],
        [3.019, 0.853363, 0.789163],
        [3.021, 0.854907, 0.789638],
        [3.024, 0.856409, 0.790103],
        [3.027, 0.85791, 0.790628],
        [3.029, 0.859418, 0.791091],
        [3.032, 0.86093, 0.791575],
        [3.035, 0.862431, 0.792083],
        [3.037, 0.863983, 0.792539],
        [3.04, 0.865485, 0.793035],
        [3.043, 0.866985, 0.793502],
        [3.045, 0.868504, 0.793993],
        [3.048, 0.87005, 0.79449],
        [3.051, 0.871557, 0.795024],
        [3.053, 0.873102, 0.795539],
        [3.056, 0.874621, 0.795987],
        [3.059, 0.876122, 0.796486],
        [3.061, 0.877674, 0.796977],
        [3.064, 0.879183, 0.797484],
        [3.067, 0.880737, 0.797969],
        [3.069, 0.882246, 0.798463],
        [3.072, 0.883798, 0.798961],
        [3.075, 0.88535, 0.79942],
        [3.077, 0.886862, 0.799913],
        [3.08, 0.888413, 0.800448],
        [3.083, 0.889922, 0.800903],
        [3.085, 0.891484, 0.801404],
        [3.088, 0.893036, 0.801914],
        [3.091, 0.894588, 0.80241],
        [3.093, 0.896097, 0.802944],
        [3.096, 0.89766, 0.803443],
        [3.099, 0.89921, 0.803945],
        [3.101, 0.900762, 0.804399],
        [3.104, 0.902325, 0.804947],
        [3.107, 0.903877, 0.805438],
        [3.109, 0.905386, 0.805946],
        [3.112, 0.906948, 0.806445],
        [3.115, 0.9085, 0.806899],
        [3.117, 0.910059, 0.807435],
        [3.12, 0.911622, 0.807942],
        [3.123, 0.913174, 0.808396],
        [3.125, 0.914733, 0.808932],
        [3.128, 0.916339, 0.809393],
        [3.131, 0.917891, 0.809944],
        [3.133, 0.91945, 0.810425],
        [3.136, 0.921012, 0.810972],
        [3.139, 0.922573, 0.811453],
        [3.141, 0.924125, 0.811912],
        [3.144, 0.925737, 0.812471],
        [3.147, 0.927289, 0.812918],
        [3.149, 0.928848, 0.813459],
        [3.152, 0.930411, 0.813964],
        [3.155, 0.932013, 0.814423],
        [3.157, 0.933584, 0.814921],
        [3.16, 0.935136, 0.815419],
        [3.163, 0.936738, 0.815918],
        [3.165, 0.938308, 0.816469],
        [3.168, 0.93991, 0.816922],
        [3.171, 0.941474, 0.817458],
        [3.173, 0.943076, 0.817912],
        [3.176, 0.944635, 0.81846],
        [3.179, 0.946249, 0.81897],
        [3.181, 0.947808, 0.81951],
        [3.184, 0.949421, 0.820008],
        [3.187, 0.951023, 0.820499],
        [3.189, 0.952583, 0.821007],
        [3.192, 0.954196, 0.821556],
        [3.195, 0.9558, 0.822011],
        [3.197, 0.957369, 0.822552],
        [3.2, 0.958971, 0.823018],
        [3.203, 0.960585, 0.823563],
        [3.205, 0.962194, 0.824066],
        [3.208, 0.963809, 0.824565],
        [3.211, 0.965367, 0.825056],
        [3.213, 0.96697, 0.825571],
        [3.216, 0.968591, 0.826106],
        [3.219, 0.970193, 0.826611],
        [3.221, 0.971807, 0.827109],
        [3.224, 0.973416, 0.827608],
        [3.227, 0.97503, 0.828159],
        [3.229, 0.976639, 0.828657],
        [3.232, 0.978253, 0.829155],
        [3.235, 0.979864, 0.829695],
        [3.237, 0.981477, 0.830212],
        [3.24, 0.983087, 0.830703],
        [3.243, 0.984743, 0.831244],
        [3.245, 0.986354, 0.831707],
        [3.248, 0.987975, 0.832247],
        [3.251, 0.989577, 0.832756],
        [3.253, 0.991198, 0.833253],
        [3.256, 0.99285, 0.833801],
        [3.259, 0.994471, 0.834259],
        [3.261, 0.996075, 0.834808],
        [3.264, 0.997739, 0.835353],
        [3.267, 0.999348, 0.835814],
        [3.269, 1.00097, 0.83635],
        [3.272, 1.00263, 0.836861],
        [3.275, 1.00424, 0.837354],
        [3.277, 1.00591, 0.837948],
        [3.28, 1.00752, 0.838451],
        [3.283, 1.00918, 0.83895],
        [3.285, 1.01079, 0.839441],
        [3.288, 1.01245, 0.839996],
        [3.291, 1.01407, 0.840499],
        [3.293, 1.01573, 0.841003],
        [3.296, 1.0174, 0.841544],
        [3.299, 1.01901, 0.842],
        [3.301, 1.02068, 0.842541],
        [3.304, 1.02233, 0.843056],
        [3.307, 1.024, 0.843598],
        [3.309, 1.02562, 0.844096],
        [3.312, 1.02727, 0.844601],
        [3.315, 1.02894, 0.845152],
        [3.317, 1.0306, 0.845653],
        [3.32, 1.03227, 0.846166],
        [3.323, 1.03393, 0.846707],
        [3.325, 1.03555, 0.847205],
        [3.328, 1.03722, 0.847784],
        [3.331, 1.03888, 0.848262],
        [3.333, 1.04054, 0.848803],
        [3.336, 1.04221, 0.849346],
        [3.339, 1.04387, 0.849843],
        [3.341, 1.04558, 0.850348],
        [3.344, 1.04725, 0.850858],
        [3.347, 1.04891, 0.851405],
        [3.349, 1.05058, 0.851948],
        [3.352, 1.05225, 0.852444],
        [3.355, 1.05391, 0.852941],
        [3.357, 1.05558, 0.853458],
        [3.36, 1.0573, 0.853999],
        [3.363, 1.05896, 0.854554],
        [3.365, 1.06063, 0.855003],
        [3.368, 1.06234, 0.8555],
        [3.371, 1.064, 0.856026],
        [3.373, 1.06567, 0.856568],
        [3.376, 1.06739, 0.857109],
        [3.379, 1.06905, 0.857621],
        [3.381, 1.07077, 0.858206],
        [3.384, 1.07244, 0.858664],
        [3.387, 1.07411, 0.859214],
        [3.389, 1.07582, 0.859718],
        [3.392, 1.07753, 0.860259],
        [3.395, 1.07919, 0.860801],
        [3.397, 1.08092, 0.861313],
        [3.4, 1.08259, 0.861857],
        [3.403, 1.0843, 0.862313],
        [3.405, 1.08602, 0.862868],
        [3.408, 1.08769, 0.863409],
        [3.411, 1.08941, 0.863919],
        [3.413, 1.09112, 0.864484],
        [3.416, 1.09279, 0.864975],
        [3.419, 1.09451, 0.865526],
        [3.421, 1.09623, 0.866081],
        [3.424, 1.09794, 0.866573],
        [3.427, 1.09966, 0.867131],
        [3.429, 1.10138, 0.86761],
        [3.432, 1.10309, 0.868146],
        [3.435, 1.10482, 0.868693],
        [3.437, 1.10648, 0.869198],
        [3.44, 1.1082, 0.869777],
        [3.443, 1.10992, 0.870292],
        [3.445, 1.11164, 0.870846],
        [3.448, 1.1134, 0.871382],
        [3.451, 1.11512, 0.871886],
        [3.453, 1.11684, 0.872434],
        [3.456, 1.11856, 0.87294],
        [3.459, 1.12029, 0.873485],
        [3.461, 1.122, 0.874027],
        [3.464, 1.12372, 0.874538],
        [3.467, 1.12549, 0.875079],
        [3.469, 1.12721, 0.875579],
        [3.472, 1.12893, 0.876133],
        [3.475, 1.1307, 0.876648],
        [3.477, 1.13241, 0.877151],
        [3.48, 1.13414, 0.877706],
        [3.483, 1.1359, 0.87821],
        [3.485, 1.13762, 0.878756],
        [3.488, 1.13935, 0.879271],
        [3.491, 1.14112, 0.87983],
        [3.493, 1.14283, 0.880372],
        [3.496, 1.1446, 0.880883],
        [3.499, 1.14633, 0.881461],
        [3.501, 1.14809, 0.881967],
        [3.504, 1.14987, 0.882532],
        [3.507, 1.15159, 0.883118],
        [3.509, 1.15336, 0.883622],
        [3.512, 1.15507, 0.884163],
        [3.515, 1.15685, 0.884669],
        [3.517, 1.15862, 0.88521],
        [3.52, 1.16038, 0.885761],
        [3.523, 1.16211, 0.886274],
        [3.525, 1.16389, 0.886822],
        [3.528, 1.16565, 0.887313],
        [3.531, 1.16743, 0.887879],
        [3.533, 1.1692, 0.88842],
        [3.536, 1.17093, 0.888935],
        [3.539, 1.17269, 0.889493],
        [3.541, 1.17446, 0.890012],
        [3.544, 1.17623, 0.890554],
        [3.547, 1.178, 0.891102],
        [3.549, 1.17977, 0.891606],
        [3.552, 1.18155, 0.892156],
        [3.555, 1.18332, 0.892671],
        [3.557, 1.18509, 0.893262],
        [3.56, 1.18687, 0.893804],
        [3.563, 1.18869, 0.894359],
        [3.565, 1.19046, 0.894893],
        [3.568, 1.19224, 0.895392],
        [3.571, 1.19401, 0.89595],
        [3.573, 1.19578, 0.896465],
        [3.576, 1.19761, 0.897015],
        [3.579, 1.19938, 0.897562],
        [3.581, 1.20115, 0.898112],
        [3.584, 1.20293, 0.898659],
        [3.587, 1.20474, 0.899168],
        [3.589, 1.20651, 0.899734],
        [3.592, 1.20833, 0.900282],
        [3.595, 1.21011, 0.90078],
        [3.597, 1.21189, 0.901346],
        [3.6, 1.21371, 0.901844],
        [3.603, 1.21549, 0.902439],
        [3.605, 1.21731, 0.902988],
        [3.608, 1.21913, 0.903494],
        [3.611, 1.22091, 0.904052],
        [3.613, 1.22272, 0.904558],
        [3.616, 1.2245, 0.905106],
        [3.619, 1.22634, 0.905692],
        [3.621, 1.22816, 0.906257],
        [3.624, 1.22993, 0.906798],
        [3.627, 1.23176, 0.907347],
        [3.629, 1.23358, 0.907905],
        [3.632, 1.23541, 0.908453],
        [3.635, 1.23719, 0.909002],
        [3.637, 1.23901, 0.909554],
        [3.64, 1.24083, 0.910065],
        [3.643, 1.24266, 0.910608],
        [3.645, 1.24448, 0.911123],
        [3.648, 1.2463, 0.911714],
        [3.651, 1.24813, 0.912263],
        [3.653, 1.24995, 0.91278],
        [3.656, 1.25178, 0.913339],
        [3.659, 1.2536, 0.913844],
        [3.661, 1.25543, 0.914435],
        [3.664, 1.25726, 0.914991],
        [3.667, 1.25909, 0.915499],
        [3.669, 1.26091, 0.916047],
        [3.672, 1.26274, 0.916596],
        [3.675, 1.26457, 0.917154],
        [3.677, 1.26639, 0.917706],
        [3.68, 1.26827, 0.918219],
        [3.683, 1.27009, 0.91881],
        [3.685, 1.27192, 0.919307],
        [3.688, 1.27375, 0.919858],
        [3.691, 1.27563, 0.920406],
        [3.693, 1.27745, 0.920966],
        [3.696, 1.27933, 0.92155],
        [3.699, 1.28116, 0.922079],
        [3.701, 1.28298, 0.922628],
        [3.704, 1.28486, 0.923219],
        [3.707, 1.28669, 0.923723],
        [3.709, 1.28857, 0.924294],
        [3.712, 1.2904, 0.924802],
        [3.715, 1.29227, 0.9254],
        [3.717, 1.2941, 0.925942],
        [3.72, 1.29598, 0.926455],
        [3.723, 1.29785, 0.927053],
        [3.725, 1.29968, 0.927552],
        [3.728, 1.30156, 0.928101],
        [3.731, 1.30344, 0.92867],
        [3.733, 1.30527, 0.92922],
        [3.736, 1.30714, 0.92976],
        [3.739, 1.30902, 0.930291],
        [3.741, 1.3109, 0.930875],
        [3.744, 1.31273, 0.931379],
        [3.747, 1.31461, 0.931923],
        [3.749, 1.31649, 0.932539],
        [3.752, 1.31836, 0.933036],
        [3.755, 1.32025, 0.933592],
        [3.757, 1.32212, 0.93414],
        [3.76, 1.32401, 0.934688],
        [3.763, 1.32588, 0.935241],
        [3.765, 1.32775, 0.935806],
        [3.768, 1.32965, 0.936418],
        [3.771, 1.33152, 0.936924],
        [3.773, 1.3334, 0.937517],
        [3.776, 1.33528, 0.938066],
        [3.779, 1.33717, 0.938564],
        [3.781, 1.33905, 0.939168],
        [3.784, 1.34097, 0.939674],
        [3.787, 1.34284, 0.940276],
        [3.789, 1.34474, 0.940845],
        [3.792, 1.34661, 0.941351],
        [3.795, 1.34854, 0.941943],
        [3.797, 1.35043, 0.942455],
        [3.8, 1.35231, 0.942997],
        [3.803, 1.35423, 0.943588],
        [3.805, 1.35611, 0.944099],
        [3.808, 1.358, 0.944702],
        [3.811, 1.35993, 0.9452],
        [3.813, 1.36181, 0.945756],
        [3.816, 1.36375, 0.946321],
        [3.819, 1.36562, 0.946881],
        [3.821, 1.36755, 0.947467],
        [3.824, 1.36943, 0.947996],
        [3.827, 1.37137, 0.948547],
        [3.829, 1.37325, 0.949096],
        [3.832, 1.37518, 0.949644],
        [3.835, 1.37712, 0.950242],
        [3.837, 1.379, 0.950748],
        [3.84, 1.38092, 0.951315],
        [3.843, 1.38286, 0.951862],
        [3.845, 1.38478, 0.952415],
        [3.848, 1.38667, 0.953067],
        [3.851, 1.38861, 0.953573],
        [3.853, 1.39054, 0.954164],
        [3.856, 1.39247, 0.954668],
        [3.859, 1.3944, 0.955233],
        [3.861, 1.39633, 0.95586],
        [3.864, 1.39826, 0.956382],
        [3.867, 1.4002, 0.956975],
        [3.869, 1.40213, 0.9575],
        [3.872, 1.40407, 0.958084],
        [3.875, 1.406, 0.958647],
        [3.877, 1.40792, 0.95919],
        [3.88, 1.40987, 0.959755],
        [3.883, 1.4118, 0.960311],
        [3.885, 1.41374, 0.960869],
        [3.888, 1.41567, 0.961455],
        [3.891, 1.4176, 0.961977],
        [3.893, 1.41954, 0.962535],
        [3.896, 1.42151, 0.963079],
        [3.899, 1.42346, 0.963647],
        [3.901, 1.42539, 0.964188],
        [3.904, 1.42737, 0.964744],
        [3.907, 1.42931, 0.965346],
        [3.909, 1.43124, 0.96585],
        [3.912, 1.43323, 0.966454],
        [3.915, 1.43516, 0.966966],
        [3.917, 1.4371, 0.967568],
        [3.92, 1.43908, 0.968117],
        [3.923, 1.44101, 0.968672],
        [3.925, 1.443, 0.969221],
        [3.928, 1.44493, 0.969779],
        [3.931, 1.44692, 0.970372],
        [3.933, 1.44885, 0.970989],
        [3.936, 1.45084, 0.97154],
        [3.939, 1.45282, 0.972095],
        [3.941, 1.45477, 0.972655],
        [3.944, 1.45674, 0.973202],
        [3.947, 1.45874, 0.973795],
        [3.949, 1.46067, 0.974325],
        [3.952, 1.46266, 0.974916],
        [3.955, 1.46464, 0.975424],
        [3.957, 1.46663, 0.976031],
        [3.96, 1.46861, 0.976571],
        [3.963, 1.47055, 0.977138],
        [3.965, 1.47254, 0.977694],
        [3.968, 1.47452, 0.978242],
        [3.971, 1.47651, 0.978845],
        [3.973, 1.4785, 0.979356],
        [3.976, 1.48048, 0.979947],
        [3.979, 1.48247, 0.980516],
        [3.981, 1.48445, 0.98107],
        [3.984, 1.48644, 0.981618],
        [3.987, 1.48842, 0.982171],
        [3.989, 1.49042, 0.982772],
        [3.992, 1.4924, 0.983334],
        [3.995, 1.49444, 0.983895],
        [3.997, 1.49642, 0.984443],
        [4, 1.49842, 0.984997],
        [4.003, 1.5004, 0.985557],
        [4.005, 1.50239, 0.986192],
        [4.008, 1.50443, 0.986777],
        [4.011, 1.50642, 0.987325],
        [4.013, 1.50841, 0.987873],
        [4.016, 1.51044, 0.988429],
        [4.019, 1.51243, 0.98907],
        [4.021, 1.51442, 0.989618],
        [4.024, 1.51645, 0.990179],
        [4.027, 1.51845, 0.990755],
        [4.029, 1.52048, 0.991296],
        [4.032, 1.52247, 0.991909],
        [4.035, 1.5245, 0.992449],
        [4.037, 1.5265, 0.992999],
        [4.04, 1.52854, 0.993555],
        [4.043, 1.53052, 0.994146],
        [4.045, 1.53257, 0.994712],
        [4.048, 1.53461, 0.995281],
        [4.051, 1.5366, 0.995855],
        [4.053, 0, 0.996397],
        [4.056, 0, 0.996988],
        [4.059, 0, 0.997506],
        [4.061, 0, 0.998099],
        [4.064, 0, 0.998702],
        [4.067, 0, 0.999213],
        [4.069, 0, 0.999823],
        [4.072, 0, 1.00038],
        [4.075, 0, 1.00094],
        [4.077, 0, 1.00153],
        [4.08, 0, 1.00208],
        [4.083, 0, 1.00265],
        [4.085, 0, 1.0032],
        [4.088, 0, 1.0038],
        [4.091, 0, 1.00436],
        [4.093, 0, 1.00491],
        [4.096, 0, 1.0055],
        [4.099, 0, 1.00603],
        [4.101, 0, 1.00663],
        [4.104, 0, 1.00723],
        [4.107, 0, 1.00776],
        [4.109, 0, 1.00835],
        [4.112, 0, 1.00894],
        [4.115, 0, 1.0095],
        [4.117, 0, 1.01012],
        [4.12, 0, 1.01066],
        [4.123, 0, 1.01126],
        [4.125, 0, 1.01183],
        [4.128, 0, 1.01243],
        [4.131, 0, 1.01302],
        [4.133, 0, 1.01354],
        [4.136, 0, 1.01414],
        [4.139, 0, 1.01469],
        [4.141, 0, 1.01524],
        [4.144, 0, 1.01579],
        [4.147, 0, 1.01641],
        [4.149, 0, 1.01701],
        [4.152, 0, 1.01753],
        [4.155, 0, 1.01813],
        [4.157, 0, 1.01868],
        [4.16, 0, 1.01924],
        [4.163, 0, 1.01985],
        [4.165, 0, 1.02041],
        [4.168, 0, 1.02101],
        [4.171, 0, 1.02152],
        [4.173, 0, 1.02212],
        [4.176, 0, 1.02273],
        [4.179, 0, 1.02328],
        [4.181, 0, 1.02384],
        [4.184, 0, 1.0244],
        [4.187, 0, 1.025],
        [4.189, 0, 1.0256],
        [4.192, 0, 1.0261],
        [4.195, 0, 1.02671],
        [4.197, 0, 1.02726],
        [4.2, 0, 1.02789],
        [4.203, 0, 1.02848],
        [4.205, 0, 1.02899],
        [4.208, 0, 1.02959],
        [4.211, 0, 1.03015],
        [4.213, 0, 1.03078],
        [4.216, 0, 1.03135],
        [4.219, 0, 1.03191],
        [4.221, 0, 1.03256],
        [4.224, 0, 1.03312],
        [4.227, 0, 1.03371],
        [4.229, 0, 1.03423],
        [4.232, 0, 1.03484],
        [4.235, 0, 1.03545],
        [4.237, 0, 1.036],
        [4.24, 0, 1.0366],
        [4.243, 0, 1.03711],
        [4.245, 0, 1.0377],
        [4.248, 0, 1.03831],
        [4.251, 0, 1.03888],
        [4.253, 0, 1.03947],
        [4.256, 0, 1.03999],
        [4.259, 0, 1.0406],
        [4.261, 0, 1.04119],
        [4.264, 0, 1.04175],
        [4.267, 0, 1.04236],
        [4.269, 0, 1.04287],
        [4.272, 0, 1.04347],
        [4.275, 0, 1.04407],
        [4.277, 0, 1.04464],
        [4.28, 0, 1.04524],
        [4.283, 0, 1.04579],
        [4.285, 0, 1.04637],
        [4.288, 0, 1.04697],
        [4.291, 0, 1.04751],
        [4.293, 0, 1.04814],
        [4.296, 0, 1.04869],
        [4.299, 0, 1.04927],
        [4.301, 0, 1.04989],
        [4.304, 0, 1.0504],
        [4.307, 0, 1.05099],
        [4.309, 0, 1.05157],
        [4.312, 0, 1.05222],
        [4.315, 0, 1.05276],
        [4.317, 0, 1.05338],
        [4.32, 0, 1.05402],
        [4.323, 0, 1.05454],
        [4.325, 0, 1.05514],
        [4.328, 0, 1.05569],
        [4.331, 0, 1.05629],
        [4.333, 0, 1.05691],
        [4.336, 0, 1.05746],
        [4.339, 0, 1.05807],
        [4.341, 0, 1.05864],
        [4.344, 0, 1.05919],
        [4.347, 0, 1.05979],
        [4.349, 0, 1.06036],
        [4.352, 0, 1.06096],
        [4.355, 0, 1.06152],
        [4.357, 0, 1.06211],
        [4.36, 0, 1.06271],
        [4.363, 0, 1.06327],
        [4.365, 0, 1.06388],
        [4.368, 0, 1.06445],
        [4.371, 0, 1.06501],
        [4.373, 0, 1.06561],
        [4.376, 0, 1.06616],
        [4.379, 0, 1.06675],
        [4.381, 0, 1.06733],
        [4.384, 0, 1.06793],
        [4.387, 0, 1.06853],
        [4.389, 0, 1.0691],
        [4.392, 0, 1.0697],
        [4.395, 0, 1.07026],
        [4.397, 0, 1.07092],
        [4.4, 0, 1.07147],
        [4.403, 0, 1.07204],
        [4.405, 0, 1.07264],
        [4.408, 0, 1.07319],
        [4.411, 0, 1.07379],
        [4.413, 0, 1.07436],
        [4.416, 0, 1.07495],
        [4.419, 0, 1.07556],
        [4.421, 0, 1.07611],
        [4.424, 0, 1.07672],
        [4.427, 0, 1.07729],
        [4.429, 0, 1.07789],
        [4.432, 0, 1.07849],
        [4.435, 0, 1.07905],
        [4.437, 0, 1.0797],
        [4.44, 0, 1.08026],
        [4.443, 0, 1.08087],
        [4.445, 0, 1.08147],
        [4.448, 0, 1.08203],
        [4.451, 0, 1.08264],
        [4.453, 0, 1.0832],
        [4.456, 0, 1.0838],
        [4.459, 0, 1.08441],
        [4.461, 0, 1.08492],
        [4.464, 0, 1.08554],
        [4.467, 0, 1.08609],
        [4.469, 0, 1.08669],
        [4.472, 0, 1.0873],
        [4.475, 0, 1.0879],
        [4.477, 0, 1.08851],
        [4.48, 0, 1.08907],
        [4.483, 0, 1.08967],
        [4.485, 0, 1.09022],
        [4.488, 0, 1.09083],
        [4.491, 0, 1.09144],
        [4.493, 0, 1.092],
        [4.496, 0, 1.0926],
        [4.499, 0, 1.09316],
        [4.501, 0, 1.09378],
        [4.504, 0, 1.09439],
        [4.507, 0, 1.09495],
        [4.509, 0, 1.09555],
        [4.512, 0, 1.0961],
        [4.515, 0, 1.0967],
        [4.517, 0, 1.09733],
        [4.52, 0, 1.09788],
        [4.523, 0, 1.09852],
        [4.525, 0, 1.09907],
        [4.528, 0, 1.09968],
        [4.531, 0, 1.1003],
        [4.533, 0, 1.10086],
        [4.536, 0, 1.10146],
        [4.539, 0, 1.10201],
        [4.541, 0, 1.10262],
        [4.544, 0, 1.10324],
        [4.547, 0, 1.10379],
        [4.549, 0, 1.10443],
        [4.552, 0, 1.10499],
        [4.555, 0, 1.1056],
        [4.557, 0, 1.1062],
        [4.56, 0, 1.10678],
        [4.563, 0, 1.10738],
        [4.565, 0, 1.10799],
        [4.568, 0, 1.1086],
        [4.571, 0, 1.10916],
        [4.573, 0, 1.10977],
        [4.576, 0, 1.11036],
        [4.579, 0, 1.11092],
        [4.581, 0, 1.11153],
        [4.584, 0, 1.11213],
        [4.587, 0, 1.11274],
        [4.589, 0, 1.11334],
        [4.592, 0, 1.11391],
        [4.595, 0, 1.11451],
        [4.597, 0, 1.11506],
        [4.6, 0, 1.11568],
        [4.603, 0, 1.11628],
        [4.605, 0, 1.11685],
        [4.608, 0, 1.11745],
        [4.611, 0, 1.11801],
        [4.613, 0, 1.11861],
        [4.616, 0, 1.11923],
        [4.619, 0, 1.11989],
        [4.621, 0, 1.12049],
        [4.624, 0, 1.12104],
        [4.627, 0, 1.12165],
        [4.629, 0, 1.12226],
        [4.632, 0, 1.12281],
        [4.635, 0, 1.12343],
        [4.637, 0, 1.12399],
        [4.64, 0, 1.1246],
        [4.643, 0, 1.12516],
        [4.645, 0, 1.1258],
        [4.648, 0, 1.12641],
        [4.651, 0, 1.12695],
        [4.653, 0, 1.12758],
        [4.656, 0, 1.12814],
        [4.659, 0, 1.12874],
        [4.661, 0, 1.12934],
        [4.664, 0, 1.1299],
        [4.667, 0, 1.13056],
        [4.669, 0, 1.13114],
        [4.672, 0, 1.13174],
        [4.675, 0, 1.13234],
        [4.677, 0, 1.13292],
        [4.68, 0, 1.13352],
        [4.683, 0, 1.13407],
        [4.685, 0, 1.13472],
        [4.688, 0, 1.13537],
        [4.691, 0, 1.13593],
        [4.693, 0, 1.13655],
        [4.696, 0, 1.1371],
        [4.699, 0, 1.1377],
        [4.701, 0, 1.13832],
        [4.704, 0, 1.13892],
        [4.707, 0, 1.13958],
        [4.709, 0, 1.14013],
        [4.712, 0, 1.14074],
        [4.715, 0, 1.14134],
        [4.717, 0, 1.14191],
        [4.72, 0, 1.14252],
        [4.723, 0, 1.14311],
        [4.725, 0, 1.14372],
        [4.728, 0, 1.14429],
        [4.731, 0, 1.1449],
        [4.733, 0, 1.14551],
        [4.736, 0, 1.14607],
        [4.739, 0, 1.14672],
        [4.741, 0, 1.14728],
        [4.744, 0, 1.14788],
        [4.747, 0, 1.1485],
        [4.749, 0, 1.14911],
        [4.752, 0, 1.14972],
        [4.755, 0, 1.15032],
        [4.757, 0, 1.15093],
        [4.76, 0, 1.15154],
        [4.763, 0, 1.15209],
        [4.765, 0, 1.15269],
        [4.768, 0, 1.1533],
        [4.771, 0, 1.15392],
        [4.773, 0, 1.15452],
        [4.776, 0, 1.15507],
        [4.779, 0, 1.15568],
        [4.781, 0, 1.15628],
        [4.784, 0, 1.15691],
        [4.787, 0, 1.15752],
        [4.789, 0, 1.15808],
        [4.792, 0, 1.15868],
        [4.795, 0, 1.1593],
        [4.797, 0, 1.1599],
        [4.8, 0, 1.16051],
        [4.803, 0, 1.16106],
        [4.805, 0, 1.16172],
        [4.808, 0, 1.16228],
        [4.811, 0, 1.1629],
        [4.813, 0, 1.16349],
        [4.816, 0, 1.16411],
        [4.819, 0, 1.16475],
        [4.821, 0, 1.16532],
        [4.824, 0, 1.16593],
        [4.827, 0, 1.16649],
        [4.829, 0, 1.16714],
        [4.832, 0, 1.16776],
        [4.835, 0, 1.16831],
        [4.837, 0, 1.16892],
        [4.84, 0, 1.16948],
        [4.843, 0, 1.17014],
        [4.845, 0, 1.17075],
        [4.848, 0, 1.17131],
        [4.851, 0, 1.17192],
        [4.853, 0, 1.17252],
        [4.856, 0, 1.17317],
        [4.859, 0, 1.17378],
        [4.861, 0, 1.17435],
        [4.864, 0, 1.175],
        [4.867, 0, 1.17556],
        [4.869, 0, 1.17618],
        [4.872, 0, 1.17683],
        [4.875, 0, 1.17742],
        [4.877, 0, 1.17805],
        [4.88, 0, 1.17859],
        [4.883, 0, 1.17926],
        [4.885, 0, 1.17986],
        [4.888, 0, 1.18042],
        [4.891, 0, 1.18102],
        [4.893, 0, 1.18164],
        [4.896, 0, 1.18224],
        [4.899, 0, 1.18282],
        [4.901, 0, 1.18342],
        [4.904, 0, 1.18408],
        [4.907, 0, 1.18465],
        [4.909, 0, 1.18525],
        [4.912, 0, 1.18586],
        [4.915, 0, 1.18647],
        [4.917, 0, 1.18707],
        [4.92, 0, 1.18764],
        [4.923, 0, 1.18829],
        [4.925, 0, 1.18885],
        [4.928, 0, 1.18946],
        [4.931, 0, 1.19015],
        [4.933, 0, 1.19072],
        [4.936, 0, 1.19133],
        [4.939, 0, 1.19193],
        [4.941, 0, 1.19254],
        [4.944, 0, 1.19315],
        [4.947, 0, 1.19372],
        [4.949, 0, 1.19437],
        [4.952, 0, 1.19494],
        [4.955, 0, 1.19554],
        [4.957, 0, 1.19621],
        [4.96, 0, 1.19677],
        [4.963, 0, 1.19737],
        [4.965, 0, 1.19798],
        [4.968, 0, 1.19859],
        [4.971, 0, 1.1992],
        [4.973, 0, 1.1998],
        [4.976, 0, 1.2004],
        [4.979, 0, 1.20099],
        [4.981, 0, 1.20163],
        [4.984, 0, 1.20219],
        [4.987, 0, 1.2028],
        [4.989, 0, 1.2035],
        [4.992, 0, 1.20406],
        [4.995, 0, 1.20467],
        [4.997, 0, 1.20528],
        [5, 0, 1.20589],
        [5.003, 0, 1.2065],
        [5.005, 0, 1.20711],
        [5.008, 0, 1.2077],
        [5.011, 0, 1.20828],
        [5.013, 0, 1.20894],
        [5.016, 0, 1.20955],
        [5.019, 0, 1.2101],
        [5.021, 0, 1.21082],
        [5.024, 0, 1.21137],
        [5.027, 0, 1.21197],
        [5.029, 0, 1.21263],
        [5.032, 0, 1.2132],
        [5.035, 0, 1.21385],
        [5.037, 0, 1.21441],
        [5.04, 0, 1.21502],
        [5.043, 0, 1.21572],
        [5.045, 0, 1.21629],
        [5.048, 0, 1.21689],
        [5.051, 0, 1.2175],
        [5.053, 0, 1.21811],
        [5.056, 0, 1.21872],
        [5.059, 0, 1.21933],
        [5.061, 0, 1.21994],
        [5.064, 0, 1.22055],
        [5.067, 0, 1.22116],
        [5.069, 0, 1.22173],
        [5.072, 0, 1.22238],
        [5.075, 0, 1.22299],
        [5.077, 0, 1.2236],
        [5.08, 0, 1.22421],
        [5.083, 0, 1.22478],
        [5.085, 0, 1.22543],
        [5.088, 0, 1.22604],
        [5.091, 0, 1.22659],
        [5.093, 0, 1.22726],
        [5.096, 0, 1.22782],
        [5.099, 0, 1.22851],
        [5.101, 0, 1.22913],
        [5.104, 0, 1.2297],
        [5.107, 0, 1.23034],
        [5.109, 0, 1.2309],
        [5.112, 0, 1.23157],
        [5.115, 0, 1.23217],
        [5.117, 0, 1.23277],
        [5.12, 0, 1.23338],
        [5.123, 0, 1.23396],
        [5.125, 0, 1.23461],
        [5.128, 0, 1.23521],
        [5.131, 0, 1.23583],
        [5.133, 0, 1.23646],
        [5.136, 0, 1.23701],
        [5.139, 0, 1.23767],
        [5.141, 0, 1.23828],
        [5.144, 0, 1.23889],
        [5.147, 0, 1.2395],
        [5.149, 0, 1.2401],
        [5.152, 0, 1.24075],
        [5.155, 0, 1.24133],
        [5.157, 0, 1.24197],
        [5.16, 0, 1.24258],
        [5.163, 0, 1.24319],
        [5.165, 0, 1.24381],
        [5.168, 0, 1.24441],
        [5.171, 0, 1.24503],
        [5.173, 0, 1.24563],
        [5.176, 0, 1.24624],
        [5.179, 0, 1.24685],
        [5.181, 0, 1.24747],
        [5.184, 0, 1.24809],
        [5.187, 0, 1.24874],
        [5.189, 0, 1.2493],
        [5.192, 0, 1.24995],
        [5.195, 0, 1.25052],
        [5.197, 0, 1.25118],
        [5.2, 0, 1.25179],
        [5.203, 0, 1.25239],
        [5.205, 0, 1.25308],
        [5.208, 0, 1.25366],
        [5.211, 0, 1.25431],
        [5.213, 0, 1.25492],
        [5.216, 0, 1.25552],
        [5.219, 0, 1.25613],
        [5.221, 0, 1.25676],
        [5.224, 0, 1.25735],
        [5.227, 0, 1.258],
        [5.229, 0, 1.25859],
        [5.232, 0, 1.25924],
        [5.235, 0, 1.25979],
        [5.237, 0, 1.26045],
        [5.24, 0, 1.26105],
        [5.243, 0, 1.26169],
        [5.245, 0, 1.26229],
        [5.248, 0, 1.2629],
        [5.251, 0, 1.26352],
        [5.253, 0, 1.26413],
        [5.256, 0, 1.26478],
        [5.259, 0, 1.26539],
        [5.261, 0, 1.266],
        [5.264, 0, 1.26661],
        [5.267, 0, 1.26723],
        [5.269, 0, 1.26782],
        [5.272, 0, 1.26849],
        [5.275, 0, 1.26904],
        [5.277, 0, 1.2697],
        [5.28, 0, 1.27027],
        [5.283, 0, 1.27092],
        [5.285, 0, 1.27154],
        [5.288, 0, 1.27215],
        [5.291, 0, 1.27275],
        [5.293, 0, 1.27337],
        [5.296, 0, 1.27404],
        [5.299, 0, 1.27465],
        [5.301, 0, 1.27525],
        [5.304, 0, 1.2759],
        [5.307, 0, 1.27652],
        [5.309, 0, 1.27713],
        [5.312, 0, 1.27774],
        [5.315, 0, 1.27836],
        [5.317, 0, 1.279],
        [5.32, 0, 1.27956],
        [5.323, 0, 1.28023],
        [5.325, 0, 1.28079],
        [5.328, 0, 1.28144],
        [5.331, 0, 1.28205],
        [5.333, 0, 1.28267],
        [5.336, 0, 1.28327],
        [5.339, 0, 1.2839],
        [5.341, 0, 1.28449],
        [5.344, 0, 1.28516],
        [5.347, 0, 1.28577],
        [5.349, 0, 1.28637],
        [5.352, 0, 1.28705],
        [5.355, 0, 1.28766],
        [5.357, 0, 1.28831],
        [5.36, 0, 1.28888],
        [5.363, 0, 1.28953],
        [5.365, 0, 1.29009],
        [5.368, 0, 1.29075],
        [5.371, 0, 1.29136],
        [5.373, 0, 1.29198],
        [5.376, 0, 1.29262],
        [5.379, 0, 1.29319],
        [5.381, 0, 1.29385],
        [5.384, 0, 1.29446],
        [5.387, 0, 1.29506],
        [5.389, 0, 1.29568],
        [5.392, 0, 1.29628],
        [5.395, 0, 1.29695],
        [5.397, 0, 1.29754],
        [5.4, 0, 1.29822],
        [5.403, 0, 1.29882],
        [5.405, 0, 1.29944],
        [5.408, 0, 1.30005],
        [5.411, 0, 1.30066],
        [5.413, 0, 1.30138],
        [5.416, 0, 1.30199],
        [5.419, 0, 1.30259],
        [5.421, 0, 1.3032],
        [5.424, 0, 1.30383],
        [5.427, 0, 1.30442],
        [5.429, 0, 1.30508],
        [5.432, 0, 1.30569],
        [5.435, 0, 1.3063],
        [5.437, 0, 1.30691],
        [5.44, 0, 1.30752],
        [5.443, 0, 1.30818],
        [5.445, 0, 1.30879],
        [5.448, 0, 1.30945],
        [5.451, 0, 1.31007],
        [5.453, 0, 1.31068],
        [5.456, 0, 1.31133],
        [5.459, 0, 1.31194],
        [5.461, 0, 1.31256],
        [5.464, 0, 1.31317],
        [5.467, 0, 1.31378],
        [5.469, 0, 1.31444],
        [5.472, 0, 1.31505],
        [5.475, 0, 1.31567],
        [5.477, 0, 1.31628],
        [5.48, 0, 1.31689],
        [5.483, 0, 1.3175],
        [5.485, 0, 1.31815],
        [5.488, 0, 1.31876],
        [5.491, 0, 1.31938],
        [5.493, 0, 1.32008],
        [5.496, 0, 1.32064],
        [5.499, 0, 1.32129],
        [5.501, 0, 1.3219],
        [5.504, 0, 1.32253],
        [5.507, 0, 1.32318],
        [5.509, 0, 1.32375],
        [5.512, 0, 1.32441],
        [5.515, 0, 1.32508],
        [5.517, 0, 1.32562],
        [5.52, 0, 1.32627],
        [5.523, 0, 1.32688],
        [5.525, 0, 1.32752],
        [5.528, 0, 1.32817],
        [5.531, 0, 1.32876],
        [5.533, 0, 1.3294],
        [5.536, 0, 1.33001],
        [5.539, 0, 1.33068],
        [5.541, 0, 1.33133],
        [5.544, 0, 1.33193],
        [5.547, 0, 1.33254],
        [5.549, 0, 1.33316],
        [5.552, 0, 1.33381],
        [5.555, 0, 1.33442],
        [5.557, 0, 1.33504],
        [5.56, 0, 1.33565],
        [5.563, 0, 1.33626],
        [5.565, 0, 1.33693],
        [5.568, 0, 1.33748],
        [5.571, 0, 1.33814],
        [5.573, 0, 1.33882],
        [5.576, 0, 1.33938],
        [5.579, 0, 1.34004],
        [5.581, 0, 1.34065],
        [5.584, 0, 1.34131],
        [5.587, 0, 1.34195],
        [5.589, 0, 1.34258],
        [5.592, 0, 1.3432],
        [5.595, 0, 1.34381],
        [5.597, 0, 1.34446],
        [5.6, 0, 1.34507],
        [5.603, 0, 1.34568],
        [5.605, 0, 1.34633],
        [5.608, 0, 1.34696],
        [5.611, 0, 1.34756],
        [5.613, 0, 1.34821],
        [5.616, 0, 1.34882],
        [5.619, 0, 1.34945],
        [5.621, 0, 1.35006],
        [5.624, 0, 1.35071],
        [5.627, 0, 1.35133],
        [5.629, 0, 1.35198],
        [5.632, 0, 1.35264],
        [5.635, 0, 1.35321],
        [5.637, 0, 1.35388],
        [5.64, 0, 1.35454],
        [5.643, 0, 1.3551],
        [5.645, 0, 1.35581],
        [5.648, 0, 1.35642],
        [5.651, 0, 1.35708],
        [5.653, 0, 1.35763],
        [5.656, 0, 1.35831],
        [5.659, 0, 1.35897],
        [5.661, 0, 1.35952],
        [5.664, 0, 1.36018],
        [5.667, 0, 1.36079],
        [5.669, 0, 1.36145],
        [5.672, 0, 1.36205],
        [5.675, 0, 1.36272],
        [5.677, 0, 1.36338],
        [5.68, 0, 1.36395],
        [5.683, 0, 1.3646],
        [5.685, 0, 1.36526],
        [5.688, 0, 1.36586],
        [5.691, 0, 1.36649],
        [5.693, 0, 1.36712],
        [5.696, 0, 1.36777],
        [5.699, 0, 1.36839],
        [5.701, 0, 1.36901],
        [5.704, 0, 1.36965],
        [5.707, 0, 1.37026],
        [5.709, 0, 1.3709],
        [5.712, 0, 1.37154],
        [5.715, 0, 1.37215],
        [5.717, 0, 1.37286],
        [5.72, 0, 1.37343],
        [5.723, 0, 1.37408],
        [5.725, 0, 1.37473],
        [5.728, 0, 1.37535],
        [5.731, 0, 1.37596],
        [5.733, 0, 1.37657],
        [5.736, 0, 1.37723],
        [5.739, 0, 1.37784],
        [5.741, 0, 1.37846],
        [5.744, 0, 1.37911],
        [5.747, 0, 1.37973],
        [5.749, 0, 1.3804],
        [5.752, 0, 1.38097],
        [5.755, 0, 1.38162],
        [5.757, 0, 1.38227],
        [5.76, 0, 1.38294],
        [5.763, 0, 1.38354],
        [5.765, 0, 1.38417],
        [5.768, 0, 1.38484],
        [5.771, 0, 1.38548],
        [5.773, 0, 1.38606],
        [5.776, 0, 1.38672],
        [5.779, 0, 1.38732],
        [5.781, 0, 1.38799],
        [5.784, 0, 1.38861],
        [5.787, 0, 1.38921],
        [5.789, 0, 1.38986],
        [5.792, 0, 1.39049],
        [5.795, 0, 1.39114],
        [5.797, 0, 1.39174],
        [5.8, 0, 1.39238],
        [5.803, 0, 1.39307],
        [5.805, 0, 1.39369],
        [5.808, 0, 1.3943],
        [5.811, 0, 1.39496],
        [5.813, 0, 1.39557],
        [5.816, 0, 1.39624],
        [5.819, 0, 1.39685],
        [5.821, 0, 1.39746],
        [5.824, 0, 1.39808],
        [5.827, 0, 1.39874],
        [5.829, 0, 1.39938],
        [5.832, 0, 1.39996],
        [5.835, 0, 1.40063],
        [5.837, 0, 1.40124],
        [5.84, 0, 1.40191],
        [5.843, 0, 1.40259],
        [5.845, 0, 1.40317],
        [5.848, 0, 1.40383],
        [5.851, 0, 1.40444],
        [5.853, 0, 1.40509],
        [5.856, 0, 1.40575],
        [5.859, 0, 1.40633],
        [5.861, 0, 1.40699],
        [5.864, 0, 1.40761],
        [5.867, 0, 1.40827],
        [5.869, 0, 1.40891],
        [5.872, 0, 1.40954],
        [5.875, 0, 1.41015],
        [5.877, 0, 1.41076],
        [5.88, 0, 1.41143],
        [5.883, 0, 1.41209],
        [5.885, 0, 1.41274],
        [5.888, 0, 1.41335],
        [5.891, 0, 1.41397],
        [5.893, 0, 1.41462],
        [5.896, 0, 1.41524],
        [5.899, 0, 1.4159],
        [5.901, 0, 1.41655],
        [5.904, 0, 1.41712],
        [5.907, 0, 1.4178],
        [5.909, 0, 1.41845],
        [5.912, 0, 1.4191],
        [5.915, 0, 1.41976],
        [5.917, 0, 1.42038],
        [5.92, 0, 1.42101],
        [5.923, 0, 1.42161],
        [5.925, 0, 1.42232],
        [5.928, 0, 1.42298],
        [5.931, 0, 1.42359],
        [5.933, 0, 1.42425],
        [5.936, 0, 1.42483],
        [5.939, 0, 1.42548],
        [5.941, 0, 1.42614],
        [5.944, 0, 1.42676],
        [5.947, 0, 1.42741],
        [5.949, 0, 1.42803],
        [5.952, 0, 1.42868],
        [5.955, 0, 1.42929],
        [5.957, 0, 1.42991],
        [5.96, 0, 1.43058],
        [5.963, 0, 1.43118],
        [5.965, 0, 1.43188],
        [5.968, 0, 1.43256],
        [5.971, 0, 1.43316],
        [5.973, 0, 1.43377],
        [5.976, 0, 1.43441],
        [5.979, 0, 1.43506],
        [5.981, 0, 1.43568],
        [5.984, 0, 1.43636],
        [5.987, 0, 1.437],
        [5.989, 0, 1.43761],
        [5.992, 0, 1.43824],
        [5.995, 0, 1.43885],
        [5.997, 0, 1.4395],
        [6, 0, 1.44016],
        [6.003, 0, 1.44078],
        [6.005, 0, 1.44148],
        [6.008, 0, 1.44209],
        [6.011, 0, 1.44275],
        [6.013, 0, 1.44337],
        [6.016, 0, 1.44398],
        [6.019, 0, 1.44465],
        [6.021, 0, 1.44527],
        [6.024, 0, 1.44592],
        [6.027, 0, 1.44658],
        [6.029, 0, 1.44719],
        [6.032, 0, 1.44785],
        [6.035, 0, 1.44848],
        [6.037, 0, 1.44909],
        [6.04, 0, 1.44975],
        [6.043, 0, 1.45035],
        [6.045, 0, 1.45107],
        [6.048, 0, 1.45167],
        [6.051, 0, 1.45233],
        [6.053, 0, 1.453],
        [6.056, 0, 1.45361],
        [6.059, 0, 1.45428],
        [6.061, 0, 1.45491],
        [6.064, 0, 1.45551],
        [6.067, 0, 1.45613],
        [6.069, 0, 1.4568],
        [6.072, 0, 1.45744],
        [6.075, 0, 1.45806],
        [6.077, 0, 1.45872],
        [6.08, 0, 1.45933],
        [6.083, 0, 1.46001],
        [6.085, 0, 1.46071],
        [6.088, 0, 1.46132],
        [6.091, 0, 1.46198],
        [6.093, 0, 1.46261],
        [6.096, 0, 1.46321],
        [6.099, 0, 1.46387],
        [6.101, 0, 1.46448],
        [6.104, 0, 1.46515],
        [6.107, 0, 1.46576],
        [6.109, 0, 1.46643],
        [6.112, 0, 1.46709],
        [6.115, 0, 1.4677],
        [6.117, 0, 1.46835],
        [6.12, 0, 1.46898],
        [6.123, 0, 1.46963],
        [6.125, 0, 1.47033],
        [6.128, 0, 1.47096],
        [6.131, 0, 1.47161],
        [6.133, 0, 1.47218],
        [6.136, 0, 1.47285],
        [6.139, 0, 1.4735],
        [6.141, 0, 1.47413],
        [6.144, 0, 1.47479],
        [6.147, 0, 1.47541],
        [6.149, 0, 1.47606],
        [6.152, 0, 1.4767],
        [6.155, 0, 1.47735],
        [6.157, 0, 1.47801],
        [6.16, 0, 1.47863],
        [6.163, 0, 1.47932],
        [6.165, 0, 1.47994],
        [6.168, 0, 1.4806],
        [6.171, 0, 1.48127],
        [6.173, 0, 1.48188],
        [6.176, 0, 1.48254],
        [6.179, 0, 1.48315],
        [6.181, 0, 1.48381],
        [6.184, 0, 1.48446],
        [6.187, 0, 1.48505],
        [6.189, 0, 1.48571],
        [6.192, 0, 1.48632],
        [6.195, 0, 1.487],
        [6.197, 0, 1.48764],
        [6.2, 0, 1.48829],
        [6.203, 0, 1.48898],
        [6.205, 0, 1.48959],
        [6.208, 0, 1.49024],
        [6.211, 0, 1.49092],
        [6.213, 0, 1.49151],
        [6.216, 0, 1.49221],
        [6.219, 0, 1.49286],
        [6.221, 0, 1.4935],
        [6.224, 0, 1.49418],
        [6.227, 0, 1.4948],
        [6.229, 0, 1.49545],
        [6.232, 0, 1.49606],
        [6.235, 0, 1.49673],
        [6.237, 0, 1.49734],
        [6.24, 0, 1.49805],
        [6.243, 0, 1.49871],
        [6.245, 0, 1.49932],
        [6.248, 0, 1.49999],
        [6.251, 0, 1.5006],
        [6.253, 0, 1.50126],
        [6.256, 0, 1.50191],
        [6.259, 0, 1.50255],
        [6.261, 0, 1.50322],
        [6.264, 0, 1.50383],
        [6.267, 0, 1.50449],
        [6.269, 0, 1.50515],
        [6.272, 0, 1.50575],
        [6.275, 0, 1.50642],
        [6.277, 0, 1.50709],
        [6.28, 0, 1.50773],
        [6.283, 0, 1.50841],
        [6.285, 0, 1.50903],
        [6.288, 0, 1.50967],
        [6.291, 0, 1.5103],
        [6.293, 0, 1.51096],
        [6.296, 0, 1.51161],
        [6.299, 0, 1.51224],
        [6.301, 0, 1.5129],
        [6.304, 0, 1.5135],
        [6.307, 0, 1.51417],
        [6.309, 0, 1.51483],
        [6.312, 0, 1.51547],
        [6.315, 0, 1.51618],
        [6.317, 0, 1.51679],
        [6.32, 0, 1.51745],
        [6.323, 0, 1.51807],
        [6.325, 0, 1.51873],
        [6.328, 0, 1.51939],
        [6.331, 0, 1.52],
        [6.333, 0, 1.52067],
        [6.336, 0, 1.52129],
        [6.339, 0, 1.52195],
        [6.341, 0, 1.52261],
        [6.344, 0, 1.52322],
        [6.347, 0, 1.52393],
        [6.349, 0, 1.52459],
        [6.352, 0, 1.52524],
        [6.355, 0, 1.52591],
        [6.357, 0, 1.52653],
        [6.36, 0, 1.52719],
        [6.363, 0, 1.52782],
        [6.365, 0, 1.52847],
        [6.368, 0, 1.52913],
        [6.371, 0, 1.52975],
        [6.373, 0, 1.53041],
        [6.376, 0, 1.53102],
        [6.379, 0, 1.5317],
        [6.381, 0, 1.53235],
        [6.384, 0, 1.53297],
        [6.387, 0, 1.53368],
        [6.389, 0, 1.5343],
        [6.392, 0, 1.53495],
        [6.395, 0, 1.53562],
        [6.397, 0, 1.53622],
        [6.4, 0, 1.53693],
        [6.403, 0, 1.53757],
        [6.405, 0, 1.53823],
        [6.408, 0, 1.53886],
        [6.411, 0, 1.53951],
        [6.413, 0, 1.54017],
        [6.416, 0, 1.54078],
        [6.419, 0, 1.54146],
        [6.421, 0, 1.54206],
        [6.424, 0, 1.54276],
        [6.427, 0, 1.54344],
        [6.429, 0, 1.54406],
        [6.432, 0, 1.54472],
        [6.435, 0, 1.54535],
        [6.437, 0, 1.546],
        [6.44, 0, 1.54671],
        [6.443, 0, 1.54732],
        [6.445, 0, 1.54798],
        [6.448, 0, 1.54861],
        [6.451, 0, 1.54926],
        [6.453, 0, 1.54991],
        [6.456, 0, 1.55055],
        [6.459, 0, 1.55124],
        [6.461, 0, 1.55187],
        [6.464, 0, 1.55254],
        [6.467, 0, 1.55318],
        [6.469, 0, 1.55384],
        [6.472, 0, 1.55451],
        [6.475, 0, 1.55512],
        [6.477, 0, 1.55579],
        [6.48, 0, 1.55645],
        [6.483, 0, 1.55707],
        [6.485, 0, 1.55774],
        [6.488, 0, 1.55836],
        [6.491, 0, 1.55903],
        [6.493, 0, 1.55964],
        [6.496, 0, 1.56039],
        [6.499, 0, 1.56106],
        [6.501, 0, 1.56168],
        [6.504, 0, 1.56234],
        [6.507, 0, 1.56295],
        [6.509, 0, 1.56361],
        [6.512, 0, 1.56429],
        [6.515, 0, 1.5649],
        [6.517, 0, 1.56557],
        [6.52, 0, 1.56618],
        [6.523, 0, 1.56688],
        [6.525, 0, 1.56755],
        [6.528, 0, 1.56816],
        [6.531, 0, 1.56887],
        [6.533, 0, 1.56949],
        [6.536, 0, 1.57014],
        [6.539, 0, 1.57082],
        [6.541, 0, 1.57144],
        [6.544, 0, 1.57214],
        [6.547, 0, 1.57278],
        [6.549, 0, 1.57343],
        [6.552, 0, 1.57409],
        [6.555, 0, 1.57471],
        [6.557, 0, 1.57536],
        [6.56, 0, 1.57599],
        [6.563, 0, 1.57665],
        [6.565, 0, 1.57736],
        [6.568, 0, 1.57802],
        [6.571, 0, 1.57868],
        [6.573, 0, 1.5793],
        [6.576, 0, 1.58],
        [6.579, 0, 1.58063],
        [6.581, 0, 1.58128],
        [6.584, 0, 1.58198],
        [6.587, 0, 1.58261],
        [6.589, 0, 1.58326],
        [6.592, 0, 1.58389],
        [6.595, 0, 1.58456],
        [6.597, 0, 1.58521],
        [6.6, 0, 1.58591],
        [6.603, 0, 1.5866],
        [6.605, 0, 1.58722],
        [6.608, 0, 1.58789],
        [6.611, 0, 1.58854],
        [6.613, 0, 1.58917],
        [6.616, 0, 1.58983],
        [6.619, 0, 1.5905],
        [6.621, 0, 1.59116],
        [6.624, 0, 1.59181],
        [6.627, 0, 1.59243],
        [6.629, 0, 1.59309],
        [6.632, 0, 1.59371],
        [6.635, 0, 1.59446],
        [6.637, 0, 1.59513],
        [6.64, 0, 1.59575],
        [6.643, 0, 1.5964],
        [6.645, 0, 1.59703],
        [6.648, 0, 1.5977],
        [6.651, 0, 1.59835],
        [6.653, 0, 1.59902],
        [6.656, 0, 1.59969],
        [6.659, 0, 1.60031],
        [6.661, 0, 1.60098],
        [6.664, 0, 1.60158],
        [6.667, 0, 1.60228],
        [6.669, 0, 1.603],
        [6.672, 0, 1.60362],
        [6.675, 0, 1.60429],
        [6.677, 0, 1.60491],
        [6.68, 0, 1.60561],
        [6.683, 0, 1.60628],
        [6.685, 0, 1.60689],
        [6.688, 0, 1.60756],
        [6.691, 0, 1.60818],
        [6.693, 0, 1.60883],
        [6.696, 0, 1.60954],
        [6.699, 0, 1.61016],
        [6.701, 0, 1.61082],
        [6.704, 0, 1.61151],
        [6.707, 0, 1.61216],
        [6.709, 0, 1.61287],
        [6.712, 0, 1.6135],
        [6.715, 0, 1.61416],
        [6.717, 0, 1.61477],
        [6.72, 0, 1.61544],
        [6.723, 0, 1.61615],
        [6.725, 0, 1.61676],
        [6.728, 0, 1.61744],
        [6.731, 0, 1.61805],
        [6.733, 0, 1.61872],
        [6.736, 0, 1.61939],
        [6.739, 0, 1.62008],
        [6.741, 0, 1.62076],
        [6.744, 0, 1.62136],
        [6.747, 0, 1.62207],
        [6.749, 0, 1.6227],
        [6.752, 0, 1.62335],
        [6.755, 0, 1.62402],
        [6.757, 0, 1.62464],
        [6.76, 0, 1.62534],
        [6.763, 0, 1.62598],
        [6.765, 0, 1.62664],
        [6.768, 0, 1.6273],
        [6.771, 0, 1.62797],
        [6.773, 0, 1.62867],
        [6.776, 0, 1.62929],
        [6.779, 0, 1.62996],
        [6.781, 0, 1.63062],
        [6.784, 0, 1.63127],
        [6.787, 0, 1.63195],
        [6.789, 0, 1.63256],
        [6.792, 0, 1.63323],
        [6.795, 0, 1.63395],
        [6.797, 0, 1.63455],
        [6.8, 0, 1.63523],
        [6.803, 0, 1.63584],
        [6.805, 0, 1.63659],
        [6.808, 0, 1.63726],
        [6.811, 0, 1.63787],
        [6.813, 0, 1.63856],
        [6.816, 0, 1.63917],
        [6.819, 0, 1.63986],
        [6.821, 0, 1.64051],
        [6.824, 0, 1.64117],
        [6.827, 0, 1.64184],
        [6.829, 0, 1.64251],
        [6.832, 0, 1.64316],
        [6.835, 0, 1.64378],
        [6.837, 0, 1.6445],
        [6.84, 0, 1.6452],
        [6.843, 0, 1.64582],
        [6.845, 0, 1.64648],
        [6.848, 0, 1.64714],
        [6.851, 0, 1.6478],
        [6.853, 0, 1.64848],
        [6.856, 0, 1.64909],
        [6.859, 0, 1.64979],
        [6.861, 0, 1.65042],
        [6.864, 0, 1.65109],
        [6.867, 0, 1.65175],
        [6.869, 0, 1.6524],
        [6.872, 0, 1.65312],
        [6.875, 0, 1.65374],
        [6.877, 0, 1.65439],
        [6.88, 0, 1.65511],
        [6.883, 0, 1.65574],
        [6.885, 0, 1.65641],
        [6.888, 0, 1.65707],
        [6.891, 0, 1.65773],
        [6.893, 0, 1.6584],
        [6.896, 0, 1.65902],
        [6.899, 0, 1.65972],
        [6.901, 0, 1.66034],
        [6.904, 0, 1.66105],
        [6.907, 0, 1.66168],
        [6.909, 0, 1.66237],
        [6.912, 0, 1.66305],
        [6.915, 0, 1.66368],
        [6.917, 0, 1.66438],
        [6.92, 0, 1.665],
        [6.923, 0, 1.66566],
        [6.925, 0, 1.66633],
        [6.928, 0, 1.667],
        [6.931, 0, 1.66767],
        [6.933, 0, 1.66828],
        [6.936, 0, 1.66903],
        [6.939, 0, 1.66971],
        [6.941, 0, 1.67032],
        [6.944, 0, 1.67104],
        [6.947, 0, 1.67166],
        [6.949, 0, 1.67234],
        [6.952, 0, 1.67299],
        [6.955, 0, 1.67365],
        [6.957, 0, 1.67433],
        [6.96, 0, 1.67494],
        [6.963, 0, 1.67565],
        [6.965, 0, 1.67632],
        [6.968, 0, 1.67696],
        [6.971, 0, 1.67769],
        [6.973, 0, 1.67831],
        [6.976, 0, 1.67896],
        [6.979, 0, 1.67969],
        [6.981, 0, 1.68031],
        [6.984, 0, 1.68097],
        [6.987, 0, 1.68158],
        [6.989, 0, 1.6823],
        [6.992, 0, 1.68292],
        [6.995, 0, 1.68359],
        [6.997, 0, 1.6843],
        [7, 0, 1.68491],
        [7.003, 0, 1.68567],
        [7.005, 0, 1.68633],
        [7.008, 0, 1.687],
        [7.011, 0, 1.68766],
        [7.013, 0, 1.68834],
        [7.016, 0, 1.689],
        [7.019, 0, 1.6896],
        [7.021, 0, 1.69033],
        [7.024, 0, 1.69098],
        [7.027, 0, 1.69162],
        [7.029, 0, 1.69232],
        [7.032, 0, 1.69294],
        [7.035, 0, 1.69365],
        [7.037, 0, 1.69435],
        [7.04, 0, 1.69498],
        [7.043, 0, 1.69565],
        [7.045, 0, 1.6963],
        [7.048, 0, 1.69699],
        [7.051, 0, 1.69766],
        [7.053, 0, 1.69832],
        [7.056, 0, 1.69899],
        [7.059, 0, 1.69961],
        [7.061, 0, 1.70032],
        [7.064, 0, 1.70098],
        [7.067, 0, 1.70164],
        [7.069, 0, 1.70235],
        [7.072, 0, 1.70297],
        [7.075, 0, 1.70368],
        [7.077, 0, 1.70431],
        [7.08, 0, 1.70497],
        [7.083, 0, 1.70569],
        [7.085, 0, 1.7063],
        [7.088, 0, 1.70696],
        [7.091, 0, 1.70763],
        [7.093, 0, 1.70829],
        [7.096, 0, 1.70897],
        [7.099, 0, 1.70967],
        [7.101, 0, 1.71033],
        [7.104, 0, 1.711],
        [7.107, 0, 1.71166],
        [7.109, 0, 1.71234],
        [7.112, 0, 1.713],
        [7.115, 0, 1.71368],
        [7.117, 0, 1.71431],
        [7.12, 0, 1.71501],
        [7.123, 0, 1.71568],
        [7.125, 0, 1.7163],
        [7.128, 0, 1.71704],
        [7.131, 0, 1.71767],
        [7.133, 0, 1.71838],
        [7.136, 0, 1.71903],
        [7.139, 0, 1.71967],
        [7.141, 0, 1.72037],
        [7.144, 0, 1.72099],
        [7.147, 0, 1.72171],
        [7.149, 0, 1.72236],
        [7.152, 0, 1.723],
        [7.155, 0, 1.7237],
        [7.157, 0, 1.72433],
        [7.16, 0, 1.72503],
        [7.163, 0, 1.72569],
        [7.165, 0, 1.72637],
        [7.168, 0, 1.72708],
        [7.171, 0, 1.72771],
        [7.173, 0, 1.72837],
        [7.176, 0, 1.72904],
        [7.179, 0, 1.72971],
        [7.181, 0, 1.73043],
        [7.184, 0, 1.73105],
        [7.187, 0, 1.73171],
        [7.189, 0, 1.73238],
        [7.192, 0, 1.73309],
        [7.195, 0, 1.7338],
        [7.197, 0, 1.73443],
        [7.2, 0, 1.73509],
        [7.203, 0, 1.73575],
        [7.205, 0, 1.73642],
        [7.208, 0, 1.73713],
        [7.211, 0, 1.73774],
        [7.213, 0, 1.73842],
        [7.216, 0, 1.73908],
        [7.219, 0, 1.73976],
        [7.221, 0, 1.74051],
        [7.224, 0, 1.74112],
        [7.227, 0, 1.74185],
        [7.229, 0, 1.74245],
        [7.232, 0, 1.74314],
        [7.235, 0, 1.74379],
        [7.237, 0, 1.74445],
        [7.24, 0, 1.74517],
        [7.243, 0, 1.74579],
        [7.245, 0, 1.74645],
        [7.248, 0, 1.74712],
        [7.251, 0, 1.74778],
        [7.253, 0, 1.74855],
        [7.256, 0, 1.74918],
        [7.259, 0, 1.74989],
        [7.261, 0, 1.75051],
        [7.264, 0, 1.75117],
        [7.267, 0, 1.75188],
        [7.269, 0, 1.7525],
        [7.272, 0, 1.75321],
        [7.275, 0, 1.75383],
        [7.277, 0, 1.75454],
        [7.28, 0, 1.75523],
        [7.283, 0, 1.75588],
        [7.285, 0, 1.7566],
        [7.288, 0, 1.75722],
        [7.291, 0, 1.75792],
        [7.293, 0, 1.7586],
        [7.296, 0, 1.75925],
        [7.299, 0, 1.75994],
        [7.301, 0, 1.76059],
        [7.304, 0, 1.76126],
        [7.307, 0, 1.76198],
        [7.309, 0, 1.76259],
        [7.312, 0, 1.76327],
        [7.315, 0, 1.76398],
        [7.317, 0, 1.76465],
        [7.32, 0, 1.7653],
        [7.323, 0, 1.76598],
        [7.325, 0, 1.7667],
        [7.328, 0, 1.76731],
        [7.331, 0, 1.76802],
        [7.333, 0, 1.76865],
        [7.336, 0, 1.76936],
        [7.339, 0, 1.77003],
        [7.341, 0, 1.7707],
        [7.344, 0, 1.7714],
        [7.347, 0, 1.77204],
        [7.349, 0, 1.77274],
        [7.352, 0, 1.77341],
        [7.355, 0, 1.77407],
        [7.357, 0, 1.77475],
        [7.36, 0, 1.77541],
        [7.363, 0, 1.77607],
        [7.365, 0, 1.7768],
        [7.368, 0, 1.77741],
        [7.371, 0, 1.77812],
        [7.373, 0, 1.77874],
        [7.376, 0, 1.7795],
        [7.379, 0, 1.78016],
        [7.381, 0, 1.78084],
        [7.384, 0, 1.78151],
        [7.387, 0, 1.78216],
        [7.389, 0, 1.78284],
        [7.392, 0, 1.78355],
        [7.395, 0, 1.78417],
        [7.397, 0, 1.78489],
        [7.4, 0, 1.78551],
        [7.403, 0, 1.78621],
        [7.405, 0, 1.78689],
        [7.408, 0, 1.78756],
        [7.411, 0, 1.78828],
        [7.413, 0, 1.78888],
        [7.416, 0, 1.7896],
        [7.419, 0, 1.79023],
        [7.421, 0, 1.79093],
        [7.424, 0, 1.79161],
        [7.427, 0, 1.79226],
        [7.429, 0, 1.79293],
        [7.432, 0, 1.7936],
        [7.435, 0, 1.79431],
        [7.437, 0, 1.79502],
        [7.44, 0, 1.79564],
        [7.443, 0, 1.79637],
        [7.445, 0, 1.79698],
        [7.448, 0, 1.79771],
        [7.451, 0, 1.79838],
        [7.453, 0, 1.79905],
        [7.456, 0, 1.79977],
        [7.459, 0, 1.80039],
        [7.461, 0, 1.80109],
        [7.464, 0, 1.80176],
        [7.467, 0, 1.80247],
        [7.469, 0, 1.80314],
        [7.472, 0, 1.8038],
        [7.475, 0, 1.80447],
        [7.477, 0, 1.80519],
        [7.48, 0, 1.80581],
        [7.483, 0, 1.80654],
        [7.485, 0, 1.80715],
        [7.488, 0, 1.80787],
        [7.491, 0, 1.80848],
        [7.493, 0, 1.80919],
        [7.496, 0, 1.8099],
        [7.499, 0, 1.81057],
        [7.501, 0, 1.81124],
        [7.504, 0, 1.81191],
        [7.507, 0, 1.81259],
        [7.509, 0, 1.81329],
        [7.512, 0, 1.81396],
        [7.515, 0, 1.81464],
        [7.517, 0, 1.8153],
        [7.52, 0, 1.81596],
        [7.523, 0, 1.81668],
        [7.525, 0, 1.81739],
        [7.528, 0, 1.8181],
        [7.531, 0, 1.81872],
        [7.533, 0, 1.81944],
        [7.536, 0, 1.82011],
        [7.539, 0, 1.82076],
        [7.541, 0, 1.82145],
        [7.544, 0, 1.8221],
        [7.547, 0, 1.82282],
        [7.549, 0, 1.82348],
        [7.552, 0, 1.82415],
        [7.555, 0, 1.82486],
        [7.557, 0, 1.82554],
        [7.56, 0, 1.82621],
        [7.563, 0, 1.82692],
        [7.565, 0, 1.82756],
        [7.568, 0, 1.82826],
        [7.571, 0, 1.82892],
        [7.573, 0, 1.8296],
        [7.576, 0, 1.83026],
        [7.579, 0, 1.83093],
        [7.581, 0, 1.83166],
        [7.584, 0, 1.83231],
        [7.587, 0, 1.83303],
        [7.589, 0, 1.83364],
        [7.592, 0, 1.83437],
        [7.595, 0, 1.83507],
        [7.597, 0, 1.83569],
        [7.6, 0, 1.8364],
        [7.603, 0, 1.83702],
        [7.605, 0, 1.83776],
        [7.608, 0, 1.83842],
        [7.611, 0, 1.8391],
        [7.613, 0, 1.83984],
        [7.616, 0, 1.84048],
        [7.619, 0, 1.84119],
        [7.621, 0, 1.84185],
        [7.624, 0, 1.84253],
        [7.627, 0, 1.8432],
        [7.629, 0, 1.84387],
        [7.632, 0, 1.84458],
        [7.635, 0, 1.84524],
        [7.637, 0, 1.84591],
        [7.64, 0, 1.84658],
        [7.643, 0, 1.84729],
        [7.645, 0, 1.84801],
        [7.648, 0, 1.84867],
        [7.651, 0, 1.84935],
        [7.653, 0, 1.85001],
        [7.656, 0, 1.85069],
        [7.659, 0, 1.85139],
        [7.661, 0, 1.85203],
        [7.664, 0, 1.85272],
        [7.667, 0, 1.8534],
        [7.669, 0, 1.85411],
        [7.672, 0, 1.85481],
        [7.675, 0, 1.85546],
        [7.677, 0, 1.85616],
        [7.68, 0, 1.85684],
        [7.683, 0, 1.8575],
        [7.685, 0, 1.85822],
        [7.688, 0, 1.85884],
        [7.691, 0, 1.85956],
        [7.693, 0, 1.86023],
        [7.696, 0, 1.86089],
        [7.699, 0, 1.86166],
        [7.701, 0, 1.86228],
        [7.704, 0, 1.86299],
        [7.707, 0, 1.86366],
        [7.709, 0, 1.86432],
        [7.712, 0, 1.86505],
        [7.715, 0, 1.86566],
        [7.717, 0, 1.86637],
        [7.72, 0, 1.86704],
        [7.723, 0, 1.86771],
        [7.725, 0, 1.86842],
        [7.728, 0, 1.86908],
        [7.731, 0, 1.86982],
        [7.733, 0, 1.87053],
        [7.736, 0, 1.87117],
        [7.739, 0, 1.87187],
        [7.741, 0, 1.87251],
        [7.744, 0, 1.87321],
        [7.747, 0, 1.87387],
        [7.749, 0, 1.87454],
        [7.752, 0, 1.87526],
        [7.755, 0, 1.87593],
        [7.757, 0, 1.87664],
        [7.76, 0, 1.87731],
        [7.763, 0, 1.87802],
        [7.765, 0, 1.87869],
        [7.768, 0, 1.87936],
        [7.771, 0, 1.88003],
        [7.773, 0, 1.8807],
        [7.776, 0, 1.88143],
        [7.779, 0, 1.88209],
        [7.781, 0, 1.88276],
        [7.784, 0, 1.88351],
        [7.787, 0, 1.88416],
        [7.789, 0, 1.88485],
        [7.792, 0, 1.88558],
        [7.795, 0, 1.8862],
        [7.797, 0, 1.88692],
        [7.8, 0, 1.88758],
        [7.803, 0, 1.88825],
        [7.805, 0, 1.88896],
        [7.808, 0, 1.88959],
        [7.811, 0, 1.8903],
        [7.813, 0, 1.89101],
        [7.816, 0, 1.89169],
        [7.819, 0, 1.8924],
        [7.821, 0, 1.89306],
        [7.824, 0, 1.89374],
        [7.827, 0, 1.89441],
        [7.829, 0, 1.89512],
        [7.832, 0, 1.89575],
        [7.835, 0, 1.89646],
        [7.837, 0, 1.89717],
        [7.84, 0, 1.89785],
        [7.843, 0, 1.89856],
        [7.845, 0, 1.89923],
        [7.848, 0, 1.89991],
        [7.851, 0, 1.90061],
        [7.853, 0, 1.90128],
        [7.856, 0, 1.90195],
        [7.859, 0, 1.90263],
        [7.861, 0, 1.90333],
        [7.864, 0, 1.904],
        [7.867, 0, 1.90468],
        [7.869, 0, 1.90544],
        [7.872, 0, 1.90606],
        [7.875, 0, 1.90678],
        [7.877, 0, 1.90749],
        [7.88, 0, 1.90816],
        [7.883, 0, 1.90883],
        [7.885, 0, 1.9095],
        [7.888, 0, 1.9102],
        [7.891, 0, 1.91088],
        [7.893, 0, 1.91155],
        [7.896, 0, 1.9123],
        [7.899, 0, 1.91293],
        [7.901, 0, 1.91365],
        [7.904, 0, 1.91432],
        [7.907, 0, 1.91498],
        [7.909, 0, 1.91571],
        [7.912, 0, 1.91638],
        [7.915, 0, 1.91705],
        [7.917, 0, 1.91772],
        [7.92, 0, 1.91844],
        [7.923, 0, 1.91914],
        [7.925, 0, 1.91983],
        [7.928, 0, 1.92053],
        [7.931, 0, 1.9212],
        [7.933, 0, 1.92187],
        [7.936, 0, 1.92259],
        [7.939, 0, 1.92327],
        [7.941, 0, 1.92393],
        [7.944, 0, 1.92461],
        [7.947, 0, 1.92532],
        [7.949, 0, 1.92603],
        [7.952, 0, 1.92671],
        [7.955, 0, 1.92741],
        [7.957, 0, 1.92809],
        [7.96, 0, 1.92877],
        [7.963, 0, 1.92949],
        [7.965, 0, 1.93014],
        [7.968, 0, 1.93088],
        [7.971, 0, 1.93149],
        [7.973, 0, 1.93221],
        [7.976, 0, 1.93293],
        [7.979, 0, 1.93359],
        [7.981, 0, 1.93431],
        [7.984, 0, 1.93498],
        [7.987, 0, 1.93569],
        [7.989, 0, 1.93632],
        [7.992, 0, 1.93704],
        [7.995, 0, 1.93774],
        [7.997, 0, 1.93841],
    ])
    return spectrum


def StainlessSteel316L_Gamma():
    spectrum = np.array([
        [0, 0, 1.30312],
        [0.003, 0, 1.30365],
        [0.005, 2.58155e-05, 1.30412],
        [0.008, 7.66688e-05, 1.30463],
        [0.011, 0.00013281, 1.30507],
        [0.013, 0.000187862, 1.3055],
        [0.016, 0.000269818, 1.30591],
        [0.019, 0.000372302, 1.30634],
        [0.021, 0.000483496, 1.30673],
        [0.024, 0.000616305, 1.30712],
        [0.027, 0.000753314, 1.30745],
        [0.029, 0.00091536, 1.30777],
        [0.032, 0.0010998, 1.3081],
        [0.035, 0.00128766, 1.30839],
        [0.037, 0.00150056, 1.30865],
        [0.04, 0.00171953, 1.30893],
        [0.043, 0.00195824, 1.30918],
        [0.045, 0.00220302, 1.30939],
        [0.048, 0.00246755, 1.30958],
        [0.051, 0.00276241, 1.30977],
        [0.053, 0.00305804, 1.30995],
        [0.056, 0.00337871, 1.31008],
        [0.059, 0.00369939, 1.31021],
        [0.061, 0.00404587, 1.31033],
        [0.064, 0.00439656, 1.31042],
        [0.067, 0.00477757, 1.3105],
        [0.069, 0.00515329, 1.31053],
        [0.072, 0.00557225, 1.31058],
        [0.075, 0.0059825, 1.3106],
        [0.077, 0.00641514, 1.31056],
        [0.08, 0.00686333, 1.31059],
        [0.083, 0.00734263, 1.31055],
        [0.085, 0.00780451, 1.31048],
        [0.088, 0.00831304, 1.31038],
        [0.091, 0.00882686, 1.3103],
        [0.093, 0.00936121, 1.3102],
        [0.096, 0.00989556, 1.31009],
        [0.099, 0.010461, 1.30994],
        [0.101, 0.0110212, 1.30976],
        [0.104, 0.0116151, 1.30956],
        [0.107, 0.0122098, 1.30934],
        [0.109, 0.0128424, 1.30914],
        [0.112, 0.0134621, 1.30891],
        [0.115, 0.0141077, 1.30863],
        [0.117, 0.0147756, 1.30835],
        [0.12, 0.0154515, 1.30806],
        [0.123, 0.0161487, 1.30774],
        [0.125, 0.0168667, 1.30741],
        [0.128, 0.0175942, 1.30704],
        [0.131, 0.0183198, 1.30668],
        [0.133, 0.0190947, 1.30628],
        [0.136, 0.0198515, 1.3059],
        [0.139, 0.0206522, 1.30547],
        [0.141, 0.0214564, 1.30502],
        [0.144, 0.022264, 1.30454],
        [0.147, 0.0230939, 1.30406],
        [0.149, 0.023949, 1.30355],
        [0.152, 0.0248074, 1.30304],
        [0.155, 0.0256935, 1.30249],
        [0.157, 0.0265778, 1.30196],
        [0.16, 0.0274897, 1.30138],
        [0.163, 0.0284051, 1.30077],
        [0.165, 0.029341, 1.30018],
        [0.168, 0.0303038, 1.29955],
        [0.171, 0.03127, 1.29886],
        [0.173, 0.032262, 1.2982],
        [0.176, 0.0332593, 1.29751],
        [0.179, 0.0342764, 1.29684],
        [0.181, 0.0352942, 1.2961],
        [0.184, 0.0363424, 1.29536],
        [0.187, 0.0374111, 1.29459],
        [0.189, 0.0384885, 1.29382],
        [0.192, 0.0395883, 1.293],
        [0.195, 0.0406881, 1.2922],
        [0.197, 0.0418111, 1.29138],
        [0.2, 0.042942, 1.29053],
        [0.203, 0.0440961, 1.28964],
        [0.205, 0.0452718, 1.28875],
        [0.208, 0.0464516, 1.28786],
        [0.211, 0.0476584, 1.28693],
        [0.213, 0.0488642, 1.28598],
        [0.216, 0.0501002, 1.285],
        [0.219, 0.0513309, 1.28401],
        [0.221, 0.0525928, 1.28302],
        [0.224, 0.0538804, 1.28201],
        [0.227, 0.0551673, 1.28098],
        [0.229, 0.0564584, 1.2799],
        [0.232, 0.0577935, 1.27882],
        [0.235, 0.0591157, 1.27772],
        [0.237, 0.0604792, 1.27662],
        [0.24, 0.0618436, 1.2755],
        [0.243, 0.0632166, 1.27434],
        [0.245, 0.0646147, 1.27317],
        [0.248, 0.0660299, 1.27199],
        [0.251, 0.0674538, 1.27078],
        [0.253, 0.0689035, 1.26956],
        [0.256, 0.0703532, 1.26831],
        [0.259, 0.0718245, 1.26705],
        [0.261, 0.0733251, 1.26577],
        [0.264, 0.0748309, 1.26449],
        [0.267, 0.0763539, 1.26318],
        [0.269, 0.077889, 1.26184],
        [0.272, 0.0794412, 1.26046],
        [0.275, 0.0809979, 1.25912],
        [0.277, 0.0825812, 1.25771],
        [0.28, 0.0841618, 1.25632],
        [0.283, 0.0857701, 1.25488],
        [0.285, 0.0874043, 1.25344],
        [0.288, 0.0890472, 1.25199],
        [0.291, 0.0907063, 1.25047],
        [0.293, 0.092369, 1.24899],
        [0.296, 0.0940627, 1.2475],
        [0.299, 0.0957735, 1.24593],
        [0.301, 0.097493, 1.24439],
        [0.304, 0.0992072, 1.24279],
        [0.307, 0.100974, 1.24122],
        [0.309, 0.102723, 1.23962],
        [0.312, 0.104518, 1.23797],
        [0.315, 0.106311, 1.23632],
        [0.317, 0.108111, 1.23466],
        [0.32, 0.109938, 1.23297],
        [0.323, 0.111785, 1.23129],
        [0.325, 0.113641, 1.22956],
        [0.328, 0.115514, 1.22782],
        [0.331, 0.117392, 1.22606],
        [0.333, 0.119299, 1.2243],
        [0.336, 0.121201, 1.22251],
        [0.339, 0.12313, 1.2207],
        [0.341, 0.125089, 1.21889],
        [0.344, 0.127052, 1.21705],
        [0.347, 0.129033, 1.21517],
        [0.349, 0.131017, 1.21331],
        [0.352, 0.133026, 1.2114],
        [0.355, 0.135041, 1.20951],
        [0.357, 0.137085, 1.20757],
        [0.36, 0.139142, 1.20561],
        [0.363, 0.141208, 1.20366],
        [0.365, 0.143299, 1.20171],
        [0.368, 0.145394, 1.19968],
        [0.371, 0.147511, 1.19767],
        [0.373, 0.149632, 1.19566],
        [0.376, 0.151775, 1.19359],
        [0.379, 0.153948, 1.19158],
        [0.381, 0.15612, 1.18948],
        [0.384, 0.158322, 1.18741],
        [0.387, 0.160516, 1.18528],
        [0.389, 0.162744, 1.18318],
        [0.392, 0.164973, 1.18105],
        [0.395, 0.167226, 1.17891],
        [0.397, 0.169505, 1.1767],
        [0.4, 0.171784, 1.17457],
        [0.403, 0.174086, 1.17235],
        [0.405, 0.1764, 1.17012],
        [0.408, 0.17873, 1.16794],
        [0.411, 0.181065, 1.16572],
        [0.413, 0.183425, 1.16345],
        [0.416, 0.18579, 1.1612],
        [0.419, 0.188199, 1.15892],
        [0.421, 0.190584, 1.15665],
        [0.424, 0.193, 1.15433],
        [0.427, 0.195438, 1.15207],
        [0.429, 0.197907, 1.14972],
        [0.432, 0.200374, 1.1474],
        [0.435, 0.202841, 1.14506],
        [0.437, 0.205339, 1.14269],
        [0.44, 0.207858, 1.14035],
        [0.443, 0.210381, 1.13798],
        [0.445, 0.212925, 1.13557],
        [0.448, 0.215474, 1.13318],
        [0.451, 0.218049, 1.13081],
        [0.453, 0.220648, 1.12837],
        [0.456, 0.223249, 1.12596],
        [0.459, 0.225853, 1.12352],
        [0.461, 0.228509, 1.12106],
        [0.464, 0.231139, 1.11863],
        [0.467, 0.233821, 1.11618],
        [0.469, 0.236498, 1.11373],
        [0.472, 0.239187, 1.11125],
        [0.475, 0.241895, 1.10879],
        [0.477, 0.244627, 1.1063],
        [0.48, 0.247363, 1.10383],
        [0.483, 0.250122, 1.10132],
        [0.485, 0.252894, 1.09885],
        [0.488, 0.255678, 1.09634],
        [0.491, 0.25847, 1.09382],
        [0.493, 0.261289, 1.09133],
        [0.496, 0.264128, 1.0888],
        [0.499, 0.266973, 1.08628],
        [0.501, 0.269837, 1.08375],
        [0.504, 0.272711, 1.08122],
        [0.507, 0.275607, 1.07871],
        [0.509, 0.278527, 1.07616],
        [0.512, 0.281453, 1.07363],
        [0.515, 0.284377, 1.07108],
        [0.517, 0.287333, 1.06855],
        [0.52, 0.290224, 1.06602],
        [0.523, 0.293227, 1.06346],
        [0.525, 0.296228, 1.06091],
        [0.528, 0.299235, 1.05836],
        [0.531, 0.302267, 1.0558],
        [0.533, 0.305294, 1.05325],
        [0.536, 0.308377, 1.05071],
        [0.539, 0.311435, 1.04816],
        [0.541, 0.314544, 1.04561],
        [0.544, 0.317637, 1.0431],
        [0.547, 0.320771, 1.04054],
        [0.549, 0.323905, 1.03798],
        [0.552, 0.327049, 1.03543],
        [0.555, 0.330209, 1.03289],
        [0.557, 0.333404, 1.03036],
        [0.56, 0.336598, 1.02781],
        [0.563, 0.33935, 1.02527],
        [0.565, 0.342571, 1.02274],
        [0.568, 0.345816, 1.02021],
        [0.571, 0.349062, 1.01768],
        [0.573, 0.352332, 1.01516],
        [0.576, 0.355625, 1.01263],
        [0.579, 0.358927, 1.01012],
        [0.581, 0.362228, 1.00762],
        [0.584, 0.365555, 1.00508],
        [0.587, 0.368903, 1.00258],
        [0.589, 0.372281, 1.00005],
        [0.592, 0.375394, 0.997566],
        [0.595, 0.378798, 0.995071],
        [0.597, 0.382203, 0.992595],
        [0.6, 0.384797, 0.990094],
        [0.603, 0.38823, 0.987619],
        [0.605, 0.391668, 0.985161],
        [0.608, 0.395124, 0.98269],
        [0.611, 0.398613, 0.980221],
        [0.613, 0.402097, 0.977773],
        [0.616, 0.404581, 0.975298],
        [0.619, 0.408096, 0.972856],
        [0.621, 0.411611, 0.970446],
        [0.624, 0.415151, 0.968017],
        [0.627, 0.417555, 0.965602],
        [0.629, 0.421121, 0.963182],
        [0.632, 0.42469, 0.960756],
        [0.635, 0.427662, 0.958392],
        [0.637, 0.431257, 0.955993],
        [0.64, 0.434874, 0.953602],
        [0.643, 0.438495, 0.951184],
        [0.645, 0.442146, 0.948813],
        [0.648, 0.444311, 0.946488],
        [0.651, 0.447978, 0.944123],
        [0.653, 0.451655, 0.941754],
        [0.656, 0.455357, 0.939411],
        [0.659, 0.459054, 0.937071],
        [0.661, 0.462781, 0.93473],
        [0.664, 0.466535, 0.932466],
        [0.667, 0.466602, 0.930147],
        [0.669, 0.470332, 0.92784],
        [0.672, 0.474085, 0.925546],
        [0.675, 0.477869, 0.923264],
        [0.677, 0.481651, 0.920995],
        [0.68, 0.485454, 0.918731],
        [0.683, 0.489267, 0.916445],
        [0.685, 0.493096, 0.914232],
        [0.688, 0.496935, 0.911972],
        [0.691, 0.500018, 0.909765],
        [0.693, 0.503876, 0.907552],
        [0.696, 0.505317, 0.90534],
        [0.699, 0.509184, 0.90316],
        [0.701, 0.51309, 0.900949],
        [0.704, 0.51161, 0.898746],
        [0.707, 0.515493, 0.896614],
        [0.709, 0.519407, 0.894435],
        [0.712, 0.523321, 0.892295],
        [0.715, 0.527239, 0.890148],
        [0.717, 0.531178, 0.887988],
        [0.72, 0.53206, 0.885883],
        [0.723, 0.529662, 0.883787],
        [0.725, 0.533579, 0.881685],
        [0.728, 0.53752, 0.879584],
        [0.731, 0.54146, 0.877505],
        [0.733, 0.541915, 0.875448],
        [0.736, 0.545856, 0.873374],
        [0.739, 0.549823, 0.871343],
        [0.741, 0.553813, 0.869277],
        [0.744, 0.557784, 0.867257],
        [0.747, 0.561807, 0.865205],
        [0.749, 0.565826, 0.863207],
        [0.752, 0.569854, 0.861243],
        [0.755, 0.573898, 0.859221],
        [0.757, 0.577972, 0.857244],
        [0.76, 0.582051, 0.855276],
        [0.763, 0.586129, 0.853332],
        [0.765, 0.585641, 0.851363],
        [0.768, 0.589741, 0.849444],
        [0.771, 0.593845, 0.847503],
        [0.773, 0.597949, 0.845562],
        [0.776, 0.602078, 0.843668],
        [0.779, 0.606234, 0.841813],
        [0.781, 0.610389, 0.839919],
        [0.784, 0.603974, 0.838001],
        [0.787, 0.608081, 0.836137],
        [0.789, 0.601211, 0.834299],
        [0.792, 0.605287, 0.83246],
        [0.795, 0.609359, 0.83063],
        [0.797, 0.613461, 0.82881],
        [0.8, 0.617567, 0.82698],
        [0.803, 0.615581, 0.825151],
        [0.805, 0.619681, 0.823383],
        [0.808, 0.623783, 0.821606],
        [0.811, 0.627914, 0.819857],
        [0.813, 0.632045, 0.818069],
        [0.816, 0.636198, 0.816303],
        [0.819, 0.640355, 0.81458],
        [0.821, 0.644542, 0.812843],
        [0.824, 0.641619, 0.81112],
        [0.827, 0.645797, 0.809413],
        [0.829, 0.632746, 0.807708],
        [0.832, 0.636819, 0.806008],
        [0.835, 0.640923, 0.804351],
        [0.837, 0.645028, 0.802683],
        [0.84, 0.649127, 0.801011],
        [0.843, 0.653256, 0.799372],
        [0.845, 0.657411, 0.797714],
        [0.848, 0.649108, 0.796116],
        [0.851, 0.653202, 0.794485],
        [0.853, 0.657309, 0.792865],
        [0.856, 0.661408, 0.791269],
        [0.859, 0.665541, 0.789667],
        [0.861, 0.669673, 0.788097],
        [0.864, 0.673829, 0.786538],
        [0.867, 0.678008, 0.784989],
        [0.869, 0.682167, 0.783427],
        [0.872, 0.666967, 0.781904],
        [0.875, 0.671043, 0.78034],
        [0.877, 0.66507, 0.77884],
        [0.88, 0.669121, 0.777326],
        [0.883, 0.673171, 0.775859],
        [0.885, 0.677247, 0.774321],
        [0.888, 0.681343, 0.772855],
        [0.891, 0.685428, 0.771414],
        [0.893, 0.68955, 0.769938],
        [0.896, 0.693657, 0.768496],
        [0.899, 0.694948, 0.767055],
        [0.901, 0.699075, 0.765596],
        [0.904, 0.703227, 0.764188],
        [0.907, 0.707384, 0.762797],
        [0.909, 0.711545, 0.76139],
        [0.912, 0.715727, 0.759984],
        [0.915, 0.71991, 0.758576],
        [0.917, 0.724121, 0.757219],
        [0.92, 0.72833, 0.755836],
        [0.923, 0.732562, 0.754502],
        [0.925, 0.736799, 0.753135],
        [0.928, 0.741064, 0.751829],
        [0.931, 0.745326, 0.750462],
        [0.933, 0.749594, 0.749183],
        [0.936, 0.711574, 0.747864],
        [0.939, 0.715624, 0.746553],
        [0.941, 0.7197, 0.745255],
        [0.944, 0.723775, 0.743978],
        [0.947, 0.727874, 0.742702],
        [0.949, 0.731982, 0.741459],
        [0.952, 0.736107, 0.740199],
        [0.955, 0.740235, 0.738929],
        [0.957, 0.744369, 0.737709],
        [0.96, 0.716371, 0.736462],
        [0.963, 0.720367, 0.735261],
        [0.965, 0.724359, 0.73406],
        [0.968, 0.728359, 0.732835],
        [0.971, 0.732384, 0.731648],
        [0.973, 0.736406, 0.730475],
        [0.976, 0.740451, 0.729277],
        [0.979, 0.744499, 0.72812],
        [0.981, 0.748553, 0.726948],
        [0.984, 0.752627, 0.725826],
        [0.987, 0.756729, 0.72464],
        [0.989, 0.760811, 0.723499],
        [0.992, 0.764934, 0.722397],
        [0.995, 0.76904, 0.721285],
        [0.997, 0.753828, 0.720175],
        [1, 0.757869, 0.719079],
        [1.003, 0.761898, 0.717949],
        [1.005, 0.725546, 0.716884],
        [1.008, 0.729403, 0.715818],
        [1.011, 0.733265, 0.714754],
        [1.013, 0.737131, 0.713689],
        [1.016, 0.741022, 0.712632],
        [1.019, 0.74493, 0.711598],
        [1.021, 0.748821, 0.710558],
        [1.024, 0.752738, 0.709526],
        [1.027, 0.756677, 0.708465],
        [1.029, 0.760594, 0.70746],
        [1.032, 0.764541, 0.706454],
        [1.035, 0.768509, 0.705467],
        [1.037, 0.76468, 0.70449],
        [1.04, 0.768598, 0.70348],
        [1.043, 0.772564, 0.702523],
        [1.045, 0.776507, 0.701568],
        [1.048, 0.780474, 0.700608],
        [1.051, 0.784442, 0.699658],
        [1.053, 0.78844, 0.698706],
        [1.056, 0.792437, 0.69777],
        [1.059, 0.796436, 0.696849],
        [1.061, 0.800454, 0.695945],
        [1.064, 0.804482, 0.695016],
        [1.067, 0.808525, 0.694094],
        [1.069, 0.812575, 0.693191],
        [1.072, 0.816628, 0.692291],
        [1.075, 0.820703, 0.691412],
        [1.077, 0.824781, 0.690543],
        [1.08, 0.828859, 0.689668],
        [1.083, 0.804343, 0.68881],
        [1.085, 0.808316, 0.687962],
        [1.088, 0.812286, 0.687095],
        [1.091, 0.816279, 0.686256],
        [1.093, 0.820277, 0.68542],
        [1.096, 0.794073, 0.68461],
        [1.099, 0.797937, 0.683777],
        [1.101, 0.801822, 0.682961],
        [1.104, 0.805712, 0.682142],
        [1.107, 0.809606, 0.681323],
        [1.109, 0.813521, 0.680545],
        [1.112, 0.817432, 0.679764],
        [1.115, 0.821351, 0.678944],
        [1.117, 0.825292, 0.678175],
        [1.12, 0.829233, 0.677448],
        [1.123, 0.833178, 0.67669],
        [1.125, 0.837148, 0.675901],
        [1.128, 0.84112, 0.675155],
        [1.131, 0.845112, 0.674416],
        [1.133, 0.849086, 0.673699],
        [1.136, 0.817576, 0.672951],
        [1.139, 0.821436, 0.672221],
        [1.141, 0.825274, 0.67151],
        [1.144, 0.829141, 0.670794],
        [1.147, 0.833, 0.670101],
        [1.149, 0.83689, 0.669405],
        [1.152, 0.840778, 0.668716],
        [1.155, 0.844667, 0.668019],
        [1.157, 0.848585, 0.667357],
        [1.16, 0.852495, 0.666651],
        [1.163, 0.856415, 0.665991],
        [1.165, 0.860355, 0.665324],
        [1.168, 0.864299, 0.664669],
        [1.171, 0.868243, 0.664026],
        [1.173, 0.872213, 0.663378],
        [1.176, 0.876182, 0.66277],
        [1.179, 0.880151, 0.662111],
        [1.181, 0.884147, 0.661476],
        [1.184, 0.888147, 0.660843],
        [1.187, 0.892142, 0.66024],
        [1.189, 0.896162, 0.659648],
        [1.192, 0.900188, 0.659022],
        [1.195, 0.904212, 0.658436],
        [1.197, 0.85239, 0.65784],
        [1.2, 0.856198, 0.657249],
        [1.203, 0.860009, 0.656649],
        [1.205, 0.863816, 0.656121],
        [1.208, 0.867652, 0.655542],
        [1.211, 0.871485, 0.654973],
        [1.213, 0.780564, 0.654411],
        [1.216, 0.783999, 0.653842],
        [1.219, 0.787457, 0.65331],
        [1.221, 0.790893, 0.652742],
        [1.224, 0.794353, 0.652218],
        [1.227, 0.797809, 0.651676],
        [1.229, 0.801296, 0.651154],
        [1.232, 0.80476, 0.650649],
        [1.235, 0.808252, 0.650129],
        [1.237, 0.811763, 0.64961],
        [1.24, 0.81525, 0.6491],
        [1.243, 0.818765, 0.648603],
        [1.245, 0.822277, 0.648079],
        [1.248, 0.82582, 0.647645],
        [1.251, 0.829336, 0.647128],
        [1.253, 0.832872, 0.64664],
        [1.256, 0.83644, 0.646183],
        [1.259, 0.839982, 0.645692],
        [1.261, 0.843553, 0.645246],
        [1.264, 0.847119, 0.644798],
        [1.267, 0.850691, 0.644306],
        [1.269, 0.825656, 0.643859],
        [1.272, 0.829142, 0.643437],
        [1.275, 0.832607, 0.642963],
        [1.277, 0.836093, 0.642544],
        [1.28, 0.839604, 0.642123],
        [1.283, 0.843093, 0.641679],
        [1.285, 0.84661, 0.641239],
        [1.288, 0.850126, 0.64085],
        [1.291, 0.853641, 0.640451],
        [1.293, 0.857178, 0.640037],
        [1.296, 0.860724, 0.639599],
        [1.299, 0.864261, 0.639209],
        [1.301, 0.867826, 0.638814],
        [1.304, 0.871372, 0.638444],
        [1.307, 0.874938, 0.638028],
        [1.309, 0.87851, 0.637661],
        [1.312, 0.882103, 0.637271],
        [1.315, 0.885694, 0.636902],
        [1.317, 0.889291, 0.636523],
        [1.32, 0.892892, 0.636178],
        [1.323, 0.896505, 0.63581],
        [1.325, 0.900127, 0.63545],
        [1.328, 0.903753, 0.635101],
        [1.331, 0.907376, 0.634743],
        [1.333, 0.911023, 0.634451],
        [1.336, 0.914671, 0.634068],
        [1.339, 0.918322, 0.633738],
        [1.341, 0.921995, 0.633389],
        [1.344, 0.925646, 0.633077],
        [1.347, 0.929344, 0.632769],
        [1.349, 0.933018, 0.632462],
        [1.352, 0.936699, 0.632143],
        [1.355, 0.940397, 0.631839],
        [1.357, 0.944104, 0.6315],
        [1.36, 0.947828, 0.631195],
        [1.363, 0.951552, 0.630907],
        [1.365, 0.955285, 0.630616],
        [1.368, 0.959013, 0.630316],
        [1.371, 0.962746, 0.630045],
        [1.373, 0.966499, 0.629772],
        [1.376, 0.970257, 0.629509],
        [1.379, 0.974016, 0.629226],
        [1.381, 0.870115, 0.62894],
        [1.384, 0.873498, 0.628687],
        [1.387, 0.876851, 0.628408],
        [1.389, 0.880229, 0.62817],
        [1.392, 0.883607, 0.627912],
        [1.395, 0.887016, 0.627655],
        [1.397, 0.890398, 0.627396],
        [1.4, 0.893807, 0.627184],
        [1.403, 0.89721, 0.626918],
        [1.405, 0.900623, 0.626689],
        [1.408, 0.904052, 0.626452],
        [1.411, 0.907464, 0.626216],
        [1.413, 0.910894, 0.625999],
        [1.416, 0.914353, 0.625766],
        [1.419, 0.917792, 0.625559],
        [1.421, 0.921252, 0.625354],
        [1.424, 0.924709, 0.625143],
        [1.427, 0.928173, 0.624943],
        [1.429, 0.931637, 0.624731],
        [1.432, 0.935122, 0.624539],
        [1.435, 0.938611, 0.624338],
        [1.437, 0.9421, 0.624156],
        [1.44, 0.94561, 0.623948],
        [1.443, 0.949103, 0.623752],
        [1.445, 0.952617, 0.62358],
        [1.448, 0.956131, 0.623397],
        [1.451, 0.959667, 0.623224],
        [1.453, 0.963186, 0.62304],
        [1.456, 0.96673, 0.622872],
        [1.459, 0.970271, 0.622694],
        [1.461, 0.973836, 0.622544],
        [1.464, 0.977385, 0.622395],
        [1.467, 0.879021, 0.622196],
        [1.469, 0.882237, 0.622075],
        [1.472, 0.885431, 0.62192],
        [1.475, 0.888647, 0.621784],
        [1.477, 0.891868, 0.621644],
        [1.48, 0.895088, 0.621495],
        [1.483, 0.898308, 0.621346],
        [1.485, 0.901554, 0.621192],
        [1.488, 0.904775, 0.621079],
        [1.491, 0.908025, 0.620953],
        [1.493, 0.911291, 0.620853],
        [1.496, 0.914542, 0.620727],
        [1.499, 0.917812, 0.620583],
        [1.501, 0.921063, 0.620446],
        [1.504, 0.924361, 0.62036],
        [1.507, 0.927631, 0.620245],
        [1.509, 0.93091, 0.620123],
        [1.512, 0.934208, 0.620043],
        [1.515, 0.93751, 0.619925],
        [1.517, 0.940809, 0.619853],
        [1.52, 0.944111, 0.619757],
        [1.523, 0.947437, 0.619626],
        [1.525, 0.950764, 0.619528],
        [1.528, 0.954091, 0.619481],
        [1.531, 0.957417, 0.619381],
        [1.533, 0.960748, 0.61931],
        [1.536, 0.964099, 0.619236],
        [1.539, 0.967452, 0.619145],
        [1.541, 0.970807, 0.619075],
        [1.544, 0.97416, 0.61899],
        [1.547, 0.977543, 0.618938],
        [1.549, 0.980924, 0.618877],
        [1.552, 0.984279, 0.618808],
        [1.555, 0.987683, 0.618734],
        [1.557, 0.991069, 0.618687],
        [1.56, 0.994472, 0.61865],
        [1.563, 0.997853, 0.618583],
        [1.565, 1.00129, 0.618557],
        [1.568, 1.00469, 0.618491],
        [1.571, 1.00811, 0.618433],
        [1.573, 1.01154, 0.618396],
        [1.576, 1.01498, 0.618392],
        [1.579, 1.01841, 0.618354],
        [1.581, 1.02184, 0.618292],
        [1.584, 1.0253, 0.618247],
        [1.587, 1.02876, 0.618255],
        [1.589, 1.03222, 0.618238],
        [1.592, 1.03569, 0.618198],
        [1.595, 1.03915, 0.618167],
        [1.597, 1.04264, 0.61817],
        [1.6, 1.04612, 0.618134],
        [1.603, 1.04961, 0.61814],
        [1.605, 0.90934, 0.618121],
        [1.608, 0.912373, 0.618116],
        [1.611, 0.915401, 0.6181],
        [1.613, 0.918438, 0.618105],
        [1.616, 0.921471, 0.618094],
        [1.619, 0.924503, 0.618105],
        [1.621, 0.927561, 0.618112],
        [1.624, 0.930623, 0.618127],
        [1.627, 0.933677, 0.618107],
        [1.629, 0.936738, 0.618125],
        [1.632, 0.939802, 0.618187],
        [1.635, 0.942881, 0.618169],
        [1.637, 0.945948, 0.618193],
        [1.64, 0.94903, 0.618221],
        [1.643, 0.952119, 0.618233],
        [1.645, 0.955227, 0.618257],
        [1.648, 0.800063, 0.618304],
        [1.651, 0.802644, 0.618321],
        [1.653, 0.805245, 0.618341],
        [1.656, 0.807849, 0.618379],
        [1.659, 0.810452, 0.618418],
        [1.661, 0.813054, 0.618477],
        [1.664, 0.81566, 0.618496],
        [1.667, 0.818289, 0.618535],
        [1.669, 0.820896, 0.618576],
        [1.672, 0.823522, 0.618612],
        [1.675, 0.826151, 0.618701],
        [1.677, 0.828784, 0.618744],
        [1.68, 0.831438, 0.618782],
        [1.683, 0.83407, 0.618842],
        [1.685, 0.836724, 0.618914],
        [1.688, 0.83936, 0.61897],
        [1.691, 0.842017, 0.619024],
        [1.693, 0.844675, 0.619107],
        [1.696, 0.847332, 0.619151],
        [1.699, 0.850012, 0.619213],
        [1.701, 0.852669, 0.619299],
        [1.704, 0.855353, 0.61937],
        [1.707, 0.858036, 0.619461],
        [1.709, 0.860718, 0.619527],
        [1.712, 0.863402, 0.619575],
        [1.715, 0.86609, 0.619693],
        [1.717, 0.868799, 0.619764],
        [1.72, 0.871482, 0.619846],
        [1.723, 0.87419, 0.619942],
        [1.725, 0.876904, 0.620033],
        [1.728, 0.879616, 0.620097],
        [1.731, 0.882324, 0.620212],
        [1.733, 0.885059, 0.620306],
        [1.736, 0.887776, 0.620402],
        [1.739, 0.89051, 0.620492],
        [1.741, 0.893249, 0.620591],
        [1.744, 0.895983, 0.620709],
        [1.747, 0.898726, 0.620809],
        [1.749, 0.90146, 0.6209],
        [1.752, 0.904224, 0.621014],
        [1.755, 0.906962, 0.621111],
        [1.757, 0.90973, 0.621248],
        [1.76, 0.91249, 0.621344],
        [1.763, 0.915258, 0.621482],
        [1.765, 0.918044, 0.621562],
        [1.768, 0.920807, 0.621707],
        [1.771, 0.923601, 0.621832],
        [1.773, 0.926369, 0.621944],
        [1.776, 0.929157, 0.622085],
        [1.779, 0.931947, 0.622188],
        [1.781, 0.934741, 0.622329],
        [1.784, 0.937556, 0.622446],
        [1.787, 0.940354, 0.622574],
        [1.789, 0.943164, 0.622718],
        [1.792, 0.945983, 0.62286],
        [1.795, 0.894832, 0.62298],
        [1.797, 0.897489, 0.623126],
        [1.8, 0.900147, 0.623255],
        [1.803, 0.902805, 0.623422],
        [1.805, 0.905493, 0.623546],
        [1.808, 0.908175, 0.623713],
        [1.811, 0.910858, 0.623838],
        [1.813, 0.913541, 0.624002],
        [1.816, 0.916224, 0.624128],
        [1.819, 0.918911, 0.6243],
        [1.821, 0.921616, 0.624421],
        [1.824, 0.924308, 0.62459],
        [1.827, 0.927015, 0.624757],
        [1.829, 0.929724, 0.62492],
        [1.832, 0.932436, 0.625069],
        [1.835, 0.935149, 0.625235],
        [1.837, 0.937883, 0.625414],
        [1.84, 0.940595, 0.625559],
        [1.843, 0.943334, 0.625725],
        [1.845, 0.946067, 0.625901],
        [1.848, 0.948807, 0.626073],
        [1.851, 0.951544, 0.626249],
        [1.853, 0.954282, 0.626402],
        [1.856, 0.957024, 0.626578],
        [1.859, 0.959783, 0.62677],
        [1.861, 0.962547, 0.626945],
        [1.864, 0.96529, 0.627121],
        [1.867, 0.968053, 0.627295],
        [1.869, 0.970821, 0.627496],
        [1.872, 0.973605, 0.627641],
        [1.875, 0.976373, 0.627866],
        [1.877, 0.979163, 0.628018],
        [1.88, 0.981929, 0.628231],
        [1.883, 0.98472, 0.628389],
        [1.885, 0.987513, 0.628595],
        [1.888, 0.990302, 0.628797],
        [1.891, 0.993116, 0.628992],
        [1.893, 0.99591, 0.629167],
        [1.896, 0.998729, 0.629367],
        [1.899, 1.00155, 0.62957],
        [1.901, 1.00434, 0.629784],
        [1.904, 1.00718, 0.629991],
        [1.907, 1.01, 0.630162],
        [1.909, 1.01282, 0.630369],
        [1.912, 1.01566, 0.630578],
        [1.915, 1.01848, 0.630779],
        [1.917, 1.02133, 0.63102],
        [1.92, 1.02417, 0.631206],
        [1.923, 1.02701, 0.631418],
        [1.925, 1.02986, 0.631628],
        [1.928, 1.03273, 0.631848],
        [1.931, 1.03558, 0.632053],
        [1.933, 1.03845, 0.632258],
        [1.936, 1.04132, 0.6325],
        [1.939, 1.04417, 0.632679],
        [1.941, 1.04706, 0.632938],
        [1.944, 1.04993, 0.633145],
        [1.947, 1.05281, 0.63339],
        [1.949, 1.05571, 0.633621],
        [1.952, 1.05858, 0.633813],
        [1.955, 1.06148, 0.634041],
        [1.957, 1.06438, 0.63428],
        [1.96, 1.06728, 0.634524],
        [1.963, 1.0702, 0.634728],
        [1.965, 1.0731, 0.634958],
        [1.968, 1.07602, 0.635189],
        [1.971, 1.07892, 0.635422],
        [1.973, 1.08185, 0.635667],
        [1.976, 1.08478, 0.635916],
        [1.979, 1.08772, 0.636155],
        [1.981, 1.09065, 0.636396],
        [1.984, 1.09358, 0.636605],
        [1.987, 1.09653, 0.636847],
        [1.989, 1.09948, 0.637139],
        [1.992, 1.10243, 0.637344],
        [1.995, 1.10539, 0.637617],
        [1.997, 1.10834, 0.637858],
        [2, 1.11129, 0.638079],
        [2.003, 1.11427, 0.638355],
        [2.005, 1.11722, 0.638597],
        [2.008, 1.1202, 0.638847],
        [2.011, 1.12318, 0.639098],
        [2.013, 1.12616, 0.639353],
        [2.016, 1.12914, 0.639626],
        [2.019, 1.13214, 0.639858],
        [2.021, 1.13512, 0.640117],
        [2.024, 1.13813, 0.640365],
        [2.027, 1.14113, 0.640656],
        [2.029, 1.14414, 0.640884],
        [2.032, 1.14714, 0.64116],
        [2.035, 1.15015, 0.641424],
        [2.037, 1.15316, 0.641677],
        [2.04, 1.15619, 0.641977],
        [2.043, 1.15922, 0.642214],
        [2.045, 1.16223, 0.642489],
        [2.048, 1.16527, 0.642767],
        [2.051, 1.16832, 0.643025],
        [2.053, 1.17135, 0.64331],
        [2.056, 1.17439, 0.643565],
        [2.059, 1.17745, 0.643845],
        [2.061, 1.18051, 0.644122],
        [2.064, 1.18356, 0.644402],
        [2.067, 1.18662, 0.644661],
        [2.069, 1.18969, 0.644943],
        [2.072, 1.0737, 0.645221],
        [2.075, 1.07646, 0.645509],
        [2.077, 1.07923, 0.645782],
        [2.08, 1.082, 0.646085],
        [2.083, 1.08479, 0.646351],
        [2.085, 1.08755, 0.646632],
        [2.088, 1.09034, 0.646934],
        [2.091, 1.09313, 0.647199],
        [2.093, 1.09593, 0.647482],
        [2.096, 1.09871, 0.647784],
        [2.099, 1.10151, 0.648042],
        [2.101, 1.10431, 0.6484],
        [2.104, 1.10712, 0.648674],
        [2.107, 1.10991, 0.648938],
        [2.109, 1.11273, 0.649238],
        [2.112, 1.11555, 0.649531],
        [2.115, 1.11837, 0.649813],
        [2.117, 1.12119, 0.650143],
        [2.12, 1.12403, 0.650426],
        [2.123, 1.12685, 0.650734],
        [2.125, 1.12969, 0.65102],
        [2.128, 1.13251, 0.651302],
        [2.131, 1.13535, 0.65165],
        [2.133, 1.1382, 0.651921],
        [2.136, 1.14104, 0.652223],
        [2.139, 1.14389, 0.652561],
        [2.141, 1.14676, 0.652826],
        [2.144, 1.14961, 0.653153],
        [2.147, 1.15248, 0.653486],
        [2.149, 1.15533, 0.653763],
        [2.152, 1.1582, 0.654048],
        [2.155, 1.16107, 0.654383],
        [2.157, 1.16396, 0.654686],
        [2.16, 1.16683, 0.655003],
        [2.163, 1.16971, 0.655334],
        [2.165, 0.757767, 0.655617],
        [2.168, 0.759646, 0.65594],
        [2.171, 0.761522, 0.65625],
        [2.173, 0.763381, 0.656591],
        [2.176, 0.765255, 0.656909],
        [2.179, 0.767136, 0.657214],
        [2.181, 0.769015, 0.657527],
        [2.184, 0.770895, 0.657836],
        [2.187, 0.772773, 0.658189],
        [2.189, 0.774676, 0.658503],
        [2.192, 0.776554, 0.658817],
        [2.195, 0.778439, 0.659154],
        [2.197, 0.780339, 0.659488],
        [2.2, 0.782245, 0.659775],
        [2.203, 0.784129, 0.660133],
        [2.205, 0.786032, 0.660467],
        [2.208, 0.787938, 0.660751],
        [2.211, 0.789845, 0.661107],
        [2.213, 0.791748, 0.661424],
        [2.216, 0.793658, 0.661777],
        [2.219, 0.795564, 0.662091],
        [2.221, 0.797468, 0.662425],
        [2.224, 0.799399, 0.662766],
        [2.227, 0.801308, 0.663101],
        [2.229, 0.803237, 0.663435],
        [2.232, 0.805147, 0.663765],
        [2.235, 0.807079, 0.664126],
        [2.237, 0.809013, 0.664457],
        [2.24, 0.810944, 0.664757],
        [2.243, 0.812874, 0.665113],
        [2.245, 0.814809, 0.665465],
        [2.248, 0.816743, 0.665804],
        [2.251, 0.818678, 0.66612],
        [2.253, 0.820634, 0.666475],
        [2.256, 0.822569, 0.666818],
        [2.259, 0.824499, 0.667183],
        [2.261, 0.826459, 0.667518],
        [2.264, 0.828415, 0.667853],
        [2.267, 0.830354, 0.668209],
        [2.269, 0.832314, 0.668567],
        [2.272, 0.834271, 0.668907],
        [2.275, 0.836231, 0.669246],
        [2.277, 0.838192, 0.669606],
        [2.28, 0.840152, 0.66997],
        [2.283, 0.842137, 0.67029],
        [2.285, 0.844097, 0.67065],
        [2.288, 0.846058, 0.671027],
        [2.291, 0.848043, 0.671365],
        [2.293, 0.850004, 0.671708],
        [2.296, 0.851989, 0.672069],
        [2.299, 0.853975, 0.672425],
        [2.301, 0.85596, 0.672789],
        [2.304, 0.857946, 0.673149],
        [2.307, 0.859932, 0.673488],
        [2.309, 0.861922, 0.673856],
        [2.312, 0.863911, 0.674213],
        [2.315, 0.865897, 0.6746],
        [2.317, 0.867904, 0.674947],
        [2.32, 0.869894, 0.675307],
        [2.323, 0.871904, 0.675641],
        [2.325, 0.8739, 0.676022],
        [2.328, 0.875911, 0.676368],
        [2.331, 0.877921, 0.676755],
        [2.333, 0.879932, 0.677111],
        [2.336, 0.881944, 0.677502],
        [2.339, 0.88396, 0.67787],
        [2.341, 0.885975, 0.678188],
        [2.344, 0.887986, 0.678599],
        [2.347, 0.890005, 0.678964],
        [2.349, 0.892042, 0.679323],
        [2.352, 0.894053, 0.679687],
        [2.355, 0.896094, 0.680074],
        [2.357, 0.89811, 0.680459],
        [2.36, 0.900146, 0.680822],
        [2.363, 0.902191, 0.681186],
        [2.365, 0.904227, 0.68156],
        [2.368, 0.906264, 0.68192],
        [2.371, 0.908309, 0.682283],
        [2.373, 0.910349, 0.682715],
        [2.376, 0.912391, 0.683084],
        [2.379, 0.914453, 0.683422],
        [2.381, 0.916498, 0.683811],
        [2.384, 0.91856, 0.684193],
        [2.387, 0.920606, 0.684588],
        [2.389, 0.922671, 0.684972],
        [2.392, 0.924738, 0.685309],
        [2.395, 0.9268, 0.685736],
        [2.397, 0.928871, 0.686095],
        [2.4, 0.930936, 0.686479],
        [2.403, 0.933004, 0.68687],
        [2.405, 0.935069, 0.68726],
        [2.408, 0.93714, 0.687623],
        [2.411, 0.93921, 0.688012],
        [2.413, 0.941298, 0.688381],
        [2.416, 0.943372, 0.688818],
        [2.419, 0.945464, 0.689198],
        [2.421, 0.947552, 0.68955],
        [2.424, 0.949648, 0.689941],
        [2.427, 0.951722, 0.690351],
        [2.429, 0.95381, 0.690744],
        [2.432, 0.955906, 0.691134],
        [2.435, 0.958024, 0.6915],
        [2.437, 0.960115, 0.691914],
        [2.44, 0.962211, 0.692305],
        [2.443, 0.964332, 0.692714],
        [2.445, 0.966428, 0.693085],
        [2.448, 0.968546, 0.693473],
        [2.451, 0.970641, 0.693865],
        [2.453, 0.972763, 0.694259],
        [2.456, 0.97488, 0.694652],
        [2.459, 0.977002, 0.695086],
        [2.461, 0.979124, 0.695474],
        [2.464, 0.981246, 0.695849],
        [2.467, 0.983361, 0.696235],
        [2.469, 0.985487, 0.696642],
        [2.472, 0.987608, 0.69708],
        [2.475, 0.989752, 0.697472],
        [2.477, 0.991877, 0.69786],
        [2.48, 0.994023, 0.698265],
        [2.483, 0.996167, 0.698649],
        [2.485, 0.998292, 0.699068],
        [2.488, 1.00044, 0.69948],
        [2.491, 1.00259, 0.699871],
        [2.493, 1.00473, 0.700288],
        [2.496, 1.00688, 0.700676],
        [2.499, 1.00903, 0.701079],
        [2.501, 1.0112, 0.701482],
        [2.504, 1.01335, 0.701916],
        [2.507, 1.01552, 0.702319],
        [2.509, 1.01767, 0.702709],
        [2.512, 1.01984, 0.703106],
        [2.515, 1.022, 0.703547],
        [2.517, 1.02417, 0.703959],
        [2.52, 1.02635, 0.704355],
        [2.523, 1.02852, 0.70476],
        [2.525, 1.03069, 0.705159],
        [2.528, 1.03287, 0.705595],
        [2.531, 1.03504, 0.705992],
        [2.533, 1.03724, 0.706403],
        [2.536, 1.03942, 0.706833],
        [2.539, 0.688699, 0.707242],
        [2.541, 0.690155, 0.70766],
        [2.544, 0.691605, 0.708074],
        [2.547, 0.693052, 0.70847],
        [2.549, 0.694502, 0.708883],
        [2.552, 0.695953, 0.709329],
        [2.555, 0.697403, 0.709736],
        [2.557, 0.698875, 0.710157],
        [2.56, 0.700325, 0.71057],
        [2.563, 0.701779, 0.71097],
        [2.565, 0.703252, 0.711412],
        [2.568, 0.704707, 0.711825],
        [2.571, 0.706179, 0.712271],
        [2.573, 0.707634, 0.712663],
        [2.576, 0.709106, 0.713099],
        [2.579, 0.710581, 0.713513],
        [2.581, 0.712057, 0.713915],
        [2.584, 0.713513, 0.714329],
        [2.587, 0.714988, 0.714774],
        [2.589, 0.716464, 0.715208],
        [2.592, 0.71794, 0.715631],
        [2.595, 0.719416, 0.716057],
        [2.597, 0.720897, 0.716467],
        [2.6, 0.722394, 0.716895],
        [2.603, 0.723871, 0.717347],
        [2.605, 0.725346, 0.71777],
        [2.608, 0.726831, 0.718188],
        [2.611, 0.728329, 0.718611],
        [2.613, 0.729808, 0.719051],
        [2.616, 0.73131, 0.719487],
        [2.619, 0.73279, 0.719906],
        [2.621, 0.734288, 0.720327],
        [2.624, 0.735789, 0.720749],
        [2.627, 0.737274, 0.721173],
        [2.629, 0.738775, 0.721655],
        [2.632, 0.740276, 0.722069],
        [2.635, 0.741783, 0.722488],
        [2.637, 0.743284, 0.722911],
        [2.64, 0.74479, 0.723333],
        [2.643, 0.746291, 0.72379],
        [2.645, 0.747793, 0.724239],
        [2.648, 0.749303, 0.724667],
        [2.651, 0.750804, 0.72508],
        [2.653, 0.752327, 0.725529],
        [2.656, 0.753836, 0.725965],
        [2.659, 0.755338, 0.72641],
        [2.661, 0.75687, 0.726827],
        [2.664, 0.758374, 0.727267],
        [2.667, 0.759906, 0.727699],
        [2.669, 0.76143, 0.728154],
        [2.672, 0.762939, 0.728595],
        [2.675, 0.764466, 0.729039],
        [2.677, 0.765998, 0.729488],
        [2.68, 0.767528, 0.729915],
        [2.683, 0.76906, 0.730333],
        [2.685, 0.770587, 0.730813],
        [2.688, 0.772118, 0.731235],
        [2.691, 0.773649, 0.731688],
        [2.693, 0.77518, 0.732123],
        [2.696, 0.776711, 0.732545],
        [2.699, 0.778243, 0.733019],
        [2.701, 0.779794, 0.733473],
        [2.704, 0.78133, 0.733878],
        [2.707, 0.782879, 0.734327],
        [2.709, 0.784414, 0.734771],
        [2.712, 0.785972, 0.735215],
        [2.715, 0.787501, 0.735698],
        [2.717, 0.789059, 0.736146],
        [2.72, 0.790616, 0.736568],
        [2.723, 0.792146, 0.737015],
        [2.725, 0.793707, 0.737456],
        [2.728, 0.795259, 0.737931],
        [2.731, 0.796816, 0.738371],
        [2.733, 0.798377, 0.738815],
        [2.736, 0.799929, 0.739271],
        [2.739, 0.80149, 0.739704],
        [2.741, 0.803052, 0.740151],
        [2.744, 0.804604, 0.740644],
        [2.747, 0.806186, 0.741083],
        [2.749, 0.807747, 0.741527],
        [2.752, 0.809307, 0.741957],
        [2.755, 0.810885, 0.742396],
        [2.757, 0.812446, 0.742887],
        [2.76, 0.814028, 0.743336],
        [2.763, 0.815612, 0.74378],
        [2.765, 0.81717, 0.744234],
        [2.768, 0.818754, 0.744699],
        [2.771, 0.820336, 0.745164],
        [2.773, 0.821922, 0.74563],
        [2.776, 0.823505, 0.746078],
        [2.779, 0.825086, 0.746504],
        [2.781, 0.826672, 0.746948],
        [2.784, 0.828255, 0.747422],
        [2.787, 0.829842, 0.747886],
        [2.789, 0.831427, 0.748356],
        [2.792, 0.833009, 0.748806],
        [2.795, 0.834595, 0.74927],
        [2.797, 0.836203, 0.749718],
        [2.8, 0.837789, 0.750188],
        [2.803, 0.839397, 0.750658],
        [2.805, 0.840984, 0.751102],
        [2.808, 0.842596, 0.751553],
        [2.811, 0.844182, 0.752018],
        [2.813, 0.845794, 0.752493],
        [2.816, 0.847402, 0.75296],
        [2.819, 0.849008, 0.753405],
        [2.821, 0.850616, 0.753881],
        [2.824, 0.852206, 0.754353],
        [2.827, 0.853818, 0.754791],
        [2.829, 0.85543, 0.755284],
        [2.832, 0.857063, 0.755732],
        [2.835, 0.858674, 0.756189],
        [2.837, 0.860286, 0.756652],
        [2.84, 0.861898, 0.757118],
        [2.843, 0.86351, 0.757593],
        [2.845, 0.865143, 0.758059],
        [2.848, 0.866759, 0.758509],
        [2.851, 0.868392, 0.758984],
        [2.853, 0.870007, 0.759457],
        [2.856, 0.871641, 0.759943],
        [2.859, 0.873283, 0.760418],
        [2.861, 0.874895, 0.760864],
        [2.864, 0.876532, 0.761335],
        [2.867, 0.87817, 0.76178],
        [2.869, 0.879806, 0.762234],
        [2.872, 0.881444, 0.762743],
        [2.875, 0.88308, 0.76322],
        [2.877, 0.884718, 0.763699],
        [2.88, 0.886355, 0.764141],
        [2.883, 0.887992, 0.764615],
        [2.885, 0.889634, 0.765106],
        [2.888, 0.891275, 0.765575],
        [2.891, 0.892934, 0.766048],
        [2.893, 0.894571, 0.766517],
        [2.896, 0.896233, 0.766995],
        [2.899, 0.897874, 0.767456],
        [2.901, 0.899539, 0.767925],
        [2.904, 0.901179, 0.768408],
        [2.907, 0.902842, 0.768877],
        [2.909, 0.904504, 0.769358],
        [2.912, 0.906172, 0.769822],
        [2.915, 0.907813, 0.770311],
        [2.917, 0.909475, 0.770788],
        [2.92, 0.911138, 0.77126],
        [2.923, 0.912805, 0.771736],
        [2.925, 0.914469, 0.772221],
        [2.928, 0.916135, 0.772712],
        [2.931, 0.917819, 0.77319],
        [2.933, 0.919486, 0.773646],
        [2.936, 0.921153, 0.774125],
        [2.939, 0.922841, 0.774597],
        [2.941, 0.924508, 0.775083],
        [2.944, 0.926175, 0.775574],
        [2.947, 0.927862, 0.776051],
        [2.949, 0.929555, 0.776524],
        [2.952, 0.931222, 0.777002],
        [2.955, 0.932909, 0.77747],
        [2.957, 0.934603, 0.77796],
        [2.96, 0.93627, 0.778444],
        [2.963, 0.937962, 0.778935],
        [2.965, 0.939651, 0.779431],
        [2.968, 0.941342, 0.779907],
        [2.971, 0.943035, 0.780401],
        [2.973, 0.944723, 0.780844],
        [2.976, 0.94642, 0.781321],
        [2.979, 0.948133, 0.781798],
        [2.981, 0.949826, 0.782316],
        [2.984, 0.951518, 0.78281],
        [2.987, 0.953231, 0.783279],
        [2.989, 0.954928, 0.783767],
        [2.992, 0.956641, 0.784256],
        [2.995, 0.958338, 0.78473],
        [2.997, 0.960051, 0.785206],
        [3, 0.961748, 0.785728],
        [3.003, 0.963461, 0.786222],
        [3.005, 0.96518, 0.786695],
        [3.008, 0.966897, 0.787168],
        [3.011, 0.968595, 0.787659],
        [3.013, 0.970313, 0.788153],
        [3.016, 0.97203, 0.788615],
        [3.019, 0.973752, 0.789109],
        [3.021, 0.975487, 0.789607],
        [3.024, 0.97721, 0.790098],
        [3.027, 0.978926, 0.790601],
        [3.029, 0.980648, 0.791074],
        [3.032, 0.982393, 0.791568],
        [3.035, 0.984109, 0.792042],
        [3.037, 0.985832, 0.792545],
        [3.04, 0.987576, 0.793041],
        [3.043, 0.989293, 0.793552],
        [3.045, 0.991037, 0.794036],
        [3.048, 0.992784, 0.794534],
        [3.051, 0.994523, 0.795011],
        [3.053, 0.996249, 0.795506],
        [3.056, 0.997993, 0.796007],
        [3.059, 0.999736, 0.796498],
        [3.061, 1.00148, 0.796998],
        [3.064, 1.00323, 0.797491],
        [3.067, 1.00497, 0.797947],
        [3.069, 1.00672, 0.798463],
        [3.072, 1.00846, 0.798967],
        [3.075, 1.01023, 0.799441],
        [3.077, 1.01198, 0.799944],
        [3.08, 1.01372, 0.80042],
        [3.083, 1.01549, 0.800937],
        [3.085, 1.01724, 0.801457],
        [3.088, 1.01901, 0.801929],
        [3.091, 1.02076, 0.802424],
        [3.093, 1.02253, 0.802921],
        [3.096, 1.0243, 0.803403],
        [3.099, 1.02605, 0.803919],
        [3.101, 1.02782, 0.804424],
        [3.104, 1.02959, 0.804941],
        [3.107, 1.03136, 0.805421],
        [3.109, 1.03313, 0.805923],
        [3.112, 1.03491, 0.806442],
        [3.115, 1.03668, 0.806933],
        [3.117, 1.03845, 0.807415],
        [3.12, 1.04023, 0.807905],
        [3.123, 1.04202, 0.808386],
        [3.125, 1.04379, 0.808906],
        [3.128, 1.04557, 0.809427],
        [3.131, 1.04736, 0.809909],
        [3.133, 1.04914, 0.810408],
        [3.136, 1.05093, 0.810907],
        [3.139, 1.05271, 0.81141],
        [3.141, 1.05451, 0.811926],
        [3.144, 1.0563, 0.812427],
        [3.147, 1.0581, 0.812952],
        [3.149, 1.05988, 0.813425],
        [3.152, 1.06167, 0.813928],
        [3.155, 1.06347, 0.814442],
        [3.157, 1.06527, 0.814951],
        [3.16, 1.06707, 0.81544],
        [3.163, 1.06887, 0.815943],
        [3.165, 1.07069, 0.816442],
        [3.168, 1.07249, 0.816942],
        [3.171, 1.07429, 0.817486],
        [3.173, 1.07609, 0.817989],
        [3.176, 1.07791, 0.818484],
        [3.179, 1.07971, 0.818982],
        [3.181, 1.08154, 0.819488],
        [3.184, 1.08335, 0.820005],
        [3.187, 1.08517, 0.820514],
        [3.189, 1.08699, 0.821015],
        [3.192, 1.08879, 0.821511],
        [3.195, 1.09062, 0.822013],
        [3.197, 1.09244, 0.822537],
        [3.2, 1.09426, 0.823031],
        [3.203, 1.09609, 0.823558],
        [3.205, 1.09792, 0.824059],
        [3.208, 1.09974, 0.824556],
        [3.211, 1.10157, 0.825063],
        [3.213, 1.10339, 0.825579],
        [3.216, 1.10522, 0.826113],
        [3.219, 1.10707, 0.826608],
        [3.221, 1.1089, 0.827112],
        [3.224, 1.11073, 0.82762],
        [3.227, 1.11258, 0.828143],
        [3.229, 1.1144, 0.828646],
        [3.232, 1.11626, 0.829145],
        [3.235, 1.11811, 0.82965],
        [3.237, 1.11993, 0.830167],
        [3.24, 1.12179, 0.830712],
        [3.243, 1.12364, 0.831221],
        [3.245, 1.12549, 0.831718],
        [3.248, 1.12734, 0.832247],
        [3.251, 1.1292, 0.832745],
        [3.253, 1.13105, 0.833248],
        [3.256, 1.1329, 0.833768],
        [3.259, 1.13476, 0.834291],
        [3.261, 1.13661, 0.834791],
        [3.264, 1.13846, 0.835317],
        [3.267, 1.14034, 0.835839],
        [3.269, 1.14219, 0.836363],
        [3.272, 1.14407, 0.836865],
        [3.275, 1.14593, 0.837393],
        [3.277, 1.1478, 0.837888],
        [3.28, 1.14966, 0.838399],
        [3.283, 1.15153, 0.838915],
        [3.285, 1.15341, 0.839447],
        [3.288, 1.15527, 0.839916],
        [3.291, 1.15714, 0.840464],
        [3.293, 1.15903, 0.840968],
        [3.296, 1.1609, 0.841491],
        [3.299, 1.16279, 0.842016],
        [3.301, 1.16466, 0.842523],
        [3.304, 1.16654, 0.843039],
        [3.307, 1.16842, 0.843549],
        [3.309, 1.17032, 0.844072],
        [3.312, 1.17221, 0.844597],
        [3.315, 1.17408, 0.845142],
        [3.317, 1.17599, 0.845641],
        [3.32, 1.17787, 0.846173],
        [3.323, 1.17975, 0.846677],
        [3.325, 1.18166, 0.847202],
        [3.328, 1.18356, 0.84773],
        [3.331, 1.18544, 0.848254],
        [3.333, 1.18735, 0.848757],
        [3.336, 1.18925, 0.849281],
        [3.339, 1.19116, 0.849787],
        [3.341, 1.19307, 0.85035],
        [3.344, 1.19497, 0.850852],
        [3.347, 1.19687, 0.851379],
        [3.349, 1.19878, 0.8519],
        [3.352, 1.20069, 0.852401],
        [3.355, 1.2026, 0.852952],
        [3.357, 1.20451, 0.853455],
        [3.36, 1.20641, 0.853987],
        [3.363, 1.20834, 0.854503],
        [3.365, 1.21025, 0.855007],
        [3.368, 1.21218, 0.855558],
        [3.371, 1.21409, 0.856099],
        [3.373, 1.21602, 0.856604],
        [3.376, 1.21793, 0.857129],
        [3.379, 1.21986, 0.857649],
        [3.381, 1.22179, 0.85816],
        [3.384, 1.22373, 0.858706],
        [3.387, 1.22566, 0.859229],
        [3.389, 1.22759, 0.859745],
        [3.392, 1.2295, 0.860264],
        [3.395, 1.23146, 0.860793],
        [3.397, 1.23339, 0.861343],
        [3.4, 1.23532, 0.861863],
        [3.403, 1.23726, 0.862394],
        [3.405, 1.23919, 0.862914],
        [3.408, 1.24115, 0.863419],
        [3.411, 1.24308, 0.863947],
        [3.413, 1.24502, 0.864494],
        [3.416, 1.24698, 0.865021],
        [3.419, 1.24891, 0.86555],
        [3.421, 1.25087, 0.866044],
        [3.424, 1.25283, 0.866601],
        [3.427, 1.25476, 0.867147],
        [3.429, 1.25672, 0.867671],
        [3.432, 1.25868, 0.868203],
        [3.435, 1.26064, 0.868723],
        [3.437, 1.2626, 0.86923],
        [3.44, 1.26456, 0.869787],
        [3.443, 1.26652, 0.870309],
        [3.445, 1.26848, 0.870832],
        [3.448, 1.27044, 0.871364],
        [3.451, 1.27241, 0.871888],
        [3.453, 1.27439, 0.872433],
        [3.456, 1.27635, 0.872962],
        [3.459, 1.27831, 0.873484],
        [3.461, 1.28029, 0.874016],
        [3.464, 1.28226, 0.874541],
        [3.467, 1.28424, 0.875067],
        [3.469, 1.2862, 0.875623],
        [3.472, 1.28819, 0.876152],
        [3.475, 1.29017, 0.876675],
        [3.477, 1.29216, 0.877206],
        [3.48, 1.29413, 0.877726],
        [3.483, 1.29611, 0.878297],
        [3.485, 1.2981, 0.878825],
        [3.488, 1.30009, 0.879351],
        [3.491, 1.30207, 0.879875],
        [3.493, 1.30408, 0.880406],
        [3.496, 1.30607, 0.880932],
        [3.499, 1.30806, 0.881486],
        [3.501, 1.31004, 0.882012],
        [3.504, 1.31205, 0.882543],
        [3.507, 1.31404, 0.883073],
        [3.509, 1.31605, 0.883595],
        [3.512, 1.31805, 0.884144],
        [3.515, 1.32006, 0.884688],
        [3.517, 1.32205, 0.885222],
        [3.52, 1.32406, 0.885752],
        [3.523, 1.32607, 0.886272],
        [3.525, 1.32808, 0.886852],
        [3.528, 1.33008, 0.887376],
        [3.531, 1.33209, 0.887904],
        [3.533, 1.3341, 0.888436],
        [3.536, 1.33612, 0.888963],
        [3.539, 1.33813, 0.889483],
        [3.541, 1.34017, 0.890041],
        [3.544, 1.34218, 0.890593],
        [3.547, 1.34419, 0.891116],
        [3.549, 1.34621, 0.891663],
        [3.552, 1.34825, 0.892186],
        [3.555, 1.35026, 0.892749],
        [3.557, 1.3523, 0.893281],
        [3.56, 1.35432, 0.893801],
        [3.563, 1.35636, 0.894355],
        [3.565, 1.35837, 0.894887],
        [3.568, 1.36041, 0.895432],
        [3.571, 1.36245, 0.895961],
        [3.573, 1.36449, 0.89649],
        [3.576, 1.36653, 0.897057],
        [3.579, 1.36857, 0.897588],
        [3.581, 1.37061, 0.898117],
        [3.584, 1.37265, 0.898676],
        [3.587, 1.37469, 0.899225],
        [3.589, 0.840553, 0.899744],
        [3.592, 0.841791, 0.900276],
        [3.595, 0.843051, 0.900804],
        [3.597, 0.844289, 0.90137],
        [3.6, 0.845549, 0.901907],
        [3.603, 0.846809, 0.902443],
        [3.605, 0.848051, 0.902987],
        [3.608, 0.849311, 0.903519],
        [3.611, 0.850571, 0.904094],
        [3.613, 0.851831, 0.904618],
        [3.616, 0.853094, 0.905171],
        [3.619, 0.854332, 0.905703],
        [3.621, 0.855593, 0.906236],
        [3.624, 0.856856, 0.906786],
        [3.627, 0.858116, 0.907331],
        [3.629, 0.85938, 0.907879],
        [3.632, 0.860643, 0.908406],
        [3.635, 0.861903, 0.908934],
        [3.637, 0.863189, 0.909493],
        [3.64, 0.864452, 0.910054],
        [3.643, 0.865712, 0.910604],
        [3.645, 0.866976, 0.911153],
        [3.648, 0.868239, 0.911676],
        [3.651, 0.869525, 0.91223],
        [3.653, 0.870788, 0.912783],
        [3.656, 0.872052, 0.913333],
        [3.659, 0.873337, 0.91386],
        [3.661, 0.874601, 0.914392],
        [3.664, 0.875886, 0.914937],
        [3.667, 0.877155, 0.915468],
        [3.669, 0.87844, 0.916048],
        [3.672, 0.879704, 0.916576],
        [3.675, 0.880989, 0.917134],
        [3.677, 0.882278, 0.917684],
        [3.68, 0.883542, 0.918232],
        [3.683, 0.884827, 0.918784],
        [3.685, 0.886116, 0.919335],
        [3.688, 0.887401, 0.919867],
        [3.691, 0.888673, 0.920423],
        [3.693, 0.889959, 0.920947],
        [3.696, 0.891248, 0.921528],
        [3.699, 0.892534, 0.922058],
        [3.701, 0.893822, 0.922608],
        [3.704, 0.895111, 0.923139],
        [3.707, 0.896402, 0.923716],
        [3.709, 0.897691, 0.924242],
        [3.712, 0.89898, 0.924813],
        [3.715, 0.900269, 0.925367],
        [3.717, 0.901557, 0.925923],
        [3.72, 0.902868, 0.926472],
        [3.723, 0.904162, 0.927],
        [3.725, 0.905452, 0.927585],
        [3.728, 0.906741, 0.928111],
        [3.731, 0.908051, 0.928662],
        [3.733, 0.90934, 0.929215],
        [3.736, 0.910635, 0.929742],
        [3.739, 0.911945, 0.93032],
        [3.741, 0.913238, 0.930848],
        [3.744, 0.914548, 0.931407],
        [3.747, 0.915843, 0.931955],
        [3.749, 0.917157, 0.932503],
        [3.752, 0.918468, 0.933062],
        [3.755, 0.919757, 0.933638],
        [3.757, 0.921077, 0.934173],
        [3.76, 0.922388, 0.934722],
        [3.763, 0.92368, 0.935279],
        [3.765, 0.924994, 0.935806],
        [3.768, 0.926311, 0.936381],
        [3.771, 0.927625, 0.936935],
        [3.773, 0.928939, 0.937467],
        [3.776, 0.930258, 0.938018],
        [3.779, 0.93157, 0.938571],
        [3.781, 0.932884, 0.939148],
        [3.784, 0.934203, 0.939689],
        [3.787, 0.935518, 0.940237],
        [3.789, 0.936832, 0.940808],
        [3.792, 0.938152, 0.941364],
        [3.795, 0.939467, 0.941888],
        [3.797, 0.940781, 0.942472],
        [3.8, 0.942101, 0.94302],
        [3.803, 0.94344, 0.943574],
        [3.805, 0.944755, 0.944101],
        [3.808, 0.946074, 0.944658],
        [3.811, 0.947411, 0.945235],
        [3.813, 0.948728, 0.945793],
        [3.816, 0.95007, 0.946345],
        [3.819, 0.951388, 0.946893],
        [3.821, 0.952729, 0.947455],
        [3.824, 0.954048, 0.948028],
        [3.827, 0.955383, 0.948601],
        [3.829, 0.956707, 0.949149],
        [3.832, 0.958043, 0.949685],
        [3.835, 0.959388, 0.950239],
        [3.837, 0.960706, 0.950801],
        [3.84, 0.962046, 0.951371],
        [3.843, 0.963387, 0.951929],
        [3.845, 0.964727, 0.952486],
        [3.848, 0.966072, 0.953009],
        [3.851, 0.967391, 0.953566],
        [3.853, 0.968735, 0.954146],
        [3.856, 0.970075, 0.954699],
        [3.859, 0.97142, 0.955251],
        [3.861, 0.97276, 0.955799],
        [3.864, 0.9741, 0.956362],
        [3.867, 0.975449, 0.956962],
        [3.869, 0.976809, 0.957512],
        [3.872, 0.978155, 0.95804],
        [3.875, 0.979494, 0.958605],
        [3.877, 0.980843, 0.959154],
        [3.88, 0.982183, 0.959708],
        [3.883, 0.98355, 0.960278],
        [3.885, 0.984893, 0.960838],
        [3.888, 0.986238, 0.961395],
        [3.891, 0.987603, 0.961947],
        [3.893, 0.988952, 0.962506],
        [3.896, 0.99032, 0.963085],
        [3.899, 0.991663, 0.963634],
        [3.901, 0.993033, 0.964215],
        [3.904, 0.994373, 0.96477],
        [3.907, 0.995743, 0.96532],
        [3.909, 0.997108, 0.965916],
        [3.912, 0.998457, 0.966474],
        [3.915, 0.999823, 0.967026],
        [3.917, 1.00119, 0.967584],
        [3.92, 1.00256, 0.968136],
        [3.923, 1.00391, 0.968703],
        [3.925, 1.00528, 0.969274],
        [3.928, 1.00664, 0.969831],
        [3.931, 1.00801, 0.970383],
        [3.933, 1.00938, 0.970937],
        [3.936, 1.01075, 0.971494],
        [3.939, 1.01212, 0.972073],
        [3.941, 1.01349, 0.972617],
        [3.944, 1.01486, 0.973179],
        [3.947, 1.01623, 0.973736],
        [3.949, 1.01762, 0.974289],
        [3.952, 1.01899, 0.974872],
        [3.955, 1.02036, 0.975451],
        [3.957, 1.02173, 0.976023],
        [3.96, 1.02312, 0.976578],
        [3.963, 1.02449, 0.977135],
        [3.965, 1.02587, 0.977686],
        [3.968, 1.02726, 0.978268],
        [3.971, 1.02863, 0.978817],
        [3.973, 1.03002, 0.979401],
        [3.976, 1.0314, 0.979953],
        [3.979, 1.03279, 0.980506],
        [3.981, 1.03416, 0.981111],
        [3.984, 1.03556, 0.981674],
        [3.987, 1.03696, 0.982221],
        [3.989, 1.03832, 0.982777],
        [3.992, 1.03972, 0.983335],
        [3.995, 1.04112, 0.983912],
        [3.997, 1.04249, 0.98451],
        [4, 1.04388, 0.985062],
        [4.003, 1.04528, 0.985625],
        [4.005, 1.04668, 0.986177],
        [4.008, 1.04807, 0.986736],
        [4.011, 1.04947, 0.987313],
        [4.013, 1.05086, 0.987894],
        [4.016, 1.05226, 0.988445],
        [4.019, 1.05366, 0.989003],
        [4.021, 1.05505, 0.989555],
        [4.024, 1.05645, 0.990139],
        [4.027, 1.05785, 0.990713],
        [4.029, 1.05926, 0.991265],
        [4.032, 1.06066, 0.991829],
        [4.035, 1.06206, 0.992388],
        [4.037, 1.06346, 0.992985],
        [4.04, 1.06488, 0.993581],
        [4.043, 1.06628, 0.994151],
        [4.045, 1.0677, 0.994696],
        [4.048, 1.06909, 0.995274],
        [4.051, 1.07051, 0.995831],
        [4.053, 1.07191, 0.99641],
        [4.056, 1.07333, 0.996967],
        [4.059, 1.07473, 0.997546],
        [4.061, 1.07615, 0.998098],
        [4.064, 1.07755, 0.998661],
        [4.067, 1.07897, 0.999262],
        [4.069, 1.08039, 0.999818],
        [4.072, 1.08181, 1.00037],
        [4.075, 1.08322, 1.00092],
        [4.077, 1.08464, 1.00151],
        [4.08, 1.08606, 1.00207],
        [4.083, 1.08749, 1.00265],
        [4.085, 1.08891, 1.00322],
        [4.088, 1.09033, 1.0038],
        [4.091, 1.09175, 1.00436],
        [4.093, 1.09318, 1.00496],
        [4.096, 1.0946, 1.00554],
        [4.099, 1.09602, 1.00609],
        [4.101, 1.09745, 1.00667],
        [4.104, 1.09887, 1.00724],
        [4.107, 1.10032, 1.00781],
        [4.109, 1.10174, 1.00839],
        [4.112, 1.10316, 1.00895],
        [4.115, 1.10459, 1.00952],
        [4.117, 1.10604, 1.01008],
        [4.12, 1.10746, 1.01066],
        [4.123, 1.10891, 1.01123],
        [4.125, 1.11033, 1.01179],
        [4.128, 1.11176, 1.01237],
        [4.131, 1.11321, 1.01294],
        [4.133, 1.11465, 1.01352],
        [4.136, 1.11608, 1.01409],
        [4.139, 1.11753, 1.01467],
        [4.141, 1.11895, 1.01525],
        [4.144, 0, 1.01581],
        [4.147, 0, 1.01639],
        [4.149, 0, 1.01697],
        [4.152, 0, 1.01757],
        [4.155, 0, 1.01813],
        [4.157, 0, 1.01871],
        [4.16, 0, 1.01926],
        [4.163, 0, 1.01983],
        [4.165, 0, 1.0204],
        [4.168, 0, 1.02099],
        [4.171, 0, 1.02156],
        [4.173, 0, 1.02212],
        [4.176, 0, 1.02269],
        [4.179, 0, 1.02326],
        [4.181, 0, 1.02386],
        [4.184, 0, 1.02442],
        [4.187, 0, 1.02502],
        [4.189, 0, 1.02558],
        [4.192, 0, 1.02615],
        [4.195, 0, 1.02673],
        [4.197, 0, 1.02734],
        [4.2, 0, 1.02789],
        [4.203, 0, 1.02847],
        [4.205, 0, 1.02906],
        [4.208, 0, 1.02962],
        [4.211, 0, 1.03021],
        [4.213, 0, 1.03078],
        [4.216, 0, 1.03135],
        [4.219, 0, 1.03191],
        [4.221, 0, 1.03249],
        [4.224, 0, 1.03307],
        [4.227, 0, 1.03365],
        [4.229, 0, 1.03424],
        [4.232, 0, 1.03479],
        [4.235, 0, 1.03538],
        [4.237, 0, 1.03595],
        [4.24, 0, 1.03656],
        [4.243, 0, 1.03713],
        [4.245, 0, 1.03771],
        [4.248, 0, 1.0383],
        [4.251, 0, 1.03885],
        [4.253, 0, 1.03945],
        [4.256, 0, 1.04004],
        [4.259, 0, 1.04059],
        [4.261, 0, 1.04117],
        [4.264, 0, 1.04176],
        [4.267, 0, 1.04234],
        [4.269, 0, 1.04292],
        [4.272, 0, 1.04349],
        [4.275, 0, 1.04406],
        [4.277, 0, 1.04464],
        [4.28, 0, 1.04523],
        [4.283, 0, 1.0458],
        [4.285, 0, 1.04638],
        [4.288, 0, 1.04695],
        [4.291, 0, 1.04755],
        [4.293, 0, 1.04815],
        [4.296, 0, 1.04874],
        [4.299, 0, 1.04931],
        [4.301, 0, 1.04988],
        [4.304, 0, 1.05046],
        [4.307, 0, 1.05106],
        [4.309, 0, 1.05163],
        [4.312, 0, 1.05221],
        [4.315, 0, 1.05279],
        [4.317, 0, 1.05334],
        [4.32, 0, 1.05394],
        [4.323, 0, 1.05454],
        [4.325, 0, 1.05512],
        [4.328, 0, 1.05567],
        [4.331, 0, 1.05626],
        [4.333, 0, 1.05684],
        [4.336, 0, 1.05744],
        [4.339, 0, 1.05802],
        [4.341, 0, 1.0586],
        [4.344, 0, 1.05918],
        [4.347, 0, 1.05977],
        [4.349, 0, 1.06035],
        [4.352, 0, 1.06095],
        [4.355, 0, 1.06154],
        [4.357, 0, 1.06211],
        [4.36, 0, 1.06269],
        [4.363, 0, 1.06326],
        [4.365, 0, 1.06386],
        [4.368, 0, 1.06443],
        [4.371, 0, 1.06502],
        [4.373, 0, 1.0656],
        [4.376, 0, 1.0662],
        [4.379, 0, 1.06678],
        [4.381, 0, 1.06737],
        [4.384, 0, 1.06795],
        [4.387, 0, 1.06854],
        [4.389, 0, 1.06912],
        [4.392, 0, 1.06969],
        [4.395, 0, 1.07028],
        [4.397, 0, 1.07086],
        [4.4, 0, 1.07144],
        [4.403, 0, 1.07202],
        [4.405, 0, 1.07261],
        [4.408, 0, 1.07324],
        [4.411, 0, 1.07382],
        [4.413, 0, 1.07438],
        [4.416, 0, 1.07498],
        [4.419, 0, 1.07557],
        [4.421, 0, 1.07614],
        [4.424, 0, 1.07674],
        [4.427, 0, 1.07733],
        [4.429, 0, 1.07791],
        [4.432, 0, 1.0785],
        [4.435, 0, 1.07907],
        [4.437, 0, 1.07968],
        [4.44, 0, 1.08025],
        [4.443, 0, 1.08082],
        [4.445, 0, 1.0814],
        [4.448, 0, 1.08199],
        [4.451, 0, 1.08259],
        [4.453, 0, 1.08317],
        [4.456, 0, 1.08377],
        [4.459, 0, 1.08436],
        [4.461, 0, 1.08495],
        [4.464, 0, 1.08552],
        [4.467, 0, 1.08613],
        [4.469, 0, 1.08674],
        [4.472, 0, 1.08732],
        [4.475, 0, 1.0879],
        [4.477, 0, 1.08848],
        [4.48, 0, 1.08908],
        [4.483, 0, 1.08967],
        [4.485, 0, 1.09025],
        [4.488, 0, 1.09084],
        [4.491, 0, 1.09142],
        [4.493, 0, 1.09205],
        [4.496, 0, 1.09263],
        [4.499, 0, 1.09321],
        [4.501, 0, 1.09379],
        [4.504, 0, 1.09437],
        [4.507, 0, 1.09496],
        [4.509, 0, 1.09556],
        [4.512, 0, 1.09615],
        [4.515, 0, 1.09672],
        [4.517, 0, 1.0973],
        [4.52, 0, 1.0979],
        [4.523, 0, 1.0985],
        [4.525, 0, 1.09909],
        [4.528, 0, 1.09967],
        [4.531, 0, 1.10026],
        [4.533, 0, 1.10088],
        [4.536, 0, 1.10148],
        [4.539, 0, 1.10206],
        [4.541, 0, 1.10265],
        [4.544, 0, 1.10324],
        [4.547, 0, 1.10383],
        [4.549, 0, 1.10442],
        [4.552, 0, 1.10502],
        [4.555, 0, 1.10561],
        [4.557, 0, 1.1062],
        [4.56, 0, 1.10677],
        [4.563, 0, 1.10735],
        [4.565, 0, 1.10796],
        [4.568, 0, 1.10857],
        [4.571, 0, 1.10915],
        [4.573, 0, 1.10976],
        [4.576, 0, 1.11035],
        [4.579, 0, 1.11093],
        [4.581, 0, 1.11152],
        [4.584, 0, 1.11212],
        [4.587, 0, 1.1127],
        [4.589, 0, 1.11329],
        [4.592, 0, 1.11389],
        [4.595, 0, 1.11449],
        [4.597, 0, 1.1151],
        [4.6, 0, 1.11567],
        [4.603, 0, 1.11629],
        [4.605, 0, 1.11687],
        [4.608, 0, 1.11748],
        [4.611, 0, 1.11809],
        [4.613, 0, 1.11867],
        [4.616, 0, 1.11925],
        [4.619, 0, 1.11982],
        [4.621, 0, 1.12041],
        [4.624, 0, 1.12104],
        [4.627, 0, 1.12163],
        [4.629, 0, 1.12221],
        [4.632, 0, 1.1228],
        [4.635, 0, 1.12338],
        [4.637, 0, 1.12403],
        [4.64, 0, 1.12461],
        [4.643, 0, 1.1252],
        [4.645, 0, 1.12579],
        [4.648, 0, 1.12636],
        [4.651, 0, 1.127],
        [4.653, 0, 1.12758],
        [4.656, 0, 1.12816],
        [4.659, 0, 1.12875],
        [4.661, 0, 1.12935],
        [4.664, 0, 1.12994],
        [4.667, 0, 1.13056],
        [4.669, 0, 1.13117],
        [4.672, 0, 1.13177],
        [4.675, 0, 1.13236],
        [4.677, 0, 1.13294],
        [4.68, 0, 1.13356],
        [4.683, 0, 1.13415],
        [4.685, 0, 1.13474],
        [4.688, 0, 1.13532],
        [4.691, 0, 1.13591],
        [4.693, 0, 1.13654],
        [4.696, 0, 1.13712],
        [4.699, 0, 1.13771],
        [4.701, 0, 1.13833],
        [4.704, 0, 1.13893],
        [4.707, 0, 1.1395],
        [4.709, 0, 1.14013],
        [4.712, 0, 1.14072],
        [4.715, 0, 1.1413],
        [4.717, 0, 1.14191],
        [4.72, 0, 1.1425],
        [4.723, 0, 1.14311],
        [4.725, 0, 1.14369],
        [4.728, 0, 1.14429],
        [4.731, 0, 1.14487],
        [4.733, 0, 1.14546],
        [4.736, 0, 1.14611],
        [4.739, 0, 1.14671],
        [4.741, 0, 1.14733],
        [4.744, 0, 1.14791],
        [4.747, 0, 1.1485],
        [4.749, 0, 1.14911],
        [4.752, 0, 1.14971],
        [4.755, 0, 1.1503],
        [4.757, 0, 1.1509],
        [4.76, 0, 1.15148],
        [4.763, 0, 1.15207],
        [4.765, 0, 1.15272],
        [4.768, 0, 1.15331],
        [4.771, 0, 1.15391],
        [4.773, 0, 1.1545],
        [4.776, 0, 1.15509],
        [4.779, 0, 1.15571],
        [4.781, 0, 1.1563],
        [4.784, 0, 1.1569],
        [4.787, 0, 1.15749],
        [4.789, 0, 1.15807],
        [4.792, 0, 1.15868],
        [4.795, 0, 1.15929],
        [4.797, 0, 1.15992],
        [4.8, 0, 1.16051],
        [4.803, 0, 1.16112],
        [4.805, 0, 1.1617],
        [4.808, 0, 1.16231],
        [4.811, 0, 1.16291],
        [4.813, 0, 1.16351],
        [4.816, 0, 1.16412],
        [4.819, 0, 1.16472],
        [4.821, 0, 1.16534],
        [4.824, 0, 1.16592],
        [4.827, 0, 1.16653],
        [4.829, 0, 1.16715],
        [4.832, 0, 1.16775],
        [4.835, 0, 1.16834],
        [4.837, 0, 1.16895],
        [4.84, 0, 1.16955],
        [4.843, 0, 1.17014],
        [4.845, 0, 1.17074],
        [4.848, 0, 1.17133],
        [4.851, 0, 1.17195],
        [4.853, 0, 1.17254],
        [4.856, 0, 1.17315],
        [4.859, 0, 1.17376],
        [4.861, 0, 1.17437],
        [4.864, 0, 1.17498],
        [4.867, 0, 1.17558],
        [4.869, 0, 1.17617],
        [4.872, 0, 1.17678],
        [4.875, 0, 1.17739],
        [4.877, 0, 1.17796],
        [4.88, 0, 1.1786],
        [4.883, 0, 1.17918],
        [4.885, 0, 1.1798],
        [4.888, 0, 1.1804],
        [4.891, 0, 1.18101],
        [4.893, 0, 1.18162],
        [4.896, 0, 1.18226],
        [4.899, 0, 1.18283],
        [4.901, 0, 1.18344],
        [4.904, 0, 1.18405],
        [4.907, 0, 1.18466],
        [4.909, 0, 1.18527],
        [4.912, 0, 1.18585],
        [4.915, 0, 1.18646],
        [4.917, 0, 1.18708],
        [4.92, 0, 1.18768],
        [4.923, 0, 1.18831],
        [4.925, 0, 1.1889],
        [4.928, 0, 1.1895],
        [4.931, 0, 1.19008],
        [4.933, 0, 1.19069],
        [4.936, 0, 1.19132],
        [4.939, 0, 1.19192],
        [4.941, 0, 1.19252],
        [4.944, 0, 1.19311],
        [4.947, 0, 1.19374],
        [4.949, 0, 1.19438],
        [4.952, 0, 1.19496],
        [4.955, 0, 1.19557],
        [4.957, 0, 1.19615],
        [4.96, 0, 1.19676],
        [4.963, 0, 1.19737],
        [4.965, 0, 1.19797],
        [4.968, 0, 1.19858],
        [4.971, 0, 1.19919],
        [4.973, 0, 1.1998],
        [4.976, 0, 1.20041],
        [4.979, 0, 1.20106],
        [4.981, 0, 1.20165],
        [4.984, 0, 1.20226],
        [4.987, 0, 1.20287],
        [4.989, 0, 1.20346],
        [4.992, 0, 1.20408],
        [4.995, 0, 1.20468],
        [4.997, 0, 1.20528],
        [5, 0, 1.20588],
        [5.003, 0, 1.20652],
        [5.005, 0, 1.20711],
        [5.008, 0, 1.20774],
        [5.011, 0, 1.20834],
        [5.013, 0, 1.20894],
        [5.016, 0, 1.20954],
        [5.019, 0, 1.21015],
        [5.021, 0, 1.21075],
        [5.024, 0, 1.21137],
        [5.027, 0, 1.21199],
        [5.029, 0, 1.21262],
        [5.032, 0, 1.2132],
        [5.035, 0, 1.21383],
        [5.037, 0, 1.21443],
        [5.04, 0, 1.21504],
        [5.043, 0, 1.21563],
        [5.045, 0, 1.21623],
        [5.048, 0, 1.21685],
        [5.051, 0, 1.21746],
        [5.053, 0, 1.21807],
        [5.056, 0, 1.21868],
        [5.059, 0, 1.21932],
        [5.061, 0, 1.21989],
        [5.064, 0, 1.22053],
        [5.067, 0, 1.22116],
        [5.069, 0, 1.22177],
        [5.072, 0, 1.22237],
        [5.075, 0, 1.22297],
        [5.077, 0, 1.22359],
        [5.08, 0, 1.2242],
        [5.083, 0, 1.22482],
        [5.085, 0, 1.22543],
        [5.088, 0, 1.22603],
        [5.091, 0, 1.22664],
        [5.093, 0, 1.22727],
        [5.096, 0, 1.22788],
        [5.099, 0, 1.22847],
        [5.101, 0, 1.22908],
        [5.104, 0, 1.22969],
        [5.107, 0, 1.23032],
        [5.109, 0, 1.23093],
        [5.112, 0, 1.23154],
        [5.115, 0, 1.23216],
        [5.117, 0, 1.23276],
        [5.12, 0, 1.23339],
        [5.123, 0, 1.234],
        [5.125, 0, 1.23461],
        [5.128, 0, 1.2352],
        [5.131, 0, 1.23581],
        [5.133, 0, 1.23642],
        [5.136, 0, 1.23705],
        [5.139, 0, 1.23768],
        [5.141, 0, 1.23829],
        [5.144, 0, 1.23888],
        [5.147, 0, 1.2395],
        [5.149, 0, 1.24013],
        [5.152, 0, 1.24073],
        [5.155, 0, 1.24134],
        [5.157, 0, 1.24197],
        [5.16, 0, 1.24259],
        [5.163, 0, 1.24321],
        [5.165, 0, 1.24382],
        [5.168, 0, 1.24444],
        [5.171, 0, 1.24505],
        [5.173, 0, 1.24567],
        [5.176, 0, 1.24627],
        [5.179, 0, 1.2469],
        [5.181, 0, 1.24751],
        [5.184, 0, 1.24812],
        [5.187, 0, 1.2487],
        [5.189, 0, 1.24934],
        [5.192, 0, 1.24996],
        [5.195, 0, 1.25059],
        [5.197, 0, 1.2512],
        [5.2, 0, 1.25181],
        [5.203, 0, 1.25242],
        [5.205, 0, 1.25304],
        [5.208, 0, 1.25365],
        [5.211, 0, 1.25427],
        [5.213, 0, 1.25488],
        [5.216, 0, 1.25551],
        [5.219, 0, 1.25611],
        [5.221, 0, 1.25674],
        [5.224, 0, 1.25734],
        [5.227, 0, 1.25796],
        [5.229, 0, 1.25856],
        [5.232, 0, 1.25917],
        [5.235, 0, 1.2598],
        [5.237, 0, 1.26042],
        [5.24, 0, 1.26104],
        [5.243, 0, 1.26165],
        [5.245, 0, 1.26227],
        [5.248, 0, 1.26288],
        [5.251, 0, 1.26351],
        [5.253, 0, 1.26412],
        [5.256, 0, 1.26476],
        [5.259, 0, 1.26537],
        [5.261, 0, 1.26597],
        [5.264, 0, 1.2666],
        [5.267, 0, 1.26724],
        [5.269, 0, 1.26786],
        [5.272, 0, 1.26846],
        [5.275, 0, 1.26907],
        [5.277, 0, 1.26971],
        [5.28, 0, 1.27032],
        [5.283, 0, 1.27093],
        [5.285, 0, 1.27154],
        [5.288, 0, 1.27215],
        [5.291, 0, 1.27278],
        [5.293, 0, 1.27341],
        [5.296, 0, 1.27402],
        [5.299, 0, 1.27464],
        [5.301, 0, 1.27525],
        [5.304, 0, 1.27586],
        [5.307, 0, 1.2765],
        [5.309, 0, 1.2771],
        [5.312, 0, 1.27772],
        [5.315, 0, 1.27835],
        [5.317, 0, 1.27896],
        [5.32, 0, 1.27959],
        [5.323, 0, 1.2802],
        [5.325, 0, 1.28084],
        [5.328, 0, 1.28145],
        [5.331, 0, 1.28206],
        [5.333, 0, 1.28267],
        [5.336, 0, 1.28331],
        [5.339, 0, 1.28393],
        [5.341, 0, 1.28455],
        [5.344, 0, 1.28516],
        [5.347, 0, 1.28577],
        [5.349, 0, 1.2864],
        [5.352, 0, 1.28702],
        [5.355, 0, 1.28762],
        [5.357, 0, 1.28824],
        [5.36, 0, 1.28889],
        [5.363, 0, 1.28953],
        [5.365, 0, 1.29016],
        [5.368, 0, 1.29077],
        [5.371, 0, 1.29139],
        [5.373, 0, 1.292],
        [5.376, 0, 1.29261],
        [5.379, 0, 1.29324],
        [5.381, 0, 1.29386],
        [5.384, 0, 1.29448],
        [5.387, 0, 1.2951],
        [5.389, 0, 1.29572],
        [5.392, 0, 1.29636],
        [5.395, 0, 1.29698],
        [5.397, 0, 1.29759],
        [5.4, 0, 1.29819],
        [5.403, 0, 1.29881],
        [5.405, 0, 1.29946],
        [5.408, 0, 1.30008],
        [5.411, 0, 1.30069],
        [5.413, 0, 1.30132],
        [5.416, 0, 1.30194],
        [5.419, 0, 1.30254],
        [5.421, 0, 1.3032],
        [5.424, 0, 1.30382],
        [5.427, 0, 1.30443],
        [5.429, 0, 1.30504],
        [5.432, 0, 1.30565],
        [5.435, 0, 1.3063],
        [5.437, 0, 1.30694],
        [5.44, 0, 1.30755],
        [5.443, 0, 1.30816],
        [5.445, 0, 1.30878],
        [5.448, 0, 1.3094],
        [5.451, 0, 1.31005],
        [5.453, 0, 1.31066],
        [5.456, 0, 1.31127],
        [5.459, 0, 1.3119],
        [5.461, 0, 1.31251],
        [5.464, 0, 1.31316],
        [5.467, 0, 1.31379],
        [5.469, 0, 1.31441],
        [5.472, 0, 1.31503],
        [5.475, 0, 1.31564],
        [5.477, 0, 1.31629],
        [5.48, 0, 1.31692],
        [5.483, 0, 1.31754],
        [5.485, 0, 1.31816],
        [5.488, 0, 1.31878],
        [5.491, 0, 1.31943],
        [5.493, 0, 1.32003],
        [5.496, 0, 1.32065],
        [5.499, 0, 1.32128],
        [5.501, 0, 1.32189],
        [5.504, 0, 1.32251],
        [5.507, 0, 1.32316],
        [5.509, 0, 1.3238],
        [5.512, 0, 1.32441],
        [5.515, 0, 1.32502],
        [5.517, 0, 1.32563],
        [5.52, 0, 1.3263],
        [5.523, 0, 1.3269],
        [5.525, 0, 1.32752],
        [5.528, 0, 1.32815],
        [5.531, 0, 1.32879],
        [5.533, 0, 1.32942],
        [5.536, 0, 1.33003],
        [5.539, 0, 1.33067],
        [5.541, 0, 1.33128],
        [5.544, 0, 1.33189],
        [5.547, 0, 1.3325],
        [5.549, 0, 1.33316],
        [5.552, 0, 1.33379],
        [5.555, 0, 1.33441],
        [5.557, 0, 1.33504],
        [5.56, 0, 1.33566],
        [5.563, 0, 1.3363],
        [5.565, 0, 1.33692],
        [5.568, 0, 1.33754],
        [5.571, 0, 1.33815],
        [5.573, 0, 1.33881],
        [5.576, 0, 1.33945],
        [5.579, 0, 1.34005],
        [5.581, 0, 1.34069],
        [5.584, 0, 1.34132],
        [5.587, 0, 1.34194],
        [5.589, 0, 1.34257],
        [5.592, 0, 1.34321],
        [5.595, 0, 1.34382],
        [5.597, 0, 1.34448],
        [5.6, 0, 1.34509],
        [5.603, 0, 1.3457],
        [5.605, 0, 1.34636],
        [5.608, 0, 1.34697],
        [5.611, 0, 1.34759],
        [5.613, 0, 1.34822],
        [5.616, 0, 1.34884],
        [5.619, 0, 1.3495],
        [5.621, 0, 1.35013],
        [5.624, 0, 1.35074],
        [5.627, 0, 1.35138],
        [5.629, 0, 1.352],
        [5.632, 0, 1.3526],
        [5.635, 0, 1.35326],
        [5.637, 0, 1.35388],
        [5.64, 0, 1.35453],
        [5.643, 0, 1.35514],
        [5.645, 0, 1.35576],
        [5.648, 0, 1.35641],
        [5.651, 0, 1.35703],
        [5.653, 0, 1.35767],
        [5.656, 0, 1.35828],
        [5.659, 0, 1.35889],
        [5.661, 0, 1.35957],
        [5.664, 0, 1.36018],
        [5.667, 0, 1.36082],
        [5.669, 0, 1.36143],
        [5.672, 0, 1.36204],
        [5.675, 0, 1.36268],
        [5.677, 0, 1.36331],
        [5.68, 0, 1.36395],
        [5.683, 0, 1.36457],
        [5.685, 0, 1.36522],
        [5.688, 0, 1.36584],
        [5.691, 0, 1.3665],
        [5.693, 0, 1.36711],
        [5.696, 0, 1.36772],
        [5.699, 0, 1.36836],
        [5.701, 0, 1.36897],
        [5.704, 0, 1.36962],
        [5.707, 0, 1.37027],
        [5.709, 0, 1.37092],
        [5.712, 0, 1.37153],
        [5.715, 0, 1.37217],
        [5.717, 0, 1.37279],
        [5.72, 0, 1.37344],
        [5.723, 0, 1.37406],
        [5.725, 0, 1.3747],
        [5.728, 0, 1.37533],
        [5.731, 0, 1.37596],
        [5.733, 0, 1.3766],
        [5.736, 0, 1.37724],
        [5.739, 0, 1.37785],
        [5.741, 0, 1.37848],
        [5.744, 0, 1.3791],
        [5.747, 0, 1.37975],
        [5.749, 0, 1.3804],
        [5.752, 0, 1.38103],
        [5.755, 0, 1.38165],
        [5.757, 0, 1.38228],
        [5.76, 0, 1.38289],
        [5.763, 0, 1.38355],
        [5.765, 0, 1.38417],
        [5.768, 0, 1.3848],
        [5.771, 0, 1.38544],
        [5.773, 0, 1.38607],
        [5.776, 0, 1.38671],
        [5.779, 0, 1.38734],
        [5.781, 0, 1.38796],
        [5.784, 0, 1.3886],
        [5.787, 0, 1.38921],
        [5.789, 0, 1.38987],
        [5.792, 0, 1.39051],
        [5.795, 0, 1.39114],
        [5.797, 0, 1.39179],
        [5.8, 0, 1.39239],
        [5.803, 0, 1.39303],
        [5.805, 0, 1.39366],
        [5.808, 0, 1.3943],
        [5.811, 0, 1.39491],
        [5.813, 0, 1.39557],
        [5.816, 0, 1.39619],
        [5.819, 0, 1.39685],
        [5.821, 0, 1.39749],
        [5.824, 0, 1.3981],
        [5.827, 0, 1.39874],
        [5.829, 0, 1.39935],
        [5.832, 0, 1.4],
        [5.835, 0, 1.40067],
        [5.837, 0, 1.40127],
        [5.84, 0, 1.40193],
        [5.843, 0, 1.40255],
        [5.845, 0, 1.40318],
        [5.848, 0, 1.40385],
        [5.851, 0, 1.40446],
        [5.853, 0, 1.40513],
        [5.856, 0, 1.40574],
        [5.859, 0, 1.40638],
        [5.861, 0, 1.40703],
        [5.864, 0, 1.40765],
        [5.867, 0, 1.40828],
        [5.869, 0, 1.40889],
        [5.872, 0, 1.40953],
        [5.875, 0, 1.41021],
        [5.877, 0, 1.41083],
        [5.88, 0, 1.41146],
        [5.883, 0, 1.41211],
        [5.885, 0, 1.41271],
        [5.888, 0, 1.41336],
        [5.891, 0, 1.41402],
        [5.893, 0, 1.41463],
        [5.896, 0, 1.41529],
        [5.899, 0, 1.4159],
        [5.901, 0, 1.41654],
        [5.904, 0, 1.4172],
        [5.907, 0, 1.41782],
        [5.909, 0, 1.41845],
        [5.912, 0, 1.41909],
        [5.915, 0, 1.41972],
        [5.917, 0, 1.42036],
        [5.92, 0, 1.42101],
        [5.923, 0, 1.42163],
        [5.925, 0, 1.42228],
        [5.928, 0, 1.42291],
        [5.931, 0, 1.42355],
        [5.933, 0, 1.42419],
        [5.936, 0, 1.42484],
        [5.939, 0, 1.42548],
        [5.941, 0, 1.4261],
        [5.944, 0, 1.42674],
        [5.947, 0, 1.42739],
        [5.949, 0, 1.42801],
        [5.952, 0, 1.42864],
        [5.955, 0, 1.42928],
        [5.957, 0, 1.42991],
        [5.96, 0, 1.43055],
        [5.963, 0, 1.43122],
        [5.965, 0, 1.43186],
        [5.968, 0, 1.43247],
        [5.971, 0, 1.4331],
        [5.973, 0, 1.43375],
        [5.976, 0, 1.43442],
        [5.979, 0, 1.43504],
        [5.981, 0, 1.43568],
        [5.984, 0, 1.43634],
        [5.987, 0, 1.43695],
        [5.989, 0, 1.43761],
        [5.992, 0, 1.43825],
        [5.995, 0, 1.43889],
        [5.997, 0, 1.43952],
        [6, 0, 1.44016],
        [6.003, 0, 1.4408],
        [6.005, 0, 1.44146],
        [6.008, 0, 1.44208],
        [6.011, 0, 1.44271],
        [6.013, 0, 1.44335],
        [6.016, 0, 1.44401],
        [6.019, 0, 1.44467],
        [6.021, 0, 1.44528],
        [6.024, 0, 1.44592],
        [6.027, 0, 1.44656],
        [6.029, 0, 1.4472],
        [6.032, 0, 1.44783],
        [6.035, 0, 1.44848],
        [6.037, 0, 1.44913],
        [6.04, 0, 1.44977],
        [6.043, 0, 1.45041],
        [6.045, 0, 1.45103],
        [6.048, 0, 1.45169],
        [6.051, 0, 1.45233],
        [6.053, 0, 1.45296],
        [6.056, 0, 1.45362],
        [6.059, 0, 1.45424],
        [6.061, 0, 1.45489],
        [6.064, 0, 1.45553],
        [6.067, 0, 1.45617],
        [6.069, 0, 1.45681],
        [6.072, 0, 1.45742],
        [6.075, 0, 1.4581],
        [6.077, 0, 1.45875],
        [6.08, 0, 1.45939],
        [6.083, 0, 1.46002],
        [6.085, 0, 1.46066],
        [6.088, 0, 1.46128],
        [6.091, 0, 1.46193],
        [6.093, 0, 1.46258],
        [6.096, 0, 1.46323],
        [6.099, 0, 1.46387],
        [6.101, 0, 1.46451],
        [6.104, 0, 1.46515],
        [6.107, 0, 1.46579],
        [6.109, 0, 1.46642],
        [6.112, 0, 1.46706],
        [6.115, 0, 1.46772],
        [6.117, 0, 1.46838],
        [6.12, 0, 1.46902],
        [6.123, 0, 1.46964],
        [6.125, 0, 1.47028],
        [6.128, 0, 1.47091],
        [6.131, 0, 1.47156],
        [6.133, 0, 1.47224],
        [6.136, 0, 1.4729],
        [6.139, 0, 1.47353],
        [6.141, 0, 1.47418],
        [6.144, 0, 1.47478],
        [6.147, 0, 1.47545],
        [6.149, 0, 1.47609],
        [6.152, 0, 1.47674],
        [6.155, 0, 1.47738],
        [6.157, 0, 1.47802],
        [6.16, 0, 1.47869],
        [6.163, 0, 1.47932],
        [6.165, 0, 1.47997],
        [6.168, 0, 1.4806],
        [6.171, 0, 1.48122],
        [6.173, 0, 1.48188],
        [6.176, 0, 1.48254],
        [6.179, 0, 1.48318],
        [6.181, 0, 1.48381],
        [6.184, 0, 1.48445],
        [6.187, 0, 1.4851],
        [6.189, 0, 1.48576],
        [6.192, 0, 1.48641],
        [6.195, 0, 1.48706],
        [6.197, 0, 1.48769],
        [6.2, 0, 1.48833],
        [6.203, 0, 1.489],
        [6.205, 0, 1.48963],
        [6.208, 0, 1.49025],
        [6.211, 0, 1.49091],
        [6.213, 0, 1.49154],
        [6.216, 0, 1.49219],
        [6.219, 0, 1.49285],
        [6.221, 0, 1.49349],
        [6.224, 0, 1.49413],
        [6.227, 0, 1.49476],
        [6.229, 0, 1.49542],
        [6.232, 0, 1.49609],
        [6.235, 0, 1.49672],
        [6.237, 0, 1.49736],
        [6.24, 0, 1.498],
        [6.243, 0, 1.49863],
        [6.245, 0, 1.49931],
        [6.248, 0, 1.49997],
        [6.251, 0, 1.5006],
        [6.253, 0, 1.50124],
        [6.256, 0, 1.50189],
        [6.259, 0, 1.50252],
        [6.261, 0, 1.50318],
        [6.264, 0, 1.50382],
        [6.267, 0, 1.50448],
        [6.269, 0, 1.50512],
        [6.272, 0, 1.50576],
        [6.275, 0, 1.50642],
        [6.277, 0, 1.50706],
        [6.28, 0, 1.5077],
        [6.283, 0, 1.50834],
        [6.285, 0, 1.509],
        [6.288, 0, 1.50966],
        [6.291, 0, 1.51031],
        [6.293, 0, 1.51094],
        [6.296, 0, 1.51158],
        [6.299, 0, 1.51222],
        [6.301, 0, 1.51288],
        [6.304, 0, 1.51357],
        [6.307, 0, 1.51421],
        [6.309, 0, 1.51484],
        [6.312, 0, 1.51548],
        [6.315, 0, 1.51612],
        [6.317, 0, 1.51679],
        [6.32, 0, 1.51742],
        [6.323, 0, 1.51808],
        [6.325, 0, 1.51874],
        [6.328, 0, 1.51939],
        [6.331, 0, 1.52004],
        [6.333, 0, 1.52069],
        [6.336, 0, 1.52133],
        [6.339, 0, 1.52197],
        [6.341, 0, 1.52263],
        [6.344, 0, 1.52327],
        [6.347, 0, 1.52393],
        [6.349, 0, 1.52457],
        [6.352, 0, 1.52521],
        [6.355, 0, 1.52584],
        [6.357, 0, 1.52649],
        [6.36, 0, 1.52718],
        [6.363, 0, 1.52783],
        [6.365, 0, 1.52847],
        [6.368, 0, 1.52911],
        [6.371, 0, 1.52975],
        [6.373, 0, 1.53041],
        [6.376, 0, 1.53105],
        [6.379, 0, 1.53172],
        [6.381, 0, 1.53235],
        [6.384, 0, 1.53299],
        [6.387, 0, 1.53364],
        [6.389, 0, 1.53432],
        [6.392, 0, 1.53496],
        [6.395, 0, 1.53562],
        [6.397, 0, 1.53626],
        [6.4, 0, 1.5369],
        [6.403, 0, 1.53756],
        [6.405, 0, 1.5382],
        [6.408, 0, 1.53884],
        [6.411, 0, 1.5395],
        [6.413, 0, 1.54016],
        [6.416, 0, 1.54083],
        [6.419, 0, 1.54147],
        [6.421, 0, 1.5421],
        [6.424, 0, 1.54275],
        [6.427, 0, 1.54339],
        [6.429, 0, 1.54405],
        [6.432, 0, 1.54473],
        [6.435, 0, 1.54538],
        [6.437, 0, 1.54601],
        [6.44, 0, 1.54665],
        [6.443, 0, 1.5473],
        [6.445, 0, 1.54797],
        [6.448, 0, 1.54862],
        [6.451, 0, 1.54928],
        [6.453, 0, 1.54993],
        [6.456, 0, 1.55056],
        [6.459, 0, 1.55122],
        [6.461, 0, 1.55186],
        [6.464, 0, 1.55252],
        [6.467, 0, 1.55319],
        [6.469, 0, 1.55383],
        [6.472, 0, 1.55447],
        [6.475, 0, 1.55514],
        [6.477, 0, 1.5558],
        [6.48, 0, 1.55646],
        [6.483, 0, 1.5571],
        [6.485, 0, 1.55776],
        [6.488, 0, 1.55843],
        [6.491, 0, 1.55909],
        [6.493, 0, 1.55972],
        [6.496, 0, 1.56037],
        [6.499, 0, 1.56101],
        [6.501, 0, 1.56167],
        [6.504, 0, 1.56236],
        [6.507, 0, 1.563],
        [6.509, 0, 1.56364],
        [6.512, 0, 1.56428],
        [6.515, 0, 1.56493],
        [6.517, 0, 1.5656],
        [6.52, 0, 1.56626],
        [6.523, 0, 1.56691],
        [6.525, 0, 1.56755],
        [6.528, 0, 1.56821],
        [6.531, 0, 1.56887],
        [6.533, 0, 1.56952],
        [6.536, 0, 1.57016],
        [6.539, 0, 1.57084],
        [6.541, 0, 1.57148],
        [6.544, 0, 1.57212],
        [6.547, 0, 1.57279],
        [6.549, 0, 1.57344],
        [6.552, 0, 1.57408],
        [6.555, 0, 1.57472],
        [6.557, 0, 1.57539],
        [6.56, 0, 1.57608],
        [6.563, 0, 1.57671],
        [6.565, 0, 1.57735],
        [6.568, 0, 1.57802],
        [6.571, 0, 1.57866],
        [6.573, 0, 1.57935],
        [6.576, 0, 1.57999],
        [6.579, 0, 1.58064],
        [6.581, 0, 1.58129],
        [6.584, 0, 1.58194],
        [6.587, 0, 1.58258],
        [6.589, 0, 1.58326],
        [6.592, 0, 1.58393],
        [6.595, 0, 1.58456],
        [6.597, 0, 1.58522],
        [6.6, 0, 1.58587],
        [6.603, 0, 1.58653],
        [6.605, 0, 1.58719],
        [6.608, 0, 1.58785],
        [6.611, 0, 1.58849],
        [6.613, 0, 1.58914],
        [6.616, 0, 1.58982],
        [6.619, 0, 1.59046],
        [6.621, 0, 1.59111],
        [6.624, 0, 1.59177],
        [6.627, 0, 1.59244],
        [6.629, 0, 1.59308],
        [6.632, 0, 1.59376],
        [6.635, 0, 1.59439],
        [6.637, 0, 1.59504],
        [6.64, 0, 1.59571],
        [6.643, 0, 1.59637],
        [6.645, 0, 1.59703],
        [6.648, 0, 1.59769],
        [6.651, 0, 1.59834],
        [6.653, 0, 1.59897],
        [6.656, 0, 1.59964],
        [6.659, 0, 1.60031],
        [6.661, 0, 1.60096],
        [6.664, 0, 1.60163],
        [6.667, 0, 1.60228],
        [6.669, 0, 1.60294],
        [6.672, 0, 1.60358],
        [6.675, 0, 1.60426],
        [6.677, 0, 1.60495],
        [6.68, 0, 1.6056],
        [6.683, 0, 1.60623],
        [6.685, 0, 1.60689],
        [6.688, 0, 1.60756],
        [6.691, 0, 1.60822],
        [6.693, 0, 1.60886],
        [6.696, 0, 1.60953],
        [6.699, 0, 1.61019],
        [6.701, 0, 1.61085],
        [6.704, 0, 1.61149],
        [6.707, 0, 1.61216],
        [6.709, 0, 1.61281],
        [6.712, 0, 1.61348],
        [6.715, 0, 1.61413],
        [6.717, 0, 1.6148],
        [6.72, 0, 1.61545],
        [6.723, 0, 1.61609],
        [6.725, 0, 1.61676],
        [6.728, 0, 1.61743],
        [6.731, 0, 1.61812],
        [6.733, 0, 1.61876],
        [6.736, 0, 1.6194],
        [6.739, 0, 1.62007],
        [6.741, 0, 1.6207],
        [6.744, 0, 1.62139],
        [6.747, 0, 1.62206],
        [6.749, 0, 1.62269],
        [6.752, 0, 1.62335],
        [6.755, 0, 1.624],
        [6.757, 0, 1.62467],
        [6.76, 0, 1.62533],
        [6.763, 0, 1.62601],
        [6.765, 0, 1.62665],
        [6.768, 0, 1.62733],
        [6.771, 0, 1.62796],
        [6.773, 0, 1.62862],
        [6.776, 0, 1.62929],
        [6.779, 0, 1.62995],
        [6.781, 0, 1.63061],
        [6.784, 0, 1.63127],
        [6.787, 0, 1.63195],
        [6.789, 0, 1.63259],
        [6.792, 0, 1.63326],
        [6.795, 0, 1.6339],
        [6.797, 0, 1.63459],
        [6.8, 0, 1.63523],
        [6.803, 0, 1.63591],
        [6.805, 0, 1.63656],
        [6.808, 0, 1.63722],
        [6.811, 0, 1.63786],
        [6.813, 0, 1.63853],
        [6.816, 0, 1.63921],
        [6.819, 0, 1.63986],
        [6.821, 0, 1.64052],
        [6.824, 0, 1.64115],
        [6.827, 0, 1.64182],
        [6.829, 0, 1.6425],
        [6.832, 0, 1.64317],
        [6.835, 0, 1.64382],
        [6.837, 0, 1.64447],
        [6.84, 0, 1.64513],
        [6.843, 0, 1.64579],
        [6.845, 0, 1.64648],
        [6.848, 0, 1.64715],
        [6.851, 0, 1.6478],
        [6.853, 0, 1.64845],
        [6.856, 0, 1.64911],
        [6.859, 0, 1.64978],
        [6.861, 0, 1.65044],
        [6.864, 0, 1.65111],
        [6.867, 0, 1.65177],
        [6.869, 0, 1.65242],
        [6.872, 0, 1.6531],
        [6.875, 0, 1.65375],
        [6.877, 0, 1.65441],
        [6.88, 0, 1.65507],
        [6.883, 0, 1.65573],
        [6.885, 0, 1.65638],
        [6.888, 0, 1.65708],
        [6.891, 0, 1.65775],
        [6.893, 0, 1.65839],
        [6.896, 0, 1.65908],
        [6.899, 0, 1.65973],
        [6.901, 0, 1.66042],
        [6.904, 0, 1.66106],
        [6.907, 0, 1.66173],
        [6.909, 0, 1.66237],
        [6.912, 0, 1.66305],
        [6.915, 0, 1.66373],
        [6.917, 0, 1.66438],
        [6.92, 0, 1.66504],
        [6.923, 0, 1.66569],
        [6.925, 0, 1.66635],
        [6.928, 0, 1.66704],
        [6.931, 0, 1.6677],
        [6.933, 0, 1.66837],
        [6.936, 0, 1.66901],
        [6.939, 0, 1.66968],
        [6.941, 0, 1.67032],
        [6.944, 0, 1.67103],
        [6.947, 0, 1.67169],
        [6.949, 0, 1.67233],
        [6.952, 0, 1.673],
        [6.955, 0, 1.67365],
        [6.957, 0, 1.67434],
        [6.96, 0, 1.67503],
        [6.963, 0, 1.67567],
        [6.965, 0, 1.67633],
        [6.968, 0, 1.67699],
        [6.971, 0, 1.67764],
        [6.973, 0, 1.67833],
        [6.976, 0, 1.67897],
        [6.979, 0, 1.67965],
        [6.981, 0, 1.68032],
        [6.984, 0, 1.68097],
        [6.987, 0, 1.68166],
        [6.989, 0, 1.68233],
        [6.992, 0, 1.68296],
        [6.995, 0, 1.68365],
        [6.997, 0, 1.68429],
        [7, 0, 1.68498],
        [7.003, 0, 1.68564],
        [7.005, 0, 1.68629],
        [7.008, 0, 1.68696],
        [7.011, 0, 1.68764],
        [7.013, 0, 1.68828],
        [7.016, 0, 1.68897],
        [7.019, 0, 1.68965],
        [7.021, 0, 1.69029],
        [7.024, 0, 1.69095],
        [7.027, 0, 1.69163],
        [7.029, 0, 1.6923],
        [7.032, 0, 1.69296],
        [7.035, 0, 1.69363],
        [7.037, 0, 1.69428],
        [7.04, 0, 1.69495],
        [7.043, 0, 1.69565],
        [7.045, 0, 1.69629],
        [7.048, 0, 1.69696],
        [7.051, 0, 1.69762],
        [7.053, 0, 1.69827],
        [7.056, 0, 1.69894],
        [7.059, 0, 1.69964],
        [7.061, 0, 1.7003],
        [7.064, 0, 1.70095],
        [7.067, 0, 1.70162],
        [7.069, 0, 1.70229],
        [7.072, 0, 1.70295],
        [7.075, 0, 1.70364],
        [7.077, 0, 1.70431],
        [7.08, 0, 1.70497],
        [7.083, 0, 1.70561],
        [7.085, 0, 1.7063],
        [7.088, 0, 1.70697],
        [7.091, 0, 1.70764],
        [7.093, 0, 1.70831],
        [7.096, 0, 1.70897],
        [7.099, 0, 1.70963],
        [7.101, 0, 1.7103],
        [7.104, 0, 1.71099],
        [7.107, 0, 1.71165],
        [7.109, 0, 1.7123],
        [7.112, 0, 1.71296],
        [7.115, 0, 1.71365],
        [7.117, 0, 1.71431],
        [7.12, 0, 1.71498],
        [7.123, 0, 1.71567],
        [7.125, 0, 1.71634],
        [7.128, 0, 1.71703],
        [7.131, 0, 1.71767],
        [7.133, 0, 1.71833],
        [7.136, 0, 1.71902],
        [7.139, 0, 1.71969],
        [7.141, 0, 1.72033],
        [7.144, 0, 1.72102],
        [7.147, 0, 1.72169],
        [7.149, 0, 1.72236],
        [7.152, 0, 1.72305],
        [7.155, 0, 1.72369],
        [7.157, 0, 1.72438],
        [7.16, 0, 1.72504],
        [7.163, 0, 1.72571],
        [7.165, 0, 1.72636],
        [7.168, 0, 1.72704],
        [7.171, 0, 1.72773],
        [7.173, 0, 1.72839],
        [7.176, 0, 1.72906],
        [7.179, 0, 1.72971],
        [7.181, 0, 1.73037],
        [7.184, 0, 1.73106],
        [7.187, 0, 1.73175],
        [7.189, 0, 1.73242],
        [7.192, 0, 1.73306],
        [7.195, 0, 1.73372],
        [7.197, 0, 1.73439],
        [7.2, 0, 1.7351],
        [7.203, 0, 1.73577],
        [7.205, 0, 1.7364],
        [7.208, 0, 1.73708],
        [7.211, 0, 1.73775],
        [7.213, 0, 1.73842],
        [7.216, 0, 1.73913],
        [7.219, 0, 1.73979],
        [7.221, 0, 1.74044],
        [7.224, 0, 1.74111],
        [7.227, 0, 1.74177],
        [7.229, 0, 1.74248],
        [7.232, 0, 1.74315],
        [7.235, 0, 1.74381],
        [7.237, 0, 1.74446],
        [7.24, 0, 1.74513],
        [7.243, 0, 1.74581],
        [7.245, 0, 1.7465],
        [7.248, 0, 1.74717],
        [7.251, 0, 1.74784],
        [7.253, 0, 1.7485],
        [7.256, 0, 1.74914],
        [7.259, 0, 1.74983],
        [7.261, 0, 1.75052],
        [7.264, 0, 1.75119],
        [7.267, 0, 1.75186],
        [7.269, 0, 1.75252],
        [7.272, 0, 1.75321],
        [7.275, 0, 1.75386],
        [7.277, 0, 1.75455],
        [7.28, 0, 1.75522],
        [7.283, 0, 1.75588],
        [7.285, 0, 1.75657],
        [7.288, 0, 1.75724],
        [7.291, 0, 1.75793],
        [7.293, 0, 1.7586],
        [7.296, 0, 1.75927],
        [7.299, 0, 1.75991],
        [7.301, 0, 1.76059],
        [7.304, 0, 1.76126],
        [7.307, 0, 1.76195],
        [7.309, 0, 1.76261],
        [7.312, 0, 1.76328],
        [7.315, 0, 1.76397],
        [7.317, 0, 1.76464],
        [7.32, 0, 1.76532],
        [7.323, 0, 1.766],
        [7.325, 0, 1.76664],
        [7.328, 0, 1.76733],
        [7.331, 0, 1.768],
        [7.333, 0, 1.76867],
        [7.336, 0, 1.76933],
        [7.339, 0, 1.77002],
        [7.341, 0, 1.77069],
        [7.344, 0, 1.77138],
        [7.347, 0, 1.77205],
        [7.349, 0, 1.77272],
        [7.352, 0, 1.7734],
        [7.355, 0, 1.77408],
        [7.357, 0, 1.77476],
        [7.36, 0, 1.77543],
        [7.363, 0, 1.7761],
        [7.365, 0, 1.77674],
        [7.368, 0, 1.77743],
        [7.371, 0, 1.77812],
        [7.373, 0, 1.77879],
        [7.376, 0, 1.77946],
        [7.379, 0, 1.78012],
        [7.381, 0, 1.78079],
        [7.384, 0, 1.7815],
        [7.387, 0, 1.78219],
        [7.389, 0, 1.78286],
        [7.392, 0, 1.78353],
        [7.395, 0, 1.78419],
        [7.397, 0, 1.78489],
        [7.4, 0, 1.78557],
        [7.403, 0, 1.78624],
        [7.405, 0, 1.78691],
        [7.408, 0, 1.78758],
        [7.411, 0, 1.78824],
        [7.413, 0, 1.78896],
        [7.416, 0, 1.78963],
        [7.419, 0, 1.7903],
        [7.421, 0, 1.79096],
        [7.424, 0, 1.79163],
        [7.427, 0, 1.79229],
        [7.429, 0, 1.793],
        [7.432, 0, 1.79367],
        [7.435, 0, 1.79435],
        [7.437, 0, 1.79501],
        [7.44, 0, 1.79568],
        [7.443, 0, 1.79639],
        [7.445, 0, 1.79706],
        [7.448, 0, 1.79773],
        [7.451, 0, 1.79839],
        [7.453, 0, 1.79905],
        [7.456, 0, 1.79975],
        [7.459, 0, 1.80044],
        [7.461, 0, 1.80111],
        [7.464, 0, 1.80178],
        [7.467, 0, 1.80244],
        [7.469, 0, 1.80312],
        [7.472, 0, 1.80383],
        [7.475, 0, 1.8045],
        [7.477, 0, 1.80516],
        [7.48, 0, 1.80583],
        [7.483, 0, 1.80649],
        [7.485, 0, 1.80718],
        [7.488, 0, 1.80787],
        [7.491, 0, 1.80857],
        [7.493, 0, 1.80924],
        [7.496, 0, 1.80991],
        [7.499, 0, 1.8106],
        [7.501, 0, 1.81129],
        [7.504, 0, 1.81196],
        [7.507, 0, 1.81262],
        [7.509, 0, 1.81329],
        [7.512, 0, 1.81395],
        [7.515, 0, 1.81464],
        [7.517, 0, 1.81533],
        [7.52, 0, 1.81601],
        [7.523, 0, 1.81667],
        [7.525, 0, 1.81735],
        [7.528, 0, 1.81803],
        [7.531, 0, 1.81875],
        [7.533, 0, 1.81942],
        [7.536, 0, 1.82008],
        [7.539, 0, 1.82075],
        [7.541, 0, 1.82144],
        [7.544, 0, 1.8221],
        [7.547, 0, 1.8228],
        [7.549, 0, 1.82346],
        [7.552, 0, 1.82414],
        [7.555, 0, 1.82481],
        [7.557, 0, 1.82552],
        [7.56, 0, 1.8262],
        [7.563, 0, 1.82687],
        [7.565, 0, 1.82754],
        [7.568, 0, 1.82822],
        [7.571, 0, 1.82891],
        [7.573, 0, 1.82958],
        [7.576, 0, 1.83027],
        [7.579, 0, 1.83093],
        [7.581, 0, 1.83162],
        [7.584, 0, 1.83232],
        [7.587, 0, 1.83298],
        [7.589, 0, 1.83367],
        [7.592, 0, 1.83435],
        [7.595, 0, 1.83501],
        [7.597, 0, 1.83568],
        [7.6, 0, 1.83637],
        [7.603, 0, 1.83707],
        [7.605, 0, 1.83775],
        [7.608, 0, 1.83842],
        [7.611, 0, 1.83909],
        [7.613, 0, 1.83978],
        [7.616, 0, 1.84044],
        [7.619, 0, 1.84116],
        [7.621, 0, 1.84183],
        [7.624, 0, 1.8425],
        [7.627, 0, 1.84318],
        [7.629, 0, 1.84385],
        [7.632, 0, 1.84453],
        [7.635, 0, 1.84522],
        [7.637, 0, 1.84591],
        [7.64, 0, 1.84658],
        [7.643, 0, 1.84727],
        [7.645, 0, 1.84794],
        [7.648, 0, 1.84863],
        [7.651, 0, 1.84932],
        [7.653, 0, 1.84998],
        [7.656, 0, 1.85068],
        [7.659, 0, 1.85135],
        [7.661, 0, 1.85202],
        [7.664, 0, 1.85271],
        [7.667, 0, 1.8534],
        [7.669, 0, 1.85409],
        [7.672, 0, 1.85476],
        [7.675, 0, 1.85545],
        [7.677, 0, 1.85615],
        [7.68, 0, 1.85684],
        [7.683, 0, 1.8575],
        [7.685, 0, 1.85819],
        [7.688, 0, 1.85887],
        [7.691, 0, 1.85956],
        [7.693, 0, 1.86025],
        [7.696, 0, 1.86091],
        [7.699, 0, 1.8616],
        [7.701, 0, 1.86227],
        [7.704, 0, 1.86296],
        [7.707, 0, 1.86366],
        [7.709, 0, 1.86432],
        [7.712, 0, 1.86501],
        [7.715, 0, 1.86568],
        [7.717, 0, 1.86638],
        [7.72, 0, 1.86707],
        [7.723, 0, 1.86774],
        [7.725, 0, 1.86841],
        [7.728, 0, 1.86913],
        [7.731, 0, 1.8698],
        [7.733, 0, 1.87046],
        [7.736, 0, 1.87116],
        [7.739, 0, 1.87185],
        [7.741, 0, 1.87253],
        [7.744, 0, 1.8732],
        [7.747, 0, 1.87388],
        [7.749, 0, 1.87459],
        [7.752, 0, 1.87526],
        [7.755, 0, 1.87595],
        [7.757, 0, 1.87662],
        [7.76, 0, 1.87731],
        [7.763, 0, 1.878],
        [7.765, 0, 1.87867],
        [7.768, 0, 1.87937],
        [7.771, 0, 1.88006],
        [7.773, 0, 1.88073],
        [7.776, 0, 1.88142],
        [7.779, 0, 1.88211],
        [7.781, 0, 1.88278],
        [7.784, 0, 1.88347],
        [7.787, 0, 1.88416],
        [7.789, 0, 1.88484],
        [7.792, 0, 1.88552],
        [7.795, 0, 1.88619],
        [7.797, 0, 1.8869],
        [7.8, 0, 1.88757],
        [7.803, 0, 1.88824],
        [7.805, 0, 1.88896],
        [7.808, 0, 1.88963],
        [7.811, 0, 1.8903],
        [7.813, 0, 1.89101],
        [7.816, 0, 1.89168],
        [7.819, 0, 1.89238],
        [7.821, 0, 1.89305],
        [7.824, 0, 1.89374],
        [7.827, 0, 1.89443],
        [7.829, 0, 1.89511],
        [7.832, 0, 1.89579],
        [7.835, 0, 1.89649],
        [7.837, 0, 1.89716],
        [7.84, 0, 1.89787],
        [7.843, 0, 1.89854],
        [7.845, 0, 1.89921],
        [7.848, 0, 1.89992],
        [7.851, 0, 1.90059],
        [7.853, 0, 1.90126],
        [7.856, 0, 1.90197],
        [7.859, 0, 1.90264],
        [7.861, 0, 1.90336],
        [7.864, 0, 1.90403],
        [7.867, 0, 1.9047],
        [7.869, 0, 1.90542],
        [7.872, 0, 1.90608],
        [7.875, 0, 1.90677],
        [7.877, 0, 1.90747],
        [7.88, 0, 1.90814],
        [7.883, 0, 1.90881],
        [7.885, 0, 1.90952],
        [7.888, 0, 1.91019],
        [7.891, 0, 1.91088],
        [7.893, 0, 1.91159],
        [7.896, 0, 1.91225],
        [7.899, 0, 1.91296],
        [7.901, 0, 1.91364],
        [7.904, 0, 1.91433],
        [7.907, 0, 1.91502],
        [7.909, 0, 1.91569],
        [7.912, 0, 1.9164],
        [7.915, 0, 1.91708],
        [7.917, 0, 1.91777],
        [7.92, 0, 1.91846],
        [7.923, 0, 1.91913],
        [7.925, 0, 1.91982],
        [7.928, 0, 1.92052],
        [7.931, 0, 1.9212],
        [7.933, 0, 1.9219],
        [7.936, 0, 1.92257],
        [7.939, 0, 1.92325],
        [7.941, 0, 1.92395],
        [7.944, 0, 1.92465],
        [7.947, 0, 1.92534],
        [7.949, 0, 1.92601],
        [7.952, 0, 1.9267],
        [7.955, 0, 1.9274],
        [7.957, 0, 1.92807],
        [7.96, 0, 1.92878],
        [7.963, 0, 1.92945],
        [7.965, 0, 1.93014],
        [7.968, 0, 1.9308],
        [7.971, 0, 1.93153],
        [7.973, 0, 1.93222],
        [7.976, 0, 1.93289],
        [7.979, 0, 1.93359],
        [7.981, 0, 1.93426],
        [7.984, 0, 1.93497],
        [7.987, 0, 1.93566],
        [7.989, 0, 1.93635],
        [7.992, 0, 1.93703],
        [7.995, 0, 1.93772],
        [7.997, 0, 1.93841],
    ])
    return spectrum


#SINQ Source Spectra


def PoldiSpectrum():
    spectrum = np.array([
        [0.00971506, 0.000243729],
        [0.021745, 0.000243148],
        [0.033775, 0.000241017],
        [0.045805, 0.000199556],
        [0.057835, 0.000239854],
        [0.069865, 0.00022048],
        [0.081895, 0.000217768],
        [0.0939367, 0.000222224],
        [0.105949, 0.000251091],
        [0.117991, 0.00025516],
        [0.130003, 0.00022978],
        [0.142045, 0.000201687],
        [0.154087, 0.000216218],
        [0.166099, 0.000215443],
        [0.178141, 0.000241404],
        [0.190153, 0.000206724],
        [0.202195, 0.00021738],
        [0.214237, 0.000208274],
        [0.226249, 0.000208855],
        [0.238291, 0.000211762],
        [0.250303, 0.000218155],
        [0.262345, 0.000200912],
        [0.274386, 0.000221061],
        [0.286399, 0.000204206],
        [0.298441, 0.00019355],
        [0.310453, 0.00023443],
        [0.322495, 0.000211955],
        [0.334536, 0.000190644],
        [0.346549, 0.000213893],
        [0.35859, 0.000202656],
        [0.370603, 0.000189288],
        [0.382645, 0.000173594],
        [0.394686, 0.000205174],
        [0.406699, 0.000211955],
        [0.41874, 0.000193162],
        [0.430753, 0.000197812],
        [0.442794, 0.000211374],
        [0.454836, 0.000186963],
        [0.466849, 0.000187737],
        [0.47889, 0.000209049],
        [0.490903, 0.000190837],
        [0.502944, 0.000187738],
        [0.514986, 0.000207887],
        [0.526999, 0.000186769],
        [0.53904, 0.000185413],
        [0.551053, 0.000192],
        [0.563094, 0.0001951],
        [0.575136, 0.000242954],
        [0.587148, 0.000234042],
        [0.59919, 0.000193356],
        [0.611203, 0.00022048],
        [0.623244, 0.00025671],
        [0.635286, 0.000244504],
        [0.647298, 0.000219705],
        [0.65934, 0.000260973],
        [0.671352, 0.000238692],
        [0.683394, 0.000257679],
        [0.695436, 0.000284416],
        [0.707448, 0.000332852],
        [0.71949, 0.000365207],
        [0.731502, 0.000352807],
        [0.743544, 0.000481453],
        [0.755586, 0.000541126],
        [0.767598, 0.000537639],
        [0.77964, 0.000646716],
        [0.791652, 0.000712977],
        [0.803694, 0.000852279],
        [0.815736, 0.000968525],
        [0.827748, 0.0010776],
        [0.83979, 0.00123531],
        [0.851802, 0.00143061],
        [0.863844, 0.00166],
        [0.875886, 0.00182546],
        [0.887898, 0.00211375],
        [0.89994, 0.00237511],
        [0.911952, 0.00277539],
        [0.923994, 0.00304585],
        [0.936036, 0.00344303],
        [0.948048, 0.00390027],
        [0.96009, 0.00459155],
        [0.972102, 0.00570442],
        [0.984144, 0.00759363],
        [0.996186, 0.0104649],
        [1.0082, 0.0159204],
        [1.02024, 0.0266057],
        [1.03225, 0.0479937],
        [1.04429, 0.0858774],
        [1.05634, 0.142667],
        [1.06835, 0.218867],
        [1.08039, 0.305255],
        [1.0924, 0.396427],
        [1.10444, 0.488961],
        [1.11649, 0.577206],
        [1.1285, 0.659524],
        [1.14054, 0.733843],
        [1.15255, 0.794993],
        [1.16459, 0.846995],
        [1.17664, 0.881863],
        [1.18865, 0.90427],
        [1.20069, 0.916761],
        [1.2127, 0.921056],
        [1.22474, 0.923999],
        [1.23679, 0.929294],
        [1.2488, 0.935595],
        [1.26084, 0.945733],
        [1.27285, 0.95259],
        [1.28489, 0.958808],
        [1.29694, 0.968338],
        [1.30895, 0.97099],
        [1.32099, 0.97887],
        [1.333, 0.982081],
        [1.34504, 0.986929],
        [1.35709, 0.98887],
        [1.3691, 0.991972],
        [1.38114, 0.995222],
        [1.39315, 0.997374],
        [1.40519, 0.998328],
        [1.41724, 1],
        [1.42925, 0.99885],
        [1.44129, 0.997056],
        [1.4533, 0.999715],
        [1.46534, 0.997709],
        [1.47738, 0.993649],
        [1.4894, 0.988288],
        [1.50144, 0.982113],
        [1.51345, 0.976117],
        [1.52549, 0.967625],
        [1.53753, 0.960948],
        [1.54955, 0.949309],
        [1.56159, 0.940839],
        [1.5736, 0.932085],
        [1.58564, 0.925758],
        [1.59768, 0.913891],
        [1.6097, 0.902356],
        [1.62174, 0.888444],
        [1.63375, 0.874186],
        [1.64579, 0.860296],
        [1.65783, 0.848029],
        [1.66985, 0.837907],
        [1.68189, 0.827476],
        [1.6939, 0.814445],
        [1.70594, 0.8031],
        [1.71798, 0.792108],
        [1.73, 0.780664],
        [1.74204, 0.776089],
        [1.75405, 0.770506],
        [1.76609, 0.764428],
        [1.77813, 0.760838],
        [1.79015, 0.755058],
        [1.80219, 0.751402],
        [1.8142, 0.747775],
        [1.82624, 0.745413],
        [1.83828, 0.74091],
        [1.8503, 0.735381],
        [1.86234, 0.731349],
        [1.87435, 0.726626],
        [1.88639, 0.716629],
        [1.89843, 0.706469],
        [1.91045, 0.696303],
        [1.92249, 0.687731],
        [1.9345, 0.674269],
        [1.94654, 0.665337],
        [1.95858, 0.654878],
        [1.9706, 0.645568],
        [1.98264, 0.633657],
        [1.99465, 0.620828],
        [2.00669, 0.608944],
        [2.01873, 0.596326],
        [2.03075, 0.590185],
        [2.04279, 0.58533],
        [2.0548, 0.577747],
        [2.06684, 0.570025],
        [2.07888, 0.560005],
        [2.0909, 0.546631],
        [2.10294, 0.535221],
        [2.11495, 0.52613],
        [2.12699, 0.517127],
        [2.13903, 0.510098],
        [2.15105, 0.503394],
        [2.16309, 0.497185],
        [2.1751, 0.492095],
        [2.18714, 0.483586],
        [2.19918, 0.474388],
        [2.2112, 0.467334],
        [2.22324, 0.457725],
        [2.23525, 0.449695],
        [2.24729, 0.440214],
        [2.25933, 0.431908],
        [2.27135, 0.423412],
        [2.28339, 0.416938],
        [2.2954, 0.408795],
        [2.30744, 0.399538],
        [2.31948, 0.388324],
        [2.3315, 0.378374],
        [2.34354, 0.374918],
        [2.35555, 0.374369],
        [2.36759, 0.370529],
        [2.37963, 0.365652],
        [2.39165, 0.361122],
        [2.40369, 0.35602],
        [2.4157, 0.350266],
        [2.42774, 0.346407],
        [2.43978, 0.345786],
        [2.4518, 0.345563],
        [2.46384, 0.343137],
        [2.47585, 0.338568],
        [2.48789, 0.334202],
        [2.49993, 0.328702],
        [2.51195, 0.324005],
        [2.52399, 0.317837],
        [2.536, 0.314304],
        [2.54804, 0.310638],
        [2.56008, 0.306066],
        [2.5721, 0.299757],
        [2.58414, 0.2969],
        [2.59615, 0.290551],
        [2.60819, 0.287059],
        [2.62023, 0.281666],
        [2.63225, 0.277169],
        [2.64429, 0.272872],
        [2.6563, 0.267066],
        [2.66834, 0.262975],
        [2.68038, 0.257925],
        [2.6924, 0.252738],
        [2.70444, 0.249561],
        [2.71645, 0.244503],
        [2.72849, 0.240234],
        [2.74053, 0.236911],
        [2.75255, 0.231618],
        [2.76459, 0.227636],
        [2.7766, 0.223759],
        [2.78864, 0.219501],
        [2.80068, 0.215279],
        [2.8127, 0.210238],
        [2.82474, 0.207213],
        [2.83675, 0.200867],
        [2.84879, 0.199527],
        [2.86083, 0.199615],
        [2.87285, 0.200553],
        [2.88489, 0.198681],
        [2.8969, 0.197503],
        [2.90894, 0.194108],
        [2.92098, 0.19143],
        [2.933, 0.189495],
        [2.94504, 0.186434],
        [2.95705, 0.184519],
        [2.96909, 0.182303],
        [2.98113, 0.179412],
        [2.99315, 0.178094],
        [3.00519, 0.17488],
        [3.0172, 0.172228],
        [3.02924, 0.169234],
        [3.04128, 0.166441],
        [3.0533, 0.164398],
        [3.06534, 0.162099],
        [3.07735, 0.158677],
        [3.08939, 0.156792],
        [3.10143, 0.154188],
        [3.11345, 0.151548],
        [3.12549, 0.148921],
        [3.1375, 0.145905],
        [3.14954, 0.143916],
        [3.16158, 0.14155],
        [3.1736, 0.139652],
        [3.18564, 0.136819],
        [3.19765, 0.135135],
        [3.20969, 0.131938],
        [3.22173, 0.129312],
        [3.23374, 0.127314],
        [3.24579, 0.124997],
        [3.2578, 0.123539],
        [3.26984, 0.120672],
        [3.28188, 0.118742],
        [3.29389, 0.117334],
        [3.30594, 0.115293],
        [3.31795, 0.113745],
        [3.32999, 0.111867],
        [3.34203, 0.109626],
        [3.35404, 0.108128],
        [3.36609, 0.107246],
        [3.3781, 0.10512],
        [3.39014, 0.102976],
        [3.40218, 0.101722],
        [3.41419, 0.100623],
        [3.42624, 0.0985129],
        [3.43825, 0.0977306],
        [3.45029, 0.0956244],
        [3.46233, 0.0944359],
        [3.47434, 0.0934434],
        [3.48639, 0.0914077],
        [3.4984, 0.0904703],
        [3.51044, 0.0890994],
        [3.52248, 0.0877742],
        [3.53449, 0.0871166],
        [3.54654, 0.0850898],
        [3.55855, 0.0841022],
        [3.57059, 0.0828926],
        [3.58263, 0.0821617],
        [3.59464, 0.0806414],
        [3.60669, 0.0789516],
        [3.6187, 0.0778006],
        [3.63074, 0.0763145],
        [3.64278, 0.0751517],
        [3.65479, 0.0736421],
        [3.66684, 0.072513],
        [3.67885, 0.0715682],
        [3.69089, 0.0708887],
        [3.70293, 0.0693734],
        [3.71494, 0.0684487],
        [3.72699, 0.0677198],
        [3.739, 0.0667174],
        [3.75104, 0.0658404],
        [3.76308, 0.0647766],
        [3.77509, 0.0636816],
        [3.78714, 0.0622564],
        [3.79915, 0.0612357],
        [3.81119, 0.0603873],
        [3.82323, 0.0597233],
        [3.83524, 0.0581731],
        [3.84729, 0.0570456],
        [3.8593, 0.0565926],
        [3.87134, 0.0555375],
        [3.88338, 0.0543983],
        [3.89539, 0.0534061],
        [3.90744, 0.0531172],
        [3.91945, 0.0515416],
        [3.93149, 0.0505361],
        [3.94353, 0.0487193],
        [3.95554, 0.0478572],
        [3.96759, 0.0467406],
        [3.9796, 0.0457847],
        [3.99164, 0.0441114],
        [4.00368, 0.0417557],
        [4.01569, 0.0407117],
        [4.02774, 0.0420064],
        [4.03975, 0.0447121],
        [4.05179, 0.0472886],
        [4.06383, 0.0468586],
        [4.07584, 0.0467991],
        [4.08789, 0.0462359],
        [4.0999, 0.0460094],
        [4.11194, 0.0445673],
        [4.12398, 0.0441156],
        [4.13599, 0.0432425],
        [4.14804, 0.043062],
        [4.16005, 0.0423358],
        [4.17209, 0.0418905],
        [4.18413, 0.0412192],
        [4.19614, 0.0408266],
        [4.20819, 0.04016],
        [4.2202, 0.0395766],
        [4.23224, 0.0390859],
        [4.24428, 0.0386901],
        [4.25629, 0.0387263],
        [4.26834, 0.0376207],
        [4.28035, 0.0374704],
        [4.29239, 0.0368832],
        [4.30443, 0.0366863],
        [4.31644, 0.0362493],
        [4.32849, 0.0358172],
        [4.3405, 0.035652],
        [4.35254, 0.0347864],
        [4.36458, 0.0349343],
        [4.37659, 0.0343453],
        [4.38864, 0.0338293],
        [4.40065, 0.0337214],
        [4.41269, 0.0334068],
        [4.42473, 0.0331102],
        [4.43674, 0.0323793],
        [4.44879, 0.0321439],
        [4.4608, 0.0315218],
        [4.47284, 0.0311736],
        [4.48488, 0.0308031],
        [4.49689, 0.0305577],
        [4.50894, 0.0300519],
        [4.52095, 0.0296385],
        [4.53299, 0.0294073],
        [4.54503, 0.0295066],
        [4.55704, 0.0287577],
        [4.56909, 0.0283343],
        [4.5811, 0.0276883],
        [4.59314, 0.027162],
        [4.60518, 0.0266026],
        [4.61719, 0.0247652],
        [4.62923, 0.0217263],
        [4.64125, 0.0207132],
        [4.65329, 0.0230745],
        [4.66533, 0.0256269],
        [4.67734, 0.0262261],
        [4.68938, 0.0265951],
        [4.7014, 0.0258131],
        [4.71344, 0.025693],
        [4.72548, 0.0252754],
        [4.73749, 0.0248884],
        [4.74953, 0.0245373],
        [4.76155, 0.0244727],
        [4.77359, 0.0241224],
        [4.78563, 0.0236518],
        [4.79764, 0.0236371],
        [4.80968, 0.0231795],
        [4.8217, 0.0229085],
        [4.83374, 0.0224832],
        [4.84578, 0.0220516],
        [4.85779, 0.0221457],
        [4.86983, 0.0217377],
        [4.88185, 0.0215305],
        [4.89389, 0.0213814],
        [4.90593, 0.0208312],
        [4.91794, 0.0207061],
        [4.92998, 0.0204094],
        [4.942, 0.0201731],
        [4.95404, 0.0200872],
        [4.96608, 0.0196027],
        [4.97809, 0.0195778],
        [4.99013, 0.0194235],
        [5.00215, 0.0189628],
        [5.01419, 0.0187248],
        [5.02623, 0.0187658],
        [5.03824, 0.0181844],
        [5.05028, 0.0179203],
        [5.0623, 0.017902],
        [5.07434, 0.0178238],
        [5.08638, 0.0174469],
        [5.09839, 0.0173478],
        [5.11043, 0.0172815],
        [5.12245, 0.0166515],
        [5.13449, 0.0165574],
        [5.14653, 0.0164265],
        [5.15854, 0.0164748],
        [5.17058, 0.0160425],
        [5.1826, 0.0161236],
        [5.19464, 0.0156638],
        [5.20668, 0.0155281],
        [5.21869, 0.0151994],
        [5.23073, 0.0150158],
        [5.24275, 0.0149603],
        [5.25479, 0.0147813],
        [5.26683, 0.0146079],
        [5.27884, 0.0145221],
        [5.29088, 0.0142499],
        [5.3029, 0.0141546],
        [5.31494, 0.0139238],
        [5.32698, 0.0138035],
        [5.33899, 0.0136444],
        [5.35103, 0.0135729],
        [5.36305, 0.0130644],
        [5.37509, 0.0132663],
        [5.38713, 0.0131149],
        [5.39914, 0.012902],
        [5.41118, 0.0126622],
        [5.4232, 0.0126626],
        [5.43524, 0.0123228],
        [5.44728, 0.0124699],
        [5.45929, 0.0122494],
        [5.47133, 0.0121176],
        [5.48335, 0.0117617],
        [5.49539, 0.0117835],
        [5.50743, 0.0117317],
        [5.51944, 0.0115569],
        [5.53148, 0.0114589],
        [5.5435, 0.0112254],
        [5.55554, 0.0111797],
        [5.56758, 0.0113244],
        [5.57959, 0.0108814],
        [5.59163, 0.0108167],
        [5.60365, 0.0106162],
        [5.61569, 0.0104271],
        [5.62773, 0.0103034],
        [5.63974, 0.0101657],
        [5.65178, 0.0101127],
        [5.6638, 0.0102004],
        [5.67584, 0.0101575],
        [5.68788, 0.00974979],
        [5.69989, 0.00983649],
        [5.71193, 0.00957236],
        [5.72395, 0.0096794],
        [5.73599, 0.00948896],
        [5.74803, 0.00931874],
        [5.76004, 0.00918174],
        [5.77208, 0.00900421],
        [5.7841, 0.00909665],
        [5.79614, 0.00892604],
        [5.80818, 0.00890187],
        [5.82019, 0.00885013],
        [5.83223, 0.00857482],
        [5.84425, 0.00855195],
        [5.85629, 0.00868853],
        [5.86833, 0.00855513],
        [5.88034, 0.00829785],
        [5.89238, 0.00829522],
        [5.9044, 0.00821625],
        [5.91644, 0.00813726],
        [5.92848, 0.00802448],
        [5.94049, 0.00803157],
        [5.95253, 0.00780761],
        [5.96455, 0.00776803],
        [5.97659, 0.00763699],
        [5.98863, 0.00749987],
        [6.00064, 0.00751351],
        [6.01268, 0.00748721],
        [6.0247, 0.00715293],
        [6.03674, 0.00717775],
        [6.04878, 0.00715042],
        [6.06079, 0.00711067],
        [6.07283, 0.0071566],
        [6.08485, 0.00681315],
        [6.09689, 0.00689824],
        [6.10893, 0.00672261],
        [6.12094, 0.00669555],
        [6.13298, 0.00658162],
        [6.145, 0.0065349],
        [6.15704, 0.00647178],
        [6.16908, 0.00653563],
        [6.18109, 0.00646139],
        [6.19313, 0.00650759],
        [6.20515, 0.00619805],
        [6.21719, 0.00624817],
        [6.22923, 0.00611556],
        [6.24124, 0.00631593],
        [6.25328, 0.00612824],
        [6.2653, 0.00599071],
        [6.27734, 0.00579188],
        [6.28938, 0.0058677],
        [6.30139, 0.00571509],
        [6.31343, 0.00572433],
        [6.32545, 0.00577097],
        [6.33749, 0.00566193],
        [6.34953, 0.005635],
        [6.36154, 0.005619],
        [6.37358, 0.00539598],
        [6.3856, 0.00543607],
        [6.39764, 0.00545144],
        [6.40968, 0.00515645],
        [6.42169, 0.00539719],
        [6.43373, 0.00511706],
        [6.44574, 0.00518624],
        [6.45779, 0.00510015],
        [6.46983, 0.00505854],
        [6.48184, 0.00517977],
        [6.49388, 0.00492955],
        [6.50589, 0.00489383],
        [6.51794, 0.00486705],
        [6.52998, 0.00488026],
        [6.54199, 0.00473543],
        [6.55403, 0.00483859],
        [6.56604, 0.00467527],
        [6.57809, 0.00469328],
        [6.59013, 0.00472978],
        [6.60214, 0.00457759],
        [6.61418, 0.00438978],
        [6.62619, 0.00452382],
        [6.63824, 0.00438263],
        [6.65028, 0.00445128],
        [6.66229, 0.00433707],
        [6.67433, 0.00423332],
        [6.68634, 0.00426564],
        [6.69839, 0.00420817],
        [6.71043, 0.00416666],
        [6.72244, 0.00406838],
        [6.73448, 0.00405712],
        [6.74649, 0.00412564],
        [6.75854, 0.00402198],
        [6.77058, 0.00401097],
        [6.78259, 0.00375424],
        [6.79463, 0.00390572],
        [6.80664, 0.00387137],
        [6.81869, 0.00374604],
        [6.83073, 0.00377383],
        [6.84274, 0.00366743],
        [6.85478, 0.00363313],
        [6.86679, 0.00370078],
        [6.87884, 0.00368592],
        [6.89088, 0.00363462],
        [6.90289, 0.00367894],
        [6.91493, 0.00353476],
        [6.92694, 0.00338814],
        [6.93899, 0.00349525],
        [6.95103, 0.00348213],
        [6.96304, 0.00347575],
        [6.97508, 0.00336021],
        [6.98709, 0.0033614],
        [6.99914, 0.00338287],
        [7.01118, 0.0033054],
        [7.02319, 0.00315905],
        [7.03523, 0.00322219],
        [7.04724, 0.00325297],
        [7.05929, 0.00314506],
        [7.07133, 0.00323705],
        [7.08334, 0.00316316],
        [7.09538, 0.00306254],
        [7.10739, 0.00305981],
        [7.11944, 0.00309988],
        [7.13148, 0.00305888],
        [7.14349, 0.00301184],
        [7.15553, 0.00298106],
        [7.16754, 0.00298486],
        [7.17959, 0.00286119],
        [7.19163, 0.00284617],
        [7.20364, 0.00288099],
        [7.21568, 0.0028702],
        [7.22769, 0.00284362],
        [7.23974, 0.00278268],
        [7.25178, 0.00278492],
        [7.26379, 0.00287318],
        [7.27583, 0.00276477],
        [7.28784, 0.00270012],
        [7.29989, 0.00272865],
        [7.31193, 0.00266876],
        [7.32394, 0.00259964],
        [7.33598, 0.00261137],
        [7.34799, 0.00258375],
        [7.36004, 0.00247014],
        [7.37208, 0.002568],
        [7.38409, 0.00253568],
        [7.39613, 0.00256933],
        [7.40814, 0.00245956],
        [7.42019, 0.00249305],
        [7.43223, 0.00247611],
        [7.44424, 0.00243489],
        [7.45628, 0.00243195],
        [7.46829, 0.00242687],
        [7.48034, 0.00228432],
        [7.49238, 0.00238575],
        [7.50439, 0.00234883],
        [7.51643, 0.00234017],
        [7.52844, 0.00235506],
        [7.54049, 0.002232],
        [7.55253, 0.00219428],
        [7.56454, 0.0020901],
        [7.57658, 0.00220844],
        [7.58859, 0.00216194],
        [7.60064, 0.00212509],
        [7.61268, 0.00207418],
        [7.62469, 0.00206083],
        [7.63673, 0.0021016],
        [7.64874, 0.00208714],
        [7.66078, 0.002011],
        [7.67283, 0.00197498],
        [7.68484, 0.00210107],
        [7.69688, 0.00202153],
        [7.70889, 0.0020016],
        [7.72093, 0.0019537],
        [7.73298, 0.00193977],
        [7.74499, 0.00196738],
        [7.75703, 0.00198212],
        [7.76904, 0.00198968],
        [7.78108, 0.0019368],
        [7.79313, 0.00190056],
        [7.80514, 0.00186082],
        [7.81718, 0.00185444],
        [7.82919, 0.00184842],
        [7.84123, 0.00180483],
        [7.85328, 0.00176833],
        [7.86529, 0.00186038],
        [7.87733, 0.00182098],
        [7.88934, 0.001745],
        [7.90138, 0.00171698],
        [7.91343, 0.00173615],
        [7.92544, 0.00169629],
        [7.93748, 0.00169958],
        [7.94949, 0.00175214],
        [7.96153, 0.00173687],
        [7.97358, 0.00168613],
        [7.98559, 0.00171272],
        [7.99763, 0.0016583],
        [8.00964, 0.00163202],
        [8.02168, 0.00160322],
        [8.03373, 0.00159222],
        [8.04574, 0.00147613],
        [8.05778, 0.00164691],
        [8.06979, 0.00151132],
        [8.08183, 0.00149235],
        [8.09388, 0.00155905],
        [8.10589, 0.00156511],
        [8.11793, 0.00150952],
        [8.12994, 0.00147326],
        [8.14198, 0.00151699],
        [8.15403, 0.00148551],
        [8.16604, 0.00146875],
        [8.17808, 0.00144654],
        [8.19009, 0.00142719],
        [8.20213, 0.00143981],
        [8.21418, 0.00140556],
        [8.22619, 0.00137989],
        [8.23823, 0.00140295],
        [8.25024, 0.00139912],
        [8.26228, 0.00136667],
        [8.27433, 0.00132143],
        [8.28634, 0.00134999],
        [8.29838, 0.00132167],
    ])
    return spectrum


def BoaSpectrum():
    spectrum = np.array([
        [0.78878, 0],
        [0.81036, 0],
        [0.83194, 0.00028697],
        [0.85351, 0.0022001],
        [0.87509, 0.003635],
        [0.89667, 0.0011479],
        [0.91825, 0.0023914],
        [0.93983, 0.0059307],
        [0.96141, 0.0084178],
        [0.98298, 0.0046872],
        [1.0046, 0.0088005],
        [1.0261, 0.011861],
        [1.0477, 0.015783],
        [1.0693, 0.021332],
        [1.0909, 0.031949],
        [1.1125, 0.038837],
        [1.134, 0.040654],
        [1.1556, 0.040559],
        [1.1772, 0.044863],
        [1.1988, 0.056342],
        [1.2203, 0.064664],
        [1.2419, 0.081596],
        [1.2635, 0.083126],
        [1.2851, 0.086857],
        [1.3067, 0.099675],
        [1.3282, 0.11259],
        [1.3498, 0.12598],
        [1.3714, 0.12627],
        [1.393, 0.13909],
        [1.4146, 0.15324],
        [1.4361, 0.16903],
        [1.4577, 0.17132],
        [1.4793, 0.18165],
        [1.5009, 0.18557],
        [1.5224, 0.1917],
        [1.544, 0.207],
        [1.5656, 0.21647],
        [1.5872, 0.23293],
        [1.6088, 0.2532],
        [1.6303, 0.25875],
        [1.6519, 0.27368],
        [1.6735, 0.29328],
        [1.6951, 0.29175],
        [1.7166, 0.30639],
        [1.7382, 0.3304],
        [1.7598, 0.34035],
        [1.7814, 0.35259],
        [1.803, 0.3722],
        [1.8245, 0.39344],
        [1.8461, 0.41305],
        [1.8677, 0.43132],
        [1.8893, 0.45169],
        [1.9109, 0.43888],
        [1.9324, 0.46977],
        [1.954, 0.46872],
        [1.9756, 0.50182],
        [1.9972, 0.52822],
        [2.0187, 0.51684],
        [2.0403, 0.54993],
        [2.0619, 0.56112],
        [2.0835, 0.57069],
        [2.1051, 0.58427],
        [2.1266, 0.61661],
        [2.1482, 0.63775],
        [2.1698, 0.65209],
        [2.1914, 0.68672],
        [2.213, 0.69399],
        [2.2345, 0.72183],
        [2.2561, 0.74364],
        [2.2777, 0.74976],
        [2.2993, 0.76564],
        [2.3208, 0.77874],
        [2.3424, 0.80314],
        [2.364, 0.80113],
        [2.3856, 0.8391],
        [2.4072, 0.85498],
        [2.4287, 0.87632],
        [2.4503, 0.8789],
        [2.4719, 0.90511],
        [2.4935, 0.92797],
        [2.515, 0.93687],
        [2.5366, 0.94241],
        [2.5582, 0.95868],
        [2.5798, 0.97197],
        [2.6014, 0.96442],
        [2.6229, 0.97408],
        [2.6445, 0.95973],
        [2.6661, 0.95782],
        [2.6877, 0.96872],
        [2.7093, 0.97063],
        [2.7308, 0.96719],
        [2.7524, 0.97092],
        [2.774, 0.95093],
        [2.7956, 0.97723],
        [2.8171, 0.9955],
        [2.8387, 0.97972],
        [2.8603, 0.96729],
        [2.8819, 0.97389],
        [2.9035, 0.97054],
        [2.925, 0.98881],
        [2.9466, 1],
        [2.9682, 0.97398],
        [2.9898, 0.98747],
        [3.0114, 0.97647],
        [3.0329, 0.98345],
        [3.0545, 0.98967],
        [3.0761, 0.95284],
        [3.0977, 0.95657],
        [3.1192, 0.96088],
        [3.1408, 0.93036],
        [3.1624, 0.92682],
        [3.184, 0.90893],
        [3.2056, 0.9207],
        [3.2271, 0.9097],
        [3.2487, 0.90922],
        [3.2703, 0.90951],
        [3.2919, 0.87861],
        [3.3134, 0.88894],
        [3.335, 0.89277],
        [3.3566, 0.89573],
        [3.3782, 0.87278],
        [3.3998, 0.84484],
        [3.4213, 0.84838],
        [3.4429, 0.83834],
        [3.4645, 0.85058],
        [3.4861, 0.83155],
        [3.5077, 0.82944],
        [3.5292, 0.82016],
        [3.5508, 0.81462],
        [3.5724, 0.80486],
        [3.594, 0.81022],
        [3.6155, 0.78764],
        [3.6371, 0.78152],
        [3.6587, 0.74699],
        [3.6803, 0.7444],
        [3.7019, 0.73924],
        [3.7234, 0.7335],
        [3.745, 0.72087],
        [3.7666, 0.74536],
        [3.7882, 0.70471],
        [3.8098, 0.70719],
        [3.8313, 0.69256],
        [3.8529, 0.685],
        [3.8745, 0.68787],
        [3.8961, 0.66807],
        [3.9176, 0.65611],
        [3.9392, 0.64243],
        [3.9608, 0.64033],
        [3.9824, 0.62244],
        [4.004, 0.60245],
        [4.0255, 0.59614],
        [4.0471, 0.60321],
        [4.0687, 0.61488],
        [4.0903, 0.63889],
        [4.1118, 0.62694],
        [4.1334, 0.63277],
        [4.155, 0.62598],
        [4.1766, 0.61134],
        [4.1982, 0.61909],
        [4.2197, 0.60101],
        [4.2413, 0.58561],
        [4.2629, 0.59843],
        [4.2845, 0.5661],
        [4.3061, 0.57375],
        [4.3276, 0.56447],
        [4.3492, 0.54285],
        [4.3708, 0.53329],
        [4.3924, 0.52831],
        [4.4139, 0.53501],
        [4.4355, 0.51645],
        [4.4571, 0.50344],
        [4.4787, 0.52583],
        [4.5003, 0.49168],
        [4.5218, 0.48297],
        [4.5434, 0.48603],
        [4.565, 0.47169],
        [4.5866, 0.46824],
        [4.6082, 0.46642],
        [4.6297, 0.45131],
        [4.6513, 0.46068],
        [4.6729, 0.46384],
        [4.6945, 0.46432],
        [4.716, 0.46709],
        [4.7376, 0.45418],
        [4.7592, 0.44777],
        [4.7808, 0.44691],
        [4.8024, 0.44146],
        [4.8239, 0.43381],
        [4.8455, 0.4252],
        [4.8671, 0.42166],
        [4.8887, 0.41955],
        [4.9102, 0.41974],
        [4.9318, 0.40205],
        [4.9534, 0.40549],
        [4.975, 0.40348],
        [4.9966, 0.40501],
        [5.0181, 0.38789],
        [5.0397, 0.38215],
        [5.0613, 0.37832],
        [5.0829, 0.37383],
        [5.1045, 0.37306],
        [5.126, 0.37153],
        [5.1476, 0.37871],
        [5.1692, 0.36598],
        [5.1908, 0.36723],
        [5.2123, 0.34561],
        [5.2339, 0.35259],
        [5.2555, 0.36187],
        [5.2771, 0.34207],
        [5.2987, 0.33518],
        [5.3202, 0.32552],
        [5.3418, 0.33337],
        [5.3634, 0.32122],
        [5.385, 0.32236],
        [5.4065, 0.31663],
        [5.4281, 0.31328],
        [5.4497, 0.29663],
        [5.4713, 0.30036],
        [5.4929, 0.28716],
        [5.5144, 0.2908],
        [5.536, 0.28525],
        [5.5576, 0.28372],
        [5.5792, 0.27884],
        [5.6008, 0.27874],
        [5.6223, 0.26956],
        [5.6439, 0.26401],
        [5.6655, 0.26564],
        [5.6871, 0.26315],
        [5.7086, 0.2598],
        [5.7302, 0.24928],
        [5.7518, 0.2511],
        [5.7734, 0.2401],
        [5.795, 0.2467],
        [5.8165, 0.24584],
        [5.8381, 0.2444],
        [5.8597, 0.238],
        [5.8813, 0.22747],
        [5.9029, 0.22958],
        [5.9244, 0.22891],
        [5.946, 0.21848],
        [5.9676, 0.21599],
        [5.9892, 0.21925],
        [6.0107, 0.22164],
        [6.0323, 0.20595],
        [6.0539, 0.20949],
        [6.0755, 0.20212],
        [6.0971, 0.20078],
        [6.1186, 0.2026],
        [6.1402, 0.19581],
        [6.1618, 0.20212],
        [6.1834, 0.19093],
        [6.2049, 0.19208],
        [6.2265, 0.18089],
        [6.2481, 0.18462],
        [6.2697, 0.18797],
        [6.2913, 0.17467],
        [6.3128, 0.17324],
        [6.3344, 0.1762],
        [6.356, 0.17658],
        [6.3776, 0.17897],
        [6.3992, 0.17716],
        [6.4207, 0.17381],
        [6.4423, 0.16549],
        [6.4639, 0.16797],
        [6.4855, 0.16003],
        [6.507, 0.17008],
        [6.5286, 0.15956],
        [6.5502, 0.15678],
        [6.5718, 0.15487],
        [6.5934, 0.14942],
        [6.6149, 0.14626],
        [6.6365, 0.14999],
        [6.6581, 0.14224],
        [6.6797, 0.13631],
        [6.7013, 0.15171],
        [6.7228, 0.13277],
        [6.7444, 0.13029],
        [6.766, 0.13335],
        [6.7876, 0.1299],
        [6.8091, 0.13134],
        [6.8307, 0.12349],
        [6.8523, 0.12388],
        [6.8739, 0.13],
        [6.8955, 0.11661],
        [6.917, 0.12789],
        [6.9386, 0.11861],
        [6.9602, 0.11144],
        [6.9818, 0.11861],
        [7.0033, 0.11536],
        [7.0249, 0.11909],
        [7.0465, 0.10771],
        [7.0681, 0.1079],
        [7.0897, 0.10321],
        [7.1112, 0.10943],
        [7.1328, 0.10207],
        [7.1544, 0.10312],
        [7.176, 0.10522],
        [7.1976, 0.10446],
        [7.2191, 0.094318],
        [7.2407, 0.092883],
        [7.2623, 0.092787],
        [7.2839, 0.096518],
        [7.3054, 0.084178],
        [7.327, 0.093361],
        [7.3486, 0.085996],
        [7.3702, 0.077578],
        [7.3918, 0.082074],
        [7.4133, 0.081596],
        [7.4349, 0.083604],
        [7.4565, 0.073752],
        [7.4781, 0.078917],
        [7.4997, 0.07576],
        [7.5212, 0.081883],
        [7.5428, 0.075378],
        [7.5644, 0.071456],
        [7.586, 0.068299],
        [7.6075, 0.067056],
        [7.6291, 0.072126],
        [7.6507, 0.069734],
        [7.6723, 0.065812],
        [7.6939, 0.06476],
        [7.7154, 0.066099],
        [7.737, 0.063516],
        [7.7586, 0.066577],
        [7.7802, 0.062847],
        [7.8017, 0.064856],
        [7.8233, 0.062082],
        [7.8449, 0.053664],
        [7.8665, 0.062368],
        [7.8881, 0.058829],
        [7.9096, 0.056629],
        [7.9312, 0.054333],
        [7.9528, 0.055768],
        [7.9744, 0.055385],
        [7.996, 0.052898],
        [8.0175, 0.053472],
        [8.0391, 0.049359],
        [8.0607, 0.049455],
        [8.0823, 0.047446],
        [8.1038, 0.049742],
        [8.1254, 0.050316],
        [8.147, 0.050316],
        [8.1686, 0.043715],
        [8.1902, 0.045724],
        [8.2117, 0.040846],
        [8.2333, 0.040176],
        [8.2549, 0.047159],
        [8.2765, 0.045437],
        [8.2981, 0.04075],
        [8.3196, 0.037498],
        [8.3412, 0.046298],
        [8.3628, 0.036254],
        [8.3844, 0.035967],
        [8.4059, 0.037115],
        [8.4275, 0.033384],
        [8.4491, 0.038359],
        [8.4707, 0.039219],
        [8.4923, 0.034628],
        [8.5138, 0.037785],
        [8.5354, 0.034915],
        [8.557, 0.037306],
        [8.5786, 0.033863],
        [8.6001, 0.035202],
        [8.6217, 0.03568],
        [8.6433, 0.034628],
        [8.6649, 0.026593],
        [8.6865, 0.032523],
        [8.708, 0.032045],
        [8.7296, 0.026401],
        [8.7512, 0.027071],
        [8.7728, 0.027071],
        [8.7944, 0.026019],
        [8.8159, 0.028506],
        [8.8375, 0.025062],
        [8.8591, 0.025732],
        [8.8807, 0.025732],
        [8.9022, 0.028601],
        [8.9238, 0.026306],
        [8.9454, 0.027071],
        [8.967, 0.023723],
        [8.9886, 0.022958],
        [9.0101, 0.025062],
        [9.0317, 0.026019],
        [9.0533, 0.022288],
        [9.0749, 0.021523],
        [9.0964, 0.024297],
        [9.118, 0.02181],
        [9.1396, 0.017697],
        [9.1612, 0.022192],
        [9.1828, 0.018557],
        [9.2043, 0.019514],
        [9.2259, 0.020566],
        [9.2475, 0.020758],
        [9.2691, 0.019992],
        [9.2907, 0.021714],
        [9.3122, 0.01961],
        [9.3338, 0.020662],
        [9.3554, 0.015783],
        [9.377, 0.020758],
        [9.3985, 0.020088],
        [9.3985, 0.020088],
    ])
    return spectrum


def IconSpectrum():
    spectrum = np.array([
        [0.39199, 0.34942],
        [0.4113, 0.34168],
        [0.43061, 0.33452],
        [0.44992, 0.31243],
        [0.46924, 0.27315],
        [0.48855, 0.2632],
        [0.50786, 0.244],
        [0.52717, 0.24753],
        [0.54648, 0.24834],
        [0.56579, 0.22906],
        [0.5851, 0.24989],
        [0.60441, 0.23223],
        [0.62373, 0.24347],
        [0.64304, 0.2528],
        [0.66235, 0.26048],
        [0.68166, 0.26504],
        [0.70097, 0.26965],
        [0.72028, 0.28695],
        [0.73959, 0.28439],
        [0.7589, 0.30345],
        [0.77821, 0.3461],
        [0.79753, 0.35111],
        [0.81684, 0.37839],
        [0.83615, 0.40014],
        [0.85546, 0.41165],
        [0.87477, 0.43106],
        [0.89408, 0.46219],
        [0.91339, 0.49108],
        [0.9327, 0.48525],
        [0.95202, 0.50495],
        [0.97133, 0.53886],
        [0.99064, 0.55752],
        [1.0099, 0.58315],
        [1.0293, 0.60575],
        [1.0486, 0.61994],
        [1.0679, 0.66018],
        [1.0872, 0.697],
        [1.1065, 0.71238],
        [1.1258, 0.73776],
        [1.1451, 0.75696],
        [1.1644, 0.76682],
        [1.1837, 0.78536],
        [1.2031, 0.80916],
        [1.2224, 0.83415],
        [1.2417, 0.8498],
        [1.261, 0.87663],
        [1.2803, 0.87439],
        [1.2996, 0.90201],
        [1.3189, 0.90162],
        [1.3382, 0.91556],
        [1.3576, 0.92227],
        [1.3769, 0.93095],
        [1.3962, 0.97554],
        [1.4155, 0.96251],
        [1.4348, 0.99356],
        [1.4541, 0.96146],
        [1.4734, 0.9754],
        [1.4927, 0.98961],
        [1.512, 1],
        [1.5314, 0.96659],
        [1.5507, 0.98724],
        [1.57, 0.9996],
        [1.5893, 0.96804],
        [1.6086, 0.99369],
        [1.6279, 0.9679],
        [1.6472, 0.9804],
        [1.6665, 0.97317],
        [1.6858, 0.95488],
        [1.7052, 0.97356],
        [1.7245, 0.97593],
        [1.7438, 0.95225],
        [1.7631, 0.92173],
        [1.7824, 0.91226],
        [1.8017, 0.91174],
        [1.821, 0.91147],
        [1.8403, 0.89674],
        [1.8596, 0.89359],
        [1.879, 0.8928],
        [1.8983, 0.90595],
        [1.9176, 0.83163],
        [1.9369, 0.86281],
        [1.9562, 0.84978],
        [1.9755, 0.82571],
        [1.9948, 0.80966],
        [2.0141, 0.83216],
        [2.0334, 0.81453],
        [2.0528, 0.81532],
        [2.0721, 0.80559],
        [2.0914, 0.824],
        [2.1107, 0.79796],
        [2.13, 0.78309],
        [2.1493, 0.79296],
        [2.1686, 0.78599],
        [2.1879, 0.81545],
        [2.2072, 0.80769],
        [2.2266, 0.78217],
        [2.2459, 0.77494],
        [2.2652, 0.77902],
        [2.2845, 0.75192],
        [2.3038, 0.76126],
        [2.3231, 0.75337],
        [2.3424, 0.73443],
        [2.3617, 0.74679],
        [2.381, 0.73285],
        [2.4004, 0.75074],
        [2.4197, 0.73666],
        [2.439, 0.71956],
        [2.4583, 0.7318],
        [2.4776, 0.72706],
        [2.4969, 0.71812],
        [2.5162, 0.68142],
        [2.5355, 0.70536],
        [2.5548, 0.72154],
        [2.5742, 0.71614],
        [2.5935, 0.72811],
        [2.6128, 0.69746],
        [2.6321, 0.68536],
        [2.6514, 0.70023],
        [2.6707, 0.69089],
        [2.69, 0.70601],
        [2.7093, 0.68826],
        [2.7286, 0.66603],
        [2.748, 0.69483],
        [2.7673, 0.67313],
        [2.7866, 0.66419],
        [2.8059, 0.66787],
        [2.8252, 0.65169],
        [2.8445, 0.65945],
        [2.8638, 0.67024],
        [2.8831, 0.65314],
        [2.9024, 0.63854],
        [2.9218, 0.6509],
        [2.9411, 0.65406],
        [2.9604, 0.63946],
        [2.9797, 0.65011],
        [2.999, 0.63722],
        [3.0183, 0.6317],
        [3.0376, 0.64025],
        [3.0569, 0.60657],
        [3.0762, 0.60552],
        [3.0956, 0.59592],
        [3.1149, 0.62301],
        [3.1342, 0.61026],
        [3.1535, 0.62551],
        [3.1728, 0.59986],
        [3.1921, 0.58513],
        [3.2114, 0.57658],
        [3.2307, 0.55948],
        [3.25, 0.56908],
        [3.2694, 0.5604],
        [3.2887, 0.56395],
        [3.308, 0.53712],
        [3.3273, 0.53081],
        [3.3466, 0.51792],
        [3.3659, 0.52199],
        [3.3852, 0.54054],
        [3.4045, 0.52594],
        [3.4238, 0.50818],
        [3.4432, 0.50082],
        [3.4625, 0.49122],
        [3.4818, 0.47096],
        [3.5011, 0.4707],
        [3.5204, 0.46517],
        [3.5397, 0.45452],
        [3.559, 0.42703],
        [3.5783, 0.39125],
        [3.5976, 0.41571],
        [3.617, 0.41348],
        [3.6363, 0.45517],
        [3.6556, 0.46728],
        [3.6749, 0.45754],
        [3.6942, 0.43939],
        [3.7135, 0.45465],
        [3.7328, 0.43505],
        [3.7521, 0.43373],
        [3.7714, 0.43189],
        [3.7908, 0.43781],
        [3.8101, 0.4457],
        [3.8294, 0.4019],
        [3.8487, 0.40098],
        [3.868, 0.39743],
        [3.8873, 0.39638],
        [3.9066, 0.39454],
        [3.9259, 0.37928],
        [3.9452, 0.39914],
        [3.9646, 0.38967],
        [3.9839, 0.36126],
        [4.0032, 0.35152],
        [4.0225, 0.35994],
        [4.0418, 0.33192],
        [4.0611, 0.33732],
        [4.0804, 0.3431],
        [4.0997, 0.36783],
        [4.119, 0.36191],
        [4.1384, 0.35915],
        [4.1577, 0.34574],
        [4.177, 0.35442],
        [4.1963, 0.36113],
        [4.2156, 0.34074],
        [4.2349, 0.36099],
        [4.2542, 0.35455],
        [4.2735, 0.34218],
        [4.2929, 0.36191],
        [4.3122, 0.32337],
        [4.3315, 0.32614],
        [4.3508, 0.3218],
        [4.3701, 0.3214],
        [4.3894, 0.31535],
        [4.4087, 0.30877],
        [4.428, 0.31404],
        [4.4473, 0.30917],
        [4.4667, 0.32364],
        [4.486, 0.31838],
        [4.5053, 0.29996],
        [4.5246, 0.29562],
        [4.5439, 0.27707],
        [4.5632, 0.27878],
        [4.5825, 0.26958],
        [4.6018, 0.26247],
        [4.6211, 0.27747],
        [4.6405, 0.24406],
        [4.6598, 0.27168],
        [4.6791, 0.25208],
        [4.6984, 0.26195],
        [4.7177, 0.2484],
        [4.737, 0.27523],
        [4.7563, 0.25524],
        [4.7756, 0.2434],
        [4.7949, 0.24037],
        [4.8143, 0.24077],
        [4.8336, 0.22064],
        [4.8529, 0.21972],
        [4.8722, 0.22906],
        [4.8915, 0.21341],
        [4.9108, 0.21341],
        [4.9301, 0.22617],
        [4.9494, 0.23183],
        [4.9687, 0.21946],
        [4.9881, 0.21551],
        [5.0074, 0.22433],
        [5.0267, 0.19684],
        [5.046, 0.20946],
        [5.0653, 0.2067],
        [5.0846, 0.20368],
        [5.1039, 0.20775],
        [5.1232, 0.20407],
        [5.1425, 0.19657],
        [5.1619, 0.21025],
        [5.1812, 0.20841],
        [5.2005, 0.18697],
        [5.2198, 0.20354],
        [5.2391, 0.19447],
        [5.2584, 0.18592],
        [5.2777, 0.20946],
        [5.297, 0.20736],
        [5.3163, 0.19407],
        [5.3357, 0.18802],
        [5.355, 0.19947],
        [5.3743, 0.19236],
        [5.3936, 0.20447],
        [5.4129, 0.17724],
        [5.4322, 0.19565],
        [5.4515, 0.17079],
        [5.4708, 0.17408],
        [5.4901, 0.17487],
        [5.5095, 0.1846],
        [5.5288, 0.17987],
        [5.5481, 0.18815],
        [5.5674, 0.15514],
        [5.5867, 0.16382],
        [5.606, 0.16645],
        [5.6253, 0.15974],
        [5.6446, 0.15014],
        [5.6639, 0.15567],
        [5.6833, 0.16251],
        [5.7026, 0.18276],
        [5.7219, 0.15277],
        [5.7412, 0.15567],
        [5.7605, 0.14961],
        [5.7798, 0.14462],
        [5.7991, 0.1412],
        [5.8184, 0.12475],
        [5.8377, 0.14672],
        [5.8571, 0.1412],
        [5.8764, 0.13659],
        [5.8957, 0.12923],
        [5.915, 0.12883],
        [5.9343, 0.11528],
        [5.9536, 0.11502],
        [5.9729, 0.13357],
        [5.9922, 0.13554],
        [6.0115, 0.12239],
        [6.0309, 0.11318],
        [6.0502, 0.11962],
        [6.0695, 0.11436],
        [6.0888, 0.1095],
        [6.1081, 0.10345],
        [6.1274, 0.11094],
        [6.1467, 0.11713],
        [6.166, 0.10187],
        [6.1853, 0.10594],
        [6.2047, 0.10805],
        [6.224, 0.12002],
        [6.2433, 0.096869],
        [6.2626, 0.095685],
        [6.2819, 0.077796],
        [6.3012, 0.095027],
        [6.3205, 0.089634],
        [6.3398, 0.10371],
        [6.3591, 0.091081],
        [6.3785, 0.088845],
        [6.3978, 0.084373],
        [6.4171, 0.078322],
        [6.4364, 0.098447],
        [6.4557, 0.084241],
        [6.475, 0.09016],
        [6.4943, 0.074376],
        [6.5136, 0.082531],
        [6.5329, 0.10397],
        [6.5523, 0.08845],
        [6.5716, 0.067273],
        [6.5909, 0.081084],
        [6.6102, 0.089503],
        [6.6295, 0.073192],
        [6.6488, 0.06872],
        [6.6681, 0.088713],
        [6.6874, 0.079243],
        [6.7067, 0.067536],
        [6.7261, 0.078322],
        [6.7454, 0.079374],
        [6.7647, 0.073718],
        [6.784, 0.068457],
        [6.8033, 0.071087],
        [6.8226, 0.050042],
        [6.8419, 0.057145],
        [6.8612, 0.064511],
        [6.8805, 0.067141],
        [6.8999, 0.055435],
        [6.9192, 0.05504],
        [6.9385, 0.060696],
        [6.9578, 0.062406],
        [6.9771, 0.059249],
        [6.9964, 0.063985],
        [7.0157, 0.044912],
        [7.035, 0.059907],
        [7.0543, 0.041623],
        [7.0737, 0.051752],
        [7.093, 0.032679],
        [7.1123, 0.057145],
        [7.1316, 0.065826],
        [7.1509, 0.052541],
        [7.1702, 0.061617],
        [7.1895, 0.063327],
        [7.2088, 0.05675],
        [7.2281, 0.053462],
        [7.2475, 0.055829],
        [7.2668, 0.054119],
        [7.2861, 0.055698],
        [7.3054, 0.045306],
        [7.3247, 0.048858],
        [7.344, 0.045964],
        [7.3633, 0.040176],
        [7.3826, 0.054119],
        [7.402, 0.056224],
        [7.4213, 0.049647],
        [7.4406, 0.0482],
        [7.4599, 0.04307],
        [7.4792, 0.040571],
        [7.4985, 0.038335],
        [7.5178, 0.042149],
        [7.5371, 0.054645],
        [7.5564, 0.02768],
        [7.5758, 0.038072],
        [7.5951, 0.022024],
        [7.6144, 0.035441],
        [7.6337, 0.032284],
        [7.653, 0.040308],
        [7.6723, 0.018604],
        [7.6916, 0.035441],
        [7.7109, 0.046096],
        [7.7302, 0.031758],
        [7.7496, 0.037414],
        [7.7689, 0.038466],
        [7.7882, 0.036756],
        [7.8075, 0.033073],
        [7.8268, 0.028996],
        [7.8461, 0.019525],
        [7.8654, 0.035046],
        [7.8847, 0.039124],
        [7.904, 0.03623],
        [7.9234, 0.0092653],
        [7.9427, 0.029522],
        [7.962, 0.03623],
        [7.9813, 0.016894],
        [8.0006, 0.018999],
        [8.0199, 0.02597],
        [8.0392, 0.032284],
        [8.0585, 0.0075554],
        [8.0778, 0.038072],
        [8.0972, 0.015579],
        [8.1165, 0.016894],
        [8.1358, 0.019525],
        [8.1551, 0.020709],
        [8.1744, 0.028338],
        [8.1937, 0.02597],
        [8.213, 0.025576],
        [8.2323, 0.009923],
        [8.2516, 0.023471],
        [8.271, 0.012685],
        [8.2903, 0.014001],
        [8.3096, 0.030969],
        [8.3289, 0.019525],
        [8.3482, 0.018341],
        [8.3675, 0.028996],
        [8.3868, 0.022814],
        [8.4061, 0.011501],
        [8.4254, 0.01479],
        [8.4448, 0.022945],
        [8.4641, 0.0021624],
        [8.4834, 0.024787],
        [8.5027, 0.0054508],
        [8.522, 0.036493],
        [8.5413, 0.0063715],
        [8.5606, 0.016368],
        [8.5799, 0.0032147],
        [8.5992, 0.019394],
        [8.6186, 0.013211],
        [8.6379, 0.012422],
        [8.6572, 0.015316],
        [8.6765, 0.01821],
        [8.6958, 0.027944],
        [8.7151, 0.0011101],
        [8.7344, 0.013738],
        [8.7537, 0.015579],
        [8.773, 0.0021624],
        [8.7924, 0.009923],
        [8.8117, 0.0098],
        [8.831, 0.0097],
        [8.8503, 0.0096],
        [8.8696, 0.0095],
        [8.8889, 0.0094],
        [8.9082, 0.0093],
        [8.9275, 0.0092],
        [8.9468, 0.0091],
        [8.9662, 0.009],
        [8.9855, 0.0089],
        [9.0048, 0.0088],
        [9.0241, 0.0087],
        [9.0434, 0.0086],
        [9.0627, 0.0085],
        [9.082, 0.0084],
        [9.1013, 0.0083],
        [9.1206, 0.0082],
        [9.14, 0.0081],
        [9.1593, 0.008],
        [9.1786, 0.0079],
        [9.1979, 0.0078],
        [9.2172, 0.0077],
        [9.2365, 0.0076],
        [9.2558, 0.0075],
        [9.2751, 0.0074],
        [9.2944, 0.0073],
        [9.3138, 0.0072],
        [9.3331, 0.0071],
        [9.3524, 0.007],
        [9.3717, 0.0069],
        [9.391, 0.0068],
        [9.4103, 0.0067],
        [9.4296, 0.0066],
        [9.4489, 0.0065],
        [9.4682, 0.0064],
        [9.4876, 0.0063],
        [9.5069, 0.0062],
        [9.5262, 0.0061],
        [9.5455, 0.006],
        [9.5648, 0.0059],
        [9.5841, 0.0058],
        [9.6034, 0.0057],
        [9.6227, 0.0056],
        [9.642, 0.0055],
        [9.6614, 0.0054],
        [9.6807, 0.0053],
        [9.7, 0.0052],
        [9.7193, 0.0051],
        [9.7386, 0.005],
        [9.7579, 0.0049],
        [9.7772, 0.0048],
        [9.7965, 0.0047],
        [9.8158, 0.0046],
        [9.8352, 0.0045],
        [9.8545, 0.0044],
        [9.8738, 0.0043],
        [9.8931, 0.0042],
    ])
    return spectrum


def NeutraSpectrum():
    spectrum = np.array([
        [0.075192, 0],
        [0.084591, 0.69976],
        [0.09399, 0.61292],
        [0.10339, 0.55422],
        [0.11279, 0.44353],
        [0.12219, 0.44643],
        [0.13159, 0.37957],
        [0.14098, 0.31331],
        [0.15038, 0.27603],
        [0.15978, 0.28273],
        [0.16918, 0.24817],
        [0.17858, 0.24622],
        [0.18798, 0.2327],
        [0.19738, 0.20644],
        [0.20678, 0.20047],
        [0.21618, 0.19737],
        [0.22558, 0.17163],
        [0.23497, 0.16269],
        [0.24437, 0.17042],
        [0.25377, 0.16154],
        [0.26317, 0.16247],
        [0.27257, 0.13125],
        [0.28197, 0.13807],
        [0.29137, 0.13236],
        [0.30077, 0.13298],
        [0.31017, 0.13128],
        [0.31956, 0.12799],
        [0.32896, 0.11922],
        [0.33836, 0.1186],
        [0.34776, 0.10551],
        [0.35716, 0.11435],
        [0.36656, 0.11714],
        [0.37596, 0.10691],
        [0.38536, 0.10266],
        [0.39476, 0.10914],
        [0.40416, 0.10405],
        [0.41355, 0.1104],
        [0.42295, 0.099707],
        [0.43235, 0.10314],
        [0.44175, 0.095226],
        [0.45115, 0.092643],
        [0.46055, 0.09612],
        [0.46995, 0.10363],
        [0.47935, 0.09797],
        [0.48875, 0.090225],
        [0.49815, 0.089707],
        [0.50754, 0.10753],
        [0.51694, 0.084441],
        [0.52634, 0.098599],
        [0.53574, 0.073079],
        [0.54514, 0.09427],
        [0.55454, 0.092605],
        [0.56394, 0.10422],
        [0.57334, 0.1013],
        [0.58274, 0.10904],
        [0.59214, 0.10415],
        [0.60153, 0.11339],
        [0.61093, 0.13366],
        [0.62033, 0.12757],
        [0.62973, 0.13023],
        [0.63913, 0.12897],
        [0.64853, 0.14597],
        [0.65793, 0.1462],
        [0.66733, 0.15987],
        [0.67673, 0.16767],
        [0.68612, 0.18375],
        [0.69552, 0.19552],
        [0.70492, 0.21993],
        [0.71432, 0.24449],
        [0.72372, 0.24693],
        [0.73312, 0.24422],
        [0.74252, 0.28232],
        [0.75192, 0.28975],
        [0.76132, 0.31862],
        [0.77072, 0.35848],
        [0.78011, 0.36773],
        [0.78951, 0.38664],
        [0.79891, 0.40971],
        [0.80831, 0.42373],
        [0.81771, 0.43164],
        [0.82711, 0.47701],
        [0.83651, 0.49741],
        [0.84591, 0.52473],
        [0.85531, 0.54769],
        [0.86471, 0.59389],
        [0.8741, 0.57834],
        [0.8835, 0.60656],
        [0.8929, 0.6298],
        [0.9023, 0.62542],
        [0.9117, 0.63415],
        [0.9211, 0.61345],
        [0.9305, 0.64338],
        [0.9399, 0.58987],
        [0.9493, 0.61876],
        [0.95869, 0.64752],
        [0.96809, 0.64582],
        [0.97749, 0.6704],
        [0.98689, 0.69355],
        [0.99629, 0.68114],
        [1.0057, 0.7246],
        [1.0151, 0.80055],
        [1.0245, 0.79108],
        [1.0339, 0.80856],
        [1.0433, 0.827],
        [1.0527, 0.85564],
        [1.0621, 0.85914],
        [1.0715, 0.86892],
        [1.0809, 0.89052],
        [1.0903, 0.8947],
        [1.0997, 0.92834],
        [1.1091, 0.9175],
        [1.1185, 0.93247],
        [1.1279, 0.96305],
        [1.1373, 0.97374],
        [1.1467, 1],
        [1.1561, 0.97895],
        [1.1655, 0.96995],
        [1.1749, 0.92939],
        [1.1843, 0.93023],
        [1.1937, 0.92435],
        [1.2031, 0.923],
        [1.2125, 0.9079],
        [1.2219, 0.88838],
        [1.2313, 0.85582],
        [1.2407, 0.87162],
        [1.2501, 0.83571],
        [1.2595, 0.80916],
        [1.2689, 0.79765],
        [1.2783, 0.81513],
        [1.2877, 0.83734],
        [1.2971, 0.82559],
        [1.3065, 0.81167],
        [1.3159, 0.80793],
        [1.3253, 0.79409],
        [1.3347, 0.79831],
        [1.3441, 0.83251],
        [1.3535, 0.85594],
        [1.3629, 0.84754],
        [1.3722, 0.86811],
        [1.3816, 0.82676],
        [1.391, 0.81092],
        [1.4004, 0.79827],
        [1.4098, 0.75902],
        [1.4192, 0.73614],
        [1.4286, 0.72582],
        [1.438, 0.72553],
        [1.4474, 0.73838],
        [1.4568, 0.69067],
        [1.4662, 0.68796],
        [1.4756, 0.70396],
        [1.485, 0.6888],
        [1.4944, 0.66995],
        [1.5038, 0.62593],
        [1.5132, 0.60748],
        [1.5226, 0.61018],
        [1.532, 0.58774],
        [1.5414, 0.57681],
        [1.5508, 0.60838],
        [1.5602, 0.62938],
        [1.5696, 0.63055],
        [1.579, 0.65494],
        [1.5884, 0.65735],
        [1.5978, 0.68572],
        [1.6072, 0.70326],
        [1.6166, 0.74024],
        [1.626, 0.74263],
        [1.6354, 0.72467],
        [1.6448, 0.72184],
        [1.6542, 0.72827],
        [1.6636, 0.74947],
        [1.673, 0.73927],
        [1.6824, 0.72816],
        [1.6918, 0.70231],
        [1.7012, 0.68386],
        [1.7106, 0.67496],
        [1.72, 0.62615],
        [1.7294, 0.60255],
        [1.7388, 0.6106],
        [1.7482, 0.59164],
        [1.7576, 0.56749],
        [1.767, 0.54705],
        [1.7764, 0.52386],
        [1.7858, 0.4863],
        [1.7952, 0.49562],
        [1.8046, 0.47218],
        [1.814, 0.48028],
        [1.8234, 0.43852],
        [1.8328, 0.44816],
        [1.8422, 0.41225],
        [1.8516, 0.41212],
        [1.861, 0.40344],
        [1.8704, 0.36911],
        [1.8798, 0.36595],
        [1.8892, 0.35791],
        [1.8986, 0.3804],
        [1.908, 0.387],
        [1.9174, 0.40917],
        [1.9268, 0.42584],
        [1.9362, 0.44494],
        [1.9456, 0.42928],
        [1.955, 0.42125],
        [1.9644, 0.41079],
        [1.9738, 0.40918],
        [1.9832, 0.40025],
        [1.9926, 0.39529],
        [2.002, 0.38516],
        [2.0114, 0.36682],
        [2.0208, 0.35579],
        [2.0302, 0.33594],
        [2.0396, 0.28751],
        [2.049, 0.28594],
        [2.0584, 0.27068],
        [2.0678, 0.28492],
        [2.0772, 0.26815],
        [2.0866, 0.28512],
        [2.096, 0.30056],
        [2.1054, 0.31327],
        [2.1148, 0.28467],
        [2.1242, 0.30861],
        [2.1336, 0.28791],
        [2.143, 0.29728],
        [2.1524, 0.27508],
        [2.1618, 0.2635],
        [2.1712, 0.25588],
        [2.1806, 0.27131],
        [2.19, 0.25186],
        [2.1994, 0.27427],
        [2.2088, 0.27484],
        [2.2182, 0.29785],
        [2.2276, 0.28356],
        [2.237, 0.28565],
        [2.2464, 0.27894],
        [2.2558, 0.27679],
        [2.2652, 0.27524],
        [2.2746, 0.28339],
        [2.2839, 0.25427],
        [2.2933, 0.24122],
        [2.3027, 0.2315],
        [2.3121, 0.21269],
        [2.3215, 0.22055],
        [2.3309, 0.22809],
        [2.3403, 0.2208],
        [2.3497, 0.21927],
        [2.3591, 0.21471],
        [2.3685, 0.22922],
        [2.3779, 0.22102],
        [2.3873, 0.22615],
        [2.3967, 0.21584],
        [2.4061, 0.20977],
        [2.4155, 0.20612],
        [2.4249, 0.18493],
        [2.4343, 0.20185],
        [2.4437, 0.19004],
        [2.4531, 0.20212],
        [2.4625, 0.19273],
        [2.4719, 0.19302],
        [2.4813, 0.17335],
        [2.4907, 0.17243],
        [2.5001, 0.17363],
        [2.5095, 0.15487],
        [2.5189, 0.16574],
        [2.5283, 0.16301],
        [2.5377, 0.15212],
        [2.5471, 0.12793],
        [2.5565, 0.13638],
        [2.5659, 0.14151],
        [2.5753, 0.14332],
        [2.5847, 0.15238],
        [2.5941, 0.14783],
        [2.6035, 0.15357],
        [2.6129, 0.15416],
        [2.6223, 0.16171],
        [2.6317, 0.15264],
        [2.6411, 0.15897],
        [2.6505, 0.13178],
        [2.6599, 0.16319],
        [2.6693, 0.12421],
        [2.6787, 0.13689],
        [2.6881, 0.13266],
        [2.6975, 0.14292],
        [2.7069, 0.13174],
        [2.7163, 0.13566],
        [2.7257, 0.11995],
        [2.7351, 0.11391],
        [2.7445, 0.12236],
        [2.7539, 0.10907],
        [2.7633, 0.11088],
        [2.7727, 0.11117],
        [2.7821, 0.10755],
        [2.7915, 0.10724],
        [2.8009, 0.11569],
        [2.8103, 0.098478],
        [2.8197, 0.10331],
        [2.8291, 0.095453],
        [2.8385, 0.094544],
        [2.8479, 0.10601],
        [2.8573, 0.096953],
        [2.8667, 0.11204],
        [2.8761, 0.088194],
        [2.8855, 0.099057],
        [2.8949, 0.10147],
        [2.9043, 0.096939],
        [2.9137, 0.090901],
        [2.9231, 0.094218],
        [2.9325, 0.097837],
        [2.9419, 0.09029],
        [2.9513, 0.080329],
        [2.9607, 0.07731],
        [2.9701, 0.069764],
        [2.9795, 0.069159],
        [2.9889, 0.061312],
        [2.9983, 0.055578],
        [3.0077, 0.068853],
        [3.0171, 0.068248],
        [3.0265, 0.071565],
        [3.0359, 0.064926],
        [3.0453, 0.063114],
        [3.0547, 0.070052],
        [3.0641, 0.077292],
        [3.0735, 0.054965],
        [3.0829, 0.058584],
        [3.0923, 0.050136],
        [3.1017, 0.050437],
        [3.1111, 0.049833],
        [3.1205, 0.055865],
        [3.1299, 0.054356],
        [3.1393, 0.053752],
        [3.1487, 0.059784],
        [3.1581, 0.064006],
        [3.1675, 0.067323],
        [3.1769, 0.056463],
        [3.1863, 0.057065],
        [3.1956, 0.05073],
        [3.205, 0.055254],
        [3.2144, 0.05827],
        [3.2238, 0.06219],
        [3.2332, 0.059474],
        [3.2426, 0.056759],
        [3.252, 0.062187],
        [3.2614, 0.056456],
        [3.2708, 0.050424],
        [3.2802, 0.052836],
        [3.2896, 0.047708],
        [3.299, 0.054342],
        [3.3084, 0.049818],
        [3.3178, 0.04831],
        [3.3272, 0.05223],
        [3.3366, 0.048912],
        [3.346, 0.048308],
        [3.3554, 0.042276],
        [3.3648, 0.047402],
        [3.3742, 0.048307],
        [3.3836, 0.044084],
        [3.393, 0.04137],
        [3.4024, 0.032323],
        [3.4118, 0.039861],
        [3.4212, 0.039861],
        [3.4306, 0.038353],
        [3.44, 0.037146],
        [3.4494, 0.034734],
        [3.4588, 0.038955],
        [3.4682, 0.034431],
        [3.4776, 0.037145],
        [3.487, 0.028702],
        [3.4964, 0.023877],
        [3.5058, 0.026289],
        [3.5152, 0.028098],
        [3.5246, 0.022972],
        [3.534, 0.03443],
        [3.5434, 0.031716],
        [3.5528, 0.029303],
        [3.5622, 0.020257],
        [3.5716, 0.021463],
        [3.581, 0.01875],
        [3.5904, 0.019352],
        [3.5998, 0.02086],
        [3.6092, 0.027493],
        [3.6186, 0.033825],
        [3.628, 0.017844],
        [3.6374, 0.02689],
        [3.6468, 0.026889],
        [3.6562, 0.027794],
        [3.6656, 0.032015],
        [3.675, 0.034728],
        [3.6844, 0.030507],
        [3.6938, 0.033823],
        [3.7032, 0.026587],
        [3.7126, 0.028396],
        [3.722, 0.030205],
        [3.7314, 0.025984],
        [3.7408, 0.028697],
        [3.7502, 0.022667],
        [3.7596, 0.023572],
        [3.769, 0.026888],
        [3.7784, 0.026888],
        [3.7878, 0.02327],
        [3.7972, 0.026586],
        [3.8066, 0.017541],
        [3.816, 0.025681],
        [3.8254, 0.028998],
        [3.8348, 0.022365],
        [3.8442, 0.023269],
        [3.8536, 0.021159],
        [3.863, 0.022666],
        [3.8724, 0.016938],
        [3.8818, 0.016033],
        [3.8912, 0.016938],
        [3.9006, 0.022063],
        [3.91, 0.013923],
        [3.9194, 0.019048],
        [3.9288, 0.017842],
        [3.9382, 0.015129],
        [3.9476, 0.016636],
        [3.957, 0.016334],
        [3.9664, 0.022364],
        [3.9758, 0.012415],
        [3.9852, 0.016334],
        [3.9946, 0.018143],
        [4.004, 0.007893],
        [4.0134, 0.0087973],
        [4.0228, 0.015731],
        [4.0322, 0.012716],
        [4.0416, 0.015731],
        [4.051, 0.010606],
        [4.0604, 0.0066869],
        [4.0698, 0.012716],
        [4.0792, 0.010907],
        [4.0886, 0.014525],
        [4.098, 0.013319],
        [4.1073, 0.018444],
        [4.1167, 0.025981],
        [4.1261, 0.016032],
        [4.1355, 0.013319],
        [4.1449, 0.0078926],
        [4.1543, 0.0097014],
        [4.1637, 0.010003],
        [4.1731, 0.0093999],
        [4.1825, 0.010907],
        [4.1919, 0.014525],
        [4.2013, 0.017238],
        [4.2107, 0.017539],
        [4.2201, 0.013922],
        [4.2295, 0.016333],
        [4.2389, 0.014826],
        [4.2483, 0.017539],
        [4.2577, 0.01151],
        [4.2671, 0.0097012],
        [4.2765, 0.017238],
        [4.2859, 0.010606],
        [4.2953, 0.012113],
        [4.3047, 0.010003],
        [4.3141, 0.0084953],
        [4.3235, 0.0078923],
        [4.3329, 0.0066865],
        [4.3423, 0.012414],
        [4.3517, 0.010605],
        [4.3611, 0.013318],
        [4.3705, 0.022061],
        [4.3799, 0.014223],
        [4.3893, 0.009701],
        [4.3987, 0.013318],
        [4.4081, 0.01151],
        [4.4175, 0.012113],
        [4.4269, 0.010605],
        [4.4363, 0.012113],
        [4.4457, 0.011811],
        [4.4551, 0.0051791],
        [4.4645, 0.013017],
        [4.4739, 0.01151],
        [4.4833, 0.0048777],
        [4.4927, 0.0081936],
        [4.5021, 0.0075907],
        [4.5115, 0.011208],
        [4.5209, 0.0069878],
        [4.5303, 0.011811],
        [4.5397, 0.0087965],
        [4.5491, 0.0093994],
        [4.5585, 0.00065728],
        [4.5679, 0.008495],
        [4.5773, 0.005179],
        [4.5867, 0.0048776],
        [4.5961, 0.002466],
        [4.6055, 0.0042747],
        [4.6149, 0.0063848],
        [4.6243, 0.0069877],
        [4.6337, 0.010605],
        [4.6431, 0.0054805],
        [4.6525, 0.0036718],
        [4.6619, 0.0063848],
        [4.6713, 0.008495],
        [4.6807, 0.0030689],
        [4.6901, 0.010605],
        [4.6995, 0.0081935],
        [4.7089, 0.0063848],
        [4.7183, 0.0036717],
        [4.7277, 0.0030688],
        [4.7371, 0.0054804],
        [4.7465, 0.007892],
        [4.7559, 0.010907],
        [4.7653, 0.00095868],
        [4.7747, 0.013017],
        [4.7841, 0.007892],
        [4.7935, 0.005179],
        [4.8029, 0.0063847],
        [4.8123, 0.0021645],
        [4.8217, 0.0027674],
        [4.8311, 0.0017544],
        [4.8405, 0.00095866],
        [4.8499, 0.0051789],
        [4.8593, 0.0051789],
        [4.8687, 0.0087963],
        [4.8781, 0.0033702],
        [4.8875, 0.004576],
        [4.8969, 0.0036717],
        [4.9063, 0.0024659],
        [4.9157, 0.0021644],
        [4.9251, 0.0027673],
        [4.9345, 0.0006572],
        [4.9439, 0.0036717],
        [4.9533, 0.0084948],
        [4.9627, 0.0057818],
        [4.9721, 0.012414],
        [4.9815, 0],
        [4.9909, 0.0042746],
        [5.0003, 0.0048774],
        [5.0097, 0.0015615],
        [5.019, 0.0036717],
        [5.0284, 0.00065719],
        [5.0378, 0.00065719],
        [5.0472, 0.0012601],
        [5.0566, 0.0027673],
        [5.066, 0.0051789],
        [5.0754, 0],
        [5.0848, 0],
        [5.0942, 0.00065719],
        [5.1036, 0],
        [5.113, 0.0078919],
        [5.1224, 0.004576],
        [5.1318, 0.0021644],
        [5.1412, 0],
        [5.1506, 0],
        [5.16, 0.0033702],
        [5.1694, 0.0042745],
        [5.1788, 0.00065718],
        [5.1882, 0.0033702],
        [5.1976, 0],
        [5.207, 0.001863],
        [5.2164, 0.001863],
        [5.2258, 0],
        [5.2352, 0.0039731],
        [5.2446, 0],
        [5.254, 0.0036716],
        [5.2634, 0.0039731],
        [5.2728, 0.0033702],
        [5.2822, 0],
        [5.2916, 0],
        [5.301, 0.00095862],
        [5.3104, 0.0057817],
        [5.3198, 0.0066861],
        [5.3292, 0.0036716],
        [5.3386, 0],
        [5.348, 0.0063846],
        [5.3574, 0],
        [5.3668, 0.0027673],
        [5.3762, 0],
        [5.3856, 5.43e-05],
        [5.395, 0.00095861],
        [5.4044, 0],
        [5.4138, 0.0021644],
        [5.4232, 0],
        [5.4326, 0],
        [5.442, 5.43e-05],
        [5.4514, 0.0018629],
        [5.4608, 0],
        [5.4702, 0],
        [5.4796, 0.00065716],
        [5.489, 0.0027673],
        [5.4984, 0.0030687],
        [5.5078, 0.0021644],
        [5.5172, 0],
        [5.5266, 0],
        [5.536, 0.0051788],
        [5.5454, 0],
        [5.5548, 0.0045759],
        [5.5642, 0.0054803],
        [5.5736, 0.0015615],
        [5.583, 0.0066861],
        [5.5924, 0],
        [5.6018, 0.00035571],
        [5.6112, 0.0009586],
        [5.6206, 0.003973],
        [5.63, 0],
        [5.6394, 0],
        [5.6488, 0],
        [5.6582, 0],
        [5.6676, 0.003973],
        [5.677, 0.0069875],
        [5.6864, 0],
        [5.6958, 0],
        [5.7052, 5.43e-05],
        [5.7146, 0],
        [5.724, 5.43e-05],
        [5.7334, 0.0048774],
        [5.7428, 0],
        [5.7522, 0],
        [5.7616, 0.0024658],
        [5.771, 0],
        [5.7804, 0.0024658],
        [5.7898, 0],
        [5.7992, 0.00126],
        [5.8086, 0],
        [5.818, 0],
        [5.8274, 0],
        [5.8368, 0],
        [5.8462, 0.00126],
        [5.8556, 0.0054803],
        [5.865, 0],
        [5.8744, 5.43e-05],
        [5.8838, 0.0015615],
        [5.8932, 0.00035571],
        [5.9026, 0.00035571],
        [5.912, 0],
        [5.9214, 0],
        [5.9307, 0],
        [5.9307, 0],
    ])
    return spectrum