from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.scaleway_qaas_v1_alpha_1_application import (
        ScalewayQaasV1Alpha1Application,
    )


T = TypeVar("T", bound="ScalewayQaasV1Alpha1ListApplicationsResponse")


@_attrs_define
class ScalewayQaasV1Alpha1ListApplicationsResponse:
    """
    Attributes:
        total_count (Union[Unset, int]): Total number of applications.
        applications (Union[Unset, list['ScalewayQaasV1Alpha1Application']]): List of applications.
    """

    total_count: Union[Unset, int] = UNSET
    applications: Union[Unset, list["ScalewayQaasV1Alpha1Application"]] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        total_count = self.total_count

        applications: Union[Unset, list[dict[str, Any]]] = UNSET
        if not isinstance(self.applications, Unset):
            applications = []
            for applications_item_data in self.applications:
                applications_item = applications_item_data.to_dict()
                applications.append(applications_item)

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if total_count is not UNSET:
            field_dict["total_count"] = total_count
        if applications is not UNSET:
            field_dict["applications"] = applications

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.scaleway_qaas_v1_alpha_1_application import (
            ScalewayQaasV1Alpha1Application,
        )

        d = dict(src_dict)
        total_count = d.pop("total_count", UNSET)

        applications = []
        _applications = d.pop("applications", UNSET)
        for applications_item_data in _applications or []:
            applications_item = ScalewayQaasV1Alpha1Application.from_dict(
                applications_item_data
            )

            applications.append(applications_item)

        scaleway_qaas_v1_alpha_1_list_applications_response = cls(
            total_count=total_count,
            applications=applications,
        )

        scaleway_qaas_v1_alpha_1_list_applications_response.additional_properties = d
        return scaleway_qaas_v1_alpha_1_list_applications_response

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
