import setuptools

with open("README.md", "r") as fh:
    long_description = fh.read()

pkgs = setuptools.find_packages()
print('found these packages:', pkgs)

pkg_name = "QuadrantAnalysis"

setuptools.setup(
    name=pkg_name,
    version="1.0.1",
    author="Geoffrey Barrett",
    author_email="geoffrey.m.barrett@gmail.com",
    description="QuadrantAnalysis - Python GUI designed to analyze behavior in NOR task, as well as determine differences between outer and inner arena exploration.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/HussainiLab/QuadrantAnalysis",
    packages=pkgs,
    install_requires=
    [
        'PyQtGraph',
        'matplotlib',
        'numpy',
        'openpyxl',
        'PyQt5',
        'scipy',
        'scikit-image',
        # 'sklearn',
    ],
    package_data={'QuadrantAnalysis': ['img/*.png']},
    classifiers=[
        "Programming Language :: Python :: 3.7 ",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3) ",
        "Operating System :: OS Independent",
    ],
)
