# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['das', 'das.modules']

package_data = \
{'': ['*']}

install_requires = \
['netaddr>=0.8.0,<0.9.0', 'tinydb>=4.4.0,<5.0.0']

entry_points = \
{'console_scripts': ['das = das.divideandscan:main',
                     'divideandscan = das.divideandscan:main']}

setup_kwargs = {
    'name': 'divideandscan',
    'version': '0.1.2',
    'description': 'Divide full port scan results and use it for targeted Nmap runs',
    'long_description': '<p align="center">\n  <img src="https://user-images.githubusercontent.com/23141800/113610876-632a4300-9656-11eb-9583-d07f4e34d774.png" width="350px" alt="DivideAndScan">\n</p>\n\n<p align="center">\n  <strong>Divide <strike>Et Impera</strike> And Scan (and also merge the scan results)</strong>\n</p>\n\n<p align="center">\n  <img src="https://img.shields.io/badge/version-0.1.2-success?style=flat-square" alt="version" />\n  <a href="https://github.com/snovvcrash/DivideAndScan/search?l=python"><img src="https://img.shields.io/badge/python-3.7-ffca1d?logo=python&logoColor=white&style=flat-square" alt="python" /></a>\n  <a href="https://pypi.org/project/divideandscan"><img src="https://img.shields.io/pypi/status/divideandscan?label=pypi&color=2cffab&logo=pypi&logoColor=white&style=flat-square" alt="pypi" /></a>\n  <a href="https://hub.docker.com/repository/docker/snovvcrash/divideandscan"><img src="https://img.shields.io/docker/cloud/build/snovvcrash/divideandscan?label=docker&color=099dec&logo=docker&logoColor=white&style=flat-square" alt="docker" /></a>\n  <a href="https://github.com/snovvcrash/DivideAndScan/issues?q=is%3Aopen+is%3Aissue"><img src="https://img.shields.io/github/issues/snovvcrash/DivideAndScan?logo=github&logoColor=white&style=flat-square" alt="issues" /></a>\n  <a href="https://twitter.com/snovvcrash"><img src="https://img.shields.io/twitter/follow/snovvcrash?label=%E2%80%8Esnovvcrash&style=social" alt="twitter"></a>\n</p>\n\n---\n\n**D**ivide**A**nd**S**can is used to efficiently automate port scanning routine by splitting it into 3 phases:\n\n1. Discover open ports for a bunch of targets.\n2. Run Nmap individually for each target with version grabbing and NSE actions.\n3. Merge the results into a single Nmap report (different formats available).\n\nFor the 1st phase a *fast* port scanner is intended to be used ([Masscan](https://github.com/robertdavidgraham/masscan) / [RustScan](https://github.com/RustScan/RustScan)), whose output is parsed and stored in a database ([TinyDB](https://github.com/msiemens/tinydb)). Next, during the 2nd phase individual Nmap scans are launched for each target with its set of open ports (multiprocessing is supported) according to the database data. Finally, in the 3rd phase separate Nmap outputs are merged into a single report in different formats (XML / HTML / Simple text / Grepable) with [nMap_Merger](https://github.com/CBHue/nMap_Merger).\n\nPotential use cases:\n\n* Pentest engagements / red teaming with a large scope to enumerate.\n* Cybersecurity wargames / training CTF labs.\n* OSCP certification exam.\n\n# How It Works\n\n![how-it-works.png](https://user-images.githubusercontent.com/23141800/113610892-67566080-9656-11eb-8520-8fa2dcaf3463.png)\n\n# How to Install\n\n## Prerequisites\n\nTo successfully *divide and scan* we need to get some good port scanning tools.\n\n📑 **Note:** if you don\'t feel like messing with dependecies on your host OS, skip to the [Docker](#using-from-docker) part.\n\n### Nmap\n\n```bash\nsudo apt install nmap sudo xsltproc -y\nsudo nmap --script-updatedb\n```\n\n### Masscan\n\n```bash\ncd /tmp\ngit clone https://github.com/robertdavidgraham/masscan.git\ncd masscan\nmake\nsudo make install\ncd && rm -rf /tmp/masscan\n```\n\n### RustScan\n\n```bash\ncd /tmp\n\nwget -qO- https://api.github.com/repos/RustScan/RustScan/releases/latest \\\n| grep "browser_download_url.*amd64.deb" \\\n| cut -d: -f2,3 \\\n| tr -d \\" \\\n| wget -qO rustscan.deb -i-\n\nsudo dpkg -i rustscan.deb\ncd && rm /tmp/rustscan.deb\n\nsudo wget https://gist.github.com/snovvcrash/c7f8223cc27154555496a9cbb4650681/raw/a76a2c658370d8b823a8a38a860e4d88051b417e/rustscan-ports-top1000.toml -O /root/.rustscan.toml\n```\n\n## Installation\n\nDivideAndScan is available on PyPI as `divideandscan`, though I recommend installing it from GitHub with [pipx](https://github.com/pipxproject/pipx) in order to always have the bleeding-edge version:\n\n```console\n~$ pipx install -f "git+https://github.com/snovvcrash/DivideAndScan.git"\n~$ das\n```\n\nFor debbugging purposes you can set up a dev environment with [poetry](https://github.com/python-poetry/poetry):\n\n```console\n~$ git clone https://github.com/snovvcrash/DivideAndScan\n~$ cd DivideAndScan\n~$ poetry install\n~$ poetry run das\n```\n\n📑 **Note:** DivideAndScan uses sudo to run all the port scanners, so it will ask for the password when scanning commands are invoked.\n\n## Using from Docker\n\nYou can run DivideAndScan in a Docker container as follows:\n\n```console\n~$ docker run -it --rm --name das -v `pwd`:/app snovvcrash/divideandscan\n```\n\nSince the tool requires some input data and produces some output data, you should specify your current working directory as the mount point at `/app` within the container. You may want to set an alias to make the base command shorter:\n\n```console\n~$ alias das=\'docker run -it --rm --name das -v `pwd`:/app snovvcrash/divideandscan\'\n~$ das\n```\n\n# How to Use\n\n![how-to-use.png](https://user-images.githubusercontent.com/23141800/113610915-6fae9b80-9656-11eb-8b1a-db503dd43861.png)\n\n> More examples coming soon at [snovvcrash.rocks](https://snovvcrash.rocks/)...\n\n## 0. Preparations\n\n<table>\n<tr>\n<td>\n\nMake a new directory to start DivideAndScan from. The tool will create subdirectories to store the output, so I recommend launching it from a clean directory to stay organized:\n\n```console\n~$ mkdir divideandscan\n~$ cd divideandscan\n```\n\n</td>\n</tr>\n</table>\n\n## 1. Filling the DB\n\n<table>\n<tr>\n<td>\n\nProvide the `add` module a command for either Masscan or RustScan to discover open ports in a desired range.\n\n⚠️ **Warning:** please, make sure that you understand what you\'re doing, because nearly all port scanning tools [can damage the system being tested](https://github.com/RustScan/RustScan/wiki/Usage#%EF%B8%8F-warning) if used improperly.\n\n```console\n# Masscan example\n~$ das add -db testdb masscan \'--rate 1000 -iL hosts.txt --open -p1-65535\'\n# RustScan example\n~$ das add -db testdb rustscan \'-b 1000 -t 2000 -u 5000 -a hosts.txt -r 1-65535 -g --no-config\'\n```\n\nWhen the module completes its work, a hidden directory `.db` is created in CWD containig the database file and raw scan results.\n\n</td>\n</tr>\n</table>\n\n## 2. Targeted Scanning\n\n<table>\n<tr>\n<td>\n\nLaunch targeted Nmap scans with the `scan` module. You can adjust the scan surface with either `-hosts` or `-ports` option:\n\n```console\n# Scan by hosts\n~$ das scan -db testdb -hosts all -oA report1\n~$ das scan -db testdb -hosts 192.168.1.0/24,10.10.13.37 -oA report1\n~$ das scan -db testdb -hosts hosts.txt -oA report1\n# Scan by ports\n~$ das scan -db testdb -ports all -oA report2\n~$ das scan -db testdb -ports 22,80,443,445 -oA report2\n~$ das scan -db testdb -ports ports.txt -oA report2\n```\n\nTo start Nmap simultaneously in multiple processes, specify the `-parallel` switch and set number of workers with the `-proc` option (if no value is provided, it will default to the number of processors on the machine):\n\n```console\n~$ das scan -db testdb -hosts all -oA report -parallel [-proc 4]\n```\n\nThe output format is selected with `-oX`, `-oN`, `-oG` and `-oA` options for XML+HTML formats, simple text format, grepable format and all formats respectively. When the module completes its work, a hidden directory `.nmap` is created in CWD containig Nmap raw scan reports.\n\nAlso, you can inspect the contents of the database with `-show` option before actually launching the scans:\n\n```console\n~$ das scan -db testdb -hosts all -show\n```\n\n</td>\n</tr>\n</table>\n\n## 3 (Optional). Merging the Reports\n\n<table>\n<tr>\n<td>\n\nIn order to generate a report independently of the `scan` module, you should use the `report` module. It will search for Nmap raw scan reports in the `.nmap` directory and process and merge them based on either `-hosts` or `-ports` option:\n\n```console\n# Merge outputs by hosts\n~$ das report -db testdb -hosts all -oA report1\n~$ das report -db testdb -hosts 192.168.1.0/24,10.10.13.37 -oA report1\n~$ das report -db testdb -hosts hosts.txt -oA report1\n# Merge outputs by ports\n~$ das report -db testdb -ports all -oA report2\n~$ das report -db testdb -ports 22,80,443,445 -oA report2\n~$ das report -db testdb -ports ports.txt -oA report2\n```\n\n📑 **Note:** keep in mind that the `report` module does **not** search the DB when processing the `-hosts` and `-ports` options, but looks for Nmap raw reports directly in `.nmap` directory instead; it means that `-hosts 127.0.0.1` argument value will be successfully resolved only if `.nmap/127-0-0-1.*` file exists, and `-ports 80` argument value will be successfully resolved only if `.nmap/port80.*` file exists.\n\n</td>\n</tr>\n</table>\n\n# Help\n\n```\nusage: das [-h] {add,scan,report} ...\n\n -----------------------------------------------------------------------------------------------\n|  ________  .__      .__    .___        _____              .____________                       |\n|  \\______ \\ |__|__  _|__| __| _/____   /  _  \\   ____    __| _/   _____/ ____ _____    ____    |\n|   |    |  \\|  \\  \\/ /  |/ __ |/ __ \\ /  /_\\  \\ /    \\  / __ |\\_____  \\_/ ___\\\\__  \\  /    \\   |\n|   |    `   \\  |\\   /|  / /_/ \\  ___//    |    \\   |  \\/ /_/ |/        \\  \\___ / __ \\|   |  \\  |\n|  /_______  /__| \\_/ |__\\____ |\\___  >____|__  /___|  /\\____ /_______  /\\___  >____  /___|  /  |\n|          \\/                 \\/    \\/        \\/     \\/      \\/       \\/     \\/     \\/     \\/   |\n|  {@snovvcrash}            {https://github.com/snovvcrash/DivideAndScan}             {vX.Y.Z}  |\n -----------------------------------------------------------------------------------------------\n\npositional arguments:\n  {add,scan,report}\n    add              run a full port scan {masscan,rustscan} and add the output to DB\n    scan             run targeted Nmap scans against hosts and ports from DB\n    report           merge separate Nmap outputs into a single report in different formats\n\noptional arguments:\n  -h, --help         show this help message and exit\n\nPsst, hey buddy... Wanna do some organized p0r7 5c4nn1n6?\n```\n\n# ToDo\n\n* [ ] Add [projectdiscovery/naabu](https://github.com/projectdiscovery/naabu) parser\n\n# Support\n\nIf this tool has been useful for you, feel free to buy me a <strike>beer</strike> coffee!\n\n[![beer.png](https://user-images.githubusercontent.com/23141800/113611163-d03dd880-9656-11eb-9279-e5e2689b0c1b.png)](https://buymeacoff.ee/snovvcrash)\n',
    'author': 'Sam Freeside',
    'author_email': 'snovvcrash@protonmail.ch',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/snovvcrash/DivideAndScan',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
