
> Note: This package is in the dangerous land of `0.x.y` versions and may be subject to breaking
> changes with minor version increments.

# nr.pylang.ast

This package provides tools for processing the AST as generated by the Python
`ast` module.

### Module: `dynamic_eval`

This module provides an AST rewriter that takes and Read/Write operations on
global variables and rewrites them to retrieve the variable by a function
instead. Non-global variables are left untouched.

Example:

```python
import os
from os import path

parent_dir = path.dirname(__file__)

def main():
  filename = path.join(parent_dir, 'foo.py')
  print(filename)
```

Will be converted to:

```python
import os; __dict__['os'] = os
from os import path; __dict__['path'] = path

__dict__['parent_dir'] = __dict__['path'].dirname(__dict__['__file__'])

def main():
  filename = __dict__['path'].join(__dict__['parent_dir'], 'foo.py')
  __dict__['print'](filename)
```

---

<p align="center">Copyright &copy; 2020 Niklas Rosenstein</p>
