#!/usr/bin/env python
# ------------------------------------------------------------------------------------------------------%
# Created by "Thieu Nguyen" at 15:21, 20/04/2020                                                        %
#                                                                                                       %
#       Email:      nguyenthieu2102@gmail.com                                                           %
#       Homepage:   https://www.researchgate.net/profile/Thieu_Nguyen6                                  %
#       Github:     https://github.com/thieunguyen5991                                                  %
#-------------------------------------------------------------------------------------------------------%

from opfunu.cec.cec2005.root import Root


class Model(Root):
    def __init__(self, f_name="Shifted Rosenbrock's Function", f_shift_data_file="data_rosenbrock",
                 f_ext='.txt', f_bias=390):
        Root.__init__(self, f_name, f_shift_data_file, f_ext, f_bias)

    def _main__(self, solution=None):
        problem_size = len(solution)
        if problem_size > 100:
            print("CEC 2005 not support for problem size > 100")
            return 1
        shift_data = self.load_shift_data()[:problem_size]
        z = solution - shift_data + 1
        result = 0
        for i in range(0, problem_size-1):
            result += (100 * (z[i] ** 2 - z[i + 1]) ** 2 + (z[i] - 1) ** 2)
        return result + self.f_bias

