# Pashword

> What does it mean?

The name "Pashword" comes from the contraction of "hash" and "password".

> What is it for?

Pashword is a Python package for password management.

> Is it hard to use?

Simply create a configuration file and execute one of the available commands.

## Background

Password management is a subject that we often prefer to ignore.
And for good reason, it's usually a headache.
Do you have to write everything down in a notebook that you risk losing or having stolen?
Should everything be stored in plain text?
Or encrypt it?
How to keep it all easy to use and portable from one machine to another?
The goal here is to settle all these issues once and for all by proposing, in open source, a very simple system based on a light and innovative mechanism.

## Features

With this Python package, your passwords become virtual.
They are not stored, neither in clear, nor in encrypted form.
They are generated from a configuration file, exist only in RAM for the period you want to view them, then disappear.
To make it work you only have to remember one secret key.
The main features offered by Pashword are identified by the following commands:

* `read`: To temporarily display the passwords generated from a configuration file.
* `sort`: To sort in alphabetical order the accounts contained in your configuration file.

## Installation

### Virtual environment

It is generally advisable to install Python packages in [virtual environments](https://docs.python.org/3/library/venv.html).
This is not necessary, but it will allow you to isolate the package and its dependencies from the rest of your computer.

### PyPi

Pashword is available on the [Python Package Index](https://pypi.org/project/pashword).
The easiest way to install it is to run the following command:

```bash
pip install pashword
```

### Development mode

If you want to work on the package source files, you can install the package in [development mode](https://packaging.python.org/en/latest/guides/distributing-packages-using-setuptools/#working-in-development-mode).
To do this on a POSIX system, clone, or download the project from its [GitLab repository](https://gitlab.com/dustils/pashword) and execute the following command in it:

```bash
source setup.sh
```

### Android

To synchronize your passwords on your Android phone, follow these steps:

* Install [F-Droid](https://f-droid.org) on your phone.
* Install [Termux](https://f-droid.org/en/packages/com.termux) (from F-Droid app).
* In the Termux app, execute the following commands:

```bash
pkg update
pkg install git
pkg install openssh
pkg install python3
termux-setup-storage
ssh-keygen -t rsa -C "gitlab"
less ~/.ssh/rsa.pub
```

* Copy the public key.
* Add the public key in your account settings on GitLab.
* Create a GitLab project containing your configuration file (see below).
* Clone the project on your phone.

## Usage

### Password configuration file

To start, you need to create a file that will contain the (public) information that will allow you to reconstruct your passwords.
This file contains several sections.
Each of these sections corresponds to the information needed to generate a single password.
So you can have more than one account saved in the same configuration file.
Here is an example of a file named `your-name.conf`:

```ini
[entity-one.org]
mail = user@email.address
date = 2023-07-19
form = u***-l***-d***

[entity-two.com]
user = username
date = 2022-02-19
form = u***-l***-d***
```

The name of the section must be different for each account.
It is recommended to name the sections with the hostname of the server on which your account is registered.
The only mandatory entry is the one called `form`.
This entry defines the format of the generated password.
To see what the metacharacters correspond to, look at the section `pashword.core.sets` of the package configuration file [default.conf](/src/pashword/default.conf).
Even if it is not mandatory, it is advisable to keep the sections `mail` (or `user`) and `date`.
This will allow you to remember your login name and the date you last changed your password.

### Hashing and modus operandi

Passwords are generated by a hashing algorithm from a secret key known only by the user to which is concatenated a cryptographic salt made up of the unencrypted information contained in the configuration file.
To clarify, the secret key and the configuration file are the inputs to the program, and the passwords for your accounts are the outputs.
Here are a few notions specific to the use of Pashword:

* Only one secret key is used to reveal the passwords of the accounts defined in a configuration file.
* You do not choose the value of your passwords. You only choose their format (according to what is allowed on this or that site).
* Changing an entry in a section of the configuration file will change the password associated with the section.
* Since a password is an hash of your secret key (to which we add a salt specific to the account), it is technically impossible (or at least extremely complicated) to deduce your secret key from a leaked password.
* Since a unique salt (consisting of the section name and its entries) is used for each account, the passwords generated from the different sections will all be different.

To create a password you must:

1. Add the section corresponding to the new account in the configuration file.
2. Run the program to discover the value of your password.

To change a password you must:

1. Run the program to get the value of your old password.
2. Add the section corresponding to the account in the configuration file.
3. Run again the program to get the new value of your password.

### Display help

Run the following commands to display information about the accepted arguments in each of the program features.

```bash
pashword read --help
pashword sort --help
```

### Read a password book

To display your passwords, run the following command:

```bash
pashword read your-name.conf
```

In order to limit the number of sections to be displayed, the program will first ask you for a matching pattern.
As for matching filenames on Linux, use the `*` character as a wildcard.
Then the program will ask you to enter your secret key before displaying your passwords.
As it is, the program has no way of knowing if you have entered the right secret key or not.
It will generate the passwords, but they will be wrong if there is a typo in the secret key.

If you want to be notified when you mistype your secret key, use option `--hash`, followed by the path to the file in which a hash value of your secret key will be stored.
If the file does not exist, it will be generated with the value of the secret key that you will enter to decode your passwords.
When the file already exists, it is used to compare the secret key you enter with the one you entered the first time.
If you want to change your secret key, simply delete the file containing the hash.

If other people can see your screen, you may not want your passwords to be visible.
For this, use the `--hide` option.
This will allow you to copy your passwords without them being displayed.

### Sort a password book

You can sort the sections contained in a configuration file alphabetically with the following command.

```bash
pashword sort your-name.conf
```

### Configure the package

To modify the package configuration at the time of execution of a command, you can use the `--config` option, followed by the path to a custom configuration file.
You can create your own custom configuration file by copying the default configuration file [`default.conf`](/src/pashword/default.conf).

## Credits

* Dunstan Becht

## License

This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
