# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WebhookArgs', 'Webhook']

@pulumi.input_type
class WebhookArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[str],
                 events: pulumi.Input[Sequence[pulumi.Input[str]]],
                 project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Webhook resource.
        :param pulumi.Input[str] endpoint: Webhooks events will be sent as POST requests to this URL.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] events: A list of the events the webhook will listen to. At least one must be present.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] project_ids: A list of project IDs that the webhook should be associated with. These projects should send events to the specified endpoint.
        :param pulumi.Input[str] team_id: The ID of the team the Webhook should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "events", events)
        if project_ids is not None:
            pulumi.set(__self__, "project_ids", project_ids)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        Webhooks events will be sent as POST requests to this URL.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def events(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of the events the webhook will listen to. At least one must be present.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "events", value)

    @property
    @pulumi.getter(name="projectIds")
    def project_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of project IDs that the webhook should be associated with. These projects should send events to the specified endpoint.
        """
        return pulumi.get(self, "project_ids")

    @project_ids.setter
    def project_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "project_ids", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the team the Webhook should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


@pulumi.input_type
class _WebhookState:
    def __init__(__self__, *,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Webhook resources.
        :param pulumi.Input[str] endpoint: Webhooks events will be sent as POST requests to this URL.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] events: A list of the events the webhook will listen to. At least one must be present.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] project_ids: A list of project IDs that the webhook should be associated with. These projects should send events to the specified endpoint.
        :param pulumi.Input[str] secret: A secret value which will be provided in the `x-vercel-signature` header and can be used to verify the authenticity of the webhook. See https://vercel.com/docs/observability/webhooks-overview/webhooks-api#securing-webhooks for further details.
        :param pulumi.Input[str] team_id: The ID of the team the Webhook should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if events is not None:
            pulumi.set(__self__, "events", events)
        if project_ids is not None:
            pulumi.set(__self__, "project_ids", project_ids)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Webhooks events will be sent as POST requests to this URL.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the events the webhook will listen to. At least one must be present.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "events", value)

    @property
    @pulumi.getter(name="projectIds")
    def project_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of project IDs that the webhook should be associated with. These projects should send events to the specified endpoint.
        """
        return pulumi.get(self, "project_ids")

    @project_ids.setter
    def project_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "project_ids", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        A secret value which will be provided in the `x-vercel-signature` header and can be used to verify the authenticity of the webhook. See https://vercel.com/docs/observability/webhooks-overview/webhooks-api#securing-webhooks for further details.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the team the Webhook should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


class Webhook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A webhook is a trigger-based HTTP endpoint configured to receive HTTP POST requests through events.

        When an event happens, a webhook is sent to a third-party app, which can then take appropriate action.

        > Only Pro and Enterprise teams are able to configure these webhooks at the account level.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_vercel as vercel

        example = vercel.Project("example", name="example-project")
        example2 = vercel.Project("example2", name="another-example-project")
        with_project_ids = vercel.Webhook("with_project_ids",
            events=[
                "deployment.created",
                "deployment.succeeded",
            ],
            endpoint="https://example.com/endpoint",
            project_ids=[
                example.id,
                example2.id,
            ])
        without_project_ids = vercel.Webhook("without_project_ids",
            events=[
                "deployment.created",
                "deployment.succeeded",
            ],
            endpoint="https://example.com/endpoint")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] endpoint: Webhooks events will be sent as POST requests to this URL.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] events: A list of the events the webhook will listen to. At least one must be present.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] project_ids: A list of project IDs that the webhook should be associated with. These projects should send events to the specified endpoint.
        :param pulumi.Input[str] team_id: The ID of the team the Webhook should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebhookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A webhook is a trigger-based HTTP endpoint configured to receive HTTP POST requests through events.

        When an event happens, a webhook is sent to a third-party app, which can then take appropriate action.

        > Only Pro and Enterprise teams are able to configure these webhooks at the account level.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_vercel as vercel

        example = vercel.Project("example", name="example-project")
        example2 = vercel.Project("example2", name="another-example-project")
        with_project_ids = vercel.Webhook("with_project_ids",
            events=[
                "deployment.created",
                "deployment.succeeded",
            ],
            endpoint="https://example.com/endpoint",
            project_ids=[
                example.id,
                example2.id,
            ])
        without_project_ids = vercel.Webhook("without_project_ids",
            events=[
                "deployment.created",
                "deployment.succeeded",
            ],
            endpoint="https://example.com/endpoint")
        ```

        :param str resource_name: The name of the resource.
        :param WebhookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebhookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebhookArgs.__new__(WebhookArgs)

            if endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint'")
            __props__.__dict__["endpoint"] = endpoint
            if events is None and not opts.urn:
                raise TypeError("Missing required property 'events'")
            __props__.__dict__["events"] = events
            __props__.__dict__["project_ids"] = project_ids
            __props__.__dict__["team_id"] = team_id
            __props__.__dict__["secret"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Webhook, __self__).__init__(
            'vercel:index/webhook:Webhook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            secret: Optional[pulumi.Input[str]] = None,
            team_id: Optional[pulumi.Input[str]] = None) -> 'Webhook':
        """
        Get an existing Webhook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] endpoint: Webhooks events will be sent as POST requests to this URL.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] events: A list of the events the webhook will listen to. At least one must be present.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] project_ids: A list of project IDs that the webhook should be associated with. These projects should send events to the specified endpoint.
        :param pulumi.Input[str] secret: A secret value which will be provided in the `x-vercel-signature` header and can be used to verify the authenticity of the webhook. See https://vercel.com/docs/observability/webhooks-overview/webhooks-api#securing-webhooks for further details.
        :param pulumi.Input[str] team_id: The ID of the team the Webhook should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebhookState.__new__(_WebhookState)

        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["events"] = events
        __props__.__dict__["project_ids"] = project_ids
        __props__.__dict__["secret"] = secret
        __props__.__dict__["team_id"] = team_id
        return Webhook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        Webhooks events will be sent as POST requests to this URL.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def events(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of the events the webhook will listen to. At least one must be present.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="projectIds")
    def project_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of project IDs that the webhook should be associated with. These projects should send events to the specified endpoint.
        """
        return pulumi.get(self, "project_ids")

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Output[str]:
        """
        A secret value which will be provided in the `x-vercel-signature` header and can be used to verify the authenticity of the webhook. See https://vercel.com/docs/observability/webhooks-overview/webhooks-api#securing-webhooks for further details.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        The ID of the team the Webhook should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

