# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TeamConfigArgs', 'TeamConfig']

@pulumi.input_type
class TeamConfigArgs:
    def __init__(__self__, *,
                 avatar: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email_domain: Optional[pulumi.Input[str]] = None,
                 enable_preview_feedback: Optional[pulumi.Input[str]] = None,
                 enable_production_feedback: Optional[pulumi.Input[str]] = None,
                 hide_ip_addresses: Optional[pulumi.Input[bool]] = None,
                 hide_ip_addresses_in_log_drains: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 preview_deployment_suffix: Optional[pulumi.Input[str]] = None,
                 remote_caching: Optional[pulumi.Input['TeamConfigRemoteCachingArgs']] = None,
                 saml: Optional[pulumi.Input['TeamConfigSamlArgs']] = None,
                 sensitive_environment_variable_policy: Optional[pulumi.Input[str]] = None,
                 slug: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TeamConfig resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] avatar: The `avatar` should be a the 'file' attribute from a get_file data source.
        :param pulumi.Input[str] description: A description of the team.
        :param pulumi.Input[str] email_domain: Hostname that'll be matched with emails on sign-up to automatically join the Team.
        :param pulumi.Input[str] enable_preview_feedback: Enables the Vercel Toolbar on your preview deployments: one of on, off or default.
        :param pulumi.Input[str] enable_production_feedback: Enables the Vercel Toolbar on your production deployments: one of on, off or default.
        :param pulumi.Input[bool] hide_ip_addresses: Indicates if ip addresses should be accessible in o11y tooling.
        :param pulumi.Input[bool] hide_ip_addresses_in_log_drains: Indicates if ip addresses should be accessible in log drains.
        :param pulumi.Input[str] name: The name of the team.
        :param pulumi.Input[str] preview_deployment_suffix: The hostname that is used as the preview deployment suffix.
        :param pulumi.Input['TeamConfigRemoteCachingArgs'] remote_caching: Configuration for Remote Caching.
        :param pulumi.Input['TeamConfigSamlArgs'] saml: Configuration for SAML authentication.
        :param pulumi.Input[str] sensitive_environment_variable_policy: Ensures that all environment variables created by members of this team will be created as Sensitive Environment Variables which can only be decrypted by Vercel's deployment system.: one of on, off or default.
        :param pulumi.Input[str] slug: The slug of the team. Will be used in the URL of the team's dashboard.
        """
        if avatar is not None:
            pulumi.set(__self__, "avatar", avatar)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email_domain is not None:
            pulumi.set(__self__, "email_domain", email_domain)
        if enable_preview_feedback is not None:
            pulumi.set(__self__, "enable_preview_feedback", enable_preview_feedback)
        if enable_production_feedback is not None:
            pulumi.set(__self__, "enable_production_feedback", enable_production_feedback)
        if hide_ip_addresses is not None:
            pulumi.set(__self__, "hide_ip_addresses", hide_ip_addresses)
        if hide_ip_addresses_in_log_drains is not None:
            pulumi.set(__self__, "hide_ip_addresses_in_log_drains", hide_ip_addresses_in_log_drains)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if preview_deployment_suffix is not None:
            pulumi.set(__self__, "preview_deployment_suffix", preview_deployment_suffix)
        if remote_caching is not None:
            pulumi.set(__self__, "remote_caching", remote_caching)
        if saml is not None:
            pulumi.set(__self__, "saml", saml)
        if sensitive_environment_variable_policy is not None:
            pulumi.set(__self__, "sensitive_environment_variable_policy", sensitive_environment_variable_policy)
        if slug is not None:
            pulumi.set(__self__, "slug", slug)

    @property
    @pulumi.getter
    def avatar(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The `avatar` should be a the 'file' attribute from a get_file data source.
        """
        return pulumi.get(self, "avatar")

    @avatar.setter
    def avatar(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "avatar", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the team.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="emailDomain")
    def email_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname that'll be matched with emails on sign-up to automatically join the Team.
        """
        return pulumi.get(self, "email_domain")

    @email_domain.setter
    def email_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_domain", value)

    @property
    @pulumi.getter(name="enablePreviewFeedback")
    def enable_preview_feedback(self) -> Optional[pulumi.Input[str]]:
        """
        Enables the Vercel Toolbar on your preview deployments: one of on, off or default.
        """
        return pulumi.get(self, "enable_preview_feedback")

    @enable_preview_feedback.setter
    def enable_preview_feedback(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_preview_feedback", value)

    @property
    @pulumi.getter(name="enableProductionFeedback")
    def enable_production_feedback(self) -> Optional[pulumi.Input[str]]:
        """
        Enables the Vercel Toolbar on your production deployments: one of on, off or default.
        """
        return pulumi.get(self, "enable_production_feedback")

    @enable_production_feedback.setter
    def enable_production_feedback(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_production_feedback", value)

    @property
    @pulumi.getter(name="hideIpAddresses")
    def hide_ip_addresses(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if ip addresses should be accessible in o11y tooling.
        """
        return pulumi.get(self, "hide_ip_addresses")

    @hide_ip_addresses.setter
    def hide_ip_addresses(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_ip_addresses", value)

    @property
    @pulumi.getter(name="hideIpAddressesInLogDrains")
    def hide_ip_addresses_in_log_drains(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if ip addresses should be accessible in log drains.
        """
        return pulumi.get(self, "hide_ip_addresses_in_log_drains")

    @hide_ip_addresses_in_log_drains.setter
    def hide_ip_addresses_in_log_drains(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_ip_addresses_in_log_drains", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the team.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="previewDeploymentSuffix")
    def preview_deployment_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname that is used as the preview deployment suffix.
        """
        return pulumi.get(self, "preview_deployment_suffix")

    @preview_deployment_suffix.setter
    def preview_deployment_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preview_deployment_suffix", value)

    @property
    @pulumi.getter(name="remoteCaching")
    def remote_caching(self) -> Optional[pulumi.Input['TeamConfigRemoteCachingArgs']]:
        """
        Configuration for Remote Caching.
        """
        return pulumi.get(self, "remote_caching")

    @remote_caching.setter
    def remote_caching(self, value: Optional[pulumi.Input['TeamConfigRemoteCachingArgs']]):
        pulumi.set(self, "remote_caching", value)

    @property
    @pulumi.getter
    def saml(self) -> Optional[pulumi.Input['TeamConfigSamlArgs']]:
        """
        Configuration for SAML authentication.
        """
        return pulumi.get(self, "saml")

    @saml.setter
    def saml(self, value: Optional[pulumi.Input['TeamConfigSamlArgs']]):
        pulumi.set(self, "saml", value)

    @property
    @pulumi.getter(name="sensitiveEnvironmentVariablePolicy")
    def sensitive_environment_variable_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Ensures that all environment variables created by members of this team will be created as Sensitive Environment Variables which can only be decrypted by Vercel's deployment system.: one of on, off or default.
        """
        return pulumi.get(self, "sensitive_environment_variable_policy")

    @sensitive_environment_variable_policy.setter
    def sensitive_environment_variable_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sensitive_environment_variable_policy", value)

    @property
    @pulumi.getter
    def slug(self) -> Optional[pulumi.Input[str]]:
        """
        The slug of the team. Will be used in the URL of the team's dashboard.
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slug", value)


@pulumi.input_type
class _TeamConfigState:
    def __init__(__self__, *,
                 avatar: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email_domain: Optional[pulumi.Input[str]] = None,
                 enable_preview_feedback: Optional[pulumi.Input[str]] = None,
                 enable_production_feedback: Optional[pulumi.Input[str]] = None,
                 hide_ip_addresses: Optional[pulumi.Input[bool]] = None,
                 hide_ip_addresses_in_log_drains: Optional[pulumi.Input[bool]] = None,
                 invite_code: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 preview_deployment_suffix: Optional[pulumi.Input[str]] = None,
                 remote_caching: Optional[pulumi.Input['TeamConfigRemoteCachingArgs']] = None,
                 saml: Optional[pulumi.Input['TeamConfigSamlArgs']] = None,
                 sensitive_environment_variable_policy: Optional[pulumi.Input[str]] = None,
                 slug: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TeamConfig resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] avatar: The `avatar` should be a the 'file' attribute from a get_file data source.
        :param pulumi.Input[str] description: A description of the team.
        :param pulumi.Input[str] email_domain: Hostname that'll be matched with emails on sign-up to automatically join the Team.
        :param pulumi.Input[str] enable_preview_feedback: Enables the Vercel Toolbar on your preview deployments: one of on, off or default.
        :param pulumi.Input[str] enable_production_feedback: Enables the Vercel Toolbar on your production deployments: one of on, off or default.
        :param pulumi.Input[bool] hide_ip_addresses: Indicates if ip addresses should be accessible in o11y tooling.
        :param pulumi.Input[bool] hide_ip_addresses_in_log_drains: Indicates if ip addresses should be accessible in log drains.
        :param pulumi.Input[str] invite_code: A code that can be used to join this team. Only visible to Team owners.
        :param pulumi.Input[str] name: The name of the team.
        :param pulumi.Input[str] preview_deployment_suffix: The hostname that is used as the preview deployment suffix.
        :param pulumi.Input['TeamConfigRemoteCachingArgs'] remote_caching: Configuration for Remote Caching.
        :param pulumi.Input['TeamConfigSamlArgs'] saml: Configuration for SAML authentication.
        :param pulumi.Input[str] sensitive_environment_variable_policy: Ensures that all environment variables created by members of this team will be created as Sensitive Environment Variables which can only be decrypted by Vercel's deployment system.: one of on, off or default.
        :param pulumi.Input[str] slug: The slug of the team. Will be used in the URL of the team's dashboard.
        """
        if avatar is not None:
            pulumi.set(__self__, "avatar", avatar)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email_domain is not None:
            pulumi.set(__self__, "email_domain", email_domain)
        if enable_preview_feedback is not None:
            pulumi.set(__self__, "enable_preview_feedback", enable_preview_feedback)
        if enable_production_feedback is not None:
            pulumi.set(__self__, "enable_production_feedback", enable_production_feedback)
        if hide_ip_addresses is not None:
            pulumi.set(__self__, "hide_ip_addresses", hide_ip_addresses)
        if hide_ip_addresses_in_log_drains is not None:
            pulumi.set(__self__, "hide_ip_addresses_in_log_drains", hide_ip_addresses_in_log_drains)
        if invite_code is not None:
            pulumi.set(__self__, "invite_code", invite_code)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if preview_deployment_suffix is not None:
            pulumi.set(__self__, "preview_deployment_suffix", preview_deployment_suffix)
        if remote_caching is not None:
            pulumi.set(__self__, "remote_caching", remote_caching)
        if saml is not None:
            pulumi.set(__self__, "saml", saml)
        if sensitive_environment_variable_policy is not None:
            pulumi.set(__self__, "sensitive_environment_variable_policy", sensitive_environment_variable_policy)
        if slug is not None:
            pulumi.set(__self__, "slug", slug)

    @property
    @pulumi.getter
    def avatar(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The `avatar` should be a the 'file' attribute from a get_file data source.
        """
        return pulumi.get(self, "avatar")

    @avatar.setter
    def avatar(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "avatar", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the team.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="emailDomain")
    def email_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname that'll be matched with emails on sign-up to automatically join the Team.
        """
        return pulumi.get(self, "email_domain")

    @email_domain.setter
    def email_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_domain", value)

    @property
    @pulumi.getter(name="enablePreviewFeedback")
    def enable_preview_feedback(self) -> Optional[pulumi.Input[str]]:
        """
        Enables the Vercel Toolbar on your preview deployments: one of on, off or default.
        """
        return pulumi.get(self, "enable_preview_feedback")

    @enable_preview_feedback.setter
    def enable_preview_feedback(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_preview_feedback", value)

    @property
    @pulumi.getter(name="enableProductionFeedback")
    def enable_production_feedback(self) -> Optional[pulumi.Input[str]]:
        """
        Enables the Vercel Toolbar on your production deployments: one of on, off or default.
        """
        return pulumi.get(self, "enable_production_feedback")

    @enable_production_feedback.setter
    def enable_production_feedback(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_production_feedback", value)

    @property
    @pulumi.getter(name="hideIpAddresses")
    def hide_ip_addresses(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if ip addresses should be accessible in o11y tooling.
        """
        return pulumi.get(self, "hide_ip_addresses")

    @hide_ip_addresses.setter
    def hide_ip_addresses(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_ip_addresses", value)

    @property
    @pulumi.getter(name="hideIpAddressesInLogDrains")
    def hide_ip_addresses_in_log_drains(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if ip addresses should be accessible in log drains.
        """
        return pulumi.get(self, "hide_ip_addresses_in_log_drains")

    @hide_ip_addresses_in_log_drains.setter
    def hide_ip_addresses_in_log_drains(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_ip_addresses_in_log_drains", value)

    @property
    @pulumi.getter(name="inviteCode")
    def invite_code(self) -> Optional[pulumi.Input[str]]:
        """
        A code that can be used to join this team. Only visible to Team owners.
        """
        return pulumi.get(self, "invite_code")

    @invite_code.setter
    def invite_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invite_code", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the team.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="previewDeploymentSuffix")
    def preview_deployment_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname that is used as the preview deployment suffix.
        """
        return pulumi.get(self, "preview_deployment_suffix")

    @preview_deployment_suffix.setter
    def preview_deployment_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preview_deployment_suffix", value)

    @property
    @pulumi.getter(name="remoteCaching")
    def remote_caching(self) -> Optional[pulumi.Input['TeamConfigRemoteCachingArgs']]:
        """
        Configuration for Remote Caching.
        """
        return pulumi.get(self, "remote_caching")

    @remote_caching.setter
    def remote_caching(self, value: Optional[pulumi.Input['TeamConfigRemoteCachingArgs']]):
        pulumi.set(self, "remote_caching", value)

    @property
    @pulumi.getter
    def saml(self) -> Optional[pulumi.Input['TeamConfigSamlArgs']]:
        """
        Configuration for SAML authentication.
        """
        return pulumi.get(self, "saml")

    @saml.setter
    def saml(self, value: Optional[pulumi.Input['TeamConfigSamlArgs']]):
        pulumi.set(self, "saml", value)

    @property
    @pulumi.getter(name="sensitiveEnvironmentVariablePolicy")
    def sensitive_environment_variable_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Ensures that all environment variables created by members of this team will be created as Sensitive Environment Variables which can only be decrypted by Vercel's deployment system.: one of on, off or default.
        """
        return pulumi.get(self, "sensitive_environment_variable_policy")

    @sensitive_environment_variable_policy.setter
    def sensitive_environment_variable_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sensitive_environment_variable_policy", value)

    @property
    @pulumi.getter
    def slug(self) -> Optional[pulumi.Input[str]]:
        """
        The slug of the team. Will be used in the URL of the team's dashboard.
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slug", value)


class TeamConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 avatar: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email_domain: Optional[pulumi.Input[str]] = None,
                 enable_preview_feedback: Optional[pulumi.Input[str]] = None,
                 enable_production_feedback: Optional[pulumi.Input[str]] = None,
                 hide_ip_addresses: Optional[pulumi.Input[bool]] = None,
                 hide_ip_addresses_in_log_drains: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 preview_deployment_suffix: Optional[pulumi.Input[str]] = None,
                 remote_caching: Optional[pulumi.Input[Union['TeamConfigRemoteCachingArgs', 'TeamConfigRemoteCachingArgsDict']]] = None,
                 saml: Optional[pulumi.Input[Union['TeamConfigSamlArgs', 'TeamConfigSamlArgsDict']]] = None,
                 sensitive_environment_variable_policy: Optional[pulumi.Input[str]] = None,
                 slug: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages the configuration of an existing Vercel Team.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] avatar: The `avatar` should be a the 'file' attribute from a get_file data source.
        :param pulumi.Input[str] description: A description of the team.
        :param pulumi.Input[str] email_domain: Hostname that'll be matched with emails on sign-up to automatically join the Team.
        :param pulumi.Input[str] enable_preview_feedback: Enables the Vercel Toolbar on your preview deployments: one of on, off or default.
        :param pulumi.Input[str] enable_production_feedback: Enables the Vercel Toolbar on your production deployments: one of on, off or default.
        :param pulumi.Input[bool] hide_ip_addresses: Indicates if ip addresses should be accessible in o11y tooling.
        :param pulumi.Input[bool] hide_ip_addresses_in_log_drains: Indicates if ip addresses should be accessible in log drains.
        :param pulumi.Input[str] name: The name of the team.
        :param pulumi.Input[str] preview_deployment_suffix: The hostname that is used as the preview deployment suffix.
        :param pulumi.Input[Union['TeamConfigRemoteCachingArgs', 'TeamConfigRemoteCachingArgsDict']] remote_caching: Configuration for Remote Caching.
        :param pulumi.Input[Union['TeamConfigSamlArgs', 'TeamConfigSamlArgsDict']] saml: Configuration for SAML authentication.
        :param pulumi.Input[str] sensitive_environment_variable_policy: Ensures that all environment variables created by members of this team will be created as Sensitive Environment Variables which can only be decrypted by Vercel's deployment system.: one of on, off or default.
        :param pulumi.Input[str] slug: The slug of the team. Will be used in the URL of the team's dashboard.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TeamConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the configuration of an existing Vercel Team.

        :param str resource_name: The name of the resource.
        :param TeamConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TeamConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 avatar: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email_domain: Optional[pulumi.Input[str]] = None,
                 enable_preview_feedback: Optional[pulumi.Input[str]] = None,
                 enable_production_feedback: Optional[pulumi.Input[str]] = None,
                 hide_ip_addresses: Optional[pulumi.Input[bool]] = None,
                 hide_ip_addresses_in_log_drains: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 preview_deployment_suffix: Optional[pulumi.Input[str]] = None,
                 remote_caching: Optional[pulumi.Input[Union['TeamConfigRemoteCachingArgs', 'TeamConfigRemoteCachingArgsDict']]] = None,
                 saml: Optional[pulumi.Input[Union['TeamConfigSamlArgs', 'TeamConfigSamlArgsDict']]] = None,
                 sensitive_environment_variable_policy: Optional[pulumi.Input[str]] = None,
                 slug: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TeamConfigArgs.__new__(TeamConfigArgs)

            __props__.__dict__["avatar"] = avatar
            __props__.__dict__["description"] = description
            __props__.__dict__["email_domain"] = email_domain
            __props__.__dict__["enable_preview_feedback"] = enable_preview_feedback
            __props__.__dict__["enable_production_feedback"] = enable_production_feedback
            __props__.__dict__["hide_ip_addresses"] = hide_ip_addresses
            __props__.__dict__["hide_ip_addresses_in_log_drains"] = hide_ip_addresses_in_log_drains
            __props__.__dict__["name"] = name
            __props__.__dict__["preview_deployment_suffix"] = preview_deployment_suffix
            __props__.__dict__["remote_caching"] = remote_caching
            __props__.__dict__["saml"] = saml
            __props__.__dict__["sensitive_environment_variable_policy"] = sensitive_environment_variable_policy
            __props__.__dict__["slug"] = slug
            __props__.__dict__["invite_code"] = None
        super(TeamConfig, __self__).__init__(
            'vercel:index/teamConfig:TeamConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            avatar: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            email_domain: Optional[pulumi.Input[str]] = None,
            enable_preview_feedback: Optional[pulumi.Input[str]] = None,
            enable_production_feedback: Optional[pulumi.Input[str]] = None,
            hide_ip_addresses: Optional[pulumi.Input[bool]] = None,
            hide_ip_addresses_in_log_drains: Optional[pulumi.Input[bool]] = None,
            invite_code: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            preview_deployment_suffix: Optional[pulumi.Input[str]] = None,
            remote_caching: Optional[pulumi.Input[Union['TeamConfigRemoteCachingArgs', 'TeamConfigRemoteCachingArgsDict']]] = None,
            saml: Optional[pulumi.Input[Union['TeamConfigSamlArgs', 'TeamConfigSamlArgsDict']]] = None,
            sensitive_environment_variable_policy: Optional[pulumi.Input[str]] = None,
            slug: Optional[pulumi.Input[str]] = None) -> 'TeamConfig':
        """
        Get an existing TeamConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] avatar: The `avatar` should be a the 'file' attribute from a get_file data source.
        :param pulumi.Input[str] description: A description of the team.
        :param pulumi.Input[str] email_domain: Hostname that'll be matched with emails on sign-up to automatically join the Team.
        :param pulumi.Input[str] enable_preview_feedback: Enables the Vercel Toolbar on your preview deployments: one of on, off or default.
        :param pulumi.Input[str] enable_production_feedback: Enables the Vercel Toolbar on your production deployments: one of on, off or default.
        :param pulumi.Input[bool] hide_ip_addresses: Indicates if ip addresses should be accessible in o11y tooling.
        :param pulumi.Input[bool] hide_ip_addresses_in_log_drains: Indicates if ip addresses should be accessible in log drains.
        :param pulumi.Input[str] invite_code: A code that can be used to join this team. Only visible to Team owners.
        :param pulumi.Input[str] name: The name of the team.
        :param pulumi.Input[str] preview_deployment_suffix: The hostname that is used as the preview deployment suffix.
        :param pulumi.Input[Union['TeamConfigRemoteCachingArgs', 'TeamConfigRemoteCachingArgsDict']] remote_caching: Configuration for Remote Caching.
        :param pulumi.Input[Union['TeamConfigSamlArgs', 'TeamConfigSamlArgsDict']] saml: Configuration for SAML authentication.
        :param pulumi.Input[str] sensitive_environment_variable_policy: Ensures that all environment variables created by members of this team will be created as Sensitive Environment Variables which can only be decrypted by Vercel's deployment system.: one of on, off or default.
        :param pulumi.Input[str] slug: The slug of the team. Will be used in the URL of the team's dashboard.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TeamConfigState.__new__(_TeamConfigState)

        __props__.__dict__["avatar"] = avatar
        __props__.__dict__["description"] = description
        __props__.__dict__["email_domain"] = email_domain
        __props__.__dict__["enable_preview_feedback"] = enable_preview_feedback
        __props__.__dict__["enable_production_feedback"] = enable_production_feedback
        __props__.__dict__["hide_ip_addresses"] = hide_ip_addresses
        __props__.__dict__["hide_ip_addresses_in_log_drains"] = hide_ip_addresses_in_log_drains
        __props__.__dict__["invite_code"] = invite_code
        __props__.__dict__["name"] = name
        __props__.__dict__["preview_deployment_suffix"] = preview_deployment_suffix
        __props__.__dict__["remote_caching"] = remote_caching
        __props__.__dict__["saml"] = saml
        __props__.__dict__["sensitive_environment_variable_policy"] = sensitive_environment_variable_policy
        __props__.__dict__["slug"] = slug
        return TeamConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def avatar(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The `avatar` should be a the 'file' attribute from a get_file data source.
        """
        return pulumi.get(self, "avatar")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A description of the team.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="emailDomain")
    def email_domain(self) -> pulumi.Output[str]:
        """
        Hostname that'll be matched with emails on sign-up to automatically join the Team.
        """
        return pulumi.get(self, "email_domain")

    @property
    @pulumi.getter(name="enablePreviewFeedback")
    def enable_preview_feedback(self) -> pulumi.Output[str]:
        """
        Enables the Vercel Toolbar on your preview deployments: one of on, off or default.
        """
        return pulumi.get(self, "enable_preview_feedback")

    @property
    @pulumi.getter(name="enableProductionFeedback")
    def enable_production_feedback(self) -> pulumi.Output[str]:
        """
        Enables the Vercel Toolbar on your production deployments: one of on, off or default.
        """
        return pulumi.get(self, "enable_production_feedback")

    @property
    @pulumi.getter(name="hideIpAddresses")
    def hide_ip_addresses(self) -> pulumi.Output[bool]:
        """
        Indicates if ip addresses should be accessible in o11y tooling.
        """
        return pulumi.get(self, "hide_ip_addresses")

    @property
    @pulumi.getter(name="hideIpAddressesInLogDrains")
    def hide_ip_addresses_in_log_drains(self) -> pulumi.Output[bool]:
        """
        Indicates if ip addresses should be accessible in log drains.
        """
        return pulumi.get(self, "hide_ip_addresses_in_log_drains")

    @property
    @pulumi.getter(name="inviteCode")
    def invite_code(self) -> pulumi.Output[str]:
        """
        A code that can be used to join this team. Only visible to Team owners.
        """
        return pulumi.get(self, "invite_code")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the team.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="previewDeploymentSuffix")
    def preview_deployment_suffix(self) -> pulumi.Output[str]:
        """
        The hostname that is used as the preview deployment suffix.
        """
        return pulumi.get(self, "preview_deployment_suffix")

    @property
    @pulumi.getter(name="remoteCaching")
    def remote_caching(self) -> pulumi.Output['outputs.TeamConfigRemoteCaching']:
        """
        Configuration for Remote Caching.
        """
        return pulumi.get(self, "remote_caching")

    @property
    @pulumi.getter
    def saml(self) -> pulumi.Output['outputs.TeamConfigSaml']:
        """
        Configuration for SAML authentication.
        """
        return pulumi.get(self, "saml")

    @property
    @pulumi.getter(name="sensitiveEnvironmentVariablePolicy")
    def sensitive_environment_variable_policy(self) -> pulumi.Output[str]:
        """
        Ensures that all environment variables created by members of this team will be created as Sensitive Environment Variables which can only be decrypted by Vercel's deployment system.: one of on, off or default.
        """
        return pulumi.get(self, "sensitive_environment_variable_policy")

    @property
    @pulumi.getter
    def slug(self) -> pulumi.Output[str]:
        """
        The slug of the team. Will be used in the URL of the team's dashboard.
        """
        return pulumi.get(self, "slug")

