# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SharedEnvironmentVariableProjectLinkArgs', 'SharedEnvironmentVariableProjectLink']

@pulumi.input_type
class SharedEnvironmentVariableProjectLinkArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[str],
                 shared_environment_variable_id: pulumi.Input[str],
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SharedEnvironmentVariableProjectLink resource.
        :param pulumi.Input[str] project_id: The ID of the Vercel project.
        :param pulumi.Input[str] shared_environment_variable_id: The ID of the shared environment variable.
        :param pulumi.Input[str] team_id: The ID of the Vercel team. Required when configuring a team resource if a default team has not been set in the provider.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "shared_environment_variable_id", shared_environment_variable_id)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The ID of the Vercel project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="sharedEnvironmentVariableId")
    def shared_environment_variable_id(self) -> pulumi.Input[str]:
        """
        The ID of the shared environment variable.
        """
        return pulumi.get(self, "shared_environment_variable_id")

    @shared_environment_variable_id.setter
    def shared_environment_variable_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "shared_environment_variable_id", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Vercel team. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


@pulumi.input_type
class _SharedEnvironmentVariableProjectLinkState:
    def __init__(__self__, *,
                 project_id: Optional[pulumi.Input[str]] = None,
                 shared_environment_variable_id: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SharedEnvironmentVariableProjectLink resources.
        :param pulumi.Input[str] project_id: The ID of the Vercel project.
        :param pulumi.Input[str] shared_environment_variable_id: The ID of the shared environment variable.
        :param pulumi.Input[str] team_id: The ID of the Vercel team. Required when configuring a team resource if a default team has not been set in the provider.
        """
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if shared_environment_variable_id is not None:
            pulumi.set(__self__, "shared_environment_variable_id", shared_environment_variable_id)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Vercel project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="sharedEnvironmentVariableId")
    def shared_environment_variable_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the shared environment variable.
        """
        return pulumi.get(self, "shared_environment_variable_id")

    @shared_environment_variable_id.setter
    def shared_environment_variable_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_environment_variable_id", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Vercel team. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


class SharedEnvironmentVariableProjectLink(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 shared_environment_variable_id: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Links a project to a Shared Environment Variable.

        > This resource is intended to be used alongside a SharedEnvironmentVariable Data Source, not the Resource. The Resource also defines which projects to link to the shared environment variable, and using both SharedEnvironmentVariable and SharedEnvironmentVariableProjectLink together results in undefined behavior.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vercel as vercel
        import pulumiverse_vercel as vercel

        example = vercel.get_shared_environment_variable(key="EXAMPLE_ENV_VAR",
            targets=[
                "production",
                "preview",
            ])
        example_project = vercel.Project("example", name="example")
        example_shared_environment_variable_project_link = vercel.SharedEnvironmentVariableProjectLink("example",
            shared_environment_variable_id=example.id,
            project_id=example_project.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project_id: The ID of the Vercel project.
        :param pulumi.Input[str] shared_environment_variable_id: The ID of the shared environment variable.
        :param pulumi.Input[str] team_id: The ID of the Vercel team. Required when configuring a team resource if a default team has not been set in the provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SharedEnvironmentVariableProjectLinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Links a project to a Shared Environment Variable.

        > This resource is intended to be used alongside a SharedEnvironmentVariable Data Source, not the Resource. The Resource also defines which projects to link to the shared environment variable, and using both SharedEnvironmentVariable and SharedEnvironmentVariableProjectLink together results in undefined behavior.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vercel as vercel
        import pulumiverse_vercel as vercel

        example = vercel.get_shared_environment_variable(key="EXAMPLE_ENV_VAR",
            targets=[
                "production",
                "preview",
            ])
        example_project = vercel.Project("example", name="example")
        example_shared_environment_variable_project_link = vercel.SharedEnvironmentVariableProjectLink("example",
            shared_environment_variable_id=example.id,
            project_id=example_project.id)
        ```

        :param str resource_name: The name of the resource.
        :param SharedEnvironmentVariableProjectLinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SharedEnvironmentVariableProjectLinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 shared_environment_variable_id: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SharedEnvironmentVariableProjectLinkArgs.__new__(SharedEnvironmentVariableProjectLinkArgs)

            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if shared_environment_variable_id is None and not opts.urn:
                raise TypeError("Missing required property 'shared_environment_variable_id'")
            __props__.__dict__["shared_environment_variable_id"] = shared_environment_variable_id
            __props__.__dict__["team_id"] = team_id
        super(SharedEnvironmentVariableProjectLink, __self__).__init__(
            'vercel:index/sharedEnvironmentVariableProjectLink:SharedEnvironmentVariableProjectLink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            shared_environment_variable_id: Optional[pulumi.Input[str]] = None,
            team_id: Optional[pulumi.Input[str]] = None) -> 'SharedEnvironmentVariableProjectLink':
        """
        Get an existing SharedEnvironmentVariableProjectLink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project_id: The ID of the Vercel project.
        :param pulumi.Input[str] shared_environment_variable_id: The ID of the shared environment variable.
        :param pulumi.Input[str] team_id: The ID of the Vercel team. Required when configuring a team resource if a default team has not been set in the provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SharedEnvironmentVariableProjectLinkState.__new__(_SharedEnvironmentVariableProjectLinkState)

        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["shared_environment_variable_id"] = shared_environment_variable_id
        __props__.__dict__["team_id"] = team_id
        return SharedEnvironmentVariableProjectLink(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the Vercel project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="sharedEnvironmentVariableId")
    def shared_environment_variable_id(self) -> pulumi.Output[str]:
        """
        The ID of the shared environment variable.
        """
        return pulumi.get(self, "shared_environment_variable_id")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        The ID of the Vercel team. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

