# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProjectDomainArgs', 'ProjectDomain']

@pulumi.input_type
class ProjectDomainArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 custom_environment_id: Optional[pulumi.Input[str]] = None,
                 git_branch: Optional[pulumi.Input[str]] = None,
                 redirect: Optional[pulumi.Input[str]] = None,
                 redirect_status_code: Optional[pulumi.Input[int]] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ProjectDomain resource.
        :param pulumi.Input[str] domain: The domain name to associate with the project.
        :param pulumi.Input[str] project_id: The project ID to add the deployment to.
        :param pulumi.Input[str] custom_environment_id: The name of the Custom Environment to link to the Project Domain. Deployments from this custom environment will be assigned the domain name.
        :param pulumi.Input[str] git_branch: Git branch to link to the project domain. Deployments from this git branch will be assigned the domain name.
        :param pulumi.Input[str] redirect: The domain name that serves as a target destination for redirects.
        :param pulumi.Input[int] redirect_status_code: The HTTP status code to use when serving as a redirect.
        :param pulumi.Input[str] team_id: The ID of the team the project exists under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "project_id", project_id)
        if custom_environment_id is not None:
            pulumi.set(__self__, "custom_environment_id", custom_environment_id)
        if git_branch is not None:
            pulumi.set(__self__, "git_branch", git_branch)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)
        if redirect_status_code is not None:
            pulumi.set(__self__, "redirect_status_code", redirect_status_code)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        The domain name to associate with the project.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The project ID to add the deployment to.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="customEnvironmentId")
    def custom_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Custom Environment to link to the Project Domain. Deployments from this custom environment will be assigned the domain name.
        """
        return pulumi.get(self, "custom_environment_id")

    @custom_environment_id.setter
    def custom_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_environment_id", value)

    @property
    @pulumi.getter(name="gitBranch")
    def git_branch(self) -> Optional[pulumi.Input[str]]:
        """
        Git branch to link to the project domain. Deployments from this git branch will be assigned the domain name.
        """
        return pulumi.get(self, "git_branch")

    @git_branch.setter
    def git_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "git_branch", value)

    @property
    @pulumi.getter
    def redirect(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name that serves as a target destination for redirects.
        """
        return pulumi.get(self, "redirect")

    @redirect.setter
    def redirect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect", value)

    @property
    @pulumi.getter(name="redirectStatusCode")
    def redirect_status_code(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP status code to use when serving as a redirect.
        """
        return pulumi.get(self, "redirect_status_code")

    @redirect_status_code.setter
    def redirect_status_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "redirect_status_code", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the team the project exists under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


@pulumi.input_type
class _ProjectDomainState:
    def __init__(__self__, *,
                 custom_environment_id: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 git_branch: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 redirect: Optional[pulumi.Input[str]] = None,
                 redirect_status_code: Optional[pulumi.Input[int]] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ProjectDomain resources.
        :param pulumi.Input[str] custom_environment_id: The name of the Custom Environment to link to the Project Domain. Deployments from this custom environment will be assigned the domain name.
        :param pulumi.Input[str] domain: The domain name to associate with the project.
        :param pulumi.Input[str] git_branch: Git branch to link to the project domain. Deployments from this git branch will be assigned the domain name.
        :param pulumi.Input[str] project_id: The project ID to add the deployment to.
        :param pulumi.Input[str] redirect: The domain name that serves as a target destination for redirects.
        :param pulumi.Input[int] redirect_status_code: The HTTP status code to use when serving as a redirect.
        :param pulumi.Input[str] team_id: The ID of the team the project exists under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        if custom_environment_id is not None:
            pulumi.set(__self__, "custom_environment_id", custom_environment_id)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if git_branch is not None:
            pulumi.set(__self__, "git_branch", git_branch)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)
        if redirect_status_code is not None:
            pulumi.set(__self__, "redirect_status_code", redirect_status_code)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="customEnvironmentId")
    def custom_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Custom Environment to link to the Project Domain. Deployments from this custom environment will be assigned the domain name.
        """
        return pulumi.get(self, "custom_environment_id")

    @custom_environment_id.setter
    def custom_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_environment_id", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name to associate with the project.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="gitBranch")
    def git_branch(self) -> Optional[pulumi.Input[str]]:
        """
        Git branch to link to the project domain. Deployments from this git branch will be assigned the domain name.
        """
        return pulumi.get(self, "git_branch")

    @git_branch.setter
    def git_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "git_branch", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The project ID to add the deployment to.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def redirect(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name that serves as a target destination for redirects.
        """
        return pulumi.get(self, "redirect")

    @redirect.setter
    def redirect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect", value)

    @property
    @pulumi.getter(name="redirectStatusCode")
    def redirect_status_code(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP status code to use when serving as a redirect.
        """
        return pulumi.get(self, "redirect_status_code")

    @redirect_status_code.setter
    def redirect_status_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "redirect_status_code", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the team the project exists under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


class ProjectDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_environment_id: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 git_branch: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 redirect: Optional[pulumi.Input[str]] = None,
                 redirect_status_code: Optional[pulumi.Input[int]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Project Domain resource.

        A Project Domain is used to associate a domain name with a `Project`.

        By default, Project Domains will be automatically applied to any `production` deployments.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_vercel as vercel

        example = vercel.Project("example", name="example-project")
        # A simple domain that will be automatically
        # applied to each production deployment
        example_project_domain = vercel.ProjectDomain("example",
            project_id=example.id,
            domain="i-love.vercel.app")
        # A redirect of a domain name to a second domain name.
        # The status_code can optionally be controlled.
        example_redirect = vercel.ProjectDomain("example_redirect",
            project_id=example.id,
            domain="i-also-love.vercel.app",
            redirect=example_project_domain.domain,
            redirect_status_code=307)
        ```

        ## Import

        If importing into a personal account, or with a team configured on

        the provider, simply use the project ID and domain.

        - project_id can be found in the project `settings` tab in the Vercel UI.

        ```sh
        $ pulumi import vercel:index/projectDomain:ProjectDomain example prj_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/example.com
        ```

        Alternatively, you can import via the team_id, project_id and domain name.

        - team_id can be found in the team `settings` tab in the Vercel UI.

        - project_id can be found in the project `settings` tab in the Vercel UI.

        ```sh
        $ pulumi import vercel:index/projectDomain:ProjectDomain example team_xxxxxxxxxxxxxxxxxxxxxxxx/prj_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/example.com
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] custom_environment_id: The name of the Custom Environment to link to the Project Domain. Deployments from this custom environment will be assigned the domain name.
        :param pulumi.Input[str] domain: The domain name to associate with the project.
        :param pulumi.Input[str] git_branch: Git branch to link to the project domain. Deployments from this git branch will be assigned the domain name.
        :param pulumi.Input[str] project_id: The project ID to add the deployment to.
        :param pulumi.Input[str] redirect: The domain name that serves as a target destination for redirects.
        :param pulumi.Input[int] redirect_status_code: The HTTP status code to use when serving as a redirect.
        :param pulumi.Input[str] team_id: The ID of the team the project exists under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Project Domain resource.

        A Project Domain is used to associate a domain name with a `Project`.

        By default, Project Domains will be automatically applied to any `production` deployments.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_vercel as vercel

        example = vercel.Project("example", name="example-project")
        # A simple domain that will be automatically
        # applied to each production deployment
        example_project_domain = vercel.ProjectDomain("example",
            project_id=example.id,
            domain="i-love.vercel.app")
        # A redirect of a domain name to a second domain name.
        # The status_code can optionally be controlled.
        example_redirect = vercel.ProjectDomain("example_redirect",
            project_id=example.id,
            domain="i-also-love.vercel.app",
            redirect=example_project_domain.domain,
            redirect_status_code=307)
        ```

        ## Import

        If importing into a personal account, or with a team configured on

        the provider, simply use the project ID and domain.

        - project_id can be found in the project `settings` tab in the Vercel UI.

        ```sh
        $ pulumi import vercel:index/projectDomain:ProjectDomain example prj_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/example.com
        ```

        Alternatively, you can import via the team_id, project_id and domain name.

        - team_id can be found in the team `settings` tab in the Vercel UI.

        - project_id can be found in the project `settings` tab in the Vercel UI.

        ```sh
        $ pulumi import vercel:index/projectDomain:ProjectDomain example team_xxxxxxxxxxxxxxxxxxxxxxxx/prj_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/example.com
        ```

        :param str resource_name: The name of the resource.
        :param ProjectDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_environment_id: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 git_branch: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 redirect: Optional[pulumi.Input[str]] = None,
                 redirect_status_code: Optional[pulumi.Input[int]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectDomainArgs.__new__(ProjectDomainArgs)

            __props__.__dict__["custom_environment_id"] = custom_environment_id
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["git_branch"] = git_branch
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["redirect"] = redirect
            __props__.__dict__["redirect_status_code"] = redirect_status_code
            __props__.__dict__["team_id"] = team_id
        super(ProjectDomain, __self__).__init__(
            'vercel:index/projectDomain:ProjectDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_environment_id: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            git_branch: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            redirect: Optional[pulumi.Input[str]] = None,
            redirect_status_code: Optional[pulumi.Input[int]] = None,
            team_id: Optional[pulumi.Input[str]] = None) -> 'ProjectDomain':
        """
        Get an existing ProjectDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] custom_environment_id: The name of the Custom Environment to link to the Project Domain. Deployments from this custom environment will be assigned the domain name.
        :param pulumi.Input[str] domain: The domain name to associate with the project.
        :param pulumi.Input[str] git_branch: Git branch to link to the project domain. Deployments from this git branch will be assigned the domain name.
        :param pulumi.Input[str] project_id: The project ID to add the deployment to.
        :param pulumi.Input[str] redirect: The domain name that serves as a target destination for redirects.
        :param pulumi.Input[int] redirect_status_code: The HTTP status code to use when serving as a redirect.
        :param pulumi.Input[str] team_id: The ID of the team the project exists under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectDomainState.__new__(_ProjectDomainState)

        __props__.__dict__["custom_environment_id"] = custom_environment_id
        __props__.__dict__["domain"] = domain
        __props__.__dict__["git_branch"] = git_branch
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["redirect"] = redirect
        __props__.__dict__["redirect_status_code"] = redirect_status_code
        __props__.__dict__["team_id"] = team_id
        return ProjectDomain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customEnvironmentId")
    def custom_environment_id(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the Custom Environment to link to the Project Domain. Deployments from this custom environment will be assigned the domain name.
        """
        return pulumi.get(self, "custom_environment_id")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        The domain name to associate with the project.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="gitBranch")
    def git_branch(self) -> pulumi.Output[Optional[str]]:
        """
        Git branch to link to the project domain. Deployments from this git branch will be assigned the domain name.
        """
        return pulumi.get(self, "git_branch")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The project ID to add the deployment to.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def redirect(self) -> pulumi.Output[Optional[str]]:
        """
        The domain name that serves as a target destination for redirects.
        """
        return pulumi.get(self, "redirect")

    @property
    @pulumi.getter(name="redirectStatusCode")
    def redirect_status_code(self) -> pulumi.Output[Optional[int]]:
        """
        The HTTP status code to use when serving as a redirect.
        """
        return pulumi.get(self, "redirect_status_code")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        The ID of the team the project exists under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

