# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'CustomEnvironmentBranchTracking',
    'DeploymentProjectSettings',
    'DnsRecordSrv',
    'FirewallConfigIpRules',
    'FirewallConfigIpRulesRule',
    'FirewallConfigManagedRulesets',
    'FirewallConfigManagedRulesetsBotFilter',
    'FirewallConfigManagedRulesetsOwasp',
    'FirewallConfigManagedRulesetsOwaspGen',
    'FirewallConfigManagedRulesetsOwaspJava',
    'FirewallConfigManagedRulesetsOwaspLfi',
    'FirewallConfigManagedRulesetsOwaspMa',
    'FirewallConfigManagedRulesetsOwaspPhp',
    'FirewallConfigManagedRulesetsOwaspRce',
    'FirewallConfigManagedRulesetsOwaspRfi',
    'FirewallConfigManagedRulesetsOwaspSd',
    'FirewallConfigManagedRulesetsOwaspSqli',
    'FirewallConfigManagedRulesetsOwaspXss',
    'FirewallConfigRules',
    'FirewallConfigRulesRule',
    'FirewallConfigRulesRuleAction',
    'FirewallConfigRulesRuleActionRateLimit',
    'FirewallConfigRulesRuleActionRedirect',
    'FirewallConfigRulesRuleConditionGroup',
    'FirewallConfigRulesRuleConditionGroupCondition',
    'MicrofrontendGroupDefaultApp',
    'ProjectEnvironment',
    'ProjectEnvironmentVariablesVariable',
    'ProjectGitComments',
    'ProjectGitRepository',
    'ProjectGitRepositoryDeployHook',
    'ProjectMembersMember',
    'ProjectOidcTokenConfig',
    'ProjectOptionsAllowlist',
    'ProjectOptionsAllowlistPath',
    'ProjectPasswordProtection',
    'ProjectResourceConfig',
    'ProjectTrustedIps',
    'ProjectTrustedIpsAddress',
    'ProjectVercelAuthentication',
    'TeamConfigRemoteCaching',
    'TeamConfigSaml',
    'TeamConfigSamlRoles',
    'TeamMemberProject',
    'GetCustomEnvironmentBranchTrackingResult',
    'GetMicrofrontendGroupDefaultAppResult',
    'GetProjectEnvironmentResult',
    'GetProjectGitCommentsResult',
    'GetProjectGitRepositoryResult',
    'GetProjectGitRepositoryDeployHookResult',
    'GetProjectMembersMemberResult',
    'GetProjectOidcTokenConfigResult',
    'GetProjectOptionsAllowlistResult',
    'GetProjectOptionsAllowlistPathResult',
    'GetProjectPasswordProtectionResult',
    'GetProjectResourceConfigResult',
    'GetProjectTrustedIpsResult',
    'GetProjectTrustedIpsAddressResult',
    'GetProjectVercelAuthenticationResult',
    'GetTeamConfigRemoteCachingResult',
    'GetTeamConfigSamlResult',
    'GetTeamConfigSamlRolesResult',
    'GetTeamMemberProjectResult',
]

@pulumi.output_type
class CustomEnvironmentBranchTracking(dict):
    def __init__(__self__, *,
                 pattern: str,
                 type: str):
        """
        :param str pattern: The pattern of the branch name to track.
        :param str type: How a branch name should be matched against the pattern. Must be one of 'startsWith', 'endsWith' or 'equals'.
        """
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        The pattern of the branch name to track.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        How a branch name should be matched against the pattern. Must be one of 'startsWith', 'endsWith' or 'equals'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DeploymentProjectSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildCommand":
            suggest = "build_command"
        elif key == "installCommand":
            suggest = "install_command"
        elif key == "outputDirectory":
            suggest = "output_directory"
        elif key == "rootDirectory":
            suggest = "root_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentProjectSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentProjectSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentProjectSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 build_command: Optional[str] = None,
                 framework: Optional[str] = None,
                 install_command: Optional[str] = None,
                 output_directory: Optional[str] = None,
                 root_directory: Optional[str] = None):
        """
        :param str build_command: The build command for this deployment. If omitted, this value will be taken from the project or automatically detected.
        :param str framework: The framework that is being used for this deployment. If omitted, no framework is selected.
        :param str install_command: The install command for this deployment. If omitted, this value will be taken from the project or automatically detected.
        :param str output_directory: The output directory of the deployment. If omitted, this value will be taken from the project or automatically detected.
        :param str root_directory: The name of a directory or relative path to the source code of your project. When null is used it will default to the project root.
        """
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if framework is not None:
            pulumi.set(__self__, "framework", framework)
        if install_command is not None:
            pulumi.set(__self__, "install_command", install_command)
        if output_directory is not None:
            pulumi.set(__self__, "output_directory", output_directory)
        if root_directory is not None:
            pulumi.set(__self__, "root_directory", root_directory)

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        The build command for this deployment. If omitted, this value will be taken from the project or automatically detected.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter
    def framework(self) -> Optional[str]:
        """
        The framework that is being used for this deployment. If omitted, no framework is selected.
        """
        return pulumi.get(self, "framework")

    @property
    @pulumi.getter(name="installCommand")
    def install_command(self) -> Optional[str]:
        """
        The install command for this deployment. If omitted, this value will be taken from the project or automatically detected.
        """
        return pulumi.get(self, "install_command")

    @property
    @pulumi.getter(name="outputDirectory")
    def output_directory(self) -> Optional[str]:
        """
        The output directory of the deployment. If omitted, this value will be taken from the project or automatically detected.
        """
        return pulumi.get(self, "output_directory")

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> Optional[str]:
        """
        The name of a directory or relative path to the source code of your project. When null is used it will default to the project root.
        """
        return pulumi.get(self, "root_directory")


@pulumi.output_type
class DnsRecordSrv(dict):
    def __init__(__self__, *,
                 port: int,
                 priority: int,
                 target: str,
                 weight: int):
        """
        :param int port: The TCP or UDP port on which the service is to be found.
        :param int priority: The priority of the target host, lower value means more preferred.
        :param str target: The canonical hostname of the machine providing the service, ending in a dot.
        :param int weight: A relative weight for records with the same priority, higher value means higher chance of getting picked.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The TCP or UDP port on which the service is to be found.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The priority of the target host, lower value means more preferred.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        The canonical hostname of the machine providing the service, ending in a dot.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        A relative weight for records with the same priority, higher value means higher chance of getting picked.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class FirewallConfigIpRules(dict):
    def __init__(__self__, *,
                 rules: Optional[Sequence['outputs.FirewallConfigIpRulesRule']] = None):
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.FirewallConfigIpRulesRule']]:
        return pulumi.get(self, "rules")


@pulumi.output_type
class FirewallConfigIpRulesRule(dict):
    def __init__(__self__, *,
                 action: str,
                 hostname: str,
                 ip: str,
                 id: Optional[str] = None,
                 notes: Optional[str] = None):
        """
        :param str hostname: Hosts to apply these rules to
        :param str ip: IP or CIDR to block
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip", ip)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Hosts to apply these rules to
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        IP or CIDR to block
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def notes(self) -> Optional[str]:
        return pulumi.get(self, "notes")


@pulumi.output_type
class FirewallConfigManagedRulesets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "botFilter":
            suggest = "bot_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallConfigManagedRulesets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallConfigManagedRulesets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallConfigManagedRulesets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bot_filter: Optional['outputs.FirewallConfigManagedRulesetsBotFilter'] = None,
                 owasp: Optional['outputs.FirewallConfigManagedRulesetsOwasp'] = None):
        """
        :param 'FirewallConfigManagedRulesetsBotFilterArgs' bot_filter: Enable the bot*filter managed ruleset and select action
        :param 'FirewallConfigManagedRulesetsOwaspArgs' owasp: Enable the owasp managed rulesets and select ruleset behaviors
        """
        if bot_filter is not None:
            pulumi.set(__self__, "bot_filter", bot_filter)
        if owasp is not None:
            pulumi.set(__self__, "owasp", owasp)

    @property
    @pulumi.getter(name="botFilter")
    def bot_filter(self) -> Optional['outputs.FirewallConfigManagedRulesetsBotFilter']:
        """
        Enable the bot*filter managed ruleset and select action
        """
        return pulumi.get(self, "bot_filter")

    @property
    @pulumi.getter
    def owasp(self) -> Optional['outputs.FirewallConfigManagedRulesetsOwasp']:
        """
        Enable the owasp managed rulesets and select ruleset behaviors
        """
        return pulumi.get(self, "owasp")


@pulumi.output_type
class FirewallConfigManagedRulesetsBotFilter(dict):
    def __init__(__self__, *,
                 action: Optional[str] = None,
                 active: Optional[bool] = None):
        if action is not None:
            pulumi.set(__self__, "action", action)
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")


@pulumi.output_type
class FirewallConfigManagedRulesetsOwasp(dict):
    def __init__(__self__, *,
                 gen: Optional['outputs.FirewallConfigManagedRulesetsOwaspGen'] = None,
                 java: Optional['outputs.FirewallConfigManagedRulesetsOwaspJava'] = None,
                 lfi: Optional['outputs.FirewallConfigManagedRulesetsOwaspLfi'] = None,
                 ma: Optional['outputs.FirewallConfigManagedRulesetsOwaspMa'] = None,
                 php: Optional['outputs.FirewallConfigManagedRulesetsOwaspPhp'] = None,
                 rce: Optional['outputs.FirewallConfigManagedRulesetsOwaspRce'] = None,
                 rfi: Optional['outputs.FirewallConfigManagedRulesetsOwaspRfi'] = None,
                 sd: Optional['outputs.FirewallConfigManagedRulesetsOwaspSd'] = None,
                 sqli: Optional['outputs.FirewallConfigManagedRulesetsOwaspSqli'] = None,
                 xss: Optional['outputs.FirewallConfigManagedRulesetsOwaspXss'] = None):
        """
        :param 'FirewallConfigManagedRulesetsOwaspGenArgs' gen: Generic Attack Detection
        :param 'FirewallConfigManagedRulesetsOwaspJavaArgs' java: Java Attack Detection
        :param 'FirewallConfigManagedRulesetsOwaspLfiArgs' lfi: Local File Inclusion Rules
        :param 'FirewallConfigManagedRulesetsOwaspMaArgs' ma: Multipart Rules
        :param 'FirewallConfigManagedRulesetsOwaspPhpArgs' php: PHP Attack Detection
        :param 'FirewallConfigManagedRulesetsOwaspRceArgs' rce: Remote Code Execution Rules
        :param 'FirewallConfigManagedRulesetsOwaspRfiArgs' rfi: Remote File Inclusion Rules
        :param 'FirewallConfigManagedRulesetsOwaspSdArgs' sd: Scanner Detection Rules
        :param 'FirewallConfigManagedRulesetsOwaspSqliArgs' sqli: SQL Injection Rules
        :param 'FirewallConfigManagedRulesetsOwaspXssArgs' xss: Cross Site Scripting Rules
        """
        if gen is not None:
            pulumi.set(__self__, "gen", gen)
        if java is not None:
            pulumi.set(__self__, "java", java)
        if lfi is not None:
            pulumi.set(__self__, "lfi", lfi)
        if ma is not None:
            pulumi.set(__self__, "ma", ma)
        if php is not None:
            pulumi.set(__self__, "php", php)
        if rce is not None:
            pulumi.set(__self__, "rce", rce)
        if rfi is not None:
            pulumi.set(__self__, "rfi", rfi)
        if sd is not None:
            pulumi.set(__self__, "sd", sd)
        if sqli is not None:
            pulumi.set(__self__, "sqli", sqli)
        if xss is not None:
            pulumi.set(__self__, "xss", xss)

    @property
    @pulumi.getter
    def gen(self) -> Optional['outputs.FirewallConfigManagedRulesetsOwaspGen']:
        """
        Generic Attack Detection
        """
        return pulumi.get(self, "gen")

    @property
    @pulumi.getter
    def java(self) -> Optional['outputs.FirewallConfigManagedRulesetsOwaspJava']:
        """
        Java Attack Detection
        """
        return pulumi.get(self, "java")

    @property
    @pulumi.getter
    def lfi(self) -> Optional['outputs.FirewallConfigManagedRulesetsOwaspLfi']:
        """
        Local File Inclusion Rules
        """
        return pulumi.get(self, "lfi")

    @property
    @pulumi.getter
    def ma(self) -> Optional['outputs.FirewallConfigManagedRulesetsOwaspMa']:
        """
        Multipart Rules
        """
        return pulumi.get(self, "ma")

    @property
    @pulumi.getter
    def php(self) -> Optional['outputs.FirewallConfigManagedRulesetsOwaspPhp']:
        """
        PHP Attack Detection
        """
        return pulumi.get(self, "php")

    @property
    @pulumi.getter
    def rce(self) -> Optional['outputs.FirewallConfigManagedRulesetsOwaspRce']:
        """
        Remote Code Execution Rules
        """
        return pulumi.get(self, "rce")

    @property
    @pulumi.getter
    def rfi(self) -> Optional['outputs.FirewallConfigManagedRulesetsOwaspRfi']:
        """
        Remote File Inclusion Rules
        """
        return pulumi.get(self, "rfi")

    @property
    @pulumi.getter
    def sd(self) -> Optional['outputs.FirewallConfigManagedRulesetsOwaspSd']:
        """
        Scanner Detection Rules
        """
        return pulumi.get(self, "sd")

    @property
    @pulumi.getter
    def sqli(self) -> Optional['outputs.FirewallConfigManagedRulesetsOwaspSqli']:
        """
        SQL Injection Rules
        """
        return pulumi.get(self, "sqli")

    @property
    @pulumi.getter
    def xss(self) -> Optional['outputs.FirewallConfigManagedRulesetsOwaspXss']:
        """
        Cross Site Scripting Rules
        """
        return pulumi.get(self, "xss")


@pulumi.output_type
class FirewallConfigManagedRulesetsOwaspGen(dict):
    def __init__(__self__, *,
                 action: str,
                 active: Optional[bool] = None):
        pulumi.set(__self__, "action", action)
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")


@pulumi.output_type
class FirewallConfigManagedRulesetsOwaspJava(dict):
    def __init__(__self__, *,
                 action: str,
                 active: Optional[bool] = None):
        pulumi.set(__self__, "action", action)
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")


@pulumi.output_type
class FirewallConfigManagedRulesetsOwaspLfi(dict):
    def __init__(__self__, *,
                 action: str,
                 active: Optional[bool] = None):
        pulumi.set(__self__, "action", action)
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")


@pulumi.output_type
class FirewallConfigManagedRulesetsOwaspMa(dict):
    def __init__(__self__, *,
                 action: str,
                 active: Optional[bool] = None):
        pulumi.set(__self__, "action", action)
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")


@pulumi.output_type
class FirewallConfigManagedRulesetsOwaspPhp(dict):
    def __init__(__self__, *,
                 action: str,
                 active: Optional[bool] = None):
        pulumi.set(__self__, "action", action)
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")


@pulumi.output_type
class FirewallConfigManagedRulesetsOwaspRce(dict):
    def __init__(__self__, *,
                 action: str,
                 active: Optional[bool] = None):
        pulumi.set(__self__, "action", action)
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")


@pulumi.output_type
class FirewallConfigManagedRulesetsOwaspRfi(dict):
    def __init__(__self__, *,
                 action: str,
                 active: Optional[bool] = None):
        pulumi.set(__self__, "action", action)
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")


@pulumi.output_type
class FirewallConfigManagedRulesetsOwaspSd(dict):
    def __init__(__self__, *,
                 action: str,
                 active: Optional[bool] = None):
        pulumi.set(__self__, "action", action)
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")


@pulumi.output_type
class FirewallConfigManagedRulesetsOwaspSqli(dict):
    def __init__(__self__, *,
                 action: str,
                 active: Optional[bool] = None):
        pulumi.set(__self__, "action", action)
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")


@pulumi.output_type
class FirewallConfigManagedRulesetsOwaspXss(dict):
    def __init__(__self__, *,
                 action: str,
                 active: Optional[bool] = None):
        pulumi.set(__self__, "action", action)
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        return pulumi.get(self, "active")


@pulumi.output_type
class FirewallConfigRules(dict):
    def __init__(__self__, *,
                 rules: Optional[Sequence['outputs.FirewallConfigRulesRule']] = None):
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.FirewallConfigRulesRule']]:
        return pulumi.get(self, "rules")


@pulumi.output_type
class FirewallConfigRulesRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conditionGroups":
            suggest = "condition_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallConfigRulesRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallConfigRulesRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallConfigRulesRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: 'outputs.FirewallConfigRulesRuleAction',
                 condition_groups: Sequence['outputs.FirewallConfigRulesRuleConditionGroup'],
                 name: str,
                 active: Optional[bool] = None,
                 description: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param 'FirewallConfigRulesRuleActionArgs' action: Actions to take when the condition groups match a request
        :param Sequence['FirewallConfigRulesRuleConditionGroupArgs'] condition_groups: Sets of conditions that may match a request
        :param str name: Name to identify the rule
        :param bool active: Rule is active or disabled
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "condition_groups", condition_groups)
        pulumi.set(__self__, "name", name)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.FirewallConfigRulesRuleAction':
        """
        Actions to take when the condition groups match a request
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="conditionGroups")
    def condition_groups(self) -> Sequence['outputs.FirewallConfigRulesRuleConditionGroup']:
        """
        Sets of conditions that may match a request
        """
        return pulumi.get(self, "condition_groups")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name to identify the rule
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def active(self) -> Optional[bool]:
        """
        Rule is active or disabled
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class FirewallConfigRulesRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionDuration":
            suggest = "action_duration"
        elif key == "rateLimit":
            suggest = "rate_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallConfigRulesRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallConfigRulesRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallConfigRulesRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 action_duration: Optional[str] = None,
                 rate_limit: Optional['outputs.FirewallConfigRulesRuleActionRateLimit'] = None,
                 redirect: Optional['outputs.FirewallConfigRulesRuleActionRedirect'] = None):
        """
        :param str action: Base action
        :param str action_duration: Forward persistence of a rule action
        :param 'FirewallConfigRulesRuleActionRateLimitArgs' rate_limit: Behavior or a rate limiting action. Required if action is rate*limit
        :param 'FirewallConfigRulesRuleActionRedirectArgs' redirect: How to redirect a request. Required if action is redirect
        """
        pulumi.set(__self__, "action", action)
        if action_duration is not None:
            pulumi.set(__self__, "action_duration", action_duration)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Base action
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="actionDuration")
    def action_duration(self) -> Optional[str]:
        """
        Forward persistence of a rule action
        """
        return pulumi.get(self, "action_duration")

    @property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional['outputs.FirewallConfigRulesRuleActionRateLimit']:
        """
        Behavior or a rate limiting action. Required if action is rate*limit
        """
        return pulumi.get(self, "rate_limit")

    @property
    @pulumi.getter
    def redirect(self) -> Optional['outputs.FirewallConfigRulesRuleActionRedirect']:
        """
        How to redirect a request. Required if action is redirect
        """
        return pulumi.get(self, "redirect")


@pulumi.output_type
class FirewallConfigRulesRuleActionRateLimit(dict):
    def __init__(__self__, *,
                 action: str,
                 algo: str,
                 keys: Sequence[str],
                 limit: int,
                 window: int):
        """
        :param str action: Action to take when rate limit is exceeded
        :param str algo: Rate limiting algorithm
        :param Sequence[str] keys: Keys used to bucket an individual client
        :param int limit: number of requests allowed in the window
        :param int window: Time window in seconds
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "algo", algo)
        pulumi.set(__self__, "keys", keys)
        pulumi.set(__self__, "limit", limit)
        pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Action to take when rate limit is exceeded
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def algo(self) -> str:
        """
        Rate limiting algorithm
        """
        return pulumi.get(self, "algo")

    @property
    @pulumi.getter
    def keys(self) -> Sequence[str]:
        """
        Keys used to bucket an individual client
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter
    def limit(self) -> int:
        """
        number of requests allowed in the window
        """
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter
    def window(self) -> int:
        """
        Time window in seconds
        """
        return pulumi.get(self, "window")


@pulumi.output_type
class FirewallConfigRulesRuleActionRedirect(dict):
    def __init__(__self__, *,
                 location: str,
                 permanent: bool):
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "permanent", permanent)

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def permanent(self) -> bool:
        return pulumi.get(self, "permanent")


@pulumi.output_type
class FirewallConfigRulesRuleConditionGroup(dict):
    def __init__(__self__, *,
                 conditions: Sequence['outputs.FirewallConfigRulesRuleConditionGroupCondition']):
        """
        :param Sequence['FirewallConfigRulesRuleConditionGroupConditionArgs'] conditions: Conditions that must all match within a group
        """
        pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.FirewallConfigRulesRuleConditionGroupCondition']:
        """
        Conditions that must all match within a group
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class FirewallConfigRulesRuleConditionGroupCondition(dict):
    def __init__(__self__, *,
                 op: str,
                 type: str,
                 key: Optional[str] = None,
                 neg: Optional[bool] = None,
                 value: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        :param str op: How to comparse type to value
        :param str type: Request key type to match against
        :param str key: Key within type to match against
        :param bool neg: Negate the condition
        :param str value: Value to match against
        :param Sequence[str] values: Values to match against if op is inc, ninc
        """
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if neg is not None:
            pulumi.set(__self__, "neg", neg)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        How to comparse type to value
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Request key type to match against
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Key within type to match against
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def neg(self) -> Optional[bool]:
        """
        Negate the condition
        """
        return pulumi.get(self, "neg")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value to match against
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        Values to match against if op is inc, ninc
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class MicrofrontendGroupDefaultApp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "defaultRoute":
            suggest = "default_route"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MicrofrontendGroupDefaultApp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MicrofrontendGroupDefaultApp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MicrofrontendGroupDefaultApp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_id: str,
                 default_route: Optional[str] = None):
        """
        :param str project_id: The ID of the project.
        :param str default_route: The default route for the project. Used for the screenshot of deployments.
        """
        pulumi.set(__self__, "project_id", project_id)
        if default_route is not None:
            pulumi.set(__self__, "default_route", default_route)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="defaultRoute")
    def default_route(self) -> Optional[str]:
        """
        The default route for the project. Used for the screenshot of deployments.
        """
        return pulumi.get(self, "default_route")


@pulumi.output_type
class ProjectEnvironment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customEnvironmentIds":
            suggest = "custom_environment_ids"
        elif key == "gitBranch":
            suggest = "git_branch"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectEnvironment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectEnvironment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectEnvironment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 value: str,
                 comment: Optional[str] = None,
                 custom_environment_ids: Optional[Sequence[str]] = None,
                 git_branch: Optional[str] = None,
                 id: Optional[str] = None,
                 sensitive: Optional[bool] = None,
                 targets: Optional[Sequence[str]] = None):
        """
        :param str key: The name of the Environment Variable.
        :param str value: The value of the Environment Variable.
        :param str comment: A comment explaining what the environment variable is for.
        :param Sequence[str] custom_environment_ids: The IDs of Custom Environments that the Environment Variable should be present on. At least one of `target` or `custom_environment_ids` must be set.
        :param str git_branch: The git branch of the Environment Variable.
        :param str id: The ID of the Environment Variable.
        :param bool sensitive: Whether the Environment Variable is sensitive or not. (May be affected by a [team-wide environment variable policy](https://vercel.com/docs/projects/environment-variables/sensitive-environment-variables#environment-variables-policy))
        :param Sequence[str] targets: The environments that the Environment Variable should be present on. Valid targets are either `production`, `preview`, or `development`. At least one of `target` or `custom_environment_ids` must be set.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if custom_environment_ids is not None:
            pulumi.set(__self__, "custom_environment_ids", custom_environment_ids)
        if git_branch is not None:
            pulumi.set(__self__, "git_branch", git_branch)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if sensitive is not None:
            pulumi.set(__self__, "sensitive", sensitive)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the Environment Variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the Environment Variable.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        A comment explaining what the environment variable is for.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="customEnvironmentIds")
    def custom_environment_ids(self) -> Optional[Sequence[str]]:
        """
        The IDs of Custom Environments that the Environment Variable should be present on. At least one of `target` or `custom_environment_ids` must be set.
        """
        return pulumi.get(self, "custom_environment_ids")

    @property
    @pulumi.getter(name="gitBranch")
    def git_branch(self) -> Optional[str]:
        """
        The git branch of the Environment Variable.
        """
        return pulumi.get(self, "git_branch")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the Environment Variable.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def sensitive(self) -> Optional[bool]:
        """
        Whether the Environment Variable is sensitive or not. (May be affected by a [team-wide environment variable policy](https://vercel.com/docs/projects/environment-variables/sensitive-environment-variables#environment-variables-policy))
        """
        return pulumi.get(self, "sensitive")

    @property
    @pulumi.getter
    def targets(self) -> Optional[Sequence[str]]:
        """
        The environments that the Environment Variable should be present on. Valid targets are either `production`, `preview`, or `development`. At least one of `target` or `custom_environment_ids` must be set.
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class ProjectEnvironmentVariablesVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customEnvironmentIds":
            suggest = "custom_environment_ids"
        elif key == "gitBranch":
            suggest = "git_branch"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectEnvironmentVariablesVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectEnvironmentVariablesVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectEnvironmentVariablesVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 value: str,
                 comment: Optional[str] = None,
                 custom_environment_ids: Optional[Sequence[str]] = None,
                 git_branch: Optional[str] = None,
                 id: Optional[str] = None,
                 sensitive: Optional[bool] = None,
                 targets: Optional[Sequence[str]] = None):
        """
        :param str key: The name of the Environment Variable.
        :param str value: The value of the Environment Variable.
        :param str comment: A comment explaining what the environment variable is for.
        :param Sequence[str] custom_environment_ids: The IDs of Custom Environments that the Environment Variable should be present on. At least one of `target` or `custom_environment_ids` must be set.
        :param str git_branch: The git branch of the Environment Variable.
        :param str id: The ID of the Environment Variable.
        :param bool sensitive: Whether the Environment Variable is sensitive or not.
        :param Sequence[str] targets: The environments that the Environment Variable should be present on. Valid targets are either `production`, `preview`, or `development`. At least one of `target` or `custom_environment_ids` must be set.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if custom_environment_ids is not None:
            pulumi.set(__self__, "custom_environment_ids", custom_environment_ids)
        if git_branch is not None:
            pulumi.set(__self__, "git_branch", git_branch)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if sensitive is not None:
            pulumi.set(__self__, "sensitive", sensitive)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the Environment Variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the Environment Variable.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        A comment explaining what the environment variable is for.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="customEnvironmentIds")
    def custom_environment_ids(self) -> Optional[Sequence[str]]:
        """
        The IDs of Custom Environments that the Environment Variable should be present on. At least one of `target` or `custom_environment_ids` must be set.
        """
        return pulumi.get(self, "custom_environment_ids")

    @property
    @pulumi.getter(name="gitBranch")
    def git_branch(self) -> Optional[str]:
        """
        The git branch of the Environment Variable.
        """
        return pulumi.get(self, "git_branch")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the Environment Variable.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def sensitive(self) -> Optional[bool]:
        """
        Whether the Environment Variable is sensitive or not.
        """
        return pulumi.get(self, "sensitive")

    @property
    @pulumi.getter
    def targets(self) -> Optional[Sequence[str]]:
        """
        The environments that the Environment Variable should be present on. Valid targets are either `production`, `preview`, or `development`. At least one of `target` or `custom_environment_ids` must be set.
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class ProjectGitComments(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onCommit":
            suggest = "on_commit"
        elif key == "onPullRequest":
            suggest = "on_pull_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectGitComments. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectGitComments.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectGitComments.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_commit: bool,
                 on_pull_request: bool):
        """
        :param bool on_commit: Whether Commit comments are enabled
        :param bool on_pull_request: Whether Pull Request comments are enabled
        """
        pulumi.set(__self__, "on_commit", on_commit)
        pulumi.set(__self__, "on_pull_request", on_pull_request)

    @property
    @pulumi.getter(name="onCommit")
    def on_commit(self) -> bool:
        """
        Whether Commit comments are enabled
        """
        return pulumi.get(self, "on_commit")

    @property
    @pulumi.getter(name="onPullRequest")
    def on_pull_request(self) -> bool:
        """
        Whether Pull Request comments are enabled
        """
        return pulumi.get(self, "on_pull_request")


@pulumi.output_type
class ProjectGitRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployHooks":
            suggest = "deploy_hooks"
        elif key == "productionBranch":
            suggest = "production_branch"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectGitRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectGitRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectGitRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repo: str,
                 type: str,
                 deploy_hooks: Optional[Sequence['outputs.ProjectGitRepositoryDeployHook']] = None,
                 production_branch: Optional[str] = None):
        """
        :param str repo: The name of the git repository. For example: `vercel/next.js`.
        :param str type: The git provider of the repository. Must be either `github`, `gitlab`, or `bitbucket`.
        :param Sequence['ProjectGitRepositoryDeployHookArgs'] deploy_hooks: Deploy hooks are unique URLs that allow you to trigger a deployment of a given branch. See https://vercel.com/docs/deployments/deploy-hooks for full information.
        :param str production_branch: By default, every commit pushed to the main branch will trigger a Production Deployment instead of the usual Preview Deployment. You can switch to a different branch here.
        """
        pulumi.set(__self__, "repo", repo)
        pulumi.set(__self__, "type", type)
        if deploy_hooks is not None:
            pulumi.set(__self__, "deploy_hooks", deploy_hooks)
        if production_branch is not None:
            pulumi.set(__self__, "production_branch", production_branch)

    @property
    @pulumi.getter
    def repo(self) -> str:
        """
        The name of the git repository. For example: `vercel/next.js`.
        """
        return pulumi.get(self, "repo")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The git provider of the repository. Must be either `github`, `gitlab`, or `bitbucket`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="deployHooks")
    def deploy_hooks(self) -> Optional[Sequence['outputs.ProjectGitRepositoryDeployHook']]:
        """
        Deploy hooks are unique URLs that allow you to trigger a deployment of a given branch. See https://vercel.com/docs/deployments/deploy-hooks for full information.
        """
        return pulumi.get(self, "deploy_hooks")

    @property
    @pulumi.getter(name="productionBranch")
    def production_branch(self) -> Optional[str]:
        """
        By default, every commit pushed to the main branch will trigger a Production Deployment instead of the usual Preview Deployment. You can switch to a different branch here.
        """
        return pulumi.get(self, "production_branch")


@pulumi.output_type
class ProjectGitRepositoryDeployHook(dict):
    def __init__(__self__, *,
                 name: str,
                 ref: str,
                 id: Optional[str] = None,
                 url: Optional[str] = None):
        """
        :param str name: The name of the deploy hook.
        :param str ref: The branch or commit hash that should be deployed.
        :param str id: The ID of the deploy hook.
        :param str url: A URL that, when a POST request is made to, will trigger a new deployment.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ref", ref)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the deploy hook.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ref(self) -> str:
        """
        The branch or commit hash that should be deployed.
        """
        return pulumi.get(self, "ref")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the deploy hook.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        A URL that, when a POST request is made to, will trigger a new deployment.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ProjectMembersMember(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectMembersMember. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectMembersMember.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectMembersMember.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role: str,
                 email: Optional[str] = None,
                 user_id: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str role: The role that the user should have in the project. One of 'MEMBER', 'PROJECT*DEVELOPER', or 'PROJECT*VIEWER'.
        :param str email: The email of the user to add to the project. Exactly one of `user_id`, `email`, or `username` must be specified.
        :param str user_id: The ID of the user to add to the project. Exactly one of `user_id`, `email`, or `username` must be specified.
        :param str username: The username of the user to add to the project. Exactly one of `user_id`, `email`, or `username` must be specified.
        """
        pulumi.set(__self__, "role", role)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role that the user should have in the project. One of 'MEMBER', 'PROJECT*DEVELOPER', or 'PROJECT*VIEWER'.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email of the user to add to the project. Exactly one of `user_id`, `email`, or `username` must be specified.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[str]:
        """
        The ID of the user to add to the project. Exactly one of `user_id`, `email`, or `username` must be specified.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username of the user to add to the project. Exactly one of `user_id`, `email`, or `username` must be specified.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ProjectOidcTokenConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "issuerMode":
            suggest = "issuer_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectOidcTokenConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectOidcTokenConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectOidcTokenConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 issuer_mode: Optional[str] = None):
        """
        :param bool enabled: When true, Vercel issued OpenID Connect (OIDC) tokens will be available on the compute environments. See https://vercel.com/docs/security/secure-backend-access/oidc for more information.
        :param str issuer_mode: Configures the URL of the `iss` claim. `team` = `https://oidc.vercel.com/[team_slug]` `global` = `https://oidc.vercel.com`
        """
        pulumi.set(__self__, "enabled", enabled)
        if issuer_mode is not None:
            pulumi.set(__self__, "issuer_mode", issuer_mode)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        When true, Vercel issued OpenID Connect (OIDC) tokens will be available on the compute environments. See https://vercel.com/docs/security/secure-backend-access/oidc for more information.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> Optional[str]:
        """
        Configures the URL of the `iss` claim. `team` = `https://oidc.vercel.com/[team_slug]` `global` = `https://oidc.vercel.com`
        """
        return pulumi.get(self, "issuer_mode")


@pulumi.output_type
class ProjectOptionsAllowlist(dict):
    def __init__(__self__, *,
                 paths: Sequence['outputs.ProjectOptionsAllowlistPath']):
        """
        :param Sequence['ProjectOptionsAllowlistPathArgs'] paths: The allowed paths for the OPTIONS Allowlist. Incoming requests will bypass Deployment Protection if they have the method `OPTIONS` and **start with** one of the path values.
        """
        pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> Sequence['outputs.ProjectOptionsAllowlistPath']:
        """
        The allowed paths for the OPTIONS Allowlist. Incoming requests will bypass Deployment Protection if they have the method `OPTIONS` and **start with** one of the path values.
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class ProjectOptionsAllowlistPath(dict):
    def __init__(__self__, *,
                 value: str):
        """
        :param str value: The path prefix to compare with the incoming request path.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The path prefix to compare with the incoming request path.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ProjectPasswordProtection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentType":
            suggest = "deployment_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectPasswordProtection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectPasswordProtection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectPasswordProtection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_type: str,
                 password: str):
        """
        :param str deployment_type: The deployment environment to protect. Must be one of `standard_protection`, `all_deployments`, or `only_preview_deployments`.
        :param str password: The password that visitors must enter to gain access to your Preview Deployments. Drift detection is not possible for this field.
        """
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The deployment environment to protect. Must be one of `standard_protection`, `all_deployments`, or `only_preview_deployments`.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password that visitors must enter to gain access to your Preview Deployments. Drift detection is not possible for this field.
        """
        return pulumi.get(self, "password")


@pulumi.output_type
class ProjectResourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionDefaultCpuType":
            suggest = "function_default_cpu_type"
        elif key == "functionDefaultTimeout":
            suggest = "function_default_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectResourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectResourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectResourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fluid: Optional[bool] = None,
                 function_default_cpu_type: Optional[str] = None,
                 function_default_timeout: Optional[int] = None):
        """
        :param bool fluid: Enable fluid compute for your Vercel Functions to automatically manage concurrency and optimize performance. Vercel will handle the defaults to ensure the best experience for your workload.
        :param str function_default_cpu_type: The amount of CPU available to your Serverless Functions. Should be one of 'standard_legacy' (0.6vCPU), 'standard' (1vCPU) or 'performance' (1.7vCPUs).
        :param int function_default_timeout: The default timeout for Serverless Functions.
        """
        if fluid is not None:
            pulumi.set(__self__, "fluid", fluid)
        if function_default_cpu_type is not None:
            pulumi.set(__self__, "function_default_cpu_type", function_default_cpu_type)
        if function_default_timeout is not None:
            pulumi.set(__self__, "function_default_timeout", function_default_timeout)

    @property
    @pulumi.getter
    def fluid(self) -> Optional[bool]:
        """
        Enable fluid compute for your Vercel Functions to automatically manage concurrency and optimize performance. Vercel will handle the defaults to ensure the best experience for your workload.
        """
        return pulumi.get(self, "fluid")

    @property
    @pulumi.getter(name="functionDefaultCpuType")
    def function_default_cpu_type(self) -> Optional[str]:
        """
        The amount of CPU available to your Serverless Functions. Should be one of 'standard_legacy' (0.6vCPU), 'standard' (1vCPU) or 'performance' (1.7vCPUs).
        """
        return pulumi.get(self, "function_default_cpu_type")

    @property
    @pulumi.getter(name="functionDefaultTimeout")
    def function_default_timeout(self) -> Optional[int]:
        """
        The default timeout for Serverless Functions.
        """
        return pulumi.get(self, "function_default_timeout")


@pulumi.output_type
class ProjectTrustedIps(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentType":
            suggest = "deployment_type"
        elif key == "protectionMode":
            suggest = "protection_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectTrustedIps. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectTrustedIps.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectTrustedIps.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 addresses: Sequence['outputs.ProjectTrustedIpsAddress'],
                 deployment_type: str,
                 protection_mode: Optional[str] = None):
        """
        :param Sequence['ProjectTrustedIpsAddressArgs'] addresses: The allowed IP addressses and CIDR ranges with optional descriptions.
        :param str deployment_type: The deployment environment to protect. Must be one of `standard_protection`, `all_deployments`, `only_production_deployments`, or `only_preview_deployments`.
        :param str protection_mode: Whether or not Trusted IPs is optional to access a deployment. Must be either `trusted_ip_required` or `trusted_ip_optional`. `trusted_ip_optional` is only available with Standalone Trusted IPs.
        """
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "deployment_type", deployment_type)
        if protection_mode is not None:
            pulumi.set(__self__, "protection_mode", protection_mode)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence['outputs.ProjectTrustedIpsAddress']:
        """
        The allowed IP addressses and CIDR ranges with optional descriptions.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The deployment environment to protect. Must be one of `standard_protection`, `all_deployments`, `only_production_deployments`, or `only_preview_deployments`.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> Optional[str]:
        """
        Whether or not Trusted IPs is optional to access a deployment. Must be either `trusted_ip_required` or `trusted_ip_optional`. `trusted_ip_optional` is only available with Standalone Trusted IPs.
        """
        return pulumi.get(self, "protection_mode")


@pulumi.output_type
class ProjectTrustedIpsAddress(dict):
    def __init__(__self__, *,
                 value: str,
                 note: Optional[str] = None):
        """
        :param str value: The address or CIDR range that can access deployments.
        :param str note: A description for the value
        """
        pulumi.set(__self__, "value", value)
        if note is not None:
            pulumi.set(__self__, "note", note)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The address or CIDR range that can access deployments.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def note(self) -> Optional[str]:
        """
        A description for the value
        """
        return pulumi.get(self, "note")


@pulumi.output_type
class ProjectVercelAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentType":
            suggest = "deployment_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectVercelAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectVercelAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectVercelAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_type: str):
        """
        :param str deployment_type: The deployment environment to protect. Must be one of `standard_protection`, `all_deployments`, `only_preview_deployments`, or `none`.
        """
        pulumi.set(__self__, "deployment_type", deployment_type)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The deployment environment to protect. Must be one of `standard_protection`, `all_deployments`, `only_preview_deployments`, or `none`.
        """
        return pulumi.get(self, "deployment_type")


@pulumi.output_type
class TeamConfigRemoteCaching(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Indicates if Remote Caching is enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Indicates if Remote Caching is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class TeamConfigSaml(dict):
    def __init__(__self__, *,
                 enforced: bool,
                 roles: Optional[Mapping[str, 'outputs.TeamConfigSamlRoles']] = None):
        """
        :param bool enforced: Indicates if SAML is enforced for the team.
        :param Mapping[str, 'TeamConfigSamlRolesArgs'] roles: Directory groups to role or access group mappings. For each directory group, specify either a role or access group id.
        """
        pulumi.set(__self__, "enforced", enforced)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter
    def enforced(self) -> bool:
        """
        Indicates if SAML is enforced for the team.
        """
        return pulumi.get(self, "enforced")

    @property
    @pulumi.getter
    def roles(self) -> Optional[Mapping[str, 'outputs.TeamConfigSamlRoles']]:
        """
        Directory groups to role or access group mappings. For each directory group, specify either a role or access group id.
        """
        return pulumi.get(self, "roles")


@pulumi.output_type
class TeamConfigSamlRoles(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessGroupId":
            suggest = "access_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TeamConfigSamlRoles. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TeamConfigSamlRoles.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TeamConfigSamlRoles.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_group_id: Optional[str] = None,
                 role: Optional[str] = None):
        """
        :param str access_group_id: The access group id to assign to the user.
        :param str role: The team level role to assign to the user. One of 'MEMBER', 'OWNER', 'VIEWER', 'DEVELOPER', 'BILLING' or 'CONTRIBUTOR'.
        """
        if access_group_id is not None:
            pulumi.set(__self__, "access_group_id", access_group_id)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="accessGroupId")
    def access_group_id(self) -> Optional[str]:
        """
        The access group id to assign to the user.
        """
        return pulumi.get(self, "access_group_id")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        The team level role to assign to the user. One of 'MEMBER', 'OWNER', 'VIEWER', 'DEVELOPER', 'BILLING' or 'CONTRIBUTOR'.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class TeamMemberProject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TeamMemberProject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TeamMemberProject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TeamMemberProject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_id: str,
                 role: str):
        """
        :param str project_id: The ID of the project that the user should be granted access to.
        :param str role: The role that the user should have in the project.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project that the user should be granted access to.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role that the user should have in the project.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GetCustomEnvironmentBranchTrackingResult(dict):
    def __init__(__self__, *,
                 pattern: str,
                 type: str):
        """
        :param str pattern: The pattern of the branch name to track.
        :param str type: How a branch name should be matched against the pattern. Must be one of 'startsWith', 'endsWith' or 'equals'.
        """
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        The pattern of the branch name to track.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        How a branch name should be matched against the pattern. Must be one of 'startsWith', 'endsWith' or 'equals'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMicrofrontendGroupDefaultAppResult(dict):
    def __init__(__self__, *,
                 default_route: str,
                 project_id: str):
        """
        :param str default_route: The default route for the project. Used for the screenshot of deployments.
        :param str project_id: The ID of the project.
        """
        pulumi.set(__self__, "default_route", default_route)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="defaultRoute")
    def default_route(self) -> str:
        """
        The default route for the project. Used for the screenshot of deployments.
        """
        return pulumi.get(self, "default_route")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class GetProjectEnvironmentResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 custom_environment_ids: Sequence[str],
                 git_branch: str,
                 id: str,
                 key: str,
                 sensitive: bool,
                 targets: Sequence[str],
                 value: str):
        """
        :param str comment: A comment explaining what the environment variable is for.
        :param Sequence[str] custom_environment_ids: The IDs of Custom Environments that the Environment Variable should be present on.
        :param str git_branch: The git branch of the environment variable.
        :param str id: The ID of the environment variable
        :param str key: The name of the environment variable.
        :param bool sensitive: Whether the Environment Variable is sensitive or not. Note that the value will be `null` for sensitive environment variables.
        :param Sequence[str] targets: The environments that the environment variable should be present on. Valid targets are either `production`, `preview`, or `development`.
        :param str value: The value of the environment variable.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "custom_environment_ids", custom_environment_ids)
        pulumi.set(__self__, "git_branch", git_branch)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "sensitive", sensitive)
        pulumi.set(__self__, "targets", targets)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def comment(self) -> str:
        """
        A comment explaining what the environment variable is for.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="customEnvironmentIds")
    def custom_environment_ids(self) -> Sequence[str]:
        """
        The IDs of Custom Environments that the Environment Variable should be present on.
        """
        return pulumi.get(self, "custom_environment_ids")

    @property
    @pulumi.getter(name="gitBranch")
    def git_branch(self) -> str:
        """
        The git branch of the environment variable.
        """
        return pulumi.get(self, "git_branch")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the environment variable
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def sensitive(self) -> bool:
        """
        Whether the Environment Variable is sensitive or not. Note that the value will be `null` for sensitive environment variables.
        """
        return pulumi.get(self, "sensitive")

    @property
    @pulumi.getter
    def targets(self) -> Sequence[str]:
        """
        The environments that the environment variable should be present on. Valid targets are either `production`, `preview`, or `development`.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetProjectGitCommentsResult(dict):
    def __init__(__self__, *,
                 on_commit: bool,
                 on_pull_request: bool):
        """
        :param bool on_commit: Whether Commit comments are enabled
        :param bool on_pull_request: Whether Pull Request comments are enabled
        """
        pulumi.set(__self__, "on_commit", on_commit)
        pulumi.set(__self__, "on_pull_request", on_pull_request)

    @property
    @pulumi.getter(name="onCommit")
    def on_commit(self) -> bool:
        """
        Whether Commit comments are enabled
        """
        return pulumi.get(self, "on_commit")

    @property
    @pulumi.getter(name="onPullRequest")
    def on_pull_request(self) -> bool:
        """
        Whether Pull Request comments are enabled
        """
        return pulumi.get(self, "on_pull_request")


@pulumi.output_type
class GetProjectGitRepositoryResult(dict):
    def __init__(__self__, *,
                 deploy_hooks: Sequence['outputs.GetProjectGitRepositoryDeployHookResult'],
                 production_branch: str,
                 repo: str,
                 type: str):
        """
        :param Sequence['GetProjectGitRepositoryDeployHookArgs'] deploy_hooks: Deploy hooks are unique URLs that allow you to trigger a deployment of a given branch. See https://vercel.com/docs/deployments/deploy-hooks for full information.
        :param str production_branch: By default, every commit pushed to the main branch will trigger a Production Deployment instead of the usual Preview Deployment. You can switch to a different branch here.
        :param str repo: The name of the git repository. For example: `vercel/next.js`.
        :param str type: The git provider of the repository. Must be either `github`, `gitlab`, or `bitbucket`.
        """
        pulumi.set(__self__, "deploy_hooks", deploy_hooks)
        pulumi.set(__self__, "production_branch", production_branch)
        pulumi.set(__self__, "repo", repo)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="deployHooks")
    def deploy_hooks(self) -> Sequence['outputs.GetProjectGitRepositoryDeployHookResult']:
        """
        Deploy hooks are unique URLs that allow you to trigger a deployment of a given branch. See https://vercel.com/docs/deployments/deploy-hooks for full information.
        """
        return pulumi.get(self, "deploy_hooks")

    @property
    @pulumi.getter(name="productionBranch")
    def production_branch(self) -> str:
        """
        By default, every commit pushed to the main branch will trigger a Production Deployment instead of the usual Preview Deployment. You can switch to a different branch here.
        """
        return pulumi.get(self, "production_branch")

    @property
    @pulumi.getter
    def repo(self) -> str:
        """
        The name of the git repository. For example: `vercel/next.js`.
        """
        return pulumi.get(self, "repo")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The git provider of the repository. Must be either `github`, `gitlab`, or `bitbucket`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetProjectGitRepositoryDeployHookResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 ref: str,
                 url: str):
        """
        :param str id: The ID of the deploy hook.
        :param str name: The name of the deploy hook.
        :param str ref: The branch or commit hash that should be deployed.
        :param str url: A URL that, when a POST request is made to, will trigger a new deployment.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ref", ref)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the deploy hook.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the deploy hook.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ref(self) -> str:
        """
        The branch or commit hash that should be deployed.
        """
        return pulumi.get(self, "ref")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        A URL that, when a POST request is made to, will trigger a new deployment.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetProjectMembersMemberResult(dict):
    def __init__(__self__, *,
                 email: str,
                 role: str,
                 user_id: str,
                 username: str):
        """
        :param str email: The email of the user.
        :param str role: The role of the user in the project. One of 'MEMBER', 'PROJECT*DEVELOPER', or 'PROJECT*VIEWER'.
        :param str user_id: The ID of the user.
        :param str username: The username of the user.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role of the user in the project. One of 'MEMBER', 'PROJECT*DEVELOPER', or 'PROJECT*VIEWER'.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username of the user.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetProjectOidcTokenConfigResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 issuer_mode: str):
        """
        :param bool enabled: When true, Vercel issued OpenID Connect (OIDC) tokens will be available on the compute environments. See https://vercel.com/docs/security/secure-backend-access/oidc for more information.
        :param str issuer_mode: Configures the URL of the `iss` claim. `team` = `https://oidc.vercel.com/[team_slug]` `global` = `https://oidc.vercel.com`
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "issuer_mode", issuer_mode)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        When true, Vercel issued OpenID Connect (OIDC) tokens will be available on the compute environments. See https://vercel.com/docs/security/secure-backend-access/oidc for more information.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> str:
        """
        Configures the URL of the `iss` claim. `team` = `https://oidc.vercel.com/[team_slug]` `global` = `https://oidc.vercel.com`
        """
        return pulumi.get(self, "issuer_mode")


@pulumi.output_type
class GetProjectOptionsAllowlistResult(dict):
    def __init__(__self__, *,
                 paths: Sequence['outputs.GetProjectOptionsAllowlistPathResult']):
        """
        :param Sequence['GetProjectOptionsAllowlistPathArgs'] paths: The allowed paths for the OPTIONS Allowlist. Incoming requests will bypass Deployment Protection if they have the method `OPTIONS` and **start with** one of the path values.
        """
        pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> Sequence['outputs.GetProjectOptionsAllowlistPathResult']:
        """
        The allowed paths for the OPTIONS Allowlist. Incoming requests will bypass Deployment Protection if they have the method `OPTIONS` and **start with** one of the path values.
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class GetProjectOptionsAllowlistPathResult(dict):
    def __init__(__self__, *,
                 value: str):
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetProjectPasswordProtectionResult(dict):
    def __init__(__self__, *,
                 deployment_type: str):
        """
        :param str deployment_type: The deployment environment that will be protected.
        """
        pulumi.set(__self__, "deployment_type", deployment_type)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The deployment environment that will be protected.
        """
        return pulumi.get(self, "deployment_type")


@pulumi.output_type
class GetProjectResourceConfigResult(dict):
    def __init__(__self__, *,
                 fluid: bool,
                 function_default_cpu_type: str,
                 function_default_timeout: int):
        """
        :param bool fluid: Enable fluid compute for your Vercel Functions to automatically manage concurrency and optimize performance. Vercel will handle the defaults to ensure the best experience for your workload.
        :param str function_default_cpu_type: The amount of CPU available to your Serverless Functions. Should be one of 'standard_legacy' (0.6vCPU), 'standard' (1vCPU) or 'performance' (1.7vCPUs).
        :param int function_default_timeout: The default timeout for Serverless Functions.
        """
        pulumi.set(__self__, "fluid", fluid)
        pulumi.set(__self__, "function_default_cpu_type", function_default_cpu_type)
        pulumi.set(__self__, "function_default_timeout", function_default_timeout)

    @property
    @pulumi.getter
    def fluid(self) -> bool:
        """
        Enable fluid compute for your Vercel Functions to automatically manage concurrency and optimize performance. Vercel will handle the defaults to ensure the best experience for your workload.
        """
        return pulumi.get(self, "fluid")

    @property
    @pulumi.getter(name="functionDefaultCpuType")
    def function_default_cpu_type(self) -> str:
        """
        The amount of CPU available to your Serverless Functions. Should be one of 'standard_legacy' (0.6vCPU), 'standard' (1vCPU) or 'performance' (1.7vCPUs).
        """
        return pulumi.get(self, "function_default_cpu_type")

    @property
    @pulumi.getter(name="functionDefaultTimeout")
    def function_default_timeout(self) -> int:
        """
        The default timeout for Serverless Functions.
        """
        return pulumi.get(self, "function_default_timeout")


@pulumi.output_type
class GetProjectTrustedIpsResult(dict):
    def __init__(__self__, *,
                 addresses: Sequence['outputs.GetProjectTrustedIpsAddressResult'],
                 deployment_type: str,
                 protection_mode: str):
        """
        :param Sequence['GetProjectTrustedIpsAddressArgs'] addresses: The allowed IP addressses and CIDR ranges with optional descriptions.
        :param str deployment_type: The deployment environment that will be protected.
        :param str protection_mode: Whether or not Trusted IPs is required or optional to access a deployment.
        """
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "protection_mode", protection_mode)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence['outputs.GetProjectTrustedIpsAddressResult']:
        """
        The allowed IP addressses and CIDR ranges with optional descriptions.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The deployment environment that will be protected.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> str:
        """
        Whether or not Trusted IPs is required or optional to access a deployment.
        """
        return pulumi.get(self, "protection_mode")


@pulumi.output_type
class GetProjectTrustedIpsAddressResult(dict):
    def __init__(__self__, *,
                 note: str,
                 value: str):
        pulumi.set(__self__, "note", note)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def note(self) -> str:
        return pulumi.get(self, "note")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetProjectVercelAuthenticationResult(dict):
    def __init__(__self__, *,
                 deployment_type: str):
        """
        :param str deployment_type: The deployment environment that will be protected.
        """
        pulumi.set(__self__, "deployment_type", deployment_type)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The deployment environment that will be protected.
        """
        return pulumi.get(self, "deployment_type")


@pulumi.output_type
class GetTeamConfigRemoteCachingResult(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Indicates if Remote Caching is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates if Remote Caching is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetTeamConfigSamlResult(dict):
    def __init__(__self__, *,
                 enforced: bool,
                 roles: Mapping[str, 'outputs.GetTeamConfigSamlRolesResult']):
        """
        :param bool enforced: Indicates if SAML is enforced for the team.
        :param Mapping[str, 'GetTeamConfigSamlRolesArgs'] roles: Directory groups to role or access group mappings. For each directory group, either a role or access group id is specified.
        """
        pulumi.set(__self__, "enforced", enforced)
        pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter
    def enforced(self) -> bool:
        """
        Indicates if SAML is enforced for the team.
        """
        return pulumi.get(self, "enforced")

    @property
    @pulumi.getter
    def roles(self) -> Mapping[str, 'outputs.GetTeamConfigSamlRolesResult']:
        """
        Directory groups to role or access group mappings. For each directory group, either a role or access group id is specified.
        """
        return pulumi.get(self, "roles")


@pulumi.output_type
class GetTeamConfigSamlRolesResult(dict):
    def __init__(__self__, *,
                 access_group_id: str,
                 role: str):
        """
        :param str access_group_id: The access group the assign is assigned to.
        :param str role: The team level role the user is assigned. One of 'MEMBER', 'OWNER', 'VIEWER', 'DEVELOPER', 'BILLING' or 'CONTRIBUTOR'.
        """
        pulumi.set(__self__, "access_group_id", access_group_id)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="accessGroupId")
    def access_group_id(self) -> str:
        """
        The access group the assign is assigned to.
        """
        return pulumi.get(self, "access_group_id")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The team level role the user is assigned. One of 'MEMBER', 'OWNER', 'VIEWER', 'DEVELOPER', 'BILLING' or 'CONTRIBUTOR'.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GetTeamMemberProjectResult(dict):
    def __init__(__self__, *,
                 project_id: str,
                 role: str):
        """
        :param str project_id: The ID of the project that the user should be granted access to.
        :param str role: The role that the user should have in the project.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project that the user should be granted access to.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role that the user should have in the project.
        """
        return pulumi.get(self, "role")


