# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MicrofrontendGroupMembershipArgs', 'MicrofrontendGroupMembership']

@pulumi.input_type
class MicrofrontendGroupMembershipArgs:
    def __init__(__self__, *,
                 microfrontend_group_id: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 default_route: Optional[pulumi.Input[str]] = None,
                 route_observability_to_this_project: Optional[pulumi.Input[bool]] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MicrofrontendGroupMembership resource.
        :param pulumi.Input[str] microfrontend_group_id: The ID of the microfrontend group.
        :param pulumi.Input[str] project_id: The ID of the project.
        :param pulumi.Input[str] default_route: The default route for the project. Used for the screenshot of deployments.
        :param pulumi.Input[bool] route_observability_to_this_project: Whether the project is route observability for this project. If dalse, the project will be route observability for all projects to the default project.
        :param pulumi.Input[str] team_id: The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        pulumi.set(__self__, "microfrontend_group_id", microfrontend_group_id)
        pulumi.set(__self__, "project_id", project_id)
        if default_route is not None:
            pulumi.set(__self__, "default_route", default_route)
        if route_observability_to_this_project is not None:
            pulumi.set(__self__, "route_observability_to_this_project", route_observability_to_this_project)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="microfrontendGroupId")
    def microfrontend_group_id(self) -> pulumi.Input[str]:
        """
        The ID of the microfrontend group.
        """
        return pulumi.get(self, "microfrontend_group_id")

    @microfrontend_group_id.setter
    def microfrontend_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "microfrontend_group_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="defaultRoute")
    def default_route(self) -> Optional[pulumi.Input[str]]:
        """
        The default route for the project. Used for the screenshot of deployments.
        """
        return pulumi.get(self, "default_route")

    @default_route.setter
    def default_route(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_route", value)

    @property
    @pulumi.getter(name="routeObservabilityToThisProject")
    def route_observability_to_this_project(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the project is route observability for this project. If dalse, the project will be route observability for all projects to the default project.
        """
        return pulumi.get(self, "route_observability_to_this_project")

    @route_observability_to_this_project.setter
    def route_observability_to_this_project(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "route_observability_to_this_project", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


@pulumi.input_type
class _MicrofrontendGroupMembershipState:
    def __init__(__self__, *,
                 default_route: Optional[pulumi.Input[str]] = None,
                 microfrontend_group_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 route_observability_to_this_project: Optional[pulumi.Input[bool]] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MicrofrontendGroupMembership resources.
        :param pulumi.Input[str] default_route: The default route for the project. Used for the screenshot of deployments.
        :param pulumi.Input[str] microfrontend_group_id: The ID of the microfrontend group.
        :param pulumi.Input[str] project_id: The ID of the project.
        :param pulumi.Input[bool] route_observability_to_this_project: Whether the project is route observability for this project. If dalse, the project will be route observability for all projects to the default project.
        :param pulumi.Input[str] team_id: The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        if default_route is not None:
            pulumi.set(__self__, "default_route", default_route)
        if microfrontend_group_id is not None:
            pulumi.set(__self__, "microfrontend_group_id", microfrontend_group_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if route_observability_to_this_project is not None:
            pulumi.set(__self__, "route_observability_to_this_project", route_observability_to_this_project)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="defaultRoute")
    def default_route(self) -> Optional[pulumi.Input[str]]:
        """
        The default route for the project. Used for the screenshot of deployments.
        """
        return pulumi.get(self, "default_route")

    @default_route.setter
    def default_route(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_route", value)

    @property
    @pulumi.getter(name="microfrontendGroupId")
    def microfrontend_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the microfrontend group.
        """
        return pulumi.get(self, "microfrontend_group_id")

    @microfrontend_group_id.setter
    def microfrontend_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "microfrontend_group_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="routeObservabilityToThisProject")
    def route_observability_to_this_project(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the project is route observability for this project. If dalse, the project will be route observability for all projects to the default project.
        """
        return pulumi.get(self, "route_observability_to_this_project")

    @route_observability_to_this_project.setter
    def route_observability_to_this_project(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "route_observability_to_this_project", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


class MicrofrontendGroupMembership(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_route: Optional[pulumi.Input[str]] = None,
                 microfrontend_group_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 route_observability_to_this_project: Optional[pulumi.Input[bool]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Microfrontend Group Membership resource.

        A Microfrontend Group Membership is a definition of a Vercel Project being a part of a Microfrontend Group.

        ## Import

        If importing into a personal account, or with a team configured on the provider, simply use the record id.

        - the microfrontend ID can be taken from the microfrontend settings page

        - the project ID can be taken from the project settings page

        ```sh
        $ pulumi import vercel:index/microfrontendGroupMembership:MicrofrontendGroupMembership example mfe_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/pid_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        Alternatively, you can import via the team_id and microfrontend_id.

        - team_id can be found in the team `settings` tab in the Vercel UI.

        - the microfrontend ID can be taken from the microfrontend settings page

        - the project ID can be taken from the project settings page

        ```sh
        $ pulumi import vercel:index/microfrontendGroupMembership:MicrofrontendGroupMembership example team_xxxxxxxxxxxxxxxxxxxxxxxx/mfe_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/pid_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_route: The default route for the project. Used for the screenshot of deployments.
        :param pulumi.Input[str] microfrontend_group_id: The ID of the microfrontend group.
        :param pulumi.Input[str] project_id: The ID of the project.
        :param pulumi.Input[bool] route_observability_to_this_project: Whether the project is route observability for this project. If dalse, the project will be route observability for all projects to the default project.
        :param pulumi.Input[str] team_id: The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MicrofrontendGroupMembershipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Microfrontend Group Membership resource.

        A Microfrontend Group Membership is a definition of a Vercel Project being a part of a Microfrontend Group.

        ## Import

        If importing into a personal account, or with a team configured on the provider, simply use the record id.

        - the microfrontend ID can be taken from the microfrontend settings page

        - the project ID can be taken from the project settings page

        ```sh
        $ pulumi import vercel:index/microfrontendGroupMembership:MicrofrontendGroupMembership example mfe_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/pid_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        Alternatively, you can import via the team_id and microfrontend_id.

        - team_id can be found in the team `settings` tab in the Vercel UI.

        - the microfrontend ID can be taken from the microfrontend settings page

        - the project ID can be taken from the project settings page

        ```sh
        $ pulumi import vercel:index/microfrontendGroupMembership:MicrofrontendGroupMembership example team_xxxxxxxxxxxxxxxxxxxxxxxx/mfe_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/pid_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param MicrofrontendGroupMembershipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MicrofrontendGroupMembershipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_route: Optional[pulumi.Input[str]] = None,
                 microfrontend_group_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 route_observability_to_this_project: Optional[pulumi.Input[bool]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MicrofrontendGroupMembershipArgs.__new__(MicrofrontendGroupMembershipArgs)

            __props__.__dict__["default_route"] = default_route
            if microfrontend_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'microfrontend_group_id'")
            __props__.__dict__["microfrontend_group_id"] = microfrontend_group_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["route_observability_to_this_project"] = route_observability_to_this_project
            __props__.__dict__["team_id"] = team_id
        super(MicrofrontendGroupMembership, __self__).__init__(
            'vercel:index/microfrontendGroupMembership:MicrofrontendGroupMembership',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_route: Optional[pulumi.Input[str]] = None,
            microfrontend_group_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            route_observability_to_this_project: Optional[pulumi.Input[bool]] = None,
            team_id: Optional[pulumi.Input[str]] = None) -> 'MicrofrontendGroupMembership':
        """
        Get an existing MicrofrontendGroupMembership resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_route: The default route for the project. Used for the screenshot of deployments.
        :param pulumi.Input[str] microfrontend_group_id: The ID of the microfrontend group.
        :param pulumi.Input[str] project_id: The ID of the project.
        :param pulumi.Input[bool] route_observability_to_this_project: Whether the project is route observability for this project. If dalse, the project will be route observability for all projects to the default project.
        :param pulumi.Input[str] team_id: The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MicrofrontendGroupMembershipState.__new__(_MicrofrontendGroupMembershipState)

        __props__.__dict__["default_route"] = default_route
        __props__.__dict__["microfrontend_group_id"] = microfrontend_group_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["route_observability_to_this_project"] = route_observability_to_this_project
        __props__.__dict__["team_id"] = team_id
        return MicrofrontendGroupMembership(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultRoute")
    def default_route(self) -> pulumi.Output[str]:
        """
        The default route for the project. Used for the screenshot of deployments.
        """
        return pulumi.get(self, "default_route")

    @property
    @pulumi.getter(name="microfrontendGroupId")
    def microfrontend_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the microfrontend group.
        """
        return pulumi.get(self, "microfrontend_group_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="routeObservabilityToThisProject")
    def route_observability_to_this_project(self) -> pulumi.Output[bool]:
        """
        Whether the project is route observability for this project. If dalse, the project will be route observability for all projects to the default project.
        """
        return pulumi.get(self, "route_observability_to_this_project")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

