# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MicrofrontendGroupArgs', 'MicrofrontendGroup']

@pulumi.input_type
class MicrofrontendGroupArgs:
    def __init__(__self__, *,
                 default_app: pulumi.Input['MicrofrontendGroupDefaultAppArgs'],
                 name: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MicrofrontendGroup resource.
        :param pulumi.Input['MicrofrontendGroupDefaultAppArgs'] default_app: The default app for the project. Used as the entry point for the microfrontend.
        :param pulumi.Input[str] name: A human readable name for the microfrontends group.
        :param pulumi.Input[str] team_id: The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        pulumi.set(__self__, "default_app", default_app)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="defaultApp")
    def default_app(self) -> pulumi.Input['MicrofrontendGroupDefaultAppArgs']:
        """
        The default app for the project. Used as the entry point for the microfrontend.
        """
        return pulumi.get(self, "default_app")

    @default_app.setter
    def default_app(self, value: pulumi.Input['MicrofrontendGroupDefaultAppArgs']):
        pulumi.set(self, "default_app", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A human readable name for the microfrontends group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


@pulumi.input_type
class _MicrofrontendGroupState:
    def __init__(__self__, *,
                 default_app: Optional[pulumi.Input['MicrofrontendGroupDefaultAppArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 slug: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MicrofrontendGroup resources.
        :param pulumi.Input['MicrofrontendGroupDefaultAppArgs'] default_app: The default app for the project. Used as the entry point for the microfrontend.
        :param pulumi.Input[str] name: A human readable name for the microfrontends group.
        :param pulumi.Input[str] slug: A slugified version of the name.
        :param pulumi.Input[str] team_id: The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        if default_app is not None:
            pulumi.set(__self__, "default_app", default_app)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if slug is not None:
            pulumi.set(__self__, "slug", slug)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="defaultApp")
    def default_app(self) -> Optional[pulumi.Input['MicrofrontendGroupDefaultAppArgs']]:
        """
        The default app for the project. Used as the entry point for the microfrontend.
        """
        return pulumi.get(self, "default_app")

    @default_app.setter
    def default_app(self, value: Optional[pulumi.Input['MicrofrontendGroupDefaultAppArgs']]):
        pulumi.set(self, "default_app", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A human readable name for the microfrontends group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def slug(self) -> Optional[pulumi.Input[str]]:
        """
        A slugified version of the name.
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slug", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


class MicrofrontendGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_app: Optional[pulumi.Input[Union['MicrofrontendGroupDefaultAppArgs', 'MicrofrontendGroupDefaultAppArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Microfrontend Group resource.

        A Microfrontend Group is a definition of a microfrontend belonging to a Vercel Team.

        ## Import

        If importing into a personal account, or with a team configured on the provider, simply use the record id.

        - the microfrontend ID can be taken from the microfrontend settings page

        ```sh
        $ pulumi import vercel:index/microfrontendGroup:MicrofrontendGroup example mfe_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        Alternatively, you can import via the team_id and microfrontend_id.

        - team_id can be found in the team `settings` tab in the Vercel UI.

        - the microfrontend ID can be taken from the microfrontend settings page

        ```sh
        $ pulumi import vercel:index/microfrontendGroup:MicrofrontendGroup example team_xxxxxxxxxxxxxxxxxxxxxxxx/mfe_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MicrofrontendGroupDefaultAppArgs', 'MicrofrontendGroupDefaultAppArgsDict']] default_app: The default app for the project. Used as the entry point for the microfrontend.
        :param pulumi.Input[str] name: A human readable name for the microfrontends group.
        :param pulumi.Input[str] team_id: The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MicrofrontendGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Microfrontend Group resource.

        A Microfrontend Group is a definition of a microfrontend belonging to a Vercel Team.

        ## Import

        If importing into a personal account, or with a team configured on the provider, simply use the record id.

        - the microfrontend ID can be taken from the microfrontend settings page

        ```sh
        $ pulumi import vercel:index/microfrontendGroup:MicrofrontendGroup example mfe_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        Alternatively, you can import via the team_id and microfrontend_id.

        - team_id can be found in the team `settings` tab in the Vercel UI.

        - the microfrontend ID can be taken from the microfrontend settings page

        ```sh
        $ pulumi import vercel:index/microfrontendGroup:MicrofrontendGroup example team_xxxxxxxxxxxxxxxxxxxxxxxx/mfe_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param MicrofrontendGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MicrofrontendGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_app: Optional[pulumi.Input[Union['MicrofrontendGroupDefaultAppArgs', 'MicrofrontendGroupDefaultAppArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MicrofrontendGroupArgs.__new__(MicrofrontendGroupArgs)

            if default_app is None and not opts.urn:
                raise TypeError("Missing required property 'default_app'")
            __props__.__dict__["default_app"] = default_app
            __props__.__dict__["name"] = name
            __props__.__dict__["team_id"] = team_id
            __props__.__dict__["slug"] = None
        super(MicrofrontendGroup, __self__).__init__(
            'vercel:index/microfrontendGroup:MicrofrontendGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_app: Optional[pulumi.Input[Union['MicrofrontendGroupDefaultAppArgs', 'MicrofrontendGroupDefaultAppArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            slug: Optional[pulumi.Input[str]] = None,
            team_id: Optional[pulumi.Input[str]] = None) -> 'MicrofrontendGroup':
        """
        Get an existing MicrofrontendGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MicrofrontendGroupDefaultAppArgs', 'MicrofrontendGroupDefaultAppArgsDict']] default_app: The default app for the project. Used as the entry point for the microfrontend.
        :param pulumi.Input[str] name: A human readable name for the microfrontends group.
        :param pulumi.Input[str] slug: A slugified version of the name.
        :param pulumi.Input[str] team_id: The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MicrofrontendGroupState.__new__(_MicrofrontendGroupState)

        __props__.__dict__["default_app"] = default_app
        __props__.__dict__["name"] = name
        __props__.__dict__["slug"] = slug
        __props__.__dict__["team_id"] = team_id
        return MicrofrontendGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultApp")
    def default_app(self) -> pulumi.Output['outputs.MicrofrontendGroupDefaultApp']:
        """
        The default app for the project. Used as the entry point for the microfrontend.
        """
        return pulumi.get(self, "default_app")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A human readable name for the microfrontends group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def slug(self) -> pulumi.Output[str]:
        """
        A slugified version of the name.
        """
        return pulumi.get(self, "slug")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

