# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetTeamMemberResult',
    'AwaitableGetTeamMemberResult',
    'get_team_member',
    'get_team_member_output',
]

@pulumi.output_type
class GetTeamMemberResult:
    """
    A collection of values returned by getTeamMember.
    """
    def __init__(__self__, access_groups=None, email=None, id=None, projects=None, role=None, team_id=None, user_id=None):
        if access_groups and not isinstance(access_groups, list):
            raise TypeError("Expected argument 'access_groups' to be a list")
        pulumi.set(__self__, "access_groups", access_groups)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if projects and not isinstance(projects, list):
            raise TypeError("Expected argument 'projects' to be a list")
        pulumi.set(__self__, "projects", projects)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessGroups")
    def access_groups(self) -> Sequence[str]:
        """
        If access groups are enabled on the team, and the user is a CONTRIBUTOR, `projects`, `access_groups` or both must be specified. A set of access groups IDs that the user should be granted access to.
        """
        return pulumi.get(self, "access_groups")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email address of the existing Vercel Team Member.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def projects(self) -> Sequence['outputs.GetTeamMemberProjectResult']:
        """
        If access groups are enabled on the team, and the user is a CONTRIBUTOR, `projects`, `access_groups` or both must be specified. A set of projects that the user should be granted access to, along with their role in each project.
        """
        return pulumi.get(self, "projects")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role that the user should have in the project. One of 'MEMBER', 'OWNER', 'VIEWER', 'DEVELOPER', 'BILLING' or 'CONTRIBUTOR'. Depending on your Team's plan, some of these roles may be unavailable.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        The ID of the existing Vercel Team.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The ID of the existing Vercel Team Member.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetTeamMemberResult(GetTeamMemberResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTeamMemberResult(
            access_groups=self.access_groups,
            email=self.email,
            id=self.id,
            projects=self.projects,
            role=self.role,
            team_id=self.team_id,
            user_id=self.user_id)


def get_team_member(team_id: Optional[str] = None,
                    user_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTeamMemberResult:
    """
    Provider a datasource for managing a team member.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_team_member(user_id="uuuuuuuuuuuuuuuuuuuuuuuuuu",
        team_id="team_xxxxxxxxxxxxxxxxxxxxxxxx")
    ```


    :param str team_id: The ID of the existing Vercel Team.
    :param str user_id: The ID of the existing Vercel Team Member.
    """
    __args__ = dict()
    __args__['teamId'] = team_id
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vercel:index/getTeamMember:getTeamMember', __args__, opts=opts, typ=GetTeamMemberResult).value

    return AwaitableGetTeamMemberResult(
        access_groups=pulumi.get(__ret__, 'access_groups'),
        email=pulumi.get(__ret__, 'email'),
        id=pulumi.get(__ret__, 'id'),
        projects=pulumi.get(__ret__, 'projects'),
        role=pulumi.get(__ret__, 'role'),
        team_id=pulumi.get(__ret__, 'team_id'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_team_member_output(team_id: Optional[pulumi.Input[str]] = None,
                           user_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTeamMemberResult]:
    """
    Provider a datasource for managing a team member.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_team_member(user_id="uuuuuuuuuuuuuuuuuuuuuuuuuu",
        team_id="team_xxxxxxxxxxxxxxxxxxxxxxxx")
    ```


    :param str team_id: The ID of the existing Vercel Team.
    :param str user_id: The ID of the existing Vercel Team Member.
    """
    __args__ = dict()
    __args__['teamId'] = team_id
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vercel:index/getTeamMember:getTeamMember', __args__, opts=opts, typ=GetTeamMemberResult)
    return __ret__.apply(lambda __response__: GetTeamMemberResult(
        access_groups=pulumi.get(__response__, 'access_groups'),
        email=pulumi.get(__response__, 'email'),
        id=pulumi.get(__response__, 'id'),
        projects=pulumi.get(__response__, 'projects'),
        role=pulumi.get(__response__, 'role'),
        team_id=pulumi.get(__response__, 'team_id'),
        user_id=pulumi.get(__response__, 'user_id')))
