# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetProjectMembersResult',
    'AwaitableGetProjectMembersResult',
    'get_project_members',
    'get_project_members_output',
]

@pulumi.output_type
class GetProjectMembersResult:
    """
    A collection of values returned by getProjectMembers.
    """
    def __init__(__self__, id=None, members=None, project_id=None, team_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetProjectMembersMemberResult']:
        """
        The set of members in this project.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the Vercel Project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[str]:
        """
        The team ID to which the project belongs. Required when accessing a team project if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")


class AwaitableGetProjectMembersResult(GetProjectMembersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectMembersResult(
            id=self.id,
            members=self.members,
            project_id=self.project_id,
            team_id=self.team_id)


def get_project_members(project_id: Optional[str] = None,
                        team_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectMembersResult:
    """
    Retrieves members and their roles for a Vercel Project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_project(name="example-with-members")
    example_get_project_members = vercel.get_project_members(project_id=example.id)
    ```


    :param str project_id: The ID of the Vercel Project.
    :param str team_id: The team ID to which the project belongs. Required when accessing a team project if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vercel:index/getProjectMembers:getProjectMembers', __args__, opts=opts, typ=GetProjectMembersResult).value

    return AwaitableGetProjectMembersResult(
        id=pulumi.get(__ret__, 'id'),
        members=pulumi.get(__ret__, 'members'),
        project_id=pulumi.get(__ret__, 'project_id'),
        team_id=pulumi.get(__ret__, 'team_id'))
def get_project_members_output(project_id: Optional[pulumi.Input[str]] = None,
                               team_id: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectMembersResult]:
    """
    Retrieves members and their roles for a Vercel Project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_project(name="example-with-members")
    example_get_project_members = vercel.get_project_members(project_id=example.id)
    ```


    :param str project_id: The ID of the Vercel Project.
    :param str team_id: The team ID to which the project belongs. Required when accessing a team project if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vercel:index/getProjectMembers:getProjectMembers', __args__, opts=opts, typ=GetProjectMembersResult)
    return __ret__.apply(lambda __response__: GetProjectMembersResult(
        id=pulumi.get(__response__, 'id'),
        members=pulumi.get(__response__, 'members'),
        project_id=pulumi.get(__response__, 'project_id'),
        team_id=pulumi.get(__response__, 'team_id')))
