# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetProjectDeploymentRetentionResult',
    'AwaitableGetProjectDeploymentRetentionResult',
    'get_project_deployment_retention',
    'get_project_deployment_retention_output',
]

@pulumi.output_type
class GetProjectDeploymentRetentionResult:
    """
    A collection of values returned by getProjectDeploymentRetention.
    """
    def __init__(__self__, expiration_canceled=None, expiration_errored=None, expiration_preview=None, expiration_production=None, id=None, project_id=None, team_id=None):
        if expiration_canceled and not isinstance(expiration_canceled, str):
            raise TypeError("Expected argument 'expiration_canceled' to be a str")
        pulumi.set(__self__, "expiration_canceled", expiration_canceled)
        if expiration_errored and not isinstance(expiration_errored, str):
            raise TypeError("Expected argument 'expiration_errored' to be a str")
        pulumi.set(__self__, "expiration_errored", expiration_errored)
        if expiration_preview and not isinstance(expiration_preview, str):
            raise TypeError("Expected argument 'expiration_preview' to be a str")
        pulumi.set(__self__, "expiration_preview", expiration_preview)
        if expiration_production and not isinstance(expiration_production, str):
            raise TypeError("Expected argument 'expiration_production' to be a str")
        pulumi.set(__self__, "expiration_production", expiration_production)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="expirationCanceled")
    def expiration_canceled(self) -> str:
        """
        The retention period for canceled deployments.
        """
        return pulumi.get(self, "expiration_canceled")

    @property
    @pulumi.getter(name="expirationErrored")
    def expiration_errored(self) -> str:
        """
        The retention period for errored deployments.
        """
        return pulumi.get(self, "expiration_errored")

    @property
    @pulumi.getter(name="expirationPreview")
    def expiration_preview(self) -> str:
        """
        The retention period for preview deployments.
        """
        return pulumi.get(self, "expiration_preview")

    @property
    @pulumi.getter(name="expirationProduction")
    def expiration_production(self) -> str:
        """
        The retention period for production deployments.
        """
        return pulumi.get(self, "expiration_production")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the Project for the retention policy
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        The ID of the Vercel team.
        """
        return pulumi.get(self, "team_id")


class AwaitableGetProjectDeploymentRetentionResult(GetProjectDeploymentRetentionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectDeploymentRetentionResult(
            expiration_canceled=self.expiration_canceled,
            expiration_errored=self.expiration_errored,
            expiration_preview=self.expiration_preview,
            expiration_production=self.expiration_production,
            id=self.id,
            project_id=self.project_id,
            team_id=self.team_id)


def get_project_deployment_retention(project_id: Optional[str] = None,
                                     team_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectDeploymentRetentionResult:
    """
    Provides a Project Deployment Retention datasource.

    A Project Deployment Retention datasource details information about Deployment Retention on a Vercel Project.

    For more detailed information, please see the [Vercel documentation](https://vercel.com/docs/security/deployment-retention).


    :param str project_id: The ID of the Project for the retention policy
    :param str team_id: The ID of the Vercel team.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vercel:index/getProjectDeploymentRetention:getProjectDeploymentRetention', __args__, opts=opts, typ=GetProjectDeploymentRetentionResult).value

    return AwaitableGetProjectDeploymentRetentionResult(
        expiration_canceled=pulumi.get(__ret__, 'expiration_canceled'),
        expiration_errored=pulumi.get(__ret__, 'expiration_errored'),
        expiration_preview=pulumi.get(__ret__, 'expiration_preview'),
        expiration_production=pulumi.get(__ret__, 'expiration_production'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        team_id=pulumi.get(__ret__, 'team_id'))
def get_project_deployment_retention_output(project_id: Optional[pulumi.Input[str]] = None,
                                            team_id: Optional[pulumi.Input[Optional[str]]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectDeploymentRetentionResult]:
    """
    Provides a Project Deployment Retention datasource.

    A Project Deployment Retention datasource details information about Deployment Retention on a Vercel Project.

    For more detailed information, please see the [Vercel documentation](https://vercel.com/docs/security/deployment-retention).


    :param str project_id: The ID of the Project for the retention policy
    :param str team_id: The ID of the Vercel team.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vercel:index/getProjectDeploymentRetention:getProjectDeploymentRetention', __args__, opts=opts, typ=GetProjectDeploymentRetentionResult)
    return __ret__.apply(lambda __response__: GetProjectDeploymentRetentionResult(
        expiration_canceled=pulumi.get(__response__, 'expiration_canceled'),
        expiration_errored=pulumi.get(__response__, 'expiration_errored'),
        expiration_preview=pulumi.get(__response__, 'expiration_preview'),
        expiration_production=pulumi.get(__response__, 'expiration_production'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        team_id=pulumi.get(__response__, 'team_id')))
