# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, auto_assign_custom_domains=None, automatically_expose_system_environment_variables=None, build_command=None, customer_success_code_visibility=None, dev_command=None, directory_listing=None, enable_affected_projects_deployments=None, enable_preview_feedback=None, enable_production_feedback=None, environments=None, framework=None, function_failover=None, git_comments=None, git_fork_protection=None, git_lfs=None, git_repository=None, id=None, ignore_command=None, install_command=None, name=None, node_version=None, oidc_token_config=None, on_demand_concurrent_builds=None, options_allowlist=None, output_directory=None, password_protection=None, preview_comments=None, prioritise_production_builds=None, protection_bypass_for_automation=None, protection_bypass_for_automation_secret=None, public_source=None, resource_config=None, root_directory=None, serverless_function_region=None, skew_protection=None, team_id=None, trusted_ips=None, vercel_authentication=None):
        if auto_assign_custom_domains and not isinstance(auto_assign_custom_domains, bool):
            raise TypeError("Expected argument 'auto_assign_custom_domains' to be a bool")
        pulumi.set(__self__, "auto_assign_custom_domains", auto_assign_custom_domains)
        if automatically_expose_system_environment_variables and not isinstance(automatically_expose_system_environment_variables, bool):
            raise TypeError("Expected argument 'automatically_expose_system_environment_variables' to be a bool")
        pulumi.set(__self__, "automatically_expose_system_environment_variables", automatically_expose_system_environment_variables)
        if build_command and not isinstance(build_command, str):
            raise TypeError("Expected argument 'build_command' to be a str")
        pulumi.set(__self__, "build_command", build_command)
        if customer_success_code_visibility and not isinstance(customer_success_code_visibility, bool):
            raise TypeError("Expected argument 'customer_success_code_visibility' to be a bool")
        pulumi.set(__self__, "customer_success_code_visibility", customer_success_code_visibility)
        if dev_command and not isinstance(dev_command, str):
            raise TypeError("Expected argument 'dev_command' to be a str")
        pulumi.set(__self__, "dev_command", dev_command)
        if directory_listing and not isinstance(directory_listing, bool):
            raise TypeError("Expected argument 'directory_listing' to be a bool")
        pulumi.set(__self__, "directory_listing", directory_listing)
        if enable_affected_projects_deployments and not isinstance(enable_affected_projects_deployments, bool):
            raise TypeError("Expected argument 'enable_affected_projects_deployments' to be a bool")
        pulumi.set(__self__, "enable_affected_projects_deployments", enable_affected_projects_deployments)
        if enable_preview_feedback and not isinstance(enable_preview_feedback, bool):
            raise TypeError("Expected argument 'enable_preview_feedback' to be a bool")
        pulumi.set(__self__, "enable_preview_feedback", enable_preview_feedback)
        if enable_production_feedback and not isinstance(enable_production_feedback, bool):
            raise TypeError("Expected argument 'enable_production_feedback' to be a bool")
        pulumi.set(__self__, "enable_production_feedback", enable_production_feedback)
        if environments and not isinstance(environments, list):
            raise TypeError("Expected argument 'environments' to be a list")
        pulumi.set(__self__, "environments", environments)
        if framework and not isinstance(framework, str):
            raise TypeError("Expected argument 'framework' to be a str")
        pulumi.set(__self__, "framework", framework)
        if function_failover and not isinstance(function_failover, bool):
            raise TypeError("Expected argument 'function_failover' to be a bool")
        pulumi.set(__self__, "function_failover", function_failover)
        if git_comments and not isinstance(git_comments, dict):
            raise TypeError("Expected argument 'git_comments' to be a dict")
        pulumi.set(__self__, "git_comments", git_comments)
        if git_fork_protection and not isinstance(git_fork_protection, bool):
            raise TypeError("Expected argument 'git_fork_protection' to be a bool")
        pulumi.set(__self__, "git_fork_protection", git_fork_protection)
        if git_lfs and not isinstance(git_lfs, bool):
            raise TypeError("Expected argument 'git_lfs' to be a bool")
        pulumi.set(__self__, "git_lfs", git_lfs)
        if git_repository and not isinstance(git_repository, dict):
            raise TypeError("Expected argument 'git_repository' to be a dict")
        pulumi.set(__self__, "git_repository", git_repository)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ignore_command and not isinstance(ignore_command, str):
            raise TypeError("Expected argument 'ignore_command' to be a str")
        pulumi.set(__self__, "ignore_command", ignore_command)
        if install_command and not isinstance(install_command, str):
            raise TypeError("Expected argument 'install_command' to be a str")
        pulumi.set(__self__, "install_command", install_command)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_version and not isinstance(node_version, str):
            raise TypeError("Expected argument 'node_version' to be a str")
        pulumi.set(__self__, "node_version", node_version)
        if oidc_token_config and not isinstance(oidc_token_config, dict):
            raise TypeError("Expected argument 'oidc_token_config' to be a dict")
        pulumi.set(__self__, "oidc_token_config", oidc_token_config)
        if on_demand_concurrent_builds and not isinstance(on_demand_concurrent_builds, bool):
            raise TypeError("Expected argument 'on_demand_concurrent_builds' to be a bool")
        pulumi.set(__self__, "on_demand_concurrent_builds", on_demand_concurrent_builds)
        if options_allowlist and not isinstance(options_allowlist, dict):
            raise TypeError("Expected argument 'options_allowlist' to be a dict")
        pulumi.set(__self__, "options_allowlist", options_allowlist)
        if output_directory and not isinstance(output_directory, str):
            raise TypeError("Expected argument 'output_directory' to be a str")
        pulumi.set(__self__, "output_directory", output_directory)
        if password_protection and not isinstance(password_protection, dict):
            raise TypeError("Expected argument 'password_protection' to be a dict")
        pulumi.set(__self__, "password_protection", password_protection)
        if preview_comments and not isinstance(preview_comments, bool):
            raise TypeError("Expected argument 'preview_comments' to be a bool")
        pulumi.set(__self__, "preview_comments", preview_comments)
        if prioritise_production_builds and not isinstance(prioritise_production_builds, bool):
            raise TypeError("Expected argument 'prioritise_production_builds' to be a bool")
        pulumi.set(__self__, "prioritise_production_builds", prioritise_production_builds)
        if protection_bypass_for_automation and not isinstance(protection_bypass_for_automation, bool):
            raise TypeError("Expected argument 'protection_bypass_for_automation' to be a bool")
        pulumi.set(__self__, "protection_bypass_for_automation", protection_bypass_for_automation)
        if protection_bypass_for_automation_secret and not isinstance(protection_bypass_for_automation_secret, str):
            raise TypeError("Expected argument 'protection_bypass_for_automation_secret' to be a str")
        pulumi.set(__self__, "protection_bypass_for_automation_secret", protection_bypass_for_automation_secret)
        if public_source and not isinstance(public_source, bool):
            raise TypeError("Expected argument 'public_source' to be a bool")
        pulumi.set(__self__, "public_source", public_source)
        if resource_config and not isinstance(resource_config, dict):
            raise TypeError("Expected argument 'resource_config' to be a dict")
        pulumi.set(__self__, "resource_config", resource_config)
        if root_directory and not isinstance(root_directory, str):
            raise TypeError("Expected argument 'root_directory' to be a str")
        pulumi.set(__self__, "root_directory", root_directory)
        if serverless_function_region and not isinstance(serverless_function_region, str):
            raise TypeError("Expected argument 'serverless_function_region' to be a str")
        pulumi.set(__self__, "serverless_function_region", serverless_function_region)
        if skew_protection and not isinstance(skew_protection, str):
            raise TypeError("Expected argument 'skew_protection' to be a str")
        pulumi.set(__self__, "skew_protection", skew_protection)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)
        if trusted_ips and not isinstance(trusted_ips, dict):
            raise TypeError("Expected argument 'trusted_ips' to be a dict")
        pulumi.set(__self__, "trusted_ips", trusted_ips)
        if vercel_authentication and not isinstance(vercel_authentication, dict):
            raise TypeError("Expected argument 'vercel_authentication' to be a dict")
        pulumi.set(__self__, "vercel_authentication", vercel_authentication)

    @property
    @pulumi.getter(name="autoAssignCustomDomains")
    def auto_assign_custom_domains(self) -> bool:
        """
        Automatically assign custom production domains after each Production deployment via merge to the production branch or Vercel CLI deploy with --prod. Defaults to `true`
        """
        return pulumi.get(self, "auto_assign_custom_domains")

    @property
    @pulumi.getter(name="automaticallyExposeSystemEnvironmentVariables")
    def automatically_expose_system_environment_variables(self) -> bool:
        """
        Vercel provides a set of Environment Variables that are automatically populated by the System, such as the URL of the Deployment or the name of the Git branch deployed. To expose them to your Deployments, enable this field
        """
        return pulumi.get(self, "automatically_expose_system_environment_variables")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> str:
        """
        The build command for this project. If omitted, this value will be automatically detected.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter(name="customerSuccessCodeVisibility")
    def customer_success_code_visibility(self) -> bool:
        """
        Allows Vercel Customer Support to inspect all Deployments' source code in this project to assist with debugging.
        """
        return pulumi.get(self, "customer_success_code_visibility")

    @property
    @pulumi.getter(name="devCommand")
    def dev_command(self) -> str:
        """
        The dev command for this project. If omitted, this value will be automatically detected.
        """
        return pulumi.get(self, "dev_command")

    @property
    @pulumi.getter(name="directoryListing")
    def directory_listing(self) -> bool:
        """
        If no index file is present within a directory, the directory contents will be displayed.
        """
        return pulumi.get(self, "directory_listing")

    @property
    @pulumi.getter(name="enableAffectedProjectsDeployments")
    def enable_affected_projects_deployments(self) -> bool:
        """
        When enabled, Vercel will automatically deploy all projects that are affected by a change to this project.
        """
        return pulumi.get(self, "enable_affected_projects_deployments")

    @property
    @pulumi.getter(name="enablePreviewFeedback")
    def enable_preview_feedback(self) -> bool:
        """
        Whether the Vercel Toolbar is enabled on your preview deployments. If unspecified, defaults to team setting.
        """
        return pulumi.get(self, "enable_preview_feedback")

    @property
    @pulumi.getter(name="enableProductionFeedback")
    def enable_production_feedback(self) -> bool:
        """
        Whether the Vercel Toolbar is enabled on your production deployments. If unspecified, defaults to team setting.
        """
        return pulumi.get(self, "enable_production_feedback")

    @property
    @pulumi.getter
    def environments(self) -> Sequence['outputs.GetProjectEnvironmentResult']:
        """
        A list of environment variables that should be configured for the project.
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter
    def framework(self) -> str:
        """
        The framework that is being used for this project. If omitted, no framework is selected.
        """
        return pulumi.get(self, "framework")

    @property
    @pulumi.getter(name="functionFailover")
    def function_failover(self) -> bool:
        """
        Automatically failover Serverless Functions to the nearest region. You can customize regions through vercel.json. A new Deployment is required for your changes to take effect.
        """
        return pulumi.get(self, "function_failover")

    @property
    @pulumi.getter(name="gitComments")
    def git_comments(self) -> 'outputs.GetProjectGitCommentsResult':
        """
        Configuration for Git Comments.
        """
        return pulumi.get(self, "git_comments")

    @property
    @pulumi.getter(name="gitForkProtection")
    def git_fork_protection(self) -> bool:
        """
        Ensures that pull requests targeting your Git repository must be authorized by a member of your Team before deploying if your Project has Environment Variables or if the pull request includes a change to vercel.json.
        """
        return pulumi.get(self, "git_fork_protection")

    @property
    @pulumi.getter(name="gitLfs")
    def git_lfs(self) -> bool:
        """
        Enables Git LFS support. Git LFS replaces large files such as audio samples, videos, datasets, and graphics with text pointers inside Git, while storing the file contents on a remote server like GitHub.com or GitHub Enterprise.
        """
        return pulumi.get(self, "git_lfs")

    @property
    @pulumi.getter(name="gitRepository")
    def git_repository(self) -> 'outputs.GetProjectGitRepositoryResult':
        """
        The Git Repository that will be connected to the project. When this is defined, any pushes to the specified connected Git Repository will be automatically deployed. This requires the corresponding Vercel for [Github](https://vercel.com/docs/concepts/git/vercel-for-github), [Gitlab](https://vercel.com/docs/concepts/git/vercel-for-gitlab) or [Bitbucket](https://vercel.com/docs/concepts/git/vercel-for-bitbucket) plugins to be installed.
        """
        return pulumi.get(self, "git_repository")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ignoreCommand")
    def ignore_command(self) -> str:
        """
        When a commit is pushed to the Git repository that is connected with your Project, its SHA will determine if a new Build has to be issued. If the SHA was deployed before, no new Build will be issued. You can customize this behavior with a command that exits with code 1 (new Build needed) or code 0.
        """
        return pulumi.get(self, "ignore_command")

    @property
    @pulumi.getter(name="installCommand")
    def install_command(self) -> str:
        """
        The install command for this project. If omitted, this value will be automatically detected.
        """
        return pulumi.get(self, "install_command")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeVersion")
    def node_version(self) -> str:
        """
        The version of Node.js that is used in the Build Step and for Serverless Functions.
        """
        return pulumi.get(self, "node_version")

    @property
    @pulumi.getter(name="oidcTokenConfig")
    def oidc_token_config(self) -> 'outputs.GetProjectOidcTokenConfigResult':
        """
        Configuration for OpenID Connect (OIDC) tokens.
        """
        return pulumi.get(self, "oidc_token_config")

    @property
    @pulumi.getter(name="onDemandConcurrentBuilds")
    def on_demand_concurrent_builds(self) -> bool:
        """
        Instantly scale build capacity to skip the queue, even if all build slots are in use. You can also choose a larger build machine; charges apply per minute if it exceeds your team's default.
        """
        return pulumi.get(self, "on_demand_concurrent_builds")

    @property
    @pulumi.getter(name="optionsAllowlist")
    def options_allowlist(self) -> 'outputs.GetProjectOptionsAllowlistResult':
        """
        Disable Deployment Protection for CORS preflight `OPTIONS` requests for a list of paths.
        """
        return pulumi.get(self, "options_allowlist")

    @property
    @pulumi.getter(name="outputDirectory")
    def output_directory(self) -> str:
        """
        The output directory of the project. When null is used this value will be automatically detected.
        """
        return pulumi.get(self, "output_directory")

    @property
    @pulumi.getter(name="passwordProtection")
    def password_protection(self) -> 'outputs.GetProjectPasswordProtectionResult':
        """
        Ensures visitors of your Preview Deployments must enter a password in order to gain access.
        """
        return pulumi.get(self, "password_protection")

    @property
    @pulumi.getter(name="previewComments")
    @_utilities.deprecated("""Use `enable_preview_feedback` instead. This attribute will be removed in a future version.""")
    def preview_comments(self) -> bool:
        """
        Whether comments are enabled on your Preview Deployments.
        """
        return pulumi.get(self, "preview_comments")

    @property
    @pulumi.getter(name="prioritiseProductionBuilds")
    def prioritise_production_builds(self) -> bool:
        """
        If enabled, builds for the Production environment will be prioritized over Preview environments.
        """
        return pulumi.get(self, "prioritise_production_builds")

    @property
    @pulumi.getter(name="protectionBypassForAutomation")
    def protection_bypass_for_automation(self) -> bool:
        """
        Allows automation services to bypass Deployment Protection on this project when using an HTTP header named `x-vercel-protection-bypass` with the value from `protection_bypass_for_automation_secret`.
        """
        return pulumi.get(self, "protection_bypass_for_automation")

    @property
    @pulumi.getter(name="protectionBypassForAutomationSecret")
    def protection_bypass_for_automation_secret(self) -> str:
        """
        If `protection_bypass_for_automation` is enabled, optionally set this value to specify a 32 character secret, otherwise a secret will be generated.
        """
        return pulumi.get(self, "protection_bypass_for_automation_secret")

    @property
    @pulumi.getter(name="publicSource")
    def public_source(self) -> bool:
        """
        Specifies whether the source code and logs of the deployments for this project should be public or not.
        """
        return pulumi.get(self, "public_source")

    @property
    @pulumi.getter(name="resourceConfig")
    def resource_config(self) -> 'outputs.GetProjectResourceConfigResult':
        """
        Resource Configuration for the project.
        """
        return pulumi.get(self, "resource_config")

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> str:
        """
        The name of a directory or relative path to the source code of your project. When null is used it will default to the project root.
        """
        return pulumi.get(self, "root_directory")

    @property
    @pulumi.getter(name="serverlessFunctionRegion")
    def serverless_function_region(self) -> str:
        """
        The region on Vercel's network to which your Serverless Functions are deployed. It should be close to any data source your Serverless Function might depend on. A new Deployment is required for your changes to take effect. Please see [Vercel's documentation](https://vercel.com/docs/concepts/edge-network/regions) for a full list of regions.
        """
        return pulumi.get(self, "serverless_function_region")

    @property
    @pulumi.getter(name="skewProtection")
    def skew_protection(self) -> str:
        """
        Ensures that outdated clients always fetch the correct version for a given deployment. This value defines how long Vercel keeps Skew Protection active.
        """
        return pulumi.get(self, "skew_protection")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        The team ID the project exists beneath. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter(name="trustedIps")
    def trusted_ips(self) -> 'outputs.GetProjectTrustedIpsResult':
        """
        Ensures only visitors from an allowed IP address can access your deployment.
        """
        return pulumi.get(self, "trusted_ips")

    @property
    @pulumi.getter(name="vercelAuthentication")
    def vercel_authentication(self) -> 'outputs.GetProjectVercelAuthenticationResult':
        """
        Ensures visitors to your Preview Deployments are logged into Vercel and have a minimum of Viewer access on your team.
        """
        return pulumi.get(self, "vercel_authentication")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            auto_assign_custom_domains=self.auto_assign_custom_domains,
            automatically_expose_system_environment_variables=self.automatically_expose_system_environment_variables,
            build_command=self.build_command,
            customer_success_code_visibility=self.customer_success_code_visibility,
            dev_command=self.dev_command,
            directory_listing=self.directory_listing,
            enable_affected_projects_deployments=self.enable_affected_projects_deployments,
            enable_preview_feedback=self.enable_preview_feedback,
            enable_production_feedback=self.enable_production_feedback,
            environments=self.environments,
            framework=self.framework,
            function_failover=self.function_failover,
            git_comments=self.git_comments,
            git_fork_protection=self.git_fork_protection,
            git_lfs=self.git_lfs,
            git_repository=self.git_repository,
            id=self.id,
            ignore_command=self.ignore_command,
            install_command=self.install_command,
            name=self.name,
            node_version=self.node_version,
            oidc_token_config=self.oidc_token_config,
            on_demand_concurrent_builds=self.on_demand_concurrent_builds,
            options_allowlist=self.options_allowlist,
            output_directory=self.output_directory,
            password_protection=self.password_protection,
            preview_comments=self.preview_comments,
            prioritise_production_builds=self.prioritise_production_builds,
            protection_bypass_for_automation=self.protection_bypass_for_automation,
            protection_bypass_for_automation_secret=self.protection_bypass_for_automation_secret,
            public_source=self.public_source,
            resource_config=self.resource_config,
            root_directory=self.root_directory,
            serverless_function_region=self.serverless_function_region,
            skew_protection=self.skew_protection,
            team_id=self.team_id,
            trusted_ips=self.trusted_ips,
            vercel_authentication=self.vercel_authentication)


def get_project(name: Optional[str] = None,
                on_demand_concurrent_builds: Optional[bool] = None,
                team_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    Provides information about an existing project within Vercel.

    A Project groups deployments and custom domains. To deploy on Vercel, you need a Project.

    For more detailed information, please see the [Vercel documentation](https://vercel.com/docs/concepts/projects/overview).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_project(name="my-existing-project")
    ```


    :param str name: The name of the project.
    :param bool on_demand_concurrent_builds: Instantly scale build capacity to skip the queue, even if all build slots are in use. You can also choose a larger build machine; charges apply per minute if it exceeds your team's default.
    :param str team_id: The team ID the project exists beneath. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['onDemandConcurrentBuilds'] = on_demand_concurrent_builds
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vercel:index/getProject:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        auto_assign_custom_domains=pulumi.get(__ret__, 'auto_assign_custom_domains'),
        automatically_expose_system_environment_variables=pulumi.get(__ret__, 'automatically_expose_system_environment_variables'),
        build_command=pulumi.get(__ret__, 'build_command'),
        customer_success_code_visibility=pulumi.get(__ret__, 'customer_success_code_visibility'),
        dev_command=pulumi.get(__ret__, 'dev_command'),
        directory_listing=pulumi.get(__ret__, 'directory_listing'),
        enable_affected_projects_deployments=pulumi.get(__ret__, 'enable_affected_projects_deployments'),
        enable_preview_feedback=pulumi.get(__ret__, 'enable_preview_feedback'),
        enable_production_feedback=pulumi.get(__ret__, 'enable_production_feedback'),
        environments=pulumi.get(__ret__, 'environments'),
        framework=pulumi.get(__ret__, 'framework'),
        function_failover=pulumi.get(__ret__, 'function_failover'),
        git_comments=pulumi.get(__ret__, 'git_comments'),
        git_fork_protection=pulumi.get(__ret__, 'git_fork_protection'),
        git_lfs=pulumi.get(__ret__, 'git_lfs'),
        git_repository=pulumi.get(__ret__, 'git_repository'),
        id=pulumi.get(__ret__, 'id'),
        ignore_command=pulumi.get(__ret__, 'ignore_command'),
        install_command=pulumi.get(__ret__, 'install_command'),
        name=pulumi.get(__ret__, 'name'),
        node_version=pulumi.get(__ret__, 'node_version'),
        oidc_token_config=pulumi.get(__ret__, 'oidc_token_config'),
        on_demand_concurrent_builds=pulumi.get(__ret__, 'on_demand_concurrent_builds'),
        options_allowlist=pulumi.get(__ret__, 'options_allowlist'),
        output_directory=pulumi.get(__ret__, 'output_directory'),
        password_protection=pulumi.get(__ret__, 'password_protection'),
        preview_comments=pulumi.get(__ret__, 'preview_comments'),
        prioritise_production_builds=pulumi.get(__ret__, 'prioritise_production_builds'),
        protection_bypass_for_automation=pulumi.get(__ret__, 'protection_bypass_for_automation'),
        protection_bypass_for_automation_secret=pulumi.get(__ret__, 'protection_bypass_for_automation_secret'),
        public_source=pulumi.get(__ret__, 'public_source'),
        resource_config=pulumi.get(__ret__, 'resource_config'),
        root_directory=pulumi.get(__ret__, 'root_directory'),
        serverless_function_region=pulumi.get(__ret__, 'serverless_function_region'),
        skew_protection=pulumi.get(__ret__, 'skew_protection'),
        team_id=pulumi.get(__ret__, 'team_id'),
        trusted_ips=pulumi.get(__ret__, 'trusted_ips'),
        vercel_authentication=pulumi.get(__ret__, 'vercel_authentication'))
def get_project_output(name: Optional[pulumi.Input[str]] = None,
                       on_demand_concurrent_builds: Optional[pulumi.Input[Optional[bool]]] = None,
                       team_id: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectResult]:
    """
    Provides information about an existing project within Vercel.

    A Project groups deployments and custom domains. To deploy on Vercel, you need a Project.

    For more detailed information, please see the [Vercel documentation](https://vercel.com/docs/concepts/projects/overview).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_project(name="my-existing-project")
    ```


    :param str name: The name of the project.
    :param bool on_demand_concurrent_builds: Instantly scale build capacity to skip the queue, even if all build slots are in use. You can also choose a larger build machine; charges apply per minute if it exceeds your team's default.
    :param str team_id: The team ID the project exists beneath. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['onDemandConcurrentBuilds'] = on_demand_concurrent_builds
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vercel:index/getProject:getProject', __args__, opts=opts, typ=GetProjectResult)
    return __ret__.apply(lambda __response__: GetProjectResult(
        auto_assign_custom_domains=pulumi.get(__response__, 'auto_assign_custom_domains'),
        automatically_expose_system_environment_variables=pulumi.get(__response__, 'automatically_expose_system_environment_variables'),
        build_command=pulumi.get(__response__, 'build_command'),
        customer_success_code_visibility=pulumi.get(__response__, 'customer_success_code_visibility'),
        dev_command=pulumi.get(__response__, 'dev_command'),
        directory_listing=pulumi.get(__response__, 'directory_listing'),
        enable_affected_projects_deployments=pulumi.get(__response__, 'enable_affected_projects_deployments'),
        enable_preview_feedback=pulumi.get(__response__, 'enable_preview_feedback'),
        enable_production_feedback=pulumi.get(__response__, 'enable_production_feedback'),
        environments=pulumi.get(__response__, 'environments'),
        framework=pulumi.get(__response__, 'framework'),
        function_failover=pulumi.get(__response__, 'function_failover'),
        git_comments=pulumi.get(__response__, 'git_comments'),
        git_fork_protection=pulumi.get(__response__, 'git_fork_protection'),
        git_lfs=pulumi.get(__response__, 'git_lfs'),
        git_repository=pulumi.get(__response__, 'git_repository'),
        id=pulumi.get(__response__, 'id'),
        ignore_command=pulumi.get(__response__, 'ignore_command'),
        install_command=pulumi.get(__response__, 'install_command'),
        name=pulumi.get(__response__, 'name'),
        node_version=pulumi.get(__response__, 'node_version'),
        oidc_token_config=pulumi.get(__response__, 'oidc_token_config'),
        on_demand_concurrent_builds=pulumi.get(__response__, 'on_demand_concurrent_builds'),
        options_allowlist=pulumi.get(__response__, 'options_allowlist'),
        output_directory=pulumi.get(__response__, 'output_directory'),
        password_protection=pulumi.get(__response__, 'password_protection'),
        preview_comments=pulumi.get(__response__, 'preview_comments'),
        prioritise_production_builds=pulumi.get(__response__, 'prioritise_production_builds'),
        protection_bypass_for_automation=pulumi.get(__response__, 'protection_bypass_for_automation'),
        protection_bypass_for_automation_secret=pulumi.get(__response__, 'protection_bypass_for_automation_secret'),
        public_source=pulumi.get(__response__, 'public_source'),
        resource_config=pulumi.get(__response__, 'resource_config'),
        root_directory=pulumi.get(__response__, 'root_directory'),
        serverless_function_region=pulumi.get(__response__, 'serverless_function_region'),
        skew_protection=pulumi.get(__response__, 'skew_protection'),
        team_id=pulumi.get(__response__, 'team_id'),
        trusted_ips=pulumi.get(__response__, 'trusted_ips'),
        vercel_authentication=pulumi.get(__response__, 'vercel_authentication')))
