# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetMicrofrontendGroupMembershipResult',
    'AwaitableGetMicrofrontendGroupMembershipResult',
    'get_microfrontend_group_membership',
    'get_microfrontend_group_membership_output',
]

@pulumi.output_type
class GetMicrofrontendGroupMembershipResult:
    """
    A collection of values returned by getMicrofrontendGroupMembership.
    """
    def __init__(__self__, default_route=None, id=None, microfrontend_group_id=None, project_id=None, route_observability_to_this_project=None, team_id=None):
        if default_route and not isinstance(default_route, str):
            raise TypeError("Expected argument 'default_route' to be a str")
        pulumi.set(__self__, "default_route", default_route)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if microfrontend_group_id and not isinstance(microfrontend_group_id, str):
            raise TypeError("Expected argument 'microfrontend_group_id' to be a str")
        pulumi.set(__self__, "microfrontend_group_id", microfrontend_group_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if route_observability_to_this_project and not isinstance(route_observability_to_this_project, bool):
            raise TypeError("Expected argument 'route_observability_to_this_project' to be a bool")
        pulumi.set(__self__, "route_observability_to_this_project", route_observability_to_this_project)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="defaultRoute")
    def default_route(self) -> str:
        """
        The default route for the project. Used for the screenshot of deployments.
        """
        return pulumi.get(self, "default_route")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="microfrontendGroupId")
    def microfrontend_group_id(self) -> str:
        """
        The ID of the microfrontend group.
        """
        return pulumi.get(self, "microfrontend_group_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="routeObservabilityToThisProject")
    def route_observability_to_this_project(self) -> bool:
        """
        Whether the project is route observability for this project. If dalse, the project will be route observability for all projects to the default project.
        """
        return pulumi.get(self, "route_observability_to_this_project")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")


class AwaitableGetMicrofrontendGroupMembershipResult(GetMicrofrontendGroupMembershipResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMicrofrontendGroupMembershipResult(
            default_route=self.default_route,
            id=self.id,
            microfrontend_group_id=self.microfrontend_group_id,
            project_id=self.project_id,
            route_observability_to_this_project=self.route_observability_to_this_project,
            team_id=self.team_id)


def get_microfrontend_group_membership(microfrontend_group_id: Optional[str] = None,
                                       project_id: Optional[str] = None,
                                       team_id: Optional[str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMicrofrontendGroupMembershipResult:
    """
    Provides information about an existing Microfrontend Group Membership.

    A Microfrontend Group Membership is a definition of a Vercel Project being a part of a Microfrontend Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_microfrontend_group_membership(project_id="prj_xxxxxxxxxxxxxxxxxxxxxxxxxxxx",
        microfrontend_group_id="mfe_xxxxxxxxxxxxxxxxxxxxxxxxxxxx")
    ```


    :param str microfrontend_group_id: The ID of the microfrontend group.
    :param str project_id: The ID of the project.
    :param str team_id: The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['microfrontendGroupId'] = microfrontend_group_id
    __args__['projectId'] = project_id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vercel:index/getMicrofrontendGroupMembership:getMicrofrontendGroupMembership', __args__, opts=opts, typ=GetMicrofrontendGroupMembershipResult).value

    return AwaitableGetMicrofrontendGroupMembershipResult(
        default_route=pulumi.get(__ret__, 'default_route'),
        id=pulumi.get(__ret__, 'id'),
        microfrontend_group_id=pulumi.get(__ret__, 'microfrontend_group_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        route_observability_to_this_project=pulumi.get(__ret__, 'route_observability_to_this_project'),
        team_id=pulumi.get(__ret__, 'team_id'))
def get_microfrontend_group_membership_output(microfrontend_group_id: Optional[pulumi.Input[str]] = None,
                                              project_id: Optional[pulumi.Input[str]] = None,
                                              team_id: Optional[pulumi.Input[Optional[str]]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMicrofrontendGroupMembershipResult]:
    """
    Provides information about an existing Microfrontend Group Membership.

    A Microfrontend Group Membership is a definition of a Vercel Project being a part of a Microfrontend Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_microfrontend_group_membership(project_id="prj_xxxxxxxxxxxxxxxxxxxxxxxxxxxx",
        microfrontend_group_id="mfe_xxxxxxxxxxxxxxxxxxxxxxxxxxxx")
    ```


    :param str microfrontend_group_id: The ID of the microfrontend group.
    :param str project_id: The ID of the project.
    :param str team_id: The team ID to add the microfrontend group to. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['microfrontendGroupId'] = microfrontend_group_id
    __args__['projectId'] = project_id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vercel:index/getMicrofrontendGroupMembership:getMicrofrontendGroupMembership', __args__, opts=opts, typ=GetMicrofrontendGroupMembershipResult)
    return __ret__.apply(lambda __response__: GetMicrofrontendGroupMembershipResult(
        default_route=pulumi.get(__response__, 'default_route'),
        id=pulumi.get(__response__, 'id'),
        microfrontend_group_id=pulumi.get(__response__, 'microfrontend_group_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        route_observability_to_this_project=pulumi.get(__response__, 'route_observability_to_this_project'),
        team_id=pulumi.get(__response__, 'team_id')))
