# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetMicrofrontendGroupResult',
    'AwaitableGetMicrofrontendGroupResult',
    'get_microfrontend_group',
    'get_microfrontend_group_output',
]

@pulumi.output_type
class GetMicrofrontendGroupResult:
    """
    A collection of values returned by getMicrofrontendGroup.
    """
    def __init__(__self__, default_app=None, id=None, name=None, slug=None, team_id=None):
        if default_app and not isinstance(default_app, dict):
            raise TypeError("Expected argument 'default_app' to be a dict")
        pulumi.set(__self__, "default_app", default_app)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if slug and not isinstance(slug, str):
            raise TypeError("Expected argument 'slug' to be a str")
        pulumi.set(__self__, "slug", slug)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="defaultApp")
    def default_app(self) -> 'outputs.GetMicrofrontendGroupDefaultAppResult':
        """
        The default app for the project. Used as the entry point for the microfrontend.
        """
        return pulumi.get(self, "default_app")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A unique identifier for the group of microfrontends. Example: mfe_12HKQaOmR5t5Uy6vdcQsNIiZgHGB
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A human readable name for the microfrontends group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def slug(self) -> str:
        """
        A slugified version of the name.
        """
        return pulumi.get(self, "slug")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        The team ID to add the project to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")


class AwaitableGetMicrofrontendGroupResult(GetMicrofrontendGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMicrofrontendGroupResult(
            default_app=self.default_app,
            id=self.id,
            name=self.name,
            slug=self.slug,
            team_id=self.team_id)


def get_microfrontend_group(id: Optional[str] = None,
                            team_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMicrofrontendGroupResult:
    """
    Provides information about an existing Microfrontend Group.

    A Microfrontend Group is a definition of a microfrontend belonging to a Vercel Team.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_microfrontend_group(id="mfe_xxxxxxxxxxxxxxxxxxxxxxxxxxxx")
    ```


    :param str id: A unique identifier for the group of microfrontends. Example: mfe_12HKQaOmR5t5Uy6vdcQsNIiZgHGB
    :param str team_id: The team ID to add the project to. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vercel:index/getMicrofrontendGroup:getMicrofrontendGroup', __args__, opts=opts, typ=GetMicrofrontendGroupResult).value

    return AwaitableGetMicrofrontendGroupResult(
        default_app=pulumi.get(__ret__, 'default_app'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        slug=pulumi.get(__ret__, 'slug'),
        team_id=pulumi.get(__ret__, 'team_id'))
def get_microfrontend_group_output(id: Optional[pulumi.Input[str]] = None,
                                   team_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMicrofrontendGroupResult]:
    """
    Provides information about an existing Microfrontend Group.

    A Microfrontend Group is a definition of a microfrontend belonging to a Vercel Team.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_microfrontend_group(id="mfe_xxxxxxxxxxxxxxxxxxxxxxxxxxxx")
    ```


    :param str id: A unique identifier for the group of microfrontends. Example: mfe_12HKQaOmR5t5Uy6vdcQsNIiZgHGB
    :param str team_id: The team ID to add the project to. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vercel:index/getMicrofrontendGroup:getMicrofrontendGroup', __args__, opts=opts, typ=GetMicrofrontendGroupResult)
    return __ret__.apply(lambda __response__: GetMicrofrontendGroupResult(
        default_app=pulumi.get(__response__, 'default_app'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        slug=pulumi.get(__response__, 'slug'),
        team_id=pulumi.get(__response__, 'team_id')))
