# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetLogDrainResult',
    'AwaitableGetLogDrainResult',
    'get_log_drain',
    'get_log_drain_output',
]

@pulumi.output_type
class GetLogDrainResult:
    """
    A collection of values returned by getLogDrain.
    """
    def __init__(__self__, delivery_format=None, endpoint=None, environments=None, headers=None, id=None, project_ids=None, sampling_rate=None, sources=None, team_id=None):
        if delivery_format and not isinstance(delivery_format, str):
            raise TypeError("Expected argument 'delivery_format' to be a str")
        pulumi.set(__self__, "delivery_format", delivery_format)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if environments and not isinstance(environments, list):
            raise TypeError("Expected argument 'environments' to be a list")
        pulumi.set(__self__, "environments", environments)
        if headers and not isinstance(headers, dict):
            raise TypeError("Expected argument 'headers' to be a dict")
        pulumi.set(__self__, "headers", headers)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_ids and not isinstance(project_ids, list):
            raise TypeError("Expected argument 'project_ids' to be a list")
        pulumi.set(__self__, "project_ids", project_ids)
        if sampling_rate and not isinstance(sampling_rate, float):
            raise TypeError("Expected argument 'sampling_rate' to be a float")
        pulumi.set(__self__, "sampling_rate", sampling_rate)
        if sources and not isinstance(sources, list):
            raise TypeError("Expected argument 'sources' to be a list")
        pulumi.set(__self__, "sources", sources)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="deliveryFormat")
    def delivery_format(self) -> str:
        """
        The format log data should be delivered in. Can be `json` or `ndjson`.
        """
        return pulumi.get(self, "delivery_format")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Logs will be sent as POST requests to this URL. The endpoint will be verified, and must return a `200` status code and an `x-vercel-verify` header taken from the endpoint_verification data source. The value the `x-vercel-verify` header should be can be read from the `vercel_endpoint_verification_code` data source.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def environments(self) -> Sequence[str]:
        """
        Logs from the selected environments will be forwarded to your webhook. At least one must be present.
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter
    def headers(self) -> Mapping[str, str]:
        """
        Custom headers to include in requests to the log drain endpoint.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Log Drain.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectIds")
    def project_ids(self) -> Sequence[str]:
        """
        A list of project IDs that the log drain should be associated with. Logs from these projects will be sent log events to the specified endpoint. If omitted, logs will be sent for all projects.
        """
        return pulumi.get(self, "project_ids")

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> float:
        """
        A ratio of logs matching the sampling rate will be sent to your log drain. Should be a value between 0 and 1. If unspecified, all logs are sent.
        """
        return pulumi.get(self, "sampling_rate")

    @property
    @pulumi.getter
    def sources(self) -> Sequence[str]:
        """
        A set of sources that the log drain should send logs for. Valid values are `static`, `edge`, `external`, `build` and `function`.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        The ID of the team the Log Drain should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")


class AwaitableGetLogDrainResult(GetLogDrainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogDrainResult(
            delivery_format=self.delivery_format,
            endpoint=self.endpoint,
            environments=self.environments,
            headers=self.headers,
            id=self.id,
            project_ids=self.project_ids,
            sampling_rate=self.sampling_rate,
            sources=self.sources,
            team_id=self.team_id)


def get_log_drain(endpoint: Optional[str] = None,
                  id: Optional[str] = None,
                  team_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogDrainResult:
    """
    Provides information about an existing Log Drain.

    Log Drains collect all of your logs using a service specializing in storing app logs.

    Teams on Pro and Enterprise plans can subscribe to log drains that are generic and configurable from the Vercel dashboard without creating an integration. This allows you to use a HTTP service to receive logs through Vercel's log drains.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_log_drain(id="lg_xxxxxxx_xxxxxx_xxxxx")
    ```


    :param str endpoint: Logs will be sent as POST requests to this URL. The endpoint will be verified, and must return a `200` status code and an `x-vercel-verify` header taken from the endpoint_verification data source. The value the `x-vercel-verify` header should be can be read from the `vercel_endpoint_verification_code` data source.
    :param str id: The ID of the Log Drain.
    :param str team_id: The ID of the team the Log Drain should exist under. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['endpoint'] = endpoint
    __args__['id'] = id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vercel:index/getLogDrain:getLogDrain', __args__, opts=opts, typ=GetLogDrainResult).value

    return AwaitableGetLogDrainResult(
        delivery_format=pulumi.get(__ret__, 'delivery_format'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        environments=pulumi.get(__ret__, 'environments'),
        headers=pulumi.get(__ret__, 'headers'),
        id=pulumi.get(__ret__, 'id'),
        project_ids=pulumi.get(__ret__, 'project_ids'),
        sampling_rate=pulumi.get(__ret__, 'sampling_rate'),
        sources=pulumi.get(__ret__, 'sources'),
        team_id=pulumi.get(__ret__, 'team_id'))
def get_log_drain_output(endpoint: Optional[pulumi.Input[str]] = None,
                         id: Optional[pulumi.Input[str]] = None,
                         team_id: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLogDrainResult]:
    """
    Provides information about an existing Log Drain.

    Log Drains collect all of your logs using a service specializing in storing app logs.

    Teams on Pro and Enterprise plans can subscribe to log drains that are generic and configurable from the Vercel dashboard without creating an integration. This allows you to use a HTTP service to receive logs through Vercel's log drains.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_log_drain(id="lg_xxxxxxx_xxxxxx_xxxxx")
    ```


    :param str endpoint: Logs will be sent as POST requests to this URL. The endpoint will be verified, and must return a `200` status code and an `x-vercel-verify` header taken from the endpoint_verification data source. The value the `x-vercel-verify` header should be can be read from the `vercel_endpoint_verification_code` data source.
    :param str id: The ID of the Log Drain.
    :param str team_id: The ID of the team the Log Drain should exist under. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['endpoint'] = endpoint
    __args__['id'] = id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vercel:index/getLogDrain:getLogDrain', __args__, opts=opts, typ=GetLogDrainResult)
    return __ret__.apply(lambda __response__: GetLogDrainResult(
        delivery_format=pulumi.get(__response__, 'delivery_format'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        environments=pulumi.get(__response__, 'environments'),
        headers=pulumi.get(__response__, 'headers'),
        id=pulumi.get(__response__, 'id'),
        project_ids=pulumi.get(__response__, 'project_ids'),
        sampling_rate=pulumi.get(__response__, 'sampling_rate'),
        sources=pulumi.get(__response__, 'sources'),
        team_id=pulumi.get(__response__, 'team_id')))
